/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.ConditionFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.Type;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final CollectionPersister collectionPersister;
    private final Type idType;

    public CollectionLoader(CollectionPersister persister, SessionFactoryImplementor session) throws MappingException {
        super(session.getDialect());
        this.idType = persister.getKeyType();
        String alias = OuterJoinLoader.alias(persister.getQualifiedTableName(), 0);
        String whereString = "";
        if (persister.hasWhere()) {
            whereString = " and " + persister.getSQLWhereString(alias);
        }
        List associations = this.walkCollectionTree(persister, alias, session);
        int joins = associations.size();
        this.suffixes = new String[joins];
        int i = 0;
        while (i < joins) {
            this.suffixes[i] = Integer.toString(i) + '_';
            ++i;
        }
        JoinFragment ojf = this.outerJoins(associations);
        Select select = new Select().setSelectClause(persister.selectClauseFragment(alias) + (joins == 0 ? "" : ", " + this.selectString(associations))).setFromClause(persister.getQualifiedTableName(), alias).setWhereClause(new ConditionFragment().setTableAlias(alias).setCondition(persister.getKeyColumnNames(), "?").toFragmentString() + whereString).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        if (persister.hasOrdering()) {
            select.setOrderByClause(persister.getSQLOrderByString(alias));
        }
        this.sql = select.toStatementString();
        this.classPersisters = new Loadable[joins];
        this.lockModeArray = this.createLockModeArray(joins, LockMode.NONE);
        int i2 = 0;
        while (i2 < joins) {
            this.classPersisters[i2] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i2)).subpersister;
            ++i2;
        }
        this.collectionPersister = persister;
        this.postInstantiate();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, PersistentCollection collection, Object owner, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, id, this.idType, owner, collection);
    }
}

