# Structuring a repo for docs


## Root level of the repo

- ``docs`` directory : All source files for documentation go here.
- ``readthedocs.yml`` : configuration file for readthedocs to build using
  conda

![The root level of the jupyter kernel_gateway repo. There are orange boxes surrounding two elements in the directory structure: the docs folder and the readthedocs.yml file. The docs folder is the first element in the directory. The readthedocs.yml file is the 12th item in the directory.](static/repo-root.png)

## Inside the docs directory

- ``source`` directory : contains all content source files in ``.rst``,
  ``.md``, or ``.ipynb``
- ``makefile`` : used by Sphinx to build the docs
- ``environment.yml`` : conda build instructions

![The docs directory in the jupyter kernel_gateway repo (path: jupyter/kernel_gateway/docs). The first two elements in the directory are folders that have blue boxes surrounding them: `_static` and `source`.  The third and forth elements in the directory are files with orange boxes surrounding them: `Makefile` and `environment.yml`. There are two more files in the directory, which have no visual emphasis.](static/docs-directory.png)


## Sphinx

- ``conf.py`` : Sphinx configuration file
- ``index.rst`` of ``contents.rst`` : Sphinx master table of contents file
- ``_static`` directory : contains images, drawings, icons
- ``_templates`` directory: overrides theme templates and layouts
- ``build`` directory : html files generated by Sphinx (do not check this
  directory into GitHub)