/* gpx-parser.c generated by valac 0.20.1, the Vala compiler
 * generated from gpx-parser.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2011 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "gpx.h"
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
typedef struct _GpxParamSpecPoint GpxParamSpecPoint;
#define __g_list_free__gpx_point_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gpx_point_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GpxPointPrivate {
	gchar* _name;
	time_t utime;
};

struct _GpxParamSpecPoint {
	GParamSpec parent_instance;
};

struct _GpxTrackPrivate {
	gchar* _name;
	GpxPoint* last;
};


static gpointer gpx_point_parent_class = NULL;
static gpointer gpx_track_parent_class = NULL;
static gpointer gpx_file_base_parent_class = NULL;

#define GPX_POINT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GPX_TYPE_POINT, GpxPointPrivate))
enum  {
	GPX_POINT_DUMMY_PROPERTY
};
static void gpx_point_finalize (GpxPoint* obj);
#define GPX_TRACK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GPX_TYPE_TRACK, GpxTrackPrivate))
enum  {
	GPX_TRACK_DUMMY_PROPERTY,
	GPX_TRACK_NAME
};
static void _gpx_point_unref0_ (gpointer var);
static void _g_list_free__gpx_point_unref0_ (GList* self);
static void gpx_track_finalize (GObject* obj);
static void _vala_gpx_track_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gpx_track_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	GPX_FILE_BASE_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void gpx_file_base_finalize (GObject* obj);


GpxHeartRateMonitorPoint* gpx_heart_rate_monitor_point_dup (const GpxHeartRateMonitorPoint* self) {
	GpxHeartRateMonitorPoint* dup;
	dup = g_new0 (GpxHeartRateMonitorPoint, 1);
	memcpy (dup, self, sizeof (GpxHeartRateMonitorPoint));
	return dup;
}


void gpx_heart_rate_monitor_point_free (GpxHeartRateMonitorPoint* self) {
	g_free (self);
}


GType gpx_heart_rate_monitor_point_get_type (void) {
	static volatile gsize gpx_heart_rate_monitor_point_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_heart_rate_monitor_point_type_id__volatile)) {
		GType gpx_heart_rate_monitor_point_type_id;
		gpx_heart_rate_monitor_point_type_id = g_boxed_type_register_static ("GpxHeartRateMonitorPoint", (GBoxedCopyFunc) gpx_heart_rate_monitor_point_dup, (GBoxedFreeFunc) gpx_heart_rate_monitor_point_free);
		g_once_init_leave (&gpx_heart_rate_monitor_point_type_id__volatile, gpx_heart_rate_monitor_point_type_id);
	}
	return gpx_heart_rate_monitor_point_type_id__volatile;
}


GpxHeartRateMonitorTrack* gpx_heart_rate_monitor_track_dup (const GpxHeartRateMonitorTrack* self) {
	GpxHeartRateMonitorTrack* dup;
	dup = g_new0 (GpxHeartRateMonitorTrack, 1);
	memcpy (dup, self, sizeof (GpxHeartRateMonitorTrack));
	return dup;
}


void gpx_heart_rate_monitor_track_free (GpxHeartRateMonitorTrack* self) {
	g_free (self);
}


GType gpx_heart_rate_monitor_track_get_type (void) {
	static volatile gsize gpx_heart_rate_monitor_track_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_heart_rate_monitor_track_type_id__volatile)) {
		GType gpx_heart_rate_monitor_track_type_id;
		gpx_heart_rate_monitor_track_type_id = g_boxed_type_register_static ("GpxHeartRateMonitorTrack", (GBoxedCopyFunc) gpx_heart_rate_monitor_track_dup, (GBoxedFreeFunc) gpx_heart_rate_monitor_track_free);
		g_once_init_leave (&gpx_heart_rate_monitor_track_type_id__volatile, gpx_heart_rate_monitor_track_type_id);
	}
	return gpx_heart_rate_monitor_track_type_id__volatile;
}


gboolean gpx_point_has_position (GpxPoint* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->lat;
	if (_tmp1_ == ((gdouble) 1000)) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp2_;
		_tmp2_ = self->lon;
		_tmp0_ = _tmp2_ == ((gdouble) 1000);
	}
	_tmp3_ = _tmp0_;
	result = !_tmp3_;
	return result;
}


/**
         * Make a clean copy off the point.
         * Only position and time is copied.
         */
GpxPoint* gpx_point_copy (GpxPoint* self) {
	GpxPoint* result = NULL;
	GpxPoint* _tmp0_;
	GpxPoint* p;
	const gchar* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	GpxHeartRateMonitorPoint _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gpx_point_new ();
	p = _tmp0_;
	_tmp1_ = self->priv->_name;
	gpx_point_set_name (p, _tmp1_);
	_tmp2_ = self->lat;
	p->lat = _tmp2_;
	_tmp3_ = self->lon;
	p->lon = _tmp3_;
	_tmp4_ = self->lat_dec;
	p->lat_dec = _tmp4_;
	_tmp5_ = self->lon_dec;
	p->lon_dec = _tmp5_;
	_tmp6_ = self->time;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (p->time);
	p->time = _tmp7_;
	_tmp8_ = self->elevation;
	p->elevation = _tmp8_;
	_tmp9_ = self->smooth_elevation;
	p->smooth_elevation = _tmp9_;
	_tmp10_ = self->tpe;
	p->tpe = _tmp10_;
	result = p;
	return result;
}


void gpx_point_set_position_lat (GpxPoint* self, gdouble lat_d) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lat_d;
	self->lat_dec = _tmp0_;
	_tmp1_ = lat_d;
	self->lat = ((2 * G_PI) * _tmp1_) / 360.0;
}


void gpx_point_set_position_lon (GpxPoint* self, gdouble lon_d) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lon_d;
	self->lon_dec = _tmp0_;
	_tmp1_ = lon_d;
	self->lon = ((2 * G_PI) * _tmp1_) / 360.0;
}


void gpx_point_set_position (GpxPoint* self, gdouble lat, gdouble lon) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lat;
	self->lat_dec = _tmp0_;
	_tmp1_ = lon;
	self->lon_dec = _tmp1_;
	_tmp2_ = lat;
	self->lat = ((2 * G_PI) * _tmp2_) / 360.0;
	_tmp3_ = lon;
	self->lon = ((2 * G_PI) * _tmp3_) / 360.0;
}


time_t gpx_point_get_time (GpxPoint* self) {
	time_t result = 0;
	const gchar* _tmp0_;
	time_t _tmp1_;
	struct tm ta = {0};
	const gchar* _tmp3_;
	time_t _tmp4_ = 0;
	time_t _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->time;
	if (_tmp0_ == NULL) {
		result = (time_t) 0;
		return result;
	}
	_tmp1_ = self->priv->utime;
	if (_tmp1_ > ((time_t) 0)) {
		time_t _tmp2_;
		_tmp2_ = self->priv->utime;
		result = _tmp2_;
		return result;
	}
	memset (&ta, 0, sizeof (struct tm));
	_tmp3_ = self->time;
	strptime (_tmp3_, "%FT%T%z", &ta);
	_tmp4_ = mktime (&ta);
	self->priv->utime = _tmp4_;
	_tmp5_ = self->priv->utime;
	result = _tmp5_;
	return result;
}


GpxPoint* gpx_point_construct (GType object_type) {
	GpxPoint* self = NULL;
	self = (GpxPoint*) g_type_create_instance (object_type);
	return self;
}


GpxPoint* gpx_point_new (void) {
	return gpx_point_construct (GPX_TYPE_POINT);
}


const gchar* gpx_point_get_name (GpxPoint* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void gpx_point_set_name (GpxPoint* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


static void gpx_value_point_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gpx_value_point_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gpx_point_unref (value->data[0].v_pointer);
	}
}


static void gpx_value_point_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gpx_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gpx_value_point_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gpx_value_point_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GpxPoint* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gpx_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gpx_value_point_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GpxPoint** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gpx_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gpx_param_spec_point (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GpxParamSpecPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GPX_TYPE_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gpx_value_get_point (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPX_TYPE_POINT), NULL);
	return value->data[0].v_pointer;
}


void gpx_value_set_point (GValue* value, gpointer v_object) {
	GpxPoint* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPX_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GPX_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gpx_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gpx_point_unref (old);
	}
}


void gpx_value_take_point (GValue* value, gpointer v_object) {
	GpxPoint* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPX_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GPX_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gpx_point_unref (old);
	}
}


static void gpx_point_class_init (GpxPointClass * klass) {
	gpx_point_parent_class = g_type_class_peek_parent (klass);
	GPX_POINT_CLASS (klass)->finalize = gpx_point_finalize;
	g_type_class_add_private (klass, sizeof (GpxPointPrivate));
}


static void gpx_point_instance_init (GpxPoint * self) {
	GpxHeartRateMonitorPoint _tmp0_ = {0};
	self->priv = GPX_POINT_GET_PRIVATE (self);
	self->priv->_name = NULL;
	self->lat = (gdouble) 1000;
	self->lon = (gdouble) 1000;
	self->lat_dec = (gdouble) 1000;
	self->lon_dec = (gdouble) 1000;
	self->distance = (gdouble) 0;
	self->speed = (gdouble) 0;
	self->stopped = FALSE;
	self->priv->utime = (time_t) 0;
	memset (&_tmp0_, 0, sizeof (GpxHeartRateMonitorPoint));
	_tmp0_.heartrate = 0;
	self->tpe = _tmp0_;
	self->ref_count = 1;
}


static void gpx_point_finalize (GpxPoint* obj) {
	GpxPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_POINT, GpxPoint);
	_g_free0 (self->priv->_name);
	_g_free0 (self->time);
}


/**
     * Represents a point in the track or a waypoint.
     */
GType gpx_point_get_type (void) {
	static volatile gsize gpx_point_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_point_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gpx_value_point_init, gpx_value_point_free_value, gpx_value_point_copy_value, gpx_value_point_peek_pointer, "p", gpx_value_point_collect_value, "p", gpx_value_point_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GpxPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxPoint), 0, (GInstanceInitFunc) gpx_point_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gpx_point_type_id;
		gpx_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GpxPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gpx_point_type_id__volatile, gpx_point_type_id);
	}
	return gpx_point_type_id__volatile;
}


gpointer gpx_point_ref (gpointer instance) {
	GpxPoint* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gpx_point_unref (gpointer instance) {
	GpxPoint* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GPX_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _gpx_point_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL));
}


static void _g_list_free__gpx_point_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gpx_point_unref0_, NULL);
	g_list_free (self);
}


GpxPoint* gpx_track_get_last (GpxTrack* self) {
	GpxPoint* result = NULL;
	GpxPoint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->last;
	result = _tmp0_;
	return result;
}


/** This function will try to remove useless points */
void gpx_track_filter_points (GpxTrack* self) {
	GList* a;
	GList* b;
	GList* c;
	gdouble _tmp0_ = 0.0;
	gdouble davg;
	gdouble _tmp125_ = 0.0;
	gdouble avg;
	gdouble _tmp126_ = 0.0;
	gdouble _tmp127_;
	gdouble _tmp129_;
	gint _tmp151_;
	g_return_if_fail (self != NULL);
	a = NULL;
	b = NULL;
	c = NULL;
	_tmp0_ = gpx_track_get_track_average (self);
	davg = _tmp0_;
	{
		GList* _tmp1_;
		GList* _tmp2_ = NULL;
		GList* iter;
		_tmp1_ = self->points;
		_tmp2_ = g_list_first (_tmp1_);
		iter = _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				GList* _tmp7_;
				GList* _tmp8_;
				GList* _tmp10_;
				GList* _tmp12_;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				GList* _tmp15_;
				gboolean _tmp17_;
				gboolean _tmp19_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					GList* _tmp5_;
					GList* _tmp6_;
					_tmp5_ = iter;
					_tmp6_ = _tmp5_->next;
					iter = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = iter;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = b;
				if (_tmp8_ != NULL) {
					GList* _tmp9_;
					_tmp9_ = b;
					c = _tmp9_;
				}
				_tmp10_ = a;
				if (_tmp10_ != NULL) {
					GList* _tmp11_;
					_tmp11_ = a;
					b = _tmp11_;
				}
				_tmp12_ = iter;
				a = _tmp12_;
				_tmp15_ = a;
				if (_tmp15_ != NULL) {
					GList* _tmp16_;
					_tmp16_ = b;
					_tmp14_ = _tmp16_ != NULL;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp17_ = _tmp14_;
				if (_tmp17_) {
					GList* _tmp18_;
					_tmp18_ = c;
					_tmp13_ = _tmp18_ != NULL;
				} else {
					_tmp13_ = FALSE;
				}
				_tmp19_ = _tmp13_;
				if (_tmp19_) {
					GList* _tmp20_;
					gconstpointer _tmp21_;
					time_t _tmp22_ = 0;
					GList* _tmp23_;
					gconstpointer _tmp24_;
					time_t _tmp25_ = 0;
					gdouble elapsed_ca;
					GList* _tmp26_;
					gconstpointer _tmp27_;
					time_t _tmp28_ = 0;
					GList* _tmp29_;
					gconstpointer _tmp30_;
					time_t _tmp31_ = 0;
					gdouble elapsed_cb;
					GList* _tmp32_;
					gconstpointer _tmp33_;
					gdouble _tmp34_;
					GList* _tmp35_;
					gconstpointer _tmp36_;
					gdouble _tmp37_;
					gdouble _tmp38_;
					gdouble lat_rico_ca;
					GList* _tmp39_;
					gconstpointer _tmp40_;
					gdouble _tmp41_;
					GList* _tmp42_;
					gconstpointer _tmp43_;
					gdouble _tmp44_;
					gdouble _tmp45_;
					gdouble lon_rico_ca;
					GList* _tmp46_;
					gconstpointer _tmp47_;
					gdouble _tmp48_;
					GList* _tmp49_;
					gconstpointer _tmp50_;
					gdouble _tmp51_;
					gdouble _tmp52_;
					gdouble lat_rico_cb;
					GList* _tmp53_;
					gconstpointer _tmp54_;
					gdouble _tmp55_;
					GList* _tmp56_;
					gconstpointer _tmp57_;
					gdouble _tmp58_;
					gdouble _tmp59_;
					gdouble lon_rico_cb;
					GList* _tmp60_;
					gconstpointer _tmp61_;
					gdouble _tmp62_;
					GList* _tmp63_;
					gconstpointer _tmp64_;
					gdouble _tmp65_;
					gdouble _tmp66_;
					gdouble elv_rico_ca;
					GList* _tmp67_;
					gconstpointer _tmp68_;
					gdouble _tmp69_;
					GList* _tmp70_;
					gconstpointer _tmp71_;
					gdouble _tmp72_;
					gdouble _tmp73_;
					gdouble elv_rico_cb;
					gdouble _tmp74_;
					gdouble _tmp75_;
					gdouble _tmp76_ = 0.0;
					gdouble l;
					gdouble _tmp77_;
					gdouble _tmp78_;
					gdouble _tmp79_ = 0.0;
					gdouble m;
					gdouble _tmp80_;
					gdouble _tmp81_;
					gdouble _tmp82_ = 0.0;
					gdouble e;
					GList* _tmp83_;
					gconstpointer _tmp84_;
					gdouble _tmp85_;
					GList* _tmp86_;
					gconstpointer _tmp87_;
					gdouble _tmp88_;
					gdouble _tmp89_ = 0.0;
					GList* _tmp90_;
					gconstpointer _tmp91_;
					gdouble _tmp92_;
					GList* _tmp93_;
					gconstpointer _tmp94_;
					gdouble _tmp95_;
					gdouble _tmp96_ = 0.0;
					gdouble abs_diff;
					GList* _tmp97_;
					gconstpointer _tmp98_;
					gdouble _tmp99_;
					GList* _tmp100_;
					gconstpointer _tmp101_;
					gdouble _tmp102_;
					GList* _tmp103_;
					gconstpointer _tmp104_;
					gdouble _tmp105_;
					GList* _tmp106_;
					gconstpointer _tmp107_;
					gdouble _tmp108_;
					gdouble _tmp109_ = 0.0;
					gdouble diff;
					gboolean _tmp110_ = FALSE;
					gdouble _tmp111_;
					gdouble _tmp112_;
					gboolean _tmp115_;
					_tmp20_ = a;
					_tmp21_ = _tmp20_->data;
					_tmp22_ = gpx_point_get_time ((GpxPoint*) _tmp21_);
					_tmp23_ = c;
					_tmp24_ = _tmp23_->data;
					_tmp25_ = gpx_point_get_time ((GpxPoint*) _tmp24_);
					elapsed_ca = (gdouble) (_tmp22_ - _tmp25_);
					_tmp26_ = a;
					_tmp27_ = _tmp26_->data;
					_tmp28_ = gpx_point_get_time ((GpxPoint*) _tmp27_);
					_tmp29_ = b;
					_tmp30_ = _tmp29_->data;
					_tmp31_ = gpx_point_get_time ((GpxPoint*) _tmp30_);
					elapsed_cb = (gdouble) (_tmp28_ - _tmp31_);
					_tmp32_ = a;
					_tmp33_ = _tmp32_->data;
					_tmp34_ = ((GpxPoint*) _tmp33_)->lat_dec;
					_tmp35_ = c;
					_tmp36_ = _tmp35_->data;
					_tmp37_ = ((GpxPoint*) _tmp36_)->lat_dec;
					_tmp38_ = elapsed_ca;
					lat_rico_ca = (_tmp34_ - _tmp37_) / ((gdouble) _tmp38_);
					_tmp39_ = a;
					_tmp40_ = _tmp39_->data;
					_tmp41_ = ((GpxPoint*) _tmp40_)->lon_dec;
					_tmp42_ = c;
					_tmp43_ = _tmp42_->data;
					_tmp44_ = ((GpxPoint*) _tmp43_)->lon_dec;
					_tmp45_ = elapsed_ca;
					lon_rico_ca = (_tmp41_ - _tmp44_) / ((gdouble) _tmp45_);
					_tmp46_ = b;
					_tmp47_ = _tmp46_->data;
					_tmp48_ = ((GpxPoint*) _tmp47_)->lat_dec;
					_tmp49_ = c;
					_tmp50_ = _tmp49_->data;
					_tmp51_ = ((GpxPoint*) _tmp50_)->lat_dec;
					_tmp52_ = elapsed_cb;
					lat_rico_cb = (_tmp48_ - _tmp51_) / ((gdouble) _tmp52_);
					_tmp53_ = b;
					_tmp54_ = _tmp53_->data;
					_tmp55_ = ((GpxPoint*) _tmp54_)->lon_dec;
					_tmp56_ = c;
					_tmp57_ = _tmp56_->data;
					_tmp58_ = ((GpxPoint*) _tmp57_)->lon_dec;
					_tmp59_ = elapsed_cb;
					lon_rico_cb = (_tmp55_ - _tmp58_) / ((gdouble) _tmp59_);
					_tmp60_ = a;
					_tmp61_ = _tmp60_->data;
					_tmp62_ = ((GpxPoint*) _tmp61_)->elevation;
					_tmp63_ = c;
					_tmp64_ = _tmp63_->data;
					_tmp65_ = ((GpxPoint*) _tmp64_)->elevation;
					_tmp66_ = elapsed_ca;
					elv_rico_ca = (_tmp62_ - _tmp65_) / ((gdouble) _tmp66_);
					_tmp67_ = a;
					_tmp68_ = _tmp67_->data;
					_tmp69_ = ((GpxPoint*) _tmp68_)->elevation;
					_tmp70_ = b;
					_tmp71_ = _tmp70_->data;
					_tmp72_ = ((GpxPoint*) _tmp71_)->elevation;
					_tmp73_ = elapsed_cb;
					elv_rico_cb = (_tmp69_ - _tmp72_) / ((gdouble) _tmp73_);
					_tmp74_ = lat_rico_ca;
					_tmp75_ = lat_rico_cb;
					_tmp76_ = fabs (1.0 - (_tmp74_ / _tmp75_));
					l = _tmp76_;
					_tmp77_ = lon_rico_ca;
					_tmp78_ = lon_rico_cb;
					_tmp79_ = fabs (1.0 - (_tmp77_ / _tmp78_));
					m = _tmp79_;
					_tmp80_ = elv_rico_ca;
					_tmp81_ = elv_rico_cb;
					_tmp82_ = fabs (1.0 - (_tmp80_ / _tmp81_));
					e = _tmp82_;
					_tmp83_ = b;
					_tmp84_ = _tmp83_->data;
					_tmp85_ = ((GpxPoint*) _tmp84_)->speed;
					_tmp86_ = a;
					_tmp87_ = _tmp86_->data;
					_tmp88_ = ((GpxPoint*) _tmp87_)->speed;
					_tmp89_ = fabs (_tmp85_ - _tmp88_);
					_tmp90_ = c;
					_tmp91_ = _tmp90_->data;
					_tmp92_ = ((GpxPoint*) _tmp91_)->speed;
					_tmp93_ = b;
					_tmp94_ = _tmp93_->data;
					_tmp95_ = ((GpxPoint*) _tmp94_)->speed;
					_tmp96_ = fabs (_tmp92_ - _tmp95_);
					abs_diff = _tmp89_ + _tmp96_;
					_tmp97_ = b;
					_tmp98_ = _tmp97_->data;
					_tmp99_ = ((GpxPoint*) _tmp98_)->speed;
					_tmp100_ = a;
					_tmp101_ = _tmp100_->data;
					_tmp102_ = ((GpxPoint*) _tmp101_)->speed;
					_tmp103_ = c;
					_tmp104_ = _tmp103_->data;
					_tmp105_ = ((GpxPoint*) _tmp104_)->speed;
					_tmp106_ = b;
					_tmp107_ = _tmp106_->data;
					_tmp108_ = ((GpxPoint*) _tmp107_)->speed;
					_tmp109_ = fabs ((_tmp99_ - _tmp102_) + (_tmp105_ - _tmp108_));
					diff = _tmp109_;
					_tmp111_ = diff;
					_tmp112_ = abs_diff;
					if (_tmp111_ < (0.2 * _tmp112_)) {
						gdouble _tmp113_;
						gdouble _tmp114_;
						_tmp113_ = abs_diff;
						_tmp114_ = davg;
						_tmp110_ = _tmp113_ > (3 * _tmp114_);
					} else {
						_tmp110_ = FALSE;
					}
					_tmp115_ = _tmp110_;
					if (_tmp115_) {
						FILE* _tmp116_;
						gdouble _tmp117_;
						gdouble _tmp118_;
						GList* _tmp119_;
						_tmp116_ = stdout;
						_tmp117_ = diff;
						_tmp118_ = abs_diff;
						fprintf (_tmp116_, "----- %f %f filter points\n", _tmp117_, _tmp118_);
						_tmp119_ = b;
						self->points = g_list_remove_link (self->points, _tmp119_);
					} else {
						gdouble _tmp120_;
						_tmp120_ = l;
						if (_tmp120_ <= 0.2) {
							gdouble _tmp121_;
							_tmp121_ = m;
							if (_tmp121_ <= 0.2) {
								GList* _tmp122_;
								gint _tmp123_;
								GList* _tmp124_;
								_tmp122_ = b;
								self->points = g_list_remove_link (self->points, _tmp122_);
								_tmp123_ = self->filtered_points;
								self->filtered_points = _tmp123_ + 1;
								_tmp124_ = c;
								b = _tmp124_;
							}
						}
					}
				}
			}
		}
	}
	gpx_track_recalculate (self);
	_tmp125_ = gpx_track_get_track_average (self);
	avg = _tmp125_ / 20;
	_tmp127_ = avg;
	if (_tmp127_ > ((gdouble) 2)) {
		_tmp126_ = (gdouble) 2;
	} else {
		gdouble _tmp128_;
		_tmp128_ = avg;
		_tmp126_ = _tmp128_;
	}
	_tmp129_ = _tmp126_;
	avg = _tmp129_;
	{
		GList* _tmp130_;
		GList* _tmp131_ = NULL;
		GList* iter;
		_tmp130_ = self->points;
		_tmp131_ = g_list_first (_tmp130_);
		iter = _tmp131_;
		{
			gboolean _tmp132_;
			_tmp132_ = TRUE;
			while (TRUE) {
				gboolean _tmp133_;
				GList* _tmp136_;
				GList* _tmp137_;
				gconstpointer _tmp138_;
				GpxPoint* p;
				gboolean _tmp139_ = FALSE;
				gboolean _tmp140_ = FALSE;
				GpxPoint* _tmp141_;
				gdouble _tmp142_;
				gboolean _tmp146_;
				gboolean _tmp149_;
				_tmp133_ = _tmp132_;
				if (!_tmp133_) {
					GList* _tmp134_;
					GList* _tmp135_;
					_tmp134_ = iter;
					_tmp135_ = _tmp134_->next;
					iter = _tmp135_;
				}
				_tmp132_ = FALSE;
				_tmp136_ = iter;
				if (!(_tmp136_ != NULL)) {
					break;
				}
				_tmp137_ = iter;
				_tmp138_ = _tmp137_->data;
				p = (GpxPoint*) _tmp138_;
				_tmp141_ = p;
				_tmp142_ = _tmp141_->distance;
				if (_tmp142_ < 0.01) {
					_tmp140_ = TRUE;
				} else {
					GpxPoint* _tmp143_;
					gdouble _tmp144_;
					gdouble _tmp145_;
					_tmp143_ = p;
					_tmp144_ = _tmp143_->speed;
					_tmp145_ = avg;
					_tmp140_ = _tmp144_ < _tmp145_;
				}
				_tmp146_ = _tmp140_;
				if (_tmp146_) {
					_tmp139_ = TRUE;
				} else {
					GpxPoint* _tmp147_;
					gboolean _tmp148_ = FALSE;
					_tmp147_ = p;
					_tmp148_ = gpx_point_has_position (_tmp147_);
					_tmp139_ = !_tmp148_;
				}
				_tmp149_ = _tmp139_;
				if (_tmp149_) {
					GpxPoint* _tmp150_;
					_tmp150_ = p;
					_tmp150_->stopped = TRUE;
				}
			}
		}
	}
	_tmp151_ = self->filtered_points;
	g_debug ("gpx-parser.vala:219: Removed %i points", _tmp151_);
}


/**
 * This will recalculates all speeds and distances. Call this when the list was modified.
 */
void gpx_track_recalculate (GpxTrack* self) {
	GList* last;
	g_return_if_fail (self != NULL);
	last = NULL;
	self->total_distance = (gdouble) 0;
	self->max_speed = (gdouble) 0;
	self->max_elevation = 0.0;
	self->min_elevation = 0.0;
	{
		GList* _tmp0_;
		GList* _tmp1_ = NULL;
		GList* iter;
		_tmp0_ = self->points;
		_tmp1_ = g_list_first (_tmp0_);
		iter = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				GList* _tmp6_;
				GList* _tmp7_;
				gconstpointer _tmp8_;
				GpxPoint* point;
				GList* _tmp9_;
				gdouble radius;
				GpxPoint* _tmp50_;
				gdouble _tmp51_;
				gdouble _tmp52_;
				gdouble elevation_value;
				gdouble _tmp53_;
				gdouble weights;
				GList* _tmp54_;
				GList* env_iter;
				gint i;
				GList* _tmp74_;
				GpxPoint* _tmp94_;
				gdouble _tmp95_;
				gdouble _tmp96_;
				GpxPoint* _tmp97_;
				gboolean _tmp98_ = FALSE;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					GList* _tmp4_;
					GList* _tmp5_;
					_tmp4_ = iter;
					_tmp5_ = _tmp4_->next;
					iter = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = iter;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = iter;
				_tmp8_ = _tmp7_->data;
				point = (GpxPoint*) _tmp8_;
				_tmp9_ = last;
				if (_tmp9_ != NULL) {
					GpxPoint* _tmp10_;
					gboolean _tmp11_ = FALSE;
					_tmp10_ = point;
					_tmp11_ = gpx_point_has_position (_tmp10_);
					if (_tmp11_) {
						gdouble _tmp12_;
						GList* _tmp13_;
						gconstpointer _tmp14_;
						GpxPoint* _tmp15_;
						gdouble _tmp16_ = 0.0;
						GpxPoint* _tmp17_;
						gdouble _tmp18_;
						GpxPoint* _tmp19_;
						GList* _tmp20_;
						gconstpointer _tmp21_;
						GpxPoint* _tmp22_;
						gdouble _tmp23_ = 0.0;
						GpxPoint* _tmp24_;
						gdouble _tmp25_;
						gdouble _tmp26_;
						GpxPoint* _tmp29_;
						gdouble _tmp30_;
						gdouble _tmp31_;
						GpxPoint* _tmp34_;
						gdouble _tmp35_;
						gdouble _tmp36_;
						_tmp12_ = self->total_distance;
						_tmp13_ = last;
						_tmp14_ = _tmp13_->data;
						_tmp15_ = point;
						_tmp16_ = gpx_track_calculate_distance ((GpxPoint*) _tmp14_, _tmp15_);
						self->total_distance = _tmp12_ + _tmp16_;
						_tmp17_ = point;
						_tmp18_ = self->total_distance;
						_tmp17_->distance = _tmp18_;
						_tmp19_ = point;
						_tmp20_ = last;
						_tmp21_ = _tmp20_->data;
						_tmp22_ = point;
						_tmp23_ = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp21_, _tmp22_);
						_tmp19_->speed = _tmp23_;
						_tmp24_ = point;
						_tmp25_ = _tmp24_->elevation;
						_tmp26_ = self->max_elevation;
						if (_tmp25_ > _tmp26_) {
							GpxPoint* _tmp27_;
							gdouble _tmp28_;
							_tmp27_ = point;
							_tmp28_ = _tmp27_->elevation;
							self->max_elevation = _tmp28_;
						}
						_tmp29_ = point;
						_tmp30_ = _tmp29_->elevation;
						_tmp31_ = self->min_elevation;
						if (_tmp30_ < _tmp31_) {
							GpxPoint* _tmp32_;
							gdouble _tmp33_;
							_tmp32_ = point;
							_tmp33_ = _tmp32_->elevation;
							self->min_elevation = _tmp33_;
						}
						_tmp34_ = point;
						_tmp35_ = _tmp34_->speed;
						_tmp36_ = self->max_speed;
						if (_tmp35_ > _tmp36_) {
							GpxPoint* _tmp37_;
							gdouble _tmp38_;
							_tmp37_ = point;
							_tmp38_ = _tmp37_->speed;
							self->max_speed = _tmp38_;
						}
					}
				} else {
					GpxPoint* _tmp39_;
					gdouble _tmp40_;
					gdouble _tmp41_;
					GpxPoint* _tmp44_;
					gdouble _tmp45_;
					gdouble _tmp46_;
					GpxPoint* _tmp49_;
					_tmp39_ = point;
					_tmp40_ = _tmp39_->elevation;
					_tmp41_ = self->max_elevation;
					if (_tmp40_ > _tmp41_) {
						GpxPoint* _tmp42_;
						gdouble _tmp43_;
						_tmp42_ = point;
						_tmp43_ = _tmp42_->elevation;
						self->max_elevation = _tmp43_;
					}
					_tmp44_ = point;
					_tmp45_ = _tmp44_->elevation;
					_tmp46_ = self->min_elevation;
					if (_tmp45_ < _tmp46_) {
						GpxPoint* _tmp47_;
						gdouble _tmp48_;
						_tmp47_ = point;
						_tmp48_ = _tmp47_->elevation;
						self->min_elevation = _tmp48_;
					}
					_tmp49_ = point;
					_tmp49_->distance = (gdouble) 0;
				}
				radius = 0.2;
				_tmp50_ = point;
				_tmp51_ = _tmp50_->elevation;
				_tmp52_ = radius;
				elevation_value = _tmp51_ * _tmp52_;
				_tmp53_ = radius;
				weights = _tmp53_;
				_tmp54_ = iter;
				env_iter = _tmp54_;
				i = 0;
				while (TRUE) {
					GList* _tmp55_;
					GList* _tmp56_;
					GList* _tmp57_;
					gint _tmp58_;
					GList* _tmp59_;
					gconstpointer _tmp60_;
					GpxPoint* _tmp61_;
					gdouble _tmp62_ = 0.0;
					gdouble mydist;
					gdouble _tmp63_;
					gdouble _tmp64_;
					_tmp55_ = env_iter;
					_tmp56_ = _tmp55_->prev;
					env_iter = _tmp56_;
					_tmp57_ = env_iter;
					if (!(_tmp57_ != NULL)) {
						break;
					}
					_tmp58_ = i;
					i = _tmp58_ + 1;
					_tmp59_ = env_iter;
					_tmp60_ = _tmp59_->data;
					_tmp61_ = point;
					_tmp62_ = gpx_track_calculate_distance ((GpxPoint*) _tmp60_, _tmp61_);
					mydist = _tmp62_;
					_tmp63_ = mydist;
					_tmp64_ = radius;
					if (_tmp63_ < _tmp64_) {
						gdouble _tmp65_;
						GList* _tmp66_;
						gconstpointer _tmp67_;
						gdouble _tmp68_;
						gdouble _tmp69_;
						gdouble _tmp70_;
						gdouble _tmp71_;
						gdouble _tmp72_;
						gdouble _tmp73_;
						_tmp65_ = elevation_value;
						_tmp66_ = env_iter;
						_tmp67_ = _tmp66_->data;
						_tmp68_ = ((GpxPoint*) _tmp67_)->elevation;
						_tmp69_ = radius;
						_tmp70_ = mydist;
						elevation_value = _tmp65_ + (_tmp68_ * (_tmp69_ - _tmp70_));
						_tmp71_ = weights;
						_tmp72_ = radius;
						_tmp73_ = mydist;
						weights = _tmp71_ + (_tmp72_ - _tmp73_);
					} else {
						break;
					}
				}
				_tmp74_ = iter;
				env_iter = _tmp74_;
				while (TRUE) {
					GList* _tmp75_;
					GList* _tmp76_;
					GList* _tmp77_;
					gint _tmp78_;
					GList* _tmp79_;
					gconstpointer _tmp80_;
					GpxPoint* _tmp81_;
					gdouble _tmp82_ = 0.0;
					gdouble mydist;
					gdouble _tmp83_;
					gdouble _tmp84_;
					_tmp75_ = env_iter;
					_tmp76_ = _tmp75_->prev;
					env_iter = _tmp76_;
					_tmp77_ = env_iter;
					if (!(_tmp77_ != NULL)) {
						break;
					}
					_tmp78_ = i;
					i = _tmp78_ + 1;
					_tmp79_ = env_iter;
					_tmp80_ = _tmp79_->data;
					_tmp81_ = point;
					_tmp82_ = gpx_track_calculate_distance ((GpxPoint*) _tmp80_, _tmp81_);
					mydist = _tmp82_;
					_tmp83_ = mydist;
					_tmp84_ = radius;
					if (_tmp83_ < _tmp84_) {
						gdouble _tmp85_;
						GList* _tmp86_;
						gconstpointer _tmp87_;
						gdouble _tmp88_;
						gdouble _tmp89_;
						gdouble _tmp90_;
						gdouble _tmp91_;
						gdouble _tmp92_;
						gdouble _tmp93_;
						_tmp85_ = elevation_value;
						_tmp86_ = env_iter;
						_tmp87_ = _tmp86_->data;
						_tmp88_ = ((GpxPoint*) _tmp87_)->elevation;
						_tmp89_ = radius;
						_tmp90_ = mydist;
						elevation_value = _tmp85_ + (_tmp88_ * (_tmp89_ - _tmp90_));
						_tmp91_ = weights;
						_tmp92_ = radius;
						_tmp93_ = mydist;
						weights = _tmp91_ + (_tmp92_ - _tmp93_);
					} else {
						break;
					}
				}
				_tmp94_ = point;
				_tmp95_ = elevation_value;
				_tmp96_ = weights;
				_tmp94_->smooth_elevation = _tmp95_ / _tmp96_;
				_tmp97_ = point;
				_tmp98_ = gpx_point_has_position (_tmp97_);
				if (_tmp98_) {
					GList* _tmp99_;
					_tmp99_ = iter;
					last = _tmp99_;
				}
			}
		}
	}
}


static gpointer _gpx_point_ref0 (gpointer self) {
	return self ? gpx_point_ref (self) : NULL;
}


void gpx_track_add_point (GpxTrack* self, GpxPoint* point) {
	GpxPoint* _tmp0_;
	GpxPoint* _tmp1_;
	GpxPoint* _tmp118_;
	GpxPoint* _tmp119_;
	GpxPoint* _tmp120_;
	GpxPoint* _tmp121_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = point;
	_tmp0_->speed = 0.0;
	_tmp1_ = self->priv->last;
	if (_tmp1_ != NULL) {
		GpxPoint* _tmp2_;
		GpxPoint* _tmp3_;
		gdouble _tmp4_ = 0.0;
		gdouble distance;
		gdouble _tmp5_;
		gdouble _tmp6_;
		GpxPoint* _tmp7_;
		gdouble _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GpxPoint* _tmp11_;
		gboolean _tmp14_;
		gboolean _tmp19_;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		GpxPoint* _tmp30_;
		gboolean _tmp33_;
		gboolean _tmp38_;
		gboolean _tmp47_ = FALSE;
		gboolean _tmp48_ = FALSE;
		GpxPoint* _tmp49_;
		gboolean _tmp52_;
		gboolean _tmp57_;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		GpxPoint* _tmp68_;
		gboolean _tmp71_;
		gboolean _tmp76_;
		gboolean _tmp85_ = FALSE;
		gboolean _tmp86_ = FALSE;
		GpxPoint* _tmp87_;
		const gchar* _tmp88_;
		gboolean _tmp91_;
		gboolean _tmp94_;
		_tmp2_ = self->priv->last;
		_tmp3_ = point;
		_tmp4_ = gpx_track_calculate_distance (_tmp2_, _tmp3_);
		distance = _tmp4_;
		_tmp5_ = self->total_distance;
		_tmp6_ = distance;
		self->total_distance = _tmp5_ + _tmp6_;
		_tmp7_ = point;
		_tmp8_ = self->total_distance;
		_tmp7_->distance = _tmp8_;
		_tmp11_ = self->top;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			GpxPoint* _tmp12_;
			gdouble _tmp13_;
			_tmp12_ = self->top;
			_tmp13_ = _tmp12_->lat_dec;
			_tmp10_ = _tmp13_ == ((gdouble) 1000);
		}
		_tmp14_ = _tmp10_;
		if (_tmp14_) {
			_tmp9_ = TRUE;
		} else {
			GpxPoint* _tmp15_;
			gdouble _tmp16_;
			GpxPoint* _tmp17_;
			gdouble _tmp18_;
			_tmp15_ = self->top;
			_tmp16_ = _tmp15_->lat_dec;
			_tmp17_ = point;
			_tmp18_ = _tmp17_->lat_dec;
			_tmp9_ = _tmp16_ < _tmp18_;
		}
		_tmp19_ = _tmp9_;
		if (_tmp19_) {
			GpxPoint* _tmp20_;
			GpxPoint* _tmp22_;
			GpxPoint* _tmp23_;
			gdouble _tmp24_;
			GpxPoint* _tmp25_;
			GpxPoint* _tmp26_;
			gdouble _tmp27_;
			_tmp20_ = self->top;
			if (_tmp20_ == NULL) {
				GpxPoint* _tmp21_;
				_tmp21_ = gpx_point_new ();
				_gpx_point_unref0 (self->top);
				self->top = _tmp21_;
			}
			_tmp22_ = self->top;
			_tmp23_ = point;
			_tmp24_ = _tmp23_->lat_dec;
			_tmp22_->lat_dec = _tmp24_;
			_tmp25_ = self->top;
			_tmp26_ = point;
			_tmp27_ = _tmp26_->lat;
			_tmp25_->lat = _tmp27_;
		}
		_tmp30_ = self->top;
		if (_tmp30_ == NULL) {
			_tmp29_ = TRUE;
		} else {
			GpxPoint* _tmp31_;
			gdouble _tmp32_;
			_tmp31_ = self->top;
			_tmp32_ = _tmp31_->lon_dec;
			_tmp29_ = _tmp32_ == ((gdouble) 1000);
		}
		_tmp33_ = _tmp29_;
		if (_tmp33_) {
			_tmp28_ = TRUE;
		} else {
			GpxPoint* _tmp34_;
			gdouble _tmp35_;
			GpxPoint* _tmp36_;
			gdouble _tmp37_;
			_tmp34_ = self->top;
			_tmp35_ = _tmp34_->lon_dec;
			_tmp36_ = point;
			_tmp37_ = _tmp36_->lon_dec;
			_tmp28_ = _tmp35_ < _tmp37_;
		}
		_tmp38_ = _tmp28_;
		if (_tmp38_) {
			GpxPoint* _tmp39_;
			GpxPoint* _tmp41_;
			GpxPoint* _tmp42_;
			gdouble _tmp43_;
			GpxPoint* _tmp44_;
			GpxPoint* _tmp45_;
			gdouble _tmp46_;
			_tmp39_ = self->top;
			if (_tmp39_ == NULL) {
				GpxPoint* _tmp40_;
				_tmp40_ = gpx_point_new ();
				_gpx_point_unref0 (self->top);
				self->top = _tmp40_;
			}
			_tmp41_ = self->top;
			_tmp42_ = point;
			_tmp43_ = _tmp42_->lon_dec;
			_tmp41_->lon_dec = _tmp43_;
			_tmp44_ = self->top;
			_tmp45_ = point;
			_tmp46_ = _tmp45_->lon;
			_tmp44_->lon = _tmp46_;
		}
		_tmp49_ = self->bottom;
		if (_tmp49_ == NULL) {
			_tmp48_ = TRUE;
		} else {
			GpxPoint* _tmp50_;
			gdouble _tmp51_;
			_tmp50_ = self->bottom;
			_tmp51_ = _tmp50_->lat_dec;
			_tmp48_ = _tmp51_ == ((gdouble) 1000);
		}
		_tmp52_ = _tmp48_;
		if (_tmp52_) {
			_tmp47_ = TRUE;
		} else {
			GpxPoint* _tmp53_;
			gdouble _tmp54_;
			GpxPoint* _tmp55_;
			gdouble _tmp56_;
			_tmp53_ = self->bottom;
			_tmp54_ = _tmp53_->lat_dec;
			_tmp55_ = point;
			_tmp56_ = _tmp55_->lat_dec;
			_tmp47_ = _tmp54_ > _tmp56_;
		}
		_tmp57_ = _tmp47_;
		if (_tmp57_) {
			GpxPoint* _tmp58_;
			GpxPoint* _tmp60_;
			GpxPoint* _tmp61_;
			gdouble _tmp62_;
			GpxPoint* _tmp63_;
			GpxPoint* _tmp64_;
			gdouble _tmp65_;
			_tmp58_ = self->bottom;
			if (_tmp58_ == NULL) {
				GpxPoint* _tmp59_;
				_tmp59_ = gpx_point_new ();
				_gpx_point_unref0 (self->bottom);
				self->bottom = _tmp59_;
			}
			_tmp60_ = self->bottom;
			_tmp61_ = point;
			_tmp62_ = _tmp61_->lat_dec;
			_tmp60_->lat_dec = _tmp62_;
			_tmp63_ = self->bottom;
			_tmp64_ = point;
			_tmp65_ = _tmp64_->lat;
			_tmp63_->lat = _tmp65_;
		}
		_tmp68_ = self->bottom;
		if (_tmp68_ == NULL) {
			_tmp67_ = TRUE;
		} else {
			GpxPoint* _tmp69_;
			gdouble _tmp70_;
			_tmp69_ = self->bottom;
			_tmp70_ = _tmp69_->lon_dec;
			_tmp67_ = _tmp70_ == ((gdouble) 1000);
		}
		_tmp71_ = _tmp67_;
		if (_tmp71_) {
			_tmp66_ = TRUE;
		} else {
			GpxPoint* _tmp72_;
			gdouble _tmp73_;
			GpxPoint* _tmp74_;
			gdouble _tmp75_;
			_tmp72_ = self->bottom;
			_tmp73_ = _tmp72_->lon_dec;
			_tmp74_ = point;
			_tmp75_ = _tmp74_->lon_dec;
			_tmp66_ = _tmp73_ > _tmp75_;
		}
		_tmp76_ = _tmp66_;
		if (_tmp76_) {
			GpxPoint* _tmp77_;
			GpxPoint* _tmp79_;
			GpxPoint* _tmp80_;
			gdouble _tmp81_;
			GpxPoint* _tmp82_;
			GpxPoint* _tmp83_;
			gdouble _tmp84_;
			_tmp77_ = self->bottom;
			if (_tmp77_ == NULL) {
				GpxPoint* _tmp78_;
				_tmp78_ = gpx_point_new ();
				_gpx_point_unref0 (self->bottom);
				self->bottom = _tmp78_;
			}
			_tmp79_ = self->bottom;
			_tmp80_ = point;
			_tmp81_ = _tmp80_->lon_dec;
			_tmp79_->lon_dec = _tmp81_;
			_tmp82_ = self->bottom;
			_tmp83_ = point;
			_tmp84_ = _tmp83_->lon;
			_tmp82_->lon = _tmp84_;
		}
		_tmp87_ = self->priv->last;
		_tmp88_ = _tmp87_->time;
		if (_tmp88_ != NULL) {
			GpxPoint* _tmp89_;
			const gchar* _tmp90_;
			_tmp89_ = point;
			_tmp90_ = _tmp89_->time;
			_tmp86_ = _tmp90_ != NULL;
		} else {
			_tmp86_ = FALSE;
		}
		_tmp91_ = _tmp86_;
		if (_tmp91_) {
			GpxPoint* _tmp92_;
			gboolean _tmp93_ = FALSE;
			_tmp92_ = point;
			_tmp93_ = gpx_point_has_position (_tmp92_);
			_tmp85_ = _tmp93_;
		} else {
			_tmp85_ = FALSE;
		}
		_tmp94_ = _tmp85_;
		if (_tmp94_) {
			GpxPoint* _tmp95_;
			GpxPoint* _tmp96_;
			GpxPoint* _tmp97_;
			gdouble _tmp98_ = 0.0;
			GpxPoint* _tmp99_;
			gdouble _tmp100_;
			gdouble _tmp101_;
			GpxPoint* _tmp104_;
			gdouble _tmp105_;
			gdouble _tmp106_;
			GpxPoint* _tmp109_;
			gdouble _tmp110_;
			gdouble _tmp111_;
			_tmp95_ = point;
			_tmp96_ = self->priv->last;
			_tmp97_ = point;
			_tmp98_ = gpx_track_calculate_point_to_point_speed (self, _tmp96_, _tmp97_);
			_tmp95_->speed = _tmp98_;
			_tmp99_ = point;
			_tmp100_ = _tmp99_->speed;
			_tmp101_ = self->max_speed;
			if (_tmp100_ > _tmp101_) {
				GpxPoint* _tmp102_;
				gdouble _tmp103_;
				_tmp102_ = point;
				_tmp103_ = _tmp102_->speed;
				self->max_speed = _tmp103_;
			}
			_tmp104_ = point;
			_tmp105_ = _tmp104_->elevation;
			_tmp106_ = self->max_elevation;
			if (_tmp105_ > _tmp106_) {
				GpxPoint* _tmp107_;
				gdouble _tmp108_;
				_tmp107_ = point;
				_tmp108_ = _tmp107_->elevation;
				self->max_elevation = _tmp108_;
			}
			_tmp109_ = point;
			_tmp110_ = _tmp109_->elevation;
			_tmp111_ = self->min_elevation;
			if (_tmp110_ < _tmp111_) {
				GpxPoint* _tmp112_;
				gdouble _tmp113_;
				_tmp112_ = point;
				_tmp113_ = _tmp112_->elevation;
				self->min_elevation = _tmp113_;
			}
		}
	} else {
		GpxPoint* _tmp114_;
		gdouble _tmp115_;
		GpxPoint* _tmp116_;
		gdouble _tmp117_;
		_tmp114_ = point;
		_tmp115_ = _tmp114_->elevation;
		self->max_elevation = _tmp115_;
		_tmp116_ = point;
		_tmp117_ = _tmp116_->elevation;
		self->min_elevation = _tmp117_;
	}
	_tmp118_ = point;
	_tmp119_ = _gpx_point_ref0 (_tmp118_);
	self->points = g_list_append (self->points, _tmp119_);
	_tmp120_ = point;
	_tmp121_ = _gpx_point_ref0 (_tmp120_);
	_gpx_point_unref0 (self->priv->last);
	self->priv->last = _tmp121_;
}


GpxTrack* gpx_track_cleanup_speed (GpxTrack* self) {
	GpxTrack* result = NULL;
	GpxTrack* _tmp0_;
	GpxTrack* retv;
	GpxTrack* _tmp1_;
	const gchar* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	guint num_points;
	gdouble _tmp5_ = 0.0;
	gdouble mean;
	gdouble deviation;
	GList* _tmp6_;
	GList* _tmp7_ = NULL;
	GList* list_copy;
	GList* _tmp8_;
	GList* _tmp9_ = NULL;
	GList* iter;
	gdouble _tmp20_;
	guint _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_ = NULL;
	guint i;
	GList* _tmp95_;
	GList* _tmp96_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gpx_track_new ();
	retv = _tmp0_;
	_tmp1_ = retv;
	_tmp2_ = self->priv->_name;
	gpx_track_set_name (_tmp1_, _tmp2_);
	_tmp3_ = self->points;
	_tmp4_ = g_list_length (_tmp3_);
	num_points = _tmp4_;
	_tmp5_ = gpx_track_get_track_average (self);
	mean = _tmp5_;
	deviation = 0.0;
	_tmp6_ = self->points;
	_tmp7_ = g_list_copy (_tmp6_);
	list_copy = _tmp7_;
	_tmp8_ = list_copy;
	_tmp9_ = g_list_first (_tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GList* _tmp10_;
		GList* _tmp11_;
		gconstpointer _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		gdouble diff;
		gdouble _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_;
		_tmp10_ = iter;
		if (!(_tmp10_ != NULL)) {
			break;
		}
		_tmp11_ = iter;
		_tmp12_ = _tmp11_->data;
		_tmp13_ = ((GpxPoint*) _tmp12_)->speed;
		_tmp14_ = mean;
		diff = _tmp13_ - _tmp14_;
		_tmp15_ = deviation;
		_tmp16_ = diff;
		_tmp17_ = diff;
		deviation = _tmp15_ + (_tmp16_ * _tmp17_);
		_tmp18_ = iter;
		_tmp19_ = _tmp18_->next;
		iter = _tmp19_;
	}
	_tmp20_ = deviation;
	_tmp21_ = num_points;
	deviation = _tmp20_ / _tmp21_;
	_tmp22_ = list_copy;
	_tmp23_ = g_list_first (_tmp22_);
	iter = _tmp23_;
	i = (guint) 0;
	while (TRUE) {
		GList* _tmp24_;
		GList* _tmp25_;
		gconstpointer _tmp26_;
		gdouble _tmp27_;
		gdouble pspeed;
		GList* _tmp28_;
		GList* _tmp29_;
		gdouble _tmp34_;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_;
		gdouble _tmp41_ = 0.0;
		gdouble pdf;
		gboolean _tmp42_ = FALSE;
		guint _tmp43_;
		gdouble _tmp44_;
		gboolean _tmp48_;
		_tmp24_ = iter;
		if (!(_tmp24_ != NULL)) {
			break;
		}
		_tmp25_ = iter;
		_tmp26_ = _tmp25_->data;
		_tmp27_ = ((GpxPoint*) _tmp26_)->speed;
		pspeed = _tmp27_;
		_tmp28_ = iter;
		_tmp29_ = _tmp28_->next;
		if (_tmp29_ != NULL) {
			GList* _tmp30_;
			GList* _tmp31_;
			gconstpointer _tmp32_;
			gdouble _tmp33_;
			_tmp30_ = iter;
			_tmp31_ = _tmp30_->next;
			_tmp32_ = _tmp31_->data;
			_tmp33_ = ((GpxPoint*) _tmp32_)->speed;
			pspeed = _tmp33_;
		}
		_tmp34_ = deviation;
		_tmp35_ = sqrt ((2 * G_PI) * _tmp34_);
		_tmp36_ = pspeed;
		_tmp37_ = mean;
		_tmp38_ = pspeed;
		_tmp39_ = mean;
		_tmp40_ = deviation;
		_tmp41_ = exp ((-((_tmp36_ - _tmp37_) * (_tmp38_ - _tmp39_))) / (2 * _tmp40_));
		pdf = (1 / _tmp35_) * _tmp41_;
		_tmp43_ = num_points;
		_tmp44_ = pdf;
		if ((_tmp43_ * _tmp44_) < 0.1) {
			GList* _tmp45_;
			gconstpointer _tmp46_;
			gboolean _tmp47_;
			_tmp45_ = iter;
			_tmp46_ = _tmp45_->data;
			_tmp47_ = ((GpxPoint*) _tmp46_)->stopped;
			_tmp42_ = !_tmp47_;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp48_ = _tmp42_;
		if (_tmp48_) {
			GList* _tmp49_;
			GList* _tmp50_;
			GList* temp;
			GList* _tmp51_;
			GList* _tmp52_;
			_tmp49_ = iter;
			_tmp50_ = _tmp49_->prev;
			temp = _tmp50_;
			_tmp51_ = iter;
			list_copy = g_list_remove_link (list_copy, _tmp51_);
			_tmp52_ = temp;
			if (_tmp52_ != NULL) {
				GList* _tmp53_;
				GList* _tmp54_;
				GList* _tmp55_;
				_tmp53_ = temp;
				iter = _tmp53_;
				_tmp54_ = iter;
				_tmp55_ = _tmp54_->next;
				if (_tmp55_ != NULL) {
					GList* _tmp56_;
					GList* _tmp57_;
					gconstpointer _tmp58_;
					GList* _tmp59_;
					gconstpointer _tmp60_;
					GList* _tmp61_;
					GList* _tmp62_;
					gconstpointer _tmp63_;
					gdouble _tmp64_ = 0.0;
					_tmp56_ = iter;
					_tmp57_ = _tmp56_->next;
					_tmp58_ = _tmp57_->data;
					_tmp59_ = iter;
					_tmp60_ = _tmp59_->data;
					_tmp61_ = iter;
					_tmp62_ = _tmp61_->next;
					_tmp63_ = _tmp62_->data;
					_tmp64_ = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp60_, (GpxPoint*) _tmp63_);
					((GpxPoint*) _tmp58_)->speed = _tmp64_;
				}
			} else {
				GList* _tmp65_;
				GList* _tmp66_ = NULL;
				GList* _tmp67_;
				i = (guint) 0;
				_tmp65_ = list_copy;
				_tmp66_ = g_list_first (_tmp65_);
				iter = _tmp66_;
				_tmp67_ = iter;
				if (_tmp67_ != NULL) {
					GList* _tmp68_;
					gconstpointer _tmp69_;
					GList* _tmp70_;
					gconstpointer _tmp71_;
					GList* _tmp72_;
					GList* _tmp73_;
					_tmp68_ = iter;
					_tmp69_ = _tmp68_->data;
					((GpxPoint*) _tmp69_)->speed = 0.0;
					_tmp70_ = iter;
					_tmp71_ = _tmp70_->data;
					((GpxPoint*) _tmp71_)->distance = 0.0;
					_tmp72_ = iter;
					_tmp73_ = _tmp72_->next;
					if (_tmp73_ != NULL) {
						GList* _tmp74_;
						GList* _tmp75_;
						gconstpointer _tmp76_;
						GList* _tmp77_;
						gconstpointer _tmp78_;
						GList* _tmp79_;
						GList* _tmp80_;
						gconstpointer _tmp81_;
						gdouble _tmp82_ = 0.0;
						GList* _tmp83_;
						GList* _tmp84_;
						gconstpointer _tmp85_;
						GList* _tmp86_;
						gconstpointer _tmp87_;
						GList* _tmp88_;
						GList* _tmp89_;
						gconstpointer _tmp90_;
						gdouble _tmp91_ = 0.0;
						_tmp74_ = iter;
						_tmp75_ = _tmp74_->next;
						_tmp76_ = _tmp75_->data;
						_tmp77_ = iter;
						_tmp78_ = _tmp77_->data;
						_tmp79_ = iter;
						_tmp80_ = _tmp79_->next;
						_tmp81_ = _tmp80_->data;
						_tmp82_ = gpx_track_calculate_distance ((GpxPoint*) _tmp78_, (GpxPoint*) _tmp81_);
						((GpxPoint*) _tmp76_)->distance = _tmp82_;
						_tmp83_ = iter;
						_tmp84_ = _tmp83_->next;
						_tmp85_ = _tmp84_->data;
						_tmp86_ = iter;
						_tmp87_ = _tmp86_->data;
						_tmp88_ = iter;
						_tmp89_ = _tmp88_->next;
						_tmp90_ = _tmp89_->data;
						_tmp91_ = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp87_, (GpxPoint*) _tmp90_);
						((GpxPoint*) _tmp85_)->speed = _tmp91_;
					}
				}
			}
		} else {
			GList* _tmp92_;
			GList* _tmp93_;
			guint _tmp94_;
			_tmp92_ = iter;
			_tmp93_ = _tmp92_->next;
			iter = _tmp93_;
			_tmp94_ = i;
			i = _tmp94_ + 1;
		}
	}
	_tmp95_ = list_copy;
	_tmp96_ = g_list_first (_tmp95_);
	iter = _tmp96_;
	while (TRUE) {
		GList* _tmp97_;
		GpxTrack* _tmp98_;
		GList* _tmp99_;
		gconstpointer _tmp100_;
		GList* _tmp101_;
		GList* _tmp102_;
		_tmp97_ = iter;
		if (!(_tmp97_ != NULL)) {
			break;
		}
		_tmp98_ = retv;
		_tmp99_ = iter;
		_tmp100_ = _tmp99_->data;
		gpx_track_add_point (_tmp98_, (GpxPoint*) _tmp100_);
		_tmp101_ = iter;
		_tmp102_ = _tmp101_->next;
		iter = _tmp102_;
	}
	result = retv;
	_g_list_free0 (list_copy);
	return result;
}


/**
         * Calculate the speed of the full track
         *
         * @returns the average speed of the full track in km/h.
         */
gdouble gpx_track_get_track_average (GpxTrack* self) {
	gdouble result = 0.0;
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* first;
	GList* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* last;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->points;
	_tmp1_ = g_list_first (_tmp0_);
	first = _tmp1_;
	_tmp2_ = self->points;
	_tmp3_ = g_list_last (_tmp2_);
	last = _tmp3_;
	_tmp5_ = first;
	if (_tmp5_ != NULL) {
		GList* _tmp6_;
		_tmp6_ = last;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GList* _tmp8_;
		gconstpointer _tmp9_;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		gdouble _tmp12_ = 0.0;
		_tmp8_ = first;
		_tmp9_ = _tmp8_->data;
		_tmp10_ = last;
		_tmp11_ = _tmp10_->data;
		_tmp12_ = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp9_, (GpxPoint*) _tmp11_);
		result = _tmp12_;
		return result;
	}
	result = (gdouble) 0;
	return result;
}


/**
         * Calculate the average speed between Point a and Point b on the track
         */
gdouble gpx_track_calculate_point_to_point_speed (GpxTrack* self, GpxPoint* a, GpxPoint* b) {
	gdouble result = 0.0;
	GpxPoint* _tmp0_;
	gdouble _tmp1_;
	GpxPoint* _tmp2_;
	gdouble _tmp3_;
	gdouble dist;
	gboolean _tmp4_ = FALSE;
	GpxPoint* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_;
	GpxPoint* _tmp10_;
	time_t _tmp11_ = 0;
	time_t ta;
	GpxPoint* _tmp12_;
	time_t _tmp13_ = 0;
	time_t tb;
	time_t _tmp14_;
	time_t _tmp15_;
	gdouble _tmp16_;
	time_t _tmp17_;
	time_t _tmp18_;
	gdouble speed;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	_tmp0_ = b;
	_tmp1_ = _tmp0_->distance;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->distance;
	dist = _tmp1_ - _tmp3_;
	_tmp5_ = a;
	_tmp6_ = _tmp5_->time;
	if (_tmp6_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GpxPoint* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = b;
		_tmp8_ = _tmp7_->time;
		_tmp4_ = _tmp8_ == NULL;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		result = (gdouble) 0;
		return result;
	}
	_tmp10_ = a;
	_tmp11_ = gpx_point_get_time (_tmp10_);
	ta = _tmp11_;
	_tmp12_ = b;
	_tmp13_ = gpx_point_get_time (_tmp12_);
	tb = _tmp13_;
	_tmp14_ = tb;
	_tmp15_ = ta;
	if ((_tmp14_ - _tmp15_) == ((time_t) 0)) {
		result = (gdouble) 0;
		return result;
	}
	_tmp16_ = dist;
	_tmp17_ = tb;
	_tmp18_ = ta;
	speed = ((60.0 * 60.0) * _tmp16_) / (_tmp17_ - _tmp18_);
	result = speed;
	return result;
}


time_t gpx_track_get_total_time (GpxTrack* self) {
	time_t result = 0;
	GpxPoint* a = NULL;
	GpxPoint* b = NULL;
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* na;
	GList* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* nb;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	gboolean _tmp7_;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	GpxPoint* _tmp10_;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	GpxPoint* _tmp13_;
	GpxPoint* _tmp14_;
	time_t _tmp15_ = 0;
	GpxPoint* _tmp16_;
	time_t _tmp17_ = 0;
	time_t time;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->points;
	_tmp1_ = g_list_first (_tmp0_);
	na = _tmp1_;
	_tmp2_ = self->points;
	_tmp3_ = g_list_last (_tmp2_);
	nb = _tmp3_;
	_tmp5_ = na;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GList* _tmp6_;
		_tmp6_ = nb;
		_tmp4_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		result = (time_t) 0;
		_gpx_point_unref0 (b);
		_gpx_point_unref0 (a);
		return result;
	}
	_tmp8_ = na;
	_tmp9_ = _tmp8_->data;
	_tmp10_ = _gpx_point_ref0 ((GpxPoint*) _tmp9_);
	_gpx_point_unref0 (a);
	a = _tmp10_;
	_tmp11_ = nb;
	_tmp12_ = _tmp11_->data;
	_tmp13_ = _gpx_point_ref0 ((GpxPoint*) _tmp12_);
	_gpx_point_unref0 (b);
	b = _tmp13_;
	_tmp14_ = b;
	_tmp15_ = gpx_point_get_time (_tmp14_);
	_tmp16_ = a;
	_tmp17_ = gpx_point_get_time (_tmp16_);
	time = _tmp15_ - _tmp17_;
	result = time;
	_gpx_point_unref0 (b);
	_gpx_point_unref0 (a);
	return result;
}


/**
         * Try not to calculate time that we "stopped"  in average
         */
gdouble gpx_track_calculate_moving_average (GpxTrack* self, GpxPoint* start, GpxPoint* stop, time_t* moving_time) {
	time_t _vala_moving_time = 0;
	gdouble result = 0.0;
	gdouble time;
	gdouble distance;
	GList* _tmp0_;
	GpxPoint* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* iter;
	GList* _tmp3_;
	GList* _tmp4_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (start != NULL, 0.0);
	g_return_val_if_fail (stop != NULL, 0.0);
	time = (gdouble) 0;
	distance = (gdouble) 0;
	_vala_moving_time = (time_t) 0;
	_tmp0_ = self->points;
	_tmp1_ = start;
	_tmp2_ = g_list_find (_tmp0_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = iter;
	if (_tmp3_ == NULL) {
		result = (gdouble) 0;
		if (moving_time) {
			*moving_time = _vala_moving_time;
		}
		return result;
	}
	_tmp4_ = iter;
	if (_tmp4_ != NULL) {
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			GList* _tmp6_;
			GList* _tmp7_;
			GList* _tmp8_;
			gboolean _tmp13_;
			GList* _tmp14_;
			gconstpointer _tmp15_;
			GpxPoint* _tmp16_;
			GpxPoint* b;
			GpxPoint* _tmp17_;
			gboolean _tmp18_;
			_tmp6_ = iter;
			_tmp7_ = _tmp6_->next;
			iter = _tmp7_;
			_tmp8_ = iter;
			if (_tmp8_ != NULL) {
				GList* _tmp9_;
				GList* _tmp10_;
				gconstpointer _tmp11_;
				GpxPoint* _tmp12_;
				_tmp9_ = iter;
				_tmp10_ = _tmp9_->prev;
				_tmp11_ = _tmp10_->data;
				_tmp12_ = stop;
				_tmp5_ = ((GpxPoint*) _tmp11_) != _tmp12_;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp13_ = _tmp5_;
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = iter;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = _gpx_point_ref0 ((GpxPoint*) _tmp15_);
			b = _tmp16_;
			_tmp17_ = b;
			_tmp18_ = _tmp17_->stopped;
			if (!_tmp18_) {
				gdouble _tmp19_;
				GpxPoint* _tmp20_;
				time_t _tmp21_ = 0;
				GList* _tmp22_;
				GList* _tmp23_;
				gconstpointer _tmp24_;
				time_t _tmp25_ = 0;
				gdouble _tmp26_;
				GpxPoint* _tmp27_;
				gdouble _tmp28_;
				GList* _tmp29_;
				GList* _tmp30_;
				gconstpointer _tmp31_;
				gdouble _tmp32_;
				_tmp19_ = time;
				_tmp20_ = b;
				_tmp21_ = gpx_point_get_time (_tmp20_);
				_tmp22_ = iter;
				_tmp23_ = _tmp22_->prev;
				_tmp24_ = _tmp23_->data;
				_tmp25_ = gpx_point_get_time ((GpxPoint*) _tmp24_);
				time = _tmp19_ + (_tmp21_ - _tmp25_);
				_tmp26_ = distance;
				_tmp27_ = b;
				_tmp28_ = _tmp27_->distance;
				_tmp29_ = iter;
				_tmp30_ = _tmp29_->prev;
				_tmp31_ = _tmp30_->data;
				_tmp32_ = ((GpxPoint*) _tmp31_)->distance;
				distance = _tmp26_ + (_tmp28_ - _tmp32_);
			}
			_gpx_point_unref0 (b);
		}
	}
	_tmp33_ = time;
	_vala_moving_time = (time_t) _tmp33_;
	_tmp34_ = distance;
	_tmp35_ = time;
	result = _tmp34_ / (_tmp35_ / (60.0 * 60.0));
	if (moving_time) {
		*moving_time = _vala_moving_time;
	}
	return result;
}


void gpx_track_calculate_total_elevation (GpxTrack* self, GpxPoint* start, GpxPoint* stop, gdouble* up, gdouble* down) {
	gdouble _vala_up = 0.0;
	gdouble _vala_down = 0.0;
	GList* _tmp0_;
	GpxPoint* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* iter;
	GList* last;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (stop != NULL);
	_vala_up = 0.0;
	_vala_down = 0.0;
	_tmp0_ = self->points;
	_tmp1_ = start;
	_tmp2_ = g_list_find (_tmp0_, _tmp1_);
	iter = _tmp2_;
	last = NULL;
	_tmp3_ = iter;
	if (_tmp3_ == NULL) {
		if (up) {
			*up = _vala_up;
		}
		if (down) {
			*down = _vala_down;
		}
		return;
	}
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			gboolean _tmp5_;
			GList* _tmp15_;
			GList* _tmp36_;
			_tmp5_ = _tmp4_;
			if (!_tmp5_) {
				gboolean _tmp6_ = FALSE;
				GList* _tmp7_;
				GList* _tmp8_;
				GList* _tmp9_;
				gboolean _tmp14_;
				_tmp7_ = iter;
				_tmp8_ = _tmp7_->next;
				iter = _tmp8_;
				_tmp9_ = iter;
				if (_tmp9_ != NULL) {
					GList* _tmp10_;
					GList* _tmp11_;
					gconstpointer _tmp12_;
					GpxPoint* _tmp13_;
					_tmp10_ = iter;
					_tmp11_ = _tmp10_->prev;
					_tmp12_ = _tmp11_->data;
					_tmp13_ = stop;
					_tmp6_ = ((GpxPoint*) _tmp12_) != _tmp13_;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp14_ = _tmp6_;
				if (!_tmp14_) {
					break;
				}
			}
			_tmp4_ = FALSE;
			_tmp15_ = last;
			if (_tmp15_ != NULL) {
				GList* _tmp16_;
				gconstpointer _tmp17_;
				gdouble _tmp18_;
				GList* _tmp19_;
				gconstpointer _tmp20_;
				gdouble _tmp21_;
				_tmp16_ = iter;
				_tmp17_ = _tmp16_->data;
				_tmp18_ = ((GpxPoint*) _tmp17_)->smooth_elevation;
				_tmp19_ = last;
				_tmp20_ = _tmp19_->data;
				_tmp21_ = ((GpxPoint*) _tmp20_)->smooth_elevation;
				if (_tmp18_ > _tmp21_) {
					gdouble _tmp22_;
					GList* _tmp23_;
					gconstpointer _tmp24_;
					gdouble _tmp25_;
					GList* _tmp26_;
					gconstpointer _tmp27_;
					gdouble _tmp28_;
					_tmp22_ = _vala_up;
					_tmp23_ = iter;
					_tmp24_ = _tmp23_->data;
					_tmp25_ = ((GpxPoint*) _tmp24_)->smooth_elevation;
					_tmp26_ = last;
					_tmp27_ = _tmp26_->data;
					_tmp28_ = ((GpxPoint*) _tmp27_)->smooth_elevation;
					_vala_up = _tmp22_ + (_tmp25_ - _tmp28_);
				} else {
					gdouble _tmp29_;
					GList* _tmp30_;
					gconstpointer _tmp31_;
					gdouble _tmp32_;
					GList* _tmp33_;
					gconstpointer _tmp34_;
					gdouble _tmp35_;
					_tmp29_ = _vala_down;
					_tmp30_ = last;
					_tmp31_ = _tmp30_->data;
					_tmp32_ = ((GpxPoint*) _tmp31_)->smooth_elevation;
					_tmp33_ = iter;
					_tmp34_ = _tmp33_->data;
					_tmp35_ = ((GpxPoint*) _tmp34_)->smooth_elevation;
					_vala_down = _tmp29_ + (_tmp32_ - _tmp35_);
				}
			}
			_tmp36_ = iter;
			last = _tmp36_;
		}
	}
	if (up) {
		*up = _vala_up;
	}
	if (down) {
		*down = _vala_down;
	}
}


/**
 * @param lon_a longitude in radians of point a
 * @param lat_a latitude in radians of point a
 * @param lon_b longitude in radians of point b
 * @param lat_a latitude in radians of point b
         * Calculate distance between point a and point b using great circular distance method
         * Elevation is not taken into account.
         *
         * @returns distance in km.		 
 */
gdouble gpx_track_calculate_distance_coords (gdouble lon_a, gdouble lat_a, gdouble lon_b, gdouble lat_b) {
	gdouble result = 0.0;
	gdouble retv;
	gdouble _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_;
	gint _tmp13_ = 0;
	retv = (gdouble) 0;
	_tmp0_ = lat_a;
	_tmp1_ = sin (_tmp0_);
	_tmp2_ = lat_b;
	_tmp3_ = sin (_tmp2_);
	_tmp4_ = lat_a;
	_tmp5_ = cos (_tmp4_);
	_tmp6_ = lat_b;
	_tmp7_ = cos (_tmp6_);
	_tmp8_ = lon_b;
	_tmp9_ = lon_a;
	_tmp10_ = cos (_tmp8_ - _tmp9_);
	_tmp11_ = acos ((_tmp1_ * _tmp3_) + ((_tmp5_ * _tmp7_) * _tmp10_));
	retv = 6378.7 * _tmp11_;
	_tmp12_ = retv;
	_tmp13_ = isnan (_tmp12_);
	if (_tmp13_ == 1) {
		result = (gdouble) 0;
		return result;
	}
	result = retv;
	return result;
}


/**
         * @param a the first Gpx.Point
         * @param b the second Gpx.Point
         *
         * Calculate distance between point a and point b using great circular distance method
         * Elevation is not taken into account.
         *
         * @returns distance in km.
         */
gdouble gpx_track_calculate_distance (GpxPoint* a, GpxPoint* b) {
	gdouble result = 0.0;
	gboolean _tmp0_ = FALSE;
	GpxPoint* _tmp1_;
	gdouble _tmp2_;
	GpxPoint* _tmp3_;
	gdouble _tmp4_;
	gboolean _tmp9_;
	GpxPoint* _tmp10_;
	gdouble _tmp11_;
	GpxPoint* _tmp12_;
	gdouble _tmp13_;
	GpxPoint* _tmp14_;
	gdouble _tmp15_;
	GpxPoint* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_ = 0.0;
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	_tmp1_ = a;
	_tmp2_ = _tmp1_->lat;
	_tmp3_ = b;
	_tmp4_ = _tmp3_->lat;
	if (_tmp2_ == _tmp4_) {
		GpxPoint* _tmp5_;
		gdouble _tmp6_;
		GpxPoint* _tmp7_;
		gdouble _tmp8_;
		_tmp5_ = a;
		_tmp6_ = _tmp5_->lon;
		_tmp7_ = b;
		_tmp8_ = _tmp7_->lon;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = (gdouble) 0;
		return result;
	}
	_tmp10_ = a;
	_tmp11_ = _tmp10_->lon;
	_tmp12_ = a;
	_tmp13_ = _tmp12_->lat;
	_tmp14_ = b;
	_tmp15_ = _tmp14_->lon;
	_tmp16_ = b;
	_tmp17_ = _tmp16_->lat;
	_tmp18_ = gpx_track_calculate_distance_coords (_tmp11_, _tmp13_, _tmp15_, _tmp17_);
	result = _tmp18_;
	return result;
}


guint gpx_track_heartrate_avg (GpxTrack* self, GpxPoint* start, GpxPoint* stop) {
	guint result = 0U;
	gdouble total;
	gdouble total_time;
	GpxPoint* prev;
	GList* _tmp0_;
	GpxPoint* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* iter;
	GList* _tmp3_;
	guint _tmp35_ = 0U;
	gdouble _tmp36_;
	guint _tmp39_;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (start != NULL, 0U);
	g_return_val_if_fail (stop != NULL, 0U);
	total = (gdouble) 0;
	total_time = 0.0;
	prev = NULL;
	_tmp0_ = self->points;
	_tmp1_ = start;
	_tmp2_ = g_list_find (_tmp0_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = iter;
	if (_tmp3_ == NULL) {
		result = (guint) 0;
		return result;
	}
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			gboolean _tmp5_;
			GList* _tmp13_;
			gconstpointer _tmp14_;
			GpxPoint* _tmp15_;
			GpxPoint* p;
			GpxPoint* _tmp16_;
			GpxHeartRateMonitorPoint _tmp17_;
			gint _tmp18_;
			GList* _tmp33_;
			GList* _tmp34_;
			_tmp5_ = _tmp4_;
			if (!_tmp5_) {
				gboolean _tmp6_ = FALSE;
				GList* _tmp7_;
				gboolean _tmp12_;
				_tmp7_ = iter;
				if (_tmp7_ != NULL) {
					GList* _tmp8_;
					GList* _tmp9_;
					gconstpointer _tmp10_;
					GpxPoint* _tmp11_;
					_tmp8_ = iter;
					_tmp9_ = _tmp8_->prev;
					_tmp10_ = _tmp9_->data;
					_tmp11_ = stop;
					_tmp6_ = ((GpxPoint*) _tmp10_) != _tmp11_;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp12_ = _tmp6_;
				if (!_tmp12_) {
					break;
				}
			}
			_tmp4_ = FALSE;
			_tmp13_ = iter;
			_tmp14_ = _tmp13_->data;
			_tmp15_ = _gpx_point_ref0 ((GpxPoint*) _tmp14_);
			p = _tmp15_;
			_tmp16_ = p;
			_tmp17_ = _tmp16_->tpe;
			_tmp18_ = _tmp17_.heartrate;
			if (_tmp18_ != 0) {
				GpxPoint* _tmp19_;
				_tmp19_ = prev;
				if (_tmp19_ == NULL) {
					GpxPoint* _tmp20_;
					_tmp20_ = p;
					prev = _tmp20_;
				} else {
					GpxPoint* _tmp21_;
					time_t _tmp22_ = 0;
					GpxPoint* _tmp23_;
					time_t _tmp24_ = 0;
					gdouble diff;
					GpxPoint* _tmp32_;
					_tmp21_ = p;
					_tmp22_ = gpx_point_get_time (_tmp21_);
					_tmp23_ = prev;
					_tmp24_ = gpx_point_get_time (_tmp23_);
					diff = ((gdouble) _tmp22_) - ((gdouble) _tmp24_);
					{
						gdouble _tmp25_;
						GpxPoint* _tmp26_;
						GpxHeartRateMonitorPoint _tmp27_;
						gint _tmp28_;
						gdouble _tmp29_;
						gdouble _tmp30_;
						gdouble _tmp31_;
						_tmp25_ = total;
						_tmp26_ = prev;
						_tmp27_ = _tmp26_->tpe;
						_tmp28_ = _tmp27_.heartrate;
						_tmp29_ = diff;
						total = _tmp25_ + (_tmp28_ * _tmp29_);
						_tmp30_ = total_time;
						_tmp31_ = diff;
						total_time = _tmp30_ + _tmp31_;
					}
					_tmp32_ = p;
					prev = _tmp32_;
				}
			}
			_tmp33_ = iter;
			_tmp34_ = _tmp33_->next;
			iter = _tmp34_;
			_gpx_point_unref0 (p);
		}
	}
	_tmp36_ = total_time;
	if (_tmp36_ > ((gdouble) 0)) {
		gdouble _tmp37_;
		gdouble _tmp38_;
		_tmp37_ = total;
		_tmp38_ = total_time;
		_tmp35_ = (guint) (_tmp37_ / _tmp38_);
	} else {
		_tmp35_ = (guint) 0;
	}
	_tmp39_ = _tmp35_;
	result = _tmp39_;
	return result;
}


guint gpx_track_get_burned_calories (GpxTrack* self) {
	guint result = 0U;
	GpxHeartRateMonitorTrack _tmp0_;
	guint32 _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->hrmt;
	_tmp1_ = _tmp0_.calories;
	result = (guint) _tmp1_;
	return result;
}


void gpx_track_set_burned_calories (GpxTrack* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->hrmt.calories = (guint32) _tmp0_;
}


GpxTrack* gpx_track_construct (GType object_type) {
	GpxTrack * self = NULL;
	self = (GpxTrack*) g_object_new (object_type, NULL);
	return self;
}


GpxTrack* gpx_track_new (void) {
	return gpx_track_construct (GPX_TYPE_TRACK);
}


const gchar* gpx_track_get_name (GpxTrack* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void gpx_track_set_name (GpxTrack* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static void gpx_track_class_init (GpxTrackClass * klass) {
	gpx_track_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GpxTrackPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_track_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_track_set_property;
	G_OBJECT_CLASS (klass)->finalize = gpx_track_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_TRACK_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gpx_track_instance_init (GpxTrack * self) {
	GpxHeartRateMonitorTrack _tmp0_ = {0};
	self->priv = GPX_TRACK_GET_PRIVATE (self);
	memset (&_tmp0_, 0, sizeof (GpxHeartRateMonitorTrack));
	_tmp0_.calories = (guint32) 0;
	self->hrmt = _tmp0_;
	self->priv->_name = NULL;
	self->filtered_points = 0;
	self->total_distance = 0.0;
	self->max_speed = 0.0;
	self->max_elevation = 0.0;
	self->min_elevation = 0.0;
	self->points = NULL;
	self->priv->last = NULL;
	self->top = NULL;
	self->bottom = NULL;
}


static void gpx_track_finalize (GObject* obj) {
	GpxTrack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_TRACK, GpxTrack);
	_g_free0 (self->priv->_name);
	__g_list_free__gpx_point_unref0_0 (self->points);
	_gpx_point_unref0 (self->priv->last);
	_gpx_point_unref0 (self->top);
	_gpx_point_unref0 (self->bottom);
	G_OBJECT_CLASS (gpx_track_parent_class)->finalize (obj);
}


/**
     * This class represents a Track in a gpx file.
     * The tracks contains the points connecting everything together.
     * Info like total distance, average speed, moving speed/time etc are available.
     */
GType gpx_track_get_type (void) {
	static volatile gsize gpx_track_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_track_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpxTrackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_track_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxTrack), 0, (GInstanceInitFunc) gpx_track_instance_init, NULL };
		GType gpx_track_type_id;
		gpx_track_type_id = g_type_register_static (G_TYPE_OBJECT, "GpxTrack", &g_define_type_info, 0);
		g_once_init_leave (&gpx_track_type_id__volatile, gpx_track_type_id);
	}
	return gpx_track_type_id__volatile;
}


static void _vala_gpx_track_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GpxTrack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_TRACK, GpxTrack);
	switch (property_id) {
		case GPX_TRACK_NAME:
		g_value_set_string (value, gpx_track_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gpx_track_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GpxTrack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_TRACK, GpxTrack);
	switch (property_id) {
		case GPX_TRACK_NAME:
		gpx_track_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GQuark gpx_file_error_quark (void) {
	return g_quark_from_static_string ("gpx_file_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


/**
         * Helpers
         */
gchar* gpx_file_base_get_uri (GpxFileBase* self) {
	gchar* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* gpx_file_base_get_basename (GpxFileBase* self) {
	gchar* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	result = _tmp1_;
	return result;
}


/** 
         * Accessors
         */
GList* gpx_file_base_get_tracks (GpxFileBase* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tracks;
	result = _tmp0_;
	return result;
}


GList* gpx_file_base_get_waypoints (GpxFileBase* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->waypoints;
	result = _tmp0_;
	return result;
}


GList* gpx_file_base_get_routes (GpxFileBase* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->routes;
	result = _tmp0_;
	return result;
}


GpxFileBase* gpx_file_base_construct (GType object_type) {
	GpxFileBase * self = NULL;
	self = (GpxFileBase*) g_object_new (object_type, NULL);
	return self;
}


static void gpx_file_base_class_init (GpxFileBaseClass * klass) {
	gpx_file_base_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gpx_file_base_finalize;
}


static void gpx_file_base_instance_init (GpxFileBase * self) {
	self->tracks = NULL;
	self->waypoints = NULL;
	self->routes = NULL;
	self->file = NULL;
}


static void gpx_file_base_finalize (GObject* obj) {
	GpxFileBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_FILE_BASE, GpxFileBase);
	__g_list_free__g_object_unref0_0 (self->tracks);
	__g_list_free__gpx_point_unref0_0 (self->waypoints);
	__g_list_free__g_object_unref0_0 (self->routes);
	_g_object_unref0 (self->file);
	G_OBJECT_CLASS (gpx_file_base_parent_class)->finalize (obj);
}


/**
     * This is the top level class representing the gpx file it self.
     * This contains a list of tracks and waypoints.
     */
GType gpx_file_base_get_type (void) {
	static volatile gsize gpx_file_base_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_file_base_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpxFileBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_file_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxFileBase), 0, (GInstanceInitFunc) gpx_file_base_instance_init, NULL };
		GType gpx_file_base_type_id;
		gpx_file_base_type_id = g_type_register_static (G_TYPE_OBJECT, "GpxFileBase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gpx_file_base_type_id__volatile, gpx_file_base_type_id);
	}
	return gpx_file_base_type_id__volatile;
}


/**
     * @param file A GLib.File to open.
     * 
     * Tries to open the file.. check extension, if that fails, try it.
     *
     * @returns a file.
     * @throws a FileError
     */
GpxFileBase* gpx_file_open (GFile* path, GError** error) {
	GpxFileBase* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	{
		GFile* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		GFile* _tmp15_;
		GpxFitFile* _tmp16_;
		GpxFileBase* f;
		_tmp0_ = path;
		_tmp1_ = g_file_get_uri (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_str_has_suffix (_tmp2_, "fit");
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		if (_tmp4_) {
			GFile* _tmp5_;
			GpxFitFile* _tmp6_;
			GpxFitFile* _tmp7_;
			_tmp5_ = path;
			_tmp6_ = gpx_fit_file_new (_tmp5_, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			result = (GpxFileBase*) _tmp7_;
			return result;
		}
		_tmp8_ = path;
		_tmp9_ = g_file_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_str_has_suffix (_tmp10_, "gpx");
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		if (_tmp12_) {
			GFile* _tmp13_;
			GpxXmlFile* _tmp14_;
			_tmp13_ = path;
			_tmp14_ = gpx_xml_file_new (_tmp13_);
			result = (GpxFileBase*) _tmp14_;
			return result;
		}
		_tmp15_ = path;
		_tmp16_ = gpx_fit_file_new (_tmp15_, &_inner_error_);
		f = (GpxFileBase*) _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		result = f;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp17_;
		GpxXmlFile* _tmp18_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = path;
		_tmp18_ = gpx_xml_file_new (_tmp17_);
		result = (GpxFileBase*) _tmp18_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (_inner_error_->domain == GPX_FILE_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}



