// Code generated by optgen; DO NOT EDIT.

package memo

import (
	"unsafe"

	"github.com/cockroachdb/cockroach/pkg/sql/coltypes"
	"github.com/cockroachdb/cockroach/pkg/sql/opt"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/constraint"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/props"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/props/physical"
	"github.com/cockroachdb/cockroach/pkg/sql/pgwire/pgerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/types"
)

// SortExpr enforces the ordering of rows returned by its input expression. Rows can
// be sorted by one or more of the input columns, each of which can be sorted in
// either ascending or descending order. See the Ordering field in the
// PhysicalProps struct.
type SortExpr struct {
	Input RelExpr
	best  bestProps
}

func (e *SortExpr) Op() opt.Operator {
	return opt.SortOp
}

func (e *SortExpr) ChildCount() int {
	return 1
}

func (e *SortExpr) Child(nth int) opt.Expr {
	if nth == 0 {
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SortExpr) Private() interface{} {
	return nil
}

func (e *SortExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SortExpr) SetChild(nth int, child opt.Expr) {
	if nth == 0 {
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SortExpr) Memo() *Memo {
	return e.Input.Memo()
}

func (e *SortExpr) Relational() *props.Relational {
	return e.Input.Relational()
}

func (e *SortExpr) FirstExpr() RelExpr {
	return e.Input.FirstExpr()
}

func (e *SortExpr) NextExpr() RelExpr {
	return nil
}

func (e *SortExpr) RequiredPhysical() *physical.Required {
	return e.best.required
}

func (e *SortExpr) ProvidedPhysical() *physical.Provided {
	return &e.best.provided
}

func (e *SortExpr) Cost() Cost {
	return e.best.cost
}

func (e *SortExpr) bestProps() *bestProps {
	return &e.best
}

func (e *SortExpr) group() exprGroup {
	return e.Input.group()
}

func (e *SortExpr) setNext(member RelExpr) {
	panic(pgerror.NewAssertionErrorf("setNext cannot be called on enforcers"))
}

func (e *SortExpr) setGroup(member exprGroup) {
	panic(pgerror.NewAssertionErrorf("setGroup cannot be called on enforcers"))
}

// ScanExpr returns a result set containing every row in a table by scanning one of
// the table's indexes according to its ordering. The ScanPrivate field
// identifies the table and index to scan, as well as the subset of columns to
// project from it.
//
// The scan can be constrained and/or have an internal row limit. A scan can be
// executed either as a forward or as a reverse scan (except when it has a limit,
// in which case the direction is fixed).
type ScanExpr struct {
	ScanPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ScanExpr{}

func (e *ScanExpr) Op() opt.Operator {
	return opt.ScanOp
}

func (e *ScanExpr) ChildCount() int {
	return 0
}

func (e *ScanExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ScanExpr) Private() interface{} {
	return &e.ScanPrivate
}

func (e *ScanExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ScanExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ScanExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ScanExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ScanExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ScanExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ScanExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ScanExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ScanExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ScanExpr) group() exprGroup {
	return e.grp
}

func (e *ScanExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ScanExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ScanExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type scanGroup struct {
	mem   *Memo
	rel   props.Relational
	first ScanExpr
	best  bestProps
}

var _ exprGroup = &scanGroup{}

func (g *scanGroup) memo() *Memo {
	return g.mem
}

func (g *scanGroup) relational() *props.Relational {
	return &g.rel
}

func (g *scanGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *scanGroup) bestProps() *bestProps {
	return &g.best
}

type ScanPrivate struct {
	// Table identifies the table to scan. It is an id that can be passed to
	// the Metadata.Table method in order to fetch cat.Table metadata.
	Table opt.TableID

	// Index identifies the index to scan (whether primary or secondary). It
	// can be passed to the cat.Table.Index(i int) method in order to fetch the
	// cat.Index metadata.
	Index int

	// Cols specifies the set of columns that the scan operator projects. This
	// may be a subset of the columns that the table/index contains.
	Cols opt.ColSet

	// If set, the scan is a constrained scan; the constraint contains the spans
	// that need to be scanned.
	Constraint *constraint.Constraint

	// HardLimit specifies the maximum number of rows that the scan can return
	// (after applying any constraint), as well as the required scan direction.
	// This is a "hard" limit, meaning that the scan operator must never return
	// more than this number of rows, even if more are available. If its value is
	// zero, then the limit is unknown, and the scan should return all available
	// rows.
	HardLimit ScanLimit

	// Flags modify how the table is scanned, such as which index is used to scan.
	Flags ScanFlags
}

// VirtualScanExpr returns a result set containing every row in a virtual table.
// Virtual tables are system tables that are populated "on the fly" with rows
// synthesized from system metadata and other state. An example is the
// "information_schema.tables" virtual table which returns one row for each
// accessible system or user table.
//
// VirtualScan has many of the same characteristics as the Scan operator.
// However, virtual tables do not have indexes or keys, and the physical operator
// used to scan virtual tables does not support limits or constraints. Therefore,
// nearly all the rules that apply to Scan do not apply to VirtualScan, so it
// makes sense to have a separate operator.
type VirtualScanExpr struct {
	VirtualScanPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &VirtualScanExpr{}

func (e *VirtualScanExpr) Op() opt.Operator {
	return opt.VirtualScanOp
}

func (e *VirtualScanExpr) ChildCount() int {
	return 0
}

func (e *VirtualScanExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *VirtualScanExpr) Private() interface{} {
	return &e.VirtualScanPrivate
}

func (e *VirtualScanExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *VirtualScanExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *VirtualScanExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *VirtualScanExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *VirtualScanExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *VirtualScanExpr) NextExpr() RelExpr {
	return e.next
}

func (e *VirtualScanExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *VirtualScanExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *VirtualScanExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *VirtualScanExpr) group() exprGroup {
	return e.grp
}

func (e *VirtualScanExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *VirtualScanExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *VirtualScanExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type virtualScanGroup struct {
	mem   *Memo
	rel   props.Relational
	first VirtualScanExpr
	best  bestProps
}

var _ exprGroup = &virtualScanGroup{}

func (g *virtualScanGroup) memo() *Memo {
	return g.mem
}

func (g *virtualScanGroup) relational() *props.Relational {
	return &g.rel
}

func (g *virtualScanGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *virtualScanGroup) bestProps() *bestProps {
	return &g.best
}

type VirtualScanPrivate struct {
	// Table identifies the virtual table to synthesize and scan. It is an id
	// that can be passed to the Metadata.Table method in order to fetch
	// cat.Table metadata.
	Table opt.TableID

	// Cols specifies the set of columns that the VirtualScan operator projects.
	// This is always every column in the virtual table (i.e. never a subset even
	// if all columns are not needed).
	Cols opt.ColSet
}

// SequenceSelectExpr represents a read from a sequence as a data source. It always returns
// three columns, last_value, log_cnt, and is_called, with a single row. last_value is
// the most recent value returned from the sequence and log_cnt and is_called are
// always 0 and true, respectively.
type SequenceSelectExpr struct {
	SequenceSelectPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &SequenceSelectExpr{}

func (e *SequenceSelectExpr) Op() opt.Operator {
	return opt.SequenceSelectOp
}

func (e *SequenceSelectExpr) ChildCount() int {
	return 0
}

func (e *SequenceSelectExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SequenceSelectExpr) Private() interface{} {
	return &e.SequenceSelectPrivate
}

func (e *SequenceSelectExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SequenceSelectExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SequenceSelectExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *SequenceSelectExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *SequenceSelectExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *SequenceSelectExpr) NextExpr() RelExpr {
	return e.next
}

func (e *SequenceSelectExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *SequenceSelectExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *SequenceSelectExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *SequenceSelectExpr) group() exprGroup {
	return e.grp
}

func (e *SequenceSelectExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *SequenceSelectExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *SequenceSelectExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type sequenceSelectGroup struct {
	mem   *Memo
	rel   props.Relational
	first SequenceSelectExpr
	best  bestProps
}

var _ exprGroup = &sequenceSelectGroup{}

func (g *sequenceSelectGroup) memo() *Memo {
	return g.mem
}

func (g *sequenceSelectGroup) relational() *props.Relational {
	return &g.rel
}

func (g *sequenceSelectGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *sequenceSelectGroup) bestProps() *bestProps {
	return &g.best
}

type SequenceSelectPrivate struct {
	// Sequence identifies the sequence to read from.
	Sequence opt.SequenceID

	// Cols is the 3 element list of column IDs returned by the operator.
	Cols opt.ColList
}

// ValuesExpr returns a manufactured result set containing a constant number of rows.
// specified by the Rows list field. Each row must contain the same set of
// columns in the same order.
//
// The Rows field contains a list of Tuples, one for each row. Each tuple has
// the same length (same with that of Cols).
//
// The Cols field contains the set of column indices returned by each row
// as an opt.ColList. It is legal for Cols to be empty.
type ValuesExpr struct {
	Rows ScalarListExpr
	ValuesPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ValuesExpr{}

func (e *ValuesExpr) Op() opt.Operator {
	return opt.ValuesOp
}

func (e *ValuesExpr) ChildCount() int {
	return 1
}

func (e *ValuesExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return &e.Rows
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ValuesExpr) Private() interface{} {
	return &e.ValuesPrivate
}

func (e *ValuesExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ValuesExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Rows = *child.(*ScalarListExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ValuesExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ValuesExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ValuesExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ValuesExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ValuesExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ValuesExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ValuesExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ValuesExpr) group() exprGroup {
	return e.grp
}

func (e *ValuesExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ValuesExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ValuesExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type valuesGroup struct {
	mem   *Memo
	rel   props.Relational
	first ValuesExpr
	best  bestProps
}

var _ exprGroup = &valuesGroup{}

func (g *valuesGroup) memo() *Memo {
	return g.mem
}

func (g *valuesGroup) relational() *props.Relational {
	return &g.rel
}

func (g *valuesGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *valuesGroup) bestProps() *bestProps {
	return &g.best
}

type ValuesPrivate struct {
	Cols opt.ColList

	// ID is a memo-unique identifier which distinguishes between identical
	// Values expressions which appear in different places in the query. In most
	// cases the column set is sufficient to do this, but various rules make it
	// possible to construct Values expressions with no columns.
	ID opt.ValuesID
}

// SelectExpr filters rows from its input result set, based on the boolean filter
// predicate expression. Rows which do not match the filter are discarded. While
// the Filter operand can be any boolean expression, normalization rules will
// typically convert it to a Filters operator in order to make conjunction list
// matching easier.
type SelectExpr struct {
	Input   RelExpr
	Filters FiltersExpr

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &SelectExpr{}

func (e *SelectExpr) Op() opt.Operator {
	return opt.SelectOp
}

func (e *SelectExpr) ChildCount() int {
	return 2
}

func (e *SelectExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Filters
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SelectExpr) Private() interface{} {
	return nil
}

func (e *SelectExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SelectExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Filters = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SelectExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *SelectExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *SelectExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *SelectExpr) NextExpr() RelExpr {
	return e.next
}

func (e *SelectExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *SelectExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *SelectExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *SelectExpr) group() exprGroup {
	return e.grp
}

func (e *SelectExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *SelectExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *SelectExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type selectGroup struct {
	mem   *Memo
	rel   props.Relational
	first SelectExpr
	best  bestProps
}

var _ exprGroup = &selectGroup{}

func (g *selectGroup) memo() *Memo {
	return g.mem
}

func (g *selectGroup) relational() *props.Relational {
	return &g.rel
}

func (g *selectGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *selectGroup) bestProps() *bestProps {
	return &g.best
}

// ProjectExpr modifies the set of columns returned by the input result set. Columns
// can be removed, reordered, or renamed. In addition, new columns can be
// synthesized.
//
// Projections describes the synthesized columns constructed by Project, and
// Passthrough describes the input columns that are passed through as Project
// output columns.
type ProjectExpr struct {
	Input       RelExpr
	Projections ProjectionsExpr
	Passthrough opt.ColSet

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ProjectExpr{}

func (e *ProjectExpr) Op() opt.Operator {
	return opt.ProjectOp
}

func (e *ProjectExpr) ChildCount() int {
	return 2
}

func (e *ProjectExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Projections
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ProjectExpr) Private() interface{} {
	return &e.Passthrough
}

func (e *ProjectExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ProjectExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Projections = *child.(*ProjectionsExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ProjectExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ProjectExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ProjectExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ProjectExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ProjectExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ProjectExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ProjectExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ProjectExpr) group() exprGroup {
	return e.grp
}

func (e *ProjectExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ProjectExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ProjectExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type projectGroup struct {
	mem   *Memo
	rel   props.Relational
	first ProjectExpr
	best  bestProps
}

var _ exprGroup = &projectGroup{}

func (g *projectGroup) memo() *Memo {
	return g.mem
}

func (g *projectGroup) relational() *props.Relational {
	return &g.rel
}

func (g *projectGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *projectGroup) bestProps() *bestProps {
	return &g.best
}

// InnerJoinExpr creates a result set that combines columns from its left and right
// inputs, based upon its "on" join predicate. Rows which do not match the
// predicate are filtered. While expressions in the predicate can refer to
// columns projected by either the left or right inputs, the inputs are not
// allowed to refer to the other's projected columns.
type InnerJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &InnerJoinExpr{}

func (e *InnerJoinExpr) Op() opt.Operator {
	return opt.InnerJoinOp
}

func (e *InnerJoinExpr) ChildCount() int {
	return 3
}

func (e *InnerJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InnerJoinExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *InnerJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *InnerJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InnerJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *InnerJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *InnerJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *InnerJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *InnerJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *InnerJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *InnerJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *InnerJoinExpr) group() exprGroup {
	return e.grp
}

func (e *InnerJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *InnerJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *InnerJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type innerJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first InnerJoinExpr
	best  bestProps
}

var _ exprGroup = &innerJoinGroup{}

func (g *innerJoinGroup) memo() *Memo {
	return g.mem
}

func (g *innerJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *innerJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *innerJoinGroup) bestProps() *bestProps {
	return &g.best
}

type LeftJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &LeftJoinExpr{}

func (e *LeftJoinExpr) Op() opt.Operator {
	return opt.LeftJoinOp
}

func (e *LeftJoinExpr) ChildCount() int {
	return 3
}

func (e *LeftJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LeftJoinExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *LeftJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LeftJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LeftJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *LeftJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *LeftJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *LeftJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *LeftJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *LeftJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *LeftJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *LeftJoinExpr) group() exprGroup {
	return e.grp
}

func (e *LeftJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *LeftJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *LeftJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type leftJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first LeftJoinExpr
	best  bestProps
}

var _ exprGroup = &leftJoinGroup{}

func (g *leftJoinGroup) memo() *Memo {
	return g.mem
}

func (g *leftJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *leftJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *leftJoinGroup) bestProps() *bestProps {
	return &g.best
}

type RightJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &RightJoinExpr{}

func (e *RightJoinExpr) Op() opt.Operator {
	return opt.RightJoinOp
}

func (e *RightJoinExpr) ChildCount() int {
	return 3
}

func (e *RightJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RightJoinExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *RightJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RightJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RightJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *RightJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *RightJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *RightJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *RightJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *RightJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *RightJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *RightJoinExpr) group() exprGroup {
	return e.grp
}

func (e *RightJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *RightJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *RightJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type rightJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first RightJoinExpr
	best  bestProps
}

var _ exprGroup = &rightJoinGroup{}

func (g *rightJoinGroup) memo() *Memo {
	return g.mem
}

func (g *rightJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *rightJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *rightJoinGroup) bestProps() *bestProps {
	return &g.best
}

type FullJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &FullJoinExpr{}

func (e *FullJoinExpr) Op() opt.Operator {
	return opt.FullJoinOp
}

func (e *FullJoinExpr) ChildCount() int {
	return 3
}

func (e *FullJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FullJoinExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *FullJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FullJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FullJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *FullJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *FullJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *FullJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *FullJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *FullJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *FullJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *FullJoinExpr) group() exprGroup {
	return e.grp
}

func (e *FullJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *FullJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *FullJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type fullJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first FullJoinExpr
	best  bestProps
}

var _ exprGroup = &fullJoinGroup{}

func (g *fullJoinGroup) memo() *Memo {
	return g.mem
}

func (g *fullJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *fullJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *fullJoinGroup) bestProps() *bestProps {
	return &g.best
}

type SemiJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &SemiJoinExpr{}

func (e *SemiJoinExpr) Op() opt.Operator {
	return opt.SemiJoinOp
}

func (e *SemiJoinExpr) ChildCount() int {
	return 3
}

func (e *SemiJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SemiJoinExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *SemiJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SemiJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SemiJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *SemiJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *SemiJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *SemiJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *SemiJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *SemiJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *SemiJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *SemiJoinExpr) group() exprGroup {
	return e.grp
}

func (e *SemiJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *SemiJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *SemiJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type semiJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first SemiJoinExpr
	best  bestProps
}

var _ exprGroup = &semiJoinGroup{}

func (g *semiJoinGroup) memo() *Memo {
	return g.mem
}

func (g *semiJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *semiJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *semiJoinGroup) bestProps() *bestProps {
	return &g.best
}

type AntiJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &AntiJoinExpr{}

func (e *AntiJoinExpr) Op() opt.Operator {
	return opt.AntiJoinOp
}

func (e *AntiJoinExpr) ChildCount() int {
	return 3
}

func (e *AntiJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AntiJoinExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *AntiJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AntiJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AntiJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *AntiJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *AntiJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *AntiJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *AntiJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *AntiJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *AntiJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *AntiJoinExpr) group() exprGroup {
	return e.grp
}

func (e *AntiJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *AntiJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *AntiJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type antiJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first AntiJoinExpr
	best  bestProps
}

var _ exprGroup = &antiJoinGroup{}

func (g *antiJoinGroup) memo() *Memo {
	return g.mem
}

func (g *antiJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *antiJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *antiJoinGroup) bestProps() *bestProps {
	return &g.best
}

// JoinPrivate is shared between the various join operators including apply
// variants, but excluding IndexJoin, LookupJoin, MergeJoin.
type JoinPrivate struct {
	// Flags modify what type of join we choose.
	Flags JoinFlags
}

// IndexJoinExpr represents an inner join between an input expression and a primary
// index. It is a special case of LookupJoin where the input columns are the PK
// columns of the table we are looking up into, and every input row results in
// exactly one output row.
//
// IndexJoin operators are created from Scan operators (unlike lookup joins which
// are created from Join operators).
type IndexJoinExpr struct {
	Input RelExpr
	IndexJoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &IndexJoinExpr{}

func (e *IndexJoinExpr) Op() opt.Operator {
	return opt.IndexJoinOp
}

func (e *IndexJoinExpr) ChildCount() int {
	return 1
}

func (e *IndexJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IndexJoinExpr) Private() interface{} {
	return &e.IndexJoinPrivate
}

func (e *IndexJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IndexJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IndexJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *IndexJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *IndexJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *IndexJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *IndexJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *IndexJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *IndexJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *IndexJoinExpr) group() exprGroup {
	return e.grp
}

func (e *IndexJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *IndexJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *IndexJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type indexJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first IndexJoinExpr
	best  bestProps
}

var _ exprGroup = &indexJoinGroup{}

func (g *indexJoinGroup) memo() *Memo {
	return g.mem
}

func (g *indexJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *indexJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *indexJoinGroup) bestProps() *bestProps {
	return &g.best
}

type IndexJoinPrivate struct {
	// Table identifies the table to do lookups in. The primary index is
	// currently the only index used.
	Table opt.TableID

	// Cols specifies the set of columns that the index join operator projects.
	// This may be a subset of the columns that the table contains.
	Cols opt.ColSet
}

// LookupJoinExpr represents a join between an input expression and an index. The
// type of join is in the LookupJoinPrivate field.
type LookupJoinExpr struct {
	Input RelExpr
	On    FiltersExpr
	LookupJoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &LookupJoinExpr{}

func (e *LookupJoinExpr) Op() opt.Operator {
	return opt.LookupJoinOp
}

func (e *LookupJoinExpr) ChildCount() int {
	return 2
}

func (e *LookupJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LookupJoinExpr) Private() interface{} {
	return &e.LookupJoinPrivate
}

func (e *LookupJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LookupJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LookupJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *LookupJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *LookupJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *LookupJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *LookupJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *LookupJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *LookupJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *LookupJoinExpr) group() exprGroup {
	return e.grp
}

func (e *LookupJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *LookupJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *LookupJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type lookupJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first LookupJoinExpr
	best  bestProps
}

var _ exprGroup = &lookupJoinGroup{}

func (g *lookupJoinGroup) memo() *Memo {
	return g.mem
}

func (g *lookupJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *lookupJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *lookupJoinGroup) bestProps() *bestProps {
	return &g.best
}

type LookupJoinPrivate struct {
	// JoinType is InnerJoin or LeftJoin.
	// TODO(radu): support SemiJoin, AntiJoin.
	JoinType opt.Operator

	// Table identifies the table do to lookups in.
	Table opt.TableID

	// Index identifies the index to do lookups in (whether primary or secondary).
	// It can be passed to the cat.Table.Index(i int) method in order to fetch the
	// cat.Index metadata.
	Index int

	// KeyCols are the columns (produced by the input) used to create lookup keys.
	// The key columns must be non-empty, and are listed in the same order as the
	// index columns (or a prefix of them).
	KeyCols opt.ColList

	// Cols is the set of columns produced by the lookup join. This set can
	// contain columns from the input and columns from the index. Any columns not
	// in the input are retrieved from the index. Cols may not contain some or
	// all of the KeyCols, if they are not output columns for the join.
	//
	// TODO(radu): this effectively allows an arbitrary projection; it should be
	// just a LookupCols set indicating which columns we should add from the
	// index. However, this requires extra Project operators in the lookup join
	// exploration transforms which currently leads to problems related to lookup
	// join statistics.
	Cols opt.ColSet

	// lookupProps caches relational properties for the "table" side of the lookup
	// join, treating it as if it were another relational input. This makes the
	// lookup join appear more like other join operators.
	lookupProps props.Relational
	JoinPrivate
}

// MergeJoinExpr represents a join that is executed using merge-join.
// MergeOn is a scalar which contains the ON condition and merge-join ordering
// information; see the MergeOn scalar operator.
// It can be any type of join (identified in the MergeJoinPrivate field).
type MergeJoinExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	MergeJoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &MergeJoinExpr{}

func (e *MergeJoinExpr) Op() opt.Operator {
	return opt.MergeJoinOp
}

func (e *MergeJoinExpr) ChildCount() int {
	return 3
}

func (e *MergeJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MergeJoinExpr) Private() interface{} {
	return &e.MergeJoinPrivate
}

func (e *MergeJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *MergeJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MergeJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *MergeJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *MergeJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *MergeJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *MergeJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *MergeJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *MergeJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *MergeJoinExpr) group() exprGroup {
	return e.grp
}

func (e *MergeJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *MergeJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *MergeJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type mergeJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first MergeJoinExpr
	best  bestProps
}

var _ exprGroup = &mergeJoinGroup{}

func (g *mergeJoinGroup) memo() *Memo {
	return g.mem
}

func (g *mergeJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *mergeJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *mergeJoinGroup) bestProps() *bestProps {
	return &g.best
}

type MergeJoinPrivate struct {
	// JoinType is one of the basic join operators: InnerJoin, LeftJoin,
	// RightJoin, FullJoin, SemiJoin, AntiJoin.
	JoinType opt.Operator

	// LeftEq and RightEq are orderings on equality columns. They have the same
	// length and LeftEq[i] is a column on the left side which is constrained to
	// be equal to RightEq[i] on the right side. The directions also have to
	// match.
	//
	// Examples of valid settings for abc JOIN def ON a=d,b=e:
	//   LeftEq: a+,b+   RightEq: d+,e+
	//   LeftEq: b-,a+   RightEq: e-,d+
	LeftEq  opt.Ordering
	RightEq opt.Ordering

	// LeftOrdering and RightOrdering are "simplified" versions of LeftEq/RightEq,
	// taking into account the functional dependencies of each side. We need both
	// versions because we need to configure execution with specific equality
	// columns and orderings.
	LeftOrdering  physical.OrderingChoice
	RightOrdering physical.OrderingChoice
	JoinPrivate
}

// ZigzagJoinExpr represents a join that is executed using the zigzag joiner.
// All fields except for the ON expression are stored in the private;
// since the zigzag joiner operates directly on indexes and doesn't
// support arbitrary inputs.
//
// TODO(itsbilal): Add support for representing multi-way zigzag joins.
type ZigzagJoinExpr struct {
	On FiltersExpr
	ZigzagJoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ZigzagJoinExpr{}

func (e *ZigzagJoinExpr) Op() opt.Operator {
	return opt.ZigzagJoinOp
}

func (e *ZigzagJoinExpr) ChildCount() int {
	return 1
}

func (e *ZigzagJoinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ZigzagJoinExpr) Private() interface{} {
	return &e.ZigzagJoinPrivate
}

func (e *ZigzagJoinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ZigzagJoinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ZigzagJoinExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ZigzagJoinExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ZigzagJoinExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ZigzagJoinExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ZigzagJoinExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ZigzagJoinExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ZigzagJoinExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ZigzagJoinExpr) group() exprGroup {
	return e.grp
}

func (e *ZigzagJoinExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ZigzagJoinExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ZigzagJoinExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type zigzagJoinGroup struct {
	mem   *Memo
	rel   props.Relational
	first ZigzagJoinExpr
	best  bestProps
}

var _ exprGroup = &zigzagJoinGroup{}

func (g *zigzagJoinGroup) memo() *Memo {
	return g.mem
}

func (g *zigzagJoinGroup) relational() *props.Relational {
	return &g.rel
}

func (g *zigzagJoinGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *zigzagJoinGroup) bestProps() *bestProps {
	return &g.best
}

type ZigzagJoinPrivate struct {
	// LeftTable and RightTable identifies the left and right tables for this
	// join.
	LeftTable  opt.TableID
	RightTable opt.TableID

	// LeftIndex and RightIndex identifies the index to do lookups in (whether
	// primary or secondary). It can be passed to the cat.Table.Index(i int)
	// method in order to fetch the cat.Index metadata.
	LeftIndex  int
	RightIndex int

	// LeftEqCols and RightEqCols contains lists of columns on the left and
	// right sides that are being equated. Both lists must be of equal length.
	LeftEqCols  opt.ColList
	RightEqCols opt.ColList

	// FixedVals, LeftFixedCols and RightFixedCols reference fixed values.
	// Fixed values are constants that constrain each index' prefix columns
	// (the ones denoted in {Left,Right}FixedCols). These fixed columns must
	// lie at the start of the index and must immediately precede EqCols.
	//
	// FixedVals is a list of 2 tuples, each representing one side's fixed
	// values.
	//
	// Read the comment in pkg/sql/distsqlrun/zigzagjoiner.go for more on
	// fixed and equality columns.
	FixedVals      ScalarListExpr
	LeftFixedCols  opt.ColList
	RightFixedCols opt.ColList

	// Cols is the set of columns produced by the zigzag join. This set can
	// contain columns from either side's index.
	Cols opt.ColSet

	// leftProps and rightProps cache relational properties corresponding to an
	// unconstrained scan on the respective indexes. By putting this in the
	// expr, zigzag joins can reuse a lot of the logical property building code
	// for joins.
	leftProps  props.Relational
	rightProps props.Relational
}

// InnerJoinApplyExpr has the same join semantics as InnerJoin. However, unlike
// InnerJoin, it allows the right input to refer to columns projected by the
// left input.
type InnerJoinApplyExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &InnerJoinApplyExpr{}

func (e *InnerJoinApplyExpr) Op() opt.Operator {
	return opt.InnerJoinApplyOp
}

func (e *InnerJoinApplyExpr) ChildCount() int {
	return 3
}

func (e *InnerJoinApplyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InnerJoinApplyExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *InnerJoinApplyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *InnerJoinApplyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InnerJoinApplyExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *InnerJoinApplyExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *InnerJoinApplyExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *InnerJoinApplyExpr) NextExpr() RelExpr {
	return e.next
}

func (e *InnerJoinApplyExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *InnerJoinApplyExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *InnerJoinApplyExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *InnerJoinApplyExpr) group() exprGroup {
	return e.grp
}

func (e *InnerJoinApplyExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *InnerJoinApplyExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *InnerJoinApplyExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type innerJoinApplyGroup struct {
	mem   *Memo
	rel   props.Relational
	first InnerJoinApplyExpr
	best  bestProps
}

var _ exprGroup = &innerJoinApplyGroup{}

func (g *innerJoinApplyGroup) memo() *Memo {
	return g.mem
}

func (g *innerJoinApplyGroup) relational() *props.Relational {
	return &g.rel
}

func (g *innerJoinApplyGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *innerJoinApplyGroup) bestProps() *bestProps {
	return &g.best
}

type LeftJoinApplyExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &LeftJoinApplyExpr{}

func (e *LeftJoinApplyExpr) Op() opt.Operator {
	return opt.LeftJoinApplyOp
}

func (e *LeftJoinApplyExpr) ChildCount() int {
	return 3
}

func (e *LeftJoinApplyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LeftJoinApplyExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *LeftJoinApplyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LeftJoinApplyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LeftJoinApplyExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *LeftJoinApplyExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *LeftJoinApplyExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *LeftJoinApplyExpr) NextExpr() RelExpr {
	return e.next
}

func (e *LeftJoinApplyExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *LeftJoinApplyExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *LeftJoinApplyExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *LeftJoinApplyExpr) group() exprGroup {
	return e.grp
}

func (e *LeftJoinApplyExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *LeftJoinApplyExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *LeftJoinApplyExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type leftJoinApplyGroup struct {
	mem   *Memo
	rel   props.Relational
	first LeftJoinApplyExpr
	best  bestProps
}

var _ exprGroup = &leftJoinApplyGroup{}

func (g *leftJoinApplyGroup) memo() *Memo {
	return g.mem
}

func (g *leftJoinApplyGroup) relational() *props.Relational {
	return &g.rel
}

func (g *leftJoinApplyGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *leftJoinApplyGroup) bestProps() *bestProps {
	return &g.best
}

type RightJoinApplyExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &RightJoinApplyExpr{}

func (e *RightJoinApplyExpr) Op() opt.Operator {
	return opt.RightJoinApplyOp
}

func (e *RightJoinApplyExpr) ChildCount() int {
	return 3
}

func (e *RightJoinApplyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RightJoinApplyExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *RightJoinApplyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RightJoinApplyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RightJoinApplyExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *RightJoinApplyExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *RightJoinApplyExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *RightJoinApplyExpr) NextExpr() RelExpr {
	return e.next
}

func (e *RightJoinApplyExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *RightJoinApplyExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *RightJoinApplyExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *RightJoinApplyExpr) group() exprGroup {
	return e.grp
}

func (e *RightJoinApplyExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *RightJoinApplyExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *RightJoinApplyExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type rightJoinApplyGroup struct {
	mem   *Memo
	rel   props.Relational
	first RightJoinApplyExpr
	best  bestProps
}

var _ exprGroup = &rightJoinApplyGroup{}

func (g *rightJoinApplyGroup) memo() *Memo {
	return g.mem
}

func (g *rightJoinApplyGroup) relational() *props.Relational {
	return &g.rel
}

func (g *rightJoinApplyGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *rightJoinApplyGroup) bestProps() *bestProps {
	return &g.best
}

type FullJoinApplyExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &FullJoinApplyExpr{}

func (e *FullJoinApplyExpr) Op() opt.Operator {
	return opt.FullJoinApplyOp
}

func (e *FullJoinApplyExpr) ChildCount() int {
	return 3
}

func (e *FullJoinApplyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FullJoinApplyExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *FullJoinApplyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FullJoinApplyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FullJoinApplyExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *FullJoinApplyExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *FullJoinApplyExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *FullJoinApplyExpr) NextExpr() RelExpr {
	return e.next
}

func (e *FullJoinApplyExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *FullJoinApplyExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *FullJoinApplyExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *FullJoinApplyExpr) group() exprGroup {
	return e.grp
}

func (e *FullJoinApplyExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *FullJoinApplyExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *FullJoinApplyExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type fullJoinApplyGroup struct {
	mem   *Memo
	rel   props.Relational
	first FullJoinApplyExpr
	best  bestProps
}

var _ exprGroup = &fullJoinApplyGroup{}

func (g *fullJoinApplyGroup) memo() *Memo {
	return g.mem
}

func (g *fullJoinApplyGroup) relational() *props.Relational {
	return &g.rel
}

func (g *fullJoinApplyGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *fullJoinApplyGroup) bestProps() *bestProps {
	return &g.best
}

type SemiJoinApplyExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &SemiJoinApplyExpr{}

func (e *SemiJoinApplyExpr) Op() opt.Operator {
	return opt.SemiJoinApplyOp
}

func (e *SemiJoinApplyExpr) ChildCount() int {
	return 3
}

func (e *SemiJoinApplyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SemiJoinApplyExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *SemiJoinApplyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SemiJoinApplyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SemiJoinApplyExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *SemiJoinApplyExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *SemiJoinApplyExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *SemiJoinApplyExpr) NextExpr() RelExpr {
	return e.next
}

func (e *SemiJoinApplyExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *SemiJoinApplyExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *SemiJoinApplyExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *SemiJoinApplyExpr) group() exprGroup {
	return e.grp
}

func (e *SemiJoinApplyExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *SemiJoinApplyExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *SemiJoinApplyExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type semiJoinApplyGroup struct {
	mem   *Memo
	rel   props.Relational
	first SemiJoinApplyExpr
	best  bestProps
}

var _ exprGroup = &semiJoinApplyGroup{}

func (g *semiJoinApplyGroup) memo() *Memo {
	return g.mem
}

func (g *semiJoinApplyGroup) relational() *props.Relational {
	return &g.rel
}

func (g *semiJoinApplyGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *semiJoinApplyGroup) bestProps() *bestProps {
	return &g.best
}

type AntiJoinApplyExpr struct {
	Left  RelExpr
	Right RelExpr
	On    FiltersExpr
	JoinPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &AntiJoinApplyExpr{}

func (e *AntiJoinApplyExpr) Op() opt.Operator {
	return opt.AntiJoinApplyOp
}

func (e *AntiJoinApplyExpr) ChildCount() int {
	return 3
}

func (e *AntiJoinApplyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	case 2:
		return &e.On
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AntiJoinApplyExpr) Private() interface{} {
	return &e.JoinPrivate
}

func (e *AntiJoinApplyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AntiJoinApplyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	case 2:
		e.On = *child.(*FiltersExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AntiJoinApplyExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *AntiJoinApplyExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *AntiJoinApplyExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *AntiJoinApplyExpr) NextExpr() RelExpr {
	return e.next
}

func (e *AntiJoinApplyExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *AntiJoinApplyExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *AntiJoinApplyExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *AntiJoinApplyExpr) group() exprGroup {
	return e.grp
}

func (e *AntiJoinApplyExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *AntiJoinApplyExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *AntiJoinApplyExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type antiJoinApplyGroup struct {
	mem   *Memo
	rel   props.Relational
	first AntiJoinApplyExpr
	best  bestProps
}

var _ exprGroup = &antiJoinApplyGroup{}

func (g *antiJoinApplyGroup) memo() *Memo {
	return g.mem
}

func (g *antiJoinApplyGroup) relational() *props.Relational {
	return &g.rel
}

func (g *antiJoinApplyGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *antiJoinApplyGroup) bestProps() *bestProps {
	return &g.best
}

// GroupByExpr computes aggregate functions over groups of input rows. Input rows
// that are equal on the grouping columns are grouped together. The set of
// computed aggregate functions is described by the Aggregations field (which is
// always an Aggregations operator).
//
// The arguments of the aggregate functions are columns from the input
// (i.e. Variables), possibly wrapped in aggregate modifiers like AggDistinct.
//
// If the set of input rows is empty, then the output of the GroupBy operator
// will also be empty. If the grouping columns are empty, then all input rows
// form a single group. GroupBy is used for queries with aggregate functions,
// HAVING clauses and/or GROUP BY expressions.
//
// The GroupingPrivate field contains an ordering; this ordering is used to
// determine intra-group ordering and is only useful if there is an order-
// dependent aggregation (like ARRAY_AGG). Grouping columns are inconsequential
// in this ordering; we currently set all grouping columns as optional in this
// ordering (but note that this is not required by the operator).
type GroupByExpr struct {
	Input        RelExpr
	Aggregations AggregationsExpr
	GroupingPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &GroupByExpr{}

func (e *GroupByExpr) Op() opt.Operator {
	return opt.GroupByOp
}

func (e *GroupByExpr) ChildCount() int {
	return 2
}

func (e *GroupByExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Aggregations
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *GroupByExpr) Private() interface{} {
	return &e.GroupingPrivate
}

func (e *GroupByExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *GroupByExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Aggregations = *child.(*AggregationsExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *GroupByExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *GroupByExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *GroupByExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *GroupByExpr) NextExpr() RelExpr {
	return e.next
}

func (e *GroupByExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *GroupByExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *GroupByExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *GroupByExpr) group() exprGroup {
	return e.grp
}

func (e *GroupByExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *GroupByExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *GroupByExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type groupByGroup struct {
	mem   *Memo
	rel   props.Relational
	first GroupByExpr
	best  bestProps
}

var _ exprGroup = &groupByGroup{}

func (g *groupByGroup) memo() *Memo {
	return g.mem
}

func (g *groupByGroup) relational() *props.Relational {
	return &g.rel
}

func (g *groupByGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *groupByGroup) bestProps() *bestProps {
	return &g.best
}

// GroupingPrivate is shared between the grouping-related operators: GroupBy
// ScalarGroupBy, and DistinctOn. This allows the operators to be treated
// polymorphically.
type GroupingPrivate struct {
	// GroupingCols partitions the GroupBy input rows into aggregation groups.
	// All rows sharing the same values for these columns are in the same group.
	// GroupingCols is always empty in the ScalarGroupBy case.
	GroupingCols opt.ColSet

	// Ordering specifies the order required of the input. This order can intermix
	// grouping and non-grouping columns, serving a dual-purpose:
	//  - if we ignore grouping columns, it specifies an intra-group ordering (sort
	//    order of values within each group, useful for order-sensitive aggregation
	//    operators like ArrayAgg;
	//  - leading grouping columns specify an inter-group ordering, allowing for
	//    more efficient streaming execution.
	//
	// The canonical operation always contains an ordering that has no grouping
	// columns. Exploration rules can create versions of the operator with
	// orderings that contain grouping columns.
	Ordering physical.OrderingChoice
}

// ScalarGroupByExpr computes aggregate functions over the complete set of input
// rows. This is similar to GroupBy with empty grouping columns, where all input
// rows form a single group. However, there is an important difference. If the
// input set is empty, then the output of the ScalarGroupBy operator will have a
// single row containing default values for each aggregate function (typically
// null or zero, depending on the function). ScalarGroupBy always returns exactly
// one row - either the single-group aggregates or the default aggregate values.
//
// ScalarGroupBy uses the GroupingPrivate struct so that it's polymorphic with
// GroupBy and can be used in the same rules (when appropriate). In the
// ScalarGroupBy case, the grouping column field in GroupingPrivate is always
// empty.
type ScalarGroupByExpr struct {
	Input        RelExpr
	Aggregations AggregationsExpr
	GroupingPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ScalarGroupByExpr{}

func (e *ScalarGroupByExpr) Op() opt.Operator {
	return opt.ScalarGroupByOp
}

func (e *ScalarGroupByExpr) ChildCount() int {
	return 2
}

func (e *ScalarGroupByExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Aggregations
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ScalarGroupByExpr) Private() interface{} {
	return &e.GroupingPrivate
}

func (e *ScalarGroupByExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ScalarGroupByExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Aggregations = *child.(*AggregationsExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ScalarGroupByExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ScalarGroupByExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ScalarGroupByExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ScalarGroupByExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ScalarGroupByExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ScalarGroupByExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ScalarGroupByExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ScalarGroupByExpr) group() exprGroup {
	return e.grp
}

func (e *ScalarGroupByExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ScalarGroupByExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ScalarGroupByExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type scalarGroupByGroup struct {
	mem   *Memo
	rel   props.Relational
	first ScalarGroupByExpr
	best  bestProps
}

var _ exprGroup = &scalarGroupByGroup{}

func (g *scalarGroupByGroup) memo() *Memo {
	return g.mem
}

func (g *scalarGroupByGroup) relational() *props.Relational {
	return &g.rel
}

func (g *scalarGroupByGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *scalarGroupByGroup) bestProps() *bestProps {
	return &g.best
}

// DistinctOnExpr filters out rows that are identical on the set of grouping columns;
// only the first row (according to an ordering) is kept for each set of possible
// values. It is roughly equivalent with a GroupBy on the same grouping columns
// except that it uses FirstAgg functions that ensure the value on the first row
// is chosen (across all aggregations).
//
// In addition, the value on that first row must be chosen for all the grouping
// columns as well; this is relevant in the case of equal but non-identical
// values, like decimals. For example, if we have rows (1, 2.0) and (1.0, 2) and
// we are grouping on these two columns, the values output can be either (1, 2.0)
// or (1.0, 2), but not (1.0, 2.0).
//
// The execution of DistinctOn resembles that of Select more than that of
// GroupBy: each row is tested against a map of what groups we have seen already,
// and is either passed through or discarded. In particular, note that this
// preserves the input ordering.
//
// The ordering in the GroupingPrivate field will be required of the input; it
// determines which row can get "chosen" for each group of values on the grouping
// columns. There is no restriction on the ordering; but note that grouping
// columns are inconsequential - they can appear anywhere in the ordering and
// they won't change the results (other than the result ordering).
//
// Currently when we build DistinctOn, we set all grouping columns as optional
// cols in Ordering (but this is not required by the operator).
//
// TODO(radu): in the future we may want an exploration transform to try out more
// specific interesting orderings because execution is more efficient when we can
// rely on an ordering on the grouping columns (or a subset of them).
//
// DistinctOn uses an Aggregations child and the GroupingPrivate struct so that
// it's polymorphic with GroupBy and can be used in the same rules (when
// appropriate). In the DistinctOn case, the aggregations can be only FirstAgg or
// ConstAgg.
type DistinctOnExpr struct {
	Input        RelExpr
	Aggregations AggregationsExpr
	GroupingPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &DistinctOnExpr{}

func (e *DistinctOnExpr) Op() opt.Operator {
	return opt.DistinctOnOp
}

func (e *DistinctOnExpr) ChildCount() int {
	return 2
}

func (e *DistinctOnExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Aggregations
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *DistinctOnExpr) Private() interface{} {
	return &e.GroupingPrivate
}

func (e *DistinctOnExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *DistinctOnExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Aggregations = *child.(*AggregationsExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *DistinctOnExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *DistinctOnExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *DistinctOnExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *DistinctOnExpr) NextExpr() RelExpr {
	return e.next
}

func (e *DistinctOnExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *DistinctOnExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *DistinctOnExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *DistinctOnExpr) group() exprGroup {
	return e.grp
}

func (e *DistinctOnExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *DistinctOnExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *DistinctOnExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type distinctOnGroup struct {
	mem   *Memo
	rel   props.Relational
	first DistinctOnExpr
	best  bestProps
}

var _ exprGroup = &distinctOnGroup{}

func (g *distinctOnGroup) memo() *Memo {
	return g.mem
}

func (g *distinctOnGroup) relational() *props.Relational {
	return &g.rel
}

func (g *distinctOnGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *distinctOnGroup) bestProps() *bestProps {
	return &g.best
}

// UnionExpr is an operator used to combine the Left and Right input relations into
// a single set containing rows from both inputs. Duplicate rows are discarded.
// The SetPrivate field matches columns from the Left and Right inputs of the
// Union with the output columns. See the comment above SetPrivate for more
// details.
type UnionExpr struct {
	Left  RelExpr
	Right RelExpr
	SetPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &UnionExpr{}

func (e *UnionExpr) Op() opt.Operator {
	return opt.UnionOp
}

func (e *UnionExpr) ChildCount() int {
	return 2
}

func (e *UnionExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnionExpr) Private() interface{} {
	return &e.SetPrivate
}

func (e *UnionExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UnionExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnionExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *UnionExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *UnionExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *UnionExpr) NextExpr() RelExpr {
	return e.next
}

func (e *UnionExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *UnionExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *UnionExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *UnionExpr) group() exprGroup {
	return e.grp
}

func (e *UnionExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *UnionExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *UnionExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type unionGroup struct {
	mem   *Memo
	rel   props.Relational
	first UnionExpr
	best  bestProps
}

var _ exprGroup = &unionGroup{}

func (g *unionGroup) memo() *Memo {
	return g.mem
}

func (g *unionGroup) relational() *props.Relational {
	return &g.rel
}

func (g *unionGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *unionGroup) bestProps() *bestProps {
	return &g.best
}

// SetPrivate contains fields used by the relational set operators: Union,
// Intersect, Except, UnionAll, IntersectAll and ExceptAll. It matches columns
// from the left and right inputs of the operator with the output columns, since
// OutputCols are not ordered and may not correspond to each other.
//
// For example, consider the following query:
//   SELECT y, x FROM xy UNION SELECT b, a FROM ab
//
// Given:
//   col  index
//   x    1
//   y    2
//   a    3
//   b    4
//
// SetPrivate will contain the following values:
//   Left:  [2, 1]
//   Right: [4, 3]
//   Out:   [5, 6]  <-- synthesized output columns
//
// To make normalization rules and execution simpler, both inputs to the set op
// must have matching types.
type SetPrivate struct {
	LeftCols  opt.ColList
	RightCols opt.ColList
	OutCols   opt.ColList
}

// IntersectExpr is an operator used to perform an intersection between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that are also present in the Right relation. Duplicate rows are
// discarded.
// The SetPrivate field matches columns from the Left and Right inputs of the
// Intersect with the output columns. See the comment above SetPrivate for more
// details.
type IntersectExpr struct {
	Left  RelExpr
	Right RelExpr
	SetPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &IntersectExpr{}

func (e *IntersectExpr) Op() opt.Operator {
	return opt.IntersectOp
}

func (e *IntersectExpr) ChildCount() int {
	return 2
}

func (e *IntersectExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IntersectExpr) Private() interface{} {
	return &e.SetPrivate
}

func (e *IntersectExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IntersectExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IntersectExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *IntersectExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *IntersectExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *IntersectExpr) NextExpr() RelExpr {
	return e.next
}

func (e *IntersectExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *IntersectExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *IntersectExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *IntersectExpr) group() exprGroup {
	return e.grp
}

func (e *IntersectExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *IntersectExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *IntersectExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type intersectGroup struct {
	mem   *Memo
	rel   props.Relational
	first IntersectExpr
	best  bestProps
}

var _ exprGroup = &intersectGroup{}

func (g *intersectGroup) memo() *Memo {
	return g.mem
}

func (g *intersectGroup) relational() *props.Relational {
	return &g.rel
}

func (g *intersectGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *intersectGroup) bestProps() *bestProps {
	return &g.best
}

// ExceptExpr is an operator used to perform a set difference between the Left and
// Right input relations. The result consists only of rows in the Left relation
// that are not present in the Right relation. Duplicate rows are discarded.
// The SetPrivate field matches columns from the Left and Right inputs of the Except
// with the output columns. See the comment above SetPrivate for more details.
type ExceptExpr struct {
	Left  RelExpr
	Right RelExpr
	SetPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ExceptExpr{}

func (e *ExceptExpr) Op() opt.Operator {
	return opt.ExceptOp
}

func (e *ExceptExpr) ChildCount() int {
	return 2
}

func (e *ExceptExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExceptExpr) Private() interface{} {
	return &e.SetPrivate
}

func (e *ExceptExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ExceptExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExceptExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ExceptExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ExceptExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ExceptExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ExceptExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ExceptExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ExceptExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ExceptExpr) group() exprGroup {
	return e.grp
}

func (e *ExceptExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ExceptExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ExceptExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type exceptGroup struct {
	mem   *Memo
	rel   props.Relational
	first ExceptExpr
	best  bestProps
}

var _ exprGroup = &exceptGroup{}

func (g *exceptGroup) memo() *Memo {
	return g.mem
}

func (g *exceptGroup) relational() *props.Relational {
	return &g.rel
}

func (g *exceptGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *exceptGroup) bestProps() *bestProps {
	return &g.best
}

// UnionAllExpr is an operator used to combine the Left and Right input relations
// into a single set containing rows from both inputs. Duplicate rows are
// not discarded. For example:
//
//   SELECT x FROM xx UNION ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1          1
//     1       2    ->    1
//     2       3          1
//                        2
//                        2
//                        3
//
// The SetPrivate field matches columns from the Left and Right inputs of the
// UnionAll with the output columns. See the comment above SetPrivate for more
// details.
type UnionAllExpr struct {
	Left  RelExpr
	Right RelExpr
	SetPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &UnionAllExpr{}

func (e *UnionAllExpr) Op() opt.Operator {
	return opt.UnionAllOp
}

func (e *UnionAllExpr) ChildCount() int {
	return 2
}

func (e *UnionAllExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnionAllExpr) Private() interface{} {
	return &e.SetPrivate
}

func (e *UnionAllExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UnionAllExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnionAllExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *UnionAllExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *UnionAllExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *UnionAllExpr) NextExpr() RelExpr {
	return e.next
}

func (e *UnionAllExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *UnionAllExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *UnionAllExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *UnionAllExpr) group() exprGroup {
	return e.grp
}

func (e *UnionAllExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *UnionAllExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *UnionAllExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type unionAllGroup struct {
	mem   *Memo
	rel   props.Relational
	first UnionAllExpr
	best  bestProps
}

var _ exprGroup = &unionAllGroup{}

func (g *unionAllGroup) memo() *Memo {
	return g.mem
}

func (g *unionAllGroup) relational() *props.Relational {
	return &g.rel
}

func (g *unionAllGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *unionAllGroup) bestProps() *bestProps {
	return &g.best
}

// IntersectAllExpr is an operator used to perform an intersection between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that have a corresponding row in the Right relation. Duplicate rows
// are not discarded. This effectively creates a one-to-one mapping between the
// Left and Right rows. For example:
//
//   SELECT x FROM xx INTERSECT ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1          1
//     1       1    ->    1
//     1       2          2
//     2       2          2
//     2       3
//     4
//
// The SetPrivate field matches columns from the Left and Right inputs of the
// IntersectAll with the output columns. See the comment above SetPrivate for more
// details.
type IntersectAllExpr struct {
	Left  RelExpr
	Right RelExpr
	SetPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &IntersectAllExpr{}

func (e *IntersectAllExpr) Op() opt.Operator {
	return opt.IntersectAllOp
}

func (e *IntersectAllExpr) ChildCount() int {
	return 2
}

func (e *IntersectAllExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IntersectAllExpr) Private() interface{} {
	return &e.SetPrivate
}

func (e *IntersectAllExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IntersectAllExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IntersectAllExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *IntersectAllExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *IntersectAllExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *IntersectAllExpr) NextExpr() RelExpr {
	return e.next
}

func (e *IntersectAllExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *IntersectAllExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *IntersectAllExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *IntersectAllExpr) group() exprGroup {
	return e.grp
}

func (e *IntersectAllExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *IntersectAllExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *IntersectAllExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type intersectAllGroup struct {
	mem   *Memo
	rel   props.Relational
	first IntersectAllExpr
	best  bestProps
}

var _ exprGroup = &intersectAllGroup{}

func (g *intersectAllGroup) memo() *Memo {
	return g.mem
}

func (g *intersectAllGroup) relational() *props.Relational {
	return &g.rel
}

func (g *intersectAllGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *intersectAllGroup) bestProps() *bestProps {
	return &g.best
}

// ExceptAllExpr is an operator used to perform a set difference between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that do not have a corresponding row in the Right relation.
// Duplicate rows are not discarded. This effectively creates a one-to-one
// mapping between the Left and Right rows. For example:
//   SELECT x FROM xx EXCEPT ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1    ->    1
//     1       1          4
//     1       2
//     2       2
//     2       3
//     4
//
// The SetPrivate field matches columns from the Left and Right inputs of the
// ExceptAll with the output columns. See the comment above SetPrivate for more
// details.
type ExceptAllExpr struct {
	Left  RelExpr
	Right RelExpr
	SetPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ExceptAllExpr{}

func (e *ExceptAllExpr) Op() opt.Operator {
	return opt.ExceptAllOp
}

func (e *ExceptAllExpr) ChildCount() int {
	return 2
}

func (e *ExceptAllExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExceptAllExpr) Private() interface{} {
	return &e.SetPrivate
}

func (e *ExceptAllExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ExceptAllExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(RelExpr)
		return
	case 1:
		e.Right = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExceptAllExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ExceptAllExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ExceptAllExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ExceptAllExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ExceptAllExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ExceptAllExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ExceptAllExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ExceptAllExpr) group() exprGroup {
	return e.grp
}

func (e *ExceptAllExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ExceptAllExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ExceptAllExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type exceptAllGroup struct {
	mem   *Memo
	rel   props.Relational
	first ExceptAllExpr
	best  bestProps
}

var _ exprGroup = &exceptAllGroup{}

func (g *exceptAllGroup) memo() *Memo {
	return g.mem
}

func (g *exceptAllGroup) relational() *props.Relational {
	return &g.rel
}

func (g *exceptAllGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *exceptAllGroup) bestProps() *bestProps {
	return &g.best
}

// LimitExpr returns a limited subset of the results in the input relation. The limit
// expression is a scalar value; the operator returns at most this many rows. The
// Orering field is a physical.OrderingChoice which indicates the row ordering
// required from the input (the first rows with respect to this ordering are
// returned).
type LimitExpr struct {
	Input    RelExpr
	Limit    opt.ScalarExpr
	Ordering physical.OrderingChoice

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &LimitExpr{}

func (e *LimitExpr) Op() opt.Operator {
	return opt.LimitOp
}

func (e *LimitExpr) ChildCount() int {
	return 2
}

func (e *LimitExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return e.Limit
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LimitExpr) Private() interface{} {
	return &e.Ordering
}

func (e *LimitExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LimitExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Limit = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LimitExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *LimitExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *LimitExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *LimitExpr) NextExpr() RelExpr {
	return e.next
}

func (e *LimitExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *LimitExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *LimitExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *LimitExpr) group() exprGroup {
	return e.grp
}

func (e *LimitExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *LimitExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *LimitExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type limitGroup struct {
	mem   *Memo
	rel   props.Relational
	first LimitExpr
	best  bestProps
}

var _ exprGroup = &limitGroup{}

func (g *limitGroup) memo() *Memo {
	return g.mem
}

func (g *limitGroup) relational() *props.Relational {
	return &g.rel
}

func (g *limitGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *limitGroup) bestProps() *bestProps {
	return &g.best
}

// OffsetExpr filters out the first Offset rows of the input relation; used in
// conjunction with Limit.
type OffsetExpr struct {
	Input    RelExpr
	Offset   opt.ScalarExpr
	Ordering physical.OrderingChoice

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &OffsetExpr{}

func (e *OffsetExpr) Op() opt.Operator {
	return opt.OffsetOp
}

func (e *OffsetExpr) ChildCount() int {
	return 2
}

func (e *OffsetExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return e.Offset
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *OffsetExpr) Private() interface{} {
	return &e.Ordering
}

func (e *OffsetExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *OffsetExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Offset = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *OffsetExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *OffsetExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *OffsetExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *OffsetExpr) NextExpr() RelExpr {
	return e.next
}

func (e *OffsetExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *OffsetExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *OffsetExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *OffsetExpr) group() exprGroup {
	return e.grp
}

func (e *OffsetExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *OffsetExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *OffsetExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type offsetGroup struct {
	mem   *Memo
	rel   props.Relational
	first OffsetExpr
	best  bestProps
}

var _ exprGroup = &offsetGroup{}

func (g *offsetGroup) memo() *Memo {
	return g.mem
}

func (g *offsetGroup) relational() *props.Relational {
	return &g.rel
}

func (g *offsetGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *offsetGroup) bestProps() *bestProps {
	return &g.best
}

// Max1RowExpr enforces that its input must return at most one row. It is used as
// input to the Subquery operator. See the comment above Subquery for more
// details.
type Max1RowExpr struct {
	Input RelExpr

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &Max1RowExpr{}

func (e *Max1RowExpr) Op() opt.Operator {
	return opt.Max1RowOp
}

func (e *Max1RowExpr) ChildCount() int {
	return 1
}

func (e *Max1RowExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *Max1RowExpr) Private() interface{} {
	return nil
}

func (e *Max1RowExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *Max1RowExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *Max1RowExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *Max1RowExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *Max1RowExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *Max1RowExpr) NextExpr() RelExpr {
	return e.next
}

func (e *Max1RowExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *Max1RowExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *Max1RowExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *Max1RowExpr) group() exprGroup {
	return e.grp
}

func (e *Max1RowExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *Max1RowExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *Max1RowExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type max1RowGroup struct {
	mem   *Memo
	rel   props.Relational
	first Max1RowExpr
	best  bestProps
}

var _ exprGroup = &max1RowGroup{}

func (g *max1RowGroup) memo() *Memo {
	return g.mem
}

func (g *max1RowGroup) relational() *props.Relational {
	return &g.rel
}

func (g *max1RowGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *max1RowGroup) bestProps() *bestProps {
	return &g.best
}

// ExplainExpr returns information about the execution plan of the "input"
// expression.
type ExplainExpr struct {
	Input RelExpr
	ExplainPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ExplainExpr{}

func (e *ExplainExpr) Op() opt.Operator {
	return opt.ExplainOp
}

func (e *ExplainExpr) ChildCount() int {
	return 1
}

func (e *ExplainExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExplainExpr) Private() interface{} {
	return &e.ExplainPrivate
}

func (e *ExplainExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ExplainExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExplainExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ExplainExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ExplainExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ExplainExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ExplainExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ExplainExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ExplainExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ExplainExpr) group() exprGroup {
	return e.grp
}

func (e *ExplainExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ExplainExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ExplainExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type explainGroup struct {
	mem   *Memo
	rel   props.Relational
	first ExplainExpr
	best  bestProps
}

var _ exprGroup = &explainGroup{}

func (g *explainGroup) memo() *Memo {
	return g.mem
}

func (g *explainGroup) relational() *props.Relational {
	return &g.rel
}

func (g *explainGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *explainGroup) bestProps() *bestProps {
	return &g.best
}

type ExplainPrivate struct {
	// Options contains settings that control the output of the explain statement.
	Options tree.ExplainOptions

	// ColList stores the column IDs for the explain columns.
	ColList opt.ColList

	// Props stores the required physical properties for the enclosed expression.
	Props *physical.Required

	// StmtType stores the type of the statement we are explaining.
	StmtType tree.StatementType
}

// ShowTraceForSessionExpr returns the current session traces.
type ShowTraceForSessionExpr struct {
	ShowTracePrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ShowTraceForSessionExpr{}

func (e *ShowTraceForSessionExpr) Op() opt.Operator {
	return opt.ShowTraceForSessionOp
}

func (e *ShowTraceForSessionExpr) ChildCount() int {
	return 0
}

func (e *ShowTraceForSessionExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ShowTraceForSessionExpr) Private() interface{} {
	return &e.ShowTracePrivate
}

func (e *ShowTraceForSessionExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ShowTraceForSessionExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ShowTraceForSessionExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ShowTraceForSessionExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ShowTraceForSessionExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ShowTraceForSessionExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ShowTraceForSessionExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ShowTraceForSessionExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ShowTraceForSessionExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ShowTraceForSessionExpr) group() exprGroup {
	return e.grp
}

func (e *ShowTraceForSessionExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ShowTraceForSessionExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ShowTraceForSessionExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type showTraceForSessionGroup struct {
	mem   *Memo
	rel   props.Relational
	first ShowTraceForSessionExpr
	best  bestProps
}

var _ exprGroup = &showTraceForSessionGroup{}

func (g *showTraceForSessionGroup) memo() *Memo {
	return g.mem
}

func (g *showTraceForSessionGroup) relational() *props.Relational {
	return &g.rel
}

func (g *showTraceForSessionGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *showTraceForSessionGroup) bestProps() *bestProps {
	return &g.best
}

type ShowTracePrivate struct {
	TraceType tree.ShowTraceType

	// Compact indicates that we output a smaller set of columns; set
	// when SHOW COMPACT [KV] TRACE is used.
	Compact bool

	// ColList stores the column IDs for the SHOW TRACE columns.
	ColList opt.ColList
}

// RowNumberExpr adds a column to each row in its input containing a unique,
// increasing number.
type RowNumberExpr struct {
	Input RelExpr
	RowNumberPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &RowNumberExpr{}

func (e *RowNumberExpr) Op() opt.Operator {
	return opt.RowNumberOp
}

func (e *RowNumberExpr) ChildCount() int {
	return 1
}

func (e *RowNumberExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RowNumberExpr) Private() interface{} {
	return &e.RowNumberPrivate
}

func (e *RowNumberExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RowNumberExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RowNumberExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *RowNumberExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *RowNumberExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *RowNumberExpr) NextExpr() RelExpr {
	return e.next
}

func (e *RowNumberExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *RowNumberExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *RowNumberExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *RowNumberExpr) group() exprGroup {
	return e.grp
}

func (e *RowNumberExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *RowNumberExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *RowNumberExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type rowNumberGroup struct {
	mem   *Memo
	rel   props.Relational
	first RowNumberExpr
	best  bestProps
}

var _ exprGroup = &rowNumberGroup{}

func (g *rowNumberGroup) memo() *Memo {
	return g.mem
}

func (g *rowNumberGroup) relational() *props.Relational {
	return &g.rel
}

func (g *rowNumberGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *rowNumberGroup) bestProps() *bestProps {
	return &g.best
}

type RowNumberPrivate struct {
	// Ordering denotes the required ordering of the input.
	Ordering physical.OrderingChoice

	// ColID holds the id of the column introduced by this operator.
	ColID opt.ColumnID
}

// ProjectSetExpr represents a relational operator which zips through a list of
// generators for every row of the input.
//
// As a reminder, a functional zip over generators a,b,c returns tuples of
// values from a,b,c picked "simultaneously". NULLs are used when a generator is
// "shorter" than another.  For example:
//
//    zip([1,2,3], ['a','b']) = [(1,'a'), (2,'b'), (3, null)]
//
// ProjectSet corresponds to a relational operator project(R, a, b, c, ...)
// which, for each row in R, produces all the rows produced by zip(a, b, c, ...)
// with the values of R prefixed. Formally, this performs a lateral cross join
// of R with zip(a,b,c).
//
// See the Zip header for more details.
type ProjectSetExpr struct {
	Input RelExpr
	Zip   ZipExpr

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &ProjectSetExpr{}

func (e *ProjectSetExpr) Op() opt.Operator {
	return opt.ProjectSetOp
}

func (e *ProjectSetExpr) ChildCount() int {
	return 2
}

func (e *ProjectSetExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Zip
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ProjectSetExpr) Private() interface{} {
	return nil
}

func (e *ProjectSetExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ProjectSetExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Zip = *child.(*ZipExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ProjectSetExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *ProjectSetExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *ProjectSetExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *ProjectSetExpr) NextExpr() RelExpr {
	return e.next
}

func (e *ProjectSetExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *ProjectSetExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *ProjectSetExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *ProjectSetExpr) group() exprGroup {
	return e.grp
}

func (e *ProjectSetExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *ProjectSetExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *ProjectSetExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type projectSetGroup struct {
	mem   *Memo
	rel   props.Relational
	first ProjectSetExpr
	best  bestProps
}

var _ exprGroup = &projectSetGroup{}

func (g *projectSetGroup) memo() *Memo {
	return g.mem
}

func (g *projectSetGroup) relational() *props.Relational {
	return &g.rel
}

func (g *projectSetGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *projectSetGroup) bestProps() *bestProps {
	return &g.best
}

// SubqueryExpr is a subquery in a single-row context. Here are some examples:
//
//   SELECT 1 = (SELECT 1)
//   SELECT (1, 'a') = (SELECT 1, 'a')`
//
// In a single-row context, the outer query is only valid if the subquery returns
// at most one row. Subqueries in a multi-row context can be transformed to a
// single row context using the Any operator. See the comment above the Any
// operator for more details.
//
// The Input field contains the subquery itself, which should be wrapped in a
// Max1Row operator to enforce that the subquery can return at most one row
// (Max1Row may be removed by the optimizer later if it can determine statically
// that the subquery will always return at most one row). In addition, the
// subquery must project exactly one output column. If the subquery returns one
// row, then that column is bound to the single column value in that row. If the
// subquery returns zero rows, then that column is bound to NULL.
type SubqueryExpr struct {
	Input RelExpr
	SubqueryPrivate

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &SubqueryExpr{}

func (e *SubqueryExpr) ID() opt.ScalarID {
	return e.id
}

func (e *SubqueryExpr) Op() opt.Operator {
	return opt.SubqueryOp
}

func (e *SubqueryExpr) ChildCount() int {
	return 1
}

func (e *SubqueryExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SubqueryExpr) Private() interface{} {
	return &e.SubqueryPrivate
}

func (e *SubqueryExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SubqueryExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SubqueryExpr) DataType() types.T {
	return e.Typ
}

// SubqueryPrivate contains information related to a subquery (Subquery, Any,
// Exists). It is shared between the operators so that the same rules can be used
// across all the subquery operators.
type SubqueryPrivate struct {
	OriginalExpr *tree.Subquery
	Ordering     opt.Ordering

	// RequestedCol is set if there could possibly be other columns in the input
	// (say, if there was an ordering that must be respected) besides the one that
	// will eventually be output.
	RequestedCol opt.ColumnID

	// Cmp is only used for AnyOp.
	Cmp opt.Operator

	// WasLimited indicates a limit was applied "under" the subquery to
	// restrict how many rows are fetched to determine the result.  See
	// e.g. the rule IntroduceExistsLimit.
	WasLimited bool
}

// AnyExpr is a SQL operator that applies a comparison to every row of an input
// subquery and returns true if any of the comparisons are true, else returns
// null if any of the comparisons are null, else returns false. The following
// transformations map from various SQL operators into the Any operator:
//
//   <scalar> IN (<subquery>)
//   ==> (Any <subquery> <scalar> EqOp)
//
//   <scalar> NOT IN (<subquery>)
//   ==> (Not (Any <subquery> <scalar> EqOp))
//
//   <scalar> <cmp> {SOME|ANY}(<subquery>)
//   ==> (Any <subquery> <scalar> <cmp>)
//
//   <scalar> <cmp> ALL(<subquery>)
//   ==> (Not (Any <subquery> <scalar> <negated-cmp>))
//
// Any expects the input subquery to return a single column of any data type. The
// scalar value is compared with that column using the specified comparison
// operator.
type AnyExpr struct {
	Input  RelExpr
	Scalar opt.ScalarExpr
	SubqueryPrivate

	id opt.ScalarID
}

var _ opt.ScalarExpr = &AnyExpr{}

func (e *AnyExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AnyExpr) Op() opt.Operator {
	return opt.AnyOp
}

func (e *AnyExpr) ChildCount() int {
	return 2
}

func (e *AnyExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return e.Scalar
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AnyExpr) Private() interface{} {
	return &e.SubqueryPrivate
}

func (e *AnyExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AnyExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	case 1:
		e.Scalar = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AnyExpr) DataType() types.T {
	return types.Bool
}

// ExistsExpr takes a relational query as its input, and evaluates to true if the
// query returns at least one row.
type ExistsExpr struct {
	Input RelExpr
	SubqueryPrivate

	id opt.ScalarID
}

var _ opt.ScalarExpr = &ExistsExpr{}

func (e *ExistsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ExistsExpr) Op() opt.Operator {
	return opt.ExistsOp
}

func (e *ExistsExpr) ChildCount() int {
	return 1
}

func (e *ExistsExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExistsExpr) Private() interface{} {
	return &e.SubqueryPrivate
}

func (e *ExistsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ExistsExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ExistsExpr) DataType() types.T {
	return types.Bool
}

// VariableExpr is the typed scalar value of a column in the query. The Col field is
// a metadata ColumnID value that references the column by index.
type VariableExpr struct {
	Col opt.ColumnID

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &VariableExpr{}

func (e *VariableExpr) ID() opt.ScalarID {
	return e.id
}

func (e *VariableExpr) Op() opt.Operator {
	return opt.VariableOp
}

func (e *VariableExpr) ChildCount() int {
	return 0
}

func (e *VariableExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *VariableExpr) Private() interface{} {
	return &e.Col
}

func (e *VariableExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *VariableExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *VariableExpr) DataType() types.T {
	return e.Typ
}

// ConstExpr is a typed scalar constant value. The Value field is a tree.Datum value
// having any datum type that's legal in the expression's context.
type ConstExpr struct {
	Value tree.Datum

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ConstExpr{}

func (e *ConstExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ConstExpr) Op() opt.Operator {
	return opt.ConstOp
}

func (e *ConstExpr) ChildCount() int {
	return 0
}

func (e *ConstExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConstExpr) Private() interface{} {
	return e.Value
}

func (e *ConstExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ConstExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConstExpr) DataType() types.T {
	return e.Typ
}

// NullExpr is the constant SQL null value that has "unknown value" semantics. If
// the Typ field is not types.Unknown, then the value is known to be in the
// domain of that type. This is important for preserving correct types in
// replacement patterns. For example:
//   (Plus (Function ...) (Const 1))
//
// If the function in that expression has a static type of Int, but then it gets
// constant folded to (Null), then its type must remain as Int. Any other type
// violates logical equivalence of the expression, breaking type inference and
// possibly changing the results of execution. The solution is to tag the null
// with the correct type:
//   (Plus (Null (Int)) (Const 1))
//
// Null is its own operator rather than a Const datum in order to make matching
// and replacement easier and more efficient, as patterns can contain (Null)
// expressions.
type NullExpr struct {
	Typ types.T

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NullExpr{}

func (e *NullExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NullExpr) Op() opt.Operator {
	return opt.NullOp
}

func (e *NullExpr) ChildCount() int {
	return 0
}

func (e *NullExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NullExpr) Private() interface{} {
	return e.Typ
}

func (e *NullExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NullExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NullExpr) DataType() types.T {
	return e.Typ
}

// TrueExpr is the boolean true value that is equivalent to the tree.DBoolTrue datum
// value. It is a separate operator to make matching and replacement simpler and
// more efficient, as patterns can contain (True) expressions.
type TrueExpr struct {
	id opt.ScalarID
}

var _ opt.ScalarExpr = &TrueExpr{}

func (e *TrueExpr) ID() opt.ScalarID {
	return e.id
}

func (e *TrueExpr) Op() opt.Operator {
	return opt.TrueOp
}

func (e *TrueExpr) ChildCount() int {
	return 0
}

func (e *TrueExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *TrueExpr) Private() interface{} {
	return nil
}

func (e *TrueExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *TrueExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *TrueExpr) DataType() types.T {
	return types.Bool
}

// FalseExpr is the boolean false value that is equivalent to the tree.DBoolFalse
// datum value. It is a separate operator to make matching and replacement
// simpler and more efficient, as patterns can contain (False) expressions.
type FalseExpr struct {
	id opt.ScalarID
}

var _ opt.ScalarExpr = &FalseExpr{}

func (e *FalseExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FalseExpr) Op() opt.Operator {
	return opt.FalseOp
}

func (e *FalseExpr) ChildCount() int {
	return 0
}

func (e *FalseExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FalseExpr) Private() interface{} {
	return nil
}

func (e *FalseExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FalseExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FalseExpr) DataType() types.T {
	return types.Bool
}

type PlaceholderExpr struct {
	Value tree.TypedExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &PlaceholderExpr{}

func (e *PlaceholderExpr) ID() opt.ScalarID {
	return e.id
}

func (e *PlaceholderExpr) Op() opt.Operator {
	return opt.PlaceholderOp
}

func (e *PlaceholderExpr) ChildCount() int {
	return 0
}

func (e *PlaceholderExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *PlaceholderExpr) Private() interface{} {
	return e.Value
}

func (e *PlaceholderExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *PlaceholderExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *PlaceholderExpr) DataType() types.T {
	return e.Typ
}

type TupleExpr struct {
	Elems ScalarListExpr
	Typ   types.T

	id opt.ScalarID
}

var _ opt.ScalarExpr = &TupleExpr{}

func (e *TupleExpr) ID() opt.ScalarID {
	return e.id
}

func (e *TupleExpr) Op() opt.Operator {
	return opt.TupleOp
}

func (e *TupleExpr) ChildCount() int {
	return 1
}

func (e *TupleExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return &e.Elems
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *TupleExpr) Private() interface{} {
	return e.Typ
}

func (e *TupleExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *TupleExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Elems = *child.(*ScalarListExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *TupleExpr) DataType() types.T {
	return e.Typ
}

// ProjectionsExpr is a set of ProjectionsItem expressions that specify the ColumnIDs
// and scalar expressions for the synthesized output columns projected by a
// containing Project operator. It is legal for the set to be empty. See the
// Project and ProjectionsItem headers for more details.
type ProjectionsExpr []ProjectionsItem

var EmptyProjectionsExpr = ProjectionsExpr{}

var _ opt.ScalarExpr = &ProjectionsExpr{}

func (e *ProjectionsExpr) ID() opt.ScalarID {
	panic(pgerror.NewAssertionErrorf("lists have no id"))
}

func (e *ProjectionsExpr) Op() opt.Operator {
	return opt.ProjectionsOp
}

func (e *ProjectionsExpr) ChildCount() int {
	return len(*e)
}

func (e *ProjectionsExpr) Child(nth int) opt.Expr {
	return &(*e)[nth]
}

func (e *ProjectionsExpr) Private() interface{} {
	return nil
}

func (e *ProjectionsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ProjectionsExpr) SetChild(nth int, child opt.Expr) {
	(*e)[nth] = *child.(*ProjectionsItem)
}

func (e *ProjectionsExpr) DataType() types.T {
	return types.Any
}

// ProjectionsItem encapsulates the information needed to synthesize an output
// column, including its ColumnID and the scalar expression that produces its
// value. In addition, the ProjectionsItem caches a set of scalar properties that
// are lazily calculated by traversing the Element scalar expression. This allows
// the properties for the entire expression subtree to be calculated once and
// then repeatedly reused.
//
// The Element scalar expression cannot contain a simple VariableOp with the same
// ColumnID as the one stored in the ColPrivate field, since that would make it a
// pass-through column. Pass-through columns are always stored on the containing
// Project operator instead. However, the Element field can contain a VariableOp
// when a new ColumnID is being assigned, such as in the case of an outer column
// reference.
type ProjectionsItem struct {
	Element opt.ScalarExpr
	ColPrivate

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ProjectionsItem{}

func (e *ProjectionsItem) ID() opt.ScalarID {
	return e.id
}

func (e *ProjectionsItem) Op() opt.Operator {
	return opt.ProjectionsItemOp
}

func (e *ProjectionsItem) ChildCount() int {
	return 1
}

func (e *ProjectionsItem) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Element
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ProjectionsItem) Private() interface{} {
	return &e.ColPrivate
}

func (e *ProjectionsItem) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ProjectionsItem) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Element = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ProjectionsItem) DataType() types.T {
	return e.Typ
}

func (e *ProjectionsItem) ScalarProps(mem *Memo) *props.Scalar {
	if !e.scalar.Populated {
		mem.logPropsBuilder.buildProjectionsItemProps(e, &e.scalar)
	}
	return &e.scalar
}

// ColPrivate contains the ColumnID of a synthesized projection or aggregation
// column, as well as a set of lazily-populated scalar properties that apply to
// the column. ColPrivate is shared by ProjectionsItem and AggregationsItem so
// that they can be treated polymorphically.
type ColPrivate struct {
	Col opt.ColumnID

	// Lazily populated.
	scalar props.Scalar
}

// AggregationsExpr is a set of AggregationsItem expressions that specify the
// ColumnIDs and aggregation expression for output columns projected by a
// containing grouping operator (GroupBy, ScalarGroupBy, or DistinctOn). It is
// legal for the set to be empty. See the AggregationsItem header for more
// details.
type AggregationsExpr []AggregationsItem

var EmptyAggregationsExpr = AggregationsExpr{}

var _ opt.ScalarExpr = &AggregationsExpr{}

func (e *AggregationsExpr) ID() opt.ScalarID {
	panic(pgerror.NewAssertionErrorf("lists have no id"))
}

func (e *AggregationsExpr) Op() opt.Operator {
	return opt.AggregationsOp
}

func (e *AggregationsExpr) ChildCount() int {
	return len(*e)
}

func (e *AggregationsExpr) Child(nth int) opt.Expr {
	return &(*e)[nth]
}

func (e *AggregationsExpr) Private() interface{} {
	return nil
}

func (e *AggregationsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AggregationsExpr) SetChild(nth int, child opt.Expr) {
	(*e)[nth] = *child.(*AggregationsItem)
}

func (e *AggregationsExpr) DataType() types.T {
	return types.Any
}

// AggregationsItem encapsulates the information for constructing an aggregate
// output column, including its ColumnID and the aggregate expression that
// produces its value. In addition, the AggregationsItem caches a set of scalar
// properties that are lazily calculated by traversing the Agg scalar expression.
// This allows the properties for the aggregate expression to be calculated once
// and then repeatedly reused.
//
// The aggregate expression can only consist of aggregate functions, variable
// references, and modifiers like AggDistinct. Examples of valid expressions:
//
//   (Min (Variable 1))
//   (Count (AggDistinct (Variable 1)))
//
// More complex arguments must be formulated using a Project operator as input to
// the grouping operator.
type AggregationsItem struct {
	Agg opt.ScalarExpr
	ColPrivate

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &AggregationsItem{}

func (e *AggregationsItem) ID() opt.ScalarID {
	return e.id
}

func (e *AggregationsItem) Op() opt.Operator {
	return opt.AggregationsItemOp
}

func (e *AggregationsItem) ChildCount() int {
	return 1
}

func (e *AggregationsItem) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Agg
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AggregationsItem) Private() interface{} {
	return &e.ColPrivate
}

func (e *AggregationsItem) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AggregationsItem) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Agg = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AggregationsItem) DataType() types.T {
	return e.Typ
}

func (e *AggregationsItem) ScalarProps(mem *Memo) *props.Scalar {
	if !e.scalar.Populated {
		mem.logPropsBuilder.buildAggregationsItemProps(e, &e.scalar)
	}
	return &e.scalar
}

// FiltersExpr is a set of FiltersItem expressions that specify a set of conjuncts
// that filter rows selected by a containing Select or Join operator. A row is
// filtered only if all conditions evaluate to true. If the set is empty, then
// it never filters rows. See the Select and FiltersItem headers for more
// details.
type FiltersExpr []FiltersItem

var EmptyFiltersExpr = FiltersExpr{}

var _ opt.ScalarExpr = &FiltersExpr{}

func (e *FiltersExpr) ID() opt.ScalarID {
	panic(pgerror.NewAssertionErrorf("lists have no id"))
}

func (e *FiltersExpr) Op() opt.Operator {
	return opt.FiltersOp
}

func (e *FiltersExpr) ChildCount() int {
	return len(*e)
}

func (e *FiltersExpr) Child(nth int) opt.Expr {
	return &(*e)[nth]
}

func (e *FiltersExpr) Private() interface{} {
	return nil
}

func (e *FiltersExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FiltersExpr) SetChild(nth int, child opt.Expr) {
	(*e)[nth] = *child.(*FiltersItem)
}

func (e *FiltersExpr) DataType() types.T {
	return types.Any
}

// FiltersItem contains a filter condition that's evaluated to determine whether
// Select or Join rows should be filtered. In addition, the FiltersItem caches a
// set of scalar properties that are lazily calculated by traversing the
// Condition scalar expression. This allows the properties for the entire
// expression subtree to be calculated once and then repeatedly reused.
type FiltersItem struct {
	Condition opt.ScalarExpr
	scalar    props.Scalar

	id opt.ScalarID
}

var _ opt.ScalarExpr = &FiltersItem{}

func (e *FiltersItem) ID() opt.ScalarID {
	return e.id
}

func (e *FiltersItem) Op() opt.Operator {
	return opt.FiltersItemOp
}

func (e *FiltersItem) ChildCount() int {
	return 1
}

func (e *FiltersItem) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Condition
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FiltersItem) Private() interface{} {
	return &e.scalar
}

func (e *FiltersItem) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FiltersItem) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Condition = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FiltersItem) DataType() types.T {
	return types.Bool
}

func (e *FiltersItem) ScalarProps(mem *Memo) *props.Scalar {
	if !e.scalar.Populated {
		mem.logPropsBuilder.buildFiltersItemProps(e, &e.scalar)
	}
	return &e.scalar
}

// ZipExpr represents a functional zip over generators a,b,c, which returns tuples of
// values from a,b,c picked "simultaneously". NULLs are used when a generator is
// "shorter" than another. In SQL, these generators can be either generator
// functions such as generate_series(), or scalar functions or expressions such
// as upper() or CAST. For example, consider this query:
//
//    SELECT * FROM ROWS FROM (generate_series(0, 1), upper('abc'));
//
// It is equivalent to:
//
//    (Zip [
//            (ZipItem (Function generate_series)),
//            (ZipItem (Function upper))
//         ]
//    )
//
// It produces:
//
//     generate_series | upper
//    -----------------+-------
//                   0 | ABC
//                   1 | NULL
//
type ZipExpr []ZipItem

var EmptyZipExpr = ZipExpr{}

var _ opt.ScalarExpr = &ZipExpr{}

func (e *ZipExpr) ID() opt.ScalarID {
	panic(pgerror.NewAssertionErrorf("lists have no id"))
}

func (e *ZipExpr) Op() opt.Operator {
	return opt.ZipOp
}

func (e *ZipExpr) ChildCount() int {
	return len(*e)
}

func (e *ZipExpr) Child(nth int) opt.Expr {
	return &(*e)[nth]
}

func (e *ZipExpr) Private() interface{} {
	return nil
}

func (e *ZipExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ZipExpr) SetChild(nth int, child opt.Expr) {
	(*e)[nth] = *child.(*ZipItem)
}

func (e *ZipExpr) DataType() types.T {
	return types.Any
}

// ZipItem contains a generator function or scalar expression that is contained
// in a Zip. See the Zip header for more details.
type ZipItem struct {
	Func opt.ScalarExpr
	ZipItemPrivate

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ZipItem{}

func (e *ZipItem) ID() opt.ScalarID {
	return e.id
}

func (e *ZipItem) Op() opt.Operator {
	return opt.ZipItemOp
}

func (e *ZipItem) ChildCount() int {
	return 1
}

func (e *ZipItem) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Func
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ZipItem) Private() interface{} {
	return &e.ZipItemPrivate
}

func (e *ZipItem) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ZipItem) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Func = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ZipItem) DataType() types.T {
	return e.Typ
}

func (e *ZipItem) ScalarProps(mem *Memo) *props.Scalar {
	if !e.scalar.Populated {
		mem.logPropsBuilder.buildZipItemProps(e, &e.scalar)
	}
	return &e.scalar
}

// ZipItemPrivate contains the list of output columns for the generator function
// or scalar expression in a ZipItem, as well as a set of lazily-populated
// scalar properties that apply to the ZipItem. Cols is a list since a single
// function may output multiple columns (e.g., pg_get_keywords() outputs three
// columns).
type ZipItemPrivate struct {
	Cols opt.ColList

	// Lazily populated.
	scalar props.Scalar
}

// AndExpr is the boolean conjunction operator that evalutes to true only if both of
// its conditions evaluate to true.
type AndExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &AndExpr{}

func (e *AndExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AndExpr) Op() opt.Operator {
	return opt.AndOp
}

func (e *AndExpr) ChildCount() int {
	return 2
}

func (e *AndExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AndExpr) Private() interface{} {
	return nil
}

func (e *AndExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AndExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AndExpr) DataType() types.T {
	return types.Bool
}

// OrExpr is the boolean disjunction operator that evaluates to true if either one of
// its conditions evaluates to true.
type OrExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &OrExpr{}

func (e *OrExpr) ID() opt.ScalarID {
	return e.id
}

func (e *OrExpr) Op() opt.Operator {
	return opt.OrOp
}

func (e *OrExpr) ChildCount() int {
	return 2
}

func (e *OrExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *OrExpr) Private() interface{} {
	return nil
}

func (e *OrExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *OrExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *OrExpr) DataType() types.T {
	return types.Bool
}

// RangeExpr contains an And expression that constrains a single variable to a
// range. For example, the And expression might be x > 5 AND x < 10. The
// children of the And expression can be arbitrary expressions (including nested
// And expressions), but they must all constrain the same variable, and the
// constraints must be tight.
//
// Currently, Range expressions are only created by the ConsolidateSelectFilters
// normalization rule.
type RangeExpr struct {
	And opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &RangeExpr{}

func (e *RangeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *RangeExpr) Op() opt.Operator {
	return opt.RangeOp
}

func (e *RangeExpr) ChildCount() int {
	return 1
}

func (e *RangeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.And
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RangeExpr) Private() interface{} {
	return nil
}

func (e *RangeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RangeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.And = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RangeExpr) DataType() types.T {
	return types.Bool
}

// NotExpr is the boolean negation operator that evaluates to true if its input
// evaluates to false.
type NotExpr struct {
	Input opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotExpr{}

func (e *NotExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotExpr) Op() opt.Operator {
	return opt.NotOp
}

func (e *NotExpr) ChildCount() int {
	return 1
}

func (e *NotExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotExpr) Private() interface{} {
	return nil
}

func (e *NotExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotExpr) DataType() types.T {
	return types.Bool
}

type EqExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &EqExpr{}

func (e *EqExpr) ID() opt.ScalarID {
	return e.id
}

func (e *EqExpr) Op() opt.Operator {
	return opt.EqOp
}

func (e *EqExpr) ChildCount() int {
	return 2
}

func (e *EqExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *EqExpr) Private() interface{} {
	return nil
}

func (e *EqExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *EqExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *EqExpr) DataType() types.T {
	return types.Bool
}

type LtExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &LtExpr{}

func (e *LtExpr) ID() opt.ScalarID {
	return e.id
}

func (e *LtExpr) Op() opt.Operator {
	return opt.LtOp
}

func (e *LtExpr) ChildCount() int {
	return 2
}

func (e *LtExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LtExpr) Private() interface{} {
	return nil
}

func (e *LtExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LtExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LtExpr) DataType() types.T {
	return types.Bool
}

type GtExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &GtExpr{}

func (e *GtExpr) ID() opt.ScalarID {
	return e.id
}

func (e *GtExpr) Op() opt.Operator {
	return opt.GtOp
}

func (e *GtExpr) ChildCount() int {
	return 2
}

func (e *GtExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *GtExpr) Private() interface{} {
	return nil
}

func (e *GtExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *GtExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *GtExpr) DataType() types.T {
	return types.Bool
}

type LeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &LeExpr{}

func (e *LeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *LeExpr) Op() opt.Operator {
	return opt.LeOp
}

func (e *LeExpr) ChildCount() int {
	return 2
}

func (e *LeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LeExpr) Private() interface{} {
	return nil
}

func (e *LeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LeExpr) DataType() types.T {
	return types.Bool
}

type GeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &GeExpr{}

func (e *GeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *GeExpr) Op() opt.Operator {
	return opt.GeOp
}

func (e *GeExpr) ChildCount() int {
	return 2
}

func (e *GeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *GeExpr) Private() interface{} {
	return nil
}

func (e *GeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *GeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *GeExpr) DataType() types.T {
	return types.Bool
}

type NeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NeExpr{}

func (e *NeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NeExpr) Op() opt.Operator {
	return opt.NeOp
}

func (e *NeExpr) ChildCount() int {
	return 2
}

func (e *NeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NeExpr) Private() interface{} {
	return nil
}

func (e *NeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NeExpr) DataType() types.T {
	return types.Bool
}

type InExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &InExpr{}

func (e *InExpr) ID() opt.ScalarID {
	return e.id
}

func (e *InExpr) Op() opt.Operator {
	return opt.InOp
}

func (e *InExpr) ChildCount() int {
	return 2
}

func (e *InExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InExpr) Private() interface{} {
	return nil
}

func (e *InExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *InExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InExpr) DataType() types.T {
	return types.Bool
}

type NotInExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotInExpr{}

func (e *NotInExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotInExpr) Op() opt.Operator {
	return opt.NotInOp
}

func (e *NotInExpr) ChildCount() int {
	return 2
}

func (e *NotInExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotInExpr) Private() interface{} {
	return nil
}

func (e *NotInExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotInExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotInExpr) DataType() types.T {
	return types.Bool
}

type LikeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &LikeExpr{}

func (e *LikeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *LikeExpr) Op() opt.Operator {
	return opt.LikeOp
}

func (e *LikeExpr) ChildCount() int {
	return 2
}

func (e *LikeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LikeExpr) Private() interface{} {
	return nil
}

func (e *LikeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LikeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LikeExpr) DataType() types.T {
	return types.Bool
}

type NotLikeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotLikeExpr{}

func (e *NotLikeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotLikeExpr) Op() opt.Operator {
	return opt.NotLikeOp
}

func (e *NotLikeExpr) ChildCount() int {
	return 2
}

func (e *NotLikeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotLikeExpr) Private() interface{} {
	return nil
}

func (e *NotLikeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotLikeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotLikeExpr) DataType() types.T {
	return types.Bool
}

type ILikeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &ILikeExpr{}

func (e *ILikeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ILikeExpr) Op() opt.Operator {
	return opt.ILikeOp
}

func (e *ILikeExpr) ChildCount() int {
	return 2
}

func (e *ILikeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ILikeExpr) Private() interface{} {
	return nil
}

func (e *ILikeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ILikeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ILikeExpr) DataType() types.T {
	return types.Bool
}

type NotILikeExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotILikeExpr{}

func (e *NotILikeExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotILikeExpr) Op() opt.Operator {
	return opt.NotILikeOp
}

func (e *NotILikeExpr) ChildCount() int {
	return 2
}

func (e *NotILikeExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotILikeExpr) Private() interface{} {
	return nil
}

func (e *NotILikeExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotILikeExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotILikeExpr) DataType() types.T {
	return types.Bool
}

type SimilarToExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &SimilarToExpr{}

func (e *SimilarToExpr) ID() opt.ScalarID {
	return e.id
}

func (e *SimilarToExpr) Op() opt.Operator {
	return opt.SimilarToOp
}

func (e *SimilarToExpr) ChildCount() int {
	return 2
}

func (e *SimilarToExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SimilarToExpr) Private() interface{} {
	return nil
}

func (e *SimilarToExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SimilarToExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SimilarToExpr) DataType() types.T {
	return types.Bool
}

type NotSimilarToExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotSimilarToExpr{}

func (e *NotSimilarToExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotSimilarToExpr) Op() opt.Operator {
	return opt.NotSimilarToOp
}

func (e *NotSimilarToExpr) ChildCount() int {
	return 2
}

func (e *NotSimilarToExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotSimilarToExpr) Private() interface{} {
	return nil
}

func (e *NotSimilarToExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotSimilarToExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotSimilarToExpr) DataType() types.T {
	return types.Bool
}

type RegMatchExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &RegMatchExpr{}

func (e *RegMatchExpr) ID() opt.ScalarID {
	return e.id
}

func (e *RegMatchExpr) Op() opt.Operator {
	return opt.RegMatchOp
}

func (e *RegMatchExpr) ChildCount() int {
	return 2
}

func (e *RegMatchExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RegMatchExpr) Private() interface{} {
	return nil
}

func (e *RegMatchExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RegMatchExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RegMatchExpr) DataType() types.T {
	return types.Bool
}

type NotRegMatchExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotRegMatchExpr{}

func (e *NotRegMatchExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotRegMatchExpr) Op() opt.Operator {
	return opt.NotRegMatchOp
}

func (e *NotRegMatchExpr) ChildCount() int {
	return 2
}

func (e *NotRegMatchExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotRegMatchExpr) Private() interface{} {
	return nil
}

func (e *NotRegMatchExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotRegMatchExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotRegMatchExpr) DataType() types.T {
	return types.Bool
}

type RegIMatchExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &RegIMatchExpr{}

func (e *RegIMatchExpr) ID() opt.ScalarID {
	return e.id
}

func (e *RegIMatchExpr) Op() opt.Operator {
	return opt.RegIMatchOp
}

func (e *RegIMatchExpr) ChildCount() int {
	return 2
}

func (e *RegIMatchExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RegIMatchExpr) Private() interface{} {
	return nil
}

func (e *RegIMatchExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RegIMatchExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RegIMatchExpr) DataType() types.T {
	return types.Bool
}

type NotRegIMatchExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &NotRegIMatchExpr{}

func (e *NotRegIMatchExpr) ID() opt.ScalarID {
	return e.id
}

func (e *NotRegIMatchExpr) Op() opt.Operator {
	return opt.NotRegIMatchOp
}

func (e *NotRegIMatchExpr) ChildCount() int {
	return 2
}

func (e *NotRegIMatchExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotRegIMatchExpr) Private() interface{} {
	return nil
}

func (e *NotRegIMatchExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *NotRegIMatchExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *NotRegIMatchExpr) DataType() types.T {
	return types.Bool
}

type IsExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &IsExpr{}

func (e *IsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *IsExpr) Op() opt.Operator {
	return opt.IsOp
}

func (e *IsExpr) ChildCount() int {
	return 2
}

func (e *IsExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IsExpr) Private() interface{} {
	return nil
}

func (e *IsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IsExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IsExpr) DataType() types.T {
	return types.Bool
}

type IsNotExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &IsNotExpr{}

func (e *IsNotExpr) ID() opt.ScalarID {
	return e.id
}

func (e *IsNotExpr) Op() opt.Operator {
	return opt.IsNotOp
}

func (e *IsNotExpr) ChildCount() int {
	return 2
}

func (e *IsNotExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IsNotExpr) Private() interface{} {
	return nil
}

func (e *IsNotExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IsNotExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IsNotExpr) DataType() types.T {
	return types.Bool
}

type ContainsExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &ContainsExpr{}

func (e *ContainsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ContainsExpr) Op() opt.Operator {
	return opt.ContainsOp
}

func (e *ContainsExpr) ChildCount() int {
	return 2
}

func (e *ContainsExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ContainsExpr) Private() interface{} {
	return nil
}

func (e *ContainsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ContainsExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ContainsExpr) DataType() types.T {
	return types.Bool
}

type JsonExistsExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &JsonExistsExpr{}

func (e *JsonExistsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *JsonExistsExpr) Op() opt.Operator {
	return opt.JsonExistsOp
}

func (e *JsonExistsExpr) ChildCount() int {
	return 2
}

func (e *JsonExistsExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonExistsExpr) Private() interface{} {
	return nil
}

func (e *JsonExistsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *JsonExistsExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonExistsExpr) DataType() types.T {
	return types.Bool
}

type JsonAllExistsExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &JsonAllExistsExpr{}

func (e *JsonAllExistsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *JsonAllExistsExpr) Op() opt.Operator {
	return opt.JsonAllExistsOp
}

func (e *JsonAllExistsExpr) ChildCount() int {
	return 2
}

func (e *JsonAllExistsExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonAllExistsExpr) Private() interface{} {
	return nil
}

func (e *JsonAllExistsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *JsonAllExistsExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonAllExistsExpr) DataType() types.T {
	return types.Bool
}

type JsonSomeExistsExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	id opt.ScalarID
}

var _ opt.ScalarExpr = &JsonSomeExistsExpr{}

func (e *JsonSomeExistsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *JsonSomeExistsExpr) Op() opt.Operator {
	return opt.JsonSomeExistsOp
}

func (e *JsonSomeExistsExpr) ChildCount() int {
	return 2
}

func (e *JsonSomeExistsExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonSomeExistsExpr) Private() interface{} {
	return nil
}

func (e *JsonSomeExistsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *JsonSomeExistsExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonSomeExistsExpr) DataType() types.T {
	return types.Bool
}

// AnyScalarExpr is the form of ANY which refers to an ANY operation on a
// tuple or array, as opposed to Any which operates on a subquery.
type AnyScalarExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr
	Cmp   opt.Operator

	id opt.ScalarID
}

var _ opt.ScalarExpr = &AnyScalarExpr{}

func (e *AnyScalarExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AnyScalarExpr) Op() opt.Operator {
	return opt.AnyScalarOp
}

func (e *AnyScalarExpr) ChildCount() int {
	return 2
}

func (e *AnyScalarExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AnyScalarExpr) Private() interface{} {
	return &e.Cmp
}

func (e *AnyScalarExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AnyScalarExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AnyScalarExpr) DataType() types.T {
	return types.Bool
}

type BitandExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &BitandExpr{}

func (e *BitandExpr) ID() opt.ScalarID {
	return e.id
}

func (e *BitandExpr) Op() opt.Operator {
	return opt.BitandOp
}

func (e *BitandExpr) ChildCount() int {
	return 2
}

func (e *BitandExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BitandExpr) Private() interface{} {
	return nil
}

func (e *BitandExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *BitandExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BitandExpr) DataType() types.T {
	return e.Typ
}

type BitorExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &BitorExpr{}

func (e *BitorExpr) ID() opt.ScalarID {
	return e.id
}

func (e *BitorExpr) Op() opt.Operator {
	return opt.BitorOp
}

func (e *BitorExpr) ChildCount() int {
	return 2
}

func (e *BitorExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BitorExpr) Private() interface{} {
	return nil
}

func (e *BitorExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *BitorExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BitorExpr) DataType() types.T {
	return e.Typ
}

type BitxorExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &BitxorExpr{}

func (e *BitxorExpr) ID() opt.ScalarID {
	return e.id
}

func (e *BitxorExpr) Op() opt.Operator {
	return opt.BitxorOp
}

func (e *BitxorExpr) ChildCount() int {
	return 2
}

func (e *BitxorExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BitxorExpr) Private() interface{} {
	return nil
}

func (e *BitxorExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *BitxorExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BitxorExpr) DataType() types.T {
	return e.Typ
}

type PlusExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &PlusExpr{}

func (e *PlusExpr) ID() opt.ScalarID {
	return e.id
}

func (e *PlusExpr) Op() opt.Operator {
	return opt.PlusOp
}

func (e *PlusExpr) ChildCount() int {
	return 2
}

func (e *PlusExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *PlusExpr) Private() interface{} {
	return nil
}

func (e *PlusExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *PlusExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *PlusExpr) DataType() types.T {
	return e.Typ
}

type MinusExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &MinusExpr{}

func (e *MinusExpr) ID() opt.ScalarID {
	return e.id
}

func (e *MinusExpr) Op() opt.Operator {
	return opt.MinusOp
}

func (e *MinusExpr) ChildCount() int {
	return 2
}

func (e *MinusExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MinusExpr) Private() interface{} {
	return nil
}

func (e *MinusExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *MinusExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MinusExpr) DataType() types.T {
	return e.Typ
}

type MultExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &MultExpr{}

func (e *MultExpr) ID() opt.ScalarID {
	return e.id
}

func (e *MultExpr) Op() opt.Operator {
	return opt.MultOp
}

func (e *MultExpr) ChildCount() int {
	return 2
}

func (e *MultExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MultExpr) Private() interface{} {
	return nil
}

func (e *MultExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *MultExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MultExpr) DataType() types.T {
	return e.Typ
}

type DivExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &DivExpr{}

func (e *DivExpr) ID() opt.ScalarID {
	return e.id
}

func (e *DivExpr) Op() opt.Operator {
	return opt.DivOp
}

func (e *DivExpr) ChildCount() int {
	return 2
}

func (e *DivExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *DivExpr) Private() interface{} {
	return nil
}

func (e *DivExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *DivExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *DivExpr) DataType() types.T {
	return e.Typ
}

type FloorDivExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &FloorDivExpr{}

func (e *FloorDivExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FloorDivExpr) Op() opt.Operator {
	return opt.FloorDivOp
}

func (e *FloorDivExpr) ChildCount() int {
	return 2
}

func (e *FloorDivExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FloorDivExpr) Private() interface{} {
	return nil
}

func (e *FloorDivExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FloorDivExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FloorDivExpr) DataType() types.T {
	return e.Typ
}

type ModExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ModExpr{}

func (e *ModExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ModExpr) Op() opt.Operator {
	return opt.ModOp
}

func (e *ModExpr) ChildCount() int {
	return 2
}

func (e *ModExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ModExpr) Private() interface{} {
	return nil
}

func (e *ModExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ModExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ModExpr) DataType() types.T {
	return e.Typ
}

type PowExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &PowExpr{}

func (e *PowExpr) ID() opt.ScalarID {
	return e.id
}

func (e *PowExpr) Op() opt.Operator {
	return opt.PowOp
}

func (e *PowExpr) ChildCount() int {
	return 2
}

func (e *PowExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *PowExpr) Private() interface{} {
	return nil
}

func (e *PowExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *PowExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *PowExpr) DataType() types.T {
	return e.Typ
}

type ConcatExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ConcatExpr{}

func (e *ConcatExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ConcatExpr) Op() opt.Operator {
	return opt.ConcatOp
}

func (e *ConcatExpr) ChildCount() int {
	return 2
}

func (e *ConcatExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConcatExpr) Private() interface{} {
	return nil
}

func (e *ConcatExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ConcatExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConcatExpr) DataType() types.T {
	return e.Typ
}

type LShiftExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &LShiftExpr{}

func (e *LShiftExpr) ID() opt.ScalarID {
	return e.id
}

func (e *LShiftExpr) Op() opt.Operator {
	return opt.LShiftOp
}

func (e *LShiftExpr) ChildCount() int {
	return 2
}

func (e *LShiftExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LShiftExpr) Private() interface{} {
	return nil
}

func (e *LShiftExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *LShiftExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *LShiftExpr) DataType() types.T {
	return e.Typ
}

type RShiftExpr struct {
	Left  opt.ScalarExpr
	Right opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &RShiftExpr{}

func (e *RShiftExpr) ID() opt.ScalarID {
	return e.id
}

func (e *RShiftExpr) Op() opt.Operator {
	return opt.RShiftOp
}

func (e *RShiftExpr) ChildCount() int {
	return 2
}

func (e *RShiftExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RShiftExpr) Private() interface{} {
	return nil
}

func (e *RShiftExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *RShiftExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Left = child.(opt.ScalarExpr)
		return
	case 1:
		e.Right = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *RShiftExpr) DataType() types.T {
	return e.Typ
}

type FetchValExpr struct {
	Json  opt.ScalarExpr
	Index opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &FetchValExpr{}

func (e *FetchValExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FetchValExpr) Op() opt.Operator {
	return opt.FetchValOp
}

func (e *FetchValExpr) ChildCount() int {
	return 2
}

func (e *FetchValExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Json
	case 1:
		return e.Index
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchValExpr) Private() interface{} {
	return nil
}

func (e *FetchValExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FetchValExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Json = child.(opt.ScalarExpr)
		return
	case 1:
		e.Index = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchValExpr) DataType() types.T {
	return e.Typ
}

type FetchTextExpr struct {
	Json  opt.ScalarExpr
	Index opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &FetchTextExpr{}

func (e *FetchTextExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FetchTextExpr) Op() opt.Operator {
	return opt.FetchTextOp
}

func (e *FetchTextExpr) ChildCount() int {
	return 2
}

func (e *FetchTextExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Json
	case 1:
		return e.Index
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchTextExpr) Private() interface{} {
	return nil
}

func (e *FetchTextExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FetchTextExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Json = child.(opt.ScalarExpr)
		return
	case 1:
		e.Index = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchTextExpr) DataType() types.T {
	return e.Typ
}

type FetchValPathExpr struct {
	Json opt.ScalarExpr
	Path opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &FetchValPathExpr{}

func (e *FetchValPathExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FetchValPathExpr) Op() opt.Operator {
	return opt.FetchValPathOp
}

func (e *FetchValPathExpr) ChildCount() int {
	return 2
}

func (e *FetchValPathExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Json
	case 1:
		return e.Path
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchValPathExpr) Private() interface{} {
	return nil
}

func (e *FetchValPathExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FetchValPathExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Json = child.(opt.ScalarExpr)
		return
	case 1:
		e.Path = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchValPathExpr) DataType() types.T {
	return e.Typ
}

type FetchTextPathExpr struct {
	Json opt.ScalarExpr
	Path opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &FetchTextPathExpr{}

func (e *FetchTextPathExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FetchTextPathExpr) Op() opt.Operator {
	return opt.FetchTextPathOp
}

func (e *FetchTextPathExpr) ChildCount() int {
	return 2
}

func (e *FetchTextPathExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Json
	case 1:
		return e.Path
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchTextPathExpr) Private() interface{} {
	return nil
}

func (e *FetchTextPathExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FetchTextPathExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Json = child.(opt.ScalarExpr)
		return
	case 1:
		e.Path = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FetchTextPathExpr) DataType() types.T {
	return e.Typ
}

type UnaryMinusExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &UnaryMinusExpr{}

func (e *UnaryMinusExpr) ID() opt.ScalarID {
	return e.id
}

func (e *UnaryMinusExpr) Op() opt.Operator {
	return opt.UnaryMinusOp
}

func (e *UnaryMinusExpr) ChildCount() int {
	return 1
}

func (e *UnaryMinusExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnaryMinusExpr) Private() interface{} {
	return nil
}

func (e *UnaryMinusExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UnaryMinusExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnaryMinusExpr) DataType() types.T {
	return e.Typ
}

type UnaryComplementExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &UnaryComplementExpr{}

func (e *UnaryComplementExpr) ID() opt.ScalarID {
	return e.id
}

func (e *UnaryComplementExpr) Op() opt.Operator {
	return opt.UnaryComplementOp
}

func (e *UnaryComplementExpr) ChildCount() int {
	return 1
}

func (e *UnaryComplementExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnaryComplementExpr) Private() interface{} {
	return nil
}

func (e *UnaryComplementExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UnaryComplementExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnaryComplementExpr) DataType() types.T {
	return e.Typ
}

// CastExpr converts the input expression into an expression of the target type.
// While the input's type is restricted to the datum types in the types package,
// the target type can be any of the column types in the coltypes package. For
// example, this is a legal cast:
//
//   'hello'::VARCHAR(2)
//
// That expression has the effect of truncating the string to just 'he', since
// the target data type allows a maximum of two characters. This is one example
// of a "lossy" cast.
type CastExpr struct {
	Input     opt.ScalarExpr
	TargetTyp coltypes.T

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &CastExpr{}

func (e *CastExpr) ID() opt.ScalarID {
	return e.id
}

func (e *CastExpr) Op() opt.Operator {
	return opt.CastOp
}

func (e *CastExpr) ChildCount() int {
	return 1
}

func (e *CastExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CastExpr) Private() interface{} {
	return e.TargetTyp
}

func (e *CastExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CastExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CastExpr) DataType() types.T {
	return e.Typ
}

// IfErrExpr is roughly a runtime try-catch operator. It has different semantics
// depending on which of its fields are set.
//
// If ErrCode is set, only errors which match the given error code will be
// caught. If ErrCode is not set, all errors will be caught.
//
// If OrElse is not set, IfErr evaluates to true or false indicating whether an
// error was caught.  If OrElse is set, IfErr evaluates to Cond if no error was
// caught and to OrElse if an error was caught.
//
// TODO(justin): The implementation here is a hack: ErrCode and OrElse are
// optional, so we repurpose lists as an optional field (since it's not
// valid to use nil). If this comes up again, we might want to consider
// adding an explicit Option type.
type IfErrExpr struct {
	Cond opt.ScalarExpr

	// OrElse and ErrCode will be lists with a single element if their respective
	// values are set, and empty lists otherwise.
	OrElse  ScalarListExpr
	ErrCode ScalarListExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &IfErrExpr{}

func (e *IfErrExpr) ID() opt.ScalarID {
	return e.id
}

func (e *IfErrExpr) Op() opt.Operator {
	return opt.IfErrOp
}

func (e *IfErrExpr) ChildCount() int {
	return 3
}

func (e *IfErrExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Cond
	case 1:
		return &e.OrElse
	case 2:
		return &e.ErrCode
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IfErrExpr) Private() interface{} {
	return nil
}

func (e *IfErrExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IfErrExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Cond = child.(opt.ScalarExpr)
		return
	case 1:
		e.OrElse = *child.(*ScalarListExpr)
		return
	case 2:
		e.ErrCode = *child.(*ScalarListExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IfErrExpr) DataType() types.T {
	return e.Typ
}

// CaseExpr is a CASE statement of the form:
//
//   CASE [ <Input> ]
//       WHEN <condval1> THEN <expr1>
//     [ WHEN <condval2> THEN <expr2> ] ...
//     [ ELSE <expr> ]
//   END
//
// The Case operator evaluates <Input> (if not provided, Input is set to True),
// then picks the WHEN branch where <condval> is equal to <Input>, then evaluates
// and returns the corresponding THEN expression. If no WHEN branch matches, the
// ELSE expression is evaluated and returned, if any. Otherwise, NULL is
// returned.
//
// Note that the Whens list inside Case is used to represent all the WHEN
// branches as well as the ELSE statement if it exists. It is of the form:
//
//   [(When <condval1> <expr1>),(When <condval2> <expr2>),...,<expr>]
//
type CaseExpr struct {
	Input  opt.ScalarExpr
	Whens  ScalarListExpr
	OrElse opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &CaseExpr{}

func (e *CaseExpr) ID() opt.ScalarID {
	return e.id
}

func (e *CaseExpr) Op() opt.Operator {
	return opt.CaseOp
}

func (e *CaseExpr) ChildCount() int {
	return 3
}

func (e *CaseExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return &e.Whens
	case 2:
		return e.OrElse
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CaseExpr) Private() interface{} {
	return nil
}

func (e *CaseExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CaseExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	case 1:
		e.Whens = *child.(*ScalarListExpr)
		return
	case 2:
		e.OrElse = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CaseExpr) DataType() types.T {
	return e.Typ
}

// WhenExpr represents a single WHEN ... THEN ... condition inside a CASE statement.
// It is the type of each list item in Whens (except for the last item which is
// a raw expression for the ELSE statement).
type WhenExpr struct {
	Condition opt.ScalarExpr
	Value     opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &WhenExpr{}

func (e *WhenExpr) ID() opt.ScalarID {
	return e.id
}

func (e *WhenExpr) Op() opt.Operator {
	return opt.WhenOp
}

func (e *WhenExpr) ChildCount() int {
	return 2
}

func (e *WhenExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Condition
	case 1:
		return e.Value
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *WhenExpr) Private() interface{} {
	return nil
}

func (e *WhenExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *WhenExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Condition = child.(opt.ScalarExpr)
		return
	case 1:
		e.Value = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *WhenExpr) DataType() types.T {
	return e.Typ
}

// ArrayExpr is an ARRAY literal of the form ARRAY[<expr1>, <expr2>, ..., <exprN>].
type ArrayExpr struct {
	Elems ScalarListExpr
	Typ   types.T

	id opt.ScalarID
}

var _ opt.ScalarExpr = &ArrayExpr{}

func (e *ArrayExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ArrayExpr) Op() opt.Operator {
	return opt.ArrayOp
}

func (e *ArrayExpr) ChildCount() int {
	return 1
}

func (e *ArrayExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return &e.Elems
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ArrayExpr) Private() interface{} {
	return e.Typ
}

func (e *ArrayExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ArrayExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Elems = *child.(*ScalarListExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ArrayExpr) DataType() types.T {
	return e.Typ
}

// IndirectionExpr is a subscripting expression of the form <expr>[<index>].
// Input must be an Array type and Index must be an int. Multiple indirections
// and slicing are not supported.
type IndirectionExpr struct {
	Input opt.ScalarExpr
	Index opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &IndirectionExpr{}

func (e *IndirectionExpr) ID() opt.ScalarID {
	return e.id
}

func (e *IndirectionExpr) Op() opt.Operator {
	return opt.IndirectionOp
}

func (e *IndirectionExpr) ChildCount() int {
	return 2
}

func (e *IndirectionExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return e.Index
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IndirectionExpr) Private() interface{} {
	return nil
}

func (e *IndirectionExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *IndirectionExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	case 1:
		e.Index = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *IndirectionExpr) DataType() types.T {
	return e.Typ
}

// ArrayFlattenExpr is an ARRAY(<subquery>) expression. ArrayFlatten takes as input
// a subquery which returns a single column and constructs a scalar array as the
// output. Any NULLs are included in the results, and if the subquery has an
// ORDER BY clause that ordering will be respected by the resulting array.
type ArrayFlattenExpr struct {
	Input RelExpr
	SubqueryPrivate

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ArrayFlattenExpr{}

func (e *ArrayFlattenExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ArrayFlattenExpr) Op() opt.Operator {
	return opt.ArrayFlattenOp
}

func (e *ArrayFlattenExpr) ChildCount() int {
	return 1
}

func (e *ArrayFlattenExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ArrayFlattenExpr) Private() interface{} {
	return &e.SubqueryPrivate
}

func (e *ArrayFlattenExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ArrayFlattenExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ArrayFlattenExpr) DataType() types.T {
	return e.Typ
}

// FunctionExpr invokes a builtin SQL function like CONCAT or NOW, passing the given
// arguments. The FunctionPrivate field contains the name of the function as well
// as pointers to its type and properties.
type FunctionExpr struct {
	Args ScalarListExpr
	FunctionPrivate

	id opt.ScalarID
}

var _ opt.ScalarExpr = &FunctionExpr{}

func (e *FunctionExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FunctionExpr) Op() opt.Operator {
	return opt.FunctionOp
}

func (e *FunctionExpr) ChildCount() int {
	return 1
}

func (e *FunctionExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return &e.Args
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FunctionExpr) Private() interface{} {
	return &e.FunctionPrivate
}

func (e *FunctionExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FunctionExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Args = *child.(*ScalarListExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FunctionExpr) DataType() types.T {
	return e.Typ
}

type FunctionPrivate struct {
	Name       string
	Typ        types.T
	Properties *tree.FunctionProperties
	Overload   *tree.Overload
}

// CollateExpr is an expression of the form
//
//     x COLLATE y
//
// Where x is a "string type" (meaning either a normal string or a collated string),
// and y is a locale. It evaluates to the string collated to the given locale.
type CollateExpr struct {
	Input  opt.ScalarExpr
	Locale string

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &CollateExpr{}

func (e *CollateExpr) ID() opt.ScalarID {
	return e.id
}

func (e *CollateExpr) Op() opt.Operator {
	return opt.CollateOp
}

func (e *CollateExpr) ChildCount() int {
	return 1
}

func (e *CollateExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CollateExpr) Private() interface{} {
	return &e.Locale
}

func (e *CollateExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CollateExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CollateExpr) DataType() types.T {
	return e.Typ
}

type CoalesceExpr struct {
	Args ScalarListExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &CoalesceExpr{}

func (e *CoalesceExpr) ID() opt.ScalarID {
	return e.id
}

func (e *CoalesceExpr) Op() opt.Operator {
	return opt.CoalesceOp
}

func (e *CoalesceExpr) ChildCount() int {
	return 1
}

func (e *CoalesceExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return &e.Args
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CoalesceExpr) Private() interface{} {
	return nil
}

func (e *CoalesceExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CoalesceExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Args = *child.(*ScalarListExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CoalesceExpr) DataType() types.T {
	return e.Typ
}

// ColumnAccessExpr is a scalar expression that returns a column from the given
// input expression (which is assumed to be of type Tuple). Idx is the ordinal
// index of the column in Input.
type ColumnAccessExpr struct {
	Input opt.ScalarExpr
	Idx   TupleOrdinal

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ColumnAccessExpr{}

func (e *ColumnAccessExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ColumnAccessExpr) Op() opt.Operator {
	return opt.ColumnAccessOp
}

func (e *ColumnAccessExpr) ChildCount() int {
	return 1
}

func (e *ColumnAccessExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ColumnAccessExpr) Private() interface{} {
	return &e.Idx
}

func (e *ColumnAccessExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ColumnAccessExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ColumnAccessExpr) DataType() types.T {
	return e.Typ
}

// UnsupportedExprExpr is used for interfacing with the old planner code. It can
// encapsulate a TypedExpr that is otherwise not supported by the optimizer.
type UnsupportedExprExpr struct {
	Value tree.TypedExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &UnsupportedExprExpr{}

func (e *UnsupportedExprExpr) ID() opt.ScalarID {
	return e.id
}

func (e *UnsupportedExprExpr) Op() opt.Operator {
	return opt.UnsupportedExprOp
}

func (e *UnsupportedExprExpr) ChildCount() int {
	return 0
}

func (e *UnsupportedExprExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnsupportedExprExpr) Private() interface{} {
	return e.Value
}

func (e *UnsupportedExprExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UnsupportedExprExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UnsupportedExprExpr) DataType() types.T {
	return e.Typ
}

type ArrayAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ArrayAggExpr{}

func (e *ArrayAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ArrayAggExpr) Op() opt.Operator {
	return opt.ArrayAggOp
}

func (e *ArrayAggExpr) ChildCount() int {
	return 1
}

func (e *ArrayAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ArrayAggExpr) Private() interface{} {
	return nil
}

func (e *ArrayAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ArrayAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ArrayAggExpr) DataType() types.T {
	return e.Typ
}

type AvgExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &AvgExpr{}

func (e *AvgExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AvgExpr) Op() opt.Operator {
	return opt.AvgOp
}

func (e *AvgExpr) ChildCount() int {
	return 1
}

func (e *AvgExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AvgExpr) Private() interface{} {
	return nil
}

func (e *AvgExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AvgExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AvgExpr) DataType() types.T {
	return e.Typ
}

type BoolAndExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &BoolAndExpr{}

func (e *BoolAndExpr) ID() opt.ScalarID {
	return e.id
}

func (e *BoolAndExpr) Op() opt.Operator {
	return opt.BoolAndOp
}

func (e *BoolAndExpr) ChildCount() int {
	return 1
}

func (e *BoolAndExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BoolAndExpr) Private() interface{} {
	return nil
}

func (e *BoolAndExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *BoolAndExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BoolAndExpr) DataType() types.T {
	return e.Typ
}

type BoolOrExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &BoolOrExpr{}

func (e *BoolOrExpr) ID() opt.ScalarID {
	return e.id
}

func (e *BoolOrExpr) Op() opt.Operator {
	return opt.BoolOrOp
}

func (e *BoolOrExpr) ChildCount() int {
	return 1
}

func (e *BoolOrExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BoolOrExpr) Private() interface{} {
	return nil
}

func (e *BoolOrExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *BoolOrExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *BoolOrExpr) DataType() types.T {
	return e.Typ
}

type ConcatAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ConcatAggExpr{}

func (e *ConcatAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ConcatAggExpr) Op() opt.Operator {
	return opt.ConcatAggOp
}

func (e *ConcatAggExpr) ChildCount() int {
	return 1
}

func (e *ConcatAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConcatAggExpr) Private() interface{} {
	return nil
}

func (e *ConcatAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ConcatAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConcatAggExpr) DataType() types.T {
	return e.Typ
}

type CountExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &CountExpr{}

func (e *CountExpr) ID() opt.ScalarID {
	return e.id
}

func (e *CountExpr) Op() opt.Operator {
	return opt.CountOp
}

func (e *CountExpr) ChildCount() int {
	return 1
}

func (e *CountExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CountExpr) Private() interface{} {
	return nil
}

func (e *CountExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CountExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CountExpr) DataType() types.T {
	return e.Typ
}

type CountRowsExpr struct {
	id opt.ScalarID
}

var _ opt.ScalarExpr = &CountRowsExpr{}

func (e *CountRowsExpr) ID() opt.ScalarID {
	return e.id
}

func (e *CountRowsExpr) Op() opt.Operator {
	return opt.CountRowsOp
}

func (e *CountRowsExpr) ChildCount() int {
	return 0
}

func (e *CountRowsExpr) Child(nth int) opt.Expr {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CountRowsExpr) Private() interface{} {
	return nil
}

func (e *CountRowsExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CountRowsExpr) SetChild(nth int, child opt.Expr) {
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CountRowsExpr) DataType() types.T {
	return types.Int
}

type MaxExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &MaxExpr{}

func (e *MaxExpr) ID() opt.ScalarID {
	return e.id
}

func (e *MaxExpr) Op() opt.Operator {
	return opt.MaxOp
}

func (e *MaxExpr) ChildCount() int {
	return 1
}

func (e *MaxExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MaxExpr) Private() interface{} {
	return nil
}

func (e *MaxExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *MaxExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MaxExpr) DataType() types.T {
	return e.Typ
}

type MinExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &MinExpr{}

func (e *MinExpr) ID() opt.ScalarID {
	return e.id
}

func (e *MinExpr) Op() opt.Operator {
	return opt.MinOp
}

func (e *MinExpr) ChildCount() int {
	return 1
}

func (e *MinExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MinExpr) Private() interface{} {
	return nil
}

func (e *MinExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *MinExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *MinExpr) DataType() types.T {
	return e.Typ
}

type SumIntExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &SumIntExpr{}

func (e *SumIntExpr) ID() opt.ScalarID {
	return e.id
}

func (e *SumIntExpr) Op() opt.Operator {
	return opt.SumIntOp
}

func (e *SumIntExpr) ChildCount() int {
	return 1
}

func (e *SumIntExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SumIntExpr) Private() interface{} {
	return nil
}

func (e *SumIntExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SumIntExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SumIntExpr) DataType() types.T {
	return e.Typ
}

type SumExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &SumExpr{}

func (e *SumExpr) ID() opt.ScalarID {
	return e.id
}

func (e *SumExpr) Op() opt.Operator {
	return opt.SumOp
}

func (e *SumExpr) ChildCount() int {
	return 1
}

func (e *SumExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SumExpr) Private() interface{} {
	return nil
}

func (e *SumExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SumExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SumExpr) DataType() types.T {
	return e.Typ
}

type SqrDiffExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &SqrDiffExpr{}

func (e *SqrDiffExpr) ID() opt.ScalarID {
	return e.id
}

func (e *SqrDiffExpr) Op() opt.Operator {
	return opt.SqrDiffOp
}

func (e *SqrDiffExpr) ChildCount() int {
	return 1
}

func (e *SqrDiffExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SqrDiffExpr) Private() interface{} {
	return nil
}

func (e *SqrDiffExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *SqrDiffExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *SqrDiffExpr) DataType() types.T {
	return e.Typ
}

type VarianceExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &VarianceExpr{}

func (e *VarianceExpr) ID() opt.ScalarID {
	return e.id
}

func (e *VarianceExpr) Op() opt.Operator {
	return opt.VarianceOp
}

func (e *VarianceExpr) ChildCount() int {
	return 1
}

func (e *VarianceExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *VarianceExpr) Private() interface{} {
	return nil
}

func (e *VarianceExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *VarianceExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *VarianceExpr) DataType() types.T {
	return e.Typ
}

type StdDevExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &StdDevExpr{}

func (e *StdDevExpr) ID() opt.ScalarID {
	return e.id
}

func (e *StdDevExpr) Op() opt.Operator {
	return opt.StdDevOp
}

func (e *StdDevExpr) ChildCount() int {
	return 1
}

func (e *StdDevExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *StdDevExpr) Private() interface{} {
	return nil
}

func (e *StdDevExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *StdDevExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *StdDevExpr) DataType() types.T {
	return e.Typ
}

type XorAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &XorAggExpr{}

func (e *XorAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *XorAggExpr) Op() opt.Operator {
	return opt.XorAggOp
}

func (e *XorAggExpr) ChildCount() int {
	return 1
}

func (e *XorAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *XorAggExpr) Private() interface{} {
	return nil
}

func (e *XorAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *XorAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *XorAggExpr) DataType() types.T {
	return e.Typ
}

type JsonAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &JsonAggExpr{}

func (e *JsonAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *JsonAggExpr) Op() opt.Operator {
	return opt.JsonAggOp
}

func (e *JsonAggExpr) ChildCount() int {
	return 1
}

func (e *JsonAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonAggExpr) Private() interface{} {
	return nil
}

func (e *JsonAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *JsonAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonAggExpr) DataType() types.T {
	return e.Typ
}

type JsonbAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &JsonbAggExpr{}

func (e *JsonbAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *JsonbAggExpr) Op() opt.Operator {
	return opt.JsonbAggOp
}

func (e *JsonbAggExpr) ChildCount() int {
	return 1
}

func (e *JsonbAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonbAggExpr) Private() interface{} {
	return nil
}

func (e *JsonbAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *JsonbAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *JsonbAggExpr) DataType() types.T {
	return e.Typ
}

type StringAggExpr struct {
	Input opt.ScalarExpr

	// Sep is the constant expression which separates the input strings.
	// Note that it must always be a constant expression.
	Sep opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &StringAggExpr{}

func (e *StringAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *StringAggExpr) Op() opt.Operator {
	return opt.StringAggOp
}

func (e *StringAggExpr) ChildCount() int {
	return 2
}

func (e *StringAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return e.Sep
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *StringAggExpr) Private() interface{} {
	return nil
}

func (e *StringAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *StringAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	case 1:
		e.Sep = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *StringAggExpr) DataType() types.T {
	return e.Typ
}

// ConstAggExpr is used in the special case when the value of a column is known to be
// constant within a grouping set; it returns that value. If there are no rows
// in the grouping set, then ConstAgg returns NULL.
//
// ConstAgg is not part of SQL, but it's used internally to rewrite correlated
// subqueries into an efficient and convenient form.
type ConstAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ConstAggExpr{}

func (e *ConstAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ConstAggExpr) Op() opt.Operator {
	return opt.ConstAggOp
}

func (e *ConstAggExpr) ChildCount() int {
	return 1
}

func (e *ConstAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConstAggExpr) Private() interface{} {
	return nil
}

func (e *ConstAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ConstAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConstAggExpr) DataType() types.T {
	return e.Typ
}

// ConstNotNullAggExpr is used in the special case when the value of a column is
// known to be constant within a grouping set, except on some rows where it can
// have a NULL value; it returns the non-NULL constant value. If there are no
// rows in the grouping set, or all rows have a NULL value, then ConstNotNullAgg
// returns NULL.
//
// ConstNotNullAgg is not part of SQL, but it's used internally to rewrite
// correlated subqueries into an efficient and convenient form.
type ConstNotNullAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &ConstNotNullAggExpr{}

func (e *ConstNotNullAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *ConstNotNullAggExpr) Op() opt.Operator {
	return opt.ConstNotNullAggOp
}

func (e *ConstNotNullAggExpr) ChildCount() int {
	return 1
}

func (e *ConstNotNullAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConstNotNullAggExpr) Private() interface{} {
	return nil
}

func (e *ConstNotNullAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ConstNotNullAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *ConstNotNullAggExpr) DataType() types.T {
	return e.Typ
}

// AnyNotNullAggExpr returns any non-NULL value it receives, with no other guarantees.
// If it does not receive any values, it returns NULL.
//
// AnyNotNullAgg is not part of SQL, but it's used internally to rewrite
// correlated subqueries into an efficient and convenient form.
type AnyNotNullAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &AnyNotNullAggExpr{}

func (e *AnyNotNullAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AnyNotNullAggExpr) Op() opt.Operator {
	return opt.AnyNotNullAggOp
}

func (e *AnyNotNullAggExpr) ChildCount() int {
	return 1
}

func (e *AnyNotNullAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AnyNotNullAggExpr) Private() interface{} {
	return nil
}

func (e *AnyNotNullAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AnyNotNullAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AnyNotNullAggExpr) DataType() types.T {
	return e.Typ
}

// FirstAggExpr is used only by DistinctOn; it returns the value on the first row
// according to an ordering; if the ordering is unspecified (or partially
// specified), it is an arbitrary ordering but it must be the same across all
// FirstAggs in a DistinctOn.
type FirstAggExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &FirstAggExpr{}

func (e *FirstAggExpr) ID() opt.ScalarID {
	return e.id
}

func (e *FirstAggExpr) Op() opt.Operator {
	return opt.FirstAggOp
}

func (e *FirstAggExpr) ChildCount() int {
	return 1
}

func (e *FirstAggExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FirstAggExpr) Private() interface{} {
	return nil
}

func (e *FirstAggExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *FirstAggExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *FirstAggExpr) DataType() types.T {
	return e.Typ
}

// AggDistinctExpr is used as a modifier that wraps the input of an aggregate
// function. It causes the respective aggregation to only process each distinct
// value once.
type AggDistinctExpr struct {
	Input opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &AggDistinctExpr{}

func (e *AggDistinctExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AggDistinctExpr) Op() opt.Operator {
	return opt.AggDistinctOp
}

func (e *AggDistinctExpr) ChildCount() int {
	return 1
}

func (e *AggDistinctExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AggDistinctExpr) Private() interface{} {
	return nil
}

func (e *AggDistinctExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AggDistinctExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AggDistinctExpr) DataType() types.T {
	return e.Typ
}

// AggFilterExpr is used as a modifier that wraps the input of an aggregate
// function. It causes only rows for which the filter expression is true
// to be processed. AggFilter should always occur on top of AggDistinct
// if they are both present.
type AggFilterExpr struct {
	Input  opt.ScalarExpr
	Filter opt.ScalarExpr

	Typ types.T
	id  opt.ScalarID
}

var _ opt.ScalarExpr = &AggFilterExpr{}

func (e *AggFilterExpr) ID() opt.ScalarID {
	return e.id
}

func (e *AggFilterExpr) Op() opt.Operator {
	return opt.AggFilterOp
}

func (e *AggFilterExpr) ChildCount() int {
	return 2
}

func (e *AggFilterExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	case 1:
		return e.Filter
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AggFilterExpr) Private() interface{} {
	return nil
}

func (e *AggFilterExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *AggFilterExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(opt.ScalarExpr)
		return
	case 1:
		e.Filter = child.(opt.ScalarExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *AggFilterExpr) DataType() types.T {
	return e.Typ
}

// ScalarListExpr is a list expression that has scalar expression items of type
// opt.ScalarExpr. opt.ScalarExpr is an external type that is defined outside of
// Optgen. It is hard-coded in the code generator to be the item type for
// ScalarList.
//
// TODO(andyk): Consider adding Optgen syntax like:
//                define ScalarList []ScalarExpr
type ScalarListExpr []opt.ScalarExpr

var EmptyScalarListExpr = ScalarListExpr{}

var _ opt.ScalarExpr = &ScalarListExpr{}

func (e *ScalarListExpr) ID() opt.ScalarID {
	panic(pgerror.NewAssertionErrorf("lists have no id"))
}

func (e *ScalarListExpr) Op() opt.Operator {
	return opt.ScalarListOp
}

func (e *ScalarListExpr) ChildCount() int {
	return len(*e)
}

func (e *ScalarListExpr) Child(nth int) opt.Expr {
	return (*e)[nth]
}

func (e *ScalarListExpr) Private() interface{} {
	return nil
}

func (e *ScalarListExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, nil)
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *ScalarListExpr) SetChild(nth int, child opt.Expr) {
	(*e)[nth] = child.(opt.ScalarExpr)
}

func (e *ScalarListExpr) DataType() types.T {
	return types.Any
}

// InsertExpr evaluates a relational input expression, and inserts values from it
// into a target table. The input may be an arbitrarily complex expression:
//
//   INSERT INTO ab SELECT x, y+1 FROM xy ORDER BY y
//
// It can also be a simple VALUES clause:
//
//   INSERT INTO ab VALUES (1, 2)
//
// It may also return rows, which can be further composed:
//
//   SELECT a + b FROM [INSERT INTO ab VALUES (1, 2) RETURNING a, b]
//
// The Insert operator is capable of inserting values into computed columns and
// mutation columns, which are not writable (or even visible in the case of
// mutation columns) by SQL users.
type InsertExpr struct {
	Input RelExpr
	MutationPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &InsertExpr{}

func (e *InsertExpr) Op() opt.Operator {
	return opt.InsertOp
}

func (e *InsertExpr) ChildCount() int {
	return 1
}

func (e *InsertExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InsertExpr) Private() interface{} {
	return &e.MutationPrivate
}

func (e *InsertExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *InsertExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *InsertExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *InsertExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *InsertExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *InsertExpr) NextExpr() RelExpr {
	return e.next
}

func (e *InsertExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *InsertExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *InsertExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *InsertExpr) group() exprGroup {
	return e.grp
}

func (e *InsertExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *InsertExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *InsertExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type insertGroup struct {
	mem   *Memo
	rel   props.Relational
	first InsertExpr
	best  bestProps
}

var _ exprGroup = &insertGroup{}

func (g *insertGroup) memo() *Memo {
	return g.mem
}

func (g *insertGroup) relational() *props.Relational {
	return &g.rel
}

func (g *insertGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *insertGroup) bestProps() *bestProps {
	return &g.best
}

type MutationPrivate struct {
	// Table identifies the table which is being mutated. It is an id that can be
	// passed to the Metadata.Table method in order to fetch cat.Table metadata.
	Table opt.TableID

	// InsertCols are columns from the Input expression that will be inserted into
	// the target table. They must be a subset of the Input expression's output
	// columns. The count and order of columns corresponds to the count and order
	// of the target table's columns, including in-progress schema mutation
	// columns. If any column ID is zero, then that column will not be part of
	// the insert operation (e.g. delete-only mutation column). Column values are
	// read from the input columns and are then inserted into the corresponding
	// table columns. For example:
	//
	//   INSERT INTO ab VALUES (1, 2)
	//
	// If there is a delete-only mutation column "c", then InsertCols would contain
	// [a_colid, b_colid, 0].
	InsertCols opt.ColList

	// FetchCols are columns from the Input expression that will be fetched from
	// the target table. They must be a subset of the Input expression's output
	// columns. The count and order of columns corresponds to the count and order
	// of the target table's columns, including in-progress schema mutation
	// columns. If any column ID is zero, then that column will not take part in
	// the update operation (e.g. columns in unreferenced column family).
	//
	// Fetch columns are referenced by update, computed, and constraint
	// expressions. They're also needed to formulate the final key/value pairs;
	// updating even one column in a family requires the entire value to be
	// reformulated. For example:
	//
	//   CREATE TABLE abcd (
	//     a INT PRIMARY KEY, b INT, c INT, d INT, e INT,
	//     FAMILY (a, b), FAMILY (c, d), FAMILY (e))
	//   UPDATE ab SET c=c+1
	//
	// The (a, c, d) columns need to be fetched from the store in order to satisfy
	// the UPDATE query. The "a" column is needed because it's in the primary key.
	// The "c" column is needed because its value is used as part of computing an
	// updated value, and the "d" column is needed because it's in the same family
	// as "c". Taking all this into account, FetchCols would contain this list:
	// [a_colid, 0, c_colid, d_colid, 0].
	FetchCols opt.ColList

	// UpdateCols are columns from the Input expression that contain updated values
	// for columns of the target table. They must be a subset of the Input
	// expression's output columns. The count and order of columns corresponds to
	// the count and order of the target table's columns, including in-progress
	// schema mutation columns. If any column ID is zero, then that column will not
	// take part in the update operation (e.g. columns that are not updated).
	// Updated column values are read from the input columns and are then inserted
	// into the corresponding table columns. For example:
	//
	//   CREATE TABLE abc (a INT PRIMARY KEY, b INT, c INT AS (b+1) AS STORED)
	//   UPDATE abc SET b=1
	//
	// Since column "b" is updated, and "c" is a computed column dependent on "b",
	// then UpdateCols would contain [0, b_colid, c_colid].
	UpdateCols opt.ColList

	// CheckCols are columns from the Input expression containing the results of
	// evaluating the check constraints from the target table. Evaluating a check
	// check constraint expression produces a boolean value which is projected as
	// a column and then checked by the mutation operator. Check columns must be
	// a subset of the Input expression's output columns. The count and order of
	// columns corresponds to the count and order of the target table's Check
	// collection (see the opt.Table.CheckCount and opt.Table.Check methods). If
	// any column ID is zero, then that check will not be performed (i.e. because
	// it's been statically proved to be true). For example:
	//
	//   CREATE TABLE abc (a INT CHECK (a > 0), b INT, c INT CHECK (c <> 0))
	//   UPDATE abc SET a=1, b=b+1
	//
	// Since the check constraint for column "a" can be statically proven to be
	// true, CheckCols would contain [0, b_colid].
	CheckCols opt.ColList

	// CanaryCol is used only with the Upsert operator. It identifies the column
	// that the execution engine uses to decide whether to insert or to update.
	// If the canary column value is null for a particular input row, then a new
	// row is inserted into the table. Otherwise, the existing row is updated.
	// While CanaryCol is 0 for all non-Upsert operators, it is also 0 for the
	// "blind" Upsert case in which a "Put" KV operator inserts a new row or
	// overwrites an existing row.
	CanaryCol opt.ColumnID

	// ReturnCols are the set of columns returned by the mutation operator when
	// the RETURNING clause has been specified. By default, the return columns
	// include all columns in the table, including hidden columns, but not
	// including any columns that are undergoing mutation (being added or dropped
	// as part of online schema change). If no RETURNING clause was specified,
	// then ReturnCols is nil.
	ReturnCols opt.ColList
}

// UpdateExpr evaluates a relational input expression that fetches existing rows from
// a target table and computes new values for one or more columns. Arbitrary
// subsets of rows can be selected from the target table and processed in order,
// as with this example:
//
//   UPDATE abc SET b=10 WHERE a>0 ORDER BY b+c LIMIT 10
//
// The Update operator will also update any computed columns, including mutation
// columns that are computed.
type UpdateExpr struct {
	Input RelExpr
	MutationPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &UpdateExpr{}

func (e *UpdateExpr) Op() opt.Operator {
	return opt.UpdateOp
}

func (e *UpdateExpr) ChildCount() int {
	return 1
}

func (e *UpdateExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UpdateExpr) Private() interface{} {
	return &e.MutationPrivate
}

func (e *UpdateExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UpdateExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UpdateExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *UpdateExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *UpdateExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *UpdateExpr) NextExpr() RelExpr {
	return e.next
}

func (e *UpdateExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *UpdateExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *UpdateExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *UpdateExpr) group() exprGroup {
	return e.grp
}

func (e *UpdateExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *UpdateExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *UpdateExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type updateGroup struct {
	mem   *Memo
	rel   props.Relational
	first UpdateExpr
	best  bestProps
}

var _ exprGroup = &updateGroup{}

func (g *updateGroup) memo() *Memo {
	return g.mem
}

func (g *updateGroup) relational() *props.Relational {
	return &g.rel
}

func (g *updateGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *updateGroup) bestProps() *bestProps {
	return &g.best
}

// UpsertExpr evaluates a relational input expression that tries to insert a new row
// into a target table. If a conflicting row already exists, then Upsert will
// instead update the existing row. The Upsert operator is used for all of these
// syntactic variants:
//
//   INSERT..ON CONFLICT DO UPDATE
//     INSERT INTO abc VALUES (1, 2, 3) ON CONFLICT (a) DO UPDATE SET b=10
//
//   INSERT..ON CONFLICT DO NOTHING
//     INSERT INTO abc VALUES (1, 2, 3) ON CONFLICT DO NOTHING
//
//   UPSERT
//     UPSERT INTO abc VALUES (1, 2, 3)
//
// The Update operator will also insert/update any computed columns, including
// mutation columns that are computed.
type UpsertExpr struct {
	Input RelExpr
	MutationPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &UpsertExpr{}

func (e *UpsertExpr) Op() opt.Operator {
	return opt.UpsertOp
}

func (e *UpsertExpr) ChildCount() int {
	return 1
}

func (e *UpsertExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UpsertExpr) Private() interface{} {
	return &e.MutationPrivate
}

func (e *UpsertExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *UpsertExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *UpsertExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *UpsertExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *UpsertExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *UpsertExpr) NextExpr() RelExpr {
	return e.next
}

func (e *UpsertExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *UpsertExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *UpsertExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *UpsertExpr) group() exprGroup {
	return e.grp
}

func (e *UpsertExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *UpsertExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *UpsertExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type upsertGroup struct {
	mem   *Memo
	rel   props.Relational
	first UpsertExpr
	best  bestProps
}

var _ exprGroup = &upsertGroup{}

func (g *upsertGroup) memo() *Memo {
	return g.mem
}

func (g *upsertGroup) relational() *props.Relational {
	return &g.rel
}

func (g *upsertGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *upsertGroup) bestProps() *bestProps {
	return &g.best
}

// DeleteExpr is an operator used to delete all rows that are selected by a
// relational input expression:
//
//   DELETE FROM abc WHERE a>0 ORDER BY b LIMIT 10
//
type DeleteExpr struct {
	Input RelExpr
	MutationPrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &DeleteExpr{}

func (e *DeleteExpr) Op() opt.Operator {
	return opt.DeleteOp
}

func (e *DeleteExpr) ChildCount() int {
	return 1
}

func (e *DeleteExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *DeleteExpr) Private() interface{} {
	return &e.MutationPrivate
}

func (e *DeleteExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *DeleteExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *DeleteExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *DeleteExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *DeleteExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *DeleteExpr) NextExpr() RelExpr {
	return e.next
}

func (e *DeleteExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *DeleteExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *DeleteExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *DeleteExpr) group() exprGroup {
	return e.grp
}

func (e *DeleteExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *DeleteExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *DeleteExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type deleteGroup struct {
	mem   *Memo
	rel   props.Relational
	first DeleteExpr
	best  bestProps
}

var _ exprGroup = &deleteGroup{}

func (g *deleteGroup) memo() *Memo {
	return g.mem
}

func (g *deleteGroup) relational() *props.Relational {
	return &g.rel
}

func (g *deleteGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *deleteGroup) bestProps() *bestProps {
	return &g.best
}

// CreateTableExpr represents a CREATE TABLE statement.
type CreateTableExpr struct {
	// Input is only used if the AS clause was used in the CREATE TABLE
	// statement. If it was not used, then the Input is a dummy zero row, zero
	// column Values expression (and nil inputs are not allowed).
	Input RelExpr
	CreateTablePrivate

	grp  exprGroup
	next RelExpr
}

var _ RelExpr = &CreateTableExpr{}

func (e *CreateTableExpr) Op() opt.Operator {
	return opt.CreateTableOp
}

func (e *CreateTableExpr) ChildCount() int {
	return 1
}

func (e *CreateTableExpr) Child(nth int) opt.Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CreateTableExpr) Private() interface{} {
	return &e.CreateTablePrivate
}

func (e *CreateTableExpr) String() string {
	f := MakeExprFmtCtx(ExprFmtHideQualifications, e.Memo())
	f.FormatExpr(e)
	return f.Buffer.String()
}

func (e *CreateTableExpr) SetChild(nth int, child opt.Expr) {
	switch nth {
	case 0:
		e.Input = child.(RelExpr)
		return
	}
	panic(pgerror.NewAssertionErrorf("child index out of range"))
}

func (e *CreateTableExpr) Memo() *Memo {
	return e.grp.memo()
}

func (e *CreateTableExpr) Relational() *props.Relational {
	return e.grp.relational()
}

func (e *CreateTableExpr) FirstExpr() RelExpr {
	return e.grp.firstExpr()
}

func (e *CreateTableExpr) NextExpr() RelExpr {
	return e.next
}

func (e *CreateTableExpr) RequiredPhysical() *physical.Required {
	return e.grp.bestProps().required
}

func (e *CreateTableExpr) ProvidedPhysical() *physical.Provided {
	return &e.grp.bestProps().provided
}

func (e *CreateTableExpr) Cost() Cost {
	return e.grp.bestProps().cost
}

func (e *CreateTableExpr) group() exprGroup {
	return e.grp
}

func (e *CreateTableExpr) bestProps() *bestProps {
	return e.grp.bestProps()
}

func (e *CreateTableExpr) setNext(member RelExpr) {
	if e.next != nil {
		panic(pgerror.NewAssertionErrorf("expression already has its next defined: %s", e))
	}
	e.next = member
}

func (e *CreateTableExpr) setGroup(member RelExpr) {
	if e.grp != nil {
		panic(pgerror.NewAssertionErrorf("expression is already in a group: %s", e))
	}
	e.grp = member.group()
	LastGroupMember(member).setNext(e)
}

type createTableGroup struct {
	mem   *Memo
	rel   props.Relational
	first CreateTableExpr
	best  bestProps
}

var _ exprGroup = &createTableGroup{}

func (g *createTableGroup) memo() *Memo {
	return g.mem
}

func (g *createTableGroup) relational() *props.Relational {
	return &g.rel
}

func (g *createTableGroup) firstExpr() RelExpr {
	return &g.first
}

func (g *createTableGroup) bestProps() *bestProps {
	return &g.best
}

type CreateTablePrivate struct {
	// Schema is the ID of the catalog schema into which the new table goes.
	Schema opt.SchemaID

	// InputCols gives the ordering and naming of input columns. It is only
	// defined when the AS clause was used in the CREATE TABLE statement.
	InputCols physical.Presentation

	// Syntax is the CREATE TABLE AST node.
	Syntax *tree.CreateTable
}

func (m *Memo) MemoizeScan(
	scanPrivate *ScanPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(scanGroup{}))
	grp := &scanGroup{mem: m, first: ScanExpr{
		ScanPrivate: *scanPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternScan(e)
	if interned == e {
		m.logPropsBuilder.buildScanProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeVirtualScan(
	virtualScanPrivate *VirtualScanPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(virtualScanGroup{}))
	grp := &virtualScanGroup{mem: m, first: VirtualScanExpr{
		VirtualScanPrivate: *virtualScanPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternVirtualScan(e)
	if interned == e {
		m.logPropsBuilder.buildVirtualScanProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeSequenceSelect(
	sequenceSelectPrivate *SequenceSelectPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(sequenceSelectGroup{}))
	grp := &sequenceSelectGroup{mem: m, first: SequenceSelectExpr{
		SequenceSelectPrivate: *sequenceSelectPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternSequenceSelect(e)
	if interned == e {
		m.logPropsBuilder.buildSequenceSelectProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeValues(
	rows ScalarListExpr,
	valuesPrivate *ValuesPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(valuesGroup{}))
	grp := &valuesGroup{mem: m, first: ValuesExpr{
		Rows:          rows,
		ValuesPrivate: *valuesPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternValues(e)
	if interned == e {
		m.logPropsBuilder.buildValuesProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeSelect(
	input RelExpr,
	filters FiltersExpr,
) RelExpr {
	const size = int64(unsafe.Sizeof(selectGroup{}))
	grp := &selectGroup{mem: m, first: SelectExpr{
		Input:   input,
		Filters: filters,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternSelect(e)
	if interned == e {
		m.logPropsBuilder.buildSelectProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeProject(
	input RelExpr,
	projections ProjectionsExpr,
	passthrough opt.ColSet,
) RelExpr {
	const size = int64(unsafe.Sizeof(projectGroup{}))
	grp := &projectGroup{mem: m, first: ProjectExpr{
		Input:       input,
		Projections: projections,
		Passthrough: passthrough,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternProject(e)
	if interned == e {
		m.logPropsBuilder.buildProjectProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeInnerJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(innerJoinGroup{}))
	grp := &innerJoinGroup{mem: m, first: InnerJoinExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternInnerJoin(e)
	if interned == e {
		m.logPropsBuilder.buildInnerJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeLeftJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(leftJoinGroup{}))
	grp := &leftJoinGroup{mem: m, first: LeftJoinExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternLeftJoin(e)
	if interned == e {
		m.logPropsBuilder.buildLeftJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeRightJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(rightJoinGroup{}))
	grp := &rightJoinGroup{mem: m, first: RightJoinExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternRightJoin(e)
	if interned == e {
		m.logPropsBuilder.buildRightJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeFullJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(fullJoinGroup{}))
	grp := &fullJoinGroup{mem: m, first: FullJoinExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternFullJoin(e)
	if interned == e {
		m.logPropsBuilder.buildFullJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeSemiJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(semiJoinGroup{}))
	grp := &semiJoinGroup{mem: m, first: SemiJoinExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternSemiJoin(e)
	if interned == e {
		m.logPropsBuilder.buildSemiJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeAntiJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(antiJoinGroup{}))
	grp := &antiJoinGroup{mem: m, first: AntiJoinExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternAntiJoin(e)
	if interned == e {
		m.logPropsBuilder.buildAntiJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeIndexJoin(
	input RelExpr,
	indexJoinPrivate *IndexJoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(indexJoinGroup{}))
	grp := &indexJoinGroup{mem: m, first: IndexJoinExpr{
		Input:            input,
		IndexJoinPrivate: *indexJoinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternIndexJoin(e)
	if interned == e {
		m.logPropsBuilder.buildIndexJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeLookupJoin(
	input RelExpr,
	on FiltersExpr,
	lookupJoinPrivate *LookupJoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(lookupJoinGroup{}))
	grp := &lookupJoinGroup{mem: m, first: LookupJoinExpr{
		Input:             input,
		On:                on,
		LookupJoinPrivate: *lookupJoinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternLookupJoin(e)
	if interned == e {
		m.logPropsBuilder.buildLookupJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeMergeJoin(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	mergeJoinPrivate *MergeJoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(mergeJoinGroup{}))
	grp := &mergeJoinGroup{mem: m, first: MergeJoinExpr{
		Left:             left,
		Right:            right,
		On:               on,
		MergeJoinPrivate: *mergeJoinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternMergeJoin(e)
	if interned == e {
		m.logPropsBuilder.buildMergeJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeZigzagJoin(
	on FiltersExpr,
	zigzagJoinPrivate *ZigzagJoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(zigzagJoinGroup{}))
	grp := &zigzagJoinGroup{mem: m, first: ZigzagJoinExpr{
		On:                on,
		ZigzagJoinPrivate: *zigzagJoinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternZigzagJoin(e)
	if interned == e {
		m.logPropsBuilder.buildZigzagJoinProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeInnerJoinApply(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(innerJoinApplyGroup{}))
	grp := &innerJoinApplyGroup{mem: m, first: InnerJoinApplyExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternInnerJoinApply(e)
	if interned == e {
		m.logPropsBuilder.buildInnerJoinApplyProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeLeftJoinApply(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(leftJoinApplyGroup{}))
	grp := &leftJoinApplyGroup{mem: m, first: LeftJoinApplyExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternLeftJoinApply(e)
	if interned == e {
		m.logPropsBuilder.buildLeftJoinApplyProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeRightJoinApply(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(rightJoinApplyGroup{}))
	grp := &rightJoinApplyGroup{mem: m, first: RightJoinApplyExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternRightJoinApply(e)
	if interned == e {
		m.logPropsBuilder.buildRightJoinApplyProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeFullJoinApply(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(fullJoinApplyGroup{}))
	grp := &fullJoinApplyGroup{mem: m, first: FullJoinApplyExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternFullJoinApply(e)
	if interned == e {
		m.logPropsBuilder.buildFullJoinApplyProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeSemiJoinApply(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(semiJoinApplyGroup{}))
	grp := &semiJoinApplyGroup{mem: m, first: SemiJoinApplyExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternSemiJoinApply(e)
	if interned == e {
		m.logPropsBuilder.buildSemiJoinApplyProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeAntiJoinApply(
	left RelExpr,
	right RelExpr,
	on FiltersExpr,
	joinPrivate *JoinPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(antiJoinApplyGroup{}))
	grp := &antiJoinApplyGroup{mem: m, first: AntiJoinApplyExpr{
		Left:        left,
		Right:       right,
		On:          on,
		JoinPrivate: *joinPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternAntiJoinApply(e)
	if interned == e {
		m.logPropsBuilder.buildAntiJoinApplyProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeGroupBy(
	input RelExpr,
	aggregations AggregationsExpr,
	groupingPrivate *GroupingPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(groupByGroup{}))
	grp := &groupByGroup{mem: m, first: GroupByExpr{
		Input:           input,
		Aggregations:    aggregations,
		GroupingPrivate: *groupingPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternGroupBy(e)
	if interned == e {
		m.logPropsBuilder.buildGroupByProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeScalarGroupBy(
	input RelExpr,
	aggregations AggregationsExpr,
	groupingPrivate *GroupingPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(scalarGroupByGroup{}))
	grp := &scalarGroupByGroup{mem: m, first: ScalarGroupByExpr{
		Input:           input,
		Aggregations:    aggregations,
		GroupingPrivate: *groupingPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternScalarGroupBy(e)
	if interned == e {
		m.logPropsBuilder.buildScalarGroupByProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeDistinctOn(
	input RelExpr,
	aggregations AggregationsExpr,
	groupingPrivate *GroupingPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(distinctOnGroup{}))
	grp := &distinctOnGroup{mem: m, first: DistinctOnExpr{
		Input:           input,
		Aggregations:    aggregations,
		GroupingPrivate: *groupingPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternDistinctOn(e)
	if interned == e {
		m.logPropsBuilder.buildDistinctOnProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeUnion(
	left RelExpr,
	right RelExpr,
	setPrivate *SetPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(unionGroup{}))
	grp := &unionGroup{mem: m, first: UnionExpr{
		Left:       left,
		Right:      right,
		SetPrivate: *setPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternUnion(e)
	if interned == e {
		m.logPropsBuilder.buildUnionProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeIntersect(
	left RelExpr,
	right RelExpr,
	setPrivate *SetPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(intersectGroup{}))
	grp := &intersectGroup{mem: m, first: IntersectExpr{
		Left:       left,
		Right:      right,
		SetPrivate: *setPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternIntersect(e)
	if interned == e {
		m.logPropsBuilder.buildIntersectProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeExcept(
	left RelExpr,
	right RelExpr,
	setPrivate *SetPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(exceptGroup{}))
	grp := &exceptGroup{mem: m, first: ExceptExpr{
		Left:       left,
		Right:      right,
		SetPrivate: *setPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternExcept(e)
	if interned == e {
		m.logPropsBuilder.buildExceptProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeUnionAll(
	left RelExpr,
	right RelExpr,
	setPrivate *SetPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(unionAllGroup{}))
	grp := &unionAllGroup{mem: m, first: UnionAllExpr{
		Left:       left,
		Right:      right,
		SetPrivate: *setPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternUnionAll(e)
	if interned == e {
		m.logPropsBuilder.buildUnionAllProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeIntersectAll(
	left RelExpr,
	right RelExpr,
	setPrivate *SetPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(intersectAllGroup{}))
	grp := &intersectAllGroup{mem: m, first: IntersectAllExpr{
		Left:       left,
		Right:      right,
		SetPrivate: *setPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternIntersectAll(e)
	if interned == e {
		m.logPropsBuilder.buildIntersectAllProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeExceptAll(
	left RelExpr,
	right RelExpr,
	setPrivate *SetPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(exceptAllGroup{}))
	grp := &exceptAllGroup{mem: m, first: ExceptAllExpr{
		Left:       left,
		Right:      right,
		SetPrivate: *setPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternExceptAll(e)
	if interned == e {
		m.logPropsBuilder.buildExceptAllProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeLimit(
	input RelExpr,
	limit opt.ScalarExpr,
	ordering physical.OrderingChoice,
) RelExpr {
	const size = int64(unsafe.Sizeof(limitGroup{}))
	grp := &limitGroup{mem: m, first: LimitExpr{
		Input:    input,
		Limit:    limit,
		Ordering: ordering,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternLimit(e)
	if interned == e {
		m.logPropsBuilder.buildLimitProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeOffset(
	input RelExpr,
	offset opt.ScalarExpr,
	ordering physical.OrderingChoice,
) RelExpr {
	const size = int64(unsafe.Sizeof(offsetGroup{}))
	grp := &offsetGroup{mem: m, first: OffsetExpr{
		Input:    input,
		Offset:   offset,
		Ordering: ordering,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternOffset(e)
	if interned == e {
		m.logPropsBuilder.buildOffsetProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeMax1Row(
	input RelExpr,
) RelExpr {
	const size = int64(unsafe.Sizeof(max1RowGroup{}))
	grp := &max1RowGroup{mem: m, first: Max1RowExpr{
		Input: input,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternMax1Row(e)
	if interned == e {
		m.logPropsBuilder.buildMax1RowProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeExplain(
	input RelExpr,
	explainPrivate *ExplainPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(explainGroup{}))
	grp := &explainGroup{mem: m, first: ExplainExpr{
		Input:          input,
		ExplainPrivate: *explainPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternExplain(e)
	if interned == e {
		m.logPropsBuilder.buildExplainProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeShowTraceForSession(
	showTracePrivate *ShowTracePrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(showTraceForSessionGroup{}))
	grp := &showTraceForSessionGroup{mem: m, first: ShowTraceForSessionExpr{
		ShowTracePrivate: *showTracePrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternShowTraceForSession(e)
	if interned == e {
		m.logPropsBuilder.buildShowTraceForSessionProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeRowNumber(
	input RelExpr,
	rowNumberPrivate *RowNumberPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(rowNumberGroup{}))
	grp := &rowNumberGroup{mem: m, first: RowNumberExpr{
		Input:            input,
		RowNumberPrivate: *rowNumberPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternRowNumber(e)
	if interned == e {
		m.logPropsBuilder.buildRowNumberProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeProjectSet(
	input RelExpr,
	zip ZipExpr,
) RelExpr {
	const size = int64(unsafe.Sizeof(projectSetGroup{}))
	grp := &projectSetGroup{mem: m, first: ProjectSetExpr{
		Input: input,
		Zip:   zip,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternProjectSet(e)
	if interned == e {
		m.logPropsBuilder.buildProjectSetProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeSubquery(
	input RelExpr,
	subqueryPrivate *SubqueryPrivate,
) *SubqueryExpr {
	const size = int64(unsafe.Sizeof(SubqueryExpr{}))
	e := &SubqueryExpr{
		Input:           input,
		SubqueryPrivate: *subqueryPrivate,
		id:              m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternSubquery(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAny(
	input RelExpr,
	scalar opt.ScalarExpr,
	subqueryPrivate *SubqueryPrivate,
) *AnyExpr {
	const size = int64(unsafe.Sizeof(AnyExpr{}))
	e := &AnyExpr{
		Input:           input,
		Scalar:          scalar,
		SubqueryPrivate: *subqueryPrivate,
		id:              m.NextID(),
	}
	interned := m.interner.InternAny(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeExists(
	input RelExpr,
	subqueryPrivate *SubqueryPrivate,
) *ExistsExpr {
	const size = int64(unsafe.Sizeof(ExistsExpr{}))
	e := &ExistsExpr{
		Input:           input,
		SubqueryPrivate: *subqueryPrivate,
		id:              m.NextID(),
	}
	interned := m.interner.InternExists(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeVariable(
	col opt.ColumnID,
) *VariableExpr {
	const size = int64(unsafe.Sizeof(VariableExpr{}))
	e := &VariableExpr{
		Col: col,
		id:  m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternVariable(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeConst(
	value tree.Datum,
) *ConstExpr {
	const size = int64(unsafe.Sizeof(ConstExpr{}))
	e := &ConstExpr{
		Value: value,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternConst(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNull(
	typ types.T,
) *NullExpr {
	const size = int64(unsafe.Sizeof(NullExpr{}))
	e := &NullExpr{
		Typ: typ,
		id:  m.NextID(),
	}
	interned := m.interner.InternNull(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeTrue() *TrueExpr {
	return TrueSingleton
}

func (m *Memo) MemoizeFalse() *FalseExpr {
	return FalseSingleton
}

func (m *Memo) MemoizePlaceholder(
	value tree.TypedExpr,
) *PlaceholderExpr {
	const size = int64(unsafe.Sizeof(PlaceholderExpr{}))
	e := &PlaceholderExpr{
		Value: value,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternPlaceholder(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeTuple(
	elems ScalarListExpr,
	typ types.T,
) *TupleExpr {
	const size = int64(unsafe.Sizeof(TupleExpr{}))
	e := &TupleExpr{
		Elems: elems,
		Typ:   typ,
		id:    m.NextID(),
	}
	interned := m.interner.InternTuple(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAnd(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *AndExpr {
	const size = int64(unsafe.Sizeof(AndExpr{}))
	e := &AndExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternAnd(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeOr(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *OrExpr {
	const size = int64(unsafe.Sizeof(OrExpr{}))
	e := &OrExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternOr(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeRange(
	and opt.ScalarExpr,
) *RangeExpr {
	const size = int64(unsafe.Sizeof(RangeExpr{}))
	e := &RangeExpr{
		And: and,
		id:  m.NextID(),
	}
	interned := m.interner.InternRange(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNot(
	input opt.ScalarExpr,
) *NotExpr {
	const size = int64(unsafe.Sizeof(NotExpr{}))
	e := &NotExpr{
		Input: input,
		id:    m.NextID(),
	}
	interned := m.interner.InternNot(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeEq(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *EqExpr {
	const size = int64(unsafe.Sizeof(EqExpr{}))
	e := &EqExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternEq(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeLt(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *LtExpr {
	const size = int64(unsafe.Sizeof(LtExpr{}))
	e := &LtExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternLt(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeGt(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *GtExpr {
	const size = int64(unsafe.Sizeof(GtExpr{}))
	e := &GtExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternGt(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeLe(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *LeExpr {
	const size = int64(unsafe.Sizeof(LeExpr{}))
	e := &LeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternLe(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeGe(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *GeExpr {
	const size = int64(unsafe.Sizeof(GeExpr{}))
	e := &GeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternGe(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNe(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NeExpr {
	const size = int64(unsafe.Sizeof(NeExpr{}))
	e := &NeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNe(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeIn(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *InExpr {
	const size = int64(unsafe.Sizeof(InExpr{}))
	e := &InExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternIn(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNotIn(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NotInExpr {
	const size = int64(unsafe.Sizeof(NotInExpr{}))
	e := &NotInExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNotIn(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeLike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *LikeExpr {
	const size = int64(unsafe.Sizeof(LikeExpr{}))
	e := &LikeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternLike(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNotLike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NotLikeExpr {
	const size = int64(unsafe.Sizeof(NotLikeExpr{}))
	e := &NotLikeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNotLike(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeILike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *ILikeExpr {
	const size = int64(unsafe.Sizeof(ILikeExpr{}))
	e := &ILikeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternILike(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNotILike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NotILikeExpr {
	const size = int64(unsafe.Sizeof(NotILikeExpr{}))
	e := &NotILikeExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNotILike(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeSimilarTo(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *SimilarToExpr {
	const size = int64(unsafe.Sizeof(SimilarToExpr{}))
	e := &SimilarToExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternSimilarTo(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNotSimilarTo(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NotSimilarToExpr {
	const size = int64(unsafe.Sizeof(NotSimilarToExpr{}))
	e := &NotSimilarToExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNotSimilarTo(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeRegMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *RegMatchExpr {
	const size = int64(unsafe.Sizeof(RegMatchExpr{}))
	e := &RegMatchExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternRegMatch(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNotRegMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NotRegMatchExpr {
	const size = int64(unsafe.Sizeof(NotRegMatchExpr{}))
	e := &NotRegMatchExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNotRegMatch(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeRegIMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *RegIMatchExpr {
	const size = int64(unsafe.Sizeof(RegIMatchExpr{}))
	e := &RegIMatchExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternRegIMatch(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeNotRegIMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *NotRegIMatchExpr {
	const size = int64(unsafe.Sizeof(NotRegIMatchExpr{}))
	e := &NotRegIMatchExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternNotRegIMatch(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeIs(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *IsExpr {
	const size = int64(unsafe.Sizeof(IsExpr{}))
	e := &IsExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternIs(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeIsNot(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *IsNotExpr {
	const size = int64(unsafe.Sizeof(IsNotExpr{}))
	e := &IsNotExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternIsNot(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeContains(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *ContainsExpr {
	const size = int64(unsafe.Sizeof(ContainsExpr{}))
	e := &ContainsExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternContains(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeJsonExists(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *JsonExistsExpr {
	const size = int64(unsafe.Sizeof(JsonExistsExpr{}))
	e := &JsonExistsExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternJsonExists(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeJsonAllExists(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *JsonAllExistsExpr {
	const size = int64(unsafe.Sizeof(JsonAllExistsExpr{}))
	e := &JsonAllExistsExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternJsonAllExists(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeJsonSomeExists(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *JsonSomeExistsExpr {
	const size = int64(unsafe.Sizeof(JsonSomeExistsExpr{}))
	e := &JsonSomeExistsExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	interned := m.interner.InternJsonSomeExists(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAnyScalar(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
	cmp opt.Operator,
) *AnyScalarExpr {
	const size = int64(unsafe.Sizeof(AnyScalarExpr{}))
	e := &AnyScalarExpr{
		Left:  left,
		Right: right,
		Cmp:   cmp,
		id:    m.NextID(),
	}
	interned := m.interner.InternAnyScalar(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeBitand(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *BitandExpr {
	const size = int64(unsafe.Sizeof(BitandExpr{}))
	e := &BitandExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternBitand(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeBitor(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *BitorExpr {
	const size = int64(unsafe.Sizeof(BitorExpr{}))
	e := &BitorExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternBitor(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeBitxor(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *BitxorExpr {
	const size = int64(unsafe.Sizeof(BitxorExpr{}))
	e := &BitxorExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternBitxor(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizePlus(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *PlusExpr {
	const size = int64(unsafe.Sizeof(PlusExpr{}))
	e := &PlusExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternPlus(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeMinus(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *MinusExpr {
	const size = int64(unsafe.Sizeof(MinusExpr{}))
	e := &MinusExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternMinus(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeMult(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *MultExpr {
	const size = int64(unsafe.Sizeof(MultExpr{}))
	e := &MultExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternMult(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeDiv(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *DivExpr {
	const size = int64(unsafe.Sizeof(DivExpr{}))
	e := &DivExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternDiv(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFloorDiv(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *FloorDivExpr {
	const size = int64(unsafe.Sizeof(FloorDivExpr{}))
	e := &FloorDivExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternFloorDiv(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeMod(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *ModExpr {
	const size = int64(unsafe.Sizeof(ModExpr{}))
	e := &ModExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternMod(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizePow(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *PowExpr {
	const size = int64(unsafe.Sizeof(PowExpr{}))
	e := &PowExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternPow(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeConcat(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *ConcatExpr {
	const size = int64(unsafe.Sizeof(ConcatExpr{}))
	e := &ConcatExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternConcat(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeLShift(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *LShiftExpr {
	const size = int64(unsafe.Sizeof(LShiftExpr{}))
	e := &LShiftExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternLShift(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeRShift(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) *RShiftExpr {
	const size = int64(unsafe.Sizeof(RShiftExpr{}))
	e := &RShiftExpr{
		Left:  left,
		Right: right,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternRShift(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFetchVal(
	json opt.ScalarExpr,
	index opt.ScalarExpr,
) *FetchValExpr {
	const size = int64(unsafe.Sizeof(FetchValExpr{}))
	e := &FetchValExpr{
		Json:  json,
		Index: index,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternFetchVal(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFetchText(
	json opt.ScalarExpr,
	index opt.ScalarExpr,
) *FetchTextExpr {
	const size = int64(unsafe.Sizeof(FetchTextExpr{}))
	e := &FetchTextExpr{
		Json:  json,
		Index: index,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternFetchText(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFetchValPath(
	json opt.ScalarExpr,
	path opt.ScalarExpr,
) *FetchValPathExpr {
	const size = int64(unsafe.Sizeof(FetchValPathExpr{}))
	e := &FetchValPathExpr{
		Json: json,
		Path: path,
		id:   m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternFetchValPath(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFetchTextPath(
	json opt.ScalarExpr,
	path opt.ScalarExpr,
) *FetchTextPathExpr {
	const size = int64(unsafe.Sizeof(FetchTextPathExpr{}))
	e := &FetchTextPathExpr{
		Json: json,
		Path: path,
		id:   m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternFetchTextPath(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeUnaryMinus(
	input opt.ScalarExpr,
) *UnaryMinusExpr {
	const size = int64(unsafe.Sizeof(UnaryMinusExpr{}))
	e := &UnaryMinusExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternUnaryMinus(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeUnaryComplement(
	input opt.ScalarExpr,
) *UnaryComplementExpr {
	const size = int64(unsafe.Sizeof(UnaryComplementExpr{}))
	e := &UnaryComplementExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternUnaryComplement(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeCast(
	input opt.ScalarExpr,
	targetTyp coltypes.T,
) *CastExpr {
	const size = int64(unsafe.Sizeof(CastExpr{}))
	e := &CastExpr{
		Input:     input,
		TargetTyp: targetTyp,
		id:        m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternCast(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeIfErr(
	cond opt.ScalarExpr,
	orElse ScalarListExpr,
	errCode ScalarListExpr,
) *IfErrExpr {
	const size = int64(unsafe.Sizeof(IfErrExpr{}))
	e := &IfErrExpr{
		Cond:    cond,
		OrElse:  orElse,
		ErrCode: errCode,
		id:      m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternIfErr(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeCase(
	input opt.ScalarExpr,
	whens ScalarListExpr,
	orElse opt.ScalarExpr,
) *CaseExpr {
	const size = int64(unsafe.Sizeof(CaseExpr{}))
	e := &CaseExpr{
		Input:  input,
		Whens:  whens,
		OrElse: orElse,
		id:     m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternCase(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeWhen(
	condition opt.ScalarExpr,
	value opt.ScalarExpr,
) *WhenExpr {
	const size = int64(unsafe.Sizeof(WhenExpr{}))
	e := &WhenExpr{
		Condition: condition,
		Value:     value,
		id:        m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternWhen(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeArray(
	elems ScalarListExpr,
	typ types.T,
) *ArrayExpr {
	const size = int64(unsafe.Sizeof(ArrayExpr{}))
	e := &ArrayExpr{
		Elems: elems,
		Typ:   typ,
		id:    m.NextID(),
	}
	interned := m.interner.InternArray(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeIndirection(
	input opt.ScalarExpr,
	index opt.ScalarExpr,
) *IndirectionExpr {
	const size = int64(unsafe.Sizeof(IndirectionExpr{}))
	e := &IndirectionExpr{
		Input: input,
		Index: index,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternIndirection(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeArrayFlatten(
	input RelExpr,
	subqueryPrivate *SubqueryPrivate,
) *ArrayFlattenExpr {
	const size = int64(unsafe.Sizeof(ArrayFlattenExpr{}))
	e := &ArrayFlattenExpr{
		Input:           input,
		SubqueryPrivate: *subqueryPrivate,
		id:              m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternArrayFlatten(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFunction(
	args ScalarListExpr,
	functionPrivate *FunctionPrivate,
) *FunctionExpr {
	const size = int64(unsafe.Sizeof(FunctionExpr{}))
	e := &FunctionExpr{
		Args:            args,
		FunctionPrivate: *functionPrivate,
		id:              m.NextID(),
	}
	interned := m.interner.InternFunction(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeCollate(
	input opt.ScalarExpr,
	locale string,
) *CollateExpr {
	const size = int64(unsafe.Sizeof(CollateExpr{}))
	e := &CollateExpr{
		Input:  input,
		Locale: locale,
		id:     m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternCollate(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeCoalesce(
	args ScalarListExpr,
) *CoalesceExpr {
	const size = int64(unsafe.Sizeof(CoalesceExpr{}))
	e := &CoalesceExpr{
		Args: args,
		id:   m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternCoalesce(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeColumnAccess(
	input opt.ScalarExpr,
	idx TupleOrdinal,
) *ColumnAccessExpr {
	const size = int64(unsafe.Sizeof(ColumnAccessExpr{}))
	e := &ColumnAccessExpr{
		Input: input,
		Idx:   idx,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternColumnAccess(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeUnsupportedExpr(
	value tree.TypedExpr,
) *UnsupportedExprExpr {
	const size = int64(unsafe.Sizeof(UnsupportedExprExpr{}))
	e := &UnsupportedExprExpr{
		Value: value,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternUnsupportedExpr(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeArrayAgg(
	input opt.ScalarExpr,
) *ArrayAggExpr {
	const size = int64(unsafe.Sizeof(ArrayAggExpr{}))
	e := &ArrayAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternArrayAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAvg(
	input opt.ScalarExpr,
) *AvgExpr {
	const size = int64(unsafe.Sizeof(AvgExpr{}))
	e := &AvgExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternAvg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeBoolAnd(
	input opt.ScalarExpr,
) *BoolAndExpr {
	const size = int64(unsafe.Sizeof(BoolAndExpr{}))
	e := &BoolAndExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternBoolAnd(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeBoolOr(
	input opt.ScalarExpr,
) *BoolOrExpr {
	const size = int64(unsafe.Sizeof(BoolOrExpr{}))
	e := &BoolOrExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternBoolOr(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeConcatAgg(
	input opt.ScalarExpr,
) *ConcatAggExpr {
	const size = int64(unsafe.Sizeof(ConcatAggExpr{}))
	e := &ConcatAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternConcatAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeCount(
	input opt.ScalarExpr,
) *CountExpr {
	const size = int64(unsafe.Sizeof(CountExpr{}))
	e := &CountExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternCount(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeCountRows() *CountRowsExpr {
	return CountRowsSingleton
}

func (m *Memo) MemoizeMax(
	input opt.ScalarExpr,
) *MaxExpr {
	const size = int64(unsafe.Sizeof(MaxExpr{}))
	e := &MaxExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternMax(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeMin(
	input opt.ScalarExpr,
) *MinExpr {
	const size = int64(unsafe.Sizeof(MinExpr{}))
	e := &MinExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternMin(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeSumInt(
	input opt.ScalarExpr,
) *SumIntExpr {
	const size = int64(unsafe.Sizeof(SumIntExpr{}))
	e := &SumIntExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternSumInt(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeSum(
	input opt.ScalarExpr,
) *SumExpr {
	const size = int64(unsafe.Sizeof(SumExpr{}))
	e := &SumExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternSum(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeSqrDiff(
	input opt.ScalarExpr,
) *SqrDiffExpr {
	const size = int64(unsafe.Sizeof(SqrDiffExpr{}))
	e := &SqrDiffExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternSqrDiff(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeVariance(
	input opt.ScalarExpr,
) *VarianceExpr {
	const size = int64(unsafe.Sizeof(VarianceExpr{}))
	e := &VarianceExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternVariance(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeStdDev(
	input opt.ScalarExpr,
) *StdDevExpr {
	const size = int64(unsafe.Sizeof(StdDevExpr{}))
	e := &StdDevExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternStdDev(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeXorAgg(
	input opt.ScalarExpr,
) *XorAggExpr {
	const size = int64(unsafe.Sizeof(XorAggExpr{}))
	e := &XorAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternXorAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeJsonAgg(
	input opt.ScalarExpr,
) *JsonAggExpr {
	const size = int64(unsafe.Sizeof(JsonAggExpr{}))
	e := &JsonAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternJsonAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeJsonbAgg(
	input opt.ScalarExpr,
) *JsonbAggExpr {
	const size = int64(unsafe.Sizeof(JsonbAggExpr{}))
	e := &JsonbAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternJsonbAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeStringAgg(
	input opt.ScalarExpr,
	sep opt.ScalarExpr,
) *StringAggExpr {
	const size = int64(unsafe.Sizeof(StringAggExpr{}))
	e := &StringAggExpr{
		Input: input,
		Sep:   sep,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternStringAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeConstAgg(
	input opt.ScalarExpr,
) *ConstAggExpr {
	const size = int64(unsafe.Sizeof(ConstAggExpr{}))
	e := &ConstAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternConstAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeConstNotNullAgg(
	input opt.ScalarExpr,
) *ConstNotNullAggExpr {
	const size = int64(unsafe.Sizeof(ConstNotNullAggExpr{}))
	e := &ConstNotNullAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternConstNotNullAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAnyNotNullAgg(
	input opt.ScalarExpr,
) *AnyNotNullAggExpr {
	const size = int64(unsafe.Sizeof(AnyNotNullAggExpr{}))
	e := &AnyNotNullAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternAnyNotNullAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeFirstAgg(
	input opt.ScalarExpr,
) *FirstAggExpr {
	const size = int64(unsafe.Sizeof(FirstAggExpr{}))
	e := &FirstAggExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternFirstAgg(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAggDistinct(
	input opt.ScalarExpr,
) *AggDistinctExpr {
	const size = int64(unsafe.Sizeof(AggDistinctExpr{}))
	e := &AggDistinctExpr{
		Input: input,
		id:    m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternAggDistinct(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeAggFilter(
	input opt.ScalarExpr,
	filter opt.ScalarExpr,
) *AggFilterExpr {
	const size = int64(unsafe.Sizeof(AggFilterExpr{}))
	e := &AggFilterExpr{
		Input:  input,
		Filter: filter,
		id:     m.NextID(),
	}
	e.Typ = InferType(m, e)
	interned := m.interner.InternAggFilter(e)
	if interned == e {
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned
}

func (m *Memo) MemoizeInsert(
	input RelExpr,
	mutationPrivate *MutationPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(insertGroup{}))
	grp := &insertGroup{mem: m, first: InsertExpr{
		Input:           input,
		MutationPrivate: *mutationPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternInsert(e)
	if interned == e {
		m.logPropsBuilder.buildInsertProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeUpdate(
	input RelExpr,
	mutationPrivate *MutationPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(updateGroup{}))
	grp := &updateGroup{mem: m, first: UpdateExpr{
		Input:           input,
		MutationPrivate: *mutationPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternUpdate(e)
	if interned == e {
		m.logPropsBuilder.buildUpdateProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeUpsert(
	input RelExpr,
	mutationPrivate *MutationPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(upsertGroup{}))
	grp := &upsertGroup{mem: m, first: UpsertExpr{
		Input:           input,
		MutationPrivate: *mutationPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternUpsert(e)
	if interned == e {
		m.logPropsBuilder.buildUpsertProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeDelete(
	input RelExpr,
	mutationPrivate *MutationPrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(deleteGroup{}))
	grp := &deleteGroup{mem: m, first: DeleteExpr{
		Input:           input,
		MutationPrivate: *mutationPrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternDelete(e)
	if interned == e {
		m.logPropsBuilder.buildDeleteProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) MemoizeCreateTable(
	input RelExpr,
	createTablePrivate *CreateTablePrivate,
) RelExpr {
	const size = int64(unsafe.Sizeof(createTableGroup{}))
	grp := &createTableGroup{mem: m, first: CreateTableExpr{
		Input:              input,
		CreateTablePrivate: *createTablePrivate,
	}}
	e := &grp.first
	e.grp = grp
	interned := m.interner.InternCreateTable(e)
	if interned == e {
		m.logPropsBuilder.buildCreateTableProps(e, &grp.rel)
		m.memEstimate += size
		m.checkExpr(e)
	}
	return interned.FirstExpr()
}

func (m *Memo) AddScanToGroup(e *ScanExpr, grp RelExpr) *ScanExpr {
	const size = int64(unsafe.Sizeof(ScanExpr{}))
	interned := m.interner.InternScan(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddVirtualScanToGroup(e *VirtualScanExpr, grp RelExpr) *VirtualScanExpr {
	const size = int64(unsafe.Sizeof(VirtualScanExpr{}))
	interned := m.interner.InternVirtualScan(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddSequenceSelectToGroup(e *SequenceSelectExpr, grp RelExpr) *SequenceSelectExpr {
	const size = int64(unsafe.Sizeof(SequenceSelectExpr{}))
	interned := m.interner.InternSequenceSelect(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddValuesToGroup(e *ValuesExpr, grp RelExpr) *ValuesExpr {
	const size = int64(unsafe.Sizeof(ValuesExpr{}))
	interned := m.interner.InternValues(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddSelectToGroup(e *SelectExpr, grp RelExpr) *SelectExpr {
	const size = int64(unsafe.Sizeof(SelectExpr{}))
	interned := m.interner.InternSelect(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddProjectToGroup(e *ProjectExpr, grp RelExpr) *ProjectExpr {
	const size = int64(unsafe.Sizeof(ProjectExpr{}))
	interned := m.interner.InternProject(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddInnerJoinToGroup(e *InnerJoinExpr, grp RelExpr) *InnerJoinExpr {
	const size = int64(unsafe.Sizeof(InnerJoinExpr{}))
	interned := m.interner.InternInnerJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddLeftJoinToGroup(e *LeftJoinExpr, grp RelExpr) *LeftJoinExpr {
	const size = int64(unsafe.Sizeof(LeftJoinExpr{}))
	interned := m.interner.InternLeftJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddRightJoinToGroup(e *RightJoinExpr, grp RelExpr) *RightJoinExpr {
	const size = int64(unsafe.Sizeof(RightJoinExpr{}))
	interned := m.interner.InternRightJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddFullJoinToGroup(e *FullJoinExpr, grp RelExpr) *FullJoinExpr {
	const size = int64(unsafe.Sizeof(FullJoinExpr{}))
	interned := m.interner.InternFullJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddSemiJoinToGroup(e *SemiJoinExpr, grp RelExpr) *SemiJoinExpr {
	const size = int64(unsafe.Sizeof(SemiJoinExpr{}))
	interned := m.interner.InternSemiJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddAntiJoinToGroup(e *AntiJoinExpr, grp RelExpr) *AntiJoinExpr {
	const size = int64(unsafe.Sizeof(AntiJoinExpr{}))
	interned := m.interner.InternAntiJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddIndexJoinToGroup(e *IndexJoinExpr, grp RelExpr) *IndexJoinExpr {
	const size = int64(unsafe.Sizeof(IndexJoinExpr{}))
	interned := m.interner.InternIndexJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddLookupJoinToGroup(e *LookupJoinExpr, grp RelExpr) *LookupJoinExpr {
	const size = int64(unsafe.Sizeof(LookupJoinExpr{}))
	interned := m.interner.InternLookupJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddMergeJoinToGroup(e *MergeJoinExpr, grp RelExpr) *MergeJoinExpr {
	const size = int64(unsafe.Sizeof(MergeJoinExpr{}))
	interned := m.interner.InternMergeJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddZigzagJoinToGroup(e *ZigzagJoinExpr, grp RelExpr) *ZigzagJoinExpr {
	const size = int64(unsafe.Sizeof(ZigzagJoinExpr{}))
	interned := m.interner.InternZigzagJoin(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddInnerJoinApplyToGroup(e *InnerJoinApplyExpr, grp RelExpr) *InnerJoinApplyExpr {
	const size = int64(unsafe.Sizeof(InnerJoinApplyExpr{}))
	interned := m.interner.InternInnerJoinApply(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddLeftJoinApplyToGroup(e *LeftJoinApplyExpr, grp RelExpr) *LeftJoinApplyExpr {
	const size = int64(unsafe.Sizeof(LeftJoinApplyExpr{}))
	interned := m.interner.InternLeftJoinApply(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddRightJoinApplyToGroup(e *RightJoinApplyExpr, grp RelExpr) *RightJoinApplyExpr {
	const size = int64(unsafe.Sizeof(RightJoinApplyExpr{}))
	interned := m.interner.InternRightJoinApply(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddFullJoinApplyToGroup(e *FullJoinApplyExpr, grp RelExpr) *FullJoinApplyExpr {
	const size = int64(unsafe.Sizeof(FullJoinApplyExpr{}))
	interned := m.interner.InternFullJoinApply(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddSemiJoinApplyToGroup(e *SemiJoinApplyExpr, grp RelExpr) *SemiJoinApplyExpr {
	const size = int64(unsafe.Sizeof(SemiJoinApplyExpr{}))
	interned := m.interner.InternSemiJoinApply(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddAntiJoinApplyToGroup(e *AntiJoinApplyExpr, grp RelExpr) *AntiJoinApplyExpr {
	const size = int64(unsafe.Sizeof(AntiJoinApplyExpr{}))
	interned := m.interner.InternAntiJoinApply(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddGroupByToGroup(e *GroupByExpr, grp RelExpr) *GroupByExpr {
	const size = int64(unsafe.Sizeof(GroupByExpr{}))
	interned := m.interner.InternGroupBy(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddScalarGroupByToGroup(e *ScalarGroupByExpr, grp RelExpr) *ScalarGroupByExpr {
	const size = int64(unsafe.Sizeof(ScalarGroupByExpr{}))
	interned := m.interner.InternScalarGroupBy(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddDistinctOnToGroup(e *DistinctOnExpr, grp RelExpr) *DistinctOnExpr {
	const size = int64(unsafe.Sizeof(DistinctOnExpr{}))
	interned := m.interner.InternDistinctOn(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddUnionToGroup(e *UnionExpr, grp RelExpr) *UnionExpr {
	const size = int64(unsafe.Sizeof(UnionExpr{}))
	interned := m.interner.InternUnion(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddIntersectToGroup(e *IntersectExpr, grp RelExpr) *IntersectExpr {
	const size = int64(unsafe.Sizeof(IntersectExpr{}))
	interned := m.interner.InternIntersect(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddExceptToGroup(e *ExceptExpr, grp RelExpr) *ExceptExpr {
	const size = int64(unsafe.Sizeof(ExceptExpr{}))
	interned := m.interner.InternExcept(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddUnionAllToGroup(e *UnionAllExpr, grp RelExpr) *UnionAllExpr {
	const size = int64(unsafe.Sizeof(UnionAllExpr{}))
	interned := m.interner.InternUnionAll(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddIntersectAllToGroup(e *IntersectAllExpr, grp RelExpr) *IntersectAllExpr {
	const size = int64(unsafe.Sizeof(IntersectAllExpr{}))
	interned := m.interner.InternIntersectAll(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddExceptAllToGroup(e *ExceptAllExpr, grp RelExpr) *ExceptAllExpr {
	const size = int64(unsafe.Sizeof(ExceptAllExpr{}))
	interned := m.interner.InternExceptAll(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddLimitToGroup(e *LimitExpr, grp RelExpr) *LimitExpr {
	const size = int64(unsafe.Sizeof(LimitExpr{}))
	interned := m.interner.InternLimit(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddOffsetToGroup(e *OffsetExpr, grp RelExpr) *OffsetExpr {
	const size = int64(unsafe.Sizeof(OffsetExpr{}))
	interned := m.interner.InternOffset(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddMax1RowToGroup(e *Max1RowExpr, grp RelExpr) *Max1RowExpr {
	const size = int64(unsafe.Sizeof(Max1RowExpr{}))
	interned := m.interner.InternMax1Row(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddExplainToGroup(e *ExplainExpr, grp RelExpr) *ExplainExpr {
	const size = int64(unsafe.Sizeof(ExplainExpr{}))
	interned := m.interner.InternExplain(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddShowTraceForSessionToGroup(e *ShowTraceForSessionExpr, grp RelExpr) *ShowTraceForSessionExpr {
	const size = int64(unsafe.Sizeof(ShowTraceForSessionExpr{}))
	interned := m.interner.InternShowTraceForSession(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddRowNumberToGroup(e *RowNumberExpr, grp RelExpr) *RowNumberExpr {
	const size = int64(unsafe.Sizeof(RowNumberExpr{}))
	interned := m.interner.InternRowNumber(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddProjectSetToGroup(e *ProjectSetExpr, grp RelExpr) *ProjectSetExpr {
	const size = int64(unsafe.Sizeof(ProjectSetExpr{}))
	interned := m.interner.InternProjectSet(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddInsertToGroup(e *InsertExpr, grp RelExpr) *InsertExpr {
	const size = int64(unsafe.Sizeof(InsertExpr{}))
	interned := m.interner.InternInsert(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddUpdateToGroup(e *UpdateExpr, grp RelExpr) *UpdateExpr {
	const size = int64(unsafe.Sizeof(UpdateExpr{}))
	interned := m.interner.InternUpdate(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddUpsertToGroup(e *UpsertExpr, grp RelExpr) *UpsertExpr {
	const size = int64(unsafe.Sizeof(UpsertExpr{}))
	interned := m.interner.InternUpsert(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddDeleteToGroup(e *DeleteExpr, grp RelExpr) *DeleteExpr {
	const size = int64(unsafe.Sizeof(DeleteExpr{}))
	interned := m.interner.InternDelete(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (m *Memo) AddCreateTableToGroup(e *CreateTableExpr, grp RelExpr) *CreateTableExpr {
	const size = int64(unsafe.Sizeof(CreateTableExpr{}))
	interned := m.interner.InternCreateTable(e)
	if interned == e {
		e.setGroup(grp)
		m.memEstimate += size
		m.checkExpr(e)
	} else if interned.group() != grp.group() {
		// This is a group collision, do nothing.
		return nil
	}
	return interned
}

func (in *interner) InternExpr(e opt.Expr) opt.Expr {
	switch t := e.(type) {
	case *ScanExpr:
		return in.InternScan(t)
	case *VirtualScanExpr:
		return in.InternVirtualScan(t)
	case *SequenceSelectExpr:
		return in.InternSequenceSelect(t)
	case *ValuesExpr:
		return in.InternValues(t)
	case *SelectExpr:
		return in.InternSelect(t)
	case *ProjectExpr:
		return in.InternProject(t)
	case *InnerJoinExpr:
		return in.InternInnerJoin(t)
	case *LeftJoinExpr:
		return in.InternLeftJoin(t)
	case *RightJoinExpr:
		return in.InternRightJoin(t)
	case *FullJoinExpr:
		return in.InternFullJoin(t)
	case *SemiJoinExpr:
		return in.InternSemiJoin(t)
	case *AntiJoinExpr:
		return in.InternAntiJoin(t)
	case *IndexJoinExpr:
		return in.InternIndexJoin(t)
	case *LookupJoinExpr:
		return in.InternLookupJoin(t)
	case *MergeJoinExpr:
		return in.InternMergeJoin(t)
	case *ZigzagJoinExpr:
		return in.InternZigzagJoin(t)
	case *InnerJoinApplyExpr:
		return in.InternInnerJoinApply(t)
	case *LeftJoinApplyExpr:
		return in.InternLeftJoinApply(t)
	case *RightJoinApplyExpr:
		return in.InternRightJoinApply(t)
	case *FullJoinApplyExpr:
		return in.InternFullJoinApply(t)
	case *SemiJoinApplyExpr:
		return in.InternSemiJoinApply(t)
	case *AntiJoinApplyExpr:
		return in.InternAntiJoinApply(t)
	case *GroupByExpr:
		return in.InternGroupBy(t)
	case *ScalarGroupByExpr:
		return in.InternScalarGroupBy(t)
	case *DistinctOnExpr:
		return in.InternDistinctOn(t)
	case *UnionExpr:
		return in.InternUnion(t)
	case *IntersectExpr:
		return in.InternIntersect(t)
	case *ExceptExpr:
		return in.InternExcept(t)
	case *UnionAllExpr:
		return in.InternUnionAll(t)
	case *IntersectAllExpr:
		return in.InternIntersectAll(t)
	case *ExceptAllExpr:
		return in.InternExceptAll(t)
	case *LimitExpr:
		return in.InternLimit(t)
	case *OffsetExpr:
		return in.InternOffset(t)
	case *Max1RowExpr:
		return in.InternMax1Row(t)
	case *ExplainExpr:
		return in.InternExplain(t)
	case *ShowTraceForSessionExpr:
		return in.InternShowTraceForSession(t)
	case *RowNumberExpr:
		return in.InternRowNumber(t)
	case *ProjectSetExpr:
		return in.InternProjectSet(t)
	case *SubqueryExpr:
		return in.InternSubquery(t)
	case *AnyExpr:
		return in.InternAny(t)
	case *ExistsExpr:
		return in.InternExists(t)
	case *VariableExpr:
		return in.InternVariable(t)
	case *ConstExpr:
		return in.InternConst(t)
	case *NullExpr:
		return in.InternNull(t)
	case *TrueExpr:
		return in.InternTrue(t)
	case *FalseExpr:
		return in.InternFalse(t)
	case *PlaceholderExpr:
		return in.InternPlaceholder(t)
	case *TupleExpr:
		return in.InternTuple(t)
	case *ProjectionsExpr:
		return in.InternProjections(t)
	case *ProjectionsItem:
		return in.InternProjectionsItem(t)
	case *AggregationsExpr:
		return in.InternAggregations(t)
	case *AggregationsItem:
		return in.InternAggregationsItem(t)
	case *FiltersExpr:
		return in.InternFilters(t)
	case *FiltersItem:
		return in.InternFiltersItem(t)
	case *ZipExpr:
		return in.InternZip(t)
	case *ZipItem:
		return in.InternZipItem(t)
	case *AndExpr:
		return in.InternAnd(t)
	case *OrExpr:
		return in.InternOr(t)
	case *RangeExpr:
		return in.InternRange(t)
	case *NotExpr:
		return in.InternNot(t)
	case *EqExpr:
		return in.InternEq(t)
	case *LtExpr:
		return in.InternLt(t)
	case *GtExpr:
		return in.InternGt(t)
	case *LeExpr:
		return in.InternLe(t)
	case *GeExpr:
		return in.InternGe(t)
	case *NeExpr:
		return in.InternNe(t)
	case *InExpr:
		return in.InternIn(t)
	case *NotInExpr:
		return in.InternNotIn(t)
	case *LikeExpr:
		return in.InternLike(t)
	case *NotLikeExpr:
		return in.InternNotLike(t)
	case *ILikeExpr:
		return in.InternILike(t)
	case *NotILikeExpr:
		return in.InternNotILike(t)
	case *SimilarToExpr:
		return in.InternSimilarTo(t)
	case *NotSimilarToExpr:
		return in.InternNotSimilarTo(t)
	case *RegMatchExpr:
		return in.InternRegMatch(t)
	case *NotRegMatchExpr:
		return in.InternNotRegMatch(t)
	case *RegIMatchExpr:
		return in.InternRegIMatch(t)
	case *NotRegIMatchExpr:
		return in.InternNotRegIMatch(t)
	case *IsExpr:
		return in.InternIs(t)
	case *IsNotExpr:
		return in.InternIsNot(t)
	case *ContainsExpr:
		return in.InternContains(t)
	case *JsonExistsExpr:
		return in.InternJsonExists(t)
	case *JsonAllExistsExpr:
		return in.InternJsonAllExists(t)
	case *JsonSomeExistsExpr:
		return in.InternJsonSomeExists(t)
	case *AnyScalarExpr:
		return in.InternAnyScalar(t)
	case *BitandExpr:
		return in.InternBitand(t)
	case *BitorExpr:
		return in.InternBitor(t)
	case *BitxorExpr:
		return in.InternBitxor(t)
	case *PlusExpr:
		return in.InternPlus(t)
	case *MinusExpr:
		return in.InternMinus(t)
	case *MultExpr:
		return in.InternMult(t)
	case *DivExpr:
		return in.InternDiv(t)
	case *FloorDivExpr:
		return in.InternFloorDiv(t)
	case *ModExpr:
		return in.InternMod(t)
	case *PowExpr:
		return in.InternPow(t)
	case *ConcatExpr:
		return in.InternConcat(t)
	case *LShiftExpr:
		return in.InternLShift(t)
	case *RShiftExpr:
		return in.InternRShift(t)
	case *FetchValExpr:
		return in.InternFetchVal(t)
	case *FetchTextExpr:
		return in.InternFetchText(t)
	case *FetchValPathExpr:
		return in.InternFetchValPath(t)
	case *FetchTextPathExpr:
		return in.InternFetchTextPath(t)
	case *UnaryMinusExpr:
		return in.InternUnaryMinus(t)
	case *UnaryComplementExpr:
		return in.InternUnaryComplement(t)
	case *CastExpr:
		return in.InternCast(t)
	case *IfErrExpr:
		return in.InternIfErr(t)
	case *CaseExpr:
		return in.InternCase(t)
	case *WhenExpr:
		return in.InternWhen(t)
	case *ArrayExpr:
		return in.InternArray(t)
	case *IndirectionExpr:
		return in.InternIndirection(t)
	case *ArrayFlattenExpr:
		return in.InternArrayFlatten(t)
	case *FunctionExpr:
		return in.InternFunction(t)
	case *CollateExpr:
		return in.InternCollate(t)
	case *CoalesceExpr:
		return in.InternCoalesce(t)
	case *ColumnAccessExpr:
		return in.InternColumnAccess(t)
	case *UnsupportedExprExpr:
		return in.InternUnsupportedExpr(t)
	case *ArrayAggExpr:
		return in.InternArrayAgg(t)
	case *AvgExpr:
		return in.InternAvg(t)
	case *BoolAndExpr:
		return in.InternBoolAnd(t)
	case *BoolOrExpr:
		return in.InternBoolOr(t)
	case *ConcatAggExpr:
		return in.InternConcatAgg(t)
	case *CountExpr:
		return in.InternCount(t)
	case *CountRowsExpr:
		return in.InternCountRows(t)
	case *MaxExpr:
		return in.InternMax(t)
	case *MinExpr:
		return in.InternMin(t)
	case *SumIntExpr:
		return in.InternSumInt(t)
	case *SumExpr:
		return in.InternSum(t)
	case *SqrDiffExpr:
		return in.InternSqrDiff(t)
	case *VarianceExpr:
		return in.InternVariance(t)
	case *StdDevExpr:
		return in.InternStdDev(t)
	case *XorAggExpr:
		return in.InternXorAgg(t)
	case *JsonAggExpr:
		return in.InternJsonAgg(t)
	case *JsonbAggExpr:
		return in.InternJsonbAgg(t)
	case *StringAggExpr:
		return in.InternStringAgg(t)
	case *ConstAggExpr:
		return in.InternConstAgg(t)
	case *ConstNotNullAggExpr:
		return in.InternConstNotNullAgg(t)
	case *AnyNotNullAggExpr:
		return in.InternAnyNotNullAgg(t)
	case *FirstAggExpr:
		return in.InternFirstAgg(t)
	case *AggDistinctExpr:
		return in.InternAggDistinct(t)
	case *AggFilterExpr:
		return in.InternAggFilter(t)
	case *ScalarListExpr:
		return in.InternScalarList(t)
	case *InsertExpr:
		return in.InternInsert(t)
	case *UpdateExpr:
		return in.InternUpdate(t)
	case *UpsertExpr:
		return in.InternUpsert(t)
	case *DeleteExpr:
		return in.InternDelete(t)
	case *CreateTableExpr:
		return in.InternCreateTable(t)
	default:
		panic(pgerror.NewAssertionErrorf("unhandled op: %s", e.Op()))
	}
}

func (in *interner) InternScan(val *ScanExpr) *ScanExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ScanOp)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashInt(val.Index)
	in.hasher.HashColSet(val.Cols)
	in.hasher.HashPointer(unsafe.Pointer(val.Constraint))
	in.hasher.HashScanLimit(val.HardLimit)
	in.hasher.HashScanFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ScanExpr); ok {
			if in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsIntEqual(val.Index, existing.Index) &&
				in.hasher.IsColSetEqual(val.Cols, existing.Cols) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.Constraint), unsafe.Pointer(existing.Constraint)) &&
				in.hasher.IsScanLimitEqual(val.HardLimit, existing.HardLimit) &&
				in.hasher.IsScanFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternVirtualScan(val *VirtualScanExpr) *VirtualScanExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.VirtualScanOp)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashColSet(val.Cols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*VirtualScanExpr); ok {
			if in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsColSetEqual(val.Cols, existing.Cols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSequenceSelect(val *SequenceSelectExpr) *SequenceSelectExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SequenceSelectOp)
	in.hasher.HashSequenceID(val.Sequence)
	in.hasher.HashColList(val.Cols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SequenceSelectExpr); ok {
			if in.hasher.IsSequenceIDEqual(val.Sequence, existing.Sequence) &&
				in.hasher.IsColListEqual(val.Cols, existing.Cols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternValues(val *ValuesExpr) *ValuesExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ValuesOp)
	in.hasher.HashScalarListExpr(val.Rows)
	in.hasher.HashColList(val.Cols)
	in.hasher.HashValuesID(val.ID)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ValuesExpr); ok {
			if in.hasher.IsScalarListExprEqual(val.Rows, existing.Rows) &&
				in.hasher.IsColListEqual(val.Cols, existing.Cols) &&
				in.hasher.IsValuesIDEqual(val.ID, existing.ID) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSelect(val *SelectExpr) *SelectExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SelectOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashFiltersExpr(val.Filters)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SelectExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsFiltersExprEqual(val.Filters, existing.Filters) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternProject(val *ProjectExpr) *ProjectExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ProjectOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashProjectionsExpr(val.Projections)
	in.hasher.HashColSet(val.Passthrough)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ProjectExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsProjectionsExprEqual(val.Projections, existing.Projections) &&
				in.hasher.IsColSetEqual(val.Passthrough, existing.Passthrough) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternInnerJoin(val *InnerJoinExpr) *InnerJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.InnerJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*InnerJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLeftJoin(val *LeftJoinExpr) *LeftJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LeftJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LeftJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRightJoin(val *RightJoinExpr) *RightJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RightJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RightJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFullJoin(val *FullJoinExpr) *FullJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FullJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FullJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSemiJoin(val *SemiJoinExpr) *SemiJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SemiJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SemiJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAntiJoin(val *AntiJoinExpr) *AntiJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AntiJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AntiJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIndexJoin(val *IndexJoinExpr) *IndexJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IndexJoinOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashColSet(val.Cols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IndexJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsColSetEqual(val.Cols, existing.Cols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLookupJoin(val *LookupJoinExpr) *LookupJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LookupJoinOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashOperator(val.JoinType)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashInt(val.Index)
	in.hasher.HashColList(val.KeyCols)
	in.hasher.HashColSet(val.Cols)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LookupJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsOperatorEqual(val.JoinType, existing.JoinType) &&
				in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsIntEqual(val.Index, existing.Index) &&
				in.hasher.IsColListEqual(val.KeyCols, existing.KeyCols) &&
				in.hasher.IsColSetEqual(val.Cols, existing.Cols) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMergeJoin(val *MergeJoinExpr) *MergeJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.MergeJoinOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashOperator(val.JoinType)
	in.hasher.HashOrdering(val.LeftEq)
	in.hasher.HashOrdering(val.RightEq)
	in.hasher.HashOrderingChoice(val.LeftOrdering)
	in.hasher.HashOrderingChoice(val.RightOrdering)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*MergeJoinExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsOperatorEqual(val.JoinType, existing.JoinType) &&
				in.hasher.IsOrderingEqual(val.LeftEq, existing.LeftEq) &&
				in.hasher.IsOrderingEqual(val.RightEq, existing.RightEq) &&
				in.hasher.IsOrderingChoiceEqual(val.LeftOrdering, existing.LeftOrdering) &&
				in.hasher.IsOrderingChoiceEqual(val.RightOrdering, existing.RightOrdering) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternZigzagJoin(val *ZigzagJoinExpr) *ZigzagJoinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ZigzagJoinOp)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashTableID(val.LeftTable)
	in.hasher.HashTableID(val.RightTable)
	in.hasher.HashInt(val.LeftIndex)
	in.hasher.HashInt(val.RightIndex)
	in.hasher.HashColList(val.LeftEqCols)
	in.hasher.HashColList(val.RightEqCols)
	in.hasher.HashScalarListExpr(val.FixedVals)
	in.hasher.HashColList(val.LeftFixedCols)
	in.hasher.HashColList(val.RightFixedCols)
	in.hasher.HashColSet(val.Cols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ZigzagJoinExpr); ok {
			if in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsTableIDEqual(val.LeftTable, existing.LeftTable) &&
				in.hasher.IsTableIDEqual(val.RightTable, existing.RightTable) &&
				in.hasher.IsIntEqual(val.LeftIndex, existing.LeftIndex) &&
				in.hasher.IsIntEqual(val.RightIndex, existing.RightIndex) &&
				in.hasher.IsColListEqual(val.LeftEqCols, existing.LeftEqCols) &&
				in.hasher.IsColListEqual(val.RightEqCols, existing.RightEqCols) &&
				in.hasher.IsScalarListExprEqual(val.FixedVals, existing.FixedVals) &&
				in.hasher.IsColListEqual(val.LeftFixedCols, existing.LeftFixedCols) &&
				in.hasher.IsColListEqual(val.RightFixedCols, existing.RightFixedCols) &&
				in.hasher.IsColSetEqual(val.Cols, existing.Cols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternInnerJoinApply(val *InnerJoinApplyExpr) *InnerJoinApplyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.InnerJoinApplyOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*InnerJoinApplyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLeftJoinApply(val *LeftJoinApplyExpr) *LeftJoinApplyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LeftJoinApplyOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LeftJoinApplyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRightJoinApply(val *RightJoinApplyExpr) *RightJoinApplyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RightJoinApplyOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RightJoinApplyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFullJoinApply(val *FullJoinApplyExpr) *FullJoinApplyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FullJoinApplyOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FullJoinApplyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSemiJoinApply(val *SemiJoinApplyExpr) *SemiJoinApplyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SemiJoinApplyOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SemiJoinApplyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAntiJoinApply(val *AntiJoinApplyExpr) *AntiJoinApplyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AntiJoinApplyOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashFiltersExpr(val.On)
	in.hasher.HashJoinFlags(val.Flags)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AntiJoinApplyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsFiltersExprEqual(val.On, existing.On) &&
				in.hasher.IsJoinFlagsEqual(val.Flags, existing.Flags) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternGroupBy(val *GroupByExpr) *GroupByExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.GroupByOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashAggregationsExpr(val.Aggregations)
	in.hasher.HashColSet(val.GroupingCols)
	in.hasher.HashOrderingChoice(val.Ordering)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*GroupByExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsAggregationsExprEqual(val.Aggregations, existing.Aggregations) &&
				in.hasher.IsColSetEqual(val.GroupingCols, existing.GroupingCols) &&
				in.hasher.IsOrderingChoiceEqual(val.Ordering, existing.Ordering) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternScalarGroupBy(val *ScalarGroupByExpr) *ScalarGroupByExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ScalarGroupByOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashAggregationsExpr(val.Aggregations)
	in.hasher.HashColSet(val.GroupingCols)
	in.hasher.HashOrderingChoice(val.Ordering)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ScalarGroupByExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsAggregationsExprEqual(val.Aggregations, existing.Aggregations) &&
				in.hasher.IsColSetEqual(val.GroupingCols, existing.GroupingCols) &&
				in.hasher.IsOrderingChoiceEqual(val.Ordering, existing.Ordering) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternDistinctOn(val *DistinctOnExpr) *DistinctOnExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.DistinctOnOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashAggregationsExpr(val.Aggregations)
	in.hasher.HashColSet(val.GroupingCols)
	in.hasher.HashOrderingChoice(val.Ordering)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*DistinctOnExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsAggregationsExprEqual(val.Aggregations, existing.Aggregations) &&
				in.hasher.IsColSetEqual(val.GroupingCols, existing.GroupingCols) &&
				in.hasher.IsOrderingChoiceEqual(val.Ordering, existing.Ordering) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUnion(val *UnionExpr) *UnionExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UnionOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashColList(val.LeftCols)
	in.hasher.HashColList(val.RightCols)
	in.hasher.HashColList(val.OutCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UnionExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsColListEqual(val.LeftCols, existing.LeftCols) &&
				in.hasher.IsColListEqual(val.RightCols, existing.RightCols) &&
				in.hasher.IsColListEqual(val.OutCols, existing.OutCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIntersect(val *IntersectExpr) *IntersectExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IntersectOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashColList(val.LeftCols)
	in.hasher.HashColList(val.RightCols)
	in.hasher.HashColList(val.OutCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IntersectExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsColListEqual(val.LeftCols, existing.LeftCols) &&
				in.hasher.IsColListEqual(val.RightCols, existing.RightCols) &&
				in.hasher.IsColListEqual(val.OutCols, existing.OutCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternExcept(val *ExceptExpr) *ExceptExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ExceptOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashColList(val.LeftCols)
	in.hasher.HashColList(val.RightCols)
	in.hasher.HashColList(val.OutCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ExceptExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsColListEqual(val.LeftCols, existing.LeftCols) &&
				in.hasher.IsColListEqual(val.RightCols, existing.RightCols) &&
				in.hasher.IsColListEqual(val.OutCols, existing.OutCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUnionAll(val *UnionAllExpr) *UnionAllExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UnionAllOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashColList(val.LeftCols)
	in.hasher.HashColList(val.RightCols)
	in.hasher.HashColList(val.OutCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UnionAllExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsColListEqual(val.LeftCols, existing.LeftCols) &&
				in.hasher.IsColListEqual(val.RightCols, existing.RightCols) &&
				in.hasher.IsColListEqual(val.OutCols, existing.OutCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIntersectAll(val *IntersectAllExpr) *IntersectAllExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IntersectAllOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashColList(val.LeftCols)
	in.hasher.HashColList(val.RightCols)
	in.hasher.HashColList(val.OutCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IntersectAllExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsColListEqual(val.LeftCols, existing.LeftCols) &&
				in.hasher.IsColListEqual(val.RightCols, existing.RightCols) &&
				in.hasher.IsColListEqual(val.OutCols, existing.OutCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternExceptAll(val *ExceptAllExpr) *ExceptAllExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ExceptAllOp)
	in.hasher.HashRelExpr(val.Left)
	in.hasher.HashRelExpr(val.Right)
	in.hasher.HashColList(val.LeftCols)
	in.hasher.HashColList(val.RightCols)
	in.hasher.HashColList(val.OutCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ExceptAllExpr); ok {
			if in.hasher.IsRelExprEqual(val.Left, existing.Left) &&
				in.hasher.IsRelExprEqual(val.Right, existing.Right) &&
				in.hasher.IsColListEqual(val.LeftCols, existing.LeftCols) &&
				in.hasher.IsColListEqual(val.RightCols, existing.RightCols) &&
				in.hasher.IsColListEqual(val.OutCols, existing.OutCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLimit(val *LimitExpr) *LimitExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LimitOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashScalarExpr(val.Limit)
	in.hasher.HashOrderingChoice(val.Ordering)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LimitExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarExprEqual(val.Limit, existing.Limit) &&
				in.hasher.IsOrderingChoiceEqual(val.Ordering, existing.Ordering) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternOffset(val *OffsetExpr) *OffsetExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.OffsetOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashScalarExpr(val.Offset)
	in.hasher.HashOrderingChoice(val.Ordering)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*OffsetExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarExprEqual(val.Offset, existing.Offset) &&
				in.hasher.IsOrderingChoiceEqual(val.Ordering, existing.Ordering) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMax1Row(val *Max1RowExpr) *Max1RowExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.Max1RowOp)
	in.hasher.HashRelExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*Max1RowExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternExplain(val *ExplainExpr) *ExplainExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ExplainOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashExplainOptions(val.Options)
	in.hasher.HashColList(val.ColList)
	in.hasher.HashPhysProps(val.Props)
	in.hasher.HashStatementType(val.StmtType)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ExplainExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsExplainOptionsEqual(val.Options, existing.Options) &&
				in.hasher.IsColListEqual(val.ColList, existing.ColList) &&
				in.hasher.IsPhysPropsEqual(val.Props, existing.Props) &&
				in.hasher.IsStatementTypeEqual(val.StmtType, existing.StmtType) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternShowTraceForSession(val *ShowTraceForSessionExpr) *ShowTraceForSessionExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ShowTraceForSessionOp)
	in.hasher.HashShowTraceType(val.TraceType)
	in.hasher.HashBool(val.Compact)
	in.hasher.HashColList(val.ColList)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ShowTraceForSessionExpr); ok {
			if in.hasher.IsShowTraceTypeEqual(val.TraceType, existing.TraceType) &&
				in.hasher.IsBoolEqual(val.Compact, existing.Compact) &&
				in.hasher.IsColListEqual(val.ColList, existing.ColList) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRowNumber(val *RowNumberExpr) *RowNumberExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RowNumberOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashOrderingChoice(val.Ordering)
	in.hasher.HashColumnID(val.ColID)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RowNumberExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsOrderingChoiceEqual(val.Ordering, existing.Ordering) &&
				in.hasher.IsColumnIDEqual(val.ColID, existing.ColID) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternProjectSet(val *ProjectSetExpr) *ProjectSetExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ProjectSetOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashZipExpr(val.Zip)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ProjectSetExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsZipExprEqual(val.Zip, existing.Zip) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSubquery(val *SubqueryExpr) *SubqueryExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SubqueryOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashPointer(unsafe.Pointer(val.OriginalExpr))
	in.hasher.HashOrdering(val.Ordering)
	in.hasher.HashColumnID(val.RequestedCol)
	in.hasher.HashOperator(val.Cmp)
	in.hasher.HashBool(val.WasLimited)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SubqueryExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.OriginalExpr), unsafe.Pointer(existing.OriginalExpr)) &&
				in.hasher.IsOrderingEqual(val.Ordering, existing.Ordering) &&
				in.hasher.IsColumnIDEqual(val.RequestedCol, existing.RequestedCol) &&
				in.hasher.IsOperatorEqual(val.Cmp, existing.Cmp) &&
				in.hasher.IsBoolEqual(val.WasLimited, existing.WasLimited) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAny(val *AnyExpr) *AnyExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AnyOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashScalarExpr(val.Scalar)
	in.hasher.HashPointer(unsafe.Pointer(val.OriginalExpr))
	in.hasher.HashOrdering(val.Ordering)
	in.hasher.HashColumnID(val.RequestedCol)
	in.hasher.HashOperator(val.Cmp)
	in.hasher.HashBool(val.WasLimited)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AnyExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarExprEqual(val.Scalar, existing.Scalar) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.OriginalExpr), unsafe.Pointer(existing.OriginalExpr)) &&
				in.hasher.IsOrderingEqual(val.Ordering, existing.Ordering) &&
				in.hasher.IsColumnIDEqual(val.RequestedCol, existing.RequestedCol) &&
				in.hasher.IsOperatorEqual(val.Cmp, existing.Cmp) &&
				in.hasher.IsBoolEqual(val.WasLimited, existing.WasLimited) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternExists(val *ExistsExpr) *ExistsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ExistsOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashPointer(unsafe.Pointer(val.OriginalExpr))
	in.hasher.HashOrdering(val.Ordering)
	in.hasher.HashColumnID(val.RequestedCol)
	in.hasher.HashOperator(val.Cmp)
	in.hasher.HashBool(val.WasLimited)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ExistsExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.OriginalExpr), unsafe.Pointer(existing.OriginalExpr)) &&
				in.hasher.IsOrderingEqual(val.Ordering, existing.Ordering) &&
				in.hasher.IsColumnIDEqual(val.RequestedCol, existing.RequestedCol) &&
				in.hasher.IsOperatorEqual(val.Cmp, existing.Cmp) &&
				in.hasher.IsBoolEqual(val.WasLimited, existing.WasLimited) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternVariable(val *VariableExpr) *VariableExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.VariableOp)
	in.hasher.HashColumnID(val.Col)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*VariableExpr); ok {
			if in.hasher.IsColumnIDEqual(val.Col, existing.Col) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternConst(val *ConstExpr) *ConstExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ConstOp)
	in.hasher.HashDatum(val.Value)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ConstExpr); ok {
			if in.hasher.IsDatumEqual(val.Value, existing.Value) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNull(val *NullExpr) *NullExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NullOp)
	in.hasher.HashDatumType(val.Typ)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NullExpr); ok {
			if in.hasher.IsDatumTypeEqual(val.Typ, existing.Typ) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternTrue(val *TrueExpr) *TrueExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.TrueOp)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*TrueExpr); ok {
			return existing
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFalse(val *FalseExpr) *FalseExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FalseOp)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FalseExpr); ok {
			return existing
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternPlaceholder(val *PlaceholderExpr) *PlaceholderExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.PlaceholderOp)
	in.hasher.HashTypedExpr(val.Value)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*PlaceholderExpr); ok {
			if in.hasher.IsTypedExprEqual(val.Value, existing.Value) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternTuple(val *TupleExpr) *TupleExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.TupleOp)
	in.hasher.HashScalarListExpr(val.Elems)
	in.hasher.HashDatumType(val.Typ)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*TupleExpr); ok {
			if in.hasher.IsScalarListExprEqual(val.Elems, existing.Elems) &&
				in.hasher.IsDatumTypeEqual(val.Typ, existing.Typ) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternProjections(val *ProjectionsExpr) *ProjectionsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ProjectionsOp)
	in.hasher.HashProjectionsExpr(*val)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ProjectionsExpr); ok {
			if in.hasher.IsProjectionsExprEqual(*val, *existing) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternProjectionsItem(val *ProjectionsItem) *ProjectionsItem {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ProjectionsItemOp)
	in.hasher.HashScalarExpr(val.Element)
	in.hasher.HashColumnID(val.Col)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ProjectionsItem); ok {
			if in.hasher.IsScalarExprEqual(val.Element, existing.Element) &&
				in.hasher.IsColumnIDEqual(val.Col, existing.Col) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAggregations(val *AggregationsExpr) *AggregationsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AggregationsOp)
	in.hasher.HashAggregationsExpr(*val)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AggregationsExpr); ok {
			if in.hasher.IsAggregationsExprEqual(*val, *existing) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAggregationsItem(val *AggregationsItem) *AggregationsItem {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AggregationsItemOp)
	in.hasher.HashScalarExpr(val.Agg)
	in.hasher.HashColumnID(val.Col)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AggregationsItem); ok {
			if in.hasher.IsScalarExprEqual(val.Agg, existing.Agg) &&
				in.hasher.IsColumnIDEqual(val.Col, existing.Col) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFilters(val *FiltersExpr) *FiltersExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FiltersOp)
	in.hasher.HashFiltersExpr(*val)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FiltersExpr); ok {
			if in.hasher.IsFiltersExprEqual(*val, *existing) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFiltersItem(val *FiltersItem) *FiltersItem {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FiltersItemOp)
	in.hasher.HashScalarExpr(val.Condition)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FiltersItem); ok {
			if in.hasher.IsScalarExprEqual(val.Condition, existing.Condition) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternZip(val *ZipExpr) *ZipExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ZipOp)
	in.hasher.HashZipExpr(*val)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ZipExpr); ok {
			if in.hasher.IsZipExprEqual(*val, *existing) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternZipItem(val *ZipItem) *ZipItem {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ZipItemOp)
	in.hasher.HashScalarExpr(val.Func)
	in.hasher.HashColList(val.Cols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ZipItem); ok {
			if in.hasher.IsScalarExprEqual(val.Func, existing.Func) &&
				in.hasher.IsColListEqual(val.Cols, existing.Cols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAnd(val *AndExpr) *AndExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AndOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AndExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternOr(val *OrExpr) *OrExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.OrOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*OrExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRange(val *RangeExpr) *RangeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RangeOp)
	in.hasher.HashScalarExpr(val.And)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RangeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.And, existing.And) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNot(val *NotExpr) *NotExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternEq(val *EqExpr) *EqExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.EqOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*EqExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLt(val *LtExpr) *LtExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LtOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LtExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternGt(val *GtExpr) *GtExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.GtOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*GtExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLe(val *LeExpr) *LeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternGe(val *GeExpr) *GeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.GeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*GeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNe(val *NeExpr) *NeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIn(val *InExpr) *InExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.InOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*InExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNotIn(val *NotInExpr) *NotInExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotInOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotInExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLike(val *LikeExpr) *LikeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LikeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LikeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNotLike(val *NotLikeExpr) *NotLikeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotLikeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotLikeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternILike(val *ILikeExpr) *ILikeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ILikeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ILikeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNotILike(val *NotILikeExpr) *NotILikeExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotILikeOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotILikeExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSimilarTo(val *SimilarToExpr) *SimilarToExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SimilarToOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SimilarToExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNotSimilarTo(val *NotSimilarToExpr) *NotSimilarToExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotSimilarToOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotSimilarToExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRegMatch(val *RegMatchExpr) *RegMatchExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RegMatchOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RegMatchExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNotRegMatch(val *NotRegMatchExpr) *NotRegMatchExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotRegMatchOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotRegMatchExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRegIMatch(val *RegIMatchExpr) *RegIMatchExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RegIMatchOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RegIMatchExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternNotRegIMatch(val *NotRegIMatchExpr) *NotRegIMatchExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.NotRegIMatchOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*NotRegIMatchExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIs(val *IsExpr) *IsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IsOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IsExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIsNot(val *IsNotExpr) *IsNotExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IsNotOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IsNotExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternContains(val *ContainsExpr) *ContainsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ContainsOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ContainsExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternJsonExists(val *JsonExistsExpr) *JsonExistsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.JsonExistsOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*JsonExistsExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternJsonAllExists(val *JsonAllExistsExpr) *JsonAllExistsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.JsonAllExistsOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*JsonAllExistsExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternJsonSomeExists(val *JsonSomeExistsExpr) *JsonSomeExistsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.JsonSomeExistsOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*JsonSomeExistsExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAnyScalar(val *AnyScalarExpr) *AnyScalarExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AnyScalarOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)
	in.hasher.HashOperator(val.Cmp)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AnyScalarExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) &&
				in.hasher.IsOperatorEqual(val.Cmp, existing.Cmp) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternBitand(val *BitandExpr) *BitandExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.BitandOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*BitandExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternBitor(val *BitorExpr) *BitorExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.BitorOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*BitorExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternBitxor(val *BitxorExpr) *BitxorExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.BitxorOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*BitxorExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternPlus(val *PlusExpr) *PlusExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.PlusOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*PlusExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMinus(val *MinusExpr) *MinusExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.MinusOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*MinusExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMult(val *MultExpr) *MultExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.MultOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*MultExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternDiv(val *DivExpr) *DivExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.DivOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*DivExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFloorDiv(val *FloorDivExpr) *FloorDivExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FloorDivOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FloorDivExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMod(val *ModExpr) *ModExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ModOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ModExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternPow(val *PowExpr) *PowExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.PowOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*PowExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternConcat(val *ConcatExpr) *ConcatExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ConcatOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ConcatExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternLShift(val *LShiftExpr) *LShiftExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.LShiftOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*LShiftExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternRShift(val *RShiftExpr) *RShiftExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.RShiftOp)
	in.hasher.HashScalarExpr(val.Left)
	in.hasher.HashScalarExpr(val.Right)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*RShiftExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Left, existing.Left) &&
				in.hasher.IsScalarExprEqual(val.Right, existing.Right) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFetchVal(val *FetchValExpr) *FetchValExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FetchValOp)
	in.hasher.HashScalarExpr(val.Json)
	in.hasher.HashScalarExpr(val.Index)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FetchValExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Json, existing.Json) &&
				in.hasher.IsScalarExprEqual(val.Index, existing.Index) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFetchText(val *FetchTextExpr) *FetchTextExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FetchTextOp)
	in.hasher.HashScalarExpr(val.Json)
	in.hasher.HashScalarExpr(val.Index)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FetchTextExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Json, existing.Json) &&
				in.hasher.IsScalarExprEqual(val.Index, existing.Index) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFetchValPath(val *FetchValPathExpr) *FetchValPathExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FetchValPathOp)
	in.hasher.HashScalarExpr(val.Json)
	in.hasher.HashScalarExpr(val.Path)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FetchValPathExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Json, existing.Json) &&
				in.hasher.IsScalarExprEqual(val.Path, existing.Path) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFetchTextPath(val *FetchTextPathExpr) *FetchTextPathExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FetchTextPathOp)
	in.hasher.HashScalarExpr(val.Json)
	in.hasher.HashScalarExpr(val.Path)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FetchTextPathExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Json, existing.Json) &&
				in.hasher.IsScalarExprEqual(val.Path, existing.Path) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUnaryMinus(val *UnaryMinusExpr) *UnaryMinusExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UnaryMinusOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UnaryMinusExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUnaryComplement(val *UnaryComplementExpr) *UnaryComplementExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UnaryComplementOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UnaryComplementExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCast(val *CastExpr) *CastExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CastOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashColType(val.TargetTyp)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CastExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsColTypeEqual(val.TargetTyp, existing.TargetTyp) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIfErr(val *IfErrExpr) *IfErrExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IfErrOp)
	in.hasher.HashScalarExpr(val.Cond)
	in.hasher.HashScalarListExpr(val.OrElse)
	in.hasher.HashScalarListExpr(val.ErrCode)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IfErrExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Cond, existing.Cond) &&
				in.hasher.IsScalarListExprEqual(val.OrElse, existing.OrElse) &&
				in.hasher.IsScalarListExprEqual(val.ErrCode, existing.ErrCode) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCase(val *CaseExpr) *CaseExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CaseOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashScalarListExpr(val.Whens)
	in.hasher.HashScalarExpr(val.OrElse)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CaseExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarListExprEqual(val.Whens, existing.Whens) &&
				in.hasher.IsScalarExprEqual(val.OrElse, existing.OrElse) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternWhen(val *WhenExpr) *WhenExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.WhenOp)
	in.hasher.HashScalarExpr(val.Condition)
	in.hasher.HashScalarExpr(val.Value)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*WhenExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Condition, existing.Condition) &&
				in.hasher.IsScalarExprEqual(val.Value, existing.Value) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternArray(val *ArrayExpr) *ArrayExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ArrayOp)
	in.hasher.HashScalarListExpr(val.Elems)
	in.hasher.HashDatumType(val.Typ)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ArrayExpr); ok {
			if in.hasher.IsScalarListExprEqual(val.Elems, existing.Elems) &&
				in.hasher.IsDatumTypeEqual(val.Typ, existing.Typ) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternIndirection(val *IndirectionExpr) *IndirectionExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.IndirectionOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashScalarExpr(val.Index)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*IndirectionExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarExprEqual(val.Index, existing.Index) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternArrayFlatten(val *ArrayFlattenExpr) *ArrayFlattenExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ArrayFlattenOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashPointer(unsafe.Pointer(val.OriginalExpr))
	in.hasher.HashOrdering(val.Ordering)
	in.hasher.HashColumnID(val.RequestedCol)
	in.hasher.HashOperator(val.Cmp)
	in.hasher.HashBool(val.WasLimited)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ArrayFlattenExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.OriginalExpr), unsafe.Pointer(existing.OriginalExpr)) &&
				in.hasher.IsOrderingEqual(val.Ordering, existing.Ordering) &&
				in.hasher.IsColumnIDEqual(val.RequestedCol, existing.RequestedCol) &&
				in.hasher.IsOperatorEqual(val.Cmp, existing.Cmp) &&
				in.hasher.IsBoolEqual(val.WasLimited, existing.WasLimited) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFunction(val *FunctionExpr) *FunctionExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FunctionOp)
	in.hasher.HashScalarListExpr(val.Args)
	in.hasher.HashString(val.Name)
	in.hasher.HashDatumType(val.Typ)
	in.hasher.HashPointer(unsafe.Pointer(val.Properties))
	in.hasher.HashPointer(unsafe.Pointer(val.Overload))

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FunctionExpr); ok {
			if in.hasher.IsScalarListExprEqual(val.Args, existing.Args) &&
				in.hasher.IsStringEqual(val.Name, existing.Name) &&
				in.hasher.IsDatumTypeEqual(val.Typ, existing.Typ) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.Properties), unsafe.Pointer(existing.Properties)) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.Overload), unsafe.Pointer(existing.Overload)) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCollate(val *CollateExpr) *CollateExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CollateOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashString(val.Locale)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CollateExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsStringEqual(val.Locale, existing.Locale) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCoalesce(val *CoalesceExpr) *CoalesceExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CoalesceOp)
	in.hasher.HashScalarListExpr(val.Args)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CoalesceExpr); ok {
			if in.hasher.IsScalarListExprEqual(val.Args, existing.Args) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternColumnAccess(val *ColumnAccessExpr) *ColumnAccessExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ColumnAccessOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashTupleOrdinal(val.Idx)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ColumnAccessExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsTupleOrdinalEqual(val.Idx, existing.Idx) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUnsupportedExpr(val *UnsupportedExprExpr) *UnsupportedExprExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UnsupportedExprOp)
	in.hasher.HashTypedExpr(val.Value)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UnsupportedExprExpr); ok {
			if in.hasher.IsTypedExprEqual(val.Value, existing.Value) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternArrayAgg(val *ArrayAggExpr) *ArrayAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ArrayAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ArrayAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAvg(val *AvgExpr) *AvgExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AvgOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AvgExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternBoolAnd(val *BoolAndExpr) *BoolAndExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.BoolAndOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*BoolAndExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternBoolOr(val *BoolOrExpr) *BoolOrExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.BoolOrOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*BoolOrExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternConcatAgg(val *ConcatAggExpr) *ConcatAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ConcatAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ConcatAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCount(val *CountExpr) *CountExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CountOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CountExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCountRows(val *CountRowsExpr) *CountRowsExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CountRowsOp)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CountRowsExpr); ok {
			return existing
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMax(val *MaxExpr) *MaxExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.MaxOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*MaxExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternMin(val *MinExpr) *MinExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.MinOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*MinExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSumInt(val *SumIntExpr) *SumIntExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SumIntOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SumIntExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSum(val *SumExpr) *SumExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SumOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SumExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternSqrDiff(val *SqrDiffExpr) *SqrDiffExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.SqrDiffOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*SqrDiffExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternVariance(val *VarianceExpr) *VarianceExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.VarianceOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*VarianceExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternStdDev(val *StdDevExpr) *StdDevExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.StdDevOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*StdDevExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternXorAgg(val *XorAggExpr) *XorAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.XorAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*XorAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternJsonAgg(val *JsonAggExpr) *JsonAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.JsonAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*JsonAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternJsonbAgg(val *JsonbAggExpr) *JsonbAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.JsonbAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*JsonbAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternStringAgg(val *StringAggExpr) *StringAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.StringAggOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashScalarExpr(val.Sep)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*StringAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarExprEqual(val.Sep, existing.Sep) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternConstAgg(val *ConstAggExpr) *ConstAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ConstAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ConstAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternConstNotNullAgg(val *ConstNotNullAggExpr) *ConstNotNullAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ConstNotNullAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ConstNotNullAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAnyNotNullAgg(val *AnyNotNullAggExpr) *AnyNotNullAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AnyNotNullAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AnyNotNullAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternFirstAgg(val *FirstAggExpr) *FirstAggExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.FirstAggOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*FirstAggExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAggDistinct(val *AggDistinctExpr) *AggDistinctExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AggDistinctOp)
	in.hasher.HashScalarExpr(val.Input)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AggDistinctExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternAggFilter(val *AggFilterExpr) *AggFilterExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.AggFilterOp)
	in.hasher.HashScalarExpr(val.Input)
	in.hasher.HashScalarExpr(val.Filter)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*AggFilterExpr); ok {
			if in.hasher.IsScalarExprEqual(val.Input, existing.Input) &&
				in.hasher.IsScalarExprEqual(val.Filter, existing.Filter) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternScalarList(val *ScalarListExpr) *ScalarListExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.ScalarListOp)
	in.hasher.HashScalarListExpr(*val)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*ScalarListExpr); ok {
			if in.hasher.IsScalarListExprEqual(*val, *existing) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternInsert(val *InsertExpr) *InsertExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.InsertOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashColList(val.InsertCols)
	in.hasher.HashColList(val.FetchCols)
	in.hasher.HashColList(val.UpdateCols)
	in.hasher.HashColList(val.CheckCols)
	in.hasher.HashColumnID(val.CanaryCol)
	in.hasher.HashColList(val.ReturnCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*InsertExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsColListEqual(val.InsertCols, existing.InsertCols) &&
				in.hasher.IsColListEqual(val.FetchCols, existing.FetchCols) &&
				in.hasher.IsColListEqual(val.UpdateCols, existing.UpdateCols) &&
				in.hasher.IsColListEqual(val.CheckCols, existing.CheckCols) &&
				in.hasher.IsColumnIDEqual(val.CanaryCol, existing.CanaryCol) &&
				in.hasher.IsColListEqual(val.ReturnCols, existing.ReturnCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUpdate(val *UpdateExpr) *UpdateExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UpdateOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashColList(val.InsertCols)
	in.hasher.HashColList(val.FetchCols)
	in.hasher.HashColList(val.UpdateCols)
	in.hasher.HashColList(val.CheckCols)
	in.hasher.HashColumnID(val.CanaryCol)
	in.hasher.HashColList(val.ReturnCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UpdateExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsColListEqual(val.InsertCols, existing.InsertCols) &&
				in.hasher.IsColListEqual(val.FetchCols, existing.FetchCols) &&
				in.hasher.IsColListEqual(val.UpdateCols, existing.UpdateCols) &&
				in.hasher.IsColListEqual(val.CheckCols, existing.CheckCols) &&
				in.hasher.IsColumnIDEqual(val.CanaryCol, existing.CanaryCol) &&
				in.hasher.IsColListEqual(val.ReturnCols, existing.ReturnCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternUpsert(val *UpsertExpr) *UpsertExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.UpsertOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashColList(val.InsertCols)
	in.hasher.HashColList(val.FetchCols)
	in.hasher.HashColList(val.UpdateCols)
	in.hasher.HashColList(val.CheckCols)
	in.hasher.HashColumnID(val.CanaryCol)
	in.hasher.HashColList(val.ReturnCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*UpsertExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsColListEqual(val.InsertCols, existing.InsertCols) &&
				in.hasher.IsColListEqual(val.FetchCols, existing.FetchCols) &&
				in.hasher.IsColListEqual(val.UpdateCols, existing.UpdateCols) &&
				in.hasher.IsColListEqual(val.CheckCols, existing.CheckCols) &&
				in.hasher.IsColumnIDEqual(val.CanaryCol, existing.CanaryCol) &&
				in.hasher.IsColListEqual(val.ReturnCols, existing.ReturnCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternDelete(val *DeleteExpr) *DeleteExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.DeleteOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashTableID(val.Table)
	in.hasher.HashColList(val.InsertCols)
	in.hasher.HashColList(val.FetchCols)
	in.hasher.HashColList(val.UpdateCols)
	in.hasher.HashColList(val.CheckCols)
	in.hasher.HashColumnID(val.CanaryCol)
	in.hasher.HashColList(val.ReturnCols)

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*DeleteExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsTableIDEqual(val.Table, existing.Table) &&
				in.hasher.IsColListEqual(val.InsertCols, existing.InsertCols) &&
				in.hasher.IsColListEqual(val.FetchCols, existing.FetchCols) &&
				in.hasher.IsColListEqual(val.UpdateCols, existing.UpdateCols) &&
				in.hasher.IsColListEqual(val.CheckCols, existing.CheckCols) &&
				in.hasher.IsColumnIDEqual(val.CanaryCol, existing.CanaryCol) &&
				in.hasher.IsColListEqual(val.ReturnCols, existing.ReturnCols) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (in *interner) InternCreateTable(val *CreateTableExpr) *CreateTableExpr {
	in.hasher.Init()
	in.hasher.HashOperator(opt.CreateTableOp)
	in.hasher.HashRelExpr(val.Input)
	in.hasher.HashSchemaID(val.Schema)
	in.hasher.HashPresentation(val.InputCols)
	in.hasher.HashPointer(unsafe.Pointer(val.Syntax))

	in.cache.Start(in.hasher.hash)
	for in.cache.Next() {
		if existing, ok := in.cache.Item().(*CreateTableExpr); ok {
			if in.hasher.IsRelExprEqual(val.Input, existing.Input) &&
				in.hasher.IsSchemaIDEqual(val.Schema, existing.Schema) &&
				in.hasher.IsPresentationEqual(val.InputCols, existing.InputCols) &&
				in.hasher.IsPointerEqual(unsafe.Pointer(val.Syntax), unsafe.Pointer(existing.Syntax)) {
				return existing
			}
		}
	}

	in.cache.Add(val)
	return val
}

func (b *logicalPropsBuilder) buildProps(e RelExpr, rel *props.Relational) {
	switch t := e.(type) {
	case *ScanExpr:
		b.buildScanProps(t, rel)
	case *VirtualScanExpr:
		b.buildVirtualScanProps(t, rel)
	case *SequenceSelectExpr:
		b.buildSequenceSelectProps(t, rel)
	case *ValuesExpr:
		b.buildValuesProps(t, rel)
	case *SelectExpr:
		b.buildSelectProps(t, rel)
	case *ProjectExpr:
		b.buildProjectProps(t, rel)
	case *InnerJoinExpr:
		b.buildInnerJoinProps(t, rel)
	case *LeftJoinExpr:
		b.buildLeftJoinProps(t, rel)
	case *RightJoinExpr:
		b.buildRightJoinProps(t, rel)
	case *FullJoinExpr:
		b.buildFullJoinProps(t, rel)
	case *SemiJoinExpr:
		b.buildSemiJoinProps(t, rel)
	case *AntiJoinExpr:
		b.buildAntiJoinProps(t, rel)
	case *IndexJoinExpr:
		b.buildIndexJoinProps(t, rel)
	case *LookupJoinExpr:
		b.buildLookupJoinProps(t, rel)
	case *MergeJoinExpr:
		b.buildMergeJoinProps(t, rel)
	case *ZigzagJoinExpr:
		b.buildZigzagJoinProps(t, rel)
	case *InnerJoinApplyExpr:
		b.buildInnerJoinApplyProps(t, rel)
	case *LeftJoinApplyExpr:
		b.buildLeftJoinApplyProps(t, rel)
	case *RightJoinApplyExpr:
		b.buildRightJoinApplyProps(t, rel)
	case *FullJoinApplyExpr:
		b.buildFullJoinApplyProps(t, rel)
	case *SemiJoinApplyExpr:
		b.buildSemiJoinApplyProps(t, rel)
	case *AntiJoinApplyExpr:
		b.buildAntiJoinApplyProps(t, rel)
	case *GroupByExpr:
		b.buildGroupByProps(t, rel)
	case *ScalarGroupByExpr:
		b.buildScalarGroupByProps(t, rel)
	case *DistinctOnExpr:
		b.buildDistinctOnProps(t, rel)
	case *UnionExpr:
		b.buildUnionProps(t, rel)
	case *IntersectExpr:
		b.buildIntersectProps(t, rel)
	case *ExceptExpr:
		b.buildExceptProps(t, rel)
	case *UnionAllExpr:
		b.buildUnionAllProps(t, rel)
	case *IntersectAllExpr:
		b.buildIntersectAllProps(t, rel)
	case *ExceptAllExpr:
		b.buildExceptAllProps(t, rel)
	case *LimitExpr:
		b.buildLimitProps(t, rel)
	case *OffsetExpr:
		b.buildOffsetProps(t, rel)
	case *Max1RowExpr:
		b.buildMax1RowProps(t, rel)
	case *ExplainExpr:
		b.buildExplainProps(t, rel)
	case *ShowTraceForSessionExpr:
		b.buildShowTraceForSessionProps(t, rel)
	case *RowNumberExpr:
		b.buildRowNumberProps(t, rel)
	case *ProjectSetExpr:
		b.buildProjectSetProps(t, rel)
	case *InsertExpr:
		b.buildInsertProps(t, rel)
	case *UpdateExpr:
		b.buildUpdateProps(t, rel)
	case *UpsertExpr:
		b.buildUpsertProps(t, rel)
	case *DeleteExpr:
		b.buildDeleteProps(t, rel)
	case *CreateTableExpr:
		b.buildCreateTableProps(t, rel)
	default:
		panic(pgerror.NewAssertionErrorf("unhandled type: %s", t.Op()))
	}
}
