package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowTemplates invokes the cloudcallcenter.ListFlowTemplates API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listflowtemplates.html
func (client *Client) ListFlowTemplates(request *ListFlowTemplatesRequest) (response *ListFlowTemplatesResponse, err error) {
	response = CreateListFlowTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowTemplatesWithChan invokes the cloudcallcenter.ListFlowTemplates API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listflowtemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowTemplatesWithChan(request *ListFlowTemplatesRequest) (<-chan *ListFlowTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListFlowTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowTemplatesWithCallback invokes the cloudcallcenter.ListFlowTemplates API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listflowtemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowTemplatesWithCallback(request *ListFlowTemplatesRequest, callback func(response *ListFlowTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListFlowTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowTemplatesRequest is the request struct for api ListFlowTemplates
type ListFlowTemplatesRequest struct {
	*requests.RpcRequest
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	FlowTemplatesType requests.Integer `position:"Query" name:"FlowTemplatesType"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	NameKeyword       string           `position:"Query" name:"NameKeyword"`
}

// ListFlowTemplatesResponse is the response struct for api ListFlowTemplates
type ListFlowTemplatesResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	Success        bool      `json:"Success" xml:"Success"`
	Code           string    `json:"Code" xml:"Code"`
	Message        string    `json:"Message" xml:"Message"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Templates      Templates `json:"Templates" xml:"Templates"`
}

// CreateListFlowTemplatesRequest creates a request to invoke ListFlowTemplates API
func CreateListFlowTemplatesRequest() (request *ListFlowTemplatesRequest) {
	request = &ListFlowTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListFlowTemplates", "", "")
	request.Method = requests.POST
	return
}

// CreateListFlowTemplatesResponse creates a response to parse from ListFlowTemplates response
func CreateListFlowTemplatesResponse() (response *ListFlowTemplatesResponse) {
	response = &ListFlowTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
