package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferToThirdCall invokes the scsp.TransferToThirdCall API synchronously
func (client *Client) TransferToThirdCall(request *TransferToThirdCallRequest) (response *TransferToThirdCallResponse, err error) {
	response = CreateTransferToThirdCallResponse()
	err = client.DoAction(request, response)
	return
}

// TransferToThirdCallWithChan invokes the scsp.TransferToThirdCall API asynchronously
func (client *Client) TransferToThirdCallWithChan(request *TransferToThirdCallRequest) (<-chan *TransferToThirdCallResponse, <-chan error) {
	responseChan := make(chan *TransferToThirdCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferToThirdCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferToThirdCallWithCallback invokes the scsp.TransferToThirdCall API asynchronously
func (client *Client) TransferToThirdCallWithCallback(request *TransferToThirdCallRequest, callback func(response *TransferToThirdCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferToThirdCallResponse
		var err error
		defer close(result)
		response, err = client.TransferToThirdCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferToThirdCallRequest is the request struct for api TransferToThirdCall
type TransferToThirdCallRequest struct {
	*requests.RpcRequest
	ClientToken      string `position:"Body"`
	InstanceId       string `position:"Body"`
	AccountName      string `position:"Body"`
	CallId           string `position:"Body"`
	JobId            string `position:"Body"`
	ConnectionId     string `position:"Body"`
	HoldConnectionId string `position:"Body"`
}

// TransferToThirdCallResponse is the response struct for api TransferToThirdCall
type TransferToThirdCallResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateTransferToThirdCallRequest creates a request to invoke TransferToThirdCall API
func CreateTransferToThirdCallRequest() (request *TransferToThirdCallRequest) {
	request = &TransferToThirdCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "TransferToThirdCall", "", "")
	request.Method = requests.POST
	return
}

// CreateTransferToThirdCallResponse creates a response to parse from TransferToThirdCall response
func CreateTransferToThirdCallResponse() (response *TransferToThirdCallResponse) {
	response = &TransferToThirdCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
