package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchGatewayExpirationPolicy invokes the sgw.SwitchGatewayExpirationPolicy API synchronously
func (client *Client) SwitchGatewayExpirationPolicy(request *SwitchGatewayExpirationPolicyRequest) (response *SwitchGatewayExpirationPolicyResponse, err error) {
	response = CreateSwitchGatewayExpirationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchGatewayExpirationPolicyWithChan invokes the sgw.SwitchGatewayExpirationPolicy API asynchronously
func (client *Client) SwitchGatewayExpirationPolicyWithChan(request *SwitchGatewayExpirationPolicyRequest) (<-chan *SwitchGatewayExpirationPolicyResponse, <-chan error) {
	responseChan := make(chan *SwitchGatewayExpirationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchGatewayExpirationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchGatewayExpirationPolicyWithCallback invokes the sgw.SwitchGatewayExpirationPolicy API asynchronously
func (client *Client) SwitchGatewayExpirationPolicyWithCallback(request *SwitchGatewayExpirationPolicyRequest, callback func(response *SwitchGatewayExpirationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchGatewayExpirationPolicyResponse
		var err error
		defer close(result)
		response, err = client.SwitchGatewayExpirationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchGatewayExpirationPolicyRequest is the request struct for api SwitchGatewayExpirationPolicy
type SwitchGatewayExpirationPolicyRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// SwitchGatewayExpirationPolicyResponse is the response struct for api SwitchGatewayExpirationPolicy
type SwitchGatewayExpirationPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateSwitchGatewayExpirationPolicyRequest creates a request to invoke SwitchGatewayExpirationPolicy API
func CreateSwitchGatewayExpirationPolicyRequest() (request *SwitchGatewayExpirationPolicyRequest) {
	request = &SwitchGatewayExpirationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "SwitchGatewayExpirationPolicy", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchGatewayExpirationPolicyResponse creates a response to parse from SwitchGatewayExpirationPolicy response
func CreateSwitchGatewayExpirationPolicyResponse() (response *SwitchGatewayExpirationPolicyResponse) {
	response = &SwitchGatewayExpirationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
