/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.generator;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetProvider;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.ViewSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.generator.SQLGeneratorDDLFromResultSet;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorHandlerResultSetDDL
extends AbstractHandler {
    @Nullable
    public Object execute(@NotNull ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        while (!(editorPart instanceof IResultSetProvider)) {
            if (editorPart instanceof MultiPageAbstractEditor) {
                editorPart = ((MultiPageAbstractEditor)editorPart).getActiveEditor();
                continue;
            }
            return null;
        }
        IResultSetController resultSetController = ((IResultSetProvider)editorPart).getResultSetController();
        if (resultSetController != null) {
            final SQLGeneratorDDLFromResultSet generator = new SQLGeneratorDDLFromResultSet();
            generator.initGenerator(List.of(resultSetController));
            if (generator != null) {
                IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                DBCExecutionContext context = resultSetController.getExecutionContext();
                ViewSQLDialog dialog = new ViewSQLDialog(activePage.getActivePart().getSite(), () -> context, NLS.bind((String)SQLEditorMessages.sql_generator_title_text, (Object)context.getDataSource().getContainer().getName()), null, ""){

                    @Override
                    @NotNull
                    protected Composite createDialogArea(Composite parent) {
                        UIUtils.runInUI((DBRRunnableWithProgress)generator);
                        Object sql = generator.getResult();
                        if (sql != null) {
                            this.setSQLText(CommonUtils.toString((Object)sql));
                        }
                        return super.createDialogArea(parent);
                    }
                };
                dialog.open();
            }
        }
        return null;
    }
}

