// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/osconfig/v1/patch_deployments.proto

package osconfig

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Specifies the frequency of the recurring patch deployments.
type RecurringSchedule_Frequency int32

const (
	// Invalid. A frequency must be specified.
	RecurringSchedule_FREQUENCY_UNSPECIFIED RecurringSchedule_Frequency = 0
	// Indicates that the frequency should be expressed in terms of
	// weeks.
	RecurringSchedule_WEEKLY RecurringSchedule_Frequency = 1
	// Indicates that the frequency should be expressed in terms of
	// months.
	RecurringSchedule_MONTHLY RecurringSchedule_Frequency = 2
)

// Enum value maps for RecurringSchedule_Frequency.
var (
	RecurringSchedule_Frequency_name = map[int32]string{
		0: "FREQUENCY_UNSPECIFIED",
		1: "WEEKLY",
		2: "MONTHLY",
	}
	RecurringSchedule_Frequency_value = map[string]int32{
		"FREQUENCY_UNSPECIFIED": 0,
		"WEEKLY":                1,
		"MONTHLY":               2,
	}
)

func (x RecurringSchedule_Frequency) Enum() *RecurringSchedule_Frequency {
	p := new(RecurringSchedule_Frequency)
	*p = x
	return p
}

func (x RecurringSchedule_Frequency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecurringSchedule_Frequency) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_enumTypes[0].Descriptor()
}

func (RecurringSchedule_Frequency) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_patch_deployments_proto_enumTypes[0]
}

func (x RecurringSchedule_Frequency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecurringSchedule_Frequency.Descriptor instead.
func (RecurringSchedule_Frequency) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{2, 0}
}

// Patch deployments are configurations that individual patch jobs use to
// complete a patch. These configurations include instance filter, package
// repository settings, and a schedule. For more information about creating and
// managing patch deployments, see [Scheduling patch
// jobs](https://cloud.google.com/compute/docs/os-patch-management/schedule-patch-jobs).
type PatchDeployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique name for the patch deployment resource in a project. The patch
	// deployment name is in the form:
	// `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
	// This field is ignored when you create a new patch deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description of the patch deployment. Length of the description is
	// limited to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. VM instances to patch.
	InstanceFilter *PatchInstanceFilter `protobuf:"bytes,3,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Optional. Patch configuration that is applied.
	PatchConfig *PatchConfig `protobuf:"bytes,4,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// Optional. Duration of the patch. After the duration ends, the patch times
	// out.
	Duration *durationpb.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// Schedule for the patch.
	//
	// Types that are assignable to Schedule:
	//	*PatchDeployment_OneTimeSchedule
	//	*PatchDeployment_RecurringSchedule
	Schedule isPatchDeployment_Schedule `protobuf_oneof:"schedule"`
	// Output only. Time the patch deployment was created. Timestamp is in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the patch deployment was last updated. Timestamp is in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The last time a patch job was started by this deployment.
	// Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
	// format.
	LastExecuteTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=last_execute_time,json=lastExecuteTime,proto3" json:"last_execute_time,omitempty"`
	// Optional. Rollout strategy of the patch job.
	Rollout *PatchRollout `protobuf:"bytes,11,opt,name=rollout,proto3" json:"rollout,omitempty"`
}

func (x *PatchDeployment) Reset() {
	*x = PatchDeployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchDeployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchDeployment) ProtoMessage() {}

func (x *PatchDeployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchDeployment.ProtoReflect.Descriptor instead.
func (*PatchDeployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{0}
}

func (x *PatchDeployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PatchDeployment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PatchDeployment) GetInstanceFilter() *PatchInstanceFilter {
	if x != nil {
		return x.InstanceFilter
	}
	return nil
}

func (x *PatchDeployment) GetPatchConfig() *PatchConfig {
	if x != nil {
		return x.PatchConfig
	}
	return nil
}

func (x *PatchDeployment) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (m *PatchDeployment) GetSchedule() isPatchDeployment_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (x *PatchDeployment) GetOneTimeSchedule() *OneTimeSchedule {
	if x, ok := x.GetSchedule().(*PatchDeployment_OneTimeSchedule); ok {
		return x.OneTimeSchedule
	}
	return nil
}

func (x *PatchDeployment) GetRecurringSchedule() *RecurringSchedule {
	if x, ok := x.GetSchedule().(*PatchDeployment_RecurringSchedule); ok {
		return x.RecurringSchedule
	}
	return nil
}

func (x *PatchDeployment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PatchDeployment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PatchDeployment) GetLastExecuteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastExecuteTime
	}
	return nil
}

func (x *PatchDeployment) GetRollout() *PatchRollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

type isPatchDeployment_Schedule interface {
	isPatchDeployment_Schedule()
}

type PatchDeployment_OneTimeSchedule struct {
	// Required. Schedule a one-time execution.
	OneTimeSchedule *OneTimeSchedule `protobuf:"bytes,6,opt,name=one_time_schedule,json=oneTimeSchedule,proto3,oneof"`
}

type PatchDeployment_RecurringSchedule struct {
	// Required. Schedule recurring executions.
	RecurringSchedule *RecurringSchedule `protobuf:"bytes,7,opt,name=recurring_schedule,json=recurringSchedule,proto3,oneof"`
}

func (*PatchDeployment_OneTimeSchedule) isPatchDeployment_Schedule() {}

func (*PatchDeployment_RecurringSchedule) isPatchDeployment_Schedule() {}

// Sets the time for a one time patch deployment. Timestamp is in
// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
type OneTimeSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The desired patch job execution time.
	ExecuteTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=execute_time,json=executeTime,proto3" json:"execute_time,omitempty"`
}

func (x *OneTimeSchedule) Reset() {
	*x = OneTimeSchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OneTimeSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OneTimeSchedule) ProtoMessage() {}

func (x *OneTimeSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OneTimeSchedule.ProtoReflect.Descriptor instead.
func (*OneTimeSchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{1}
}

func (x *OneTimeSchedule) GetExecuteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExecuteTime
	}
	return nil
}

// Sets the time for recurring patch deployments.
type RecurringSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Defines the time zone that `time_of_day` is relative to.
	// The rules for daylight saving time are determined by the chosen time zone.
	TimeZone *datetime.TimeZone `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The time that the recurring schedule becomes effective.
	// Defaults to `create_time` of the patch deployment.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The end time at which a recurring patch deployment schedule is no
	// longer active.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Required. Time of the day to run a recurring deployment.
	TimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=time_of_day,json=timeOfDay,proto3" json:"time_of_day,omitempty"`
	// Required. The frequency unit of this recurring schedule.
	Frequency RecurringSchedule_Frequency `protobuf:"varint,5,opt,name=frequency,proto3,enum=google.cloud.osconfig.v1.RecurringSchedule_Frequency" json:"frequency,omitempty"`
	// Configurations for this recurring schedule.
	// Configurations must match frequency.
	//
	// Types that are assignable to ScheduleConfig:
	//	*RecurringSchedule_Weekly
	//	*RecurringSchedule_Monthly
	ScheduleConfig isRecurringSchedule_ScheduleConfig `protobuf_oneof:"schedule_config"`
	// Output only. The time the last patch job ran successfully.
	LastExecuteTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_execute_time,json=lastExecuteTime,proto3" json:"last_execute_time,omitempty"`
	// Output only. The time the next patch job is scheduled to run.
	NextExecuteTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=next_execute_time,json=nextExecuteTime,proto3" json:"next_execute_time,omitempty"`
}

func (x *RecurringSchedule) Reset() {
	*x = RecurringSchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecurringSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecurringSchedule) ProtoMessage() {}

func (x *RecurringSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecurringSchedule.ProtoReflect.Descriptor instead.
func (*RecurringSchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{2}
}

func (x *RecurringSchedule) GetTimeZone() *datetime.TimeZone {
	if x != nil {
		return x.TimeZone
	}
	return nil
}

func (x *RecurringSchedule) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *RecurringSchedule) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *RecurringSchedule) GetTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.TimeOfDay
	}
	return nil
}

func (x *RecurringSchedule) GetFrequency() RecurringSchedule_Frequency {
	if x != nil {
		return x.Frequency
	}
	return RecurringSchedule_FREQUENCY_UNSPECIFIED
}

func (m *RecurringSchedule) GetScheduleConfig() isRecurringSchedule_ScheduleConfig {
	if m != nil {
		return m.ScheduleConfig
	}
	return nil
}

func (x *RecurringSchedule) GetWeekly() *WeeklySchedule {
	if x, ok := x.GetScheduleConfig().(*RecurringSchedule_Weekly); ok {
		return x.Weekly
	}
	return nil
}

func (x *RecurringSchedule) GetMonthly() *MonthlySchedule {
	if x, ok := x.GetScheduleConfig().(*RecurringSchedule_Monthly); ok {
		return x.Monthly
	}
	return nil
}

func (x *RecurringSchedule) GetLastExecuteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastExecuteTime
	}
	return nil
}

func (x *RecurringSchedule) GetNextExecuteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextExecuteTime
	}
	return nil
}

type isRecurringSchedule_ScheduleConfig interface {
	isRecurringSchedule_ScheduleConfig()
}

type RecurringSchedule_Weekly struct {
	// Required. Schedule with weekly executions.
	Weekly *WeeklySchedule `protobuf:"bytes,6,opt,name=weekly,proto3,oneof"`
}

type RecurringSchedule_Monthly struct {
	// Required. Schedule with monthly executions.
	Monthly *MonthlySchedule `protobuf:"bytes,7,opt,name=monthly,proto3,oneof"`
}

func (*RecurringSchedule_Weekly) isRecurringSchedule_ScheduleConfig() {}

func (*RecurringSchedule_Monthly) isRecurringSchedule_ScheduleConfig() {}

// Represents a weekly schedule.
type WeeklySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Day of the week.
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,1,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
}

func (x *WeeklySchedule) Reset() {
	*x = WeeklySchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WeeklySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeeklySchedule) ProtoMessage() {}

func (x *WeeklySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeeklySchedule.ProtoReflect.Descriptor instead.
func (*WeeklySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{3}
}

func (x *WeeklySchedule) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

// Represents a monthly schedule. An example of a valid monthly schedule is
// "on the third Tuesday of the month" or "on the 15th of the month".
type MonthlySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One day in a month.
	//
	// Types that are assignable to DayOfMonth:
	//	*MonthlySchedule_WeekDayOfMonth
	//	*MonthlySchedule_MonthDay
	DayOfMonth isMonthlySchedule_DayOfMonth `protobuf_oneof:"day_of_month"`
}

func (x *MonthlySchedule) Reset() {
	*x = MonthlySchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonthlySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonthlySchedule) ProtoMessage() {}

func (x *MonthlySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonthlySchedule.ProtoReflect.Descriptor instead.
func (*MonthlySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{4}
}

func (m *MonthlySchedule) GetDayOfMonth() isMonthlySchedule_DayOfMonth {
	if m != nil {
		return m.DayOfMonth
	}
	return nil
}

func (x *MonthlySchedule) GetWeekDayOfMonth() *WeekDayOfMonth {
	if x, ok := x.GetDayOfMonth().(*MonthlySchedule_WeekDayOfMonth); ok {
		return x.WeekDayOfMonth
	}
	return nil
}

func (x *MonthlySchedule) GetMonthDay() int32 {
	if x, ok := x.GetDayOfMonth().(*MonthlySchedule_MonthDay); ok {
		return x.MonthDay
	}
	return 0
}

type isMonthlySchedule_DayOfMonth interface {
	isMonthlySchedule_DayOfMonth()
}

type MonthlySchedule_WeekDayOfMonth struct {
	// Required. Week day in a month.
	WeekDayOfMonth *WeekDayOfMonth `protobuf:"bytes,1,opt,name=week_day_of_month,json=weekDayOfMonth,proto3,oneof"`
}

type MonthlySchedule_MonthDay struct {
	// Required. One day of the month. 1-31 indicates the 1st to the 31st day.
	// -1 indicates the last day of the month. Months without the target day
	// will be skipped. For example, a schedule to run "every month on the 31st"
	// will not run in February, April, June, etc.
	MonthDay int32 `protobuf:"varint,2,opt,name=month_day,json=monthDay,proto3,oneof"`
}

func (*MonthlySchedule_WeekDayOfMonth) isMonthlySchedule_DayOfMonth() {}

func (*MonthlySchedule_MonthDay) isMonthlySchedule_DayOfMonth() {}

// Represents one week day in a month. An example is "the 4th Sunday".
type WeekDayOfMonth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Week number in a month. 1-4 indicates the 1st to 4th week of the
	// month. -1 indicates the last week of the month.
	WeekOrdinal int32 `protobuf:"varint,1,opt,name=week_ordinal,json=weekOrdinal,proto3" json:"week_ordinal,omitempty"`
	// Required. A day of the week.
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
}

func (x *WeekDayOfMonth) Reset() {
	*x = WeekDayOfMonth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WeekDayOfMonth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeekDayOfMonth) ProtoMessage() {}

func (x *WeekDayOfMonth) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeekDayOfMonth.ProtoReflect.Descriptor instead.
func (*WeekDayOfMonth) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{5}
}

func (x *WeekDayOfMonth) GetWeekOrdinal() int32 {
	if x != nil {
		return x.WeekOrdinal
	}
	return 0
}

func (x *WeekDayOfMonth) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

// A request message for creating a patch deployment.
type CreatePatchDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to apply this patch deployment to in the form
	// `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A name for the patch deployment in the project. When creating a
	// name the following rules apply:
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the project.
	PatchDeploymentId string `protobuf:"bytes,2,opt,name=patch_deployment_id,json=patchDeploymentId,proto3" json:"patch_deployment_id,omitempty"`
	// Required. The patch deployment to create.
	PatchDeployment *PatchDeployment `protobuf:"bytes,3,opt,name=patch_deployment,json=patchDeployment,proto3" json:"patch_deployment,omitempty"`
}

func (x *CreatePatchDeploymentRequest) Reset() {
	*x = CreatePatchDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePatchDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePatchDeploymentRequest) ProtoMessage() {}

func (x *CreatePatchDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePatchDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreatePatchDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{6}
}

func (x *CreatePatchDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePatchDeploymentRequest) GetPatchDeploymentId() string {
	if x != nil {
		return x.PatchDeploymentId
	}
	return ""
}

func (x *CreatePatchDeploymentRequest) GetPatchDeployment() *PatchDeployment {
	if x != nil {
		return x.PatchDeployment
	}
	return nil
}

// A request message for retrieving a patch deployment.
type GetPatchDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the patch deployment in the form
	// `projects/*/patchDeployments/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPatchDeploymentRequest) Reset() {
	*x = GetPatchDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPatchDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPatchDeploymentRequest) ProtoMessage() {}

func (x *GetPatchDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPatchDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetPatchDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{7}
}

func (x *GetPatchDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message for listing patch deployments.
type ListPatchDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent in the form `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of patch deployments to return. Default is
	// 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to
	// ListPatchDeployments that indicates where this listing should continue
	// from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPatchDeploymentsRequest) Reset() {
	*x = ListPatchDeploymentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPatchDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPatchDeploymentsRequest) ProtoMessage() {}

func (x *ListPatchDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPatchDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListPatchDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{8}
}

func (x *ListPatchDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPatchDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPatchDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response message for listing patch deployments.
type ListPatchDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of patch deployments.
	PatchDeployments []*PatchDeployment `protobuf:"bytes,1,rep,name=patch_deployments,json=patchDeployments,proto3" json:"patch_deployments,omitempty"`
	// A pagination token that can be used to get the next page of patch
	// deployments.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPatchDeploymentsResponse) Reset() {
	*x = ListPatchDeploymentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPatchDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPatchDeploymentsResponse) ProtoMessage() {}

func (x *ListPatchDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPatchDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListPatchDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{9}
}

func (x *ListPatchDeploymentsResponse) GetPatchDeployments() []*PatchDeployment {
	if x != nil {
		return x.PatchDeployments
	}
	return nil
}

func (x *ListPatchDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request message for deleting a patch deployment.
type DeletePatchDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the patch deployment in the form
	// `projects/*/patchDeployments/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePatchDeploymentRequest) Reset() {
	*x = DeletePatchDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePatchDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePatchDeploymentRequest) ProtoMessage() {}

func (x *DeletePatchDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePatchDeploymentRequest.ProtoReflect.Descriptor instead.
func (*DeletePatchDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP(), []int{10}
}

func (x *DeletePatchDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_osconfig_v1_patch_deployments_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_v1_patch_deployments_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61,
	0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x06, 0x0a, 0x0f, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x0c, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5c, 0x0a, 0x11, 0x6f, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0f,
	0x6f, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x61, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52,
	0x11, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a,
	0x27, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d,
	0x42, 0x0a, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x55, 0x0a, 0x0f,
	0x4f, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x42, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0xe2, 0x05, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e,
	0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f,
	0x6e, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x58, 0x0a, 0x09, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72,
	0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x46, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x47, 0x0a, 0x06, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x06, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x12, 0x4a,
	0x0a, 0x07, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68,
	0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48,
	0x00, 0x52, 0x07, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x12, 0x4b, 0x0a, 0x11, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x3f, 0x0a, 0x09, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54,
	0x48, 0x4c, 0x59, 0x10, 0x02, 0x42, 0x11, 0x0a, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4d, 0x0a, 0x0e, 0x57, 0x65, 0x65, 0x6b,
	0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x61,
	0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61,
	0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x22, 0xa1, 0x01, 0x0a, 0x0f, 0x4d, 0x6f, 0x6e, 0x74,
	0x68, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5a, 0x0a, 0x11, 0x77,
	0x65, 0x65, 0x6b, 0x5f, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x57, 0x65, 0x65, 0x6b, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x65, 0x65, 0x6b, 0x44, 0x61, 0x79,
	0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x22, 0x0a, 0x09, 0x6d, 0x6f, 0x6e, 0x74, 0x68,
	0x5f, 0x64, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48,
	0x00, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x44, 0x61, 0x79, 0x42, 0x0e, 0x0a, 0x0c, 0x64,
	0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x22, 0x75, 0x0a, 0x0e, 0x57,
	0x65, 0x65, 0x6b, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x26, 0x0a,
	0x0c, 0x77, 0x65, 0x65, 0x6b, 0x5f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x65, 0x65, 0x6b, 0x4f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f,
	0x77, 0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65,
	0x65, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65,
	0x65, 0x6b, 0x22, 0xfb, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x33, 0x0a, 0x13, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x70, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x59, 0x0a, 0x10, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x60, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9e, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x11, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x70, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x63, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0xc6, 0x01, 0x0a, 0x1c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5a, 0x40,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescData = file_google_cloud_osconfig_v1_patch_deployments_proto_rawDesc
)

func file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescData)
	})
	return file_google_cloud_osconfig_v1_patch_deployments_proto_rawDescData
}

var file_google_cloud_osconfig_v1_patch_deployments_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_osconfig_v1_patch_deployments_proto_goTypes = []interface{}{
	(RecurringSchedule_Frequency)(0),     // 0: google.cloud.osconfig.v1.RecurringSchedule.Frequency
	(*PatchDeployment)(nil),              // 1: google.cloud.osconfig.v1.PatchDeployment
	(*OneTimeSchedule)(nil),              // 2: google.cloud.osconfig.v1.OneTimeSchedule
	(*RecurringSchedule)(nil),            // 3: google.cloud.osconfig.v1.RecurringSchedule
	(*WeeklySchedule)(nil),               // 4: google.cloud.osconfig.v1.WeeklySchedule
	(*MonthlySchedule)(nil),              // 5: google.cloud.osconfig.v1.MonthlySchedule
	(*WeekDayOfMonth)(nil),               // 6: google.cloud.osconfig.v1.WeekDayOfMonth
	(*CreatePatchDeploymentRequest)(nil), // 7: google.cloud.osconfig.v1.CreatePatchDeploymentRequest
	(*GetPatchDeploymentRequest)(nil),    // 8: google.cloud.osconfig.v1.GetPatchDeploymentRequest
	(*ListPatchDeploymentsRequest)(nil),  // 9: google.cloud.osconfig.v1.ListPatchDeploymentsRequest
	(*ListPatchDeploymentsResponse)(nil), // 10: google.cloud.osconfig.v1.ListPatchDeploymentsResponse
	(*DeletePatchDeploymentRequest)(nil), // 11: google.cloud.osconfig.v1.DeletePatchDeploymentRequest
	(*PatchInstanceFilter)(nil),          // 12: google.cloud.osconfig.v1.PatchInstanceFilter
	(*PatchConfig)(nil),                  // 13: google.cloud.osconfig.v1.PatchConfig
	(*durationpb.Duration)(nil),          // 14: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),        // 15: google.protobuf.Timestamp
	(*PatchRollout)(nil),                 // 16: google.cloud.osconfig.v1.PatchRollout
	(*datetime.TimeZone)(nil),            // 17: google.type.TimeZone
	(*timeofday.TimeOfDay)(nil),          // 18: google.type.TimeOfDay
	(dayofweek.DayOfWeek)(0),             // 19: google.type.DayOfWeek
}
var file_google_cloud_osconfig_v1_patch_deployments_proto_depIdxs = []int32{
	12, // 0: google.cloud.osconfig.v1.PatchDeployment.instance_filter:type_name -> google.cloud.osconfig.v1.PatchInstanceFilter
	13, // 1: google.cloud.osconfig.v1.PatchDeployment.patch_config:type_name -> google.cloud.osconfig.v1.PatchConfig
	14, // 2: google.cloud.osconfig.v1.PatchDeployment.duration:type_name -> google.protobuf.Duration
	2,  // 3: google.cloud.osconfig.v1.PatchDeployment.one_time_schedule:type_name -> google.cloud.osconfig.v1.OneTimeSchedule
	3,  // 4: google.cloud.osconfig.v1.PatchDeployment.recurring_schedule:type_name -> google.cloud.osconfig.v1.RecurringSchedule
	15, // 5: google.cloud.osconfig.v1.PatchDeployment.create_time:type_name -> google.protobuf.Timestamp
	15, // 6: google.cloud.osconfig.v1.PatchDeployment.update_time:type_name -> google.protobuf.Timestamp
	15, // 7: google.cloud.osconfig.v1.PatchDeployment.last_execute_time:type_name -> google.protobuf.Timestamp
	16, // 8: google.cloud.osconfig.v1.PatchDeployment.rollout:type_name -> google.cloud.osconfig.v1.PatchRollout
	15, // 9: google.cloud.osconfig.v1.OneTimeSchedule.execute_time:type_name -> google.protobuf.Timestamp
	17, // 10: google.cloud.osconfig.v1.RecurringSchedule.time_zone:type_name -> google.type.TimeZone
	15, // 11: google.cloud.osconfig.v1.RecurringSchedule.start_time:type_name -> google.protobuf.Timestamp
	15, // 12: google.cloud.osconfig.v1.RecurringSchedule.end_time:type_name -> google.protobuf.Timestamp
	18, // 13: google.cloud.osconfig.v1.RecurringSchedule.time_of_day:type_name -> google.type.TimeOfDay
	0,  // 14: google.cloud.osconfig.v1.RecurringSchedule.frequency:type_name -> google.cloud.osconfig.v1.RecurringSchedule.Frequency
	4,  // 15: google.cloud.osconfig.v1.RecurringSchedule.weekly:type_name -> google.cloud.osconfig.v1.WeeklySchedule
	5,  // 16: google.cloud.osconfig.v1.RecurringSchedule.monthly:type_name -> google.cloud.osconfig.v1.MonthlySchedule
	15, // 17: google.cloud.osconfig.v1.RecurringSchedule.last_execute_time:type_name -> google.protobuf.Timestamp
	15, // 18: google.cloud.osconfig.v1.RecurringSchedule.next_execute_time:type_name -> google.protobuf.Timestamp
	19, // 19: google.cloud.osconfig.v1.WeeklySchedule.day_of_week:type_name -> google.type.DayOfWeek
	6,  // 20: google.cloud.osconfig.v1.MonthlySchedule.week_day_of_month:type_name -> google.cloud.osconfig.v1.WeekDayOfMonth
	19, // 21: google.cloud.osconfig.v1.WeekDayOfMonth.day_of_week:type_name -> google.type.DayOfWeek
	1,  // 22: google.cloud.osconfig.v1.CreatePatchDeploymentRequest.patch_deployment:type_name -> google.cloud.osconfig.v1.PatchDeployment
	1,  // 23: google.cloud.osconfig.v1.ListPatchDeploymentsResponse.patch_deployments:type_name -> google.cloud.osconfig.v1.PatchDeployment
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_v1_patch_deployments_proto_init() }
func file_google_cloud_osconfig_v1_patch_deployments_proto_init() {
	if File_google_cloud_osconfig_v1_patch_deployments_proto != nil {
		return
	}
	file_google_cloud_osconfig_v1_patch_jobs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchDeployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OneTimeSchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecurringSchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WeeklySchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonthlySchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WeekDayOfMonth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePatchDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPatchDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPatchDeploymentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPatchDeploymentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePatchDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*PatchDeployment_OneTimeSchedule)(nil),
		(*PatchDeployment_RecurringSchedule)(nil),
	}
	file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*RecurringSchedule_Weekly)(nil),
		(*RecurringSchedule_Monthly)(nil),
	}
	file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*MonthlySchedule_WeekDayOfMonth)(nil),
		(*MonthlySchedule_MonthDay)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_v1_patch_deployments_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_v1_patch_deployments_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_v1_patch_deployments_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_v1_patch_deployments_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_v1_patch_deployments_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_v1_patch_deployments_proto = out.File
	file_google_cloud_osconfig_v1_patch_deployments_proto_rawDesc = nil
	file_google_cloud_osconfig_v1_patch_deployments_proto_goTypes = nil
	file_google_cloud_osconfig_v1_patch_deployments_proto_depIdxs = nil
}
