# frozen_string_literal: true

describe Facts::Debian::Os::Distro::Id do
  describe '#call_the_resolver' do
    subject(:fact) { Facts::Debian::Os::Distro::Id.new }

    let(:value) { 'debian' }

    before do
      allow(Facter::Resolvers::OsRelease).to receive(:resolve).with(:id).and_return(value)
    end

    it 'returns os.distro.id fact' do
      expect(fact.call_the_resolver).to be_an_instance_of(Facter::ResolvedFact).and \
        have_attributes(name: 'os.distro.id', value: value.capitalize)
    end
  end
end
