#ifndef WIN32_COMMON_H
#define WIN32_COMMON_H

#include <windows.h>

#define __UTM_NO_DEV_RANDOM

#define snprintf _snprintf
#define vsnprintf _vsnprintf

inline int _open(
   const char *filename,
   int oflag,
   int pmode 
)
{
  _open(filename,oflag,pmode);
  return 0;
}

inline void sleep(int seconds)
{
	Sleep(seconds * 1000);
}

inline void usleep(unsigned long microsec)
{
	Sleep(microsec/1000UL);
}

#define strtoll _strtoi64 



#define OS_WIN32 1
#define OS_LINUX 2
#define OS_BSD 3
#define OS_SOLARIS 4

#define OS_CODE OS_WIN32


#endif