/* sithwm - Minimalist Window Manager for X
 * see README for Copyright, license and other details. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "sithwm.h"
#include <limits.h>

ScreenInfo   *screens;
ScreenInfo*current_screen;
int          num_screens;
char	local_popup_list;

void setview(void)
{
   Client *c;
   for (c = head_client; c; c = c->next)
      if (c->screen == current_screen) {
	 struct pos r;
	 long data[2];
	 data[0] = intersect(&c->screen->area, &c->dyn.area)?
	    NormalState:IconicState;
	 data[1] = None;
	 toviewpos(c, &r);
	 XMoveResizeWindow(dpy, c->dyn.window, r.x, r.y, c->dyn.area.w, c->dyn.area.h);
	 LOG_DEBUG("rescreening: 0x%lx at %ix%i%+i%+i\n", c->dyn.window, c->dyn.area.w, c->dyn.area.h, r.x, r.y);
	 XChangeProperty(dpy, c->dyn.window, xa_wm_state, xa_wm_state, 32,
			 PropModeReplace, (unsigned char *)data, 2);

      }
}

static int min(int x, int y) {return x<y?x:y;}

void toviewpos(Client *c, struct pos*r)
{
   int minb = -opt_bw;
   struct pos rel = {c->dyn.area.pos.x+minb,c->dyn.area.pos.y+minb};
   if (!c->dyn.sticky) {
      rel.x -= c->screen->area.pos.x;
      rel.y -= c->screen->area.pos.y;
   } else {
      if (rel.x<minb)rel.x=minb;
      if (rel.y<minb)rel.y=minb;
      rel.x = min(rel.x, c->screen->area.w-50);
      rel.y = min(rel.y, c->screen->area.h-50);
   }
   *r = rel;
}

void toworldpos(Client *c, int x, int y, struct pos*r)
{
   int relx = x+opt_bw;
   int rely = y+opt_bw;
   if (!c->dyn.sticky) {
      relx += c->screen->area.pos.x;
      rely += c->screen->area.pos.y;
   }
   r->x = relx;
   r->y = rely;
}

#ifndef STORMTROOPER

struct area opt_popup_area = {{30,30},320,320};
int opt_popup_stack_width = 256;
int opt_popup_time_in = 0;
int stacker_offset;

#define STACKHEIGHT 48

static void scale_rect(struct area*inr,
		       struct area*grid,
		       struct area*result)
{
   int scaler = grid->w;
   result->w = inr->w/scaler;
   result->h = inr->h/scaler;
   result->pos.x = (inr->pos.x-grid->pos.x)/scaler;
   result->pos.y = (inr->pos.y-grid->pos.y)/scaler;
}

#define print_rect(s,rect) printf("%s%ix%i%+i%+i\n", (s), (rect).w, (rect).h, (rect).x, (rect).y)

static void extend_grid(struct area *grid, struct area *area)
{
   int zz;
   zz = area->pos.x;
   if (zz<grid->pos.x) grid->pos.x = zz;
   zz = area->pos.y;
   if (zz<grid->pos.y) grid->pos.y = zz;
   zz = area->pos.x+area->w-1;
   if (zz>grid->w) grid->w = zz;
   zz = area->pos.y+area->h-1;
   if (zz>grid->h) grid->h = zz;
}
#endif

void update_info_window(ScreenInfo *screen, int func)
{
   static int key;
   Client*hc=head_client;

   if (func==INFOW_CAPTION) {
      if (!hc)
         return;
   }

   if ( func<screen->infow_func )
      return;

   if ( func>screen->infow_func )
      key++;

   screen->infow_func = func;

#ifndef STORMTROOPER
   struct area iwin;

   if (func>INFOW_CAPTION)
      XInstallColormap(dpy, screen->cmap);

   switch (func) {
   case INFOW_MAP: {
      iwin.w = (opt_popup_area.w+opt_popup_stack_width)*infow_scaler;
      iwin.h = opt_popup_area.h;
      iwin.pos.x = opt_popup_area.pos.x;
      iwin.pos.y = opt_popup_area.pos.y;
   }break;
   case INFOW_CAPTION:{
      struct pos pos;
      snprintf(global_buffer, sizeof global_buffer, "%s %dx%d%+d%+d%c", hc->name,
              hc->dyn.area.w, hc->dyn.area.h, hc->dyn.area.pos.x, hc->dyn.area.pos.y, hc->dyn.sticky);
      iwin.w = XTextWidth(font, global_buffer, strlen(global_buffer)) + 4;
      iwin.h = font_height;
      toviewpos(hc, &pos);
      iwin.pos.x = pos.x + hc->dyn.area.w - iwin.w + opt_bw*2 - 2;
      iwin.pos.y = pos.y - iwin.h + opt_bw - 2;
      if (iwin.pos.y<0) iwin.pos.y = 0;
      if (iwin.pos.x<0) iwin.pos.x = 0;
      if ( iwin.pos.x > (screen->area.w-iwin.w))
	 iwin.pos.x = screen->area.w-iwin.w;
      if ( iwin.pos.y > (screen->area.h-iwin.h))
	 iwin.pos.y = screen->area.h-iwin.h;
   }break;
   default:
	 iwin.w = 0;
   }

   int stackwidth = opt_popup_stack_width;
   if (iwin.w>0) {
      XMoveResizeWindow(dpy, screen->infow, iwin.pos.x, iwin.pos.y, iwin.w, iwin.h);
      XMapRaised(dpy, screen->infow);
   }

   switch (func) {
   case INFOW_MAP: {
      if (iwin.w>0) {
	 Window root,prnt,*chlds;
	 int pass;
	 unsigned nchlds;
	 struct { struct area a; struct pos p; } gr;
	 int hilit_offs=0;
	 int stacker=0;
	 iwin.w -= stackwidth;
	 gr.a.pos.x = gr.a.pos.y = INT_MAX;
	 gr.a.w = gr.a.h = INT_MIN;
	 XQueryTree(dpy, screen->root, &root, &prnt, &chlds, &nchlds);
	 Client**clients = (Client**)calloc(nchlds+3, sizeof(*clients));
	 Client**icl = clients;
	 for (int i = 0; i<nchlds ; i++)
	 {
	    if (chlds[i] != screen->hilit) {
	       *icl = find_client(chlds[i]);
	       if (*icl) icl++;
	    }
	 }
	 *icl++ = find_client(screen->hilit);
	 XFree(chlds);

	 for (pass=0;pass<2;pass++) {
	    if ( iwin.w>0 ) {
	       for (icl = clients; *icl; icl++) {
		  Client *c = *icl;
		  struct area r;
		  if (c->screen != screen)
		     continue;
		  if (pass==0) {
		     extend_grid(&gr.a, &c->dyn.area);
		     continue;
		  }
		  struct area cda = c->dyn.area;
		  if (c->dyn.sticky) {
		     cda.pos.x += screen->area.pos.x;
		     cda.pos.y += screen->area.pos.y;
		  }
		  scale_rect(&cda, &gr.a, &r);

		  int cc = (c->dyn.window!=screen->hilit)?('b'-COL_BASE):('h'-COL_BASE);
		  for (int i=0;i<2;i++) {
		     (i?XDrawRectangle:XFillRectangle)
			(dpy, screen->infow, screen->gc[cc],
			 r.pos.x, r.pos.y, r.w, r.h);
		     cc = 'i'-COL_BASE;
		  }
		  r.pos.x += 4;
		  r.pos.y += font_height+2;
		  int offs = (c->icon_height-STACKHEIGHT)>>1;
		  XCopyArea(dpy, c->icon,  screen->infow, screen->gc[('i'-COL_BASE)],
			    offs, offs, STACKHEIGHT, STACKHEIGHT,
			    r.pos.x, r.pos.y);
		  XDrawImageString(dpy, screen->infow, screen->gc['i'-COL_BASE],
				   r.pos.x, r.pos.y - font->max_bounds.descent,
				   c->name, strlen(c->name));
	       }
	    }

	    int offs = iwin.h-stacker;
	    if (offs<0) {
               int ih2 = iwin.h>>1;
	       if (hilit_offs<ih2)
		  stacker=0;
 	       else if ((stacker-hilit_offs)<ih2)
                  stacker = offs; 
	       else
		  stacker = -hilit_offs+(iwin.h>>1);
	    } else
	       stacker=0;
            if (pass) {
               static int real_stacker;
	       stacker_offset = stacker - (real_stacker>>1);
	       real_stacker += stacker_offset;
               stacker = real_stacker>>1;
            }

	    for (Client*c = head_client; c ; c=c->next)
	    {
	       if (c->screen == screen &&
		   ( !local_popup_list || intersect(&screen->area, &c->dyn.area))) {
		  if (pass) {
		     XFillRectangle(dpy, screen->infow,
				    screen->gc[(c->dyn.window == screen->hilit)?('h'-COL_BASE):('b'-COL_BASE)],
				    iwin.w, stacker, stackwidth, STACKHEIGHT+1);
                     int offs = (c->icon_height-STACKHEIGHT)>>1;

/* 		     XSetClipMask(dpy, screen->gc['i'-COL_BASE], c->icon_mask); */
/* 		     XSetClipOrigin(dpy, screen->gc['i'-COL_BASE], */
/* 				    0, 0); */
		     XCopyArea(dpy, c->icon,  screen->infow, screen->gc[('i'-COL_BASE)],
			       offs, offs, STACKHEIGHT, STACKHEIGHT+1,
			       iwin.w, stacker);
/* 		     XSetClipMask(dpy, screen->gc['i'-COL_BASE], None); */
/*                      XCopyArea(dpy, c->icon_mask,  screen->infow, screen->gc[('i'-COL_BASE)], */
/*                                offs, offs, STACKHEIGHT, STACKHEIGHT+1, */
/*                                iwin.w, stacker); */
/* 		     glob_gcv.clip_mask = None; */
/* 		     XChangeGC(dpy, screen->gc['i'-COL_BASE], GCClipMask, &glob_gcv); */
		     XDrawString(dpy, screen->infow, screen->gc['i'-COL_BASE],
				 iwin.w + STACKHEIGHT+2, stacker + STACKHEIGHT/2+3,
				 c->name, strlen(c->name));
		  }
		  if (c->dyn.window == screen->hilit)
		     hilit_offs = stacker;
		  stacker += STACKHEIGHT+1;
	       }
	    }
	    if (pass)
	       XClearArea(dpy, screen->infow,
			  iwin.w, stacker, stackwidth, iwin.h, 0);

	    if ( iwin.w>0 ) {
	       if (pass==0) {
		  extend_grid(&gr.a, &screen->area);
		  int zzx = gr.a.w - gr.a.pos.x;
		  int zzy = gr.a.h - gr.a.pos.y;
		  //print_rect("Pre:", &grid);
		  gr.a.w = (zzx+iwin.w+5)/iwin.w;
		  gr.a.h = (zzy+iwin.h+5)/iwin.h;
		  if (gr.a.h>gr.a.w) gr.a.w = gr.a.h;
		  gr.a.pos.x -= (gr.a.w*iwin.w-zzx)>>1;
		  gr.a.pos.y -= (gr.a.w*iwin.h-zzy)>>1;

		  static Window hilit_save;
		  gr.p=screen->area.pos;
		  static unsigned int oldhash;
		  static Client*oldclient;
		  unsigned int nhash = hash_val(&gr, sizeof gr, key);
		  if (nhash != oldhash) {
		     oldhash = nhash;
		     XClearWindow(dpy, screen->infow);
		     oldclient = 0;
		  }
		  else {
		     icl = clients;
		     Client* hil = find_client(screen->hilit);
		     if (hil != oldclient) {
			oldclient = hil;
			if ( (*icl = find_client(hilit_save)) )
			   icl++;
			*icl++ = hil;
		     }
		     *icl = 0;
		  }
		  hilit_save = screen->hilit;
	       } else if (screen->hilit == 0) {
		  struct area r;
		  scale_rect(&screen->area, &gr.a, &r);
#define WWW (4)
		  XSetLineAttributes(dpy, screen->gc['h'-COL_BASE], 2*WWW, LineSolid, CapRound, JoinRound);
		  XDrawRectangle(dpy, screen->infow, screen->gc['h'-COL_BASE],
				 r.pos.x-WWW, r.pos.y-WWW, r.w+2*WWW, r.h+2*WWW);
		  XSetLineAttributes(dpy, screen->gc['h'-COL_BASE], 0, LineSolid, CapRound, JoinRound);
	       }
	    }
	 }
	 free(clients);
	 iwin.w--;
	 XDrawLine(dpy, screen->infow, screen->gc['e'-COL_BASE],
		   iwin.w, 0, iwin.w, iwin.h);
      }
   }break;
   case INFOW_CAPTION:
      XFillRectangle(dpy, screen->infow, screen->gc['c'-COL_BASE], 0, 0, 2000, 2000);
      XDrawString(dpy, screen->infow, screen->gc['i'-COL_BASE], 3, iwin.h - font->max_bounds.descent,
		  global_buffer, strlen(global_buffer));
      break;
   case INFOW_MENU:
      do_menu(screen, 0);
   }
#endif
}



