// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BackendBase Backend Base
//
// HAProxy backend configuration
// Example: {"adv_check":"httpchk","balance":{"algorithm":"roundrobin"},"forwardfor":{"enabled":"enabled"},"httpchk_params":{"method":"GET","uri":"/check","version":"HTTP/1.1"},"mode":"http","name":"test_backend"}
//
// swagger:model backend_base
type BackendBase struct {

	// error files
	ErrorFiles []*Errorfile `json:"error_files,omitempty"`

	// error files from HTTP errors
	ErrorFilesFromHTTPErrors []*Errorfiles `json:"errorfiles_from_http_errors,omitempty"`

	// force persist list
	ForcePersistList []*ForcePersist `json:"force_persist_list,omitempty"`

	// ignore persist list
	IgnorePersistList []*IgnorePersist `json:"ignore_persist_list,omitempty"`

	// abortonclose
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Abortonclose string `json:"abortonclose,omitempty"`

	// accept invalid http response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	AcceptInvalidHTTPResponse string `json:"accept_invalid_http_response,omitempty"`

	// adv check
	// Enum: ["httpchk","ldap-check","mysql-check","pgsql-check","redis-check","smtpchk","ssl-hello-chk","tcp-check"]
	// +kubebuilder:validation:Enum="httpchk","ldap-check","mysql-check","pgsql-check","redis-check","smtpchk","ssl-hello-chk","tcp-check";
	AdvCheck string `json:"adv_check,omitempty"`

	// allbackups
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Allbackups string `json:"allbackups,omitempty"`

	// balance
	Balance *Balance `json:"balance,omitempty"`

	// check timeout
	CheckTimeout *int64 `json:"check_timeout,omitempty"`

	// checkcache
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Checkcache string `json:"checkcache,omitempty"`

	// compression
	Compression *Compression `json:"compression,omitempty"`

	// connect timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ConnectTimeout *int64 `json:"connect_timeout,omitempty"`

	// cookie
	Cookie *Cookie `json:"cookie,omitempty"`

	// default server
	DefaultServer *DefaultServer `json:"default_server,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// disabled
	Disabled bool `json:"disabled,omitempty"`

	// dynamic cookie key
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	DynamicCookieKey string `json:"dynamic_cookie_key,omitempty"`

	// email alert
	EmailAlert *EmailAlert `json:"email_alert,omitempty"`

	// enabled
	Enabled bool `json:"enabled,omitempty"`

	// errorloc302
	Errorloc302 *Errorloc `json:"errorloc302,omitempty"`

	// errorloc303
	Errorloc303 *Errorloc `json:"errorloc303,omitempty"`

	// external check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ExternalCheck string `json:"external_check,omitempty"`

	// external check command
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ExternalCheckCommand string `json:"external_check_command,omitempty"`

	// external check path
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ExternalCheckPath string `json:"external_check_path,omitempty"`

	// force persist
	ForcePersist *BackendForcePersist `json:"force_persist,omitempty"`

	// forwardfor
	Forwardfor *Forwardfor `json:"forwardfor,omitempty"`

	// from
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	From string `json:"from,omitempty"`

	// fullconn
	Fullconn *int64 `json:"fullconn,omitempty"`

	// guid
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	GUID string `json:"guid,omitempty"`

	// h1 case adjust bogus server
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	H1CaseAdjustBogusServer string `json:"h1_case_adjust_bogus_server,omitempty"`

	// hash balance factor
	HashBalanceFactor *int64 `json:"hash_balance_factor,omitempty"`

	// hash type
	HashType *HashType `json:"hash_type,omitempty"`

	// http buffer request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPBufferRequest string `json:"http-buffer-request,omitempty"`

	// http no delay
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPNoDelay string `json:"http-no-delay,omitempty"`

	// http use htx
	// Pattern: ^[^\s]+$
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPUseHtx string `json:"http-use-htx,omitempty"`

	// http connection mode
	// Enum: ["httpclose","http-server-close","http-keep-alive"]
	// +kubebuilder:validation:Enum="httpclose","http-server-close","http-keep-alive";
	HTTPConnectionMode string `json:"http_connection_mode,omitempty"`

	// http keep alive timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HTTPKeepAliveTimeout *int64 `json:"http_keep_alive_timeout,omitempty"`

	// http pretend keepalive
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPPretendKeepalive string `json:"http_pretend_keepalive,omitempty"`

	// http proxy
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPProxy string `json:"http_proxy,omitempty"`

	// http request timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HTTPRequestTimeout *int64 `json:"http_request_timeout,omitempty"`

	// http restrict req hdr names
	// Enum: ["preserve","delete","reject"]
	// +kubebuilder:validation:Enum="preserve","delete","reject";
	HTTPRestrictReqHdrNames string `json:"http_restrict_req_hdr_names,omitempty"`

	// http reuse
	// Enum: ["aggressive","always","never","safe"]
	// +kubebuilder:validation:Enum="aggressive","always","never","safe";
	HTTPReuse string `json:"http_reuse,omitempty"`

	// http send name header
	HTTPSendNameHeader *string `json:"http_send_name_header,omitempty"`

	// httpchk params
	HttpchkParams *HttpchkParams `json:"httpchk_params,omitempty"`

	// id
	ID *int64 `json:"id,omitempty"`

	// ignore persist
	IgnorePersist *BackendIgnorePersist `json:"ignore_persist,omitempty"`

	// independent streams
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	IndependentStreams string `json:"independent_streams,omitempty"`

	// load server state from file
	// Enum: ["global","local","none"]
	// +kubebuilder:validation:Enum="global","local","none";
	LoadServerStateFromFile string `json:"load_server_state_from_file,omitempty"`

	// log health checks
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	LogHealthChecks string `json:"log_health_checks,omitempty"`

	// log tag
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	LogTag string `json:"log_tag,omitempty"`

	// max keep alive queue
	MaxKeepAliveQueue *int64 `json:"max_keep_alive_queue,omitempty"`

	// mode
	// Enum: ["http","tcp","log"]
	// +kubebuilder:validation:Enum="http","tcp","log";
	Mode string `json:"mode,omitempty"`

	// mysql check params
	MysqlCheckParams *MysqlCheckParams `json:"mysql_check_params,omitempty"`

	// name
	// Required: true
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	Name string `json:"name"`

	// nolinger
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Nolinger string `json:"nolinger,omitempty"`

	// originalto
	Originalto *Originalto `json:"originalto,omitempty"`

	// persist
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Persist string `json:"persist,omitempty"`

	// persist rule
	PersistRule *PersistRule `json:"persist_rule,omitempty"`

	// pgsql check params
	PgsqlCheckParams *PgsqlCheckParams `json:"pgsql_check_params,omitempty"`

	// prefer last server
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	PreferLastServer string `json:"prefer_last_server,omitempty"`

	// queue timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	QueueTimeout *int64 `json:"queue_timeout,omitempty"`

	// redispatch
	Redispatch *Redispatch `json:"redispatch,omitempty"`

	// retries
	Retries *int64 `json:"retries,omitempty"`

	// retry on
	RetryOn string `json:"retry_on,omitempty"`

	// server fin timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ServerFinTimeout *int64 `json:"server_fin_timeout,omitempty"`

	// server state file name
	ServerStateFileName string `json:"server_state_file_name,omitempty"`

	// server timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ServerTimeout *int64 `json:"server_timeout,omitempty"`

	// smtpchk params
	SmtpchkParams *SmtpchkParams `json:"smtpchk_params,omitempty"`

	// source
	Source *Source `json:"source,omitempty"`

	// splice auto
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpliceAuto string `json:"splice_auto,omitempty"`

	// splice request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpliceRequest string `json:"splice_request,omitempty"`

	// splice response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpliceResponse string `json:"splice_response,omitempty"`

	// spop check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpopCheck string `json:"spop_check,omitempty"`

	// srvtcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Srvtcpka string `json:"srvtcpka,omitempty"`

	// srvtcpka cnt
	SrvtcpkaCnt *int64 `json:"srvtcpka_cnt,omitempty"`

	// srvtcpka idle
	SrvtcpkaIdle *int64 `json:"srvtcpka_idle,omitempty"`

	// srvtcpka intvl
	SrvtcpkaIntvl *int64 `json:"srvtcpka_intvl,omitempty"`

	// stats options
	StatsOptions *StatsOptions `json:"stats_options,omitempty"`

	// stick table
	StickTable *ConfigStickTable `json:"stick_table,omitempty"`

	// tarpit timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TarpitTimeout *int64 `json:"tarpit_timeout,omitempty"`

	// tcp smart connect
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	TCPSmartConnect string `json:"tcp_smart_connect,omitempty"`

	// tcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Tcpka string `json:"tcpka,omitempty"`

	// transparent
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Transparent string `json:"transparent,omitempty"`

	// tunnel timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TunnelTimeout *int64 `json:"tunnel_timeout,omitempty"`

	// use fcgi app
	UseFCGIApp string `json:"use_fcgi_app,omitempty"`
}

// Validate validates this backend base
func (m *BackendBase) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateErrorFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorFilesFromHTTPErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForcePersistList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgnorePersistList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAbortonclose(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAcceptInvalidHTTPResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdvCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAllbackups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBalance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompression(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCookie(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDynamicCookieKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmailAlert(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorloc302(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorloc303(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCheckCommand(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCheckPath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForcePersist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForwardfor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1CaseAdjustBogusServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPBufferRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPNoDelay(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPUseHtx(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPConnectionMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPKeepAliveTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPPretendKeepalive(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRequestTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRestrictReqHdrNames(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPReuse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHttpchkParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgnorePersist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIndependentStreams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLoadServerStateFromFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogHealthChecks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogTag(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMysqlCheckParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNolinger(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOriginalto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePersist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePersistRule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePgsqlCheckParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePreferLastServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQueueTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedispatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerFinTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSmtpchkParams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceAuto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpopCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSrvtcpka(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatsOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStickTable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarpitTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPSmartConnect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTcpka(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransparent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTunnelTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BackendBase) validateErrorFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorFiles) { // not required
		return nil
	}

	for i := 0; i < len(m.ErrorFiles); i++ {
		if swag.IsZero(m.ErrorFiles[i]) { // not required
			continue
		}

		if m.ErrorFiles[i] != nil {
			if err := m.ErrorFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) validateErrorFilesFromHTTPErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorFilesFromHTTPErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.ErrorFilesFromHTTPErrors); i++ {
		if swag.IsZero(m.ErrorFilesFromHTTPErrors[i]) { // not required
			continue
		}

		if m.ErrorFilesFromHTTPErrors[i] != nil {
			if err := m.ErrorFilesFromHTTPErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) validateForcePersistList(formats strfmt.Registry) error {
	if swag.IsZero(m.ForcePersistList) { // not required
		return nil
	}

	for i := 0; i < len(m.ForcePersistList); i++ {
		if swag.IsZero(m.ForcePersistList[i]) { // not required
			continue
		}

		if m.ForcePersistList[i] != nil {
			if err := m.ForcePersistList[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("force_persist_list" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("force_persist_list" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) validateIgnorePersistList(formats strfmt.Registry) error {
	if swag.IsZero(m.IgnorePersistList) { // not required
		return nil
	}

	for i := 0; i < len(m.IgnorePersistList); i++ {
		if swag.IsZero(m.IgnorePersistList[i]) { // not required
			continue
		}

		if m.IgnorePersistList[i] != nil {
			if err := m.IgnorePersistList[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ignore_persist_list" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ignore_persist_list" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var backendBaseTypeAbortonclosePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeAbortonclosePropEnum = append(backendBaseTypeAbortonclosePropEnum, v)
	}
}

const (

	// BackendBaseAbortoncloseEnabled captures enum value "enabled"
	BackendBaseAbortoncloseEnabled string = "enabled"

	// BackendBaseAbortoncloseDisabled captures enum value "disabled"
	BackendBaseAbortoncloseDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateAbortoncloseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeAbortonclosePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateAbortonclose(formats strfmt.Registry) error {
	if swag.IsZero(m.Abortonclose) { // not required
		return nil
	}

	// value enum
	if err := m.validateAbortoncloseEnum("abortonclose", "body", m.Abortonclose); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeAcceptInvalidHTTPResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeAcceptInvalidHTTPResponsePropEnum = append(backendBaseTypeAcceptInvalidHTTPResponsePropEnum, v)
	}
}

const (

	// BackendBaseAcceptInvalidHTTPResponseEnabled captures enum value "enabled"
	BackendBaseAcceptInvalidHTTPResponseEnabled string = "enabled"

	// BackendBaseAcceptInvalidHTTPResponseDisabled captures enum value "disabled"
	BackendBaseAcceptInvalidHTTPResponseDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateAcceptInvalidHTTPResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeAcceptInvalidHTTPResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateAcceptInvalidHTTPResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptInvalidHTTPResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateAcceptInvalidHTTPResponseEnum("accept_invalid_http_response", "body", m.AcceptInvalidHTTPResponse); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeAdvCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["httpchk","ldap-check","mysql-check","pgsql-check","redis-check","smtpchk","ssl-hello-chk","tcp-check"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeAdvCheckPropEnum = append(backendBaseTypeAdvCheckPropEnum, v)
	}
}

const (

	// BackendBaseAdvCheckHttpchk captures enum value "httpchk"
	BackendBaseAdvCheckHttpchk string = "httpchk"

	// BackendBaseAdvCheckLdapDashCheck captures enum value "ldap-check"
	BackendBaseAdvCheckLdapDashCheck string = "ldap-check"

	// BackendBaseAdvCheckMysqlDashCheck captures enum value "mysql-check"
	BackendBaseAdvCheckMysqlDashCheck string = "mysql-check"

	// BackendBaseAdvCheckPgsqlDashCheck captures enum value "pgsql-check"
	BackendBaseAdvCheckPgsqlDashCheck string = "pgsql-check"

	// BackendBaseAdvCheckRedisDashCheck captures enum value "redis-check"
	BackendBaseAdvCheckRedisDashCheck string = "redis-check"

	// BackendBaseAdvCheckSmtpchk captures enum value "smtpchk"
	BackendBaseAdvCheckSmtpchk string = "smtpchk"

	// BackendBaseAdvCheckSslDashHelloDashChk captures enum value "ssl-hello-chk"
	BackendBaseAdvCheckSslDashHelloDashChk string = "ssl-hello-chk"

	// BackendBaseAdvCheckTCPDashCheck captures enum value "tcp-check"
	BackendBaseAdvCheckTCPDashCheck string = "tcp-check"
)

// prop value enum
func (m *BackendBase) validateAdvCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeAdvCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateAdvCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.AdvCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateAdvCheckEnum("adv_check", "body", m.AdvCheck); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeAllbackupsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeAllbackupsPropEnum = append(backendBaseTypeAllbackupsPropEnum, v)
	}
}

const (

	// BackendBaseAllbackupsEnabled captures enum value "enabled"
	BackendBaseAllbackupsEnabled string = "enabled"

	// BackendBaseAllbackupsDisabled captures enum value "disabled"
	BackendBaseAllbackupsDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateAllbackupsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeAllbackupsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateAllbackups(formats strfmt.Registry) error {
	if swag.IsZero(m.Allbackups) { // not required
		return nil
	}

	// value enum
	if err := m.validateAllbackupsEnum("allbackups", "body", m.Allbackups); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateBalance(formats strfmt.Registry) error {
	if swag.IsZero(m.Balance) { // not required
		return nil
	}

	if m.Balance != nil {
		if err := m.Balance.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("balance")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("balance")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypeCheckcachePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeCheckcachePropEnum = append(backendBaseTypeCheckcachePropEnum, v)
	}
}

const (

	// BackendBaseCheckcacheEnabled captures enum value "enabled"
	BackendBaseCheckcacheEnabled string = "enabled"

	// BackendBaseCheckcacheDisabled captures enum value "disabled"
	BackendBaseCheckcacheDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateCheckcacheEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeCheckcachePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateCheckcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Checkcache) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckcacheEnum("checkcache", "body", m.Checkcache); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateCompression(formats strfmt.Registry) error {
	if swag.IsZero(m.Compression) { // not required
		return nil
	}

	if m.Compression != nil {
		if err := m.Compression.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compression")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("compression")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateConnectTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("connect_timeout", "body", *m.ConnectTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateCookie(formats strfmt.Registry) error {
	if swag.IsZero(m.Cookie) { // not required
		return nil
	}

	if m.Cookie != nil {
		if err := m.Cookie.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cookie")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cookie")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateDefaultServer(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultServer) { // not required
		return nil
	}

	if m.DefaultServer != nil {
		if err := m.DefaultServer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("default_server")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("default_server")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateDynamicCookieKey(formats strfmt.Registry) error {
	if swag.IsZero(m.DynamicCookieKey) { // not required
		return nil
	}

	if err := validate.Pattern("dynamic_cookie_key", "body", m.DynamicCookieKey, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateEmailAlert(formats strfmt.Registry) error {
	if swag.IsZero(m.EmailAlert) { // not required
		return nil
	}

	if m.EmailAlert != nil {
		if err := m.EmailAlert.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("email_alert")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("email_alert")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateErrorloc302(formats strfmt.Registry) error {
	if swag.IsZero(m.Errorloc302) { // not required
		return nil
	}

	if m.Errorloc302 != nil {
		if err := m.Errorloc302.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc302")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc302")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateErrorloc303(formats strfmt.Registry) error {
	if swag.IsZero(m.Errorloc303) { // not required
		return nil
	}

	if m.Errorloc303 != nil {
		if err := m.Errorloc303.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc303")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc303")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypeExternalCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeExternalCheckPropEnum = append(backendBaseTypeExternalCheckPropEnum, v)
	}
}

const (

	// BackendBaseExternalCheckEnabled captures enum value "enabled"
	BackendBaseExternalCheckEnabled string = "enabled"

	// BackendBaseExternalCheckDisabled captures enum value "disabled"
	BackendBaseExternalCheckDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateExternalCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeExternalCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateExternalCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateExternalCheckEnum("external_check", "body", m.ExternalCheck); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateExternalCheckCommand(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCheckCommand) { // not required
		return nil
	}

	if err := validate.Pattern("external_check_command", "body", m.ExternalCheckCommand, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateExternalCheckPath(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCheckPath) { // not required
		return nil
	}

	if err := validate.Pattern("external_check_path", "body", m.ExternalCheckPath, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateForcePersist(formats strfmt.Registry) error {
	if swag.IsZero(m.ForcePersist) { // not required
		return nil
	}

	if m.ForcePersist != nil {
		if err := m.ForcePersist.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("force_persist")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("force_persist")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateForwardfor(formats strfmt.Registry) error {
	if swag.IsZero(m.Forwardfor) { // not required
		return nil
	}

	if m.Forwardfor != nil {
		if err := m.Forwardfor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("forwardfor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("forwardfor")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.From) { // not required
		return nil
	}

	if err := validate.Pattern("from", "body", m.From, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateGUID(formats strfmt.Registry) error {
	if swag.IsZero(m.GUID) { // not required
		return nil
	}

	if err := validate.Pattern("guid", "body", m.GUID, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeH1CaseAdjustBogusServerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeH1CaseAdjustBogusServerPropEnum = append(backendBaseTypeH1CaseAdjustBogusServerPropEnum, v)
	}
}

const (

	// BackendBaseH1CaseAdjustBogusServerEnabled captures enum value "enabled"
	BackendBaseH1CaseAdjustBogusServerEnabled string = "enabled"

	// BackendBaseH1CaseAdjustBogusServerDisabled captures enum value "disabled"
	BackendBaseH1CaseAdjustBogusServerDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateH1CaseAdjustBogusServerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeH1CaseAdjustBogusServerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateH1CaseAdjustBogusServer(formats strfmt.Registry) error {
	if swag.IsZero(m.H1CaseAdjustBogusServer) { // not required
		return nil
	}

	// value enum
	if err := m.validateH1CaseAdjustBogusServerEnum("h1_case_adjust_bogus_server", "body", m.H1CaseAdjustBogusServer); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateHashType(formats strfmt.Registry) error {
	if swag.IsZero(m.HashType) { // not required
		return nil
	}

	if m.HashType != nil {
		if err := m.HashType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hash_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hash_type")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypeHTTPBufferRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPBufferRequestPropEnum = append(backendBaseTypeHTTPBufferRequestPropEnum, v)
	}
}

const (

	// BackendBaseHTTPBufferRequestEnabled captures enum value "enabled"
	BackendBaseHTTPBufferRequestEnabled string = "enabled"

	// BackendBaseHTTPBufferRequestDisabled captures enum value "disabled"
	BackendBaseHTTPBufferRequestDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateHTTPBufferRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPBufferRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPBufferRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPBufferRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPBufferRequestEnum("http-buffer-request", "body", m.HTTPBufferRequest); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPNoDelayPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPNoDelayPropEnum = append(backendBaseTypeHTTPNoDelayPropEnum, v)
	}
}

const (

	// BackendBaseHTTPNoDelayEnabled captures enum value "enabled"
	BackendBaseHTTPNoDelayEnabled string = "enabled"

	// BackendBaseHTTPNoDelayDisabled captures enum value "disabled"
	BackendBaseHTTPNoDelayDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateHTTPNoDelayEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPNoDelayPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPNoDelay(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPNoDelay) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPNoDelayEnum("http-no-delay", "body", m.HTTPNoDelay); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPUseHtxPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPUseHtxPropEnum = append(backendBaseTypeHTTPUseHtxPropEnum, v)
	}
}

const (

	// BackendBaseHTTPUseHtxEnabled captures enum value "enabled"
	BackendBaseHTTPUseHtxEnabled string = "enabled"

	// BackendBaseHTTPUseHtxDisabled captures enum value "disabled"
	BackendBaseHTTPUseHtxDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateHTTPUseHtxEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPUseHtxPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPUseHtx(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPUseHtx) { // not required
		return nil
	}

	if err := validate.Pattern("http-use-htx", "body", m.HTTPUseHtx, `^[^\s]+$`); err != nil {
		return err
	}

	// value enum
	if err := m.validateHTTPUseHtxEnum("http-use-htx", "body", m.HTTPUseHtx); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPConnectionModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["httpclose","http-server-close","http-keep-alive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPConnectionModePropEnum = append(backendBaseTypeHTTPConnectionModePropEnum, v)
	}
}

const (

	// BackendBaseHTTPConnectionModeHttpclose captures enum value "httpclose"
	BackendBaseHTTPConnectionModeHttpclose string = "httpclose"

	// BackendBaseHTTPConnectionModeHTTPDashServerDashClose captures enum value "http-server-close"
	BackendBaseHTTPConnectionModeHTTPDashServerDashClose string = "http-server-close"

	// BackendBaseHTTPConnectionModeHTTPDashKeepDashAlive captures enum value "http-keep-alive"
	BackendBaseHTTPConnectionModeHTTPDashKeepDashAlive string = "http-keep-alive"
)

// prop value enum
func (m *BackendBase) validateHTTPConnectionModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPConnectionModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPConnectionMode(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPConnectionMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPConnectionModeEnum("http_connection_mode", "body", m.HTTPConnectionMode); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateHTTPKeepAliveTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPKeepAliveTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_keep_alive_timeout", "body", *m.HTTPKeepAliveTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPPretendKeepalivePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPPretendKeepalivePropEnum = append(backendBaseTypeHTTPPretendKeepalivePropEnum, v)
	}
}

const (

	// BackendBaseHTTPPretendKeepaliveEnabled captures enum value "enabled"
	BackendBaseHTTPPretendKeepaliveEnabled string = "enabled"

	// BackendBaseHTTPPretendKeepaliveDisabled captures enum value "disabled"
	BackendBaseHTTPPretendKeepaliveDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateHTTPPretendKeepaliveEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPPretendKeepalivePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPPretendKeepalive(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPPretendKeepalive) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPPretendKeepaliveEnum("http_pretend_keepalive", "body", m.HTTPPretendKeepalive); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPProxyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPProxyPropEnum = append(backendBaseTypeHTTPProxyPropEnum, v)
	}
}

const (

	// BackendBaseHTTPProxyEnabled captures enum value "enabled"
	BackendBaseHTTPProxyEnabled string = "enabled"

	// BackendBaseHTTPProxyDisabled captures enum value "disabled"
	BackendBaseHTTPProxyDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateHTTPProxyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPProxyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPProxy(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPProxy) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPProxyEnum("http_proxy", "body", m.HTTPProxy); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateHTTPRequestTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPRequestTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_request_timeout", "body", *m.HTTPRequestTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPRestrictReqHdrNamesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preserve","delete","reject"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPRestrictReqHdrNamesPropEnum = append(backendBaseTypeHTTPRestrictReqHdrNamesPropEnum, v)
	}
}

const (

	// BackendBaseHTTPRestrictReqHdrNamesPreserve captures enum value "preserve"
	BackendBaseHTTPRestrictReqHdrNamesPreserve string = "preserve"

	// BackendBaseHTTPRestrictReqHdrNamesDelete captures enum value "delete"
	BackendBaseHTTPRestrictReqHdrNamesDelete string = "delete"

	// BackendBaseHTTPRestrictReqHdrNamesReject captures enum value "reject"
	BackendBaseHTTPRestrictReqHdrNamesReject string = "reject"
)

// prop value enum
func (m *BackendBase) validateHTTPRestrictReqHdrNamesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPRestrictReqHdrNamesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPRestrictReqHdrNames(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPRestrictReqHdrNames) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPRestrictReqHdrNamesEnum("http_restrict_req_hdr_names", "body", m.HTTPRestrictReqHdrNames); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeHTTPReusePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aggressive","always","never","safe"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeHTTPReusePropEnum = append(backendBaseTypeHTTPReusePropEnum, v)
	}
}

const (

	// BackendBaseHTTPReuseAggressive captures enum value "aggressive"
	BackendBaseHTTPReuseAggressive string = "aggressive"

	// BackendBaseHTTPReuseAlways captures enum value "always"
	BackendBaseHTTPReuseAlways string = "always"

	// BackendBaseHTTPReuseNever captures enum value "never"
	BackendBaseHTTPReuseNever string = "never"

	// BackendBaseHTTPReuseSafe captures enum value "safe"
	BackendBaseHTTPReuseSafe string = "safe"
)

// prop value enum
func (m *BackendBase) validateHTTPReuseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeHTTPReusePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateHTTPReuse(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPReuse) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPReuseEnum("http_reuse", "body", m.HTTPReuse); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateHttpchkParams(formats strfmt.Registry) error {
	if swag.IsZero(m.HttpchkParams) { // not required
		return nil
	}

	if m.HttpchkParams != nil {
		if err := m.HttpchkParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("httpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("httpchk_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateIgnorePersist(formats strfmt.Registry) error {
	if swag.IsZero(m.IgnorePersist) { // not required
		return nil
	}

	if m.IgnorePersist != nil {
		if err := m.IgnorePersist.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ignore_persist")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ignore_persist")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypeIndependentStreamsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeIndependentStreamsPropEnum = append(backendBaseTypeIndependentStreamsPropEnum, v)
	}
}

const (

	// BackendBaseIndependentStreamsEnabled captures enum value "enabled"
	BackendBaseIndependentStreamsEnabled string = "enabled"

	// BackendBaseIndependentStreamsDisabled captures enum value "disabled"
	BackendBaseIndependentStreamsDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateIndependentStreamsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeIndependentStreamsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateIndependentStreams(formats strfmt.Registry) error {
	if swag.IsZero(m.IndependentStreams) { // not required
		return nil
	}

	// value enum
	if err := m.validateIndependentStreamsEnum("independent_streams", "body", m.IndependentStreams); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeLoadServerStateFromFilePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["global","local","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeLoadServerStateFromFilePropEnum = append(backendBaseTypeLoadServerStateFromFilePropEnum, v)
	}
}

const (

	// BackendBaseLoadServerStateFromFileGlobal captures enum value "global"
	BackendBaseLoadServerStateFromFileGlobal string = "global"

	// BackendBaseLoadServerStateFromFileLocal captures enum value "local"
	BackendBaseLoadServerStateFromFileLocal string = "local"

	// BackendBaseLoadServerStateFromFileNone captures enum value "none"
	BackendBaseLoadServerStateFromFileNone string = "none"
)

// prop value enum
func (m *BackendBase) validateLoadServerStateFromFileEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeLoadServerStateFromFilePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateLoadServerStateFromFile(formats strfmt.Registry) error {
	if swag.IsZero(m.LoadServerStateFromFile) { // not required
		return nil
	}

	// value enum
	if err := m.validateLoadServerStateFromFileEnum("load_server_state_from_file", "body", m.LoadServerStateFromFile); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeLogHealthChecksPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeLogHealthChecksPropEnum = append(backendBaseTypeLogHealthChecksPropEnum, v)
	}
}

const (

	// BackendBaseLogHealthChecksEnabled captures enum value "enabled"
	BackendBaseLogHealthChecksEnabled string = "enabled"

	// BackendBaseLogHealthChecksDisabled captures enum value "disabled"
	BackendBaseLogHealthChecksDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateLogHealthChecksEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeLogHealthChecksPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateLogHealthChecks(formats strfmt.Registry) error {
	if swag.IsZero(m.LogHealthChecks) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogHealthChecksEnum("log_health_checks", "body", m.LogHealthChecks); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateLogTag(formats strfmt.Registry) error {
	if swag.IsZero(m.LogTag) { // not required
		return nil
	}

	if err := validate.Pattern("log_tag", "body", m.LogTag, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","tcp","log"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeModePropEnum = append(backendBaseTypeModePropEnum, v)
	}
}

const (

	// BackendBaseModeHTTP captures enum value "http"
	BackendBaseModeHTTP string = "http"

	// BackendBaseModeTCP captures enum value "tcp"
	BackendBaseModeTCP string = "tcp"

	// BackendBaseModeLog captures enum value "log"
	BackendBaseModeLog string = "log"
)

// prop value enum
func (m *BackendBase) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateMysqlCheckParams(formats strfmt.Registry) error {
	if swag.IsZero(m.MysqlCheckParams) { // not required
		return nil
	}

	if m.MysqlCheckParams != nil {
		if err := m.MysqlCheckParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mysql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mysql_check_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeNolingerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeNolingerPropEnum = append(backendBaseTypeNolingerPropEnum, v)
	}
}

const (

	// BackendBaseNolingerEnabled captures enum value "enabled"
	BackendBaseNolingerEnabled string = "enabled"

	// BackendBaseNolingerDisabled captures enum value "disabled"
	BackendBaseNolingerDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateNolingerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeNolingerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateNolinger(formats strfmt.Registry) error {
	if swag.IsZero(m.Nolinger) { // not required
		return nil
	}

	// value enum
	if err := m.validateNolingerEnum("nolinger", "body", m.Nolinger); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateOriginalto(formats strfmt.Registry) error {
	if swag.IsZero(m.Originalto) { // not required
		return nil
	}

	if m.Originalto != nil {
		if err := m.Originalto.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("originalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("originalto")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypePersistPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypePersistPropEnum = append(backendBaseTypePersistPropEnum, v)
	}
}

const (

	// BackendBasePersistEnabled captures enum value "enabled"
	BackendBasePersistEnabled string = "enabled"

	// BackendBasePersistDisabled captures enum value "disabled"
	BackendBasePersistDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validatePersistEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypePersistPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validatePersist(formats strfmt.Registry) error {
	if swag.IsZero(m.Persist) { // not required
		return nil
	}

	// value enum
	if err := m.validatePersistEnum("persist", "body", m.Persist); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validatePersistRule(formats strfmt.Registry) error {
	if swag.IsZero(m.PersistRule) { // not required
		return nil
	}

	if m.PersistRule != nil {
		if err := m.PersistRule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("persist_rule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("persist_rule")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validatePgsqlCheckParams(formats strfmt.Registry) error {
	if swag.IsZero(m.PgsqlCheckParams) { // not required
		return nil
	}

	if m.PgsqlCheckParams != nil {
		if err := m.PgsqlCheckParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pgsql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pgsql_check_params")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypePreferLastServerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypePreferLastServerPropEnum = append(backendBaseTypePreferLastServerPropEnum, v)
	}
}

const (

	// BackendBasePreferLastServerEnabled captures enum value "enabled"
	BackendBasePreferLastServerEnabled string = "enabled"

	// BackendBasePreferLastServerDisabled captures enum value "disabled"
	BackendBasePreferLastServerDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validatePreferLastServerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypePreferLastServerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validatePreferLastServer(formats strfmt.Registry) error {
	if swag.IsZero(m.PreferLastServer) { // not required
		return nil
	}

	// value enum
	if err := m.validatePreferLastServerEnum("prefer_last_server", "body", m.PreferLastServer); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateQueueTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.QueueTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("queue_timeout", "body", *m.QueueTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateRedispatch(formats strfmt.Registry) error {
	if swag.IsZero(m.Redispatch) { // not required
		return nil
	}

	if m.Redispatch != nil {
		if err := m.Redispatch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redispatch")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("redispatch")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateServerFinTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerFinTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("server_fin_timeout", "body", *m.ServerFinTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateServerTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("server_timeout", "body", *m.ServerTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateSmtpchkParams(formats strfmt.Registry) error {
	if swag.IsZero(m.SmtpchkParams) { // not required
		return nil
	}

	if m.SmtpchkParams != nil {
		if err := m.SmtpchkParams.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("smtpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("smtpchk_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

var backendBaseTypeSpliceAutoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeSpliceAutoPropEnum = append(backendBaseTypeSpliceAutoPropEnum, v)
	}
}

const (

	// BackendBaseSpliceAutoEnabled captures enum value "enabled"
	BackendBaseSpliceAutoEnabled string = "enabled"

	// BackendBaseSpliceAutoDisabled captures enum value "disabled"
	BackendBaseSpliceAutoDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateSpliceAutoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeSpliceAutoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateSpliceAuto(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceAuto) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceAutoEnum("splice_auto", "body", m.SpliceAuto); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeSpliceRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeSpliceRequestPropEnum = append(backendBaseTypeSpliceRequestPropEnum, v)
	}
}

const (

	// BackendBaseSpliceRequestEnabled captures enum value "enabled"
	BackendBaseSpliceRequestEnabled string = "enabled"

	// BackendBaseSpliceRequestDisabled captures enum value "disabled"
	BackendBaseSpliceRequestDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateSpliceRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeSpliceRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateSpliceRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceRequestEnum("splice_request", "body", m.SpliceRequest); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeSpliceResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeSpliceResponsePropEnum = append(backendBaseTypeSpliceResponsePropEnum, v)
	}
}

const (

	// BackendBaseSpliceResponseEnabled captures enum value "enabled"
	BackendBaseSpliceResponseEnabled string = "enabled"

	// BackendBaseSpliceResponseDisabled captures enum value "disabled"
	BackendBaseSpliceResponseDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateSpliceResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeSpliceResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateSpliceResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceResponseEnum("splice_response", "body", m.SpliceResponse); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeSpopCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeSpopCheckPropEnum = append(backendBaseTypeSpopCheckPropEnum, v)
	}
}

const (

	// BackendBaseSpopCheckEnabled captures enum value "enabled"
	BackendBaseSpopCheckEnabled string = "enabled"

	// BackendBaseSpopCheckDisabled captures enum value "disabled"
	BackendBaseSpopCheckDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateSpopCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeSpopCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateSpopCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.SpopCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpopCheckEnum("spop_check", "body", m.SpopCheck); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeSrvtcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeSrvtcpkaPropEnum = append(backendBaseTypeSrvtcpkaPropEnum, v)
	}
}

const (

	// BackendBaseSrvtcpkaEnabled captures enum value "enabled"
	BackendBaseSrvtcpkaEnabled string = "enabled"

	// BackendBaseSrvtcpkaDisabled captures enum value "disabled"
	BackendBaseSrvtcpkaDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateSrvtcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeSrvtcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateSrvtcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Srvtcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateSrvtcpkaEnum("srvtcpka", "body", m.Srvtcpka); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateStatsOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.StatsOptions) { // not required
		return nil
	}

	if m.StatsOptions != nil {
		if err := m.StatsOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats_options")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateStickTable(formats strfmt.Registry) error {
	if swag.IsZero(m.StickTable) { // not required
		return nil
	}

	if m.StickTable != nil {
		if err := m.StickTable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stick_table")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stick_table")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) validateTarpitTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.TarpitTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("tarpit_timeout", "body", *m.TarpitTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeTCPSmartConnectPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeTCPSmartConnectPropEnum = append(backendBaseTypeTCPSmartConnectPropEnum, v)
	}
}

const (

	// BackendBaseTCPSmartConnectEnabled captures enum value "enabled"
	BackendBaseTCPSmartConnectEnabled string = "enabled"

	// BackendBaseTCPSmartConnectDisabled captures enum value "disabled"
	BackendBaseTCPSmartConnectDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateTCPSmartConnectEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeTCPSmartConnectPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateTCPSmartConnect(formats strfmt.Registry) error {
	if swag.IsZero(m.TCPSmartConnect) { // not required
		return nil
	}

	// value enum
	if err := m.validateTCPSmartConnectEnum("tcp_smart_connect", "body", m.TCPSmartConnect); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeTcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeTcpkaPropEnum = append(backendBaseTypeTcpkaPropEnum, v)
	}
}

const (

	// BackendBaseTcpkaEnabled captures enum value "enabled"
	BackendBaseTcpkaEnabled string = "enabled"

	// BackendBaseTcpkaDisabled captures enum value "disabled"
	BackendBaseTcpkaDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateTcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeTcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateTcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Tcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateTcpkaEnum("tcpka", "body", m.Tcpka); err != nil {
		return err
	}

	return nil
}

var backendBaseTypeTransparentPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendBaseTypeTransparentPropEnum = append(backendBaseTypeTransparentPropEnum, v)
	}
}

const (

	// BackendBaseTransparentEnabled captures enum value "enabled"
	BackendBaseTransparentEnabled string = "enabled"

	// BackendBaseTransparentDisabled captures enum value "disabled"
	BackendBaseTransparentDisabled string = "disabled"
)

// prop value enum
func (m *BackendBase) validateTransparentEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendBaseTypeTransparentPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendBase) validateTransparent(formats strfmt.Registry) error {
	if swag.IsZero(m.Transparent) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransparentEnum("transparent", "body", m.Transparent); err != nil {
		return err
	}

	return nil
}

func (m *BackendBase) validateTunnelTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.TunnelTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("tunnel_timeout", "body", *m.TunnelTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this backend base based on the context it is used
func (m *BackendBase) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateErrorFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorFilesFromHTTPErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateForcePersistList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgnorePersistList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBalance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompression(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCookie(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDefaultServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmailAlert(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorloc302(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorloc303(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateForcePersist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateForwardfor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHashType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHttpchkParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgnorePersist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMysqlCheckParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOriginalto(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePersistRule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePgsqlCheckParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRedispatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSmtpchkParams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatsOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStickTable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BackendBase) contextValidateErrorFiles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFiles); i++ {

		if m.ErrorFiles[i] != nil {

			if swag.IsZero(m.ErrorFiles[i]) { // not required
				return nil
			}

			if err := m.ErrorFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) contextValidateErrorFilesFromHTTPErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFilesFromHTTPErrors); i++ {

		if m.ErrorFilesFromHTTPErrors[i] != nil {

			if swag.IsZero(m.ErrorFilesFromHTTPErrors[i]) { // not required
				return nil
			}

			if err := m.ErrorFilesFromHTTPErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) contextValidateForcePersistList(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ForcePersistList); i++ {

		if m.ForcePersistList[i] != nil {

			if swag.IsZero(m.ForcePersistList[i]) { // not required
				return nil
			}

			if err := m.ForcePersistList[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("force_persist_list" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("force_persist_list" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) contextValidateIgnorePersistList(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IgnorePersistList); i++ {

		if m.IgnorePersistList[i] != nil {

			if swag.IsZero(m.IgnorePersistList[i]) { // not required
				return nil
			}

			if err := m.IgnorePersistList[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ignore_persist_list" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ignore_persist_list" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BackendBase) contextValidateBalance(ctx context.Context, formats strfmt.Registry) error {

	if m.Balance != nil {

		if swag.IsZero(m.Balance) { // not required
			return nil
		}

		if err := m.Balance.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("balance")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("balance")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateCompression(ctx context.Context, formats strfmt.Registry) error {

	if m.Compression != nil {

		if swag.IsZero(m.Compression) { // not required
			return nil
		}

		if err := m.Compression.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compression")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("compression")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateCookie(ctx context.Context, formats strfmt.Registry) error {

	if m.Cookie != nil {

		if swag.IsZero(m.Cookie) { // not required
			return nil
		}

		if err := m.Cookie.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cookie")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cookie")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateDefaultServer(ctx context.Context, formats strfmt.Registry) error {

	if m.DefaultServer != nil {

		if swag.IsZero(m.DefaultServer) { // not required
			return nil
		}

		if err := m.DefaultServer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("default_server")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("default_server")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateEmailAlert(ctx context.Context, formats strfmt.Registry) error {

	if m.EmailAlert != nil {

		if swag.IsZero(m.EmailAlert) { // not required
			return nil
		}

		if err := m.EmailAlert.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("email_alert")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("email_alert")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateErrorloc302(ctx context.Context, formats strfmt.Registry) error {

	if m.Errorloc302 != nil {

		if swag.IsZero(m.Errorloc302) { // not required
			return nil
		}

		if err := m.Errorloc302.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc302")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc302")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateErrorloc303(ctx context.Context, formats strfmt.Registry) error {

	if m.Errorloc303 != nil {

		if swag.IsZero(m.Errorloc303) { // not required
			return nil
		}

		if err := m.Errorloc303.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc303")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc303")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateForcePersist(ctx context.Context, formats strfmt.Registry) error {

	if m.ForcePersist != nil {

		if swag.IsZero(m.ForcePersist) { // not required
			return nil
		}

		if err := m.ForcePersist.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("force_persist")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("force_persist")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateForwardfor(ctx context.Context, formats strfmt.Registry) error {

	if m.Forwardfor != nil {

		if swag.IsZero(m.Forwardfor) { // not required
			return nil
		}

		if err := m.Forwardfor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("forwardfor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("forwardfor")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateHashType(ctx context.Context, formats strfmt.Registry) error {

	if m.HashType != nil {

		if swag.IsZero(m.HashType) { // not required
			return nil
		}

		if err := m.HashType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hash_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hash_type")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateHttpchkParams(ctx context.Context, formats strfmt.Registry) error {

	if m.HttpchkParams != nil {

		if swag.IsZero(m.HttpchkParams) { // not required
			return nil
		}

		if err := m.HttpchkParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("httpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("httpchk_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateIgnorePersist(ctx context.Context, formats strfmt.Registry) error {

	if m.IgnorePersist != nil {

		if swag.IsZero(m.IgnorePersist) { // not required
			return nil
		}

		if err := m.IgnorePersist.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ignore_persist")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ignore_persist")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateMysqlCheckParams(ctx context.Context, formats strfmt.Registry) error {

	if m.MysqlCheckParams != nil {

		if swag.IsZero(m.MysqlCheckParams) { // not required
			return nil
		}

		if err := m.MysqlCheckParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mysql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mysql_check_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateOriginalto(ctx context.Context, formats strfmt.Registry) error {

	if m.Originalto != nil {

		if swag.IsZero(m.Originalto) { // not required
			return nil
		}

		if err := m.Originalto.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("originalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("originalto")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidatePersistRule(ctx context.Context, formats strfmt.Registry) error {

	if m.PersistRule != nil {

		if swag.IsZero(m.PersistRule) { // not required
			return nil
		}

		if err := m.PersistRule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("persist_rule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("persist_rule")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidatePgsqlCheckParams(ctx context.Context, formats strfmt.Registry) error {

	if m.PgsqlCheckParams != nil {

		if swag.IsZero(m.PgsqlCheckParams) { // not required
			return nil
		}

		if err := m.PgsqlCheckParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pgsql_check_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pgsql_check_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateRedispatch(ctx context.Context, formats strfmt.Registry) error {

	if m.Redispatch != nil {

		if swag.IsZero(m.Redispatch) { // not required
			return nil
		}

		if err := m.Redispatch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redispatch")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("redispatch")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateSmtpchkParams(ctx context.Context, formats strfmt.Registry) error {

	if m.SmtpchkParams != nil {

		if swag.IsZero(m.SmtpchkParams) { // not required
			return nil
		}

		if err := m.SmtpchkParams.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("smtpchk_params")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("smtpchk_params")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {

		if swag.IsZero(m.Source) { // not required
			return nil
		}

		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateStatsOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.StatsOptions != nil {

		if swag.IsZero(m.StatsOptions) { // not required
			return nil
		}

		if err := m.StatsOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats_options")
			}
			return err
		}
	}

	return nil
}

func (m *BackendBase) contextValidateStickTable(ctx context.Context, formats strfmt.Registry) error {

	if m.StickTable != nil {

		if swag.IsZero(m.StickTable) { // not required
			return nil
		}

		if err := m.StickTable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stick_table")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stick_table")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BackendBase) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackendBase) UnmarshalBinary(b []byte) error {
	var res BackendBase
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BackendForcePersist This field is deprecated in favor of force_persist_list, and will be removed in a future release
//
// swagger:model BackendForcePersist
type BackendForcePersist struct {
	// cond
	// Required: true
	// Enum: ["if","unless"]
	// +kubebuilder:validation:Enum="if","unless";
	Cond *string `json:"cond"`

	// cond test
	// Required: true
	CondTest *string `json:"cond_test"`
}

// Validate validates this backend force persist
func (m *BackendForcePersist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCondTest(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var backendForcePersistTypeCondPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["if","unless"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendForcePersistTypeCondPropEnum = append(backendForcePersistTypeCondPropEnum, v)
	}
}

const (

	// BackendForcePersistCondIf captures enum value "if"
	BackendForcePersistCondIf string = "if"

	// BackendForcePersistCondUnless captures enum value "unless"
	BackendForcePersistCondUnless string = "unless"
)

// prop value enum
func (m *BackendForcePersist) validateCondEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendForcePersistTypeCondPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendForcePersist) validateCond(formats strfmt.Registry) error {

	if err := validate.Required("force_persist"+"."+"cond", "body", m.Cond); err != nil {
		return err
	}

	// value enum
	if err := m.validateCondEnum("force_persist"+"."+"cond", "body", *m.Cond); err != nil {
		return err
	}

	return nil
}

func (m *BackendForcePersist) validateCondTest(formats strfmt.Registry) error {

	if err := validate.Required("force_persist"+"."+"cond_test", "body", m.CondTest); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this backend force persist based on context it is used
func (m *BackendForcePersist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BackendForcePersist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackendForcePersist) UnmarshalBinary(b []byte) error {
	var res BackendForcePersist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ForcePersist force persist
//
// swagger:model ForcePersist
type ForcePersist struct {
	// cond
	// Required: true
	// Enum: ["if","unless"]
	// +kubebuilder:validation:Enum="if","unless";
	Cond *string `json:"cond"`

	// cond test
	// Required: true
	CondTest *string `json:"cond_test"`
}

// Validate validates this force persist
func (m *ForcePersist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCondTest(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var forcePersistTypeCondPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["if","unless"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		forcePersistTypeCondPropEnum = append(forcePersistTypeCondPropEnum, v)
	}
}

const (

	// ForcePersistCondIf captures enum value "if"
	ForcePersistCondIf string = "if"

	// ForcePersistCondUnless captures enum value "unless"
	ForcePersistCondUnless string = "unless"
)

// prop value enum
func (m *ForcePersist) validateCondEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, forcePersistTypeCondPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ForcePersist) validateCond(formats strfmt.Registry) error {

	if err := validate.Required("cond", "body", m.Cond); err != nil {
		return err
	}

	// value enum
	if err := m.validateCondEnum("cond", "body", *m.Cond); err != nil {
		return err
	}

	return nil
}

func (m *ForcePersist) validateCondTest(formats strfmt.Registry) error {

	if err := validate.Required("cond_test", "body", m.CondTest); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this force persist based on context it is used
func (m *ForcePersist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ForcePersist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ForcePersist) UnmarshalBinary(b []byte) error {
	var res ForcePersist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BackendIgnorePersist This field is deprecated in favor of ignore_persist_list, and will be removed in a future release
//
// swagger:model BackendIgnorePersist
type BackendIgnorePersist struct {
	// cond
	// Required: true
	// Enum: ["if","unless"]
	// +kubebuilder:validation:Enum="if","unless";
	Cond *string `json:"cond"`

	// cond test
	// Required: true
	CondTest *string `json:"cond_test"`
}

// Validate validates this backend ignore persist
func (m *BackendIgnorePersist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCondTest(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var backendIgnorePersistTypeCondPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["if","unless"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backendIgnorePersistTypeCondPropEnum = append(backendIgnorePersistTypeCondPropEnum, v)
	}
}

const (

	// BackendIgnorePersistCondIf captures enum value "if"
	BackendIgnorePersistCondIf string = "if"

	// BackendIgnorePersistCondUnless captures enum value "unless"
	BackendIgnorePersistCondUnless string = "unless"
)

// prop value enum
func (m *BackendIgnorePersist) validateCondEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backendIgnorePersistTypeCondPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackendIgnorePersist) validateCond(formats strfmt.Registry) error {

	if err := validate.Required("ignore_persist"+"."+"cond", "body", m.Cond); err != nil {
		return err
	}

	// value enum
	if err := m.validateCondEnum("ignore_persist"+"."+"cond", "body", *m.Cond); err != nil {
		return err
	}

	return nil
}

func (m *BackendIgnorePersist) validateCondTest(formats strfmt.Registry) error {

	if err := validate.Required("ignore_persist"+"."+"cond_test", "body", m.CondTest); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this backend ignore persist based on context it is used
func (m *BackendIgnorePersist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BackendIgnorePersist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackendIgnorePersist) UnmarshalBinary(b []byte) error {
	var res BackendIgnorePersist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgnorePersist ignore persist
//
// swagger:model IgnorePersist
type IgnorePersist struct {
	// cond
	// Required: true
	// Enum: ["if","unless"]
	// +kubebuilder:validation:Enum="if","unless";
	Cond *string `json:"cond"`

	// cond test
	// Required: true
	CondTest *string `json:"cond_test"`
}

// Validate validates this ignore persist
func (m *IgnorePersist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCondTest(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ignorePersistTypeCondPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["if","unless"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ignorePersistTypeCondPropEnum = append(ignorePersistTypeCondPropEnum, v)
	}
}

const (

	// IgnorePersistCondIf captures enum value "if"
	IgnorePersistCondIf string = "if"

	// IgnorePersistCondUnless captures enum value "unless"
	IgnorePersistCondUnless string = "unless"
)

// prop value enum
func (m *IgnorePersist) validateCondEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ignorePersistTypeCondPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IgnorePersist) validateCond(formats strfmt.Registry) error {

	if err := validate.Required("cond", "body", m.Cond); err != nil {
		return err
	}

	// value enum
	if err := m.validateCondEnum("cond", "body", *m.Cond); err != nil {
		return err
	}

	return nil
}

func (m *IgnorePersist) validateCondTest(formats strfmt.Registry) error {

	if err := validate.Required("cond_test", "body", m.CondTest); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ignore persist based on context it is used
func (m *IgnorePersist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IgnorePersist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgnorePersist) UnmarshalBinary(b []byte) error {
	var res IgnorePersist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
