//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uifindsessionsearchresultdisplaystyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIFindSessionSearchResultDisplayStyle(pub NSInteger);
impl UIFindSessionSearchResultDisplayStyle {
    /// Displays the total number of reported results, and which result index is currently highlighted (i.e., "1 of 5").
    #[doc(alias = "UIFindSessionSearchResultDisplayStyleCurrentAndTotal")]
    pub const CurrentAndTotal: Self = Self(0);
    /// Displays only the total number of reported results (i.e., "5 results").
    #[doc(alias = "UIFindSessionSearchResultDisplayStyleTotal")]
    pub const Total: Self = Self(1);
    /// Do not display number of reported results.
    #[doc(alias = "UIFindSessionSearchResultDisplayStyleNone")]
    pub const None: Self = Self(2);
}

unsafe impl Encode for UIFindSessionSearchResultDisplayStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIFindSessionSearchResultDisplayStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextsearchmatchmethod?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextSearchMatchMethod(pub NSInteger);
impl UITextSearchMatchMethod {
    /// Word contains search string.
    #[doc(alias = "UITextSearchMatchMethodContains")]
    pub const Contains: Self = Self(0);
    /// Word contains the search string as a prefix.
    #[doc(alias = "UITextSearchMatchMethodStartsWith")]
    pub const StartsWith: Self = Self(1);
    /// Word is an exact match for the search string.
    #[doc(alias = "UITextSearchMatchMethodFullWord")]
    pub const FullWord: Self = Self(2);
}

unsafe impl Encode for UITextSearchMatchMethod {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextSearchMatchMethod {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextsearchoptions?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextSearchOptions;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextSearchOptions {}
);

impl UITextSearchOptions {
    extern_methods!(
        /// See UITextSearchMatchMethod above.
        #[unsafe(method(wordMatchMethod))]
        #[unsafe(method_family = none)]
        pub fn wordMatchMethod(&self) -> UITextSearchMatchMethod;

        /// Comparison options to use when searching for strings.
        #[unsafe(method(stringCompareOptions))]
        #[unsafe(method_family = none)]
        pub fn stringCompareOptions(&self) -> NSStringCompareOptions;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextSearchOptions {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// An abstract base class for managing a find session.
    ///
    /// A UIFindSession instance is returned by UIFindInteractionDelegate when a find session is initiated
    /// by the user. You can choose to implement a subclass of UIFindSession to handle all state, decoration,
    /// and behavior yourself. This would be the preferred choice if the view your find interaction is attached to
    /// is very custom in the way it handles the presentation of found results. Other clients are encouraged to
    /// instead use UISearchableObjectFindSession and the UITextSearching protocol, which manages the
    /// state of a find session automatically using behavior consistent with the rest of the system.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uifindsession?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIFindSession;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIFindSession {}
);

impl UIFindSession {
    extern_methods!(
        /// Returns the total number of results.
        /// You may call UIFindInteraction's
        /// `updateResultCount`to update the system find panel's UI if already visible.
        #[unsafe(method(resultCount))]
        #[unsafe(method_family = none)]
        pub fn resultCount(&self) -> NSInteger;

        /// Returns the index of the currently highlighted result, out of
        /// `resultCount.`If no result is currently highlighted, return NSNotFound.
        /// You may call UIFindInteraction's
        /// `updateResultCount`to update the system find panel's UI if already visible.
        #[unsafe(method(highlightedResultIndex))]
        #[unsafe(method_family = none)]
        pub fn highlightedResultIndex(&self) -> NSInteger;

        /// Defines how results are reported through the find panel's UI. The default style is
        /// `CurrentAndTotal.`
        #[unsafe(method(searchResultDisplayStyle))]
        #[unsafe(method_family = none)]
        pub fn searchResultDisplayStyle(&self) -> UIFindSessionSearchResultDisplayStyle;

        /// Setter for [`searchResultDisplayStyle`][Self::searchResultDisplayStyle].
        #[unsafe(method(setSearchResultDisplayStyle:))]
        #[unsafe(method_family = none)]
        pub fn setSearchResultDisplayStyle(
            &self,
            search_result_display_style: UIFindSessionSearchResultDisplayStyle,
        );

        /// Return YES if replacement is supported. This gates the appearance of replace UI in the find navigator panel. Default is NO.
        #[unsafe(method(supportsReplacement))]
        #[unsafe(method_family = none)]
        pub fn supportsReplacement(&self) -> bool;

        /// Return YES if replacement is allowed for the currently highlighted item. This property controls the enabled state
        /// of the "replace" button in the find navigator, as well as various hardware keyboard shortcuts involving replacement.
        /// Default is YES, if supportsReplacement is YES.
        #[unsafe(method(allowsReplacementForCurrentlyHighlightedResult))]
        #[unsafe(method_family = none)]
        pub fn allowsReplacementForCurrentlyHighlightedResult(&self) -> bool;

        /// Called when the user requests a search to be performed for
        /// `query,`using
        /// `options.`
        ///
        /// Parameter `query`: The search string entered into the search text field in the system find panel.
        ///
        /// Parameter `options`: Object representing all configured search options for this search.
        #[unsafe(method(performSearchWithQuery:options:))]
        #[unsafe(method_family = none)]
        pub fn performSearchWithQuery_options(
            &self,
            query: &NSString,
            options: Option<&UITextSearchOptions>,
        );

        /// Called when the user requests a single replacement to occur given
        /// `searchQuery`and
        /// `replacementString.`
        ///
        /// Parameter `searchQuery`: The search string entered into the search text field in the system find panel.
        ///
        /// Parameter `replacementString`: The replacement string entered into the replace text field in the system find panel.
        ///
        /// Parameter `options`: Object representing all configured search options for this replacement.
        #[unsafe(method(performSingleReplacementWithSearchQuery:replacementString:options:))]
        #[unsafe(method_family = none)]
        pub fn performSingleReplacementWithSearchQuery_replacementString_options(
            &self,
            search_query: &NSString,
            replacement_string: &NSString,
            options: Option<&UITextSearchOptions>,
        );

        /// Called when the user requests a document-wide replacement to occur.
        ///
        ///
        /// Parameter `searchQuery`: The search string entered into the search text field in the system find panel.
        ///
        /// Parameter `replacementString`: The replacement string entered into the replace text field in the system find panel.
        ///
        /// Parameter `options`: Object representing all configured search options for this replacement.
        #[unsafe(method(replaceAllInstancesOfSearchQuery:withReplacementString:options:))]
        #[unsafe(method_family = none)]
        pub fn replaceAllInstancesOfSearchQuery_withReplacementString_options(
            &self,
            search_query: &NSString,
            replacement_string: &NSString,
            options: Option<&UITextSearchOptions>,
        );

        #[cfg(feature = "UITextInput")]
        /// Called when either the next or previous button is activated, or when return or shift+return is pressed in the search field.
        ///
        ///
        /// Parameter `direction`: Which direction the user intends to move, either forward or backward.
        #[unsafe(method(highlightNextResultInDirection:))]
        #[unsafe(method_family = none)]
        pub fn highlightNextResultInDirection(&self, direction: UITextStorageDirection);

        /// This method will be called whenever the current find session's found/highlighted results are to be invalidated. For instance,
        /// when the search query is cleared, options changed, or any other event where we may not perform another search right away.
        #[unsafe(method(invalidateFoundResults))]
        #[unsafe(method_family = none)]
        pub fn invalidateFoundResults(&self);

        #[deprecated]
        #[unsafe(method(allowsReplacement))]
        #[unsafe(method_family = none)]
        pub fn allowsReplacement(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIFindSession {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A
    /// `UIFindSession`implementation for clients who adopt the
    /// `UITextSearching`protocol.
    ///
    /// `UITextSearchingFindSession`is a concrete implementation of
    /// `UIFindSession`which manages
    /// all of the state associated with a find session (i.e., the way results are presented to the user, the
    /// order in which they are cycled through, etc.). A
    /// `UITextSearchingFindSession`would be ideal
    /// for clients who already implement the
    /// `UITextInput`protocol, since many of the concepts defined there are
    /// compatible with this class.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextsearchingfindsession?language=objc)
    #[unsafe(super(UIFindSession, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextSearchingFindSession;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextSearchingFindSession {}
);

impl UITextSearchingFindSession {
    extern_methods!(
        #[cfg(feature = "UITextSearching")]
        /// The object responsible for actually performing the search operation and decorating found text results.
        /// See `UITextSearching.h` for more information.
        #[unsafe(method(searchableObject))]
        #[unsafe(method_family = none)]
        pub fn searchableObject(&self) -> Option<Retained<ProtocolObject<dyn UITextSearching>>>;

        #[cfg(feature = "UITextSearching")]
        #[unsafe(method(initWithSearchableObject:))]
        #[unsafe(method_family = init)]
        pub fn initWithSearchableObject(
            this: Allocated<Self>,
            searchable_object: &ProtocolObject<dyn UITextSearching>,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
