/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.AttrData;
import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.RuntimeConstants;
import fpc.tools.javapp.TypeSignature;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class FieldData
implements RuntimeConstants {
    ClassData cls;
    int access;
    int name_index;
    int descriptor_index;
    int attributes_count;
    int value_cpx = 0;
    boolean isSynthetic = false;
    boolean isDeprecated = false;
    Vector attrs;

    public FieldData(ClassData cls) {
        this.cls = cls;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_index = in.readUnsignedShort();
        this.descriptor_index = in.readUnsignedShort();
        int attributes_count = in.readUnsignedShort();
        this.attrs = new Vector(attributes_count);
        int i = 0;
        while (i < attributes_count) {
            int attr_name_index = in.readUnsignedShort();
            if (this.cls.getTag(attr_name_index) == 1) {
                AttrData attr;
                String attr_name = this.cls.getString(attr_name_index);
                if (attr_name.equals("ConstantValue")) {
                    if (in.readInt() != 2) {
                        throw new ClassFormatError("invalid ConstantValue attr length");
                    }
                    this.value_cpx = in.readUnsignedShort();
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index);
                    this.attrs.addElement(attr);
                } else if (attr_name.equals("Synthetic")) {
                    if (in.readInt() != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isSynthetic = true;
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index);
                    this.attrs.addElement(attr);
                } else if (attr_name.equals("Deprecated")) {
                    if (in.readInt() != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isDeprecated = true;
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index);
                    this.attrs.addElement(attr);
                } else {
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index, in);
                    this.attrs.addElement(attr);
                }
            }
            ++i;
        }
    }

    public String[] getAccess() {
        Vector<String> v = new Vector<String>();
        if ((this.access & 1) != 0) {
            v.addElement("public");
        }
        if ((this.access & 2) != 0) {
            v.addElement("private");
        }
        if ((this.access & 4) != 0) {
            v.addElement("protected");
        }
        if ((this.access & 8) != 0) {
            v.addElement("static");
        }
        if ((this.access & 0x10) != 0) {
            v.addElement("final");
        }
        if ((this.access & 0x40) != 0) {
            v.addElement("volatile");
        }
        if ((this.access & 0x80) != 0) {
            v.addElement("transient");
        }
        Object[] accflags = new String[v.size()];
        v.copyInto(accflags);
        return accflags;
    }

    public String getName() {
        return this.cls.getStringValue(this.name_index);
    }

    public String getInternalSig() {
        return this.cls.getStringValue(this.descriptor_index);
    }

    public String getType() {
        return new TypeSignature(this.getInternalSig()).getFieldType();
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public int getConstantValueIndex() {
        return this.value_cpx;
    }

    public Vector getAttributes() {
        return this.attrs;
    }
}

