/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.JavapPrinter;
import fpc.tools.javapp.MethodData;
import fpc.tools.javapp.StackMapData;
import java.io.DataInputStream;
import java.io.IOException;

class StackMapTableData {
    final int frameType;
    int offsetDelta;

    StackMapTableData(int frameType) {
        this.frameType = frameType;
    }

    void print(JavapPrinter p) {
        p.out.print("   frame_type = " + this.frameType);
    }

    static StackMapTableData getInstance(DataInputStream in, MethodData method) throws IOException {
        int frameType = in.readUnsignedByte();
        if (frameType < 64) {
            return new SameFrame(frameType, frameType);
        }
        if (64 <= frameType && frameType < 128) {
            return new SameLocals1StackItem(frameType, frameType - 64, StackMapData.readTypeArray(in, 1, method));
        }
        if (frameType == 247) {
            return new SameLocals1StackItem(frameType, in.readUnsignedShort(), StackMapData.readTypeArray(in, 1, method));
        }
        if (247 < frameType && frameType < 251) {
            return new ChopFrame(frameType, in.readUnsignedShort());
        }
        if (frameType == 251) {
            return new SameFrame(frameType, in.readUnsignedShort());
        }
        if (251 < frameType && frameType < 255) {
            return new AppendFrame(frameType, in.readUnsignedShort(), StackMapData.readTypeArray(in, frameType - 251, method));
        }
        if (frameType == 255) {
            int offsetDelta = in.readUnsignedShort();
            int locals_size = in.readUnsignedShort();
            int[] locals = StackMapData.readTypeArray(in, locals_size, method);
            int stack_size = in.readUnsignedShort();
            int[] stack = StackMapData.readTypeArray(in, stack_size, method);
            return new FullFrame(offsetDelta, locals, stack);
        }
        throw new ClassFormatError("unrecognized frame_type in StackMapTable");
    }

    static class AppendFrame
    extends StackMapTableData {
        final int[] locals;

        AppendFrame(int frameType, int offsetDelta, int[] locals) {
            super(frameType);
            this.offsetDelta = offsetDelta;
            this.locals = locals;
        }

        void print(JavapPrinter p) {
            super.print(p);
            p.out.println(" /* append */");
            p.out.println("     offset_delta = " + this.offsetDelta);
            p.printMap("     locals = [", this.locals);
        }
    }

    static class ChopFrame
    extends StackMapTableData {
        ChopFrame(int frameType, int offsetDelta) {
            super(frameType);
            this.offsetDelta = offsetDelta;
        }

        void print(JavapPrinter p) {
            super.print(p);
            p.out.println(" /* chop */");
            p.out.println("     offset_delta = " + this.offsetDelta);
        }
    }

    static class FullFrame
    extends StackMapTableData {
        final int[] locals;
        final int[] stack;

        FullFrame(int offsetDelta, int[] locals, int[] stack) {
            super(255);
            this.offsetDelta = offsetDelta;
            this.locals = locals;
            this.stack = stack;
        }

        void print(JavapPrinter p) {
            super.print(p);
            p.out.println(" /* full_frame */");
            p.out.println("     offset_delta = " + this.offsetDelta);
            p.printMap("     locals = [", this.locals);
            p.printMap("     stack = [", this.stack);
        }
    }

    static class SameFrame
    extends StackMapTableData {
        SameFrame(int frameType, int offsetDelta) {
            super(frameType);
            this.offsetDelta = offsetDelta;
        }

        void print(JavapPrinter p) {
            super.print(p);
            if (this.frameType < 64) {
                p.out.println(" /* same */");
            } else {
                p.out.println(" /* same_frame_extended */");
                p.out.println("     offset_delta = " + this.offsetDelta);
            }
        }
    }

    static class SameLocals1StackItem
    extends StackMapTableData {
        final int[] stack;

        SameLocals1StackItem(int frameType, int offsetDelta, int[] stack) {
            super(frameType);
            this.offsetDelta = offsetDelta;
            this.stack = stack;
        }

        void print(JavapPrinter p) {
            super.print(p);
            if (this.frameType == 247) {
                p.out.println(" /* same_locals_1_stack_item_frame_extended */");
                p.out.println("     offset_delta = " + this.offsetDelta);
            } else {
                p.out.println(" /* same_locals_1_stack_item */");
            }
            p.printMap("     stack = [", this.stack);
        }
    }
}

