//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file G4MonopoleFieldMessenger.hh
/// \brief Definition of the G4MonopoleFieldMessenger class

// =======================================================================
// Created:  15 Jun 2010, B. Bozsogi
// =======================================================================

#ifndef G4MonopoleFieldMessenger_h
#define G4MonopoleFieldMessenger_h

#include "G4UImessenger.hh"
#include "globals.hh"

class G4MonopoleFieldSetup;
class G4UIdirectory;
class G4UIcmdWithADoubleAndUnit;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class G4MonopoleFieldMessenger : public G4UImessenger
{
  public:
    G4MonopoleFieldMessenger(G4MonopoleFieldSetup*);
    ~G4MonopoleFieldMessenger();

    virtual void SetNewValue(G4UIcommand*, G4String);

  private:
    G4MonopoleFieldSetup* fField;

    G4UIdirectory* fFieldDir;
    G4UIcmdWithADoubleAndUnit* fSetFieldCmd;
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif
