/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.ModuleName;
import org.javamodularity.moduleplugin.extensions.DefaultModularityExtension;
import org.javamodularity.moduleplugin.extensions.ModularityExtension;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.extensions.PatchModuleExtension;
import org.javamodularity.moduleplugin.tasks.CompileModuleInfoTask;
import org.javamodularity.moduleplugin.tasks.CompileTask;
import org.javamodularity.moduleplugin.tasks.CompileTestTask;
import org.javamodularity.moduleplugin.tasks.JavadocTask;
import org.javamodularity.moduleplugin.tasks.MergeClassesTask;
import org.javamodularity.moduleplugin.tasks.ModularCreateStartScripts;
import org.javamodularity.moduleplugin.tasks.ModularJavaExec;
import org.javamodularity.moduleplugin.tasks.RunTask;
import org.javamodularity.moduleplugin.tasks.TestTask;

public class ModuleSystemPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(ModuleSystemPlugin.class);

    public void apply(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.1")) < 0) {
            LOGGER.warn("WARNING: You use {}. The minimum version supported (with some limitations) by this plugin is 5.1. It is strongly recommended to use at least Gradle 5.6.", (Object)GradleVersion.current());
        }
        project.getPlugins().apply(JavaPlugin.class);
        new ModuleName().findModuleName(project).ifPresent(moduleName -> this.configureModularity(project, (String)moduleName));
    }

    private void configureModularity(Project project, String moduleName) {
        ExtensionContainer extensions = project.getExtensions();
        extensions.add("moduleName", (Object)moduleName);
        extensions.create("patchModules", PatchModuleExtension.class, new Object[0]);
        extensions.create(ModularityExtension.class, "modularity", DefaultModularityExtension.class, new Object[]{project});
        new CompileTask(project).configureCompileJava();
        new CompileModuleInfoTask(project).configureCompileModuleInfoJava();
        new MergeClassesTask(project).configureMergeClasses();
        new CompileTestTask(project).configureCompileTestJava();
        new TestTask(project).configureTestJava();
        new RunTask(project).configureRun();
        new JavadocTask(project).configureJavaDoc();
        ModularJavaExec.configure(project);
        ModularCreateStartScripts.configure(project);
        PatchModuleContainer.configure(project);
    }
}

