/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.MethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.Parameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.CastExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ReturnStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Navigator;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.SymbolDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.FunctionalInterfaceLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.InferenceContext;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.Value;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedLambdaConstraintType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Pair;

public class LambdaExprContext
extends AbstractJavaParserContext<LambdaExpr> {
    public LambdaExprContext(LambdaExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name) {
        int index = -1;
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            ++index;
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator(parameter, this.typeSolver);
            for (ResolvedValueDeclaration decl : sb.getSymbolDeclarations()) {
                ReturnStmt returnStmt;
                Optional optDeclaration;
                if (!decl.getName().equals(name)) continue;
                Node parentNode = Navigator.demandParentNode(this.wrappedNode, Expression.IS_NOT_ENCLOSED_EXPR);
                if (parentNode instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)parentNode;
                    MethodUsage methodUsage = JavaParserFacade.get(this.typeSolver).solveMethodAsUsage(methodCallExpr);
                    int i = methodCallExpr.getArgumentPosition((Expression)this.wrappedNode, Expression.EXCLUDE_ENCLOSED_EXPR);
                    ResolvedType lambdaType = methodUsage.getParamTypes().get(i);
                    Optional<MethodUsage> functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod(lambdaType);
                    if (functionalMethodOpt.isPresent()) {
                        int lambdaParamIndex;
                        MethodUsage functionalMethod = functionalMethodOpt.get();
                        InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                        lambdaType.asReferenceType().getTypeDeclaration().ifPresent(typeDeclaration -> inferenceContext.addPair(lambdaType, new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)typeDeclaration)));
                        boolean found = false;
                        for (lambdaParamIndex = 0; lambdaParamIndex < ((LambdaExpr)this.wrappedNode).getParameters().size(); ++lambdaParamIndex) {
                            if (!((LambdaExpr)this.wrappedNode).getParameter(lambdaParamIndex).getName().getIdentifier().equals(name)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            return Optional.empty();
                        }
                        ResolvedType argType = inferenceContext.resolve(inferenceContext.addSingle(functionalMethod.getParamType(lambdaParamIndex)));
                        ResolvedLambdaConstraintType conType = argType.isWildcard() ? ResolvedLambdaConstraintType.bound(argType.asWildcard().getBoundedType()) : ResolvedLambdaConstraintType.bound(argType);
                        Value value = new Value(conType, name);
                        return Optional.of(value);
                    }
                    return Optional.empty();
                }
                if (parentNode instanceof VariableDeclarator) {
                    VariableDeclarator variableDeclarator = (VariableDeclarator)parentNode;
                    ResolvedType t = JavaParserFacade.get(this.typeSolver).convertToUsage(variableDeclarator.getType());
                    Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(t);
                    if (functionalMethod.isPresent()) {
                        ResolvedType lambdaType = functionalMethod.get().getParamType(index);
                        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
                        if (lambdaType.isReferenceType()) {
                            for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        Value value = new Value(lambdaType, name);
                        return Optional.of(value);
                    }
                    throw new UnsupportedOperationException("functional method is not present in variable declarator");
                }
                if (parentNode instanceof ReturnStmt && (optDeclaration = (returnStmt = (ReturnStmt)parentNode).findAncestor(MethodDeclaration.class)).isPresent()) {
                    ResolvedType t = JavaParserFacade.get(this.typeSolver).convertToUsage(((MethodDeclaration)optDeclaration.get()).asMethodDeclaration().getType());
                    Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(t);
                    if (functionalMethod.isPresent()) {
                        ResolvedType lambdaType = functionalMethod.get().getParamType(index);
                        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
                        if (lambdaType.isReferenceType()) {
                            for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        Value value = new Value(lambdaType, name);
                        return Optional.of(value);
                    }
                    throw new UnsupportedOperationException("functional method is not present in return statement");
                }
                if (parentNode instanceof CastExpr) {
                    CastExpr castExpr = (CastExpr)parentNode;
                    ResolvedType t = JavaParserFacade.get(this.typeSolver).convertToUsage(castExpr.getType());
                    Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(t);
                    if (functionalMethod.isPresent()) {
                        ResolvedType lambdaType = functionalMethod.get().getParamType(index);
                        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
                        if (lambdaType.isReferenceType()) {
                            for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        Value value = new Value(lambdaType, name);
                        return Optional.of(value);
                    }
                    throw new UnsupportedOperationException("functional method is not present in cast expression");
                }
                throw new UnsupportedOperationException("Unknown node type: " + parentNode.getClass().getSimpleName());
            }
        }
        return this.solveSymbolAsValueInParentContext(name);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator(parameter, this.typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = LambdaExprContext.solveWith(sb, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return this.solveSymbolInParentContext(name);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return this.solveMethodInParentContext(name, argumentsTypes, false);
    }

    @Override
    public List<Parameter> parametersExposedToChild(Node child) {
        if (child == ((LambdaExpr)this.wrappedNode).getBody()) {
            return ((LambdaExpr)this.wrappedNode).getParameters();
        }
        return Collections.emptyList();
    }

    @Override
    protected final Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            throw new UnsupportedOperationException("Symbol with name " + name + " already exists in symbol declarator");
        }
        return Optional.empty();
    }
}

