/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.CalendarView;
import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.skins.CalendarPickerSkin;
import java.time.LocalDate;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.LocalDateStringConverter;
import org.apache.commons.lang3.StringUtils;

public class CalendarPicker
extends CustomComboBox<LocalDate> {
    private final TextField editor = new TextField();
    private CalendarView calendarView;
    private final ObjectProperty<StringConverter<LocalDate>> converter = new SimpleObjectProperty((Object)this, "value", (Object)new LocalDateStringConverter());
    private final ObjectProperty<Callback<LocalDate, Boolean>> dateFilter = new SimpleObjectProperty((Object)this, "dateFilter");

    public CalendarPicker() {
        this.getStyleClass().setAll((Object[])new String[]{"calendar-picker", "text-input"});
        this.setEditable(true);
        this.setOnTouchPressed(evt -> this.commitValueAndShow());
        this.calendarView = this.getCalendarView();
        this.calendarView.setShowToday(true);
        this.calendarView.setShowTodayButton(true);
        this.calendarView.dateFilterProperty().bind(this.dateFilterProperty());
        this.setFocusTraversable(false);
        this.valueProperty().addListener(it -> this.updateTextAndHidePopup());
        this.editor.promptTextProperty().bindBidirectional((Property)this.promptTextProperty());
        this.editor.editableProperty().bind((ObservableValue)this.editableProperty());
        this.editor.setOnAction(evt -> this.commitValue());
        this.editor.focusedProperty().addListener(it -> {
            if (!this.editor.isFocused()) {
                this.commitValue();
            }
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), this.editor.isFocused());
        });
        this.editor.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().equals((Object)KeyCode.UP)) {
                this.setValue(this.getValue() != null ? ((LocalDate)this.getValue()).minusDays(1L) : LocalDate.now());
                this.placeCaretAtEnd();
            } else if (evt.getCode().equals((Object)KeyCode.DOWN)) {
                this.setValue(this.getValue() != null ? ((LocalDate)this.getValue()).plusDays(1L) : LocalDate.now());
                this.placeCaretAtEnd();
            } else if (evt.getCode().equals((Object)KeyCode.LEFT) && !this.isEditable()) {
                this.setValue(this.getValue() != null ? ((LocalDate)this.getValue()).minusDays(1L) : LocalDate.now());
                this.placeCaretAtEnd();
            } else if (evt.getCode().equals((Object)KeyCode.RIGHT) && !this.isEditable()) {
                this.setValue(this.getValue() != null ? ((LocalDate)this.getValue()).plusDays(1L) : LocalDate.now());
                this.placeCaretAtEnd();
            }
        });
        this.converterProperty().addListener((obs, oldConverter, newConverter) -> {
            if (newConverter == null) {
                this.setConverter((StringConverter<LocalDate>)oldConverter);
            }
        });
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.updateTextAndHidePopup();
    }

    private void placeCaretAtEnd() {
        Platform.runLater(() -> this.getEditor().positionCaret(this.getEditor().textProperty().getValueSafe().length()));
    }

    private void commitValueAndShow() {
        this.commitValue();
        this.show();
    }

    protected Skin<?> createDefaultSkin() {
        return new CalendarPickerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(CalendarPicker.class.getResource("calendar-picker.css")).toExternalForm();
    }

    public CalendarView getCalendarView() {
        if (this.calendarView == null) {
            this.calendarView = new CalendarView();
        }
        return this.calendarView;
    }

    private void commitValue() {
        StringConverter<LocalDate> converter;
        String text = this.editor.getText();
        if (StringUtils.isNotBlank((CharSequence)text) && (converter = this.getConverter()) != null) {
            LocalDate value = (LocalDate)converter.fromString(text);
            this.setValue(value);
        }
    }

    private void updateTextAndHidePopup() {
        LocalDate value = (LocalDate)this.getValue();
        if (value != null && this.getConverter() != null) {
            this.editor.setText(this.getConverter().toString((Object)value));
        } else {
            this.editor.setText("");
        }
        this.editor.positionCaret(this.editor.getText().length());
        CalendarPickerSkin skin = (CalendarPickerSkin)this.getSkin();
        if (skin != null) {
            skin.hide();
        }
    }

    public final TextField getEditor() {
        return this.editor;
    }

    public final StringConverter<LocalDate> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final ObjectProperty<StringConverter<LocalDate>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<LocalDate> converter) {
        this.converter.set(converter);
    }

    public final Callback<LocalDate, Boolean> getDateFilter() {
        return (Callback)this.dateFilter.get();
    }

    public final ObjectProperty<Callback<LocalDate, Boolean>> dateFilterProperty() {
        return this.dateFilter;
    }

    public final void setDateFilter(Callback<LocalDate, Boolean> dateFilter) {
        this.dateFilter.set(dateFilter);
    }
}

