/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator.columnbrowser;

import com.dlsc.gemsfx.incubator.columnbrowser.ColumnBrowserSkin;
import com.dlsc.gemsfx.incubator.columnbrowser.ColumnValuesList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;

public class ColumnBrowser<S>
extends Control {
    private final InvalidationListener filterListener = evt -> this.filter();
    private ObservableList<S> items = FXCollections.observableArrayList();
    private ReadOnlyListWrapper<S> filteredItems = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ObjectProperty<TableView<S>> tableView = new SimpleObjectProperty((Object)this, "tableView");
    private final ObservableList<ColumnValuesList<S, ?>> columnValuesLists = FXCollections.observableArrayList();

    public ColumnBrowser() {
        this.getStylesheets().add((Object)Objects.requireNonNull(ColumnBrowser.class.getResource("column-browser-view.css")).toExternalForm());
        this.tableView.addListener(evt -> this.getTableView().setItems(this.getFilteredItems()));
        this.getColumnValuesLists().addListener(c -> {
            while (c.next()) {
                for (ColumnValuesList list : c.getAddedSubList()) {
                    list.getListView().getSelectionModel().selectedIndexProperty().addListener(this.filterListener);
                }
                for (ColumnValuesList list : c.getRemoved()) {
                    list.getListView().getSelectionModel().selectedIndexProperty().removeListener(this.filterListener);
                }
            }
        });
        this.filter();
        this.items.addListener(evt -> this.filter());
    }

    public ColumnBrowser(TableView<S> tableView) {
        this();
        this.setTableView(tableView);
    }

    protected Skin<?> createDefaultSkin() {
        return new ColumnBrowserSkin(this);
    }

    public final ObservableList<S> getItems() {
        return this.items;
    }

    public final ReadOnlyListProperty<S> getFilteredItems() {
        return this.filteredItems.getReadOnlyProperty();
    }

    public final ObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableView;
    }

    public final TableView<S> getTableView() {
        return (TableView)this.tableView.get();
    }

    public final void setTableView(TableView<S> table) {
        this.tableView.set(table);
    }

    public final ObservableList<ColumnValuesList<S, ?>> getColumnValuesLists() {
        return this.columnValuesLists;
    }

    private void filter() {
        Predicate<S> predicate = this.createPredicate();
        if (predicate == null) {
            this.filteredItems.setAll(this.items);
        } else {
            this.filteredItems.setAll((Collection)this.items.filtered(predicate));
        }
    }

    private Predicate<S> createPredicate() {
        Predicate predicate = null;
        for (ColumnValuesList list : this.getColumnValuesLists()) {
            if (predicate == null) {
                predicate = list.getPredicate();
                continue;
            }
            predicate = predicate.and(list.getPredicate());
        }
        return predicate;
    }

    ColumnValuesList<S, ?> getParentValuesList(ColumnValuesList<S, ?> list) {
        int index = this.columnValuesLists.indexOf(list);
        if (index > 0) {
            return (ColumnValuesList)((Object)this.columnValuesLists.get(index - 1));
        }
        return null;
    }
}

