/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CalendarView;
import com.dlsc.gemsfx.Spacer;
import com.dlsc.gemsfx.YearMonthView;
import com.dlsc.gemsfx.YearView;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.WeekFields;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import javafx.util.Callback;

public class CalendarViewSkin
extends SkinBase<CalendarView> {
    private static final String WEEKDAY_NAME = "weekday-name";
    private static final String TODAY = "today";
    private static final String PREVIOUS_MONTH = "previous-month";
    private static final String NEXT_MONTH = "next-month";
    private static final String WEEKEND_DAY = "weekend-day";
    private static final String SELECTED = "selected";
    private static final String RANGE_START_DATE = "range-start";
    private static final String RANGE_END_DATE = "range-end";
    private static final String RANGE_DATE = "range-date";
    private static final String DROPDOWN = "dropdown";
    private final Label monthLabel;
    private final Label yearLabel;
    private final GridPane bodyGridPane;
    private final GridPane weekdayGridPane;
    private final VBox container;
    private final YearMonthView yearMonthView;
    private final YearView yearView;
    private final Map<String, CalendarView.DateCell> cellsMap = new HashMap<String, CalendarView.DateCell>();
    private final Label[] dayOfWeekLabels = new Label[7];
    private final Label[] weekNumberLabels = new Label[6];
    private final InvalidationListener updateViewListener = it -> this.updateView();
    private final WeakInvalidationListener weakUpdateViewListener = new WeakInvalidationListener(this.updateViewListener);
    private final ObjectProperty<ViewMode> viewMode = new SimpleObjectProperty((Object)this, "viewMode", (Object)ViewMode.DATE);
    private YearMonth displayedYearMonth;
    private final ChangeListener<Boolean> windowShowingListener = (obs, oldShowing, newShowing) -> {
        if (!newShowing.booleanValue()) {
            this.viewMode.set((Object)ViewMode.DATE);
        }
    };
    private final WeakChangeListener weakWindowShowingListener = new WeakChangeListener(this.windowShowingListener);
    private final ChangeListener<YearMonth> yearMonthChangeListener = (obs, oldV, newV) -> {
        ((CalendarView)this.getSkinnable()).setYearMonth((YearMonth)newV);
        this.viewMode.set((Object)ViewMode.DATE);
    };
    private final ChangeListener<Year> yearChangeListener = (obs, oldV, newV) -> {
        YearMonth yearMonth = Optional.ofNullable(((CalendarView)this.getSkinnable()).getYearMonth()).orElse(YearMonth.now());
        ((CalendarView)this.getSkinnable()).setYearMonth(newV.atMonth(yearMonth.getMonth()));
        this.viewMode.set((Object)ViewMode.DATE);
    };

    public CalendarViewSkin(CalendarView view) {
        super((Control)view);
        Scene scene = view.getScene();
        Window window = scene.getWindow();
        window.showingProperty().addListener((ChangeListener)this.weakWindowShowingListener);
        this.bodyGridPane = new GridPane();
        this.bodyGridPane.setAlignment(Pos.CENTER);
        this.bodyGridPane.getStyleClass().addAll((Object[])new String[]{"grid-pane", "body-grid-pane"});
        this.weekdayGridPane = new GridPane();
        this.weekdayGridPane.setAlignment(Pos.CENTER);
        this.weekdayGridPane.getStyleClass().addAll((Object[])new String[]{"grid-pane", "weekday-grid-pane"});
        this.monthLabel = new Label();
        this.monthLabel.getStyleClass().addAll((Object[])new String[]{"date-label", "month-label"});
        this.monthLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.monthLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> view.getYearMonth() != null ? view.getYearMonth().getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()) : "", (Observable[])new Observable[]{view.yearMonthProperty()}));
        this.monthLabel.visibleProperty().bind((ObservableValue)view.showMonthProperty());
        this.monthLabel.managedProperty().bind((ObservableValue)view.showMonthProperty());
        this.monthLabel.setOnMouseClicked(evt -> {
            if (view.isMonthSelectionViewEnabled()) {
                this.viewMode.set((Object)ViewMode.MONTH);
            }
        });
        this.yearLabel = new Label();
        this.yearLabel.getStyleClass().addAll((Object[])new String[]{"date-label", "year-label"});
        this.yearLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> view.getYearMonth() != null ? Integer.toString(view.getYearMonth().getYear()) : "", (Observable[])new Observable[]{view.yearMonthProperty()}));
        this.yearLabel.visibleProperty().bind((ObservableValue)view.showYearProperty());
        this.yearLabel.managedProperty().bind((ObservableValue)view.showYearProperty());
        this.yearLabel.setOnMouseClicked(evt -> {
            if (view.isYearSelectionViewEnabled()) {
                this.viewMode.set((Object)ViewMode.YEAR);
            }
        });
        StackPane incrementYearArrow = new StackPane();
        incrementYearArrow.getStyleClass().add((Object)"arrow");
        StackPane incrementYearButton = new StackPane(new Node[]{incrementYearArrow});
        incrementYearButton.getStyleClass().add((Object)"increment-year-button");
        incrementYearButton.setOnMouseClicked(evt -> view.setYearMonth(view.getYearMonth().plusYears(1L)));
        incrementYearButton.disableProperty().bind((ObservableValue)view.disableNextYearButtonProperty());
        StackPane decrementYearArrow = new StackPane();
        decrementYearArrow.getStyleClass().add((Object)"arrow");
        StackPane decrementYearButton = new StackPane(new Node[]{decrementYearArrow});
        decrementYearButton.getStyleClass().add((Object)"decrement-year-button");
        decrementYearButton.setOnMouseClicked(evt -> view.setYearMonth(view.getYearMonth().minusYears(1L)));
        decrementYearButton.disableProperty().bind((ObservableValue)view.disablePreviousYearButtonProperty());
        VBox yearSpinnerBox = new VBox(new Node[]{incrementYearButton, decrementYearButton});
        yearSpinnerBox.getStyleClass().add((Object)"year-spinner");
        yearSpinnerBox.setMaxWidth(Double.NEGATIVE_INFINITY);
        yearSpinnerBox.visibleProperty().bind((ObservableValue)view.showYearProperty().and((ObservableBooleanValue)view.yearDisplayModeProperty().isEqualTo((Object)CalendarView.YearDisplayMode.TEXT_AND_SPINNER)));
        yearSpinnerBox.managedProperty().bind((ObservableValue)yearSpinnerBox.visibleProperty());
        HBox header = new HBox();
        header.getStyleClass().add((Object)"header");
        StackPane previousMonthArrow = new StackPane();
        previousMonthArrow.getStyleClass().add((Object)"arrow");
        StackPane previousArrowButton = new StackPane(new Node[]{previousMonthArrow});
        previousArrowButton.getStyleClass().addAll((Object[])new String[]{"arrow-button", "previous-month-button"});
        previousArrowButton.setOnMouseClicked(evt -> view.setYearMonth(view.getYearMonth().minusMonths(1L)));
        previousArrowButton.visibleProperty().bind((ObservableValue)view.showMonthArrowsProperty().and((ObservableBooleanValue)view.showMonthProperty()));
        previousArrowButton.managedProperty().bind((ObservableValue)previousArrowButton.visibleProperty());
        previousArrowButton.disableProperty().bind((ObservableValue)view.disablePreviousMonthButtonProperty());
        StackPane nextMonthArrow = new StackPane();
        nextMonthArrow.getStyleClass().add((Object)"arrow");
        StackPane nextMonthArrowButton = new StackPane(new Node[]{nextMonthArrow});
        nextMonthArrowButton.getStyleClass().addAll((Object[])new String[]{"arrow-button", "next-month-button"});
        nextMonthArrowButton.setOnMouseClicked(evt -> view.setYearMonth(view.getYearMonth().plusMonths(1L)));
        nextMonthArrowButton.visibleProperty().bind((ObservableValue)view.showMonthArrowsProperty().and((ObservableBooleanValue)view.showMonthProperty()));
        nextMonthArrowButton.managedProperty().bind((ObservableValue)nextMonthArrowButton.visibleProperty());
        nextMonthArrowButton.disableProperty().bind((ObservableValue)view.disableNextMonthButtonProperty());
        StackPane monthDropdownArrow = new StackPane();
        monthDropdownArrow.getStyleClass().add((Object)"arrow");
        StackPane monthDropdownArrowButton = new StackPane(new Node[]{monthDropdownArrow});
        monthDropdownArrowButton.getStyleClass().addAll((Object[])new String[]{"dropdown-button", "month-dropdown-button"});
        monthDropdownArrowButton.visibleProperty().bind((ObservableValue)view.monthSelectionViewEnabledProperty().and((ObservableBooleanValue)view.monthDisplayModeProperty().isEqualTo((Object)CalendarView.MonthDisplayMode.TEXT_AND_DROPDOWN)).and((ObservableBooleanValue)view.showMonthProperty()));
        monthDropdownArrowButton.managedProperty().bind((ObservableValue)monthDropdownArrowButton.visibleProperty());
        monthDropdownArrowButton.disableProperty().bind((ObservableValue)view.disableMonthDropdownButtonProperty());
        this.monthLabel.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (view.isMonthSelectionViewEnabled() && view.getMonthDisplayMode() == CalendarView.MonthDisplayMode.TEXT_AND_DROPDOWN) {
                return monthDropdownArrowButton;
            }
            return null;
        }, (Observable[])new Observable[]{view.monthDisplayModeProperty(), view.monthSelectionViewEnabledProperty()}));
        StackPane yearDropdownArrow = new StackPane();
        yearDropdownArrow.getStyleClass().add((Object)"arrow");
        StackPane yearDropdownArrowButton = new StackPane(new Node[]{yearDropdownArrow});
        yearDropdownArrowButton.getStyleClass().addAll((Object[])new String[]{"dropdown-button", "year-dropdown-button"});
        yearDropdownArrowButton.visibleProperty().bind((ObservableValue)view.yearSelectionViewEnabledProperty().and((ObservableBooleanValue)view.yearDisplayModeProperty().isEqualTo((Object)CalendarView.YearDisplayMode.TEXT_AND_DROPDOWN)).and((ObservableBooleanValue)view.showYearProperty()));
        yearDropdownArrowButton.managedProperty().bind((ObservableValue)yearDropdownArrowButton.visibleProperty());
        yearDropdownArrowButton.disableProperty().bind((ObservableValue)view.disableYearDropdownButtonProperty());
        this.yearLabel.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (view.isYearSelectionViewEnabled() && view.getYearDisplayMode() == CalendarView.YearDisplayMode.TEXT_AND_DROPDOWN) {
                return yearDropdownArrowButton;
            }
            return null;
        }, (Observable[])new Observable[]{view.yearDisplayModeProperty(), view.yearSelectionViewEnabledProperty()}));
        Spacer leftSpacer = new Spacer();
        leftSpacer.getStyleClass().add((Object)"left");
        Spacer rightSpacer = new Spacer();
        rightSpacer.getStyleClass().add((Object)"right");
        this.updateHeader(header, previousArrowButton, leftSpacer, yearSpinnerBox, rightSpacer, nextMonthArrowButton);
        view.headerLayoutProperty().addListener(it -> this.updateHeader(header, previousArrowButton, leftSpacer, yearSpinnerBox, rightSpacer, nextMonthArrowButton));
        InvalidationListener updateViewListener = evt -> this.updateView();
        view.yearMonthProperty().addListener(evt -> {
            if (this.displayedYearMonth == null || !this.displayedYearMonth.equals(view.getYearMonth())) {
                this.updateView();
            }
        });
        InvalidationListener buildViewListener = evt -> this.buildView();
        view.showWeekNumbersProperty().addListener(buildViewListener);
        view.showMonthArrowsProperty().addListener(buildViewListener);
        view.cellFactoryProperty().addListener(buildViewListener);
        view.markSelectedDaysOfPreviousOrNextMonthProperty().addListener(buildViewListener);
        view.showTodayProperty().addListener(updateViewListener);
        Button todayButton = new Button();
        todayButton.textProperty().bind((ObservableValue)view.todayTextProperty());
        todayButton.getStyleClass().add((Object)"today-button");
        todayButton.setOnAction(evt -> view.setYearMonth(YearMonth.from(view.getToday())));
        todayButton.setMaxWidth(Double.MAX_VALUE);
        StackPane footer = new StackPane(new Node[]{todayButton});
        footer.visibleProperty().bind((ObservableValue)view.showTodayButtonProperty());
        footer.managedProperty().bind((ObservableValue)view.showTodayButtonProperty());
        footer.getStyleClass().add((Object)"footer");
        this.container = new VBox(new Node[]{header, this.weekdayGridPane, this.bodyGridPane, footer});
        this.container.getStyleClass().add((Object)"container");
        this.yearMonthView = view.getYearMonthView();
        this.yearMonthView.getStyleClass().add((Object)"inner-year-month-view");
        this.yearMonthView.setShowYear(false);
        this.yearMonthView.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            if (!evt.isConsumed()) {
                this.viewMode.set((Object)ViewMode.DATE);
            }
        });
        this.yearMonthView.addEventHandler(TouchEvent.TOUCH_PRESSED, evt -> {
            if (!evt.isConsumed()) {
                this.viewMode.set((Object)ViewMode.DATE);
            }
        });
        this.yearMonthView.earliestMonthProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> view.getEarliestDate() != null ? YearMonth.from(view.getEarliestDate()) : null, (Observable[])new Observable[]{view.earliestDateProperty()}));
        this.yearMonthView.latestMonthProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> view.getLatestDate() != null ? YearMonth.from(view.getLatestDate()) : null, (Observable[])new Observable[]{view.latestDateProperty()}));
        view.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().equals((Object)KeyCode.ESCAPE) && !evt.isConsumed() && !((ViewMode)((Object)((Object)this.viewMode.get()))).equals((Object)ViewMode.DATE)) {
                this.viewMode.set((Object)ViewMode.DATE);
                evt.consume();
            }
        });
        this.yearView = view.getYearView();
        this.yearView.earliestYearProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> view.getEarliestDate() != null ? Year.from(view.getEarliestDate()) : null, (Observable[])new Observable[]{view.earliestDateProperty()}));
        this.yearView.latestYearProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> view.getLatestDate() != null ? Year.from(view.getLatestDate()) : null, (Observable[])new Observable[]{view.latestDateProperty()}));
        this.yearView.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            if (!evt.isConsumed()) {
                this.viewMode.set((Object)ViewMode.DATE);
            }
        });
        this.yearView.addEventHandler(TouchEvent.TOUCH_PRESSED, evt -> {
            if (!evt.isConsumed()) {
                this.viewMode.set((Object)ViewMode.DATE);
            }
        });
        this.buildView();
        view.showWeekNumbersProperty().addListener(it -> this.updateBodyConstraints());
        this.updateBodyConstraints();
        header.setViewOrder(-2000.0);
        this.weekdayGridPane.setViewOrder(-1000.0);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.container.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.container.heightProperty());
        this.container.setClip((Node)clip);
        view.selectionModelProperty().addListener(it -> this.bindSelectionModel(view.getSelectionModel()));
        this.bindSelectionModel(view.getSelectionModel());
        StackPane stackPane = new StackPane(new Node[]{this.yearView, this.yearMonthView, this.container});
        stackPane.getStyleClass().add((Object)"stack-pane");
        this.getChildren().setAll((Object[])new Node[]{stackPane});
        this.updateView();
        this.viewMode.addListener(obs -> this.updateViewMode());
        this.updateViewMode();
        InvalidationListener updateStyleClassesListener = it -> this.updateStyleClasses();
        view.monthSelectionViewEnabledProperty().addListener(updateStyleClassesListener);
        view.yearSelectionViewEnabledProperty().addListener(updateStyleClassesListener);
        this.updateStyleClasses();
    }

    private void updateHeader(HBox header, StackPane previousArrowButton, Spacer leftSpacer, VBox yearSpinnerBox, Spacer rightSpacer, StackPane nextMonthArrowButton) {
        switch (((CalendarView)this.getSkinnable()).getHeaderLayout()) {
            case CENTER: {
                header.getChildren().setAll((Object[])new Node[]{previousArrowButton, leftSpacer, this.monthLabel, this.yearLabel, yearSpinnerBox, rightSpacer, nextMonthArrowButton});
                break;
            }
            case LEFT: {
                header.getChildren().setAll((Object[])new Node[]{this.monthLabel, this.yearLabel, yearSpinnerBox, rightSpacer, previousArrowButton, nextMonthArrowButton});
                break;
            }
            case RIGHT: {
                header.getChildren().setAll((Object[])new Node[]{previousArrowButton, nextMonthArrowButton, leftSpacer, this.monthLabel, this.yearLabel});
            }
        }
    }

    private void updateStyleClasses() {
        CalendarView view = (CalendarView)this.getSkinnable();
        if (view.isMonthSelectionViewEnabled()) {
            if (!this.monthLabel.getStyleClass().contains((Object)DROPDOWN)) {
                this.monthLabel.getStyleClass().add((Object)DROPDOWN);
            }
        } else {
            this.monthLabel.getStyleClass().remove((Object)DROPDOWN);
        }
        if (view.isYearSelectionViewEnabled()) {
            if (!this.yearLabel.getStyleClass().contains((Object)DROPDOWN)) {
                this.yearLabel.getStyleClass().add((Object)DROPDOWN);
            }
        } else {
            this.yearLabel.getStyleClass().remove((Object)DROPDOWN);
        }
    }

    private void bindSelectionModel(CalendarView.SelectionModel model) {
        model.selectionModeProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        model.selectedDateProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        model.selectedEndDateProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        model.selectedDatesProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
    }

    private void updateBodyConstraints() {
        int numberOfColumns;
        this.bodyGridPane.getRowConstraints().clear();
        this.bodyGridPane.getColumnConstraints().clear();
        this.weekdayGridPane.getRowConstraints().clear();
        this.weekdayGridPane.getColumnConstraints().clear();
        this.weekdayGridPane.getRowConstraints().add((Object)this.createRowConstraints(-1));
        for (int row = 0; row < 6; ++row) {
            this.bodyGridPane.getRowConstraints().add((Object)this.createRowConstraints(row));
        }
        int n = numberOfColumns = ((CalendarView)this.getSkinnable()).isShowWeekNumbers() ? 8 : 7;
        if (((CalendarView)this.getSkinnable()).isShowWeekNumbers()) {
            this.bodyGridPane.getColumnConstraints().add((Object)this.createColumnConstraints(numberOfColumns, -1));
            this.weekdayGridPane.getColumnConstraints().add((Object)this.createColumnConstraints(numberOfColumns, -1));
        }
        for (int col = 0; col < 7; ++col) {
            this.bodyGridPane.getColumnConstraints().add((Object)this.createColumnConstraints(numberOfColumns, col));
            this.weekdayGridPane.getColumnConstraints().add((Object)this.createColumnConstraints(numberOfColumns, col));
        }
    }

    protected ColumnConstraints createColumnConstraints(int numberOfColumns, int columnIndex) {
        ColumnConstraints column = new ColumnConstraints();
        column.setHalignment(HPos.CENTER);
        if (columnIndex == -1) {
            column.setPrefWidth(((CalendarView)this.getSkinnable()).getWeekNumberColumnWidth());
        } else {
            column.setPercentWidth(100.0 / (double)numberOfColumns);
        }
        column.setFillWidth(true);
        return column;
    }

    protected RowConstraints createRowConstraints(int row) {
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setFillHeight(true);
        rowConstraints.setMinHeight(Double.NEGATIVE_INFINITY);
        rowConstraints.setMaxHeight(Double.NEGATIVE_INFINITY);
        rowConstraints.setPrefHeight(-1.0);
        return rowConstraints;
    }

    private void buildView() {
        this.bodyGridPane.getChildren().clear();
        this.weekdayGridPane.getChildren().clear();
        CalendarView view = (CalendarView)this.getSkinnable();
        boolean showWeekNumbers = view.isShowWeekNumbers();
        if (showWeekNumbers) {
            Label label = new Label();
            label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            label.getStyleClass().addAll((Object[])new String[]{"corner", WEEKDAY_NAME});
            this.weekdayGridPane.add((Node)label, 0, 0);
        }
        DayOfWeek dayOfWeek = this.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            this.dayOfWeekLabels[i] = new Label(dayOfWeek.getDisplayName(TextStyle.NARROW, Locale.getDefault()));
            this.dayOfWeekLabels[i].setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.dayOfWeekLabels[i].setAlignment(Pos.CENTER);
            this.dayOfWeekLabels[i].getStyleClass().add((Object)WEEKDAY_NAME);
            this.weekdayGridPane.add((Node)this.dayOfWeekLabels[i], showWeekNumbers ? i + 1 : i, 0);
            dayOfWeek = dayOfWeek.plus(1L);
        }
        LocalDate date = this.getStartDate();
        int numberOfRows = 6;
        if (showWeekNumbers) {
            for (int row = 0; row < numberOfRows; ++row) {
                this.weekNumberLabels[row] = new Label();
                this.weekNumberLabels[row].setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                this.weekNumberLabels[row].setAlignment(Pos.CENTER);
                this.weekNumberLabels[row].getStyleClass().add((Object)"week-number-label");
                this.bodyGridPane.add((Node)this.weekNumberLabels[row], 0, row);
                date = date.plusWeeks(1L);
            }
        }
        Callback<CalendarView, CalendarView.DateCell> cellFactory = view.getCellFactory();
        LocalDate finalDate = date;
        for (int row = 0; row < numberOfRows; ++row) {
            for (int col = 0; col < 7; ++col) {
                CalendarView.DateCell cell = (CalendarView.DateCell)((Object)cellFactory.call((Object)view));
                GridPane.setHgrow((Node)cell, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)cell, (Priority)Priority.ALWAYS);
                this.cellsMap.put(this.getKey(row, col), cell);
                cell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> view.isShowDaysOfPreviousOrNextMonth() || cell.getDate() != null && YearMonth.from(cell.getDate()).equals(view.getYearMonth()), (Observable[])new Observable[]{cell.itemProperty(), view.showDaysOfPreviousOrNextMonthProperty()}));
                cell.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    LocalDate cellDate = (LocalDate)cell.getItem();
                    if (cellDate != null) {
                        LocalDate earliestDate = view.getEarliestDate();
                        if (earliestDate != null && cellDate.isBefore(earliestDate)) {
                            return true;
                        }
                        LocalDate latestDate = view.getLatestDate();
                        if (latestDate != null && cellDate.isAfter(latestDate)) {
                            return true;
                        }
                        Callback<LocalDate, Boolean> dateFilter = view.getDateFilter();
                        return dateFilter != null && (Boolean)dateFilter.call((Object)cellDate) == false;
                    }
                    return false;
                }, (Observable[])new Observable[]{view.earliestDateProperty(), view.latestDateProperty(), view.dateFilterProperty(), cell.itemProperty()}));
                this.bodyGridPane.add((Node)cell, showWeekNumbers ? col + 1 : col, row);
                this.installSelectionSupport(cell);
                date = date.plusDays(1L);
            }
        }
        this.updateView();
    }

    private void installSelectionSupport(CalendarView.DateCell cell) {
        cell.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            CalendarView.SelectionModel selectionModel = ((CalendarView)this.getSkinnable()).getSelectionModel();
            switch (selectionModel.getSelectionMode()) {
                case SINGLE_DATE: {
                    selectionModel.select(cell.getDate());
                    break;
                }
                case MULTIPLE_DATES: {
                    if (selectionModel.isSelected(cell.getDate())) {
                        selectionModel.clearSelection(cell.getDate());
                        break;
                    }
                    selectionModel.select(cell.getDate());
                    break;
                }
                case DATE_RANGE: {
                    if (selectionModel.getSelectedDate() != null && selectionModel.getSelectedEndDate() != null) {
                        selectionModel.clearSelection();
                    }
                    if (selectionModel.getSelectedDate() == null) {
                        selectionModel.select(cell.getDate());
                        break;
                    }
                    if (cell.getDate().isBefore(selectionModel.getSelectedDate())) {
                        LocalDate endDate = selectionModel.getSelectedDate();
                        selectionModel.clearAndSelect(cell.getDate());
                        selectionModel.setSelectedEndDate(endDate);
                        break;
                    }
                    selectionModel.setSelectedEndDate(cell.getDate());
                }
            }
        });
    }

    private String getKey(int row, int col) {
        return row + "/" + col;
    }

    private void updateViewMode() {
        this.yearMonthView.valueProperty().removeListener(this.yearMonthChangeListener);
        this.yearView.valueProperty().removeListener(this.yearChangeListener);
        this.container.setVisible(false);
        this.yearMonthView.setVisible(false);
        this.yearView.setVisible(false);
        if (this.viewMode.get() == ViewMode.DATE) {
            this.container.toFront();
            this.container.setVisible(true);
        } else if (this.viewMode.get() == ViewMode.MONTH) {
            this.yearMonthView.toFront();
            this.yearMonthView.setVisible(true);
            this.yearMonthView.setValue(((CalendarView)this.getSkinnable()).getYearMonth());
            this.yearMonthView.valueProperty().addListener(this.yearMonthChangeListener);
        } else if (this.viewMode.get() == ViewMode.YEAR) {
            this.yearView.toFront();
            this.yearView.setVisible(true);
            YearMonth yearMonth = Optional.ofNullable(((CalendarView)this.getSkinnable()).getYearMonth()).orElse(YearMonth.now());
            this.yearView.setValue(Year.of(yearMonth.getYear()));
            this.yearView.valueProperty().addListener(this.yearChangeListener);
        }
    }

    private void updateView() {
        YearMonth yearMonth;
        CalendarView view = (CalendarView)this.getSkinnable();
        this.displayedYearMonth = yearMonth = view.getYearMonth();
        LocalDate date = this.getStartDate();
        if (view.isShowWeekNumbers()) {
            for (int i = 0; i < 6; ++i) {
                int weekOfYear = date.get(this.getWeekFields().weekOfYear());
                this.weekNumberLabels[i].setText(Integer.toString(weekOfYear));
                date = date.plusWeeks(1L);
            }
        }
        date = this.getStartDate();
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                YearMonth cellYearMonth;
                LocalDate localDate = LocalDate.from(date);
                CalendarView.DateCell cell = this.cellsMap.get(this.getKey(row, col));
                cell.updateItem(localDate, false);
                cell.getStyleClass().removeAll((Object[])new String[]{TODAY, PREVIOUS_MONTH, NEXT_MONTH, WEEKEND_DAY, SELECTED, RANGE_START_DATE, RANGE_END_DATE, RANGE_DATE});
                if (view.isShowToday() && date.equals(view.getToday())) {
                    cell.getStyleClass().add((Object)TODAY);
                }
                if ((cellYearMonth = YearMonth.from(date)).isBefore(yearMonth)) {
                    cell.getStyleClass().add((Object)PREVIOUS_MONTH);
                } else if (cellYearMonth.isAfter(yearMonth)) {
                    cell.getStyleClass().add((Object)NEXT_MONTH);
                }
                if (view.getWeekendDays().contains((Object)date.getDayOfWeek())) {
                    cell.getStyleClass().add((Object)WEEKEND_DAY);
                }
                if (view.getSelectionModel().isSelected(localDate)) {
                    if (cellYearMonth.equals(yearMonth) || view.isMarkSelectedDaysOfPreviousOrNextMonth()) {
                        cell.getStyleClass().add((Object)SELECTED);
                    }
                    if (Objects.equals((Object)view.getSelectionModel().getSelectionMode(), (Object)CalendarView.SelectionModel.SelectionMode.DATE_RANGE)) {
                        if (Objects.equals(view.getSelectionModel().getSelectedDate(), localDate)) {
                            cell.getStyleClass().add((Object)RANGE_START_DATE);
                        } else if (Objects.equals(view.getSelectionModel().getSelectedEndDate(), localDate)) {
                            cell.getStyleClass().add((Object)RANGE_END_DATE);
                        } else {
                            cell.getStyleClass().add((Object)RANGE_DATE);
                        }
                    }
                }
                date = date.plusDays(1L);
            }
        }
    }

    private DayOfWeek getFirstDayOfWeek() {
        return this.getWeekFields().getFirstDayOfWeek();
    }

    private WeekFields getWeekFields() {
        return WeekFields.of(Locale.getDefault());
    }

    private LocalDate getStartDate() {
        YearMonth yearMonth = ((CalendarView)this.getSkinnable()).getYearMonth();
        return this.adjustToFirstDayOfWeek(LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1), this.getFirstDayOfWeek());
    }

    private LocalDate adjustToFirstDayOfWeek(LocalDate date, DayOfWeek firstDayOfWeek) {
        LocalDate newDate = date.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue());
        if (newDate.isAfter(date)) {
            newDate = newDate.minusWeeks(1L);
        }
        return newDate;
    }

    private static enum ViewMode {
        DATE,
        MONTH,
        YEAR;

    }
}

