/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.tokens;

import java.util.EnumMap;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.ComputedStyle;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.MathCharacter;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathCharacterInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public abstract class Token {
    protected final FrozenSlice slice;
    protected final TokenType type;
    protected final LaTeXMode latexMode;
    protected final EnumMap<InterpretationType, Interpretation> interpretationMap;
    protected ComputedStyle computedStyle;

    protected Token(FrozenSlice slice, TokenType type, LaTeXMode latexMode, Interpretation ... interpretations) {
        this.slice = slice;
        this.type = type;
        this.latexMode = latexMode;
        this.interpretationMap = SnugglePackage.makeInterpretationMap(interpretations);
    }

    protected Token(FrozenSlice slice, TokenType type, LaTeXMode latexMode, EnumMap<InterpretationType, Interpretation> interpretationMap) {
        this.slice = slice;
        this.type = type;
        this.latexMode = latexMode;
        this.interpretationMap = interpretationMap;
    }

    @ObjectDumperOptions(value=DumpMode.TO_STRING)
    public FrozenSlice getSlice() {
        return this.slice;
    }

    public TokenType getType() {
        return this.type;
    }

    public LaTeXMode getLatexMode() {
        return this.latexMode;
    }

    @ObjectDumperOptions(value=DumpMode.TO_STRING)
    public EnumMap<InterpretationType, Interpretation> getInterpretationMap() {
        return this.interpretationMap;
    }

    public Interpretation getInterpretation(InterpretationType type) {
        return this.interpretationMap != null ? this.interpretationMap.get((Object)type) : null;
    }

    public ComputedStyle getComputedStyle() {
        return this.computedStyle;
    }

    public void setComputedStyle(ComputedStyle computedStyle) {
        this.computedStyle = computedStyle;
    }

    public boolean hasInterpretationType(InterpretationType ... types) {
        if (this.interpretationMap == null) {
            return false;
        }
        for (InterpretationType testType : types) {
            if (!this.interpretationMap.containsKey((Object)testType)) continue;
            return true;
        }
        return false;
    }

    public boolean isCommand(BuiltinCommand command) {
        return this instanceof CommandToken && ((CommandToken)this).getCommand() == command;
    }

    public boolean isEnvironment(BuiltinEnvironment environment) {
        return this instanceof EnvironmentToken && ((EnvironmentToken)this).getEnvironment() == environment;
    }

    public MathCharacter getMathCharacter() {
        if (this.interpretationMap == null) {
            return null;
        }
        MathCharacterInterpretation mcInterpretation = (MathCharacterInterpretation)this.interpretationMap.get((Object)InterpretationType.MATH_CHARACTER);
        return mcInterpretation != null ? mcInterpretation.getMathCharacter() : null;
    }

    public int getMathCharacterCodePoint() {
        MathCharacter character = this.getMathCharacter();
        return character != null ? character.getCodePoint() : -1;
    }

    public String toString() {
        return ObjectUtilities.beanToString(this);
    }
}

