/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.gradle.internal.classpath.Instrumented;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.TextResult;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.util.FileUtils;

public final class AsyncProfiler
implements ExternalProfiler,
InternalProfiler {
    private final JavaApi instance;
    private final boolean verbose;
    private final Direction direction;
    private final String profilerConfig;
    private final List<OutputType> output;
    private final String outputFilePrefix;
    private final File outDir;
    private File trialOutDir;
    private final int traces;
    private final int flat;
    private boolean isVersion1x;
    private boolean warmupStarted;
    private boolean measurementStarted;
    private int measurementIterationCount;
    private final LinkedHashSet<File> generated = new LinkedHashSet();

    public AsyncProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new ProfilerOptionFormatter("async"));
        ArgumentAcceptingOptionSpec optOutput = parser.accepts("output", "Output format(s). Supported: " + EnumSet.allOf(OutputType.class) + ".").withRequiredArg().ofType(OutputType.class).withValuesSeparatedBy(",").describedAs("format+").defaultsTo((Object)OutputType.text, (Object[])new OutputType[0]);
        ArgumentAcceptingOptionSpec optDirection = parser.accepts("direction", "Direction(s) of flame graph. Supported: " + EnumSet.allOf(Direction.class) + ".").withRequiredArg().ofType(Direction.class).describedAs("direction").defaultsTo((Object)Direction.both, (Object[])new Direction[0]);
        ArgumentAcceptingOptionSpec optLibPath = parser.accepts("libPath", "Location of asyncProfiler library. If not specified, System.loadLibrary will be used and the library must be made available to the forked JVM in an entry of -Djava.library.path, LD_LIBRARY_PATH (Linux), or DYLD_LIBRARY_PATH (Mac OS).").withRequiredArg().ofType(String.class).describedAs("path");
        ArgumentAcceptingOptionSpec optEvent = parser.accepts("event", "Event to sample: cpu, alloc, lock, wall, itimer; com.foo.Bar.methodName; any event from `perf list` e.g. cache-misses").withRequiredArg().ofType(String.class).describedAs("event").defaultsTo((Object)"cpu", (Object[])new String[0]);
        String secondaryEventOk = "May be captured as a secondary event under output=jfr.";
        ArgumentAcceptingOptionSpec optAlloc = parser.accepts("alloc", "Enable allocation profiling. Optional argument (e.g. =512k) reduces sampling from the default of one-sample-per-TLAB. " + secondaryEventOk).withOptionalArg().ofType(String.class).describedAs("sample bytes");
        ArgumentAcceptingOptionSpec optLock = parser.accepts("lock", "Enable lock profiling. Optional argument (e.g. =1ms) limits capture based on lock duration. " + secondaryEventOk).withOptionalArg().ofType(String.class).describedAs("duration");
        ArgumentAcceptingOptionSpec optDir = parser.accepts("dir", "Output directory.").withRequiredArg().ofType(String.class).describedAs("dir");
        ArgumentAcceptingOptionSpec optInterval = parser.accepts("interval", "Profiling interval.").withRequiredArg().ofType(Long.class).describedAs("ns");
        ArgumentAcceptingOptionSpec optJstackDepth = parser.accepts("jstackdepth", "Maximum Java stack depth.").withRequiredArg().ofType(Integer.class).describedAs("frames");
        ArgumentAcceptingOptionSpec optFrameBuf = parser.accepts("framebuf", "Size of profiler framebuffer.").withRequiredArg().ofType(Long.class).describedAs("bytes");
        ArgumentAcceptingOptionSpec optFilter = parser.accepts("filter", "Enable thread filtering during collection. Useful for wall clock profiling, but only if the workload registers the relevant threads programatically via `AsyncProfiler.JavaApi.getInstance().filterThread(thread, enabled)`.").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]).describedAs("boolean");
        ArgumentAcceptingOptionSpec optThreads = parser.accepts("threads", "Profile threads separately.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec optSimple = parser.accepts("simple", "Simple class names instead of FQN.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec optSig = parser.accepts("sig", "Print method signatures.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec optAnn = parser.accepts("ann", "Annotate Java method names.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec optInclude = parser.accepts("include", "Output only stack traces containing the specified pattern.").withRequiredArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("regexp+");
        ArgumentAcceptingOptionSpec optExclude = parser.accepts("exclude", "Exclude stack traces with the specified pattern.").withRequiredArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("regexp+");
        ArgumentAcceptingOptionSpec optRawCommand = parser.accepts("rawCommand", "Command to pass directly to async-profiler. Use to access new features of JMH profiler that are not yet supported in this option parser.").withRequiredArg().ofType(String.class).describedAs("command");
        ArgumentAcceptingOptionSpec optTitle = parser.accepts("title", "SVG title.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec optWidth = parser.accepts("width", "SVG width.").withRequiredArg().ofType(Long.class).describedAs("pixels");
        ArgumentAcceptingOptionSpec optMinWidth = parser.accepts("minwidth", "Skip frames smaller than px").withRequiredArg().ofType(Long.class).describedAs("pixels");
        ArgumentAcceptingOptionSpec optAllKernel = parser.accepts("allkernel", "Only include kernel-mode events.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec optAllUser = parser.accepts("alluser", "Only include user-mode events.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec optCStack = parser.accepts("cstack", "How to traverse C stack: Supported: " + EnumSet.allOf(CStackMode.class) + ".").withRequiredArg().ofType(CStackMode.class).describedAs("mode");
        ArgumentAcceptingOptionSpec optVerbose = parser.accepts("verbose", "Output the sequence of commands.").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]).describedAs("bool");
        ArgumentAcceptingOptionSpec optTraces = parser.accepts("traces", "Number of top traces to include in the default output.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)200, (Object[])new Integer[0]).describedAs("int");
        ArgumentAcceptingOptionSpec optFlat = parser.accepts("flat", "Number of top flat profiles to include in the default output.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)200, (Object[])new Integer[0]).describedAs("int");
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            ProfilerOptionsBuilder builder = new ProfilerOptionsBuilder(set);
            this.outDir = !set.has((OptionSpec)optDir) ? new File(Instrumented.systemProperty((String)"user.dir", (String)"org.openjdk.jmh.profile.AsyncProfiler")) : new File((String)set.valueOf((OptionSpec)optDir));
            builder.appendIfExists(optInterval);
            builder.appendIfExists(optJstackDepth);
            builder.appendIfTrue((OptionSpec<Boolean>)optThreads);
            builder.appendIfTrue((OptionSpec<Boolean>)optSimple);
            builder.appendIfTrue((OptionSpec<Boolean>)optSig);
            builder.appendIfTrue((OptionSpec<Boolean>)optAnn);
            builder.appendIfExists(optFrameBuf);
            if (((Boolean)optFilter.value(set)).booleanValue()) {
                builder.appendRaw("filter");
            }
            builder.appendMulti(optInclude);
            builder.appendMulti(optExclude);
            builder.appendIfExists(optTitle);
            builder.appendIfExists(optWidth);
            builder.appendIfExists(optMinWidth);
            builder.appendIfTrue((OptionSpec<Boolean>)optAllKernel);
            builder.appendIfTrue((OptionSpec<Boolean>)optAllUser);
            builder.appendIfExists(optCStack);
            if (set.has((OptionSpec)optRawCommand)) {
                builder.appendRaw((String)optRawCommand.value(set));
            }
            this.traces = (Integer)optTraces.value(set);
            this.flat = (Integer)optFlat.value(set);
            try {
                this.instance = set.has((OptionSpec)optLibPath) ? JavaApi.getInstance((String)optLibPath.value(set)) : JavaApi.getInstance();
            }
            catch (UnsatisfiedLinkError e) {
                throw new ProfilerException("Unable to load async-profiler. Ensure asyncProfiler library is on LD_LIBRARY_PATH (Linux), DYLD_LIBRARY_PATH (Mac OS), or -Djava.library.path. Alternatively, point to explicit library location with -prof async:libPath=<path>.", e);
            }
            this.verbose = (Boolean)optVerbose.value(set);
            try {
                String version = this.instance.execute("version");
                if (this.verbose) {
                    System.out.println("[async-profiler] version=" + version);
                }
                this.isVersion1x = version.startsWith("1.");
            }
            catch (IOException e) {
                throw new ProfilerException(e);
            }
            this.direction = (Direction)((Object)optDirection.value(set));
            this.output = optOutput.values(set);
            HashSet<String> secondaryEvents = new HashSet<String>();
            if (set.has((OptionSpec)optAlloc)) {
                secondaryEvents.add("alloc");
                builder.append(optAlloc);
            }
            if (set.has((OptionSpec)optLock)) {
                secondaryEvents.add("lock");
                builder.append(optLock);
            }
            if (set.has((OptionSpec)optEvent)) {
                String evName = (String)set.valueOf((OptionSpec)optEvent);
                if (evName.contains(",")) {
                    throw new ProfilerException("Event name should not contain commas: " + evName);
                }
                this.outputFilePrefix = evName;
                builder.append(optEvent);
            } else if (secondaryEvents.isEmpty()) {
                builder.appendRaw("event=cpu");
                this.outputFilePrefix = "cpu";
            } else if (secondaryEvents.size() == 1) {
                this.outputFilePrefix = (String)secondaryEvents.iterator().next();
                secondaryEvents.clear();
            } else {
                this.outputFilePrefix = "profile";
            }
            if (!secondaryEvents.isEmpty()) {
                if (this.isVersion1x) {
                    throw new ProfilerException("Secondary event capture not supported on async-profiler 1.x");
                }
                if (this.output.size() > 1 || this.output.get(0) != OutputType.jfr) {
                    throw new ProfilerException("Secondary event capture is only supported with output=" + OutputType.jfr.name());
                }
            }
            this.profilerConfig = builder.profilerOptions();
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        if (this.trialOutDir == null) {
            this.createTrialOutDir(benchmarkParams);
        }
        if (iterationParams.getType() == IterationType.WARMUP && !this.warmupStarted) {
            this.start();
            this.warmupStarted = true;
        }
        if (iterationParams.getType() == IterationType.MEASUREMENT && !this.measurementStarted) {
            if (this.warmupStarted) {
                this.execute("stop");
            }
            this.start();
            this.measurementStarted = true;
        }
    }

    private void start() {
        if (this.output.contains((Object)OutputType.jfr)) {
            this.execute("start," + this.profilerConfig + ",file=" + this.outputFile("jfr-%s.jfr").getAbsolutePath());
        } else {
            this.execute("start," + this.profilerConfig);
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResult) {
        if (iterationParams.getType() == IterationType.MEASUREMENT) {
            ++this.measurementIterationCount;
            if (this.measurementIterationCount == iterationParams.getCount()) {
                return Collections.singletonList(this.stopAndDump());
            }
        }
        return Collections.emptyList();
    }

    private void createTrialOutDir(BenchmarkParams benchmarkParams) {
        if (this.trialOutDir == null) {
            String fileName = benchmarkParams.id().replace("%", "_");
            this.trialOutDir = new File(this.outDir, fileName);
            this.trialOutDir.mkdirs();
        }
    }

    private TextResult stopAndDump() {
        this.execute("stop");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        block8: for (OutputType outputType : this.output) {
            switch (outputType) {
                case text: {
                    File out = this.outputFile("summary-%s.txt");
                    if (this.isVersion1x) {
                        this.dump(out, "summary,flat=" + this.flat + ",traces=" + this.traces);
                    } else {
                        this.dump(out, "flat=" + this.flat + ",traces=" + this.traces);
                    }
                    try {
                        for (String line : FileUtils.readAllLines(out)) {
                            pw.println(line);
                        }
                        continue block8;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case collapsed: {
                    this.dump(this.outputFile("collapsed-%s.csv"), "collapsed");
                    break;
                }
                case flamegraph: {
                    String ext;
                    String string = ext = this.isVersion1x ? "svg" : "html";
                    if (this.direction == Direction.both || this.direction == Direction.forward) {
                        this.dump(this.outputFile("flame-%s-forward." + ext), "flamegraph");
                    }
                    if (this.direction != Direction.both && this.direction != Direction.reverse) break;
                    this.dump(this.outputFile("flame-%s-reverse." + ext), "flamegraph,reverse");
                    break;
                }
                case tree: {
                    this.dump(this.outputFile("tree-%s.html"), "tree");
                    break;
                }
            }
        }
        pw.println("Async profiler results:");
        for (File file : this.generated) {
            pw.print("  ");
            pw.println(file.getPath());
        }
        pw.flush();
        pw.close();
        return new TextResult(sw.toString(), "async");
    }

    private void dump(File target, String command) {
        this.execute(command + "," + this.profilerConfig + ",file=" + target.getAbsolutePath());
    }

    private File outputFile(String fileNameFormat) {
        File output = new File(this.trialOutDir, String.format(fileNameFormat, this.outputFilePrefix));
        this.generated.add(output);
        return output;
    }

    private String execute(String command) {
        if (this.verbose) {
            System.out.println("[async-profiler] " + command);
        }
        try {
            return this.instance.execute(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-XX:+UnlockDiagnosticVMOptions");
        args.add("-XX:+DebugNonSafepoints");
        return args;
    }

    @Override
    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return Collections.emptyList();
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return true;
    }

    @Override
    public String getDescription() {
        return "async-profiler profiler provider.";
    }

    public static enum OutputType {
        text,
        collapsed,
        flamegraph,
        tree,
        jfr;

    }

    public static enum Direction {
        forward,
        reverse,
        both;

    }

    public static enum CStackMode {
        fp,
        lbr,
        no;

    }

    private static class ProfilerOptionsBuilder {
        private final OptionSet optionSet;
        private final StringBuilder profilerOptions;

        ProfilerOptionsBuilder(OptionSet optionSet) {
            this.optionSet = optionSet;
            this.profilerOptions = new StringBuilder();
        }

        <T> void appendIfExists(OptionSpec<T> option) {
            if (this.optionSet.has(option)) {
                this.append(option);
            }
        }

        <T> void append(OptionSpec<T> option) {
            assert (option.options().size() == 1);
            String optionName = (String)option.options().iterator().next();
            this.separate();
            this.profilerOptions.append(optionName);
            Object arg = this.optionSet.valueOf(option);
            if (arg != null) {
                this.profilerOptions.append('=').append(arg);
            }
        }

        void appendRaw(String command) {
            this.separate();
            this.profilerOptions.append(command);
        }

        private void separate() {
            if (this.profilerOptions.length() > 0) {
                this.profilerOptions.append(',');
            }
        }

        void appendIfTrue(OptionSpec<Boolean> option) {
            if (this.optionSet.has(option) && ((Boolean)this.optionSet.valueOf(option)).booleanValue()) {
                this.append(option);
            }
        }

        <T> void appendMulti(OptionSpec<T> option) {
            if (this.optionSet.has(option)) {
                assert (option.options().size() == 1);
                String optionName = (String)option.options().iterator().next();
                for (Object value : this.optionSet.valuesOf(option)) {
                    this.separate();
                    this.profilerOptions.append(optionName).append('=').append(value.toString());
                }
            }
        }

        public String profilerOptions() {
            return this.profilerOptions.toString();
        }
    }

    public static final class JavaApi {
        private static EnumSet<Thread.State> ignoredThreadStates = EnumSet.of(Thread.State.NEW, Thread.State.TERMINATED);
        private static JavaApi INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static JavaApi getInstance(String libraryFileName) {
            if (INSTANCE != null) return INSTANCE;
            Class<AsyncProfiler> clazz = AsyncProfiler.class;
            synchronized (AsyncProfiler.class) {
                INSTANCE = new JavaApi(libraryFileName);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static JavaApi getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<AsyncProfiler> clazz = AsyncProfiler.class;
            synchronized (AsyncProfiler.class) {
                INSTANCE = new JavaApi();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        private JavaApi(String libraryFileName) {
            System.load(libraryFileName);
        }

        private JavaApi() {
            System.loadLibrary("asyncProfiler");
        }

        public String execute(String command) throws IOException {
            return this.execute0(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void filterThread(Thread thread, boolean enable) {
            if (thread == null) {
                this.filterThread0(null, enable);
            } else {
                Thread thread2 = thread;
                synchronized (thread2) {
                    Thread.State state = thread.getState();
                    if (!ignoredThreadStates.contains((Object)state)) {
                        this.filterThread0(thread, enable);
                    }
                }
            }
        }

        private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

        private native void stop0() throws IllegalStateException;

        private native String execute0(String var1) throws IllegalArgumentException, IOException;

        private native long getSamples();

        private native void filterThread0(Thread var1, boolean var2);
    }
}

