/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.locale;

import de.undercouch.citeproc.helper.NodeHelper;
import java.util.Objects;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LTerm {
    private final String name;
    private final Form form;
    private final String single;
    private final String multiple;

    public LTerm(Node node) {
        this.name = NodeHelper.getAttrValue(node, "name");
        String strForm = NodeHelper.getAttrValue(node, "form");
        if (strForm == null) {
            strForm = "long";
        }
        this.form = Form.fromString(strForm);
        String single = null;
        String multiple = null;
        NodeList children = node.getChildNodes();
        block8: for (int i = 0; i < children.getLength(); ++i) {
            String nodeName;
            Node c = children.item(i);
            if (c.getNodeType() != 1) continue;
            switch (nodeName = c.getNodeName()) {
                case "single": {
                    single = c.getTextContent();
                    continue block8;
                }
                case "multiple": {
                    multiple = c.getTextContent();
                    continue block8;
                }
            }
        }
        if (single == null && (single = node.getTextContent()) == null) {
            throw new IllegalStateException("Invalid term value");
        }
        if (multiple == null) {
            multiple = single;
        }
        this.single = single;
        this.multiple = multiple;
    }

    public String getName() {
        return this.name;
    }

    public Form getForm() {
        return this.form;
    }

    public String getSingle() {
        return this.single;
    }

    public String getMultiple() {
        return this.multiple;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LTerm term = (LTerm)o;
        return this.name.equals(term.name) && this.form.equals((Object)term.form) && this.single.equals(term.single) && this.multiple.equals(term.multiple);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.form, this.single, this.multiple});
    }

    public static enum Form {
        LONG,
        SHORT,
        VERB,
        VERB_SHORT,
        SYMBOL;


        public static Form fromString(String str) {
            switch (str) {
                case "long": {
                    return LONG;
                }
                case "short": {
                    return SHORT;
                }
                case "verb": {
                    return VERB;
                }
                case "verb-short": {
                    return VERB_SHORT;
                }
                case "symbol": {
                    return SYMBOL;
                }
            }
            throw new IllegalArgumentException("Unknown term form: " + str);
        }
    }
}

