/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class Levenshtein {
    public static <T extends CharSequence> T findMinimum(Collection<T> ss, CharSequence t) {
        int min = Integer.MAX_VALUE;
        CharSequence result = null;
        for (CharSequence s : ss) {
            int d = LevenshteinDistance.getDefaultInstance().apply(s, t);
            if (d >= min) continue;
            min = d;
            result = s;
        }
        return (T)result;
    }

    public static <T extends CharSequence> Collection<T> findMinimum(Collection<T> ss, CharSequence t, int n, int threshold) {
        LinkedList<Item<CharSequence>> result = new LinkedList<Item<CharSequence>>();
        for (CharSequence s : ss) {
            int n2 = LevenshteinDistance.getDefaultInstance().apply(s, t);
            if (n2 >= threshold) continue;
            result.offer(new Item<CharSequence>(s, n2));
            if (result.size() <= n + 10) continue;
            Collections.sort(result);
            while (result.size() > n) {
                result.removeLast();
            }
        }
        Collections.sort(result);
        while (result.size() > n) {
            result.removeLast();
        }
        ArrayList<CharSequence> arr = new ArrayList<CharSequence>(n);
        for (Item item : result) {
            arr.add((CharSequence)item.str);
        }
        return arr;
    }

    public static <T extends CharSequence> Collection<T> findSimilar(Collection<T> ss, CharSequence t) {
        LinkedHashSet<CharSequence> result = new LinkedHashSet<CharSequence>();
        for (CharSequence s : ss) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)s, (CharSequence)t)) continue;
            result.add(s);
        }
        Collection<T> mins = Levenshtein.findMinimum(ss, t, 5, Math.min(t.length() - 1, 7));
        result.addAll(mins);
        return result;
    }

    private static class Item<T>
    implements Comparable<Item<T>> {
        private final T str;
        private final int distance;

        public Item(T str, int distance) {
            this.str = str;
            this.distance = distance;
        }

        @Override
        public int compareTo(Item<T> o) {
            return Integer.compare(this.distance, o.distance);
        }
    }
}

