/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"
	json "encoding/json"
	fmt "fmt"

	v1beta2 "k8s.io/api/apps/v1beta2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	appsv1beta2 "k8s.io/client-go/applyconfigurations/apps/v1beta2"
	gentype "k8s.io/client-go/gentype"
	typedappsv1beta2 "k8s.io/client-go/kubernetes/typed/apps/v1beta2"
	testing "k8s.io/client-go/testing"
)

// fakeStatefulSets implements StatefulSetInterface
type fakeStatefulSets struct {
	*gentype.FakeClientWithListAndApply[*v1beta2.StatefulSet, *v1beta2.StatefulSetList, *appsv1beta2.StatefulSetApplyConfiguration]
	Fake *FakeAppsV1beta2
}

func newFakeStatefulSets(fake *FakeAppsV1beta2, namespace string) typedappsv1beta2.StatefulSetInterface {
	return &fakeStatefulSets{
		gentype.NewFakeClientWithListAndApply[*v1beta2.StatefulSet, *v1beta2.StatefulSetList, *appsv1beta2.StatefulSetApplyConfiguration](
			fake.Fake,
			namespace,
			v1beta2.SchemeGroupVersion.WithResource("statefulsets"),
			v1beta2.SchemeGroupVersion.WithKind("StatefulSet"),
			func() *v1beta2.StatefulSet { return &v1beta2.StatefulSet{} },
			func() *v1beta2.StatefulSetList { return &v1beta2.StatefulSetList{} },
			func(dst, src *v1beta2.StatefulSetList) { dst.ListMeta = src.ListMeta },
			func(list *v1beta2.StatefulSetList) []*v1beta2.StatefulSet { return gentype.ToPointerSlice(list.Items) },
			func(list *v1beta2.StatefulSetList, items []*v1beta2.StatefulSet) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}

// GetScale takes name of the statefulSet, and returns the corresponding scale object, and an error if there is any.
func (c *fakeStatefulSets) GetScale(ctx context.Context, statefulSetName string, options v1.GetOptions) (result *v1beta2.Scale, err error) {
	emptyResult := &v1beta2.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceActionWithOptions(c.Resource(), c.Namespace(), "scale", statefulSetName, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta2.Scale), err
}

// UpdateScale takes the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *fakeStatefulSets) UpdateScale(ctx context.Context, statefulSetName string, scale *v1beta2.Scale, opts v1.UpdateOptions) (result *v1beta2.Scale, err error) {
	emptyResult := &v1beta2.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(c.Resource(), "scale", c.Namespace(), scale, opts), &v1beta2.Scale{})

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta2.Scale), err
}

// ApplyScale takes top resource name and the apply declarative configuration for scale,
// applies it and returns the applied scale, and an error, if there is any.
func (c *fakeStatefulSets) ApplyScale(ctx context.Context, statefulSetName string, scale *appsv1beta2.ScaleApplyConfiguration, opts v1.ApplyOptions) (result *v1beta2.Scale, err error) {
	if scale == nil {
		return nil, fmt.Errorf("scale provided to ApplyScale must not be nil")
	}
	data, err := json.Marshal(scale)
	if err != nil {
		return nil, err
	}
	emptyResult := &v1beta2.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(c.Resource(), c.Namespace(), statefulSetName, types.ApplyPatchType, data, opts.ToPatchOptions(), "scale"), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta2.Scale), err
}
