/// <reference path="./gobject-2.0.d.ts" />

/**
 * Type Definitions for Gjs (https://gjs.guide/)
 *
 * These type definitions are automatically generated, do not edit them by hand.
 * If you found a bug fix it in `ts-for-gir` or create a bug report on https://github.com/gjsify/ts-for-gir
 *
 * The based EJS template file is used for the generated .d.ts file of each GIR module like Gtk-4.0, GObject-2.0, ...
 */

declare module 'gi://GLib?version=2.0' {
    // Module dependencies
    import type GObject from 'gi://GObject?version=2.0';

    export namespace GLib {
        /**
         * GLib-2.0
         */

        /**
         * Error codes returned by bookmark file parsing.
         */
        class BookmarkFileError extends Error {
            static $gtype: GObject.GType<BookmarkFileError>;

            // Static fields

            /**
             * URI was ill-formed
             */
            static INVALID_URI: number;
            /**
             * a requested field was not found
             */
            static INVALID_VALUE: number;
            /**
             * a requested application did
             *     not register a bookmark
             */
            static APP_NOT_REGISTERED: number;
            /**
             * a requested URI was not found
             */
            static URI_NOT_FOUND: number;
            /**
             * document was ill formed
             */
            static READ: number;
            /**
             * the text being parsed was
             *     in an unknown encoding
             */
            static UNKNOWN_ENCODING: number;
            /**
             * an error occurred while writing
             */
            static WRITE: number;
            /**
             * requested file was not found
             */
            static FILE_NOT_FOUND: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * The hashing algorithm to be used by #GChecksum when performing the
         * digest of some data.
         *
         * Note that the #GChecksumType enumeration may be extended at a later
         * date to include new hashing algorithm types.
         */

        /**
         * The hashing algorithm to be used by #GChecksum when performing the
         * digest of some data.
         *
         * Note that the #GChecksumType enumeration may be extended at a later
         * date to include new hashing algorithm types.
         */
        export namespace ChecksumType {
            export const $gtype: GObject.GType<ChecksumType>;
        }

        enum ChecksumType {
            /**
             * Use the MD5 hashing algorithm
             */
            MD5,
            /**
             * Use the SHA-1 hashing algorithm
             */
            SHA1,
            /**
             * Use the SHA-256 hashing algorithm
             */
            SHA256,
            /**
             * Use the SHA-512 hashing algorithm (Since: 2.36)
             */
            SHA512,
            /**
             * Use the SHA-384 hashing algorithm (Since: 2.51)
             */
            SHA384,
        }
        /**
         * Error codes returned by character set conversion routines.
         */
        class ConvertError extends Error {
            static $gtype: GObject.GType<ConvertError>;

            // Static fields

            /**
             * Conversion between the requested character
             *     sets is not supported.
             */
            static NO_CONVERSION: number;
            /**
             * Invalid byte sequence in conversion input;
             *    or the character sequence could not be represented in the target
             *    character set.
             */
            static ILLEGAL_SEQUENCE: number;
            /**
             * Conversion failed for some reason.
             */
            static FAILED: number;
            /**
             * Partial character sequence at end of input.
             */
            static PARTIAL_INPUT: number;
            /**
             * URI is invalid.
             */
            static BAD_URI: number;
            /**
             * Pathname is not an absolute path.
             */
            static NOT_ABSOLUTE_PATH: number;
            /**
             * No memory available. Since: 2.40
             */
            static NO_MEMORY: number;
            /**
             * An embedded NUL character is present in
             *     conversion output where a NUL-terminated string is expected.
             *     Since: 2.56
             */
            static EMBEDDED_NUL: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * This enumeration isn't used in the API, but may be useful if you need
         * to mark a number as a day, month, or year.
         */

        /**
         * This enumeration isn't used in the API, but may be useful if you need
         * to mark a number as a day, month, or year.
         */
        export namespace DateDMY {
            export const $gtype: GObject.GType<DateDMY>;
        }

        enum DateDMY {
            /**
             * a day
             */
            DAY,
            /**
             * a month
             */
            MONTH,
            /**
             * a year
             */
            YEAR,
        }
        /**
         * Enumeration representing a month; values are %G_DATE_JANUARY,
         * %G_DATE_FEBRUARY, etc. %G_DATE_BAD_MONTH is the invalid value.
         */

        /**
         * Enumeration representing a month; values are %G_DATE_JANUARY,
         * %G_DATE_FEBRUARY, etc. %G_DATE_BAD_MONTH is the invalid value.
         */
        export namespace DateMonth {
            export const $gtype: GObject.GType<DateMonth>;
        }

        enum DateMonth {
            /**
             * invalid value
             */
            BAD_MONTH,
            /**
             * January
             */
            JANUARY,
            /**
             * February
             */
            FEBRUARY,
            /**
             * March
             */
            MARCH,
            /**
             * April
             */
            APRIL,
            /**
             * May
             */
            MAY,
            /**
             * June
             */
            JUNE,
            /**
             * July
             */
            JULY,
            /**
             * August
             */
            AUGUST,
            /**
             * September
             */
            SEPTEMBER,
            /**
             * October
             */
            OCTOBER,
            /**
             * November
             */
            NOVEMBER,
            /**
             * December
             */
            DECEMBER,
        }
        /**
         * Enumeration representing a day of the week; %G_DATE_MONDAY,
         * %G_DATE_TUESDAY, etc. %G_DATE_BAD_WEEKDAY is an invalid weekday.
         */

        /**
         * Enumeration representing a day of the week; %G_DATE_MONDAY,
         * %G_DATE_TUESDAY, etc. %G_DATE_BAD_WEEKDAY is an invalid weekday.
         */
        export namespace DateWeekday {
            export const $gtype: GObject.GType<DateWeekday>;
        }

        enum DateWeekday {
            /**
             * invalid value
             */
            BAD_WEEKDAY,
            /**
             * Monday
             */
            MONDAY,
            /**
             * Tuesday
             */
            TUESDAY,
            /**
             * Wednesday
             */
            WEDNESDAY,
            /**
             * Thursday
             */
            THURSDAY,
            /**
             * Friday
             */
            FRIDAY,
            /**
             * Saturday
             */
            SATURDAY,
            /**
             * Sunday
             */
            SUNDAY,
        }
        /**
         * The possible errors, used in the `v_error` field
         * of #GTokenValue, when the token is a %G_TOKEN_ERROR.
         */

        /**
         * The possible errors, used in the `v_error` field
         * of #GTokenValue, when the token is a %G_TOKEN_ERROR.
         */
        export namespace ErrorType {
            export const $gtype: GObject.GType<ErrorType>;
        }

        enum ErrorType {
            /**
             * unknown error
             */
            UNKNOWN,
            /**
             * unexpected end of file
             */
            UNEXP_EOF,
            /**
             * unterminated string constant
             */
            UNEXP_EOF_IN_STRING,
            /**
             * unterminated comment
             */
            UNEXP_EOF_IN_COMMENT,
            /**
             * non-digit character in a number
             */
            NON_DIGIT_IN_CONST,
            /**
             * digit beyond radix in a number
             */
            DIGIT_RADIX,
            /**
             * non-decimal floating point number
             */
            FLOAT_RADIX,
            /**
             * malformed floating point number
             */
            FLOAT_MALFORMED,
        }
        /**
         * Values corresponding to `errno` codes returned from file operations
         * on UNIX. Unlike `errno` codes, GFileError values are available on
         * all systems, even Windows. The exact meaning of each code depends
         * on what sort of file operation you were performing; the UNIX
         * documentation gives more details. The following error code descriptions
         * come from the GNU C Library manual, and are under the copyright
         * of that manual.
         *
         * It's not very portable to make detailed assumptions about exactly
         * which errors will be returned from a given operation. Some errors
         * don't occur on some systems, etc., sometimes there are subtle
         * differences in when a system will report a given error, etc.
         */
        class FileError extends Error {
            static $gtype: GObject.GType<FileError>;

            // Static fields

            /**
             * Operation not permitted; only the owner of
             *     the file (or other resource) or processes with special privileges
             *     can perform the operation.
             */
            static EXIST: number;
            /**
             * File is a directory; you cannot open a directory
             *     for writing, or create or remove hard links to it.
             */
            static ISDIR: number;
            /**
             * Permission denied; the file permissions do not
             *     allow the attempted operation.
             */
            static ACCES: number;
            /**
             * Filename too long.
             */
            static NAMETOOLONG: number;
            /**
             * No such file or directory. This is a "file
             *     doesn't exist" error for ordinary files that are referenced in
             *     contexts where they are expected to already exist.
             */
            static NOENT: number;
            /**
             * A file that isn't a directory was specified when
             *     a directory is required.
             */
            static NOTDIR: number;
            /**
             * No such device or address. The system tried to
             *     use the device represented by a file you specified, and it
             *     couldn't find the device. This can mean that the device file was
             *     installed incorrectly, or that the physical device is missing or
             *     not correctly attached to the computer.
             */
            static NXIO: number;
            /**
             * The underlying file system of the specified file
             *     does not support memory mapping.
             */
            static NODEV: number;
            /**
             * The directory containing the new link can't be
             *     modified because it's on a read-only file system.
             */
            static ROFS: number;
            /**
             * Text file busy.
             */
            static TXTBSY: number;
            /**
             * You passed in a pointer to bad memory.
             *     (GLib won't reliably return this, don't pass in pointers to bad
             *     memory.)
             */
            static FAULT: number;
            /**
             * Too many levels of symbolic links were encountered
             *     in looking up a file name. This often indicates a cycle of symbolic
             *     links.
             */
            static LOOP: number;
            /**
             * No space left on device; write operation on a
             *     file failed because the disk is full.
             */
            static NOSPC: number;
            /**
             * No memory available. The system cannot allocate
             *     more virtual memory because its capacity is full.
             */
            static NOMEM: number;
            /**
             * The current process has too many files open and
             *     can't open any more. Duplicate descriptors do count toward this
             *     limit.
             */
            static MFILE: number;
            /**
             * There are too many distinct file openings in the
             *     entire system.
             */
            static NFILE: number;
            /**
             * Bad file descriptor; for example, I/O on a
             *     descriptor that has been closed or reading from a descriptor open
             *     only for writing (or vice versa).
             */
            static BADF: number;
            /**
             * Invalid argument. This is used to indicate
             *     various kinds of problems with passing the wrong argument to a
             *     library function.
             */
            static INVAL: number;
            /**
             * Broken pipe; there is no process reading from the
             *     other end of a pipe. Every library function that returns this
             *     error code also generates a 'SIGPIPE' signal; this signal
             *     terminates the program if not handled or blocked. Thus, your
             *     program will never actually see this code unless it has handled
             *     or blocked 'SIGPIPE'.
             */
            static PIPE: number;
            /**
             * Resource temporarily unavailable; the call might
             *     work if you try again later.
             */
            static AGAIN: number;
            /**
             * Interrupted function call; an asynchronous signal
             *     occurred and prevented completion of the call. When this
             *     happens, you should try the call again.
             */
            static INTR: number;
            /**
             * Input/output error; usually used for physical read
             *    or write errors. i.e. the disk or other physical device hardware
             *    is returning errors.
             */
            static IO: number;
            /**
             * Operation not permitted; only the owner of the
             *    file (or other resource) or processes with special privileges can
             *    perform the operation.
             */
            static PERM: number;
            /**
             * Function not implemented; this indicates that
             *    the system is missing some functionality.
             */
            static NOSYS: number;
            /**
             * Does not correspond to a UNIX error code; this
             *    is the standard "failed for unspecified reason" error code present
             *    in all #GError error code enumerations. Returned if no specific
             *    code applies.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Error codes returned by #GIOChannel operations.
         */
        class IOChannelError extends Error {
            static $gtype: GObject.GType<IOChannelError>;

            // Static fields

            /**
             * File too large.
             */
            static FBIG: number;
            /**
             * Invalid argument.
             */
            static INVAL: number;
            /**
             * IO error.
             */
            static IO: number;
            /**
             * File is a directory.
             */
            static ISDIR: number;
            /**
             * No space left on device.
             */
            static NOSPC: number;
            /**
             * No such device or address.
             */
            static NXIO: number;
            /**
             * Value too large for defined datatype.
             */
            static OVERFLOW: number;
            /**
             * Broken pipe.
             */
            static PIPE: number;
            /**
             * Some other error.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * #GIOError is only used by the deprecated functions
         * g_io_channel_read(), g_io_channel_write(), and g_io_channel_seek().
         */

        /**
         * #GIOError is only used by the deprecated functions
         * g_io_channel_read(), g_io_channel_write(), and g_io_channel_seek().
         */
        export namespace IOError {
            export const $gtype: GObject.GType<IOError>;
        }

        enum IOError {
            /**
             * no error
             */
            NONE,
            /**
             * an EAGAIN error occurred
             */
            AGAIN,
            /**
             * an EINVAL error occurred
             */
            INVAL,
            /**
             * another error occurred
             */
            UNKNOWN,
        }
        /**
         * Statuses returned by most of the #GIOFuncs functions.
         */

        /**
         * Statuses returned by most of the #GIOFuncs functions.
         */
        export namespace IOStatus {
            export const $gtype: GObject.GType<IOStatus>;
        }

        enum IOStatus {
            /**
             * An error occurred.
             */
            ERROR,
            /**
             * Success.
             */
            NORMAL,
            /**
             * End of file.
             */
            EOF,
            /**
             * Resource temporarily unavailable.
             */
            AGAIN,
        }
        /**
         * Error codes returned by key file parsing.
         */
        class KeyFileError extends Error {
            static $gtype: GObject.GType<KeyFileError>;

            // Static fields

            /**
             * the text being parsed was in
             *   an unknown encoding
             */
            static UNKNOWN_ENCODING: number;
            /**
             * document was ill-formed
             */
            static PARSE: number;
            /**
             * the file was not found
             */
            static NOT_FOUND: number;
            /**
             * a requested key was not found
             */
            static KEY_NOT_FOUND: number;
            /**
             * a requested group was not found
             */
            static GROUP_NOT_FOUND: number;
            /**
             * a value could not be parsed
             */
            static INVALID_VALUE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Return values from #GLogWriterFuncs to indicate whether the given log entry
         * was successfully handled by the writer, or whether there was an error in
         * handling it (and hence a fallback writer should be used).
         *
         * If a #GLogWriterFunc ignores a log entry, it should return
         * %G_LOG_WRITER_HANDLED.
         */

        /**
         * Return values from #GLogWriterFuncs to indicate whether the given log entry
         * was successfully handled by the writer, or whether there was an error in
         * handling it (and hence a fallback writer should be used).
         *
         * If a #GLogWriterFunc ignores a log entry, it should return
         * %G_LOG_WRITER_HANDLED.
         */
        export namespace LogWriterOutput {
            export const $gtype: GObject.GType<LogWriterOutput>;
        }

        enum LogWriterOutput {
            /**
             * Log writer has handled the log entry.
             */
            HANDLED,
            /**
             * Log writer could not handle the log entry.
             */
            UNHANDLED,
        }
        /**
         * Error codes returned by markup parsing.
         */
        class MarkupError extends Error {
            static $gtype: GObject.GType<MarkupError>;

            // Static fields

            /**
             * text being parsed was not valid UTF-8
             */
            static BAD_UTF8: number;
            /**
             * document contained nothing, or only whitespace
             */
            static EMPTY: number;
            /**
             * document was ill-formed
             */
            static PARSE: number;
            /**
             * error should be set by #GMarkupParser
             *     functions; element wasn't known
             */
            static UNKNOWN_ELEMENT: number;
            /**
             * error should be set by #GMarkupParser
             *     functions; attribute wasn't known
             */
            static UNKNOWN_ATTRIBUTE: number;
            /**
             * error should be set by #GMarkupParser
             *     functions; content was invalid
             */
            static INVALID_CONTENT: number;
            /**
             * error should be set by #GMarkupParser
             *     functions; a required attribute was missing
             */
            static MISSING_ATTRIBUTE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Defines how a Unicode string is transformed in a canonical
         * form, standardizing such issues as whether a character with
         * an accent is represented as a base character and combining
         * accent or as a single precomposed character. Unicode strings
         * should generally be normalized before comparing them.
         */

        /**
         * Defines how a Unicode string is transformed in a canonical
         * form, standardizing such issues as whether a character with
         * an accent is represented as a base character and combining
         * accent or as a single precomposed character. Unicode strings
         * should generally be normalized before comparing them.
         */
        export namespace NormalizeMode {
            export const $gtype: GObject.GType<NormalizeMode>;
        }

        enum NormalizeMode {
            /**
             * standardize differences that do not affect the
             *     text content, such as the above-mentioned accent representation
             */
            DEFAULT,
            /**
             * another name for %G_NORMALIZE_DEFAULT
             */
            NFD,
            /**
             * like %G_NORMALIZE_DEFAULT, but with
             *     composed forms rather than a maximally decomposed form
             */
            DEFAULT_COMPOSE,
            /**
             * another name for %G_NORMALIZE_DEFAULT_COMPOSE
             */
            NFC,
            /**
             * beyond %G_NORMALIZE_DEFAULT also standardize the
             *     "compatibility" characters in Unicode, such as SUPERSCRIPT THREE
             *     to the standard forms (in this case DIGIT THREE). Formatting
             *     information may be lost but for most text operations such
             *     characters should be considered the same
             */
            ALL,
            /**
             * another name for %G_NORMALIZE_ALL
             */
            NFKD,
            /**
             * like %G_NORMALIZE_ALL, but with composed
             *     forms rather than a maximally decomposed form
             */
            ALL_COMPOSE,
            /**
             * another name for %G_NORMALIZE_ALL_COMPOSE
             */
            NFKC,
        }
        /**
         * Error codes returned by functions converting a string to a number.
         */
        class NumberParserError extends Error {
            static $gtype: GObject.GType<NumberParserError>;

            // Static fields

            /**
             * string was not a valid number
             */
            static INVALID: number;
            /**
             * string was a number, but out of bounds
             */
            static OUT_OF_BOUNDS: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * The possible statuses of a one-time initialization function
         * controlled by a #GOnce struct.
         */

        /**
         * The possible statuses of a one-time initialization function
         * controlled by a #GOnce struct.
         */
        export namespace OnceStatus {
            export const $gtype: GObject.GType<OnceStatus>;
        }

        enum OnceStatus {
            /**
             * the function has not been called yet.
             */
            NOTCALLED,
            /**
             * the function call is currently in progress.
             */
            PROGRESS,
            /**
             * the function has been called.
             */
            READY,
        }
        /**
         * The #GOptionArg enum values determine which type of extra argument the
         * options expect to find. If an option expects an extra argument, it can
         * be specified in several ways; with a short option: `-x arg`, with a long
         * option: `--name arg` or combined in a single argument: `--name=arg`.
         */

        /**
         * The #GOptionArg enum values determine which type of extra argument the
         * options expect to find. If an option expects an extra argument, it can
         * be specified in several ways; with a short option: `-x arg`, with a long
         * option: `--name arg` or combined in a single argument: `--name=arg`.
         */
        export namespace OptionArg {
            export const $gtype: GObject.GType<OptionArg>;
        }

        enum OptionArg {
            /**
             * No extra argument. This is useful for simple flags or booleans.
             */
            NONE,
            /**
             * The option takes a UTF-8 string argument.
             */
            STRING,
            /**
             * The option takes an integer argument.
             */
            INT,
            /**
             * The option provides a callback (of type #GOptionArgFunc)
             *   to parse the extra argument.
             */
            CALLBACK,
            /**
             * The option takes a filename as argument, which will
             *      be in the GLib filename encoding rather than UTF-8.
             */
            FILENAME,
            /**
             * The option takes a string argument, multiple
             *   uses of the option are collected into an array of strings.
             */
            STRING_ARRAY,
            /**
             * The option takes a filename as argument,
             *   multiple uses of the option are collected into an array of strings.
             */
            FILENAME_ARRAY,
            /**
             * The option takes a double argument. The argument
             *   can be formatted either for the user's locale or for the "C" locale.
             *   Since 2.12
             */
            DOUBLE,
            /**
             * The option takes a 64-bit integer. Like
             *   %G_OPTION_ARG_INT but for larger numbers. The number can be in
             *   decimal base, or in hexadecimal (when prefixed with `0x`, for
             *   example, `0xffffffff`). Since 2.12
             */
            INT64,
        }
        /**
         * Error codes returned by option parsing.
         */
        class OptionError extends Error {
            static $gtype: GObject.GType<OptionError>;

            // Static fields

            /**
             * An option was not known to the parser.
             *  This error will only be reported, if the parser hasn't been instructed
             *  to ignore unknown options, see g_option_context_set_ignore_unknown_options().
             */
            static UNKNOWN_OPTION: number;
            /**
             * A value couldn't be parsed.
             */
            static BAD_VALUE: number;
            /**
             * A #GOptionArgFunc callback failed.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Error codes returned by regular expressions functions.
         */
        class RegexError extends Error {
            static $gtype: GObject.GType<RegexError>;

            // Static fields

            /**
             * Compilation of the regular expression failed.
             */
            static COMPILE: number;
            /**
             * Optimization of the regular expression failed.
             */
            static OPTIMIZE: number;
            /**
             * Replacement failed due to an ill-formed replacement
             *     string.
             */
            static REPLACE: number;
            /**
             * The match process failed.
             */
            static MATCH: number;
            /**
             * Internal error of the regular expression engine.
             *     Since 2.16
             */
            static INTERNAL: number;
            /**
             * "\\" at end of pattern. Since 2.16
             */
            static STRAY_BACKSLASH: number;
            /**
             * "\\c" at end of pattern. Since 2.16
             */
            static MISSING_CONTROL_CHAR: number;
            /**
             * Unrecognized character follows "\\".
             *     Since 2.16
             */
            static UNRECOGNIZED_ESCAPE: number;
            /**
             * Numbers out of order in "{}"
             *     quantifier. Since 2.16
             */
            static QUANTIFIERS_OUT_OF_ORDER: number;
            /**
             * Number too big in "{}" quantifier.
             *     Since 2.16
             */
            static QUANTIFIER_TOO_BIG: number;
            /**
             * Missing terminating "]" for
             *     character class. Since 2.16
             */
            static UNTERMINATED_CHARACTER_CLASS: number;
            /**
             * Invalid escape sequence
             *     in character class. Since 2.16
             */
            static INVALID_ESCAPE_IN_CHARACTER_CLASS: number;
            /**
             * Range out of order in character class.
             *     Since 2.16
             */
            static RANGE_OUT_OF_ORDER: number;
            /**
             * Nothing to repeat. Since 2.16
             */
            static NOTHING_TO_REPEAT: number;
            /**
             * Unrecognized character after "(?",
             *     "(?<" or "(?P". Since 2.16
             */
            static UNRECOGNIZED_CHARACTER: number;
            /**
             * POSIX named classes are
             *     supported only within a class. Since 2.16
             */
            static POSIX_NAMED_CLASS_OUTSIDE_CLASS: number;
            /**
             * Missing terminating ")" or ")"
             *     without opening "(". Since 2.16
             */
            static UNMATCHED_PARENTHESIS: number;
            /**
             * Reference to non-existent
             *     subpattern. Since 2.16
             */
            static INEXISTENT_SUBPATTERN_REFERENCE: number;
            /**
             * Missing terminating ")" after comment.
             *     Since 2.16
             */
            static UNTERMINATED_COMMENT: number;
            /**
             * Regular expression too large.
             *     Since 2.16
             */
            static EXPRESSION_TOO_LARGE: number;
            /**
             * Failed to get memory. Since 2.16
             */
            static MEMORY_ERROR: number;
            /**
             * Lookbehind assertion is not
             *     fixed length. Since 2.16
             */
            static VARIABLE_LENGTH_LOOKBEHIND: number;
            /**
             * Malformed number or name after "(?(".
             *     Since 2.16
             */
            static MALFORMED_CONDITION: number;
            /**
             * Conditional group contains
             *     more than two branches. Since 2.16
             */
            static TOO_MANY_CONDITIONAL_BRANCHES: number;
            /**
             * Assertion expected after "(?(".
             *     Since 2.16
             */
            static ASSERTION_EXPECTED: number;
            /**
             * Unknown POSIX class name.
             *     Since 2.16
             */
            static UNKNOWN_POSIX_CLASS_NAME: number;
            /**
             * POSIX collating
             *     elements are not supported. Since 2.16
             */
            static POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED: number;
            /**
             * Character value in "\\x{...}" sequence
             *     is too large. Since 2.16
             */
            static HEX_CODE_TOO_LARGE: number;
            /**
             * Invalid condition "(?(0)". Since 2.16
             */
            static INVALID_CONDITION: number;
            /**
             * \\C not allowed in
             *     lookbehind assertion. Since 2.16
             */
            static SINGLE_BYTE_MATCH_IN_LOOKBEHIND: number;
            /**
             * Recursive call could loop indefinitely.
             *     Since 2.16
             */
            static INFINITE_LOOP: number;
            /**
             * Missing terminator
             *     in subpattern name. Since 2.16
             */
            static MISSING_SUBPATTERN_NAME_TERMINATOR: number;
            /**
             * Two named subpatterns have
             *     the same name. Since 2.16
             */
            static DUPLICATE_SUBPATTERN_NAME: number;
            /**
             * Malformed "\\P" or "\\p" sequence.
             *     Since 2.16
             */
            static MALFORMED_PROPERTY: number;
            /**
             * Unknown property name after "\\P" or
             *     "\\p". Since 2.16
             */
            static UNKNOWN_PROPERTY: number;
            /**
             * Subpattern name is too long
             *     (maximum 32 characters). Since 2.16
             */
            static SUBPATTERN_NAME_TOO_LONG: number;
            /**
             * Too many named subpatterns (maximum
             *     10,000). Since 2.16
             */
            static TOO_MANY_SUBPATTERNS: number;
            /**
             * Octal value is greater than "\\377".
             *     Since 2.16
             */
            static INVALID_OCTAL_VALUE: number;
            /**
             * "DEFINE" group contains more
             *     than one branch. Since 2.16
             */
            static TOO_MANY_BRANCHES_IN_DEFINE: number;
            /**
             * Repeating a "DEFINE" group is not allowed.
             *     This error is never raised. Since: 2.16 Deprecated: 2.34
             */
            static DEFINE_REPETION: number;
            /**
             * Inconsistent newline options.
             *     Since 2.16
             */
            static INCONSISTENT_NEWLINE_OPTIONS: number;
            /**
             * "\\g" is not followed by a braced,
             *      angle-bracketed, or quoted name or number, or by a plain number. Since: 2.16
             */
            static MISSING_BACK_REFERENCE: number;
            /**
             * relative reference must not be zero. Since: 2.34
             */
            static INVALID_RELATIVE_REFERENCE: number;
            /**
             * the backtracing
             *     control verb used does not allow an argument. Since: 2.34
             */
            static BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN: number;
            /**
             * unknown backtracing
             *     control verb. Since: 2.34
             */
            static UNKNOWN_BACKTRACKING_CONTROL_VERB: number;
            /**
             * number is too big in escape sequence. Since: 2.34
             */
            static NUMBER_TOO_BIG: number;
            /**
             * Missing subpattern name. Since: 2.34
             */
            static MISSING_SUBPATTERN_NAME: number;
            /**
             * Missing digit. Since 2.34
             */
            static MISSING_DIGIT: number;
            /**
             * In JavaScript compatibility mode,
             *     "[" is an invalid data character. Since: 2.34
             */
            static INVALID_DATA_CHARACTER: number;
            /**
             * different names for subpatterns of the
             *     same number are not allowed. Since: 2.34
             */
            static EXTRA_SUBPATTERN_NAME: number;
            /**
             * the backtracing control
             *     verb requires an argument. Since: 2.34
             */
            static BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED: number;
            /**
             * "\\c" must be followed by an ASCII
             *     character. Since: 2.34
             */
            static INVALID_CONTROL_CHAR: number;
            /**
             * "\\k" is not followed by a braced, angle-bracketed, or
             *     quoted name. Since: 2.34
             */
            static MISSING_NAME: number;
            /**
             * "\\N" is not supported in a class. Since: 2.34
             */
            static NOT_SUPPORTED_IN_CLASS: number;
            /**
             * too many forward references. Since: 2.34
             */
            static TOO_MANY_FORWARD_REFERENCES: number;
            /**
             * the name is too long in "(*MARK)", "(*PRUNE)",
             *     "(*SKIP)", or "(*THEN)". Since: 2.34
             */
            static NAME_TOO_LONG: number;
            /**
             * the character value in the \\u sequence is
             *     too large. Since: 2.34
             */
            static CHARACTER_VALUE_TOO_LARGE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * An enumeration specifying the base position for a
         * g_io_channel_seek_position() operation.
         */

        /**
         * An enumeration specifying the base position for a
         * g_io_channel_seek_position() operation.
         */
        export namespace SeekType {
            export const $gtype: GObject.GType<SeekType>;
        }

        enum SeekType {
            /**
             * the current position in the file.
             */
            CUR,
            /**
             * the start of the file.
             */
            SET,
            /**
             * the end of the file.
             */
            END,
        }
        /**
         * Error codes returned by shell functions.
         */
        class ShellError extends Error {
            static $gtype: GObject.GType<ShellError>;

            // Static fields

            /**
             * Mismatched or otherwise mangled quoting.
             */
            static BAD_QUOTING: number;
            /**
             * String to be parsed was empty.
             */
            static EMPTY_STRING: number;
            /**
             * Some other error.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        export namespace SliceConfig {
            export const $gtype: GObject.GType<SliceConfig>;
        }

        enum SliceConfig {
            ALWAYS_MALLOC,
            BYPASS_MAGAZINES,
            WORKING_SET_MSECS,
            COLOR_INCREMENT,
            CHUNK_SIZES,
            CONTENTION_COUNTER,
        }
        /**
         * Error codes returned by spawning processes.
         */
        class SpawnError extends Error {
            static $gtype: GObject.GType<SpawnError>;

            // Static fields

            /**
             * Fork failed due to lack of memory.
             */
            static FORK: number;
            /**
             * Read or select on pipes failed.
             */
            static READ: number;
            /**
             * Changing to working directory failed.
             */
            static CHDIR: number;
            /**
             * execv() returned `EACCES`
             */
            static ACCES: number;
            /**
             * execv() returned `EPERM`
             */
            static PERM: number;
            /**
             * execv() returned `E2BIG`
             */
            static TOO_BIG: number;
            /**
             * deprecated alias for %G_SPAWN_ERROR_TOO_BIG (deprecated since GLib 2.32)
             */
            static '2BIG': number;
            /**
             * execv() returned `ENOEXEC`
             */
            static NOEXEC: number;
            /**
             * execv() returned `ENAMETOOLONG`
             */
            static NAMETOOLONG: number;
            /**
             * execv() returned `ENOENT`
             */
            static NOENT: number;
            /**
             * execv() returned `ENOMEM`
             */
            static NOMEM: number;
            /**
             * execv() returned `ENOTDIR`
             */
            static NOTDIR: number;
            /**
             * execv() returned `ELOOP`
             */
            static LOOP: number;
            /**
             * execv() returned `ETXTBUSY`
             */
            static TXTBUSY: number;
            /**
             * execv() returned `EIO`
             */
            static IO: number;
            /**
             * execv() returned `ENFILE`
             */
            static NFILE: number;
            /**
             * execv() returned `EMFILE`
             */
            static MFILE: number;
            /**
             * execv() returned `EINVAL`
             */
            static INVAL: number;
            /**
             * execv() returned `EISDIR`
             */
            static ISDIR: number;
            /**
             * execv() returned `ELIBBAD`
             */
            static LIBBAD: number;
            /**
             * Some other fatal failure,
             *   `error->message` should explain.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * The type of file to return the filename for, when used with
         * [func`GLib`.test_build_filename].
         *
         * These two options correspond rather directly to the 'dist' and
         * 'built' terminology that automake uses and are explicitly used to
         * distinguish between the 'srcdir' and 'builddir' being separate. All
         * files in your project should either be dist (in the `EXTRA_DIST` or
         * `dist_schema_DATA` sense, in which case they will always be in the
         * srcdir) or built (in the `BUILT_SOURCES` sense, in which case they
         * will always be in the builddir).
         *
         * Note: As a general rule of automake, files that are generated only as
         * part of the build-from-git process (but then are distributed with the
         * tarball) always go in srcdir (even if doing a srcdir != builddir
         * build from git) and are considered as distributed files.
         *
         * The same principles apply for other build systems, such as meson.
         */

        /**
         * The type of file to return the filename for, when used with
         * [func`GLib`.test_build_filename].
         *
         * These two options correspond rather directly to the 'dist' and
         * 'built' terminology that automake uses and are explicitly used to
         * distinguish between the 'srcdir' and 'builddir' being separate. All
         * files in your project should either be dist (in the `EXTRA_DIST` or
         * `dist_schema_DATA` sense, in which case they will always be in the
         * srcdir) or built (in the `BUILT_SOURCES` sense, in which case they
         * will always be in the builddir).
         *
         * Note: As a general rule of automake, files that are generated only as
         * part of the build-from-git process (but then are distributed with the
         * tarball) always go in srcdir (even if doing a srcdir != builddir
         * build from git) and are considered as distributed files.
         *
         * The same principles apply for other build systems, such as meson.
         */
        export namespace TestFileType {
            export const $gtype: GObject.GType<TestFileType>;
        }

        enum TestFileType {
            /**
             * a file that was included in the distribution tarball
             */
            DIST,
            /**
             * a file that was built on the compiling machine
             */
            BUILT,
        }

        export namespace TestLogType {
            export const $gtype: GObject.GType<TestLogType>;
        }

        enum TestLogType {
            NONE,
            ERROR,
            START_BINARY,
            LIST_CASE,
            SKIP_CASE,
            START_CASE,
            STOP_CASE,
            MIN_RESULT,
            MAX_RESULT,
            MESSAGE,
            START_SUITE,
            STOP_SUITE,
        }

        export namespace TestResult {
            export const $gtype: GObject.GType<TestResult>;
        }

        enum TestResult {
            SUCCESS,
            SKIPPED,
            FAILURE,
            INCOMPLETE,
        }
        /**
         * Possible errors of thread related functions.
         */
        class ThreadError extends Error {
            static $gtype: GObject.GType<ThreadError>;

            // Static fields

            /**
             * a thread couldn't be created due to resource
             *                        shortage. Try again later.
             */
            static THREAD_ERROR_AGAIN: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Thread priorities.
         */

        /**
         * Thread priorities.
         */
        export namespace ThreadPriority {
            export const $gtype: GObject.GType<ThreadPriority>;
        }

        enum ThreadPriority {
            /**
             * a priority lower than normal
             */
            LOW,
            /**
             * the default priority
             */
            NORMAL,
            /**
             * a priority higher than normal
             */
            HIGH,
            /**
             * the highest priority
             */
            URGENT,
        }
        /**
         * Disambiguates a given time in two ways.
         *
         * First, specifies if the given time is in universal or local time.
         *
         * Second, if the time is in local time, specifies if it is local
         * standard time or local daylight time.  This is important for the case
         * where the same local time occurs twice (during daylight savings time
         * transitions, for example).
         */

        /**
         * Disambiguates a given time in two ways.
         *
         * First, specifies if the given time is in universal or local time.
         *
         * Second, if the time is in local time, specifies if it is local
         * standard time or local daylight time.  This is important for the case
         * where the same local time occurs twice (during daylight savings time
         * transitions, for example).
         */
        export namespace TimeType {
            export const $gtype: GObject.GType<TimeType>;
        }

        enum TimeType {
            /**
             * the time is in local standard time
             */
            STANDARD,
            /**
             * the time is in local daylight time
             */
            DAYLIGHT,
            /**
             * the time is in UTC
             */
            UNIVERSAL,
        }
        /**
         * The possible types of token returned from each
         * g_scanner_get_next_token() call.
         */

        /**
         * The possible types of token returned from each
         * g_scanner_get_next_token() call.
         */
        export namespace TokenType {
            export const $gtype: GObject.GType<TokenType>;
        }

        enum TokenType {
            /**
             * the end of the file
             */
            EOF,
            /**
             * a '(' character
             */
            LEFT_PAREN,
            /**
             * a ')' character
             */
            RIGHT_PAREN,
            /**
             * a '{' character
             */
            LEFT_CURLY,
            /**
             * a '}' character
             */
            RIGHT_CURLY,
            /**
             * a '[' character
             */
            LEFT_BRACE,
            /**
             * a ']' character
             */
            RIGHT_BRACE,
            /**
             * a '=' character
             */
            EQUAL_SIGN,
            /**
             * a ',' character
             */
            COMMA,
            /**
             * not a token
             */
            NONE,
            /**
             * an error occurred
             */
            ERROR,
            /**
             * a character
             */
            CHAR,
            /**
             * a binary integer
             */
            BINARY,
            /**
             * an octal integer
             */
            OCTAL,
            /**
             * an integer
             */
            INT,
            /**
             * a hex integer
             */
            HEX,
            /**
             * a floating point number
             */
            FLOAT,
            /**
             * a string
             */
            STRING,
            /**
             * a symbol
             */
            SYMBOL,
            /**
             * an identifier
             */
            IDENTIFIER,
            /**
             * a null identifier
             */
            IDENTIFIER_NULL,
            /**
             * one line comment
             */
            COMMENT_SINGLE,
            /**
             * multi line comment
             */
            COMMENT_MULTI,
        }
        /**
         * Specifies the type of traversal performed by g_tree_traverse(),
         * g_node_traverse() and g_node_find().
         *
         * The different orders are illustrated here:
         *
         * - In order: A, B, C, D, E, F, G, H, I
         *   <picture>
         *     <source srcset="Sorted_binary_tree_inorder-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_inorder.svg"
         *      alt="Sorted binary tree, in-order traversal">
         *   </picture>
         * - Pre order: F, B, A, D, C, E, G, I, H
         *   <picture>
         *     <source srcset="Sorted_binary_tree_preorder-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_preorder.svg"
         *      alt="Sorted binary tree, pre-order traversal">
         *   </picture>
         * - Post order: A, C, E, D, B, H, I, G, F
         *   <picture>
         *     <source srcset="Sorted_binary_tree_postorder-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_postorder.svg"
         *      alt="Sorted binary tree, post-order traversal">
         *   </picture>
         * - Level order: F, B, G, A, D, I, C, E, H
         *   <picture>
         *     <source srcset="Sorted_binary_tree_breadth-first_traversal-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_breadth-first_traversal.svg"
         *      alt="Sorted binary tree, breadth-first level order traversal">
         *   </picture>
         */

        /**
         * Specifies the type of traversal performed by g_tree_traverse(),
         * g_node_traverse() and g_node_find().
         *
         * The different orders are illustrated here:
         *
         * - In order: A, B, C, D, E, F, G, H, I
         *   <picture>
         *     <source srcset="Sorted_binary_tree_inorder-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_inorder.svg"
         *      alt="Sorted binary tree, in-order traversal">
         *   </picture>
         * - Pre order: F, B, A, D, C, E, G, I, H
         *   <picture>
         *     <source srcset="Sorted_binary_tree_preorder-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_preorder.svg"
         *      alt="Sorted binary tree, pre-order traversal">
         *   </picture>
         * - Post order: A, C, E, D, B, H, I, G, F
         *   <picture>
         *     <source srcset="Sorted_binary_tree_postorder-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_postorder.svg"
         *      alt="Sorted binary tree, post-order traversal">
         *   </picture>
         * - Level order: F, B, G, A, D, I, C, E, H
         *   <picture>
         *     <source srcset="Sorted_binary_tree_breadth-first_traversal-dark.svg"
         *      media="(prefers-color-scheme: dark)">
         *     <img src="Sorted_binary_tree_breadth-first_traversal.svg"
         *      alt="Sorted binary tree, breadth-first level order traversal">
         *   </picture>
         */
        export namespace TraverseType {
            export const $gtype: GObject.GType<TraverseType>;
        }

        enum TraverseType {
            /**
             * visits a node's left child first, then the node itself,
             *              then its right child. This is the one to use if you
             *              want the output sorted according to the compare
             *              function.
             */
            IN_ORDER,
            /**
             * visits a node, then its children.
             */
            PRE_ORDER,
            /**
             * visits the node's children, then the node itself.
             */
            POST_ORDER,
            /**
             * is not implemented for
             *              [balanced binary trees](data-structures.html#binary-trees).
             *              For [n-ary trees](data-structures.html#n-ary-trees), it
             *              visits the root node first, then its children, then
             *              its grandchildren, and so on. Note that this is less
             *              efficient than the other orders.
             */
            LEVEL_ORDER,
        }
        /**
         * These are the possible line break classifications.
         *
         * Since new Unicode versions may add new types here, applications should be ready
         * to handle unknown values. They may be regarded as %G_UNICODE_BREAK_UNKNOWN.
         *
         * See [Unicode Line Breaking Algorithm](https://www.unicode.org/reports/tr14/).
         */

        /**
         * These are the possible line break classifications.
         *
         * Since new Unicode versions may add new types here, applications should be ready
         * to handle unknown values. They may be regarded as %G_UNICODE_BREAK_UNKNOWN.
         *
         * See [Unicode Line Breaking Algorithm](https://www.unicode.org/reports/tr14/).
         */
        export namespace UnicodeBreakType {
            export const $gtype: GObject.GType<UnicodeBreakType>;
        }

        enum UnicodeBreakType {
            /**
             * Mandatory Break (BK)
             */
            MANDATORY,
            /**
             * Carriage Return (CR)
             */
            CARRIAGE_RETURN,
            /**
             * Line Feed (LF)
             */
            LINE_FEED,
            /**
             * Attached Characters and Combining Marks (CM)
             */
            COMBINING_MARK,
            /**
             * Surrogates (SG)
             */
            SURROGATE,
            /**
             * Zero Width Space (ZW)
             */
            ZERO_WIDTH_SPACE,
            /**
             * Inseparable (IN)
             */
            INSEPARABLE,
            /**
             * Non-breaking ("Glue") (GL)
             */
            NON_BREAKING_GLUE,
            /**
             * Contingent Break Opportunity (CB)
             */
            CONTINGENT,
            /**
             * Space (SP)
             */
            SPACE,
            /**
             * Break Opportunity After (BA)
             */
            AFTER,
            /**
             * Break Opportunity Before (BB)
             */
            BEFORE,
            /**
             * Break Opportunity Before and After (B2)
             */
            BEFORE_AND_AFTER,
            /**
             * Hyphen (HY)
             */
            HYPHEN,
            /**
             * Nonstarter (NS)
             */
            NON_STARTER,
            /**
             * Opening Punctuation (OP)
             */
            OPEN_PUNCTUATION,
            /**
             * Closing Punctuation (CL)
             */
            CLOSE_PUNCTUATION,
            /**
             * Ambiguous Quotation (QU)
             */
            QUOTATION,
            /**
             * Exclamation/Interrogation (EX)
             */
            EXCLAMATION,
            /**
             * Ideographic (ID)
             */
            IDEOGRAPHIC,
            /**
             * Numeric (NU)
             */
            NUMERIC,
            /**
             * Infix Separator (Numeric) (IS)
             */
            INFIX_SEPARATOR,
            /**
             * Symbols Allowing Break After (SY)
             */
            SYMBOL,
            /**
             * Ordinary Alphabetic and Symbol Characters (AL)
             */
            ALPHABETIC,
            /**
             * Prefix (Numeric) (PR)
             */
            PREFIX,
            /**
             * Postfix (Numeric) (PO)
             */
            POSTFIX,
            /**
             * Complex Content Dependent (South East Asian) (SA)
             */
            COMPLEX_CONTEXT,
            /**
             * Ambiguous (Alphabetic or Ideographic) (AI)
             */
            AMBIGUOUS,
            /**
             * Unknown (XX)
             */
            UNKNOWN,
            /**
             * Next Line (NL)
             */
            NEXT_LINE,
            /**
             * Word Joiner (WJ)
             */
            WORD_JOINER,
            /**
             * Hangul L Jamo (JL)
             */
            HANGUL_L_JAMO,
            /**
             * Hangul V Jamo (JV)
             */
            HANGUL_V_JAMO,
            /**
             * Hangul T Jamo (JT)
             */
            HANGUL_T_JAMO,
            /**
             * Hangul LV Syllable (H2)
             */
            HANGUL_LV_SYLLABLE,
            /**
             * Hangul LVT Syllable (H3)
             */
            HANGUL_LVT_SYLLABLE,
            /**
             * Closing Parenthesis (CP). Since 2.28. Deprecated: 2.70: Use %G_UNICODE_BREAK_CLOSE_PARENTHESIS instead.
             */
            CLOSE_PARANTHESIS,
            /**
             * Closing Parenthesis (CP). Since 2.70
             */
            CLOSE_PARENTHESIS,
            /**
             * Conditional Japanese Starter (CJ). Since: 2.32
             */
            CONDITIONAL_JAPANESE_STARTER,
            /**
             * Hebrew Letter (HL). Since: 2.32
             */
            HEBREW_LETTER,
            /**
             * Regional Indicator (RI). Since: 2.36
             */
            REGIONAL_INDICATOR,
            /**
             * Emoji Base (EB). Since: 2.50
             */
            EMOJI_BASE,
            /**
             * Emoji Modifier (EM). Since: 2.50
             */
            EMOJI_MODIFIER,
            /**
             * Zero Width Joiner (ZWJ). Since: 2.50
             */
            ZERO_WIDTH_JOINER,
            /**
             * Aksara (AK). Since: 2.80
             */
            AKSARA,
            /**
             * Aksara Pre-Base (AP). Since: 2.80
             */
            AKSARA_PRE_BASE,
            /**
             * Aksara Start (AS). Since: 2.80
             */
            AKSARA_START,
            /**
             * Virama Final (VF). Since: 2.80
             */
            VIRAMA_FINAL,
            /**
             * Virama (VI). Since: 2.80
             */
            VIRAMA,
        }
        /**
         * The #GUnicodeScript enumeration identifies different writing
         * systems. The values correspond to the names as defined in the
         * Unicode standard. The enumeration has been added in GLib 2.14,
         * and is interchangeable with #PangoScript.
         *
         * Note that new types may be added in the future. Applications
         * should be ready to handle unknown values.
         * See [Unicode Standard Annex #24: Script names](http://www.unicode.org/reports/tr24/).
         */

        /**
         * The #GUnicodeScript enumeration identifies different writing
         * systems. The values correspond to the names as defined in the
         * Unicode standard. The enumeration has been added in GLib 2.14,
         * and is interchangeable with #PangoScript.
         *
         * Note that new types may be added in the future. Applications
         * should be ready to handle unknown values.
         * See [Unicode Standard Annex #24: Script names](http://www.unicode.org/reports/tr24/).
         */
        export namespace UnicodeScript {
            export const $gtype: GObject.GType<UnicodeScript>;
        }

        enum UnicodeScript {
            /**
             * a value never returned from g_unichar_get_script()
             */
            INVALID_CODE,
            /**
             * a character used by multiple different scripts
             */
            COMMON,
            /**
             * a mark glyph that takes its script from the
             *                               base glyph to which it is attached
             */
            INHERITED,
            /**
             * Arabic
             */
            ARABIC,
            /**
             * Armenian
             */
            ARMENIAN,
            /**
             * Bengali
             */
            BENGALI,
            /**
             * Bopomofo
             */
            BOPOMOFO,
            /**
             * Cherokee
             */
            CHEROKEE,
            /**
             * Coptic
             */
            COPTIC,
            /**
             * Cyrillic
             */
            CYRILLIC,
            /**
             * Deseret
             */
            DESERET,
            /**
             * Devanagari
             */
            DEVANAGARI,
            /**
             * Ethiopic
             */
            ETHIOPIC,
            /**
             * Georgian
             */
            GEORGIAN,
            /**
             * Gothic
             */
            GOTHIC,
            /**
             * Greek
             */
            GREEK,
            /**
             * Gujarati
             */
            GUJARATI,
            /**
             * Gurmukhi
             */
            GURMUKHI,
            /**
             * Han
             */
            HAN,
            /**
             * Hangul
             */
            HANGUL,
            /**
             * Hebrew
             */
            HEBREW,
            /**
             * Hiragana
             */
            HIRAGANA,
            /**
             * Kannada
             */
            KANNADA,
            /**
             * Katakana
             */
            KATAKANA,
            /**
             * Khmer
             */
            KHMER,
            /**
             * Lao
             */
            LAO,
            /**
             * Latin
             */
            LATIN,
            /**
             * Malayalam
             */
            MALAYALAM,
            /**
             * Mongolian
             */
            MONGOLIAN,
            /**
             * Myanmar
             */
            MYANMAR,
            /**
             * Ogham
             */
            OGHAM,
            /**
             * Old Italic
             */
            OLD_ITALIC,
            /**
             * Oriya
             */
            ORIYA,
            /**
             * Runic
             */
            RUNIC,
            /**
             * Sinhala
             */
            SINHALA,
            /**
             * Syriac
             */
            SYRIAC,
            /**
             * Tamil
             */
            TAMIL,
            /**
             * Telugu
             */
            TELUGU,
            /**
             * Thaana
             */
            THAANA,
            /**
             * Thai
             */
            THAI,
            /**
             * Tibetan
             */
            TIBETAN,
            /**
             * Canadian Aboriginal
             */
            CANADIAN_ABORIGINAL,
            /**
             * Yi
             */
            YI,
            /**
             * Tagalog
             */
            TAGALOG,
            /**
             * Hanunoo
             */
            HANUNOO,
            /**
             * Buhid
             */
            BUHID,
            /**
             * Tagbanwa
             */
            TAGBANWA,
            /**
             * Braille
             */
            BRAILLE,
            /**
             * Cypriot
             */
            CYPRIOT,
            /**
             * Limbu
             */
            LIMBU,
            /**
             * Osmanya
             */
            OSMANYA,
            /**
             * Shavian
             */
            SHAVIAN,
            /**
             * Linear B
             */
            LINEAR_B,
            /**
             * Tai Le
             */
            TAI_LE,
            /**
             * Ugaritic
             */
            UGARITIC,
            /**
             * New Tai Lue
             */
            NEW_TAI_LUE,
            /**
             * Buginese
             */
            BUGINESE,
            /**
             * Glagolitic
             */
            GLAGOLITIC,
            /**
             * Tifinagh
             */
            TIFINAGH,
            /**
             * Syloti Nagri
             */
            SYLOTI_NAGRI,
            /**
             * Old Persian
             */
            OLD_PERSIAN,
            /**
             * Kharoshthi
             */
            KHAROSHTHI,
            /**
             * an unassigned code point
             */
            UNKNOWN,
            /**
             * Balinese
             */
            BALINESE,
            /**
             * Cuneiform
             */
            CUNEIFORM,
            /**
             * Phoenician
             */
            PHOENICIAN,
            /**
             * Phags-pa
             */
            PHAGS_PA,
            /**
             * N'Ko
             */
            NKO,
            /**
             * Kayah Li. Since 2.16.3
             */
            KAYAH_LI,
            /**
             * Lepcha. Since 2.16.3
             */
            LEPCHA,
            /**
             * Rejang. Since 2.16.3
             */
            REJANG,
            /**
             * Sundanese. Since 2.16.3
             */
            SUNDANESE,
            /**
             * Saurashtra. Since 2.16.3
             */
            SAURASHTRA,
            /**
             * Cham. Since 2.16.3
             */
            CHAM,
            /**
             * Ol Chiki. Since 2.16.3
             */
            OL_CHIKI,
            /**
             * Vai. Since 2.16.3
             */
            VAI,
            /**
             * Carian. Since 2.16.3
             */
            CARIAN,
            /**
             * Lycian. Since 2.16.3
             */
            LYCIAN,
            /**
             * Lydian. Since 2.16.3
             */
            LYDIAN,
            /**
             * Avestan. Since 2.26
             */
            AVESTAN,
            /**
             * Bamum. Since 2.26
             */
            BAMUM,
            /**
             * Egyptian Hieroglpyhs. Since 2.26
             */
            EGYPTIAN_HIEROGLYPHS,
            /**
             * Imperial Aramaic. Since 2.26
             */
            IMPERIAL_ARAMAIC,
            /**
             * Inscriptional Pahlavi. Since 2.26
             */
            INSCRIPTIONAL_PAHLAVI,
            /**
             * Inscriptional Parthian. Since 2.26
             */
            INSCRIPTIONAL_PARTHIAN,
            /**
             * Javanese. Since 2.26
             */
            JAVANESE,
            /**
             * Kaithi. Since 2.26
             */
            KAITHI,
            /**
             * Lisu. Since 2.26
             */
            LISU,
            /**
             * Meetei Mayek. Since 2.26
             */
            MEETEI_MAYEK,
            /**
             * Old South Arabian. Since 2.26
             */
            OLD_SOUTH_ARABIAN,
            /**
             * Old Turkic. Since 2.28
             */
            OLD_TURKIC,
            /**
             * Samaritan. Since 2.26
             */
            SAMARITAN,
            /**
             * Tai Tham. Since 2.26
             */
            TAI_THAM,
            /**
             * Tai Viet. Since 2.26
             */
            TAI_VIET,
            /**
             * Batak. Since 2.28
             */
            BATAK,
            /**
             * Brahmi. Since 2.28
             */
            BRAHMI,
            /**
             * Mandaic. Since 2.28
             */
            MANDAIC,
            /**
             * Chakma. Since: 2.32
             */
            CHAKMA,
            /**
             * Meroitic Cursive. Since: 2.32
             */
            MEROITIC_CURSIVE,
            /**
             * Meroitic Hieroglyphs. Since: 2.32
             */
            MEROITIC_HIEROGLYPHS,
            /**
             * Miao. Since: 2.32
             */
            MIAO,
            /**
             * Sharada. Since: 2.32
             */
            SHARADA,
            /**
             * Sora Sompeng. Since: 2.32
             */
            SORA_SOMPENG,
            /**
             * Takri. Since: 2.32
             */
            TAKRI,
            /**
             * Bassa. Since: 2.42
             */
            BASSA_VAH,
            /**
             * Caucasian Albanian. Since: 2.42
             */
            CAUCASIAN_ALBANIAN,
            /**
             * Duployan. Since: 2.42
             */
            DUPLOYAN,
            /**
             * Elbasan. Since: 2.42
             */
            ELBASAN,
            /**
             * Grantha. Since: 2.42
             */
            GRANTHA,
            /**
             * Kjohki. Since: 2.42
             */
            KHOJKI,
            /**
             * Khudawadi, Sindhi. Since: 2.42
             */
            KHUDAWADI,
            /**
             * Linear A. Since: 2.42
             */
            LINEAR_A,
            /**
             * Mahajani. Since: 2.42
             */
            MAHAJANI,
            /**
             * Manichaean. Since: 2.42
             */
            MANICHAEAN,
            /**
             * Mende Kikakui. Since: 2.42
             */
            MENDE_KIKAKUI,
            /**
             * Modi. Since: 2.42
             */
            MODI,
            /**
             * Mro. Since: 2.42
             */
            MRO,
            /**
             * Nabataean. Since: 2.42
             */
            NABATAEAN,
            /**
             * Old North Arabian. Since: 2.42
             */
            OLD_NORTH_ARABIAN,
            /**
             * Old Permic. Since: 2.42
             */
            OLD_PERMIC,
            /**
             * Pahawh Hmong. Since: 2.42
             */
            PAHAWH_HMONG,
            /**
             * Palmyrene. Since: 2.42
             */
            PALMYRENE,
            /**
             * Pau Cin Hau. Since: 2.42
             */
            PAU_CIN_HAU,
            /**
             * Psalter Pahlavi. Since: 2.42
             */
            PSALTER_PAHLAVI,
            /**
             * Siddham. Since: 2.42
             */
            SIDDHAM,
            /**
             * Tirhuta. Since: 2.42
             */
            TIRHUTA,
            /**
             * Warang Citi. Since: 2.42
             */
            WARANG_CITI,
            /**
             * Ahom. Since: 2.48
             */
            AHOM,
            /**
             * Anatolian Hieroglyphs. Since: 2.48
             */
            ANATOLIAN_HIEROGLYPHS,
            /**
             * Hatran. Since: 2.48
             */
            HATRAN,
            /**
             * Multani. Since: 2.48
             */
            MULTANI,
            /**
             * Old Hungarian. Since: 2.48
             */
            OLD_HUNGARIAN,
            /**
             * Signwriting. Since: 2.48
             */
            SIGNWRITING,
            /**
             * Adlam. Since: 2.50
             */
            ADLAM,
            /**
             * Bhaiksuki. Since: 2.50
             */
            BHAIKSUKI,
            /**
             * Marchen. Since: 2.50
             */
            MARCHEN,
            /**
             * Newa. Since: 2.50
             */
            NEWA,
            /**
             * Osage. Since: 2.50
             */
            OSAGE,
            /**
             * Tangut. Since: 2.50
             */
            TANGUT,
            /**
             * Masaram Gondi. Since: 2.54
             */
            MASARAM_GONDI,
            /**
             * Nushu. Since: 2.54
             */
            NUSHU,
            /**
             * Soyombo. Since: 2.54
             */
            SOYOMBO,
            /**
             * Zanabazar Square. Since: 2.54
             */
            ZANABAZAR_SQUARE,
            /**
             * Dogra. Since: 2.58
             */
            DOGRA,
            /**
             * Gunjala Gondi. Since: 2.58
             */
            GUNJALA_GONDI,
            /**
             * Hanifi Rohingya. Since: 2.58
             */
            HANIFI_ROHINGYA,
            /**
             * Makasar. Since: 2.58
             */
            MAKASAR,
            /**
             * Medefaidrin. Since: 2.58
             */
            MEDEFAIDRIN,
            /**
             * Old Sogdian. Since: 2.58
             */
            OLD_SOGDIAN,
            /**
             * Sogdian. Since: 2.58
             */
            SOGDIAN,
            /**
             * Elym. Since: 2.62
             */
            ELYMAIC,
            /**
             * Nand. Since: 2.62
             */
            NANDINAGARI,
            /**
             * Rohg. Since: 2.62
             */
            NYIAKENG_PUACHUE_HMONG,
            /**
             * Wcho. Since: 2.62
             */
            WANCHO,
            /**
             * Chorasmian. Since: 2.66
             */
            CHORASMIAN,
            /**
             * Dives Akuru. Since: 2.66
             */
            DIVES_AKURU,
            /**
             * Khitan small script. Since: 2.66
             */
            KHITAN_SMALL_SCRIPT,
            /**
             * Yezidi. Since: 2.66
             */
            YEZIDI,
            /**
             * Cypro-Minoan. Since: 2.72
             */
            CYPRO_MINOAN,
            /**
             * Old Uyghur. Since: 2.72
             */
            OLD_UYGHUR,
            /**
             * Tangsa. Since: 2.72
             */
            TANGSA,
            /**
             * Toto. Since: 2.72
             */
            TOTO,
            /**
             * Vithkuqi. Since: 2.72
             */
            VITHKUQI,
            /**
             * Mathematical notation. Since: 2.72
             */
            MATH,
            /**
             * Kawi. Since 2.74
             */
            KAWI,
            /**
             * Nag Mundari. Since 2.74
             */
            NAG_MUNDARI,
            /**
             * Todhri. Since: 2.84
             */
            TODHRI,
            /**
             * Garay. Since: 2.84
             */
            GARAY,
            /**
             * Tulu-Tigalari. Since: 2.84
             */
            TULU_TIGALARI,
            /**
             * Sunuwar. Since: 2.84
             */
            SUNUWAR,
            /**
             * Gurung Khema. Since: 2.84
             */
            GURUNG_KHEMA,
            /**
             * Kirat Rai. Since: 2.84
             */
            KIRAT_RAI,
            /**
             * Ol Onal. Since: 2.84
             */
            OL_ONAL,
        }
        /**
         * These are the possible character classifications from the
         * Unicode specification.
         * See [Unicode Character Database](http://www.unicode.org/reports/tr44/#General_Category_Values).
         */

        /**
         * These are the possible character classifications from the
         * Unicode specification.
         * See [Unicode Character Database](http://www.unicode.org/reports/tr44/#General_Category_Values).
         */
        export namespace UnicodeType {
            export const $gtype: GObject.GType<UnicodeType>;
        }

        enum UnicodeType {
            /**
             * General category "Other, Control" (Cc)
             */
            CONTROL,
            /**
             * General category "Other, Format" (Cf)
             */
            FORMAT,
            /**
             * General category "Other, Not Assigned" (Cn)
             */
            UNASSIGNED,
            /**
             * General category "Other, Private Use" (Co)
             */
            PRIVATE_USE,
            /**
             * General category "Other, Surrogate" (Cs)
             */
            SURROGATE,
            /**
             * General category "Letter, Lowercase" (Ll)
             */
            LOWERCASE_LETTER,
            /**
             * General category "Letter, Modifier" (Lm)
             */
            MODIFIER_LETTER,
            /**
             * General category "Letter, Other" (Lo)
             */
            OTHER_LETTER,
            /**
             * General category "Letter, Titlecase" (Lt)
             */
            TITLECASE_LETTER,
            /**
             * General category "Letter, Uppercase" (Lu)
             */
            UPPERCASE_LETTER,
            /**
             * General category "Mark, Spacing" (Mc)
             */
            SPACING_MARK,
            /**
             * General category "Mark, Enclosing" (Me)
             */
            ENCLOSING_MARK,
            /**
             * General category "Mark, Nonspacing" (Mn)
             */
            NON_SPACING_MARK,
            /**
             * General category "Number, Decimal Digit" (Nd)
             */
            DECIMAL_NUMBER,
            /**
             * General category "Number, Letter" (Nl)
             */
            LETTER_NUMBER,
            /**
             * General category "Number, Other" (No)
             */
            OTHER_NUMBER,
            /**
             * General category "Punctuation, Connector" (Pc)
             */
            CONNECT_PUNCTUATION,
            /**
             * General category "Punctuation, Dash" (Pd)
             */
            DASH_PUNCTUATION,
            /**
             * General category "Punctuation, Close" (Pe)
             */
            CLOSE_PUNCTUATION,
            /**
             * General category "Punctuation, Final quote" (Pf)
             */
            FINAL_PUNCTUATION,
            /**
             * General category "Punctuation, Initial quote" (Pi)
             */
            INITIAL_PUNCTUATION,
            /**
             * General category "Punctuation, Other" (Po)
             */
            OTHER_PUNCTUATION,
            /**
             * General category "Punctuation, Open" (Ps)
             */
            OPEN_PUNCTUATION,
            /**
             * General category "Symbol, Currency" (Sc)
             */
            CURRENCY_SYMBOL,
            /**
             * General category "Symbol, Modifier" (Sk)
             */
            MODIFIER_SYMBOL,
            /**
             * General category "Symbol, Math" (Sm)
             */
            MATH_SYMBOL,
            /**
             * General category "Symbol, Other" (So)
             */
            OTHER_SYMBOL,
            /**
             * General category "Separator, Line" (Zl)
             */
            LINE_SEPARATOR,
            /**
             * General category "Separator, Paragraph" (Zp)
             */
            PARAGRAPH_SEPARATOR,
            /**
             * General category "Separator, Space" (Zs)
             */
            SPACE_SEPARATOR,
        }
        /**
         * Mnemonic constants for the ends of a Unix pipe.
         */

        /**
         * Mnemonic constants for the ends of a Unix pipe.
         */
        export namespace UnixPipeEnd {
            export const $gtype: GObject.GType<UnixPipeEnd>;
        }

        enum UnixPipeEnd {
            /**
             * The readable file descriptor 0
             */
            READ,
            /**
             * The writable file descriptor 1
             */
            WRITE,
        }
        /**
         * Error codes returned by #GUri methods.
         */
        class UriError extends Error {
            static $gtype: GObject.GType<UriError>;

            // Static fields

            /**
             * Generic error if no more specific error is available.
             *     See the error message for details.
             */
            static FAILED: number;
            /**
             * The scheme of a URI could not be parsed.
             */
            static BAD_SCHEME: number;
            /**
             * The user/userinfo of a URI could not be parsed.
             */
            static BAD_USER: number;
            /**
             * The password of a URI could not be parsed.
             */
            static BAD_PASSWORD: number;
            /**
             * The authentication parameters of a URI could not be parsed.
             */
            static BAD_AUTH_PARAMS: number;
            /**
             * The host of a URI could not be parsed.
             */
            static BAD_HOST: number;
            /**
             * The port of a URI could not be parsed.
             */
            static BAD_PORT: number;
            /**
             * The path of a URI could not be parsed.
             */
            static BAD_PATH: number;
            /**
             * The query of a URI could not be parsed.
             */
            static BAD_QUERY: number;
            /**
             * The fragment of a URI could not be parsed.
             */
            static BAD_FRAGMENT: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * These are logical ids for special directories which are defined
         * depending on the platform used. You should use g_get_user_special_dir()
         * to retrieve the full path associated to the logical id.
         *
         * The #GUserDirectory enumeration can be extended at later date. Not
         * every platform has a directory for every logical id in this
         * enumeration.
         */

        /**
         * These are logical ids for special directories which are defined
         * depending on the platform used. You should use g_get_user_special_dir()
         * to retrieve the full path associated to the logical id.
         *
         * The #GUserDirectory enumeration can be extended at later date. Not
         * every platform has a directory for every logical id in this
         * enumeration.
         */
        export namespace UserDirectory {
            export const $gtype: GObject.GType<UserDirectory>;
        }

        enum UserDirectory {
            /**
             * the user's Desktop directory
             */
            DIRECTORY_DESKTOP,
            /**
             * the user's Documents directory
             */
            DIRECTORY_DOCUMENTS,
            /**
             * the user's Downloads directory
             */
            DIRECTORY_DOWNLOAD,
            /**
             * the user's Music directory
             */
            DIRECTORY_MUSIC,
            /**
             * the user's Pictures directory
             */
            DIRECTORY_PICTURES,
            /**
             * the user's shared directory
             */
            DIRECTORY_PUBLIC_SHARE,
            /**
             * the user's Templates directory
             */
            DIRECTORY_TEMPLATES,
            /**
             * the user's Movies directory
             */
            DIRECTORY_VIDEOS,
            /**
             * the number of enum values
             */
            N_DIRECTORIES,
        }
        /**
         * The range of possible top-level types of #GVariant instances.
         */

        /**
         * The range of possible top-level types of #GVariant instances.
         */
        export namespace VariantClass {
            export const $gtype: GObject.GType<VariantClass>;
        }

        enum VariantClass {
            /**
             * The #GVariant is a boolean.
             */
            BOOLEAN,
            /**
             * The #GVariant is a byte.
             */
            BYTE,
            /**
             * The #GVariant is a signed 16 bit integer.
             */
            INT16,
            /**
             * The #GVariant is an unsigned 16 bit integer.
             */
            UINT16,
            /**
             * The #GVariant is a signed 32 bit integer.
             */
            INT32,
            /**
             * The #GVariant is an unsigned 32 bit integer.
             */
            UINT32,
            /**
             * The #GVariant is a signed 64 bit integer.
             */
            INT64,
            /**
             * The #GVariant is an unsigned 64 bit integer.
             */
            UINT64,
            /**
             * The #GVariant is a file handle index.
             */
            HANDLE,
            /**
             * The #GVariant is a double precision floating
             *                          point value.
             */
            DOUBLE,
            /**
             * The #GVariant is a normal string.
             */
            STRING,
            /**
             * The #GVariant is a D-Bus object path
             *                               string.
             */
            OBJECT_PATH,
            /**
             * The #GVariant is a D-Bus signature string.
             */
            SIGNATURE,
            /**
             * The #GVariant is a variant.
             */
            VARIANT,
            /**
             * The #GVariant is a maybe-typed value.
             */
            MAYBE,
            /**
             * The #GVariant is an array.
             */
            ARRAY,
            /**
             * The #GVariant is a tuple.
             */
            TUPLE,
            /**
             * The #GVariant is a dictionary entry.
             */
            DICT_ENTRY,
        }
        /**
         * Error codes returned by parsing text-format GVariants.
         */
        class VariantParseError extends Error {
            static $gtype: GObject.GType<VariantParseError>;

            // Static fields

            /**
             * generic error (unused)
             */
            static FAILED: number;
            /**
             * a non-basic #GVariantType was given where a basic type was expected
             */
            static BASIC_TYPE_EXPECTED: number;
            /**
             * cannot infer the #GVariantType
             */
            static CANNOT_INFER_TYPE: number;
            /**
             * an indefinite #GVariantType was given where a definite type was expected
             */
            static DEFINITE_TYPE_EXPECTED: number;
            /**
             * extra data after parsing finished
             */
            static INPUT_NOT_AT_END: number;
            /**
             * invalid character in number or unicode escape
             */
            static INVALID_CHARACTER: number;
            /**
             * not a valid #GVariant format string
             */
            static INVALID_FORMAT_STRING: number;
            /**
             * not a valid object path
             */
            static INVALID_OBJECT_PATH: number;
            /**
             * not a valid type signature
             */
            static INVALID_SIGNATURE: number;
            /**
             * not a valid #GVariant type string
             */
            static INVALID_TYPE_STRING: number;
            /**
             * could not find a common type for array entries
             */
            static NO_COMMON_TYPE: number;
            /**
             * the numerical value is out of range of the given type
             */
            static NUMBER_OUT_OF_RANGE: number;
            /**
             * the numerical value is out of range for any type
             */
            static NUMBER_TOO_BIG: number;
            /**
             * cannot parse as variant of the specified type
             */
            static TYPE_ERROR: number;
            /**
             * an unexpected token was encountered
             */
            static UNEXPECTED_TOKEN: number;
            /**
             * an unknown keyword was encountered
             */
            static UNKNOWN_KEYWORD: number;
            /**
             * unterminated string constant
             */
            static UNTERMINATED_STRING_CONSTANT: number;
            /**
             * no value given
             */
            static VALUE_EXPECTED: number;
            /**
             * variant was too deeply nested; #GVariant is only guaranteed to handle nesting up to 64 levels (Since: 2.64)
             */
            static RECURSION: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        const ALLOCATOR_LIST: number;
        const ALLOCATOR_NODE: number;
        const ALLOCATOR_SLIST: number;
        const ALLOC_AND_FREE: number;
        const ALLOC_ONLY: number;
        const ANALYZER_ANALYZING: number;
        /**
         * A good size for a buffer to be passed into [func`GLib`.ascii_dtostr].
         * It is guaranteed to be enough for all output of that function
         * on systems with 64bit IEEE-compatible doubles.
         *
         * The typical usage would be something like:
         * ```C
         * char buf[G_ASCII_DTOSTR_BUF_SIZE];
         *
         * fprintf (out, "value=%s\n", g_ascii_dtostr (buf, sizeof (buf), value));
         * ```
         */
        const ASCII_DTOSTR_BUF_SIZE: number;
        /**
         * Evaluates to the initial reference count for `gatomicrefcount`.
         *
         * This macro is useful for initializing `gatomicrefcount` fields inside
         * structures, for instance:
         *
         *
         * ```c
         * typedef struct {
         *   gatomicrefcount ref_count;
         *   char *name;
         *   char *address;
         * } Person;
         *
         * static const Person default_person = {
         *   .ref_count = G_ATOMIC_REF_COUNT_INIT,
         *   .name = "Default name",
         *   .address = "Default address",
         * };
         * ```
         *
         */
        const ATOMIC_REF_COUNT_INIT: number;
        /**
         * Specifies one of the possible types of byte order.
         * See %G_BYTE_ORDER.
         */
        const BIG_ENDIAN: number;
        /**
         * The set of uppercase ASCII alphabet characters.
         * Used for specifying valid identifier characters
         * in #GScannerConfig.
         */
        const CSET_A_2_Z: string;
        /**
         * The set of ASCII digits.
         * Used for specifying valid identifier characters
         * in #GScannerConfig.
         */
        const CSET_DIGITS: string;
        /**
         * The set of lowercase ASCII alphabet characters.
         * Used for specifying valid identifier characters
         * in #GScannerConfig.
         */
        const CSET_a_2_z: string;
        /**
         * The C standard version the code is compiling against, it's normally
         * defined with the same value of `__STDC_VERSION__` for C standard
         * compatible compilers, while it uses the lowest standard version
         * in pure MSVC, given that in such compiler the definition depends on
         * a compilation flag.
         *
         * This is granted to be undefined when compiling with a C++ compiler.
         *
         * See also: %G_C_STD_CHECK_VERSION and %G_CXX_STD_VERSION
         */
        const C_STD_VERSION: number;
        /**
         * A bitmask that restricts the possible flags passed to
         * g_datalist_set_flags(). Passing a flags value where
         * flags & ~G_DATALIST_FLAGS_MASK != 0 is an error.
         */
        const DATALIST_FLAGS_MASK: number;
        /**
         * Represents an invalid #GDateDay.
         */
        const DATE_BAD_DAY: number;
        /**
         * Represents an invalid Julian day number.
         */
        const DATE_BAD_JULIAN: number;
        /**
         * Represents an invalid year.
         */
        const DATE_BAD_YEAR: number;
        /**
         * The directory separator character.
         *
         * This is `'/'` on UNIX machines and `'\'` under Windows.
         */
        const DIR_SEPARATOR: number;
        /**
         * The directory separator as a string.
         *
         * This is `"/"` on UNIX machines and `"\"` under Windows.
         */
        const DIR_SEPARATOR_S: string;
        /**
         * The base of natural logarithms.
         */
        const E: number;
        const GINT16_FORMAT: string;
        const GINT16_MODIFIER: string;
        const GINT32_FORMAT: string;
        const GINT32_MODIFIER: string;
        const GINT64_FORMAT: string;
        const GINT64_MODIFIER: string;
        const GINTPTR_FORMAT: string;
        const GINTPTR_MODIFIER: string;
        /**
         * Expands to "" on all modern compilers, and to  __FUNCTION__ on gcc
         * version 2.x. Don't use it.
         */
        const GNUC_FUNCTION: string;
        /**
         * Expands to "" on all modern compilers, and to __PRETTY_FUNCTION__
         * on gcc version 2.x. Don't use it.
         */
        const GNUC_PRETTY_FUNCTION: string;
        const GSIZE_FORMAT: string;
        const GSIZE_MODIFIER: string;
        const GSSIZE_FORMAT: string;
        const GSSIZE_MODIFIER: string;
        const GUINT16_FORMAT: string;
        const GUINT32_FORMAT: string;
        const GUINT64_FORMAT: string;
        const GUINTPTR_FORMAT: string;
        const HAVE_GINT64: number;
        const HAVE_GNUC_VARARGS: number;
        /**
         * Defined to 1 if gcc-style visibility handling is supported.
         */
        const HAVE_GNUC_VISIBILITY: number;
        const HAVE_GROWING_STACK: number;
        const HAVE_ISO_VARARGS: number;
        /**
         * The position of the first bit which is not reserved for internal
         * use be the #GHook implementation, i.e.
         * `1 << G_HOOK_FLAG_USER_SHIFT` is the first
         * bit which can be used for application-defined flags.
         */
        const HOOK_FLAG_USER_SHIFT: number;
        /**
         * The bias by which exponents in double-precision floats are offset.
         */
        const IEEE754_DOUBLE_BIAS: number;
        /**
         * The bias by which exponents in single-precision floats are offset.
         */
        const IEEE754_FLOAT_BIAS: number;
        /**
         * The name of the main group of a desktop entry file, as defined in the
         * [Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/).
         *
         * Consult the specification for more
         * details about the meanings of the keys below.
         */
        const KEY_FILE_DESKTOP_GROUP: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string list
         * giving the available application actions.
         */
        const KEY_FILE_DESKTOP_KEY_ACTIONS: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a list
         * of strings giving the categories in which the desktop entry
         * should be shown in a menu.
         */
        const KEY_FILE_DESKTOP_KEY_CATEGORIES: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a localized
         * string giving the tooltip for the desktop entry.
         */
        const KEY_FILE_DESKTOP_KEY_COMMENT: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
         * set to true if the application is D-Bus activatable.
         */
        const KEY_FILE_DESKTOP_KEY_DBUS_ACTIVATABLE: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string
         * giving the command line to execute.
         *
         * It is only valid for desktop entries with the `Application` type.
         */
        const KEY_FILE_DESKTOP_KEY_EXEC: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a localized
         * string giving the generic name of the desktop entry.
         */
        const KEY_FILE_DESKTOP_KEY_GENERIC_NAME: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
         * stating whether the desktop entry has been deleted by the user.
         */
        const KEY_FILE_DESKTOP_KEY_HIDDEN: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a localized
         * string giving the name of the icon to be displayed for the desktop
         * entry.
         */
        const KEY_FILE_DESKTOP_KEY_ICON: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a list
         * of strings giving the MIME types supported by this desktop entry.
         */
        const KEY_FILE_DESKTOP_KEY_MIME_TYPE: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a localized
         * string giving the specific name of the desktop entry.
         */
        const KEY_FILE_DESKTOP_KEY_NAME: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a list of
         * strings identifying the environments that should not display the
         * desktop entry.
         */
        const KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
         * stating whether the desktop entry should be shown in menus.
         */
        const KEY_FILE_DESKTOP_KEY_NO_DISPLAY: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a list of
         * strings identifying the environments that should display the
         * desktop entry.
         */
        const KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string
         * containing the working directory to run the program in.
         *
         * It is only valid for desktop entries with the `Application` type.
         */
        const KEY_FILE_DESKTOP_KEY_PATH: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
         * stating whether the application supports the
         * [Startup Notification Protocol Specification](https://specifications.freedesktop.org/startup-notification-spec/latest/).
         */
        const KEY_FILE_DESKTOP_KEY_STARTUP_NOTIFY: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is string
         * identifying the WM class or name hint of a window that the application
         * will create, which can be used to emulate
         * [Startup Notification](https://specifications.freedesktop.org/startup-notification-spec/latest/)
         * with older applications.
         */
        const KEY_FILE_DESKTOP_KEY_STARTUP_WM_CLASS: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a boolean
         * stating whether the program should be run in a terminal window.
         *
         * It is only valid for desktop entries with the `Application` type.
         */
        const KEY_FILE_DESKTOP_KEY_TERMINAL: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string
         * giving the file name of a binary on disk used to determine if the
         * program is actually installed.
         *
         * It is only valid for desktop entries with the `Application` type.
         */
        const KEY_FILE_DESKTOP_KEY_TRY_EXEC: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string
         * giving the type of the desktop entry.
         *
         * Usually [const`GLib`.KEY_FILE_DESKTOP_TYPE_APPLICATION],
         * [const`GLib`.KEY_FILE_DESKTOP_TYPE_LINK], or
         * [const`GLib`.KEY_FILE_DESKTOP_TYPE_DIRECTORY].
         */
        const KEY_FILE_DESKTOP_KEY_TYPE: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string
         * giving the URL to access.
         *
         * It is only valid for desktop entries with the `Link` type.
         */
        const KEY_FILE_DESKTOP_KEY_URL: string;
        /**
         * A key under [const`GLib`.KEY_FILE_DESKTOP_GROUP], whose value is a string
         * giving the version of the Desktop Entry Specification used for
         * the desktop entry file.
         */
        const KEY_FILE_DESKTOP_KEY_VERSION: string;
        /**
         * The value of the [const`GLib`.KEY_FILE_DESKTOP_KEY_TYPE], key for desktop
         * entries representing applications.
         */
        const KEY_FILE_DESKTOP_TYPE_APPLICATION: string;
        /**
         * The value of the [const`GLib`.KEY_FILE_DESKTOP_KEY_TYPE], key for desktop
         * entries representing directories.
         */
        const KEY_FILE_DESKTOP_TYPE_DIRECTORY: string;
        /**
         * The value of the [const`GLib`.KEY_FILE_DESKTOP_KEY_TYPE], key for desktop
         * entries representing links to documents.
         */
        const KEY_FILE_DESKTOP_TYPE_LINK: string;
        /**
         * Specifies one of the possible types of byte order.
         * See %G_BYTE_ORDER.
         */
        const LITTLE_ENDIAN: number;
        /**
         * The natural logarithm of 10.
         */
        const LN10: number;
        /**
         * The natural logarithm of 2.
         */
        const LN2: number;
        /**
         * Multiplying the base 2 exponent by this number yields the base 10 exponent.
         */
        const LOG_2_BASE_10: number;
        /**
         * Defines the log domain. See [Log Domains](#log-domains).
         *
         * Libraries should define this so that any messages
         * which they log can be differentiated from messages from other
         * libraries and application code. But be careful not to define
         * it in any public header files.
         *
         * Log domains must be unique, and it is recommended that they are the
         * application or library name, optionally followed by a hyphen and a sub-domain
         * name. For example, `bloatpad` or `bloatpad-io`.
         *
         * If undefined, it defaults to the default %NULL (or `""`) log domain; this is
         * not advisable, as it cannot be filtered against using the `G_MESSAGES_DEBUG`
         * environment variable.
         *
         * For example, GTK uses this in its `Makefile.am`:
         *
         * ```
         * AM_CPPFLAGS = -DG_LOG_DOMAIN=\"Gtk\"
         * ```
         *
         *
         * Applications can choose to leave it as the default %NULL (or `""`)
         * domain. However, defining the domain offers the same advantages as
         * above.
         */
        const LOG_DOMAIN: number;
        /**
         * GLib log levels that are considered fatal by default.
         *
         * This is not used if structured logging is enabled; see
         * [Using Structured Logging](logging.html#using-structured-logging).
         */
        const LOG_FATAL_MASK: number;
        /**
         * Log levels below `1<<G_LOG_LEVEL_USER_SHIFT` are used by GLib.
         * Higher bits can be used for user-defined log levels.
         */
        const LOG_LEVEL_USER_SHIFT: number;
        /**
         * The major version number of the GLib library.
         *
         * Like #glib_major_version, but from the headers used at
         * application compile time, rather than from the library
         * linked against at application run time.
         */
        const MAJOR_VERSION: number;
        const MAXINT16: number;
        const MAXINT32: number;
        const MAXINT64: number;
        const MAXINT8: number;
        const MAXUINT16: number;
        const MAXUINT32: number;
        const MAXUINT64: number;
        const MAXUINT8: number;
        /**
         * The micro version number of the GLib library.
         *
         * Like #gtk_micro_version, but from the headers used at
         * application compile time, rather than from the library
         * linked against at application run time.
         */
        const MICRO_VERSION: number;
        /**
         * The minimum value which can be held in a #gint16.
         */
        const MININT16: number;
        /**
         * The minimum value which can be held in a #gint32.
         */
        const MININT32: number;
        /**
         * The minimum value which can be held in a #gint64.
         */
        const MININT64: number;
        /**
         * The minimum value which can be held in a #gint8.
         */
        const MININT8: number;
        /**
         * The minor version number of the GLib library.
         *
         * Like #gtk_minor_version, but from the headers used at
         * application compile time, rather than from the library
         * linked against at application run time.
         */
        const MINOR_VERSION: number;
        const MODULE_SUFFIX: string;
        /**
         * If a long option in the main group has this name, it is not treated as a
         * regular option. Instead it collects all non-option arguments which would
         * otherwise be left in `argv`. The option must be of type
         * %G_OPTION_ARG_CALLBACK, %G_OPTION_ARG_STRING_ARRAY
         * or %G_OPTION_ARG_FILENAME_ARRAY.
         *
         *
         * Using %G_OPTION_REMAINING instead of simply scanning `argv`
         * for leftover arguments has the advantage that GOption takes care of
         * necessary encoding conversions for strings or filenames.
         */
        const OPTION_REMAINING: string;
        /**
         * Specifies one of the possible types of byte order
         * (currently unused). See %G_BYTE_ORDER.
         */
        const PDP_ENDIAN: number;
        /**
         * The value of pi (ratio of circle's circumference to its diameter).
         */
        const PI: number;
        /**
         * A format specifier that can be used in printf()-style format strings
         * when printing a #GPid.
         */
        const PID_FORMAT: string;
        /**
         * Pi divided by 2.
         */
        const PI_2: number;
        /**
         * Pi divided by 4.
         */
        const PI_4: number;
        /**
         * A format specifier that can be used in printf()-style format strings
         * when printing the `fd` member of a #GPollFD.
         */
        const POLLFD_FORMAT: string;
        /**
         * Use this for default priority event sources.
         *
         * In GLib this priority is used when adding timeout functions
         * with [func`GLib`.timeout_add]. In GDK this priority is used for events
         * from the X server.
         */
        const PRIORITY_DEFAULT: number;
        /**
         * Use this for default priority idle functions.
         *
         * In GLib this priority is used when adding idle functions with
         * [func`GLib`.idle_add].
         */
        const PRIORITY_DEFAULT_IDLE: number;
        /**
         * Use this for high priority event sources.
         *
         * It is not used within GLib or GTK.
         */
        const PRIORITY_HIGH: number;
        /**
         * Use this for high priority idle functions.
         *
         * GTK uses %G_PRIORITY_HIGH_IDLE + 10 for resizing operations,
         * and %G_PRIORITY_HIGH_IDLE + 20 for redrawing operations. (This is
         * done to ensure that any pending resizes are processed before any
         * pending redraws, so that widgets are not redrawn twice unnecessarily.)
         */
        const PRIORITY_HIGH_IDLE: number;
        /**
         * Use this for very low priority background tasks.
         *
         * It is not used within GLib or GTK.
         */
        const PRIORITY_LOW: number;
        /**
         * Evaluates to the initial reference count for `grefcount`.
         *
         * This macro is useful for initializing `grefcount` fields inside
         * structures, for instance:
         *
         *
         * ```c
         * typedef struct {
         *   grefcount ref_count;
         *   char *name;
         *   char *address;
         * } Person;
         *
         * static const Person default_person = {
         *   .ref_count = G_REF_COUNT_INIT,
         *   .name = "Default name",
         *   .address = "Default address",
         * };
         * ```
         *
         */
        const REF_COUNT_INIT: number;
        /**
         * The search path separator character.
         * This is ':' on UNIX machines and ';' under Windows.
         */
        const SEARCHPATH_SEPARATOR: number;
        /**
         * The search path separator as a string.
         * This is ":" on UNIX machines and ";" under Windows.
         */
        const SEARCHPATH_SEPARATOR_S: string;
        const SIZEOF_LONG: number;
        const SIZEOF_SIZE_T: number;
        const SIZEOF_SSIZE_T: number;
        const SIZEOF_VOID_P: number;
        /**
         * Use this macro as the return value of a [callback`GLib`.SourceFunc] to leave
         * the [struct`GLib`.Source] in the main loop.
         */
        const SOURCE_CONTINUE: boolean;
        /**
         * Use this macro as the return value of a [callback`GLib`.SourceFunc] to remove
         * the [struct`GLib`.Source] from the main loop.
         */
        const SOURCE_REMOVE: boolean;
        /**
         * The square root of two.
         */
        const SQRT2: number;
        /**
         * The standard delimiters, used in [func`GLib`.strdelimit].
         */
        const STR_DELIMITERS: string;
        const SYSDEF_AF_INET: number;
        const SYSDEF_AF_INET6: number;
        const SYSDEF_AF_UNIX: number;
        const SYSDEF_MSG_DONTROUTE: number;
        const SYSDEF_MSG_OOB: number;
        const SYSDEF_MSG_PEEK: number;
        /**
         * A value that can be passed as an option to [func`GLib`.test_init].
         *
         * Creates a unique temporary directory for each unit test and uses sets
         * XDG directories to point into subdirectories of it for the duration of
         * the unit test. The directory tree is cleaned up after the test finishes
         * successfully.
         *
         * Note that this doesn’t take effect until [func`GLib`.test_run] is called,
         * so calls to (for example) [func`GLib`.get_home_dir] will return the
         * system-wide value when made in a test program’s main() function.
         *
         * The following functions will return subdirectories of the temporary directory
         * when this option is used. The specific subdirectory paths in use are not
         * guaranteed to be stable API — always use a getter function to retrieve them.
         *
         *  - [func`GLib`.get_home_dir]
         *  - [func`GLib`.get_user_cache_dir]
         *  - [func`GLib`.get_system_config_dirs]
         *  - [func`GLib`.get_user_config_dir]
         *  - [func`GLib`.get_system_data_dirs]
         *  - [func`GLib`.get_user_data_dir]
         *  - [func`GLib`.get_user_state_dir]
         *  - [func`GLib`.get_user_runtime_dir]
         *
         * The subdirectories may not be created by the test harness; as with normal
         * calls to functions like [func`GLib`.get_user_cache_dir], the caller must
         * be prepared to create the directory if it doesn’t exist.
         */
        const TEST_OPTION_ISOLATE_DIRS: string;
        /**
         * A value that can be passed as an option to [func`GLib`.test_init].
         *
         * If this option is given, assertions will not abort the process, but
         * call [func`GLib`.test_fail]. Equivalent to [func`GLib`.test_set_nonfatal_assertions].
         */
        const TEST_OPTION_NONFATAL_ASSERTIONS: string;
        /**
         * A value that can be passed as an option to [func`GLib`.test_init].
         *
         * If this option is given, [func`GLib`.test_init] will not call [func`GLib`.set_prgname].
         */
        const TEST_OPTION_NO_PRGNAME: string;
        /**
         * Evaluates to a time span of one day.
         */
        const TIME_SPAN_DAY: number;
        /**
         * Evaluates to a time span of one hour.
         */
        const TIME_SPAN_HOUR: number;
        /**
         * Evaluates to a time span of one millisecond.
         */
        const TIME_SPAN_MILLISECOND: number;
        /**
         * Evaluates to a time span of one minute.
         */
        const TIME_SPAN_MINUTE: number;
        /**
         * Evaluates to a time span of one second.
         */
        const TIME_SPAN_SECOND: number;
        /**
         * The maximum length (in codepoints) of a compatibility or canonical
         * decomposition of a single Unicode character.
         *
         * This is as defined by Unicode 6.1.
         */
        const UNICHAR_MAX_DECOMPOSITION_LENGTH: number;
        /**
         * Generic delimiters characters as defined in
         * [RFC 3986](https://tools.ietf.org/html/rfc3986). Includes `:/?#[]```.
         */
        const URI_RESERVED_CHARS_GENERIC_DELIMITERS: string;
        /**
         * Subcomponent delimiter characters as defined in
         * [RFC 3986](https://tools.ietf.org/html/rfc3986). Includes `!$&'()*+,;=`.
         */
        const URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS: string;
        /**
         * Number of microseconds in one second (1 million).
         * This macro is provided for code readability.
         */
        const USEC_PER_SEC: number;
        const VA_COPY_AS_ARRAY: number;
        /**
         * A macro that should be defined by the user prior to including
         * the glib.h header.
         * The definition should be one of the predefined GLib version
         * macros: %GLIB_VERSION_2_26, %GLIB_VERSION_2_28,...
         *
         * This macro defines the earliest version of GLib that the package is
         * required to be able to compile against.
         *
         * If the compiler is configured to warn about the use of deprecated
         * functions, then using functions that were deprecated in version
         * %GLIB_VERSION_MIN_REQUIRED or earlier will cause warnings (but
         * using functions deprecated in later releases will not).
         */
        const VERSION_MIN_REQUIRED: number;
        const WIN32_MSG_HANDLE: number;
        const macro__has_attribute___noreturn__: number;
        const macro__has_attribute_ifunc: number;
        const macro__has_attribute_no_sanitize_address: number;
        /**
         * A wrapper for the POSIX access() function. This function is used to
         * test a pathname for one or several of read, write or execute
         * permissions, or just existence.
         *
         * On Windows, the file protection mechanism is not at all POSIX-like,
         * and the underlying function in the C library only checks the
         * FAT-style READONLY attribute, and does not look at the ACL of a
         * file at all. This function is this in practise almost useless on
         * Windows. Software that needs to handle file permissions on Windows
         * more exactly should use the Win32 API.
         *
         * See your C library manual for more details about access().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param mode as in access()
         * @returns zero if the pathname refers to an existing file system     object that has all the tested permissions, or -1 otherwise     or on error.
         */
        function access(filename: string, mode: number): number;
        /**
         * This function is similar to g_malloc(), allocating (`n_blocks` * `n_block_bytes)`
         * bytes, but care is taken to align the allocated memory to with the given
         * alignment value. Additionally, it will detect possible overflow during
         * multiplication.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         *
         * Aligned memory allocations returned by this function can only be
         * freed using g_aligned_free_sized() or g_aligned_free().
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @param alignment the alignment to be enforced, which must be a positive power of 2   and a multiple of `sizeof(void*)`
         * @returns the allocated memory
         */
        function aligned_alloc(n_blocks: number, n_block_bytes: number, alignment: number): any | null;
        /**
         * This function is similar to g_aligned_alloc(), but it will
         * also clear the allocated memory before returning it.
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @param alignment the alignment to be enforced, which must be a positive power of 2   and a multiple of `sizeof(void*)`
         * @returns the allocated, cleared memory
         */
        function aligned_alloc0(n_blocks: number, n_block_bytes: number, alignment: number): any | null;
        /**
         * Frees the memory allocated by g_aligned_alloc().
         * @param mem the memory to deallocate
         */
        function aligned_free(mem?: any | null): void;
        /**
         * Frees the memory pointed to by `mem,` assuming it is has the given `size` and
         * `alignment`.
         *
         * If `mem` is %NULL this is a no-op (and `size` is ignored).
         *
         * It is an error if `size` doesn’t match the size, or `alignment` doesn’t match
         * the alignment, passed when `mem` was allocated. `size` and `alignment` are
         * passed to this function to allow optimizations in the allocator. If you
         * don’t know either of them, use g_aligned_free() instead.
         * @param mem the memory to free
         * @param alignment alignment of @mem
         * @param size size of @mem, in bytes
         */
        function aligned_free_sized(mem: any | null, alignment: number, size: number): void;
        /**
         * Determines the numeric value of a character as a decimal digit. If the
         * character is not a decimal digit according to [func`GLib`.ascii_isdigit],
         * `-1` is returned.
         *
         * Differs from [func`GLib`.unichar_digit_value] because it takes a char, so
         * there's no worry about sign extension if characters are signed.
         * @param c an ASCII character
         * @returns the numerical value of @c if it is a decimal digit, `-1` otherwise
         */
        function ascii_digit_value(c: number): number;
        /**
         * Converts a `gdouble` to a string, using the '.' as
         * decimal point.
         *
         * This function generates enough precision that converting
         * the string back using [func`GLib`.ascii_strtod] gives the same machine-number
         * (on machines with IEEE compatible 64bit doubles). It is
         * guaranteed that the size of the resulting string will never
         * be larger than [const`GLib`.ASCII_DTOSTR_BUF_SIZE] bytes, including the terminating
         * nul character, which is always added.
         * @param buffer a buffer to place the resulting string in
         * @param buf_len the length of the buffer
         * @param d the value to convert
         * @returns the pointer to the buffer with the converted string
         */
        function ascii_dtostr(buffer: string, buf_len: number, d: number): string;
        /**
         * Converts a `gdouble` to a string, using the '.' as
         * decimal point. To format the number you pass in
         * a `printf()`-style format string. Allowed conversion
         * specifiers are 'e', 'E', 'f', 'F', 'g' and 'G'.
         *
         * The `format` must just be a single format specifier
         * starting with `%`, expecting a `gdouble` argument.
         *
         * The returned buffer is guaranteed to be nul-terminated.
         *
         * If you just want to want to serialize the value into a
         * string, use [func`GLib`.ascii_dtostr].
         * @param buffer a buffer to place the resulting string in
         * @param buf_len the length of the buffer
         * @param format the `printf()`-style format to use for the   code to use for converting
         * @param d the value to convert
         * @returns the pointer to the buffer with the converted string
         */
        function ascii_formatd(buffer: string, buf_len: number, format: string, d: number): string;
        /**
         * Compare two strings, ignoring the case of ASCII characters.
         *
         * Unlike the BSD `strcasecmp()` function, this only recognizes standard
         * ASCII letters and ignores the locale, treating all non-ASCII
         * bytes as if they are not letters.
         *
         * This function should be used only on strings that are known to be
         * in encodings where the bytes corresponding to ASCII letters always
         * represent themselves. This includes UTF-8 and the ISO-8859-*
         * charsets, but not for instance double-byte encodings like the
         * Windows Codepage 932, where the trailing bytes of double-byte
         * characters include all ASCII letters. If you compare two CP932
         * strings using this function, you will get false matches.
         *
         * Both `s1` and `s2` must be non-`NULL`.
         * @param s1 string to compare with @s2
         * @param s2 string to compare with @s1
         * @returns 0 if the strings match, a negative value if @s1 < @s2,   or a positive value if @s1 > @s2
         */
        function ascii_strcasecmp(s1: string, s2: string): number;
        /**
         * Converts all upper case ASCII letters to lower case ASCII letters, with
         * semantics that exactly match [func`GLib`.ascii_tolower].
         * @param str a string
         * @param len length of @str in bytes, or `-1` if @str is nul-terminated
         * @returns a newly-allocated string, with all the upper case characters in   @str converted to lower case. (Note that this is unlike the old   [func@GLib.strdown], which modified the string in place.)
         */
        function ascii_strdown(str: string, len: number): string;
        /**
         * A convenience function for converting a string to a signed number.
         *
         * This function assumes that `str` contains only a number of the given
         * `base` that is within inclusive bounds limited by `min` and `max`. If
         * this is true, then the converted number is stored in `out_num`. An
         * empty string is not a valid input. A string with leading or
         * trailing whitespace is also an invalid input.
         *
         * `base` can be between 2 and 36 inclusive. Hexadecimal numbers must
         * not be prefixed with "0x" or "0X". Such a problem does not exist
         * for octal numbers, since they were usually prefixed with a zero
         * which does not change the value of the parsed number.
         *
         * Parsing failures result in an error with the `G_NUMBER_PARSER_ERROR`
         * domain. If the input is invalid, the error code will be
         * [error`GLib`.NumberParserError.INVALID]. If the parsed number is out of
         * bounds - [error`GLib`.NumberParserError.OUT_OF_BOUNDS].
         *
         * See [func`GLib`.ascii_strtoll] if you have more complex needs such as
         * parsing a string which starts with a number, but then has other
         * characters.
         * @param str a string to convert
         * @param base base of a parsed number
         * @param min a lower bound (inclusive)
         * @param max an upper bound (inclusive)
         * @returns true if @str was a number, false otherwise
         */
        function ascii_string_to_signed(str: string, base: number, min: number, max: number): [boolean, number];
        /**
         * A convenience function for converting a string to an unsigned number.
         *
         * This function assumes that `str` contains only a number of the given
         * `base` that is within inclusive bounds limited by `min` and `max`. If
         * this is true, then the converted number is stored in `out_num`. An
         * empty string is not a valid input. A string with leading or
         * trailing whitespace is also an invalid input. A string with a leading sign
         * (`-` or `+`) is not a valid input for the unsigned parser.
         *
         * `base` can be between 2 and 36 inclusive. Hexadecimal numbers must
         * not be prefixed with "0x" or "0X". Such a problem does not exist
         * for octal numbers, since they were usually prefixed with a zero
         * which does not change the value of the parsed number.
         *
         * Parsing failures result in an error with the `G_NUMBER_PARSER_ERROR`
         * domain. If the input is invalid, the error code will be
         * [error`GLib`.NumberParserError.INVALID]. If the parsed number is out of
         * bounds - [error`GLib`.NumberParserError.OUT_OF_BOUNDS].
         *
         * See [func`GLib`.ascii_strtoull] if you have more complex needs such as
         * parsing a string which starts with a number, but then has other
         * characters.
         * @param str a string
         * @param base base of a parsed number
         * @param min a lower bound (inclusive)
         * @param max an upper bound (inclusive)
         * @returns true if @str was a number, false otherwise
         */
        function ascii_string_to_unsigned(str: string, base: number, min: number, max: number): [boolean, number];
        /**
         * Compare `s1` and `s2`, ignoring the case of ASCII characters and any
         * characters after the first `n` in each string. If either string is
         * less than `n` bytes long, comparison will stop at the first nul byte
         * encountered.
         *
         * Unlike the BSD `strncasecmp()` function, this only recognizes standard
         * ASCII letters and ignores the locale, treating all non-ASCII
         * characters as if they are not letters.
         *
         * The same warning as in [func`GLib`.ascii_strcasecmp] applies: Use this
         * function only on strings known to be in encodings where bytes
         * corresponding to ASCII letters always represent themselves.
         * @param s1 string to compare with @s2
         * @param s2 string to compare with @s1
         * @param n number of characters to compare
         * @returns 0 if the strings match, a negative value if @s1 < @s2,   or a positive value if @s1 > @s2
         */
        function ascii_strncasecmp(s1: string, s2: string, n: number): number;
        /**
         * Converts a string to a floating point value.
         *
         * This function behaves like the standard `strtod()` function
         * does in the C locale. It does this without actually changing
         * the current locale, since that would not be thread-safe.
         * A limitation of the implementation is that this function
         * will still accept localized versions of infinities and NANs.
         *
         * This function is typically used when reading configuration
         * files or other non-user input that should be locale independent.
         * To handle input from the user you should normally use the
         * locale-sensitive system `strtod()` function.
         *
         * To convert from a gdouble to a string in a locale-insensitive
         * way, use [func`GLib`.ascii_dtostr].
         *
         * If the correct value would cause overflow, plus or minus `HUGE_VAL`
         * is returned (according to the sign of the value), and `ERANGE` is
         * stored in `errno`. If the correct value would cause underflow,
         * zero is returned and `ERANGE` is stored in `errno`.
         *
         * This function resets `errno` before calling `strtod()` so that
         * you can reliably detect overflow and underflow.
         * @param nptr the string to convert to a numeric value
         * @returns the converted value
         */
        function ascii_strtod(nptr: string): [number, string];
        /**
         * Converts a string to a `gint64` value.
         *
         * This function behaves like the standard `strtoll()` function
         * does in the C locale. It does this without actually
         * changing the current locale, since that would not be
         * thread-safe.
         *
         * This function is typically used when reading configuration
         * files or other non-user input that should be locale independent.
         * To handle input from the user you should normally use the
         * locale-sensitive system `strtoll()` function.
         *
         * If the correct value would cause overflow, [const`GLib`.MAXINT64] or
         * [const`GLib`.MININT64] is returned, and `ERANGE` is stored in `errno`.
         * If the base is outside the valid range, zero is returned, and
         * `EINVAL` is stored in `errno`. If the
         * string conversion fails, zero is returned, and `endptr` returns `nptr`
         * (if `endptr` is non-`NULL`).
         * @param nptr the string to convert to a numeric value
         * @param base to be used for the conversion, 2..36 or 0
         * @returns the converted value, or zero on error
         */
        function ascii_strtoll(nptr: string, base: number): [number, string];
        /**
         * Converts a string to a `guint64` value.
         *
         * This function behaves like the standard `strtoull()` function
         * does in the C locale. It does this without actually
         * changing the current locale, since that would not be
         * thread-safe.
         *
         * Note that input with a leading minus sign (`-`) is accepted, and will return
         * the negation of the parsed number, unless that would overflow a `guint64`.
         * Critically, this means you cannot assume that a short fixed length input will
         * result in a low return value, as the input could have a leading `-`.
         *
         * This function is typically used when reading configuration
         * files or other non-user input that should be locale independent.
         * To handle input from the user you should normally use the
         * locale-sensitive system `strtoull()` function.
         *
         * If the correct value would cause overflow, [const`GLib`.MAXUINT64]
         * is returned, and `ERANGE` is stored in `errno`.
         * If the base is outside the valid range, zero is returned, and
         * `EINVAL` is stored in `errno`.
         * If the string conversion fails, zero is returned, and `endptr` returns
         * `nptr` (if `endptr` is non-`NULL`).
         * @param nptr the string to convert to a numeric value
         * @param base to be used for the conversion, 2..36 or 0
         * @returns the converted value, or zero on error
         */
        function ascii_strtoull(nptr: string, base: number): [number, string];
        /**
         * Converts all lower case ASCII letters to upper case ASCII letters, with
         * semantics that exactly match [func`GLib`.ascii_toupper].
         * @param str a string
         * @param len length of @str in bytes, or `-1` if @str is nul-terminated
         * @returns a newly-allocated string, with all the lower case characters   in @str converted to upper case. (Note that this is unlike the old   [func@GLib.strup], which modified the string in place.)
         */
        function ascii_strup(str: string, len: number): string;
        /**
         * Convert a character to ASCII lower case. If the character is not an
         * ASCII upper case letter, it is returned unchanged.
         *
         * Unlike the standard C library `tolower()` function, this only
         * recognizes standard ASCII letters and ignores the locale, returning
         * all non-ASCII characters unchanged, even if they are lower case
         * letters in a particular character set. Also unlike the standard
         * library function, this takes and returns a char, not an int, so
         * don't call it on `EOF` but no need to worry about casting to `guchar`
         * before passing a possibly non-ASCII character in.
         * @param c any character
         * @returns the result of the conversion
         */
        function ascii_tolower(c: number): number;
        /**
         * Convert a character to ASCII upper case. If the character is not an
         * ASCII lower case letter, it is returned unchanged.
         *
         * Unlike the standard C library `toupper()` function, this only
         * recognizes standard ASCII letters and ignores the locale, returning
         * all non-ASCII characters unchanged, even if they are upper case
         * letters in a particular character set. Also unlike the standard
         * library function, this takes and returns a char, not an int, so
         * don't call it on `EOF` but no need to worry about casting to `guchar`
         * before passing a possibly non-ASCII character in.
         * @param c any character
         * @returns the result of the conversion
         */
        function ascii_toupper(c: number): number;
        /**
         * Determines the numeric value of a character as a hexadecimal digit. If the
         * character is not a hex digit according to [func`GLib`.ascii_isxdigit],
         * `-1` is returned.
         *
         * Differs from [func`GLib`.unichar_xdigit_value] because it takes a char, so
         * there's no worry about sign extension if characters are signed.
         *
         * Differs from [func`GLib`.unichar_xdigit_value] because it takes a char, so
         * there's no worry about sign extension if characters are signed.
         * @param c an ASCII character
         * @returns the numerical value of @c if it is a hex digit, `-1` otherwise
         */
        function ascii_xdigit_value(c: number): number;
        function assert_warning(
            log_domain: string,
            file: string,
            line: number,
            pretty_function: string,
            expression: string,
        ): void;
        function assertion_message(domain: string, file: string, line: number, func: string, message: string): void;
        function assertion_message_cmpint(
            domain: string,
            file: string,
            line: number,
            func: string,
            expr: string,
            arg1: number,
            cmp: string,
            arg2: number,
            numtype: number,
        ): void;
        function assertion_message_cmpstr(
            domain: string,
            file: string,
            line: number,
            func: string,
            expr: string,
            arg1: string,
            cmp: string,
            arg2: string,
        ): void;
        function assertion_message_cmpstrv(
            domain: string,
            file: string,
            line: number,
            func: string,
            expr: string,
            arg1: string,
            arg2: string,
            first_wrong_idx: number,
        ): void;
        function assertion_message_error(
            domain: string,
            file: string,
            line: number,
            func: string,
            expr: string,
            error: Error,
            error_domain: Quark,
            error_code: number,
        ): void;
        /**
         * Creates a new asynchronous queue.
         * @returns a new #GAsyncQueue. Free with g_async_queue_unref()
         */
        function async_queue_new(): AsyncQueue;
        /**
         * Creates a new asynchronous queue and sets up a destroy notify
         * function that is used to free any remaining queue items when
         * the queue is destroyed after the final unref.
         * @param item_free_func function to free queue elements
         * @returns a new #GAsyncQueue. Free with g_async_queue_unref()
         */
        function async_queue_new_full(item_free_func?: DestroyNotify | null): AsyncQueue;
        /**
         * Specifies a function to be called at normal program termination.
         *
         * Since GLib 2.8.2, on Windows g_atexit() actually is a preprocessor
         * macro that maps to a call to the atexit() function in the C
         * library. This means that in case the code that calls g_atexit(),
         * i.e. atexit(), is in a DLL, the function will be called when the
         * DLL is detached from the program. This typically makes more sense
         * than that the function is called when the GLib DLL is detached,
         * which happened earlier when g_atexit() was a function in the GLib
         * DLL.
         *
         * The behaviour of atexit() in the context of dynamically loaded
         * modules is not formally specified and varies wildly.
         *
         * On POSIX systems, calling g_atexit() (or atexit()) in a dynamically
         * loaded module which is unloaded before the program terminates might
         * well cause a crash at program exit.
         *
         * Some POSIX systems implement atexit() like Windows, and have each
         * dynamically loaded module maintain an own atexit chain that is
         * called when the module is unloaded.
         *
         * On other POSIX systems, before a dynamically loaded module is
         * unloaded, the registered atexit functions (if any) residing in that
         * module are called, regardless where the code that registered them
         * resided. This is presumably the most robust approach.
         *
         * As can be seen from the above, for portability it's best to avoid
         * calling g_atexit() (or atexit()) except in the main executable of a
         * program.
         * @param func the function to call on normal program termination.
         */
        function atexit(func: VoidFunc): void;
        /**
         * Atomically adds `val` to the value of `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic += val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * Before version 2.30, this function did not return a value
         * (but g_atomic_int_exchange_and_add() did, and had the same meaning).
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @param val the value to add
         * @returns the value of @atomic before the add, signed
         */
        function atomic_int_add(atomic: number, val: number): number;
        /**
         * Performs an atomic bitwise 'and' of the value of `atomic` and `val,`
         * storing the result back in `atomic`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic &= val; return tmp; }`.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @param val the value to 'and'
         * @returns the value of @atomic before the operation, unsigned
         */
        function atomic_int_and(atomic: number, val: number): number;
        /**
         * Compares `atomic` to `oldval` and, if equal, sets it to `newval`.
         * If `atomic` was not equal to `oldval` then no change occurs.
         *
         * This compare and exchange is done atomically.
         *
         * Think of this operation as an atomic version of
         * `{ if (*atomic == oldval) { *atomic = newval; return TRUE; } else return FALSE; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @param oldval the value to compare with
         * @param newval the value to conditionally replace with
         * @returns %TRUE if the exchange took place
         */
        function atomic_int_compare_and_exchange(atomic: number, oldval: number, newval: number): boolean;
        /**
         * Compares `atomic` to `oldval` and, if equal, sets it to `newval`.
         * If `atomic` was not equal to `oldval` then no change occurs.
         * In any case the value of `atomic` before this operation is stored in `preval`.
         *
         * This compare and exchange is done atomically.
         *
         * Think of this operation as an atomic version of
         * `{ *preval = *atomic; if (*atomic == oldval) { *atomic = newval; return TRUE; } else return FALSE; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * See also g_atomic_int_compare_and_exchange()
         * @param atomic a pointer to a #gint or #guint
         * @param oldval the value to compare with
         * @param newval the value to conditionally replace with
         * @returns %TRUE if the exchange took place
         */
        function atomic_int_compare_and_exchange_full(
            atomic: number,
            oldval: number,
            newval: number,
        ): [boolean, number];
        /**
         * Decrements the value of `atomic` by 1.
         *
         * Think of this operation as an atomic version of
         * `{ *atomic -= 1; return (*atomic == 0); }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @returns %TRUE if the resultant value is zero
         */
        function atomic_int_dec_and_test(atomic: number): boolean;
        /**
         * Sets the `atomic` to `newval` and returns the old value from `atomic`.
         *
         * This exchange is done atomically.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic = val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         * @param atomic a pointer to a #gint or #guint
         * @param newval the value to replace with
         * @returns the value of @atomic before the exchange, signed
         */
        function atomic_int_exchange(atomic: number, newval: number): number;
        /**
         * This function existed before g_atomic_int_add() returned the prior
         * value of the integer (which it now does).  It is retained only for
         * compatibility reasons.  Don't use this function in new code.
         * @param atomic a pointer to a #gint
         * @param val the value to add
         * @returns the value of @atomic before the add, signed
         */
        function atomic_int_exchange_and_add(atomic: number, val: number): number;
        /**
         * Gets the current value of `atomic`.
         *
         * This call acts as a full compiler and hardware
         * memory barrier (before the get).
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @returns the value of the integer
         */
        function atomic_int_get(atomic: number): number;
        /**
         * Increments the value of `atomic` by 1.
         *
         * Think of this operation as an atomic version of `{ *atomic += 1; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         */
        function atomic_int_inc(atomic: number): void;
        /**
         * Performs an atomic bitwise 'or' of the value of `atomic` and `val,`
         * storing the result back in `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic |= val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @param val the value to 'or'
         * @returns the value of @atomic before the operation, unsigned
         */
        function atomic_int_or(atomic: number, val: number): number;
        /**
         * Sets the value of `atomic` to `newval`.
         *
         * This call acts as a full compiler and hardware
         * memory barrier (after the set).
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @param newval a new value to store
         */
        function atomic_int_set(atomic: number, newval: number): void;
        /**
         * Performs an atomic bitwise 'xor' of the value of `atomic` and `val,`
         * storing the result back in `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic ^= val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gint or #guint
         * @param val the value to 'xor'
         * @returns the value of @atomic before the operation, unsigned
         */
        function atomic_int_xor(atomic: number, val: number): number;
        /**
         * Atomically adds `val` to the value of `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic += val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         *
         * In GLib 2.80, the return type was changed from #gssize to #gintptr to add
         * support for platforms with 128-bit pointers. This should not affect existing
         * code.
         * @param atomic a pointer to a #gpointer-sized value
         * @param val the value to add
         * @returns the value of @atomic before the add, signed
         */
        function atomic_pointer_add(atomic: any, val: number): never;
        /**
         * Performs an atomic bitwise 'and' of the value of `atomic` and `val,`
         * storing the result back in `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic &= val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         *
         * In GLib 2.80, the return type was changed from #gsize to #guintptr to add
         * support for platforms with 128-bit pointers. This should not affect existing
         * code.
         * @param atomic a pointer to a #gpointer-sized value
         * @param val the value to 'and'
         * @returns the value of @atomic before the operation, unsigned
         */
        function atomic_pointer_and(atomic: any, val: number): never;
        /**
         * Compares `atomic` to `oldval` and, if equal, sets it to `newval`.
         * If `atomic` was not equal to `oldval` then no change occurs.
         *
         * This compare and exchange is done atomically.
         *
         * Think of this operation as an atomic version of
         * `{ if (*atomic == oldval) { *atomic = newval; return TRUE; } else return FALSE; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gpointer-sized value
         * @param oldval the value to compare with
         * @param newval the value to conditionally replace with
         * @returns %TRUE if the exchange took place
         */
        function atomic_pointer_compare_and_exchange(atomic: any, oldval?: any | null, newval?: any | null): boolean;
        /**
         * Compares `atomic` to `oldval` and, if equal, sets it to `newval`.
         * If `atomic` was not equal to `oldval` then no change occurs.
         * In any case the value of `atomic` before this operation is stored in `preval`.
         *
         * This compare and exchange is done atomically.
         *
         * Think of this operation as an atomic version of
         * `{ *preval = *atomic; if (*atomic == oldval) { *atomic = newval; return TRUE; } else return FALSE; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * See also g_atomic_pointer_compare_and_exchange()
         * @param atomic a pointer to a #gpointer-sized value
         * @param oldval the value to compare with
         * @param newval the value to conditionally replace with
         * @returns %TRUE if the exchange took place
         */
        function atomic_pointer_compare_and_exchange_full(
            atomic: any,
            oldval: any | null,
            newval: any | null,
        ): [boolean, any];
        /**
         * Sets the `atomic` to `newval` and returns the old value from `atomic`.
         *
         * This exchange is done atomically.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic = val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         * @param atomic a pointer to a #gpointer-sized value
         * @param newval the value to replace with
         * @returns the value of @atomic before the exchange
         */
        function atomic_pointer_exchange(atomic?: any | null, newval?: any | null): any | null;
        /**
         * Gets the current value of `atomic`.
         *
         * This call acts as a full compiler and hardware
         * memory barrier (before the get).
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gpointer-sized value
         * @returns the value of the pointer
         */
        function atomic_pointer_get(atomic: any): any | null;
        /**
         * Performs an atomic bitwise 'or' of the value of `atomic` and `val,`
         * storing the result back in `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic |= val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         *
         * In GLib 2.80, the return type was changed from #gsize to #guintptr to add
         * support for platforms with 128-bit pointers. This should not affect existing
         * code.
         * @param atomic a pointer to a #gpointer-sized value
         * @param val the value to 'or'
         * @returns the value of @atomic before the operation, unsigned
         */
        function atomic_pointer_or(atomic: any, val: number): never;
        /**
         * Sets the value of `atomic` to `newval`.
         *
         * This call acts as a full compiler and hardware
         * memory barrier (after the set).
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param atomic a pointer to a #gpointer-sized value
         * @param newval a new value to store
         */
        function atomic_pointer_set(atomic: any, newval?: any | null): void;
        /**
         * Performs an atomic bitwise 'xor' of the value of `atomic` and `val,`
         * storing the result back in `atomic`.
         *
         * Think of this operation as an atomic version of
         * `{ tmp = *atomic; *atomic ^= val; return tmp; }`.
         *
         * This call acts as a full compiler and hardware memory barrier.
         *
         * While `atomic` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         *
         * In GLib 2.80, the return type was changed from #gsize to #guintptr to add
         * support for platforms with 128-bit pointers. This should not affect existing
         * code.
         * @param atomic a pointer to a #gpointer-sized value
         * @param val the value to 'xor'
         * @returns the value of @atomic before the operation, unsigned
         */
        function atomic_pointer_xor(atomic: any, val: number): never;
        /**
         * Atomically acquires a reference on the data pointed by `mem_block`.
         * @param mem_block a pointer to reference counted data
         * @returns a pointer to the data,   with its reference count increased
         */
        function atomic_rc_box_acquire(mem_block: any): any;
        /**
         * Allocates `block_size` bytes of memory, and adds atomic
         * reference counting semantics to it.
         *
         * The data will be freed when its reference count drops to
         * zero.
         *
         * The allocated data is guaranteed to be suitably aligned for any
         * built-in type.
         * @param block_size the size of the allocation, must be greater than 0
         * @returns a pointer to the allocated memory
         */
        function atomic_rc_box_alloc(block_size: number): any;
        /**
         * Allocates `block_size` bytes of memory, and adds atomic
         * reference counting semantics to it.
         *
         * The contents of the returned data is set to zero.
         *
         * The data will be freed when its reference count drops to
         * zero.
         *
         * The allocated data is guaranteed to be suitably aligned for any
         * built-in type.
         * @param block_size the size of the allocation, must be greater than 0
         * @returns a pointer to the allocated memory
         */
        function atomic_rc_box_alloc0(block_size: number): any;
        /**
         * Allocates a new block of data with atomic reference counting
         * semantics, and copies `block_size` bytes of `mem_block`
         * into it.
         * @param block_size the number of bytes to copy, must be greater than 0
         * @param mem_block the memory to copy
         * @returns a pointer to the allocated   memory
         */
        function atomic_rc_box_dup(block_size: number, mem_block: any): any;
        /**
         * Retrieves the size of the reference counted data pointed by `mem_block`.
         * @param mem_block a pointer to reference counted data
         * @returns the size of the data, in bytes
         */
        function atomic_rc_box_get_size(mem_block: any): number;
        /**
         * Atomically releases a reference on the data pointed by `mem_block`.
         *
         * If the reference was the last one, it will free the
         * resources allocated for `mem_block`.
         * @param mem_block a pointer to reference counted data
         */
        function atomic_rc_box_release(mem_block: any): void;
        /**
         * Atomically releases a reference on the data pointed by `mem_block`.
         *
         * If the reference was the last one, it will call `clear_func`
         * to clear the contents of `mem_block,` and then will free the
         * resources allocated for `mem_block`.
         *
         * Note that implementing weak references via `clear_func` is not thread-safe:
         * clearing a pointer to the memory from the callback can race with another
         * thread trying to access it as `mem_block` already has a reference count of 0
         * when the callback is called and will be freed.
         * @param mem_block a pointer to reference counted data
         */
        function atomic_rc_box_release_full(mem_block: any): void;
        /**
         * Atomically compares the current value of `arc` with `val`.
         * @param arc the address of an atomic reference count variable
         * @param val the value to compare
         * @returns %TRUE if the reference count is the same   as the given value
         */
        function atomic_ref_count_compare(arc: number, val: number): boolean;
        /**
         * Atomically decreases the reference count.
         *
         * If %TRUE is returned, the reference count reached 0. After this point, `arc`
         * is an undefined state and must be reinitialized with
         * g_atomic_ref_count_init() to be used again.
         * @param arc the address of an atomic reference count variable
         * @returns %TRUE if the reference count reached 0, and %FALSE otherwise
         */
        function atomic_ref_count_dec(arc: number): boolean;
        /**
         * Atomically increases the reference count.
         * @param arc the address of an atomic reference count variable
         */
        function atomic_ref_count_inc(arc: number): void;
        /**
         * Initializes a reference count variable to 1.
         * @param arc the address of an atomic reference count variable
         */
        function atomic_ref_count_init(arc: number): void;
        /**
         * Decode a sequence of Base-64 encoded text into binary data.  Note
         * that the returned binary data is not necessarily zero-terminated,
         * so it should not be used as a character string.
         * @param text zero-terminated string with base64 text to decode
         * @returns newly allocated buffer containing the binary data               that @text represents. The returned buffer must               be freed with g_free().
         */
        function base64_decode(text: string): Uint8Array;
        /**
         * Decode a sequence of Base-64 encoded text into binary data
         * by overwriting the input data.
         * @param text zero-terminated        string with base64 text to decode
         * @returns The binary data that @text responds. This pointer               is the same as the input @text.
         */
        function base64_decode_inplace(text: Uint8Array | string): [number, Uint8Array];
        /**
         * Encode a sequence of binary data into its Base-64 stringified
         * representation.
         * @param data the binary data to encode
         * @returns a newly allocated, zero-terminated Base-64               encoded string representing @data. The returned string must               be freed with g_free().
         */
        function base64_encode(data?: Uint8Array | null): string;
        /**
         * Flush the status from a sequence of calls to g_base64_encode_step().
         *
         * The output buffer must be large enough to fit all the data that will
         * be written to it. It will need up to 4 bytes, or up to 5 bytes if
         * line-breaking is enabled.
         *
         * The `out` array will not be automatically nul-terminated.
         * @param break_lines whether to break long lines
         * @param state Saved state from g_base64_encode_step()
         * @param save Saved state from g_base64_encode_step()
         * @returns The number of bytes of output that was written
         */
        function base64_encode_close(
            break_lines: boolean,
            state: number,
            save: number,
        ): [number, Uint8Array, number, number];
        /**
         * Incrementally encode a sequence of binary data into its Base-64 stringified
         * representation. By calling this function multiple times you can convert
         * data in chunks to avoid having to have the full encoded data in memory.
         *
         * When all of the data has been converted you must call
         * g_base64_encode_close() to flush the saved state.
         *
         * The output buffer must be large enough to fit all the data that will
         * be written to it. Due to the way base64 encodes you will need
         * at least: (`len` / 3 + 1) * 4 + 4 bytes (+ 4 may be needed in case of
         * non-zero state). If you enable line-breaking you will need at least:
         * ((`len` / 3 + 1) * 4 + 4) / 76 + 1 bytes of extra space.
         *
         * `break_lines` is typically used when putting base64-encoded data in emails.
         * It breaks the lines at 76 columns instead of putting all of the text on
         * the same line. This avoids problems with long lines in the email system.
         * Note however that it breaks the lines with `LF` characters, not
         * `CR LF` sequences, so the result cannot be passed directly to SMTP
         * or certain other protocols.
         * @param _in the binary data to encode
         * @param break_lines whether to break long lines
         * @param state Saved state between steps, initialize to 0
         * @param save Saved state between steps, initialize to 0
         * @returns The number of bytes of output that was written
         */
        function base64_encode_step(
            _in: Uint8Array | string,
            break_lines: boolean,
            state: number,
            save: number,
        ): [number, Uint8Array, number, number];
        /**
         * Gets the name of the file without any leading directory
         * components. It returns a pointer into the given file name
         * string.
         * @param file_name the name of the file
         * @returns the name of the file without any leading   directory components
         */
        function basename(file_name: string): string;
        /**
         * Sets the indicated `lock_bit` in `address`.  If the bit is already
         * set, this call will block until g_bit_unlock() unsets the
         * corresponding bit.
         *
         * Attempting to lock on two different bits within the same integer is
         * not supported and will very probably cause deadlocks.
         *
         * The value of the bit that is set is (1u << `bit)`.  If `bit` is not
         * between 0 and 31 then the result is undefined.
         *
         * This function accesses `address` atomically.  All other accesses to
         * `address` must be atomic in order for this function to work
         * reliably. While `address` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param address a pointer to an integer
         * @param lock_bit a bit value between 0 and 31
         */
        function bit_lock(address: number, lock_bit: number): void;
        /**
         * Find the position of the first bit set in `mask,` searching
         * from (but not including) `nth_bit` upwards. Bits are numbered
         * from 0 (least significant) to sizeof(#gulong) * 8 - 1 (31 or 63,
         * usually). To start searching from the 0th bit, set `nth_bit` to -1.
         * @param mask a #gulong containing flags
         * @param nth_bit the index of the bit to start the search from
         * @returns the index of the first bit set which is higher than @nth_bit, or -1    if no higher bits are set
         */
        function bit_nth_lsf(mask: number, nth_bit: number): number;
        /**
         * Find the position of the first bit set in `mask,` searching
         * from (but not including) `nth_bit` downwards. Bits are numbered
         * from 0 (least significant) to sizeof(#gulong) * 8 - 1 (31 or 63,
         * usually). To start searching from the last bit, set `nth_bit` to
         * -1 or GLIB_SIZEOF_LONG * 8.
         * @param mask a #gulong containing flags
         * @param nth_bit the index of the bit to start the search from
         * @returns the index of the first bit set which is lower than @nth_bit, or -1    if no lower bits are set
         */
        function bit_nth_msf(mask: number, nth_bit: number): number;
        /**
         * Gets the number of bits used to hold `number,`
         * e.g. if `number` is 4, 3 bits are needed.
         * @param number a #guint
         * @returns the number of bits used to hold @number
         */
        function bit_storage(number: number): number;
        /**
         * Sets the indicated `lock_bit` in `address,` returning %TRUE if
         * successful.  If the bit is already set, returns %FALSE immediately.
         *
         * Attempting to lock on two different bits within the same integer is
         * not supported.
         *
         * The value of the bit that is set is (1u << `bit)`.  If `bit` is not
         * between 0 and 31 then the result is undefined.
         *
         * This function accesses `address` atomically.  All other accesses to
         * `address` must be atomic in order for this function to work
         * reliably. While `address` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param address a pointer to an integer
         * @param lock_bit a bit value between 0 and 31
         * @returns %TRUE if the lock was acquired
         */
        function bit_trylock(address: number, lock_bit: number): boolean;
        /**
         * Clears the indicated `lock_bit` in `address`.  If another thread is
         * currently blocked in g_bit_lock() on this same bit then it will be
         * woken up.
         *
         * This function accesses `address` atomically.  All other accesses to
         * `address` must be atomic in order for this function to work
         * reliably. While `address` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param address a pointer to an integer
         * @param lock_bit a bit value between 0 and 31
         */
        function bit_unlock(address: number, lock_bit: number): void;
        function blow_chunks(): void;
        function bookmark_file_error_quark(): Quark;
        /**
         * Creates a filename from a vector of elements using the correct
         * separator for the current platform.
         *
         * This function behaves exactly like g_build_filename(), but takes the path
         * elements as a string array, instead of varargs. This function is mainly
         * meant for language bindings.
         *
         * If you are building a path programmatically you may want to use
         * #GPathBuf instead.
         * @param args %NULL-terminated   array of strings containing the path elements.
         * @returns the newly allocated path
         */
        function build_filenamev(args: string[]): string;
        /**
         * Behaves exactly like g_build_path(), but takes the path elements
         * as a string array, instead of variadic arguments.
         *
         * This function is mainly meant for language bindings.
         * @param separator a string used to separator the elements of the path.
         * @param args %NULL-terminated   array of strings containing the path elements.
         * @returns a newly-allocated string that     must be freed with g_free().
         */
        function build_pathv(separator: string, args: string[]): string;
        /**
         * Adds the given bytes to the end of the #GByteArray.
         * The array will grow in size automatically if necessary.
         * @param array a #GByteArray
         * @param data the byte data to be added
         * @param len the number of bytes to add
         * @returns the #GByteArray
         */
        function byte_array_append(array: Uint8Array | string, data: number, len: number): Uint8Array;
        /**
         * Frees the memory allocated by the #GByteArray. If `free_segment` is
         * %TRUE it frees the actual byte data. If the reference count of
         * `array` is greater than one, the #GByteArray wrapper is preserved but
         * the size of `array` will be set to zero.
         * @param array a #GByteArray
         * @param free_segment if %TRUE the actual byte data is freed as well
         * @returns the element data if @free_segment is %FALSE, otherwise          %NULL.  The element data should be freed using g_free().
         */
        function byte_array_free(array: Uint8Array | string, free_segment: boolean): number;
        /**
         * Transfers the data from the #GByteArray into a new immutable #GBytes.
         *
         * The #GByteArray is freed unless the reference count of `array` is greater
         * than one, the #GByteArray wrapper is preserved but the size of `array`
         * will be set to zero.
         *
         * This is identical to using g_bytes_new_take() and g_byte_array_free()
         * together.
         * @param array a #GByteArray
         * @returns a new immutable #GBytes representing same     byte data that was in the array
         */
        function byte_array_free_to_bytes(array: Uint8Array | string): Bytes;
        /**
         * Creates a new #GByteArray with a reference count of 1.
         * @returns the new #GByteArray
         */
        function byte_array_new(): Uint8Array;
        /**
         * Creates a byte array containing the `data`.
         * After this call, `data` belongs to the #GByteArray and may no longer be
         * modified by the caller. The memory of `data` has to be dynamically
         * allocated and will eventually be freed with g_free().
         *
         * Do not use it if `len` is greater than %G_MAXUINT. #GByteArray
         * stores the length of its data in #guint, which may be shorter than
         * #gsize.
         * @param data byte data for the array
         * @returns a new #GByteArray
         */
        function byte_array_new_take(data: Uint8Array | string): Uint8Array;
        /**
         * Adds the given data to the start of the #GByteArray.
         * The array will grow in size automatically if necessary.
         * @param array a #GByteArray
         * @param data the byte data to be added
         * @param len the number of bytes to add
         * @returns the #GByteArray
         */
        function byte_array_prepend(array: Uint8Array | string, data: number, len: number): Uint8Array;
        /**
         * Atomically increments the reference count of `array` by one.
         * This function is thread-safe and may be called from any thread.
         * @param array A #GByteArray
         * @returns The passed in #GByteArray
         */
        function byte_array_ref(array: Uint8Array | string): Uint8Array;
        /**
         * Removes the byte at the given index from a #GByteArray.
         * The following bytes are moved down one place.
         * @param array a #GByteArray
         * @param index_ the index of the byte to remove
         * @returns the #GByteArray
         */
        function byte_array_remove_index(array: Uint8Array | string, index_: number): Uint8Array;
        /**
         * Removes the byte at the given index from a #GByteArray. The last
         * element in the array is used to fill in the space, so this function
         * does not preserve the order of the #GByteArray. But it is faster
         * than g_byte_array_remove_index().
         * @param array a #GByteArray
         * @param index_ the index of the byte to remove
         * @returns the #GByteArray
         */
        function byte_array_remove_index_fast(array: Uint8Array | string, index_: number): Uint8Array;
        /**
         * Removes the given number of bytes starting at the given index from a
         * #GByteArray.  The following elements are moved to close the gap.
         * @param array a @GByteArray
         * @param index_ the index of the first byte to remove
         * @param length the number of bytes to remove
         * @returns the #GByteArray
         */
        function byte_array_remove_range(array: Uint8Array | string, index_: number, length: number): Uint8Array;
        /**
         * Sets the size of the #GByteArray, expanding it if necessary.
         * @param array a #GByteArray
         * @param length the new size of the #GByteArray
         * @returns the #GByteArray
         */
        function byte_array_set_size(array: Uint8Array | string, length: number): Uint8Array;
        /**
         * Creates a new #GByteArray with `reserved_size` bytes preallocated.
         * This avoids frequent reallocation, if you are going to add many
         * bytes to the array. Note however that the size of the array is still
         * 0.
         * @param reserved_size number of bytes preallocated
         * @returns the new #GByteArray
         */
        function byte_array_sized_new(reserved_size: number): Uint8Array;
        /**
         * Sorts a byte array, using `compare_func` which should be a
         * qsort()-style comparison function (returns less than zero for first
         * arg is less than second arg, zero for equal, greater than zero if
         * first arg is greater than second arg).
         *
         * If two array elements compare equal, their order in the sorted array
         * is undefined. If you want equal elements to keep their order (i.e.
         * you want a stable sort) you can write a comparison function that,
         * if two elements would otherwise compare equal, compares them by
         * their addresses.
         * @param array a #GByteArray
         * @param compare_func comparison function
         */
        function byte_array_sort(array: Uint8Array | string, compare_func: CompareFunc): void;
        /**
         * Like g_byte_array_sort(), but the comparison function takes an extra
         * user data argument.
         * @param array a #GByteArray
         * @param compare_func comparison function
         */
        function byte_array_sort_with_data(array: Uint8Array | string, compare_func: CompareDataFunc): void;
        /**
         * Frees the data in the array and resets the size to zero, while
         * the underlying array is preserved for use elsewhere and returned
         * to the caller.
         * @param array a #GByteArray.
         * @returns the element data, which should be     freed using g_free().
         */
        function byte_array_steal(array: Uint8Array | string): [number, number];
        /**
         * Atomically decrements the reference count of `array` by one. If the
         * reference count drops to 0, all memory allocated by the array is
         * released. This function is thread-safe and may be called from any
         * thread.
         * @param array A #GByteArray
         */
        function byte_array_unref(array: Uint8Array | string): void;
        /**
         * Gets the canonical file name from `filename`. All triple slashes are turned into
         * single slashes, and all `..` and `.`s resolved against `relative_to`.
         *
         * Symlinks are not followed, and the returned path is guaranteed to be absolute.
         *
         * If `filename` is an absolute path, `relative_to` is ignored. Otherwise,
         * `relative_to` will be prepended to `filename` to make it absolute. `relative_to`
         * must be an absolute path, or %NULL. If `relative_to` is %NULL, it'll fallback
         * to g_get_current_dir().
         *
         * This function never fails, and will canonicalize file paths even if they don't
         * exist.
         *
         * No file system I/O is done.
         * @param filename the name of the file
         * @param relative_to the relative directory, or %NULL to use the current working directory
         * @returns a newly allocated string with the   canonical file path
         */
        function canonicalize_filename(filename: string, relative_to?: string | null): string;
        /**
         * A wrapper for the POSIX chdir() function. The function changes the
         * current directory of the process to `path`.
         *
         * See your C library manual for more details about chdir().
         * @param path a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @returns 0 on success, -1 if an error occurred.
         */
        function chdir(path: string): number;
        /**
         * Checks that the GLib library in use is compatible with the
         * given version.
         *
         * Generally you would pass in the constants %GLIB_MAJOR_VERSION,
         * %GLIB_MINOR_VERSION, %GLIB_MICRO_VERSION as the three arguments
         * to this function; that produces a check that the library in use
         * is compatible with the version of GLib the application or module
         * was compiled against.
         *
         * Compatibility is defined by two things: first the version
         * of the running library is newer than the version
         * ``required_major`.required_minor.`required_micro``. Second
         * the running library must be binary compatible with the
         * version ``required_major`.`required_minor`.`required_micro``
         * (same major version.)
         * @param required_major the required major version
         * @param required_minor the required minor version
         * @param required_micro the required micro version
         * @returns %NULL if the GLib library is   compatible with the given version, or a string describing the   version mismatch. The returned string is owned by GLib and must   not be modified or freed.
         */
        function check_version(required_major: number, required_minor: number, required_micro: number): string | null;
        /**
         * Gets the length in bytes of digests of type `checksum_type`
         * @param checksum_type a #GChecksumType
         * @returns the checksum length, or -1 if @checksum_type is not supported.
         */
        function checksum_type_get_length(checksum_type: ChecksumType | null): number;
        /**
         * Sets a function to be called when the child indicated by `pid`
         * exits, at the priority `priority`.
         *
         * If you obtain `pid` from [func`GLib`.spawn_async] or
         * [func`GLib`.spawn_async_with_pipes] you will need to pass
         * %G_SPAWN_DO_NOT_REAP_CHILD as flag to the spawn function for the child
         * watching to work.
         *
         * In many programs, you will want to call [func`GLib`.spawn_check_wait_status]
         * in the callback to determine whether or not the child exited
         * successfully.
         *
         * Also, note that on platforms where #GPid must be explicitly closed
         * (see [func`GLib`.spawn_close_pid]) `pid` must not be closed while the source
         * is still active.  Typically, you should invoke [func`GLib`.spawn_close_pid]
         * in the callback function for the source.
         *
         * GLib supports only a single callback per process id.
         * On POSIX platforms, the same restrictions mentioned for
         * [func`GLib`.child_watch_source_new] apply to this function.
         *
         * This internally creates a main loop source using
         * [func`GLib`.child_watch_source_new] and attaches it to the main loop context
         * using [method`GLib`.Source.attach]. You can do these steps manually if you
         * need greater control.
         * @param priority the priority of the idle source. Typically this will be in the   range between [const@GLib.PRIORITY_DEFAULT_IDLE] and   [const@GLib.PRIORITY_HIGH_IDLE].
         * @param pid process to watch. On POSIX the positive pid of a child process. On Windows a handle for a process (which doesn't have to be a child).
         * @param _function function to call
         * @param notify function to call when the idle is removed, or %NULL
         * @returns the ID (greater than 0) of the event source.
         */
        function child_watch_add(
            priority: number,
            pid: Pid,
            _function: ChildWatchFunc,
            notify?: DestroyNotify | null,
        ): number;
        /**
         * Creates a new child_watch source.
         *
         * The source will not initially be associated with any
         * [struct`GLib`.MainContext] and must be added to one with
         * [method`GLib`.Source.attach] before it will be executed.
         *
         * Note that child watch sources can only be used in conjunction with
         * `g_spawn...` when the %G_SPAWN_DO_NOT_REAP_CHILD flag is used.
         *
         * Note that on platforms where #GPid must be explicitly closed
         * (see [func`GLib`.spawn_close_pid]) `pid` must not be closed while the
         * source is still active. Typically, you will want to call
         * [func`GLib`.spawn_close_pid] in the callback function for the source.
         *
         * On POSIX platforms, the following restrictions apply to this API
         * due to limitations in POSIX process interfaces:
         *
         * * `pid` must be a child of this process
         * * `pid` must be positive
         * * the application must not call `waitpid` with a non-positive
         *   first argument, for instance in another thread
         * * the application must not wait for `pid` to exit by any other
         *   mechanism, including `waitpid(pid, ...)` or a second child-watch
         *   source for the same `pid`
         * * the application must not ignore `SIGCHLD`
         * * Before 2.78, the application could not send a signal (`kill()`) to the
         *   watched `pid` in a race free manner. Since 2.78, you can do that while the
         *   associated [struct`GLib`.MainContext] is acquired.
         * * Before 2.78, even after destroying the [struct`GLib`.Source], you could not
         *   be sure that `pid` wasn't already reaped. Hence, it was also not
         *   safe to `kill()` or `waitpid()` on the process ID after the child watch
         *   source was gone. Destroying the source before it fired made it
         *   impossible to reliably reap the process.
         *
         * If any of those conditions are not met, this and related APIs will
         * not work correctly. This can often be diagnosed via a GLib warning
         * stating that `ECHILD` was received by `waitpid`.
         *
         * Calling `waitpid` for specific processes other than `pid` remains a
         * valid thing to do.
         * @param pid process to watch. On POSIX the positive pid of a child process. On Windows a handle for a process (which doesn't have to be a child).
         * @returns the newly-created child watch source
         */
        function child_watch_source_new(pid: Pid): Source;
        /**
         * A wrapper for the POSIX chmod() function. The chmod() function is
         * used to set the permissions of a file system object.
         *
         * On Windows the file protection mechanism is not at all POSIX-like,
         * and the underlying chmod() function in the C library just sets or
         * clears the FAT-style READONLY attribute. It does not touch any
         * ACL. Software that needs to manage file permissions on Windows
         * exactly should use the Win32 API.
         *
         * See your C library manual for more details about chmod().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param mode as in chmod()
         * @returns 0 if the operation succeeded, -1 on error
         */
        function chmod(filename: string, mode: number): number;
        /**
         * If `err` or `*err` is %NULL, does nothing. Otherwise,
         * calls g_error_free() on `*err` and sets `*err` to %NULL.
         */
        function clear_error(): void;
        /**
         * This wraps the close() call. In case of error, %errno will be
         * preserved, but the error will also be stored as a #GError in `error`.
         * In case of success, %errno is undefined.
         *
         * Besides using #GError, there is another major reason to prefer this
         * function over the call provided by the system; on Unix, it will
         * attempt to correctly handle %EINTR, which has platform-specific
         * semantics.
         *
         * It is a bug to call this function with an invalid file descriptor.
         *
         * On POSIX platforms since GLib 2.76, this function is async-signal safe
         * if (and only if) `error` is %NULL and `fd` is a valid open file descriptor.
         * This makes it safe to call from a signal handler or a #GSpawnChildSetupFunc
         * under those conditions.
         * See [`signal(7)`](man:signal(7)) and
         * [`signal-safety(7)`](man:signal-safety(7)) for more details.
         * @param fd A file descriptor
         * @returns %TRUE on success, %FALSE if there was an error.
         */
        function close(fd: number): boolean;
        /**
         * Close every file descriptor equal to or greater than `lowfd`.
         *
         * Typically `lowfd` will be 3, to leave standard input, standard output
         * and standard error open.
         *
         * This is the same as Linux `close_range (lowfd, ~0U, 0)`,
         * but portable to other OSs and to older versions of Linux.
         * Equivalently, it is the same as BSD `closefrom (lowfd)`, but portable,
         * and async-signal-safe on all OSs.
         *
         * This function is async-signal safe, making it safe to call from a
         * signal handler or a [callback`GLib`.SpawnChildSetupFunc], as long as `lowfd` is
         * non-negative.
         * See [`signal(7)`](man:signal(7)) and
         * [`signal-safety(7)`](man:signal-safety(7)) for more details.
         * @param lowfd Minimum fd to close, which must be non-negative
         * @returns 0 on success, -1 with errno set on error
         */
        function closefrom(lowfd: number): number;
        /**
         * Computes the checksum for a binary `data`. This is a
         * convenience wrapper for g_checksum_new(), g_checksum_get_string()
         * and g_checksum_free().
         *
         * The hexadecimal string returned will be in lower case.
         * @param checksum_type a #GChecksumType
         * @param data binary blob to compute the digest of
         * @returns the digest of the binary data as a   string in hexadecimal, or %NULL if g_checksum_new() fails for   @checksum_type. The returned string should be freed with g_free() when   done using it.
         */
        function compute_checksum_for_bytes(
            checksum_type: ChecksumType | null,
            data: Bytes | Uint8Array,
        ): string | null;
        /**
         * Computes the checksum for a binary `data` of `length`. This is a
         * convenience wrapper for g_checksum_new(), g_checksum_get_string()
         * and g_checksum_free().
         *
         * The hexadecimal string returned will be in lower case.
         * @param checksum_type a #GChecksumType
         * @param data binary blob to compute the digest of
         * @returns the digest of the binary data as a   string in hexadecimal, or %NULL if g_checksum_new() fails for   @checksum_type. The returned string should be freed with g_free() when   done using it.
         */
        function compute_checksum_for_data(
            checksum_type: ChecksumType | null,
            data: Uint8Array | string,
        ): string | null;
        /**
         * Computes the checksum of a string.
         *
         * The hexadecimal string returned will be in lower case.
         * @param checksum_type a #GChecksumType
         * @param str the string to compute the checksum of
         * @param length the length of the string, or -1 if the string is null-terminated.
         * @returns the checksum as a hexadecimal string,   or %NULL if g_checksum_new() fails for @checksum_type. The returned string   should be freed with g_free() when done using it.
         */
        function compute_checksum_for_string(
            checksum_type: ChecksumType | null,
            str: string,
            length: number,
        ): string | null;
        /**
         * Computes the HMAC for a binary `data`. This is a
         * convenience wrapper for g_hmac_new(), g_hmac_get_string()
         * and g_hmac_unref().
         *
         * The hexadecimal string returned will be in lower case.
         * @param digest_type a #GChecksumType to use for the HMAC
         * @param key the key to use in the HMAC
         * @param data binary blob to compute the HMAC of
         * @returns the HMAC of the binary data as a string in hexadecimal.   The returned string should be freed with g_free() when done using it.
         */
        function compute_hmac_for_bytes(
            digest_type: ChecksumType | null,
            key: Bytes | Uint8Array,
            data: Bytes | Uint8Array,
        ): string;
        /**
         * Computes the HMAC for a binary `data` of `length`. This is a
         * convenience wrapper for g_hmac_new(), g_hmac_get_string()
         * and g_hmac_unref().
         *
         * The hexadecimal string returned will be in lower case.
         * @param digest_type a #GChecksumType to use for the HMAC
         * @param key the key to use in the HMAC
         * @param data binary blob to compute the HMAC of
         * @returns the HMAC of the binary data as a string in hexadecimal.   The returned string should be freed with g_free() when done using it.
         */
        function compute_hmac_for_data(
            digest_type: ChecksumType | null,
            key: Uint8Array | string,
            data: Uint8Array | string,
        ): string;
        /**
         * Computes the HMAC for a string.
         *
         * The hexadecimal string returned will be in lower case.
         * @param digest_type a #GChecksumType to use for the HMAC
         * @param key the key to use in the HMAC
         * @param str the string to compute the HMAC for
         * @param length the length of the string, or -1 if the string is nul-terminated
         * @returns the HMAC as a hexadecimal string.     The returned string should be freed with g_free()     when done using it.
         */
        function compute_hmac_for_string(
            digest_type: ChecksumType | null,
            key: Uint8Array | string,
            str: string,
            length: number,
        ): string;
        /**
         * Converts a string from one character set to another.
         *
         * Note that you should use g_iconv() for streaming conversions.
         * Despite the fact that `bytes_read` can return information about partial
         * characters, the g_convert_... functions are not generally suitable
         * for streaming. If the underlying converter maintains internal state,
         * then this won't be preserved across successive calls to g_convert(),
         * g_convert_with_iconv() or g_convert_with_fallback(). (An example of
         * this is the GNU C converter for CP1255 which does not emit a base
         * character until it knows that the next character is not a mark that
         * could combine with the base character.)
         *
         * Using extensions such as "//TRANSLIT" may not work (or may not work
         * well) on many platforms.  Consider using g_str_to_ascii() instead.
         * @param str the string to convert.
         * @param to_codeset name of character set into which to convert @str
         * @param from_codeset character set of @str.
         * @returns If the conversion was successful, a newly allocated buffer          containing the converted string, which must be freed with g_free().          Otherwise %NULL and @error will be set.
         */
        function convert(str: Uint8Array | string, to_codeset: string, from_codeset: string): [Uint8Array, number];
        function convert_error_quark(): Quark;
        /**
         * Converts a string from one character set to another, possibly
         * including fallback sequences for characters not representable
         * in the output. Note that it is not guaranteed that the specification
         * for the fallback sequences in `fallback` will be honored. Some
         * systems may do an approximate conversion from `from_codeset`
         * to `to_codeset` in their iconv() functions,
         * in which case GLib will simply return that approximate conversion.
         *
         * Note that you should use g_iconv() for streaming conversions.
         * Despite the fact that `bytes_read` can return information about partial
         * characters, the g_convert_... functions are not generally suitable
         * for streaming. If the underlying converter maintains internal state,
         * then this won't be preserved across successive calls to g_convert(),
         * g_convert_with_iconv() or g_convert_with_fallback(). (An example of
         * this is the GNU C converter for CP1255 which does not emit a base
         * character until it knows that the next character is not a mark that
         * could combine with the base character.)
         * @param str the string to convert.
         * @param to_codeset name of character set into which to convert @str
         * @param from_codeset character set of @str.
         * @param fallback UTF-8 string to use in place of characters not                present in the target encoding. (The string must be                representable in the target encoding).                If %NULL, characters not in the target encoding will                be represented as Unicode escapes \uxxxx or \Uxxxxyyyy.
         * @returns If the conversion was successful, a newly allocated buffer          containing the converted string, which must be freed with g_free().          Otherwise %NULL and @error will be set.
         */
        function convert_with_fallback(
            str: Uint8Array | string,
            to_codeset: string,
            from_codeset: string,
            fallback: string,
        ): [Uint8Array, number];
        /**
         * A wrapper for the POSIX creat() function. The creat() function is
         * used to convert a pathname into a file descriptor, creating a file
         * if necessary.
         *
         * On POSIX systems file descriptors are implemented by the operating
         * system. On Windows, it's the C library that implements creat() and
         * file descriptors. The actual Windows API for opening files is
         * different, see MSDN documentation for CreateFile(). The Win32 API
         * uses file handles, which are more randomish integers, not small
         * integers like file descriptors.
         *
         * Because file descriptors are specific to the C library on Windows,
         * the file descriptor returned by this function makes sense only to
         * functions in the same C library. Thus if the GLib-using code uses a
         * different C library than GLib does, the file descriptor returned by
         * this function cannot be passed to C library functions like write()
         * or read().
         *
         * See your C library manual for more details about creat().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param mode as in creat()
         * @returns a new file descriptor, or -1 if an error occurred.     The return value can be used exactly like the return value     from creat().
         */
        function creat(filename: string, mode: number): number;
        /**
         * Calls the given function for each data element of the datalist. The
         * function is called with each data element's #GQuark id and data,
         * together with the given `user_data` parameter. Note that this
         * function is NOT thread-safe. So unless `datalist` can be protected
         * from any modifications during invocation of this function, it should
         * not be called.
         *
         * `func` can make changes to `datalist,` but the iteration will not
         * reflect changes made during the g_datalist_foreach() call, other
         * than skipping over elements that are removed.
         * @param datalist a datalist.
         * @param func the function to call for each data element.
         */
        function datalist_foreach(datalist: Data, func: DataForeachFunc): void;
        /**
         * Gets a data element, using its string identifier. This is slower than
         * g_datalist_id_get_data() because it compares strings.
         * @param datalist a datalist.
         * @param key the string identifying a data element.
         * @returns the data element, or %NULL if it          is not found.
         */
        function datalist_get_data(datalist: Data, key: string): any | null;
        /**
         * Gets flags values packed in together with the datalist.
         * See g_datalist_set_flags().
         * @param datalist pointer to the location that holds a list
         * @returns the flags of the datalist
         */
        function datalist_get_flags(datalist: Data): number;
        /**
         * Retrieves the data element corresponding to `key_id`.
         * @param datalist a datalist.
         * @param key_id the #GQuark identifying a data element.
         * @returns the data element, or %NULL if          it is not found.
         */
        function datalist_id_get_data(datalist: Data, key_id: Quark): any | null;
        /**
         * Removes multiple keys from a datalist.
         *
         * This is more efficient than calling g_datalist_id_remove_data()
         * multiple times in a row.
         *
         * Before 2.80, `n_keys` had to be not larger than 16.
         * Since 2.84, performance is improved for larger number of keys.
         * @param datalist a datalist
         * @param keys keys to remove
         */
        function datalist_id_remove_multiple(datalist: Data, keys: Quark[]): void;
        /**
         * Turns on flag values for a data list. This function is used
         * to keep a small number of boolean flags in an object with
         * a data list without using any additional space. It is
         * not generally useful except in circumstances where space
         * is very tight. (It is used in the base #GObject type, for
         * example.)
         * @param datalist pointer to the location that holds a list
         * @param flags the flags to turn on. The values of the flags are   restricted by %G_DATALIST_FLAGS_MASK (currently   3; giving two possible boolean flags).   A value for @flags that doesn't fit within the mask is   an error.
         */
        function datalist_set_flags(datalist: Data, flags: number): void;
        /**
         * Turns off flag values for a data list. See g_datalist_unset_flags()
         * @param datalist pointer to the location that holds a list
         * @param flags the flags to turn off. The values of the flags are   restricted by %G_DATALIST_FLAGS_MASK (currently   3: giving two possible boolean flags).   A value for @flags that doesn't fit within the mask is   an error.
         */
        function datalist_unset_flags(datalist: Data, flags: number): void;
        /**
         * Destroys the dataset, freeing all memory allocated, and calling any
         * destroy functions set for data elements.
         * @param dataset_location the location identifying the dataset.
         */
        function dataset_destroy(dataset_location: any): void;
        /**
         * Calls the given function for each data element which is associated
         * with the given location. Note that this function is NOT thread-safe.
         * So unless `dataset_location` can be protected from any modifications
         * during invocation of this function, it should not be called.
         *
         * `func` can make changes to the dataset, but the iteration will not
         * reflect changes made during the g_dataset_foreach() call, other
         * than skipping over elements that are removed.
         * @param dataset_location the location identifying the dataset.
         * @param func the function to call for each data element.
         */
        function dataset_foreach(dataset_location: any, func: DataForeachFunc): void;
        /**
         * Gets the data element corresponding to a #GQuark.
         * @param dataset_location the location identifying the dataset.
         * @param key_id the #GQuark id to identify the data element.
         * @returns the data element corresponding to          the #GQuark, or %NULL if it is not found.
         */
        function dataset_id_get_data(dataset_location: any, key_id: Quark): any | null;
        /**
         * Returns the number of days in a month, taking leap
         * years into account.
         * @param month month
         * @param year year
         * @returns number of days in @month during the @year
         */
        function date_get_days_in_month(month: DateMonth | null, year: DateYear): number;
        /**
         * Returns the number of weeks in the year, where weeks
         * are taken to start on Monday. Will be 52 or 53. The
         * date must be valid. (Years always have 52 7-day periods,
         * plus 1 or 2 extra days depending on whether it's a leap
         * year. This function is basically telling you how many
         * Mondays are in the year, i.e. there are 53 Mondays if
         * one of the extra days happens to be a Monday.)
         * @param year a year
         * @returns number of Mondays in the year
         */
        function date_get_monday_weeks_in_year(year: DateYear): number;
        /**
         * Returns the number of weeks in the year, where weeks
         * are taken to start on Sunday. Will be 52 or 53. The
         * date must be valid. (Years always have 52 7-day periods,
         * plus 1 or 2 extra days depending on whether it's a leap
         * year. This function is basically telling you how many
         * Sundays are in the year, i.e. there are 53 Sundays if
         * one of the extra days happens to be a Sunday.)
         * @param year year to count weeks in
         * @returns the number of weeks in @year
         */
        function date_get_sunday_weeks_in_year(year: DateYear): number;
        /**
         * Returns %TRUE if the year is a leap year.
         *
         * For the purposes of this function, leap year is every year
         * divisible by 4 unless that year is divisible by 100. If it
         * is divisible by 100 it would be a leap year only if that year
         * is also divisible by 400.
         * @param year year to check
         * @returns %TRUE if the year is a leap year
         */
        function date_is_leap_year(year: DateYear): boolean;
        /**
         * Generates a printed representation of the date, in a
         * [locale](running.html#locale)-specific way.
         * Works just like the platform's C library strftime() function,
         * but only accepts date-related formats; time-related formats
         * give undefined results. Date must be valid. Unlike strftime()
         * (which uses the locale encoding), works on a UTF-8 format
         * string and stores a UTF-8 result.
         *
         * This function does not provide any conversion specifiers in
         * addition to those implemented by the platform's C library.
         * For example, don't expect that using g_date_strftime() would
         * make the \%F provided by the C99 strftime() work on Windows
         * where the C library only complies to C89.
         * @param s destination buffer
         * @param slen buffer size
         * @param format format string
         * @param date valid #GDate
         * @returns number of characters written to the buffer, or `0` if the buffer was too small
         */
        function date_strftime(s: string, slen: number, format: string, date: Date): number;
        /**
         * Returns %TRUE if the day of the month is valid (a day is valid if it's
         * between 1 and 31 inclusive).
         * @param day day to check
         * @returns %TRUE if the day is valid
         */
        function date_valid_day(day: DateDay): boolean;
        /**
         * Returns %TRUE if the day-month-year triplet forms a valid, existing day
         * in the range of days #GDate understands (Year 1 or later, no more than
         * a few thousand years in the future).
         * @param day day
         * @param month month
         * @param year year
         * @returns %TRUE if the date is a valid one
         */
        function date_valid_dmy(day: DateDay, month: DateMonth | null, year: DateYear): boolean;
        /**
         * Returns %TRUE if the Julian day is valid. Anything greater than zero
         * is basically a valid Julian, though there is a 32-bit limit.
         * @param julian_date Julian day to check
         * @returns %TRUE if the Julian day is valid
         */
        function date_valid_julian(julian_date: number): boolean;
        /**
         * Returns %TRUE if the month value is valid. The 12 #GDateMonth
         * enumeration values are the only valid months.
         * @param month month
         * @returns %TRUE if the month is valid
         */
        function date_valid_month(month: DateMonth | null): boolean;
        /**
         * Returns %TRUE if the weekday is valid. The seven #GDateWeekday enumeration
         * values are the only valid weekdays.
         * @param weekday weekday
         * @returns %TRUE if the weekday is valid
         */
        function date_valid_weekday(weekday: DateWeekday | null): boolean;
        /**
         * Returns %TRUE if the year is valid. Any year greater than 0 is valid,
         * though there is a 16-bit limit to what #GDate will understand.
         * @param year year
         * @returns %TRUE if the year is valid
         */
        function date_valid_year(year: DateYear): boolean;
        /**
         * This is a variant of g_dgettext() that allows specifying a locale
         * category instead of always using `LC_MESSAGES`. See g_dgettext() for
         * more information about how this functions differs from calling
         * dcgettext() directly.
         * @param domain the translation domain to use, or %NULL to use   the domain set with textdomain()
         * @param msgid message to translate
         * @param category a locale category
         * @returns the translated string for the given locale category
         */
        function dcgettext(domain: string | null, msgid: string, category: number): string;
        /**
         * This function is a wrapper of dgettext() which does not translate
         * the message if the default domain as set with textdomain() has no
         * translations for the current locale.
         *
         * The advantage of using this function over dgettext() proper is that
         * libraries using this function (like GTK) will not use translations
         * if the application using the library does not have translations for
         * the current locale.  This results in a consistent English-only
         * interface instead of one having partial translations.  For this
         * feature to work, the call to textdomain() and setlocale() should
         * precede any g_dgettext() invocations.  For GTK, it means calling
         * textdomain() before gtk_init or its variants.
         *
         * This function disables translations if and only if upon its first
         * call all the following conditions hold:
         *
         * - `domain` is not %NULL
         *
         * - textdomain() has been called to set a default text domain
         *
         * - there is no translations available for the default text domain
         *   and the current locale
         *
         * - current locale is not "C" or any English locales (those
         *   starting with "en_")
         *
         * Note that this behavior may not be desired for example if an application
         * has its untranslated messages in a language other than English. In those
         * cases the application should call textdomain() after initializing GTK.
         *
         * Applications should normally not use this function directly,
         * but use the _() macro for translations.
         * @param domain the translation domain to use, or %NULL to use   the domain set with textdomain()
         * @param msgid message to translate
         * @returns The translated string
         */
        function dgettext(domain: string | null, msgid: string): string;
        /**
         * Creates a subdirectory in the preferred directory for temporary
         * files (as returned by g_get_tmp_dir()).
         *
         * `tmpl` should be a string in the GLib file name encoding containing
         * a sequence of six 'X' characters, as the parameter to g_mkstemp().
         * However, unlike these functions, the template should only be a
         * basename, no directory components are allowed. If template is
         * %NULL, a default template is used.
         *
         * Note that in contrast to g_mkdtemp() (and mkdtemp()) `tmpl` is not
         * modified, and might thus be a read-only literal string.
         * @param tmpl Template for directory name,   as in g_mkdtemp(), basename only, or %NULL for a default template
         * @returns The actual name used. This string   should be freed with g_free() when not needed any longer and is   is in the GLib file name encoding. In case of errors, %NULL is   returned and @error will be set.
         */
        function dir_make_tmp(tmpl?: string | null): string;
        /**
         * Compares two #gpointer arguments and returns %TRUE if they are equal.
         * It can be passed to g_hash_table_new() as the `key_equal_func`
         * parameter, when using opaque pointers compared by pointer value as
         * keys in a #GHashTable.
         *
         * This equality function is also appropriate for keys that are integers
         * stored in pointers, such as `GINT_TO_POINTER (n)`.
         * @param v1 a key
         * @param v2 a key to compare with @v1
         * @returns %TRUE if the two keys match.
         */
        function direct_equal(v1?: any | null, v2?: any | null): boolean;
        /**
         * Converts a gpointer to a hash value.
         * It can be passed to g_hash_table_new() as the `hash_func` parameter,
         * when using opaque pointers compared by pointer value as keys in a
         * #GHashTable.
         *
         * This hash function is also appropriate for keys that are integers
         * stored in pointers, such as `GINT_TO_POINTER (n)`.
         * @param v a #gpointer key
         * @returns a hash value corresponding to the key.
         */
        function direct_hash(v?: any | null): number;
        /**
         * This function is a wrapper of dngettext() which does not translate
         * the message if the default domain as set with textdomain() has no
         * translations for the current locale.
         *
         * See g_dgettext() for details of how this differs from dngettext()
         * proper.
         * @param domain the translation domain to use, or %NULL to use   the domain set with textdomain()
         * @param msgid message to translate
         * @param msgid_plural plural form of the message
         * @param n the quantity for which translation is needed
         * @returns The translated string
         */
        function dngettext(domain: string | null, msgid: string, msgid_plural: string, n: number): string;
        /**
         * Compares the two #gdouble values being pointed to and returns
         * %TRUE if they are equal.
         * It can be passed to g_hash_table_new() as the `key_equal_func`
         * parameter, when using non-%NULL pointers to doubles as keys in a
         * #GHashTable.
         * @param v1 a pointer to a #gdouble key
         * @param v2 a pointer to a #gdouble key to compare with @v1
         * @returns %TRUE if the two keys match.
         */
        function double_equal(v1: any, v2: any): boolean;
        /**
         * Converts a pointer to a #gdouble to a hash value.
         * It can be passed to g_hash_table_new() as the `hash_func` parameter,
         * It can be passed to g_hash_table_new() as the `hash_func` parameter,
         * when using non-%NULL pointers to doubles as keys in a #GHashTable.
         * @param v a pointer to a #gdouble key
         * @returns a hash value corresponding to the key.
         */
        function double_hash(v: any): number;
        /**
         * This function is a variant of g_dgettext() which supports
         * a disambiguating message context. GNU gettext uses the
         * '\004' character to separate the message context and
         * message id in `msgctxtid`.
         * If 0 is passed as `msgidoffset,` this function will fall back to
         * trying to use the deprecated convention of using "|" as a separation
         * character.
         *
         * This uses g_dgettext() internally. See that functions for differences
         * with dgettext() proper.
         *
         * Applications should normally not use this function directly,
         * but use the C_() macro for translations with context.
         * @param domain the translation domain to use, or %NULL to use   the domain set with textdomain()
         * @param msgctxtid a combined message context and message id, separated   by a \004 character
         * @param msgidoffset the offset of the message id in @msgctxid
         * @returns The translated string
         */
        function dpgettext(domain: string | null, msgctxtid: string, msgidoffset: number): string;
        /**
         * This function is a variant of g_dgettext() which supports
         * a disambiguating message context. GNU gettext uses the
         * '\004' character to separate the message context and
         * message id in `msgctxtid`.
         *
         * This uses g_dgettext() internally. See that functions for differences
         * with dgettext() proper.
         *
         * This function differs from C_() in that it is not a macro and
         * thus you may use non-string-literals as context and msgid arguments.
         * @param domain the translation domain to use, or %NULL to use   the domain set with textdomain()
         * @param context the message context
         * @param msgid the message
         * @returns The translated string
         */
        function dpgettext2(domain: string | null, context: string, msgid: string): string;
        /**
         * Returns the value of the environment variable `variable` in the
         * provided list `envp`.
         * @param envp an environment list (eg, as returned from g_get_environ()), or %NULL     for an empty environment list
         * @param variable the environment variable to get
         * @returns the value of the environment variable, or %NULL if     the environment variable is not set in @envp. The returned     string is owned by @envp, and will be freed if @variable is     set or unset again.
         */
        function environ_getenv(envp: string[] | null, variable: string): string | null;
        /**
         * Sets the environment variable `variable` in the provided list
         * `envp` to `value`.
         * @param envp an environment list that can be freed using g_strfreev() (e.g., as     returned from g_get_environ()), or %NULL for an empty     environment list
         * @param variable the environment variable to set, must not     contain '='
         * @param value the value for to set the variable to
         * @param overwrite whether to change the variable if it already exists
         * @returns the updated environment list. Free it using g_strfreev().
         */
        function environ_setenv(envp: string[] | null, variable: string, value: string, overwrite: boolean): string[];
        /**
         * Removes the environment variable `variable` from the provided
         * environment `envp`.
         * @param envp an environment list that can be freed using g_strfreev() (e.g., as     returned from g_get_environ()), or %NULL for an empty environment list
         * @param variable the environment variable to remove, must not     contain '='
         * @returns the updated environment list. Free it using g_strfreev().
         */
        function environ_unsetenv(envp: string[] | null, variable: string): string[];
        /**
         * This function registers an extended #GError domain.
         * `error_type_name` will be duplicated. Otherwise does the same as
         * g_error_domain_register_static().
         * @param error_type_name string to create a #GQuark from
         * @param error_type_private_size size of the private error data in bytes
         * @param error_type_init function initializing fields of the private error data
         * @param error_type_copy function copying fields of the private error data
         * @param error_type_clear function freeing fields of the private error data
         * @returns #GQuark representing the error domain
         */
        function error_domain_register(
            error_type_name: string,
            error_type_private_size: number,
            error_type_init: ErrorInitFunc,
            error_type_copy: ErrorCopyFunc,
            error_type_clear: ErrorClearFunc,
        ): Quark;
        /**
         * This function registers an extended #GError domain.
         *
         * `error_type_name` should not be freed. `error_type_private_size` must
         * be greater than 0.
         *
         * `error_type_init` receives an initialized #GError and should then initialize
         * the private data.
         *
         * `error_type_copy` is a function that receives both original and a copy
         * #GError and should copy the fields of the private error data. The standard
         * #GError fields are already handled.
         *
         * `error_type_clear` receives the pointer to the error, and it should free the
         * fields of the private error data. It should not free the struct itself though.
         *
         * Normally, it is better to use G_DEFINE_EXTENDED_ERROR(), as it
         * already takes care of passing valid information to this function.
         * @param error_type_name static string to create a #GQuark from
         * @param error_type_private_size size of the private error data in bytes
         * @param error_type_init function initializing fields of the private error data
         * @param error_type_copy function copying fields of the private error data
         * @param error_type_clear function freeing fields of the private error data
         * @returns #GQuark representing the error domain
         */
        function error_domain_register_static(
            error_type_name: string,
            error_type_private_size: number,
            error_type_init: ErrorInitFunc,
            error_type_copy: ErrorCopyFunc,
            error_type_clear: ErrorClearFunc,
        ): Quark;
        /**
         * Mark every file descriptor equal to or greater than `lowfd` to be closed
         * at the next `execve()` or similar, as if via the `FD_CLOEXEC` flag.
         *
         * Typically `lowfd` will be 3, to leave standard input, standard output
         * and standard error open after exec.
         *
         * This is the same as Linux `close_range (lowfd, ~0U, CLOSE_RANGE_CLOEXEC)`,
         * but portable to other OSs and to older versions of Linux.
         *
         * This function is async-signal safe, making it safe to call from a
         * signal handler or a [callback`GLib`.SpawnChildSetupFunc], as long as `lowfd` is
         * non-negative.
         * See [`signal(7)`](man:signal(7)) and
         * [`signal-safety(7)`](man:signal-safety(7)) for more details.
         * @param lowfd Minimum fd to act on, which must be non-negative
         * @returns 0 on success, -1 with errno set on error
         */
        function fdwalk_set_cloexec(lowfd: number): number;
        /**
         * Gets a #GFileError constant based on the passed-in `err_no`.
         *
         * For example, if you pass in `EEXIST` this function returns
         * %G_FILE_ERROR_EXIST. Unlike `errno` values, you can portably
         * assume that all #GFileError values will exist.
         *
         * Normally a #GFileError value goes into a #GError returned
         * from a function that manipulates files. So you would use
         * g_file_error_from_errno() when constructing a #GError.
         * @param err_no an "errno" value
         * @returns #GFileError corresponding to the given @err_no
         */
        function file_error_from_errno(err_no: number): FileError;
        function file_error_quark(): Quark;
        /**
         * Reads an entire file into allocated memory, with good error
         * checking.
         *
         * If the call was successful, it returns %TRUE and sets `contents` to the file
         * contents and `length` to the length of the file contents in bytes. The string
         * stored in `contents` will be nul-terminated, so for text files you can pass
         * %NULL for the `length` argument. If the call was not successful, it returns
         * %FALSE and sets `error`. The error domain is %G_FILE_ERROR. Possible error
         * codes are those in the #GFileError enumeration. In the error case,
         * `contents` is set to %NULL and `length` is set to zero.
         * @param filename name of a file to read contents from, in the GLib file name encoding
         * @returns %TRUE on success, %FALSE if an error occurred
         */
        function file_get_contents(filename: string): [boolean, Uint8Array];
        /**
         * Opens a file for writing in the preferred directory for temporary
         * files (as returned by g_get_tmp_dir()).
         *
         * `tmpl` should be a string in the GLib file name encoding containing
         * a sequence of six 'X' characters, as the parameter to g_mkstemp().
         * However, unlike these functions, the template should only be a
         * basename, no directory components are allowed. If template is
         * %NULL, a default template is used.
         *
         * Note that in contrast to g_mkstemp() (and mkstemp()) `tmpl` is not
         * modified, and might thus be a read-only literal string.
         *
         * Upon success, and if `name_used` is non-%NULL, the actual name used
         * is returned in `name_used`. This string should be freed with g_free()
         * when not needed any longer. The returned name is in the GLib file
         * name encoding.
         * @param tmpl Template for file name, as in   g_mkstemp(), basename only, or %NULL for a default template
         * @returns A file handle (as from open()) to the file opened for   reading and writing. The file is opened in binary mode on platforms   where there is a difference. The file handle should be closed with   close(). In case of errors, -1 is returned and @error will be set.
         */
        function file_open_tmp(tmpl: string | null): [number, string];
        /**
         * Reads the contents of the symbolic link `filename` like the POSIX
         * `readlink()` function.
         *
         * The returned string is in the encoding used for filenames. Use
         * g_filename_to_utf8() to convert it to UTF-8.
         *
         * The returned string may also be a relative path. Use g_build_filename()
         * to convert it to an absolute path:
         *
         *
         * ```c
         * g_autoptr(GError) local_error = NULL;
         * g_autofree gchar *link_target = g_file_read_link ("/etc/localtime", &local_error);
         *
         * if (local_error != NULL)
         *   g_error ("Error reading link: %s", local_error->message);
         *
         * if (!g_path_is_absolute (link_target))
         *   {
         *     g_autofree gchar *absolute_link_target = g_build_filename ("/etc", link_target, NULL);
         *     g_free (link_target);
         *     link_target = g_steal_pointer (&absolute_link_target);
         *   }
         * ```
         *
         * @param filename the symbolic link
         * @returns A newly-allocated string with   the contents of the symbolic link, or %NULL if an error occurred.
         */
        function file_read_link(filename: string): string;
        /**
         * Writes all of `contents` to a file named `filename`. This is a convenience
         * wrapper around calling g_file_set_contents_full() with `flags` set to
         * `G_FILE_SET_CONTENTS_CONSISTENT | G_FILE_SET_CONTENTS_ONLY_EXISTING` and
         * `mode` set to `0666`.
         * @param filename name of a file to write @contents to, in the GLib file name   encoding
         * @param contents string to write to the file
         * @returns %TRUE on success, %FALSE if an error occurred
         */
        function file_set_contents(filename: string, contents: Uint8Array | string): boolean;
        /**
         * Writes all of `contents` to a file named `filename,` with good error checking.
         * If a file called `filename` already exists it will be overwritten.
         *
         * `flags` control the properties of the write operation: whether it’s atomic,
         * and what the tradeoff is between returning quickly or being resilient to
         * system crashes.
         *
         * As this function performs file I/O, it is recommended to not call it anywhere
         * where blocking would cause problems, such as in the main loop of a graphical
         * application. In particular, if `flags` has any value other than
         * %G_FILE_SET_CONTENTS_NONE then this function may call `fsync()`.
         *
         * If %G_FILE_SET_CONTENTS_CONSISTENT is set in `flags,` the operation is atomic
         * in the sense that it is first written to a temporary file which is then
         * renamed to the final name.
         *
         * Notes:
         *
         * - On UNIX, if `filename` already exists hard links to `filename` will break.
         *   Also since the file is recreated, existing permissions, access control
         *   lists, metadata etc. may be lost. If `filename` is a symbolic link,
         *   the link itself will be replaced, not the linked file.
         *
         * - On UNIX, if `filename` already exists and is non-empty, and if the system
         *   supports it (via a journalling filesystem or equivalent), and if
         *   %G_FILE_SET_CONTENTS_CONSISTENT is set in `flags,` the `fsync()` call (or
         *   equivalent) will be used to ensure atomic replacement: `filename`
         *   will contain either its old contents or `contents,` even in the face of
         *   system power loss, the disk being unsafely removed, etc.
         *
         * - On UNIX, if `filename` does not already exist or is empty, there is a
         *   possibility that system power loss etc. after calling this function will
         *   leave `filename` empty or full of NUL bytes, depending on the underlying
         *   filesystem, unless %G_FILE_SET_CONTENTS_DURABLE and
         *   %G_FILE_SET_CONTENTS_CONSISTENT are set in `flags`.
         *
         * - On Windows renaming a file will not remove an existing file with the
         *   new name, so on Windows there is a race condition between the existing
         *   file being removed and the temporary file being renamed.
         *
         * - On Windows there is no way to remove a file that is open to some
         *   process, or mapped into memory. Thus, this function will fail if
         *   `filename` already exists and is open.
         *
         * If the call was successful, it returns %TRUE. If the call was not successful,
         * it returns %FALSE and sets `error`. The error domain is %G_FILE_ERROR.
         * Possible error codes are those in the #GFileError enumeration.
         *
         * Note that the name for the temporary file is constructed by appending up
         * to 7 characters to `filename`.
         *
         * If the file didn’t exist before and is created, it will be given the
         * permissions from `mode`. Otherwise, the permissions of the existing file may
         * be changed to `mode` depending on `flags,` or they may remain unchanged.
         * @param filename name of a file to write @contents to, in the GLib file name   encoding
         * @param contents string to write to the file
         * @param flags flags controlling the safety vs speed of the operation
         * @param mode file mode, as passed to `open()`; typically this will be `0666`
         * @returns %TRUE on success, %FALSE if an error occurred
         */
        function file_set_contents_full(
            filename: string,
            contents: Uint8Array | string,
            flags: FileSetContentsFlags | null,
            mode: number,
        ): boolean;
        /**
         * Returns %TRUE if any of the tests in the bitfield `test` are
         * %TRUE. For example, `(G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)`
         * will return %TRUE if the file exists; the check whether it's a
         * directory doesn't matter since the existence test is %TRUE. With
         * the current set of available tests, there's no point passing in
         * more than one test at a time.
         *
         * Apart from %G_FILE_TEST_IS_SYMLINK all tests follow symbolic links,
         * so for a symbolic link to a regular file g_file_test() will return
         * %TRUE for both %G_FILE_TEST_IS_SYMLINK and %G_FILE_TEST_IS_REGULAR.
         *
         * Note, that for a dangling symbolic link g_file_test() will return
         * %TRUE for %G_FILE_TEST_IS_SYMLINK and %FALSE for all other flags.
         *
         * You should never use g_file_test() to test whether it is safe
         * to perform an operation, because there is always the possibility
         * of the condition changing before you actually perform the operation,
         * see [TOCTOU](https://en.wikipedia.org/wiki/Time-of-check_to_time-of-use).
         *
         * For example, you might think you could use %G_FILE_TEST_IS_SYMLINK
         * to know whether it is safe to write to a file without being
         * tricked into writing into a different location. It doesn't work!
         *
         *
         * ```c
         *  // DON'T DO THIS
         *  if (!g_file_test (filename, G_FILE_TEST_IS_SYMLINK))
         *    {
         *      fd = g_open (filename, O_WRONLY);
         *      // write to fd
         *    }
         *
         *  // DO THIS INSTEAD
         *  fd = g_open (filename, O_WRONLY | O_NOFOLLOW | O_CLOEXEC);
         *  if (fd == -1)
         *    {
         *      // check error
         *      if (errno == ELOOP)
         *        // file is a symlink and can be ignored
         *      else
         *        // handle errors as before
         *    }
         *  else
         *    {
         *      // write to fd
         *    }
         * ```
         *
         *
         * Another thing to note is that %G_FILE_TEST_EXISTS and
         * %G_FILE_TEST_IS_EXECUTABLE are implemented using the access()
         * system call. This usually doesn't matter, but if your program
         * is setuid or setgid it means that these tests will give you
         * the answer for the real user ID and group ID, rather than the
         * effective user ID and group ID.
         *
         * On Windows, there are no symlinks, so testing for
         * %G_FILE_TEST_IS_SYMLINK will always return %FALSE. Testing for
         * %G_FILE_TEST_IS_EXECUTABLE will just check that the file exists and
         * its name indicates that it is executable, checking for well-known
         * extensions and those listed in the `PATHEXT` environment variable.
         * @param filename a filename to test in the     GLib file name encoding
         * @param test bitfield of #GFileTest flags
         * @returns whether a test was %TRUE
         */
        function file_test(filename: string, test: FileTest | null): boolean;
        /**
         * Returns the display basename for the particular filename, guaranteed
         * to be valid UTF-8. The display name might not be identical to the filename,
         * for instance there might be problems converting it to UTF-8, and some files
         * can be translated in the display.
         *
         * If GLib cannot make sense of the encoding of `filename,` as a last resort it
         * replaces unknown characters with U+FFFD, the Unicode replacement character.
         * You can search the result for the UTF-8 encoding of this character (which is
         * "\357\277\275" in octal notation) to find out if `filename` was in an invalid
         * encoding.
         *
         * You must pass the whole absolute pathname to this functions so that
         * translation of well known locations can be done.
         *
         * This function is preferred over g_filename_display_name() if you know the
         * whole path, as it allows translation.
         * @param filename an absolute pathname in the     GLib file name encoding
         * @returns a newly allocated string containing   a rendition of the basename of the filename in valid UTF-8
         */
        function filename_display_basename(filename: string): string;
        /**
         * Converts a filename into a valid UTF-8 string. The conversion is
         * not necessarily reversible, so you should keep the original around
         * and use the return value of this function only for display purposes.
         * Unlike g_filename_to_utf8(), the result is guaranteed to be non-%NULL
         * even if the filename actually isn't in the GLib file name encoding.
         *
         * If GLib cannot make sense of the encoding of `filename,` as a last resort it
         * replaces unknown characters with U+FFFD, the Unicode replacement character.
         * You can search the result for the UTF-8 encoding of this character (which is
         * "\357\277\275" in octal notation) to find out if `filename` was in an invalid
         * encoding.
         *
         * If you know the whole pathname of the file you should use
         * g_filename_display_basename(), since that allows location-based
         * translation of filenames.
         * @param filename a pathname hopefully in the     GLib file name encoding
         * @returns a newly allocated string containing   a rendition of the filename in valid UTF-8
         */
        function filename_display_name(filename: string): string;
        /**
         * Converts an escaped ASCII-encoded URI to a local filename in the
         * encoding used for filenames.
         *
         * Since GLib 2.78, the query string and fragment can be present in the URI,
         * but are not part of the resulting filename.
         * We take inspiration from https://url.spec.whatwg.org/#file-state,
         * but we don't support the entire standard.
         * @param uri a uri describing a filename (escaped, encoded in ASCII).
         * @returns a newly-allocated string holding               the resulting filename, or %NULL on an error.
         */
        function filename_from_uri(uri: string): [string, string];
        /**
         * Converts a string from UTF-8 to the encoding GLib uses for
         * filenames. Note that on Windows GLib uses UTF-8 for filenames;
         * on other platforms, this function indirectly depends on the
         * [current locale](running.html#locale).
         *
         * The input string shall not contain nul characters even if the `len`
         * argument is positive. A nul character found inside the string will result
         * in error %G_CONVERT_ERROR_ILLEGAL_SEQUENCE. If the filename encoding is
         * not UTF-8 and the conversion output contains a nul character, the error
         * %G_CONVERT_ERROR_EMBEDDED_NUL is set and the function returns %NULL.
         * @param utf8string a UTF-8 encoded string.
         * @param len the length of the string, or -1 if the string is                 nul-terminated.
         * @returns The converted string, or %NULL on an error.
         */
        function filename_from_utf8(utf8string: string, len: number): [string, number, number];
        /**
         * Converts an absolute filename to an escaped ASCII-encoded URI, with the path
         * component following Section 3.3. of RFC 2396.
         * @param filename an absolute filename specified in the GLib file     name encoding, which is the on-disk file name bytes on Unix, and UTF-8     on Windows
         * @param hostname A UTF-8 encoded hostname, or %NULL for none.
         * @returns a newly-allocated string holding the resulting               URI, or %NULL on an error.
         */
        function filename_to_uri(filename: string, hostname?: string | null): string;
        /**
         * Converts a string which is in the encoding used by GLib for
         * filenames into a UTF-8 string. Note that on Windows GLib uses UTF-8
         * for filenames; on other platforms, this function indirectly depends on
         * the [current locale](running.html#locale).
         *
         * The input string shall not contain nul characters even if the `len`
         * argument is positive. A nul character found inside the string will result
         * in error %G_CONVERT_ERROR_ILLEGAL_SEQUENCE.
         * If the source encoding is not UTF-8 and the conversion output contains a
         * nul character, the error %G_CONVERT_ERROR_EMBEDDED_NUL is set and the
         * function returns %NULL. Use g_convert() to produce output that
         * may contain embedded nul characters.
         * @param opsysstring a string in the encoding for filenames
         * @param len the length of the string, or -1 if the string is                 nul-terminated (Note that some encodings may allow nul                 bytes to occur inside strings. In that case, using -1                 for the @len parameter is unsafe)
         * @returns The converted string, or %NULL on an error.
         */
        function filename_to_utf8(opsysstring: string, len: number): [string, number, number];
        /**
         * Locates the first executable named `program` in the user's path, in the
         * same way that execvp() would locate it. Returns an allocated string
         * with the absolute path name, or %NULL if the program is not found in
         * the path. If `program` is already an absolute path, returns a copy of
         * `program` if `program` exists and is executable, and %NULL otherwise.
         *
         * On Windows, if `program` does not have a file type suffix, tries
         * with the suffixes .exe, .cmd, .bat and .com, and the suffixes in
         * the `PATHEXT` environment variable.
         *
         * On Windows, it looks for the file in the same way as CreateProcess()
         * would. This means first in the directory where the executing
         * program was loaded from, then in the current directory, then in the
         * Windows 32-bit system directory, then in the Windows directory, and
         * finally in the directories in the `PATH` environment variable. If
         * the program is found, the return value contains the full name
         * including the type suffix.
         * @param program a program name in the GLib file name encoding
         * @returns a newly-allocated   string with the absolute path, or %NULL
         */
        function find_program_in_path(program: string): string | null;
        /**
         * A wrapper for the stdio `fopen()` function. The `fopen()` function
         * opens a file and associates a new stream with it.
         *
         * Because file descriptors are specific to the C library on Windows,
         * and a file descriptor is part of the `FILE` struct, the `FILE*` returned
         * by this function makes sense only to functions in the same C library.
         * Thus if the GLib-using code uses a different C library than GLib does,
         * the FILE* returned by this function cannot be passed to C library
         * functions like `fprintf()` or `fread()`.
         *
         * See your C library manual for more details about `fopen()`.
         *
         * As `close()` and `fclose()` are part of the C library, this implies that it is
         * currently impossible to close a file if the application C library and the C library
         * used by GLib are different. Convenience functions like g_file_set_contents_full()
         * avoid this problem.
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param mode a string describing the mode in which the file should be opened
         * @returns A `FILE*` if the file was successfully opened, or %NULL if     an error occurred
         */
        function fopen(filename: string, mode: string): any | null;
        /**
         * Formats a size (for example the size of a file) into a human readable
         * string.  Sizes are rounded to the nearest size prefix (kB, MB, GB)
         * and are displayed rounded to the nearest tenth. E.g. the file size
         * 3292528 bytes will be converted into the string "3.2 MB". The returned string
         * is UTF-8, and may use a non-breaking space to separate the number and units,
         * to ensure they aren’t separated when line wrapped.
         *
         * The prefix units base is 1000 (i.e. 1 kB is 1000 bytes).
         *
         * This string should be freed with g_free() when not needed any longer.
         *
         * See g_format_size_full() for more options about how the size might be
         * formatted.
         * @param size a size in bytes
         * @returns a newly-allocated formatted string containing   a human readable file size
         */
        function format_size(size: number): string;
        /**
         * Formats a size (for example the size of a file) into a human
         * readable string. Sizes are rounded to the nearest size prefix
         * (KB, MB, GB) and are displayed rounded to the nearest tenth.
         * E.g. the file size 3292528 bytes will be converted into the
         * string "3.1 MB".
         *
         * The prefix units base is 1024 (i.e. 1 KB is 1024 bytes).
         *
         * This string should be freed with g_free() when not needed any longer.
         * @param size a size in bytes
         * @returns a newly-allocated formatted string   containing a human readable file size
         */
        function format_size_for_display(size: number): string;
        /**
         * Formats a size.
         *
         * This function is similar to g_format_size() but allows for flags
         * that modify the output. See #GFormatSizeFlags.
         * @param size a size in bytes
         * @param flags #GFormatSizeFlags to modify the output
         * @returns a newly-allocated formatted string   containing a human readable file size
         */
        function format_size_full(size: number, flags: FormatSizeFlags | null): string;
        /**
         * Frees the memory pointed to by `mem`.
         *
         * If you know the allocated size of `mem,` calling g_free_sized() may be faster,
         * depending on the libc implementation in use.
         *
         * Starting from GLib 2.78, this may happen automatically in case a GCC
         * compatible compiler is used with some optimization level and the allocated
         * size is known at compile time (see [documentation of
         * `__builtin_object_size()`](https://gcc.gnu.org/onlinedocs/gcc/Object-Size-Checking.html)
         * to understand its caveats).
         *
         * If `mem` is %NULL it simply returns, so there is no need to check `mem`
         * against %NULL before calling this function.
         * @param mem the memory to free
         */
        function free(mem?: any | null): void;
        /**
         * Frees the memory pointed to by `mem,` assuming it is has the given `size`.
         *
         * If `mem` is %NULL this is a no-op (and `size` is ignored).
         *
         * It is an error if `size` doesn’t match the size passed when `mem` was
         * allocated. `size` is passed to this function to allow optimizations in the
         * allocator. If you don’t know the allocation size, use g_free() instead.
         *
         * In case a GCC compatible compiler is used, this function may be used
         * automatically via g_free() if the allocated size is known at compile time,
         * since GLib 2.78.
         * @param mem the memory to free
         * @param size size of @mem, in bytes
         */
        function free_sized(mem: any | null, size: number): void;
        /**
         * A wrapper for the POSIX freopen() function. The freopen() function
         * opens a file and associates it with an existing stream.
         *
         * See your C library manual for more details about freopen().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param mode a string describing the mode in which the file should be  opened
         * @param stream an existing stream which will be reused, or %NULL
         * @returns A FILE* if the file was successfully opened, or %NULL if     an error occurred.
         */
        function freopen(filename: string, mode: string, stream?: any | null): any | null;
        /**
         * A wrapper for the POSIX `fsync()` function. On Windows, `_commit()` will be
         * used. On macOS, `fcntl(F_FULLFSYNC)` will be used.
         * The `fsync()` function is used to synchronize a file's in-core
         * state with that of the disk.
         *
         * This wrapper will handle retrying on `EINTR`.
         *
         * See the C library manual for more details about fsync().
         * @param fd a file descriptor
         * @returns 0 on success, or -1 if an error occurred. The return value can be used exactly like the return value from fsync().
         */
        function fsync(fd: number): number;
        /**
         * Gets a human-readable name for the application, as set by
         * g_set_application_name(). This name should be localized if
         * possible, and is intended for display to the user.  Contrast with
         * g_get_prgname(), which gets a non-localized name. If
         * g_set_application_name() has not been called, returns the result of
         * g_get_prgname() (which may be %NULL if g_set_prgname() has also not
         * been called).
         * @returns human-readable application   name. May return %NULL
         */
        function get_application_name(): string | null;
        /**
         * Obtains the character set for the [current locale](running.html#locale);
         * you might use this character set as an argument to g_convert(), to convert
         * from the current locale's encoding to some other encoding. (Frequently
         * g_locale_to_utf8() and g_locale_from_utf8() are nice shortcuts, though.)
         *
         * On Windows the character set returned by this function is the
         * so-called system default ANSI code-page. That is the character set
         * used by the "narrow" versions of C library and Win32 functions that
         * handle file names. It might be different from the character set
         * used by the C library's current locale.
         *
         * On Linux, the character set is found by consulting nl_langinfo() if
         * available. If not, the environment variables `LC_ALL`, `LC_CTYPE`, `LANG`
         * and `CHARSET` are queried in order. nl_langinfo() returns the C locale if
         * no locale has been loaded by setlocale().
         *
         * The return value is %TRUE if the locale's encoding is UTF-8, in that
         * case you can perhaps avoid calling g_convert().
         *
         * The string returned in `charset` is not allocated, and should not be
         * freed.
         * @returns %TRUE if the returned charset is UTF-8
         */
        function get_charset(): [boolean, string];
        /**
         * Gets the character set for the current locale.
         * @returns a newly allocated string containing the name     of the character set. This string must be freed with g_free().
         */
        function get_codeset(): string;
        /**
         * Obtains the character set used by the console attached to the process,
         * which is suitable for printing output to the terminal.
         *
         * Usually this matches the result returned by g_get_charset(), but in
         * environments where the locale's character set does not match the encoding
         * of the console this function tries to guess a more suitable value instead.
         *
         * On Windows the character set returned by this function is the
         * output code page used by the console associated with the calling process.
         * If the codepage can't be determined (for example because there is no
         * console attached) UTF-8 is assumed.
         *
         * The return value is %TRUE if the locale's encoding is UTF-8, in that
         * case you can perhaps avoid calling g_convert().
         *
         * The string returned in `charset` is not allocated, and should not be
         * freed.
         * @returns %TRUE if the returned charset is UTF-8
         */
        function get_console_charset(): [boolean, string];
        /**
         * Gets the current directory.
         *
         * The returned string should be freed when no longer needed.
         * The encoding of the returned string is system defined.
         * On Windows, it is always UTF-8.
         *
         * Since GLib 2.40, this function will return the value of the "PWD"
         * environment variable if it is set and it happens to be the same as
         * the current directory.  This can make a difference in the case that
         * the current directory is the target of a symbolic link.
         * @returns the current directory
         */
        function get_current_dir(): string;
        /**
         * Equivalent to the UNIX gettimeofday() function, but portable.
         *
         * You may find [func`GLib`.get_real_time] to be more convenient.
         * @param result #GTimeVal structure in which to store current time.
         */
        function get_current_time(result: TimeVal): void;
        /**
         * Gets the list of environment variables for the current process.
         *
         * The list is %NULL terminated and each item in the list is of the
         * form 'NAME=VALUE'.
         *
         * This is equivalent to direct access to the 'environ' global variable,
         * except portable.
         *
         * The return value is freshly allocated and it should be freed with
         * g_strfreev() when it is no longer needed.
         * @returns the list of environment variables
         */
        function get_environ(): string[];
        /**
         * Determines the preferred character sets used for filenames.
         * The first character set from the `charsets` is the filename encoding, the
         * subsequent character sets are used when trying to generate a displayable
         * representation of a filename, see g_filename_display_name().
         *
         * On Unix, the character sets are determined by consulting the
         * environment variables `G_FILENAME_ENCODING` and `G_BROKEN_FILENAMES`.
         * On Windows, the character set used in the GLib API is always UTF-8
         * and said environment variables have no effect.
         *
         * `G_FILENAME_ENCODING` may be set to a comma-separated list of
         * character set names. The special token ``locale`` is taken to mean the
         * character set for the [current locale](running.html#locale).
         * If `G_FILENAME_ENCODING` is not set, but `G_BROKEN_FILENAMES` is,
         * the character set of the current locale is taken as the filename
         * encoding. If neither environment variable  is set, UTF-8 is taken
         * as the filename encoding, but the character set of the current locale
         * is also put in the list of encodings.
         *
         * The returned `charsets` belong to GLib and must not be freed.
         *
         * Note that on Unix, regardless of the locale character set or
         * `G_FILENAME_ENCODING` value, the actual file names present
         * on a system might be in any random encoding or just gibberish.
         * @returns %TRUE if the filename encoding is UTF-8.
         */
        function get_filename_charsets(): [boolean, string[]];
        /**
         * Gets the current user's home directory.
         *
         * As with most UNIX tools, this function will return the value of the
         * `HOME` environment variable if it is set to an existing absolute path
         * name, falling back to the `passwd` file in the case that it is unset.
         *
         * If the path given in `HOME` is non-absolute, does not exist, or is
         * not a directory, the result is undefined.
         *
         * Before version 2.36 this function would ignore the `HOME` environment
         * variable, taking the value from the `passwd` database instead. This was
         * changed to increase the compatibility of GLib with other programs (and
         * the XDG basedir specification) and to increase testability of programs
         * based on GLib (by making it easier to run them from test frameworks).
         *
         * If your program has a strong requirement for either the new or the
         * old behaviour (and if you don't wish to increase your GLib
         * dependency to ensure that the new behaviour is in effect) then you
         * should either directly check the `HOME` environment variable yourself
         * or unset it before calling any functions in GLib.
         * @returns the current user's home directory
         */
        function get_home_dir(): string;
        /**
         * Return a name for the machine.
         *
         * The returned name is not necessarily a fully-qualified domain name,
         * or even present in DNS or some other name service at all. It need
         * not even be unique on your local network or site, but usually it
         * is. Callers should not rely on the return value having any specific
         * properties like uniqueness for security purposes. Even if the name
         * of the machine is changed while an application is running, the
         * return value from this function does not change. The returned
         * string is owned by GLib and should not be modified or freed. If no
         * name can be determined, a default fixed string "localhost" is
         * returned.
         *
         * The encoding of the returned string is UTF-8.
         * @returns the host name of the machine.
         */
        function get_host_name(): string;
        /**
         * Computes a list of applicable locale names, which can be used to
         * e.g. construct locale-dependent filenames or search paths. The returned
         * list is sorted from most desirable to least desirable and always contains
         * the default locale "C".
         *
         * For example, if LANGUAGE=de:en_US, then the returned list is
         * "de", "en_US", "en", "C".
         *
         * This function consults the environment variables `LANGUAGE`, `LC_ALL`,
         * `LC_MESSAGES` and `LANG` to find the list of locales specified by the
         * user.
         * @returns a %NULL-terminated array of strings owned by GLib    that must not be modified or freed.
         */
        function get_language_names(): string[];
        /**
         * Computes a list of applicable locale names with a locale category name,
         * which can be used to construct the fallback locale-dependent filenames
         * or search paths. The returned list is sorted from most desirable to
         * least desirable and always contains the default locale "C".
         *
         * This function consults the environment variables `LANGUAGE`, `LC_ALL`,
         * `category_name,` and `LANG` to find the list of locales specified by the
         * user.
         *
         * g_get_language_names() returns g_get_language_names_with_category("LC_MESSAGES").
         * @param category_name a locale category name
         * @returns a %NULL-terminated array of strings owned by    the thread g_get_language_names_with_category was called from.    It must not be modified or freed. It must be copied if planned to be used in another thread.
         */
        function get_language_names_with_category(category_name: string): string[];
        /**
         * Returns a list of derived variants of `locale,` which can be used to
         * e.g. construct locale-dependent filenames or search paths. The returned
         * list is sorted from most desirable to least desirable.
         * This function handles territory, charset and extra locale modifiers. See
         * [`setlocale(3)`](man:setlocale) for information about locales and their format.
         *
         * `locale` itself is guaranteed to be returned in the output.
         *
         * For example, if `locale` is `fr_BE`, then the returned list
         * is `fr_BE`, `fr`. If `locale` is `en_GB.UTF-8`euro``, then the returned list
         * is `en_GB.UTF-8`euro``, `en_GB.UTF-8`, `en_GB`euro``, `en_GB`, `en.UTF-8`euro``,
         * `en.UTF-8`, `en`euro``, `en`.
         *
         * If you need the list of variants for the current locale,
         * use g_get_language_names().
         * @param locale a locale identifier
         * @returns a newly   allocated array of newly allocated strings with the locale variants. Free with   g_strfreev().
         */
        function get_locale_variants(locale: string): string[];
        /**
         * Queries the system monotonic time.
         *
         * The monotonic clock will always increase and doesn't suffer
         * discontinuities when the user (or NTP) changes the system time.  It
         * may or may not continue to tick during times where the machine is
         * suspended.
         *
         * We try to use the clock that corresponds as closely as possible to
         * the passage of time as measured by system calls such as poll() but it
         * may not always be possible to do this.
         * @returns the monotonic time, in microseconds
         */
        function get_monotonic_time(): number;
        /**
         * Determine the approximate number of threads that the system will
         * schedule simultaneously for this process.  This is intended to be
         * used as a parameter to g_thread_pool_new() for CPU bound tasks and
         * similar cases.
         * @returns Number of schedulable threads, always greater than 0
         */
        function get_num_processors(): number;
        /**
         * Get information about the operating system.
         *
         * On Linux this comes from the `/etc/os-release` file. On other systems, it may
         * come from a variety of sources. You can either use the standard key names
         * like %G_OS_INFO_KEY_NAME or pass any UTF-8 string key name. For example,
         * `/etc/os-release` provides a number of other less commonly used values that may
         * be useful. No key is guaranteed to be provided, so the caller should always
         * check if the result is %NULL.
         * @param key_name a key for the OS info being requested, for example %G_OS_INFO_KEY_NAME.
         * @returns The associated value for the requested key or %NULL if   this information is not provided.
         */
        function get_os_info(key_name: string): string | null;
        /**
         * Gets the name of the program. This name should not be localized,
         * in contrast to g_get_application_name().
         *
         * If you are using #GApplication the program name is set in
         * g_application_run(). In case of GDK or GTK it is set in
         * gdk_init(), which is called by gtk_init() and the
         * #GtkApplication::startup handler. The program name is found by
         * taking the last component of `argv[`0].
         * @returns the name of the program,   or %NULL if it has not been set yet. The returned string belongs   to GLib and must not be modified or freed.
         */
        function get_prgname(): string | null;
        /**
         * Gets the real name of the user. This usually comes from the user's
         * entry in the `passwd` file. The encoding of the returned string is
         * system-defined. (On Windows, it is, however, always UTF-8.) If the
         * real user name cannot be determined, the string "Unknown" is
         * returned.
         * @returns the user's real name.
         */
        function get_real_name(): string;
        /**
         * Queries the system wall-clock time.
         *
         * This call is functionally equivalent to [func`GLib`.get_current_time] except
         * that the return value is often more convenient than dealing with a
         * #GTimeVal.
         *
         * You should only use this call if you are actually interested in the real
         * wall-clock time. [func`GLib`.get_monotonic_time] is probably more useful for
         * measuring intervals.
         * @returns the number of microseconds since January 1, 1970 UTC.
         */
        function get_real_time(): number;
        /**
         * Returns an ordered list of base directories in which to access
         * system-wide configuration information.
         *
         * On UNIX platforms this is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec).
         * In this case the list of directories retrieved will be `XDG_CONFIG_DIRS`.
         *
         * On Windows it follows XDG Base Directory Specification if `XDG_CONFIG_DIRS` is defined.
         * If `XDG_CONFIG_DIRS` is undefined, the directory that contains application
         * data for all users is used instead. A typical path is
         * `C:\Documents and Settings\All Users\Application Data`.
         * This folder is used for application data
         * that is not user specific. For example, an application can store
         * a spell-check dictionary, a database of clip art, or a log file in the
         * FOLDERID_ProgramData folder. This information will not roam and is available
         * to anyone using the computer.
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a %NULL-terminated array of strings owned by GLib that must not be     modified or freed.
         */
        function get_system_config_dirs(): string[];
        /**
         * Returns an ordered list of base directories in which to access
         * system-wide application data.
         *
         * On UNIX platforms this is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec)
         * In this case the list of directories retrieved will be `XDG_DATA_DIRS`.
         *
         * On Windows it follows XDG Base Directory Specification if `XDG_DATA_DIRS` is defined.
         * If `XDG_DATA_DIRS` is undefined,
         * the first elements in the list are the Application Data
         * and Documents folders for All Users. (These can be determined only
         * on Windows 2000 or later and are not present in the list on other
         * Windows versions.) See documentation for FOLDERID_ProgramData and
         * FOLDERID_PublicDocuments.
         *
         * Then follows the "share" subfolder in the installation folder for
         * the package containing the DLL that calls this function, if it can
         * be determined.
         *
         * Finally the list contains the "share" subfolder in the installation
         * folder for GLib, and in the installation folder for the package the
         * application's .exe file belongs to.
         *
         * The installation folders above are determined by looking up the
         * folder where the module (DLL or EXE) in question is located. If the
         * folder's name is "bin", its parent is used, otherwise the folder
         * itself.
         *
         * Note that on Windows the returned list can vary depending on where
         * this function is called.
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a %NULL-terminated array of strings owned by GLib that must not be     modified or freed.
         */
        function get_system_data_dirs(): string[];
        /**
         * Gets the directory to use for temporary files.
         *
         * On UNIX, this is taken from the `TMPDIR` environment variable.
         * If the variable is not set, `P_tmpdir` is
         * used, as defined by the system C library. Failing that, a
         * hard-coded default of "/tmp" is returned.
         *
         * On Windows, the `TEMP` environment variable is used, with the
         * root directory of the Windows installation (eg: "C:\") used
         * as a default.
         *
         * The encoding of the returned string is system-defined. On Windows,
         * it is always UTF-8. The return value is never %NULL or the empty
         * string.
         * @returns the directory to use for temporary files.
         */
        function get_tmp_dir(): string;
        /**
         * Returns a base directory in which to store non-essential, cached
         * data specific to particular user.
         *
         * On UNIX platforms this is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec).
         * In this case the directory retrieved will be `XDG_CACHE_HOME`.
         *
         * On Windows it follows XDG Base Directory Specification if `XDG_CACHE_HOME` is defined.
         * If `XDG_CACHE_HOME` is undefined, the directory that serves as a common
         * repository for temporary Internet files is used instead. A typical path is
         * `C:\Documents and Settings\username\Local Settings\Temporary Internet Files`.
         * See the [documentation for `FOLDERID_InternetCache`](https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid).
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a string owned by GLib that   must not be modified or freed.
         */
        function get_user_cache_dir(): string;
        /**
         * Returns a base directory in which to store user-specific application
         * configuration information such as user preferences and settings.
         *
         * On UNIX platforms this is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec).
         * In this case the directory retrieved will be `XDG_CONFIG_HOME`.
         *
         * On Windows it follows XDG Base Directory Specification if `XDG_CONFIG_HOME` is defined.
         * If `XDG_CONFIG_HOME` is undefined, the folder to use for local (as opposed
         * to roaming) application data is used instead. See the
         * [documentation for `FOLDERID_LocalAppData`](https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid).
         * Note that in this case on Windows it will be  the same
         * as what g_get_user_data_dir() returns.
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a string owned by GLib that   must not be modified or freed.
         */
        function get_user_config_dir(): string;
        /**
         * Returns a base directory in which to access application data such
         * as icons that is customized for a particular user.
         *
         * On UNIX platforms this is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec).
         * In this case the directory retrieved will be `XDG_DATA_HOME`.
         *
         * On Windows it follows XDG Base Directory Specification if `XDG_DATA_HOME`
         * is defined. If `XDG_DATA_HOME` is undefined, the folder to use for local (as
         * opposed to roaming) application data is used instead. See the
         * [documentation for `FOLDERID_LocalAppData`](https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid).
         * Note that in this case on Windows it will be the same
         * as what g_get_user_config_dir() returns.
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a string owned by GLib that must   not be modified or freed.
         */
        function get_user_data_dir(): string;
        /**
         * Gets the user name of the current user. The encoding of the returned
         * string is system-defined. On UNIX, it might be the preferred file name
         * encoding, or something else, and there is no guarantee that it is even
         * consistent on a machine. On Windows, it is always UTF-8.
         * @returns the user name of the current user.
         */
        function get_user_name(): string;
        /**
         * Returns a directory that is unique to the current user on the local
         * system.
         *
         * This is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec).
         * This is the directory
         * specified in the `XDG_RUNTIME_DIR` environment variable.
         * In the case that this variable is not set, we return the value of
         * g_get_user_cache_dir(), after verifying that it exists.
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a string owned by GLib that must not be     modified or freed.
         */
        function get_user_runtime_dir(): string;
        /**
         * Returns the full path of a special directory using its logical id.
         *
         * On UNIX this is done using the XDG special user directories.
         * For compatibility with existing practise, %G_USER_DIRECTORY_DESKTOP
         * falls back to `$HOME/Desktop` when XDG special user directories have
         * not been set up.
         *
         * Depending on the platform, the user might be able to change the path
         * of the special directory without requiring the session to restart; GLib
         * will not reflect any change once the special directories are loaded.
         * @param directory the logical id of special directory
         * @returns the path to the specified special   directory, or %NULL if the logical id was not found. The returned string is   owned by GLib and should not be modified or freed.
         */
        function get_user_special_dir(directory: UserDirectory | null): string | null;
        /**
         * Returns a base directory in which to store state files specific to
         * particular user.
         *
         * On UNIX platforms this is determined using the mechanisms described
         * in the
         * [XDG Base Directory Specification](http://www.freedesktop.org/Standards/basedir-spec).
         * In this case the directory retrieved will be `XDG_STATE_HOME`.
         *
         * On Windows it follows XDG Base Directory Specification if `XDG_STATE_HOME` is defined.
         * If `XDG_STATE_HOME` is undefined, the folder to use for local (as opposed
         * to roaming) application data is used instead. See the
         * [documentation for `FOLDERID_LocalAppData`](https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid).
         * Note that in this case on Windows it will be the same
         * as what g_get_user_data_dir() returns.
         *
         * The return value is cached and modifying it at runtime is not supported, as
         * it’s not thread-safe to modify environment variables at runtime.
         * @returns a string owned by GLib that   must not be modified or freed.
         */
        function get_user_state_dir(): string;
        /**
         * Returns the value of an environment variable.
         *
         * On UNIX, the name and value are byte strings which might or might not
         * be in some consistent character set and encoding. On Windows, they are
         * in UTF-8.
         * On Windows, in case the environment variable's value contains
         * references to other environment variables, they are expanded.
         * @param variable the environment variable to get
         * @returns the value of the environment variable, or %NULL if     the environment variable is not found. The returned string     may be overwritten by the next call to g_getenv(), g_setenv()     or g_unsetenv().
         */
        function getenv(variable: string): string | null;
        /**
         * This is a convenience function for using a #GHashTable as a set.  It
         * is equivalent to calling g_hash_table_replace() with `key` as both the
         * key and the value.
         *
         * In particular, this means that if `key` already exists in the hash table, then
         * the old copy of `key` in the hash table is freed and `key` replaces it in the
         * table.
         *
         * When a hash table only ever contains keys that have themselves as the
         * corresponding value it is able to be stored more efficiently.  See
         * the discussion in the section description.
         *
         * Starting from GLib 2.40, this function returns a boolean value to
         * indicate whether the newly added value was already in the hash table
         * or not.
         * @param hash_table a #GHashTable
         * @param key a key to insert
         * @returns %TRUE if the key did not exist yet
         */
        function hash_table_add(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
        /**
         * Checks if `key` is in `hash_table`.
         * @param hash_table a #GHashTable
         * @param key a key to check
         * @returns %TRUE if @key is in @hash_table, %FALSE otherwise.
         */
        function hash_table_contains(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            key?: any | null,
        ): boolean;
        /**
         * Destroys all keys and values in the #GHashTable and decrements its
         * reference count by 1. If keys and/or values are dynamically allocated,
         * you should either free them first or create the #GHashTable with destroy
         * notifiers using g_hash_table_new_full(). In the latter case the destroy
         * functions you supplied will be called on all keys and values during the
         * destruction phase.
         * @param hash_table a #GHashTable
         */
        function hash_table_destroy(hash_table: { [key: string]: any } | HashTable<any, any>): void;
        /**
         * Calls the given function for key/value pairs in the #GHashTable
         * until `predicate` returns %TRUE. The function is passed the key
         * and value of each pair, and the given `user_data` parameter. The
         * hash table may not be modified while iterating over it (you can't
         * add/remove items).
         *
         * Note, that hash tables are really only optimized for forward
         * lookups, i.e. g_hash_table_lookup(). So code that frequently issues
         * g_hash_table_find() or g_hash_table_foreach() (e.g. in the order of
         * once per every entry in a hash table) should probably be reworked
         * to use additional or different data structures for reverse lookups
         * (keep in mind that an O(n) find/foreach operation issued for all n
         * values in a hash table ends up needing O(n*n) operations).
         * @param hash_table a #GHashTable
         * @param predicate function to test the key/value pairs for a certain property
         * @returns The value of the first key/value pair is returned,     for which @predicate evaluates to %TRUE. If no pair with the     requested property is found, %NULL is returned.
         */
        function hash_table_find(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            predicate: HRFunc,
        ): any | null;
        /**
         * Calls the given function for each of the key/value pairs in the
         * #GHashTable.  The function is passed the key and value of each
         * pair, and the given `user_data` parameter.  The hash table may not
         * be modified while iterating over it (you can't add/remove
         * items). To remove all items matching a predicate, use
         * g_hash_table_foreach_remove().
         *
         * The order in which g_hash_table_foreach() iterates over the keys/values in
         * the hash table is not defined.
         *
         * See g_hash_table_find() for performance caveats for linear
         * order searches in contrast to g_hash_table_lookup().
         * @param hash_table a #GHashTable
         * @param func the function to call for each key/value pair
         */
        function hash_table_foreach(hash_table: { [key: string]: any } | HashTable<any, any>, func: HFunc): void;
        /**
         * Calls the given function for each key/value pair in the
         * #GHashTable. If the function returns %TRUE, then the key/value
         * pair is removed from the #GHashTable. If you supplied key or
         * value destroy functions when creating the #GHashTable, they are
         * used to free the memory allocated for the removed keys and values.
         *
         * See #GHashTableIter for an alternative way to loop over the
         * key/value pairs in the hash table.
         * @param hash_table a #GHashTable
         * @param func the function to call for each key/value pair
         * @returns the number of key/value pairs removed
         */
        function hash_table_foreach_remove(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            func: HRFunc,
        ): number;
        /**
         * Calls the given function for each key/value pair in the
         * #GHashTable. If the function returns %TRUE, then the key/value
         * pair is removed from the #GHashTable, but no key or value
         * destroy functions are called.
         *
         * See #GHashTableIter for an alternative way to loop over the
         * key/value pairs in the hash table.
         * @param hash_table a #GHashTable
         * @param func the function to call for each key/value pair
         * @returns the number of key/value pairs removed.
         */
        function hash_table_foreach_steal(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            func: HRFunc,
        ): number;
        /**
         * Inserts a new key and value into a #GHashTable.
         *
         * If the key already exists in the #GHashTable its current
         * value is replaced with the new value. If you supplied a
         * `value_destroy_func` when creating the #GHashTable, the old
         * value is freed using that function. If you supplied a
         * `key_destroy_func` when creating the #GHashTable, the passed
         * key is freed using that function.
         *
         * Starting from GLib 2.40, this function returns a boolean value to
         * indicate whether the newly added value was already in the hash table
         * or not.
         * @param hash_table a #GHashTable
         * @param key a key to insert
         * @param value the value to associate with the key
         * @returns %TRUE if the key did not exist yet
         */
        function hash_table_insert(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            key?: any | null,
            value?: any | null,
        ): boolean;
        /**
         * Looks up a key in a #GHashTable. Note that this function cannot
         * distinguish between a key that is not present and one which is present
         * and has the value %NULL. If you need this distinction, use
         * g_hash_table_lookup_extended().
         * @param hash_table a #GHashTable
         * @param key the key to look up
         * @returns the associated value, or %NULL if the key is not found
         */
        function hash_table_lookup(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            key?: any | null,
        ): any | null;
        /**
         * Looks up a key in the #GHashTable, returning the original key and the
         * associated value and a #gboolean which is %TRUE if the key was found. This
         * is useful if you need to free the memory allocated for the original key,
         * for example before calling g_hash_table_remove().
         *
         * You can actually pass %NULL for `lookup_key` to test
         * whether the %NULL key exists, provided the hash and equal functions
         * of `hash_table` are %NULL-safe.
         * @param hash_table a #GHashTable
         * @param lookup_key the key to look up
         * @returns %TRUE if the key was found in the #GHashTable
         */
        function hash_table_lookup_extended(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            lookup_key: any | null,
        ): [boolean, any, any];
        /**
         * Creates a new #GHashTable like g_hash_table_new_full() with a reference
         * count of 1.
         *
         * It inherits the hash function, the key equal function, the key destroy function,
         * as well as the value destroy function, from `other_hash_table`.
         *
         * The returned hash table will be empty; it will not contain the keys
         * or values from `other_hash_table`.
         * @param other_hash_table Another #GHashTable
         * @returns a new #GHashTable
         */
        function hash_table_new_similar(
            other_hash_table: { [key: string]: any } | HashTable<any, any>,
        ): HashTable<any, any>;
        /**
         * Atomically increments the reference count of `hash_table` by one.
         * This function is MT-safe and may be called from any thread.
         * @param hash_table a valid #GHashTable
         * @returns the passed in #GHashTable
         */
        function hash_table_ref(hash_table: { [key: string]: any } | HashTable<any, any>): HashTable<any, any>;
        /**
         * Removes a key and its associated value from a #GHashTable.
         *
         * If the #GHashTable was created using g_hash_table_new_full(), the
         * key and value are freed using the supplied destroy functions, otherwise
         * you have to make sure that any dynamically allocated values are freed
         * yourself.
         * @param hash_table a #GHashTable
         * @param key the key to remove
         * @returns %TRUE if the key was found and removed from the #GHashTable
         */
        function hash_table_remove(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
        /**
         * Removes all keys and their associated values from a #GHashTable.
         *
         * If the #GHashTable was created using g_hash_table_new_full(),
         * the keys and values are freed using the supplied destroy functions,
         * otherwise you have to make sure that any dynamically allocated
         * values are freed yourself.
         * @param hash_table a #GHashTable
         */
        function hash_table_remove_all(hash_table: { [key: string]: any } | HashTable<any, any>): void;
        /**
         * Inserts a new key and value into a #GHashTable similar to
         * g_hash_table_insert(). The difference is that if the key
         * already exists in the #GHashTable, it gets replaced by the
         * new key. If you supplied a `value_destroy_func` when creating
         * the #GHashTable, the old value is freed using that function.
         * If you supplied a `key_destroy_func` when creating the
         * #GHashTable, the old key is freed using that function.
         *
         * Starting from GLib 2.40, this function returns a boolean value to
         * indicate whether the newly added value was already in the hash table
         * or not.
         * @param hash_table a #GHashTable
         * @param key a key to insert
         * @param value the value to associate with the key
         * @returns %TRUE if the key did not exist yet
         */
        function hash_table_replace(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            key?: any | null,
            value?: any | null,
        ): boolean;
        /**
         * Returns the number of elements contained in the #GHashTable.
         * @param hash_table a #GHashTable
         * @returns the number of key/value pairs in the #GHashTable.
         */
        function hash_table_size(hash_table: { [key: string]: any } | HashTable<any, any>): number;
        /**
         * Removes a key and its associated value from a #GHashTable without
         * calling the key and value destroy functions.
         * @param hash_table a #GHashTable
         * @param key the key to remove
         * @returns %TRUE if the key was found and removed from the #GHashTable
         */
        function hash_table_steal(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
        /**
         * Removes all keys and their associated values from a #GHashTable
         * without calling the key and value destroy functions.
         * @param hash_table a #GHashTable
         */
        function hash_table_steal_all(hash_table: { [key: string]: any } | HashTable<any, any>): void;
        /**
         * Looks up a key in the #GHashTable, stealing the original key and the
         * associated value and returning %TRUE if the key was found. If the key was
         * not found, %FALSE is returned.
         *
         * If found, the stolen key and value are removed from the hash table without
         * calling the key and value destroy functions, and ownership is transferred to
         * the caller of this method, as with g_hash_table_steal(). That is the case
         * regardless whether `stolen_key` or `stolen_value` output parameters are
         * requested.
         *
         * You can pass %NULL for `lookup_key,` provided the hash and equal functions
         * of `hash_table` are %NULL-safe.
         *
         * The dictionary implementation optimizes for having all values identical to
         * their keys, for example by using g_hash_table_add(). Before 2.82, when
         * stealing both the key and the value from such a dictionary, the value was
         * %NULL. Since 2.82, the returned value and key will be the same.
         * @param hash_table a #GHashTable
         * @param lookup_key the key to look up
         * @returns %TRUE if the key was found in the #GHashTable
         */
        function hash_table_steal_extended(
            hash_table: { [key: string]: any } | HashTable<any, any>,
            lookup_key: any | null,
        ): [boolean, any, any];
        /**
         * Atomically decrements the reference count of `hash_table` by one.
         * If the reference count drops to 0, all keys and values will be
         * destroyed, and all memory allocated by the hash table is released.
         * This function is MT-safe and may be called from any thread.
         * @param hash_table a valid #GHashTable
         */
        function hash_table_unref(hash_table: { [key: string]: any } | HashTable<any, any>): void;
        /**
         * Destroys a #GHook, given its ID.
         * @param hook_list a #GHookList
         * @param hook_id a hook ID
         * @returns %TRUE if the #GHook was found in the #GHookList and destroyed
         */
        function hook_destroy(hook_list: HookList, hook_id: number): boolean;
        /**
         * Removes one #GHook from a #GHookList, marking it
         * inactive and calling g_hook_unref() on it.
         * @param hook_list a #GHookList
         * @param hook the #GHook to remove
         */
        function hook_destroy_link(hook_list: HookList, hook: Hook): void;
        /**
         * Calls the #GHookList `finalize_hook` function if it exists,
         * and frees the memory allocated for the #GHook.
         * @param hook_list a #GHookList
         * @param hook the #GHook to free
         */
        function hook_free(hook_list: HookList, hook: Hook): void;
        /**
         * Inserts a #GHook into a #GHookList, before a given #GHook.
         * @param hook_list a #GHookList
         * @param sibling the #GHook to insert the new #GHook before
         * @param hook the #GHook to insert
         */
        function hook_insert_before(hook_list: HookList, sibling: Hook | null, hook: Hook): void;
        /**
         * Inserts a #GHook into a #GHookList, sorted by the given function.
         * @param hook_list a #GHookList
         * @param hook the #GHook to insert
         * @param func the comparison function used to sort the #GHook elements
         */
        function hook_insert_sorted(hook_list: HookList, hook: Hook, func: HookCompareFunc): void;
        /**
         * Prepends a #GHook on the start of a #GHookList.
         * @param hook_list a #GHookList
         * @param hook the #GHook to add to the start of @hook_list
         */
        function hook_prepend(hook_list: HookList, hook: Hook): void;
        /**
         * Decrements the reference count of a #GHook.
         * If the reference count falls to 0, the #GHook is removed
         * from the #GHookList and g_hook_free() is called to free it.
         * @param hook_list a #GHookList
         * @param hook the #GHook to unref
         */
        function hook_unref(hook_list: HookList, hook: Hook): void;
        /**
         * Tests if `hostname` contains segments with an ASCII-compatible
         * encoding of an Internationalized Domain Name. If this returns
         * %TRUE, you should decode the hostname with g_hostname_to_unicode()
         * before displaying it to the user.
         *
         * Note that a hostname might contain a mix of encoded and unencoded
         * segments, and so it is possible for g_hostname_is_non_ascii() and
         * g_hostname_is_ascii_encoded() to both return %TRUE for a name.
         * @param hostname a hostname
         * @returns %TRUE if @hostname contains any ASCII-encoded segments.
         */
        function hostname_is_ascii_encoded(hostname: string): boolean;
        /**
         * Tests if `hostname` is the string form of an IPv4 or IPv6 address.
         * (Eg, "192.168.0.1".)
         *
         * Since 2.66, IPv6 addresses with a zone-id are accepted (RFC6874).
         * @param hostname a hostname (or IP address in string form)
         * @returns %TRUE if @hostname is an IP address
         */
        function hostname_is_ip_address(hostname: string): boolean;
        /**
         * Tests if `hostname` contains Unicode characters. If this returns
         * %TRUE, you need to encode the hostname with g_hostname_to_ascii()
         * before using it in non-IDN-aware contexts.
         *
         * Note that a hostname might contain a mix of encoded and unencoded
         * segments, and so it is possible for g_hostname_is_non_ascii() and
         * g_hostname_is_ascii_encoded() to both return %TRUE for a name.
         * @param hostname a hostname
         * @returns %TRUE if @hostname contains any non-ASCII characters
         */
        function hostname_is_non_ascii(hostname: string): boolean;
        /**
         * Converts `hostname` to its canonical ASCII form; an ASCII-only
         * string containing no uppercase letters and not ending with a
         * trailing dot.
         * @param hostname a valid UTF-8 or ASCII hostname
         * @returns an ASCII hostname, which must be freed,    or %NULL if @hostname is in some way invalid.
         */
        function hostname_to_ascii(hostname: string): string | null;
        /**
         * Converts `hostname` to its canonical presentation form; a UTF-8
         * string in Unicode normalization form C, containing no uppercase
         * letters, no forbidden characters, and no ASCII-encoded segments,
         * and not ending with a trailing dot.
         *
         * Of course if `hostname` is not an internationalized hostname, then
         * the canonical presentation form will be entirely ASCII.
         * @param hostname a valid UTF-8 or ASCII hostname
         * @returns a UTF-8 hostname, which must be freed,    or %NULL if @hostname is in some way invalid.
         */
        function hostname_to_unicode(hostname: string): string | null;
        /**
         * Adds a function to be called whenever there are no higher priority
         * events pending.
         *
         * If the function returns [const`GLib`.SOURCE_REMOVE] or %FALSE it is automatically
         * removed from the list of event sources and will not be called again.
         *
         * See [mainloop memory management](main-loop.html#memory-management-of-sources) for details
         * on how to handle the return value and memory management of `data`.
         *
         * This internally creates a main loop source using [func`GLib`.idle_source_new]
         * and attaches it to the global [struct`GLib`.MainContext] using
         * [method`GLib`.Source.attach], so the callback will be invoked in whichever
         * thread is running that main context. You can do these steps manually if you
         * need greater control or to use a custom main context.
         * @param priority the priority of the idle source. Typically this will be in the   range between [const@GLib.PRIORITY_DEFAULT_IDLE] and   [const@GLib.PRIORITY_HIGH_IDLE].
         * @param _function function to call
         * @param notify function to call when the idle is removed, or %NULL
         * @returns the ID (greater than 0) of the event source.
         */
        function idle_add(priority: number, _function: SourceFunc, notify?: DestroyNotify | null): number;
        /**
         * Removes the idle function with the given data.
         * @param data the data for the idle source's callback.
         * @returns %TRUE if an idle source was found and removed.
         */
        function idle_remove_by_data(data?: any | null): boolean;
        /**
         * Creates a new idle source.
         *
         * The source will not initially be associated with any
         * [struct`GLib`.MainContext] and must be added to one with
         * [method`GLib`.Source.attach] before it will be executed. Note that the
         * default priority for idle sources is [const`GLib`.PRIORITY_DEFAULT_IDLE], as
         * compared to other sources which have a default priority of
         * [const`GLib`.PRIORITY_DEFAULT].
         * @returns the newly-created idle source
         */
        function idle_source_new(): Source;
        /**
         * Compares the two #gint64 values being pointed to and returns
         * %TRUE if they are equal.
         * It can be passed to g_hash_table_new() as the `key_equal_func`
         * parameter, when using non-%NULL pointers to 64-bit integers as keys in a
         * #GHashTable.
         * @param v1 a pointer to a #gint64 key
         * @param v2 a pointer to a #gint64 key to compare with @v1
         * @returns %TRUE if the two keys match.
         */
        function int64_equal(v1: any, v2: any): boolean;
        /**
         * Converts a pointer to a #gint64 to a hash value.
         *
         * It can be passed to g_hash_table_new() as the `hash_func` parameter,
         * when using non-%NULL pointers to 64-bit integer values as keys in a
         * #GHashTable.
         * @param v a pointer to a #gint64 key
         * @returns a hash value corresponding to the key.
         */
        function int64_hash(v: any): number;
        /**
         * Compares the two #gint values being pointed to and returns
         * %TRUE if they are equal.
         * It can be passed to g_hash_table_new() as the `key_equal_func`
         * parameter, when using non-%NULL pointers to integers as keys in a
         * #GHashTable.
         *
         * Note that this function acts on pointers to #gint, not on #gint
         * directly: if your hash table's keys are of the form
         * `GINT_TO_POINTER (n)`, use g_direct_equal() instead.
         * @param v1 a pointer to a #gint key
         * @param v2 a pointer to a #gint key to compare with @v1
         * @returns %TRUE if the two keys match.
         */
        function int_equal(v1: any, v2: any): boolean;
        /**
         * Converts a pointer to a #gint to a hash value.
         * It can be passed to g_hash_table_new() as the `hash_func` parameter,
         * when using non-%NULL pointers to integer values as keys in a #GHashTable.
         *
         * Note that this function acts on pointers to #gint, not on #gint
         * directly: if your hash table's keys are of the form
         * `GINT_TO_POINTER (n)`, use g_direct_hash() instead.
         * @param v a pointer to a #gint key
         * @returns a hash value corresponding to the key.
         */
        function int_hash(v: any): number;
        /**
         * Returns a canonical representation for `string`. Interned strings
         * can be compared for equality by comparing the pointers, instead of
         * using strcmp(). g_intern_static_string() does not copy the string,
         * therefore `string` must not be freed or modified.
         *
         * This function must not be used before library constructors have finished
         * running. In particular, this means it cannot be used to initialize global
         * variables in C++.
         * @param string a static string
         * @returns a canonical representation for the string
         */
        function intern_static_string(string?: string | null): string;
        /**
         * Returns a canonical representation for `string`. Interned strings
         * can be compared for equality by comparing the pointers, instead of
         * using strcmp().
         *
         * This function must not be used before library constructors have finished
         * running. In particular, this means it cannot be used to initialize global
         * variables in C++.
         * @param string a string
         * @returns a canonical representation for the string
         */
        function intern_string(string?: string | null): string;
        /**
         * Adds the #GIOChannel into the default main loop context
         * with the given priority.
         *
         * This internally creates a main loop source using g_io_create_watch()
         * and attaches it to the main loop context with g_source_attach().
         * You can do these steps manually if you need greater control.
         * @param channel a #GIOChannel
         * @param priority the priority of the #GIOChannel source
         * @param condition the condition to watch for
         * @param func the function to call when the condition is satisfied
         * @returns the event source id
         */
        function io_add_watch(
            channel: IOChannel,
            priority: number,
            condition: IOCondition | null,
            func: IOFunc,
        ): number;
        /**
         * Converts an `errno` error number to a #GIOChannelError.
         * @param en an `errno` error number, e.g. `EINVAL`
         * @returns a #GIOChannelError error number, e.g.      %G_IO_CHANNEL_ERROR_INVAL.
         */
        function io_channel_error_from_errno(en: number): IOChannelError;
        function io_channel_error_quark(): Quark;
        /**
         * Creates a #GSource that's dispatched when `condition` is met for the
         * given `channel`. For example, if condition is %G_IO_IN, the source will
         * be dispatched when there's data available for reading.
         *
         * The callback function invoked by the #GSource should be added with
         * g_source_set_callback(), but it has type #GIOFunc (not #GSourceFunc).
         *
         * g_io_add_watch() is a simpler interface to this same functionality, for
         * the case where you want to add the source to the default main loop context
         * at the default priority.
         *
         * On Windows, polling a #GSource created to watch a channel for a socket
         * puts the socket in non-blocking mode. This is a side-effect of the
         * implementation and unavoidable.
         * @param channel a #GIOChannel to watch
         * @param condition conditions to watch for
         * @returns a new #GSource
         */
        function io_create_watch(channel: IOChannel, condition: IOCondition | null): Source;
        function key_file_error_quark(): Quark;
        function list_pop_allocator(): void;
        function list_push_allocator(allocator: Allocator): void;
        /**
         * Gets the names of all variables set in the environment.
         *
         * Programs that want to be portable to Windows should typically use
         * this function and g_getenv() instead of using the environ array
         * from the C library directly. On Windows, the strings in the environ
         * array are in system codepage encoding, while in most of the typical
         * use cases for environment variables in GLib-using programs you want
         * the UTF-8 encoding that this function and g_getenv() provide.
         * @returns a %NULL-terminated list of strings which must be freed with     g_strfreev().
         */
        function listenv(): string[];
        /**
         * Converts a string from UTF-8 to the encoding used for strings by
         * the C runtime (usually the same as that used by the operating
         * system) in the [current locale](running.html#locale).
         * On Windows this means the system codepage.
         *
         * The input string shall not contain nul characters even if the `len`
         * argument is positive. A nul character found inside the string will result
         * in error %G_CONVERT_ERROR_ILLEGAL_SEQUENCE. Use g_convert() to convert
         * input that may contain embedded nul characters.
         * @param utf8string a UTF-8 encoded string
         * @param len the length of the string, or -1 if the string is                 nul-terminated.
         * @returns A newly-allocated buffer containing the converted string,          or %NULL on an error, and error will be set.
         */
        function locale_from_utf8(utf8string: string, len: number): [Uint8Array, number];
        /**
         * Converts a string which is in the encoding used for strings by
         * the C runtime (usually the same as that used by the operating
         * system) in the [current locale](running.html#locale) into a UTF-8 string.
         *
         * If the source encoding is not UTF-8 and the conversion output contains a
         * nul character, the error %G_CONVERT_ERROR_EMBEDDED_NUL is set and the
         * function returns %NULL.
         * If the source encoding is UTF-8, an embedded nul character is treated with
         * the %G_CONVERT_ERROR_ILLEGAL_SEQUENCE error for backward compatibility with
         * earlier versions of this library. Use g_convert() to produce output that
         * may contain embedded nul characters.
         * @param opsysstring a string in the                 encoding of the current locale. On Windows                 this means the system codepage.
         * @returns The converted string, or %NULL on an error.
         */
        function locale_to_utf8(opsysstring: Uint8Array | string): [string, number, number];
        /**
         * The default log handler set up by GLib; [func`GLib`.log_set_default_handler]
         * allows to install an alternate default log handler.
         *
         * This is used if no log handler has been set for the particular log
         * domain and log level combination. It outputs the message to `stderr`
         * or `stdout` and if the log level is fatal it calls [func`GLib`.BREAKPOINT]. It automatically
         * prints a new-line character after the message, so one does not need to be
         * manually included in `message`.
         *
         * The behavior of this log handler can be influenced by a number of
         * environment variables:
         *
         *   - `G_MESSAGES_PREFIXED`: A `:`-separated list of log levels for which
         *     messages should be prefixed by the program name and PID of the
         *     application.
         *   - `G_MESSAGES_DEBUG`: A space-separated list of log domains for
         *     which debug and informational messages are printed. By default
         *     these messages are not printed. If you need to set the allowed
         *     domains at runtime, use [func`GLib`.log_writer_default_set_debug_domains].
         *   - `DEBUG_INVOCATION`: If set to `1`, this is equivalent to
         *     `G_MESSAGES_DEBUG=all`. `DEBUG_INVOCATION` is a standard environment
         *     variable set by systemd to prompt debug output. (Since: 2.84)
         *
         * `stderr` is used for levels [flags`GLib`.LogLevelFlags.LEVEL_ERROR],
         * [flags`GLib`.LogLevelFlags.LEVEL_CRITICAL], [flags`GLib`.LogLevelFlags.LEVEL_WARNING] and
         * [flags`GLib`.LogLevelFlags.LEVEL_MESSAGE]. `stdout` is used for
         * the rest, unless `stderr` was requested by
         * [func`GLib`.log_writer_default_set_use_stderr].
         *
         * This has no effect if structured logging is enabled; see
         * [Using Structured Logging](logging.html#using-structured-logging).
         * @param log_domain the log domain of the message, or `NULL` for the   default `""` application domain
         * @param log_level the level of the message
         * @param message the message
         * @param unused_data data passed from [func@GLib.log] which is unused
         */
        function log_default_handler(
            log_domain: string | null,
            log_level: LogLevelFlags | null,
            message?: string | null,
            unused_data?: any | null,
        ): void;
        /**
         * Return whether debug output from the GLib logging system is enabled.
         *
         * Note that this should not be used to conditionalise calls to [func`GLib`.debug] or
         * other logging functions; it should only be used from [type`GLib`.LogWriterFunc]
         * implementations.
         *
         * Note also that the value of this does not depend on `G_MESSAGES_DEBUG`, nor
         * `DEBUG_INVOCATION`, nor [func`GLib`.log_writer_default_set_debug_domains]; see
         * the docs for [func`GLib`.log_set_debug_enabled].
         * @returns `TRUE` if debug output is enabled, `FALSE` otherwise
         */
        function log_get_debug_enabled(): boolean;
        /**
         * Removes the log handler.
         *
         * This has no effect if structured logging is enabled; see
         * [Using Structured Logging](logging.html#using-structured-logging).
         * @param log_domain the log domain
         * @param handler_id the ID of the handler, which was returned   in [func@GLib.log_set_handler]
         */
        function log_remove_handler(log_domain: string, handler_id: number): void;
        /**
         * Sets the message levels which are always fatal, in any log domain.
         *
         * When a message with any of these levels is logged the program terminates.
         * You can only set the levels defined by GLib to be fatal.
         * [flags`GLib`.LogLevelFlags.LEVEL_ERROR] is always fatal.
         *
         * You can also make some message levels fatal at runtime by setting
         * the `G_DEBUG` environment variable (see
         * [Running GLib Applications](glib-running.html)).
         *
         * Libraries should not call this function, as it affects all messages logged
         * by a process, including those from other libraries.
         *
         * Structured log messages (using [func`GLib`.log_structured] and
         * [func`GLib`.log_structured_array]) are fatal only if the default log writer is used;
         * otherwise it is up to the writer function to determine which log messages
         * are fatal. See [Using Structured Logging](logging.html#using-structured-logging).
         * @param fatal_mask the mask containing bits set for each level of error which is   to be fatal
         * @returns the old fatal mask
         */
        function log_set_always_fatal(fatal_mask: LogLevelFlags | null): LogLevelFlags;
        /**
         * Enable or disable debug output from the GLib logging system for all domains.
         *
         * This value interacts disjunctively with `G_MESSAGES_DEBUG`, `DEBUG_INVOCATION` and
         * [func`GLib`.log_writer_default_set_debug_domains] — if any of them would allow
         * a debug message to be outputted, it will be.
         *
         * Note that this should not be used from within library code to enable debug
         * output — it is intended for external use.
         * @param enabled `TRUE` to enable debug output, `FALSE` otherwise
         */
        function log_set_debug_enabled(enabled: boolean): void;
        /**
         * Sets the log levels which are fatal in the given domain.
         *
         * [flags`GLib`.LogLevelFlags.LEVEL_ERROR] is always fatal.
         *
         * This has no effect on structured log messages (using [func`GLib`.log_structured] or
         * [func`GLib`.log_structured_array]). To change the fatal behaviour for specific log
         * messages, programs must install a custom log writer function using
         * [func`GLib`.log_set_writer_func]. See
         * [Using Structured Logging](logging.html#using-structured-logging).
         *
         * This function is mostly intended to be used with
         * [flags`GLib`.LogLevelFlags.LEVEL_CRITICAL].  You should typically not set
         * [flags`GLib`.LogLevelFlags.LEVEL_WARNING], [flags`GLib`.LogLevelFlags.LEVEL_MESSAGE], [flags`GLib`.LogLevelFlags.LEVEL_INFO] or
         * [flags`GLib`.LogLevelFlags.LEVEL_DEBUG] as fatal except inside of test programs.
         * @param log_domain the log domain
         * @param fatal_mask the new fatal mask
         * @returns the old fatal mask for the log domain
         */
        function log_set_fatal_mask(log_domain: string, fatal_mask: LogLevelFlags | null): LogLevelFlags;
        /**
         * Like [func`GLib`.log_set_handler], but takes a destroy notify for the `user_data`.
         *
         * This has no effect if structured logging is enabled; see
         * [Using Structured Logging](logging.html#using-structured-logging).
         *
         * The `log_domain` parameter can be set to `NULL` or an empty string to use the default
         * application domain.
         * @param log_domain the log domain   application domain
         * @param log_levels the log levels to apply the log handler for.   To handle fatal and recursive messages as well, combine   the log levels with the [flags@GLib.LogLevelFlags.FLAG_FATAL] and   [flags@GLib.LogLevelFlags.FLAG_RECURSION] bit flags.
         * @param log_func the log handler function
         * @returns the ID of the new handler
         */
        function log_set_handler(
            log_domain: string | null,
            log_levels: LogLevelFlags | null,
            log_func: LogFunc,
        ): number;
        /**
         * Set a writer function which will be called to format and write out each log
         * message.
         *
         * Each program should set a writer function, or the default writer
         * ([func`GLib`.log_writer_default]) will be used.
         *
         * Libraries **must not** call this function — only programs are allowed to
         * install a writer function, as there must be a single, central point where
         * log messages are formatted and outputted.
         *
         * There can only be one writer function. It is an error to set more than one.
         * @param func log writer function, which must not be `NULL`
         */
        function log_set_writer_func(func: LogWriterFunc): void;
        /**
         * Log a message with structured data.
         *
         * The message will be passed through to the log writer set by the application
         * using [func`GLib`.log_set_writer_func]. If the
         * message is fatal (i.e. its log level is [flags`GLib`.LogLevelFlags.LEVEL_ERROR]), the program will
         * be aborted at the end of this function.
         *
         * See [func`GLib`.log_structured] for more documentation.
         *
         * This assumes that `log_level` is already present in `fields` (typically as the
         * `PRIORITY` field).
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields key–value pairs of structured data to add    to the log message
         */
        function log_structured_array(log_level: LogLevelFlags | null, fields: LogField[]): void;
        /**
         * Log a message with structured data, accepting the data within a [type`GLib`.Variant].
         *
         * This version is especially useful for use in other languages, via introspection.
         *
         * The only mandatory item in the `fields` dictionary is the `"MESSAGE"` which must
         * contain the text shown to the user.
         *
         * The values in the `fields` dictionary are likely to be of type `G_VARIANT_TYPE_STRING`.
         * Array of bytes (`G_VARIANT_TYPE_BYTESTRING`) is also
         * supported. In this case the message is handled as binary and will be forwarded
         * to the log writer as such. The size of the array should not be higher than
         * `G_MAXSSIZE`. Otherwise it will be truncated to this size. For other types
         * [method`GLib`.Variant.print] will be used to convert the value into a string.
         *
         * For more details on its usage and about the parameters, see [func`GLib`.log_structured].
         * @param log_domain log domain, usually `G_LOG_DOMAIN`
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields a dictionary ([type@GLib.Variant] of the type `G_VARIANT_TYPE_VARDICT`) containing the key-value pairs of message data.
         */
        function log_variant(log_domain: string | null, log_level: LogLevelFlags | null, fields: Variant): void;
        /**
         * Format a structured log message and output it to the default log destination
         * for the platform.
         *
         * On Linux, this is typically the systemd journal, falling
         * back to `stdout` or `stderr` if running from the terminal or if output is
         * being redirected to a file.
         *
         * Support for other platform-specific logging mechanisms may be added in
         * future. Distributors of GLib may modify this function to impose their own
         * (documented) platform-specific log writing policies.
         *
         * This is suitable for use as a [type`GLib`.LogWriterFunc], and is the default writer used
         * if no other is set using [func`GLib`.log_set_writer_func].
         *
         * As with [func`GLib`.log_default_handler], this function drops debug and informational
         * messages unless their log domain (or `all`) is listed in the space-separated
         * `G_MESSAGES_DEBUG` environment variable, or `DEBUG_INVOCATION=1` is set in
         * the environment, or set at runtime by [func`GLib`.log_writer_default_set_debug_domains].
         *
         * [func`GLib`.log_writer_default] uses the mask set by [func`GLib`.log_set_always_fatal] to
         * determine which messages are fatal. When using a custom writer function instead it is
         * up to the writer function to determine which log messages are fatal.
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields key–value pairs of structured data forming    the log message
         * @param user_data user data passed to [func@GLib.log_set_writer_func]
         * @returns [enum@GLib.LogWriterOutput.HANDLED] on success,   [enum@GLib.LogWriterOutput.UNHANDLED] otherwise
         */
        function log_writer_default(
            log_level: LogLevelFlags | null,
            fields: LogField[],
            user_data?: any | null,
        ): LogWriterOutput;
        /**
         * Reset the list of domains to be logged, that might be initially set by the
         * `G_MESSAGES_DEBUG` or `DEBUG_INVOCATION` environment variables.
         *
         * This function is thread-safe.
         * @param domains `NULL`-terminated array with domains to be printed.   `NULL` or an array with no values means none. Array with a single value `"all"` means all.
         */
        function log_writer_default_set_debug_domains(domains?: string | null): void;
        /**
         * Configure whether the built-in log functions will output all log messages to
         * `stderr`.
         *
         * The built-in log functions are [func`GLib`.log_default_handler] for the
         * old-style API, and both [func`GLib`.log_writer_default] and
         * [func`GLib`.log_writer_standard_streams] for the structured API.
         *
         * By default, log messages of levels [flags`GLib`.LogLevelFlags.LEVEL_INFO] and
         * [flags`GLib`.LogLevelFlags.LEVEL_DEBUG] are sent to `stdout`, and other log messages are
         * sent to `stderr`. This is problematic for applications that intend
         * to reserve `stdout` for structured output such as JSON or XML.
         *
         * This function sets global state. It is not thread-aware, and should be
         * called at the very start of a program, before creating any other threads
         * or creating objects that could create worker threads of their own.
         * @param use_stderr If `TRUE`, use `stderr` for log messages that would  normally have appeared on `stdout`
         */
        function log_writer_default_set_use_stderr(use_stderr: boolean): void;
        /**
         * Check whether [func`GLib`.log_writer_default] and [func`GLib`.log_default_handler] would
         * ignore a message with the given domain and level.
         *
         * As with [func`GLib`.log_default_handler], this function drops debug and informational
         * messages unless their log domain (or `all`) is listed in the space-separated
         * `G_MESSAGES_DEBUG` environment variable, or `DEBUG_INVOCATION=1` is set in
         * the environment, or by [func`GLib`.log_writer_default_set_debug_domains].
         *
         * This can be used when implementing log writers with the same filtering
         * behaviour as the default, but a different destination or output format:
         *
         * ```c
         * if (g_log_writer_default_would_drop (log_level, log_domain))
         *   return G_LOG_WRITER_HANDLED;
         * ```
         *
         *
         * or to skip an expensive computation if it is only needed for a debugging
         * message, and `G_MESSAGES_DEBUG` and `DEBUG_INVOCATION` are not set:
         *
         * ```c
         * if (!g_log_writer_default_would_drop (G_LOG_LEVEL_DEBUG, G_LOG_DOMAIN))
         *   {
         *     g_autofree gchar *result = expensive_computation (my_object);
         *
         *     g_debug ("my_object result: %s", result);
         *   }
         * ```
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param log_domain log domain
         * @returns `TRUE` if the log message would be dropped by GLib’s   default log handlers
         */
        function log_writer_default_would_drop(log_level: LogLevelFlags | null, log_domain?: string | null): boolean;
        /**
         * Format a structured log message as a string suitable for outputting to the
         * terminal (or elsewhere).
         *
         * This will include the values of all fields it knows
         * how to interpret, which includes `MESSAGE` and `GLIB_DOMAIN` (see the
         * documentation for [func`GLib`.log_structured]). It does not include values from
         * unknown fields.
         *
         * The returned string does **not** have a trailing new-line character. It is
         * encoded in the character set of the current locale, which is not necessarily
         * UTF-8.
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields key–value pairs of structured data forming    the log message
         * @param use_color `TRUE` to use   [ANSI color escape sequences](https://en.wikipedia.org/wiki/ANSI_escape_code)   when formatting the message, `FALSE` to not
         * @returns string containing the formatted log message, in    the character set of the current locale
         */
        function log_writer_format_fields(
            log_level: LogLevelFlags | null,
            fields: LogField[],
            use_color: boolean,
        ): string;
        /**
         * Check whether the given `output_fd` file descriptor is a connection to the
         * systemd journal, or something else (like a log file or `stdout` or
         * `stderr`).
         *
         * Invalid file descriptors are accepted and return `FALSE`, which allows for
         * the following construct without needing any additional error handling:
         * ```c
         * is_journald = g_log_writer_is_journald (fileno (stderr));
         * ```
         * @param output_fd output file descriptor to check
         * @returns `TRUE` if @output_fd points to the journal, `FALSE` otherwise
         */
        function log_writer_is_journald(output_fd: number): boolean;
        /**
         * Format a structured log message and send it to the systemd journal as a set
         * of key–value pairs.
         *
         * All fields are sent to the journal, but if a field has
         * length zero (indicating program-specific data) then only its key will be
         * sent.
         *
         * This is suitable for use as a [type`GLib`.LogWriterFunc].
         *
         * If GLib has been compiled without systemd support, this function is still
         * defined, but will always return [enum`GLib`.LogWriterOutput.UNHANDLED].
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields key–value pairs of structured data forming    the log message
         * @param user_data user data passed to [func@GLib.log_set_writer_func]
         * @returns [enum@GLib.LogWriterOutput.HANDLED] on success, [enum@GLib.LogWriterOutput.UNHANDLED] otherwise
         */
        function log_writer_journald(
            log_level: LogLevelFlags | null,
            fields: LogField[],
            user_data?: any | null,
        ): LogWriterOutput;
        /**
         * Format a structured log message and print it to either `stdout` or `stderr`,
         * depending on its log level.
         *
         * [flags`GLib`.LogLevelFlags.LEVEL_INFO] and [flags`GLib`.LogLevelFlags.LEVEL_DEBUG] messages
         * are sent to `stdout`, or to `stderr` if requested by
         * [func`GLib`.log_writer_default_set_use_stderr];
         * all other log levels are sent to `stderr`. Only fields
         * which are understood by this function are included in the formatted string
         * which is printed.
         *
         * If the output stream supports
         * [ANSI color escape sequences](https://en.wikipedia.org/wiki/ANSI_escape_code),
         * they will be used in the output.
         *
         * A trailing new-line character is added to the log message when it is printed.
         *
         * This is suitable for use as a [type`GLib`.LogWriterFunc].
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields key–value pairs of structured data forming    the log message
         * @param user_data user data passed to [func@GLib.log_set_writer_func]
         * @returns [enum@GLib.LogWriterOutput.HANDLED] on success,   [enum@GLib.LogWriterOutput.UNHANDLED] otherwise
         */
        function log_writer_standard_streams(
            log_level: LogLevelFlags | null,
            fields: LogField[],
            user_data?: any | null,
        ): LogWriterOutput;
        /**
         * Check whether the given `output_fd` file descriptor supports
         * [ANSI color escape sequences](https://en.wikipedia.org/wiki/ANSI_escape_code).
         *
         * If so, they can safely be used when formatting log messages.
         * @param output_fd output file descriptor to check
         * @returns `TRUE` if ANSI color escapes are supported, `FALSE` otherwise
         */
        function log_writer_supports_color(output_fd: number): boolean;
        /**
         * Format a structured log message and send it to the syslog daemon. Only fields
         * which are understood by this function are included in the formatted string
         * which is printed.
         *
         * Log facility will be defined via the SYSLOG_FACILITY field and accepts the following
         * values: "auth", "daemon", and "user". If SYSLOG_FACILITY is not specified, LOG_USER
         * facility will be used.
         *
         * This is suitable for use as a [type`GLib`.LogWriterFunc].
         *
         * If syslog is not supported, this function is still defined, but will always
         * return [enum`GLib`.LogWriterOutput.UNHANDLED].
         * @param log_level log level, either from [type@GLib.LogLevelFlags], or a user-defined    level
         * @param fields key–value pairs of structured data forming    the log message
         * @param user_data user data passed to [func@GLib.log_set_writer_func]
         * @returns [enum@GLib.LogWriterOutput.HANDLED] on success, [enum@GLib.LogWriterOutput.UNHANDLED] otherwise
         */
        function log_writer_syslog(
            log_level: LogLevelFlags | null,
            fields: LogField[],
            user_data?: any | null,
        ): LogWriterOutput;
        /**
         * A wrapper for the POSIX lstat() function. The lstat() function is
         * like stat() except that in the case of symbolic links, it returns
         * information about the symbolic link itself and not the file that it
         * refers to. If the system does not support symbolic links g_lstat()
         * is identical to g_stat().
         *
         * See your C library manual for more details about lstat().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param buf a pointer to a stat struct, which will be filled with the file     information
         * @returns 0 if the information was successfully retrieved,     -1 if an error occurred
         */
        function lstat(filename: string, buf: StatBuf): number;
        /**
         * Returns the global-default main context. This is the main context
         * used for main loop functions when a main loop is not explicitly
         * specified, and corresponds to the "main" main loop. See also
         * [func`GLib`.MainContext.get_thread_default].
         * @returns the global-default main context.
         */
        function main_context_default(): MainContext;
        /**
         * Gets the thread-default #GMainContext for this thread. Asynchronous
         * operations that want to be able to be run in contexts other than
         * the default one should call this method or
         * [func`GLib`.MainContext.ref_thread_default] to get a
         * [struct`GLib`.MainContext] to add their [struct`GLib`.Source]s to. (Note that
         * even in single-threaded programs applications may sometimes want to
         * temporarily push a non-default context, so it is not safe to assume that
         * this will always return %NULL if you are running in the default thread.)
         *
         * If you need to hold a reference on the context, use
         * [func`GLib`.MainContext.ref_thread_default] instead.
         * @returns the thread-default #GMainContext, or %NULL if the thread-default context is the global-default main context.
         */
        function main_context_get_thread_default(): MainContext | null;
        /**
         * Gets the thread-default [struct`GLib`.MainContext] for this thread, as with
         * [func`GLib`.MainContext.get_thread_default], but also adds a reference to
         * it with [method`GLib`.MainContext.ref]. In addition, unlike
         * [func`GLib`.MainContext.get_thread_default], if the thread-default context
         * is the global-default context, this will return that
         * [struct`GLib`.MainContext] (with a ref added to it) rather than returning
         * %NULL.
         * @returns the thread-default #GMainContext. Unref     with [method@GLib.MainContext.unref] when you are done with it.
         */
        function main_context_ref_thread_default(): MainContext;
        /**
         * Returns the currently firing source for this thread.
         * @returns The currently firing source or %NULL.
         */
        function main_current_source(): Source | null;
        /**
         * Returns the depth of the stack of calls to
         * [method`GLib`.MainContext.dispatch] on any #GMainContext in the current thread.
         * That is, when called from the toplevel, it gives 0. When
         * called from within a callback from [method`GLib`.MainContext.iteration]
         * (or [method`GLib`.MainLoop.run], etc.) it returns 1. When called from within
         * a callback to a recursive call to [method`GLib`.MainContext.iteration],
         * it returns 2. And so forth.
         *
         * This function is useful in a situation like the following:
         * Imagine an extremely simple "garbage collected" system.
         *
         *
         * ```c
         * static GList *free_list;
         *
         * gpointer
         * allocate_memory (gsize size)
         * {
         *   gpointer result = g_malloc (size);
         *   free_list = g_list_prepend (free_list, result);
         *   return result;
         * }
         *
         * void
         * free_allocated_memory (void)
         * {
         *   GList *l;
         *   for (l = free_list; l; l = l->next);
         *     g_free (l->data);
         *   g_list_free (free_list);
         *   free_list = NULL;
         *  }
         *
         * [...]
         *
         * while (TRUE);
         *  {
         *    g_main_context_iteration (NULL, TRUE);
         *    free_allocated_memory();
         *   }
         * ```
         *
         *
         * This works from an application, however, if you want to do the same
         * thing from a library, it gets more difficult, since you no longer
         * control the main loop. You might think you can simply use an idle
         * function to make the call to free_allocated_memory(), but that
         * doesn't work, since the idle function could be called from a
         * recursive callback. This can be fixed by using [func`GLib`.main_depth]
         *
         *
         * ```c
         * gpointer
         * allocate_memory (gsize size)
         * {
         *   FreeListBlock *block = g_new (FreeListBlock, 1);
         *   block->mem = g_malloc (size);
         *   block->depth = g_main_depth ();
         *   free_list = g_list_prepend (free_list, block);
         *   return block->mem;
         * }
         *
         * void
         * free_allocated_memory (void)
         * {
         *   GList *l;
         *
         *   int depth = g_main_depth ();
         *   for (l = free_list; l; );
         *     {
         *       GList *next = l->next;
         *       FreeListBlock *block = l->data;
         *       if (block->depth > depth)
         *         {
         *           g_free (block->mem);
         *           g_free (block);
         *           free_list = g_list_delete_link (free_list, l);
         *         }
         *
         *       l = next;
         *     }
         *   }
         * ```
         *
         *
         * There is a temptation to use [func`GLib`.main_depth] to solve
         * problems with reentrancy. For instance, while waiting for data
         * to be received from the network in response to a menu item,
         * the menu item might be selected again. It might seem that
         * one could make the menu item's callback return immediately
         * and do nothing if [func`GLib`.main_depth] returns a value greater than 1.
         * However, this should be avoided since the user then sees selecting
         * the menu item do nothing. Furthermore, you'll find yourself adding
         * these checks all over your code, since there are doubtless many,
         * many things that the user could do. Instead, you can use the
         * following techniques:
         *
         * 1. Use gtk_widget_set_sensitive() or modal dialogs to prevent
         *    the user from interacting with elements while the main
         *    loop is recursing.
         *
         * 2. Avoid main loop recursion in situations where you can't handle
         *    arbitrary  callbacks. Instead, structure your code so that you
         *    simply return to the main loop and then get called again when
         *    there is more work to do.
         * @returns The main loop recursion level in the current thread
         */
        function main_depth(): number;
        /**
         * Allocates `n_bytes` bytes of memory.
         * If `n_bytes` is 0 it returns %NULL.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         * @param n_bytes the number of bytes to allocate
         * @returns a pointer to the allocated memory
         */
        function malloc(n_bytes: number): any | null;
        /**
         * Allocates `n_bytes` bytes of memory, initialized to 0's.
         * If `n_bytes` is 0 it returns %NULL.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         * @param n_bytes the number of bytes to allocate
         * @returns a pointer to the allocated memory
         */
        function malloc0(n_bytes: number): any | null;
        /**
         * This function is similar to g_malloc0(), allocating (`n_blocks` * `n_block_bytes)` bytes,
         * but care is taken to detect possible overflow during multiplication.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @returns a pointer to the allocated memory
         */
        function malloc0_n(n_blocks: number, n_block_bytes: number): any | null;
        /**
         * This function is similar to g_malloc(), allocating (`n_blocks` * `n_block_bytes)` bytes,
         * but care is taken to detect possible overflow during multiplication.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @returns a pointer to the allocated memory
         */
        function malloc_n(n_blocks: number, n_block_bytes: number): any | null;
        function markup_error_quark(): Quark;
        /**
         * Escapes text so that the markup parser will parse it verbatim.
         * Less than, greater than, ampersand, etc. are replaced with the
         * corresponding entities. This function would typically be used
         * when writing out a file to be parsed with the markup parser.
         *
         * Note that this function doesn't protect whitespace and line endings
         * from being processed according to the XML rules for normalization
         * of line endings and attribute values.
         *
         * Note also that this function will produce character references in
         * the range of &#x1; ... &#x1f; for all control sequences
         * except for tabstop, newline and carriage return.  The character
         * references in this range are not valid XML 1.0, but they are
         * valid XML 1.1 and will be accepted by the GMarkup parser.
         * @param text some valid UTF-8 text
         * @param length length of @text in bytes, or -1 if the text is nul-terminated
         * @returns a newly allocated string with the escaped text
         */
        function markup_escape_text(text: string, length: number): string;
        function mem_chunk_info(): void;
        /**
         * Checks whether the allocator used by g_malloc() is the system's
         * malloc implementation. If it returns %TRUE memory allocated with
         * malloc() can be used interchangeably with memory allocated using g_malloc().
         * This function is useful for avoiding an extra copy of allocated memory returned
         * by a non-GLib-based API.
         * @returns if %TRUE, malloc() and g_malloc() can be mixed.
         */
        function mem_is_system_malloc(): boolean;
        /**
         * GLib used to support some tools for memory profiling, but this
         * no longer works. There are many other useful tools for memory
         * profiling these days which can be used instead.
         */
        function mem_profile(): void;
        /**
         * This function used to let you override the memory allocation function.
         * However, its use was incompatible with the use of global constructors
         * in GLib and GIO, because those use the GLib allocators before main is
         * reached. Therefore this function is now deprecated and is just a stub.
         * @param vtable table of memory allocation routines.
         */
        function mem_set_vtable(vtable: MemVTable): void;
        /**
         * Allocates `byte_size` bytes of memory, and copies `byte_size` bytes into it
         * from `mem`. If `mem` is `NULL` it returns `NULL`.
         * @param mem the memory to copy
         * @param byte_size the number of bytes to copy
         * @returns a pointer to the newly-allocated copy of the memory
         */
        function memdup(mem: any | null, byte_size: number): any | null;
        /**
         * Allocates `byte_size` bytes of memory, and copies `byte_size` bytes into it
         * from `mem`. If `mem` is `NULL` it returns `NULL`.
         *
         * This replaces [func`GLib`.memdup], which was prone to integer overflows when
         * converting the argument from a `gsize` to a `guint`.
         * @param mem the memory to copy
         * @param byte_size the number of bytes to copy
         * @returns a pointer to the newly-allocated copy of the memory
         */
        function memdup2(mem: any | null, byte_size: number): any | null;
        /**
         * A wrapper for the POSIX mkdir() function. The mkdir() function
         * attempts to create a directory with the given name and permissions.
         * The mode argument is ignored on Windows.
         *
         * See your C library manual for more details about mkdir().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param mode permissions to use for the newly created directory
         * @returns 0 if the directory was successfully created, -1 if an error    occurred
         */
        function mkdir(filename: string, mode: number): number;
        /**
         * Create a directory if it doesn't already exist. Create intermediate
         * parent directories as needed, too.
         * @param pathname a pathname in the GLib file name encoding
         * @param mode permissions to use for newly created directories
         * @returns 0 if the directory already exists, or was successfully created. Returns -1 if an error occurred, with errno set.
         */
        function mkdir_with_parents(pathname: string, mode: number): number;
        function node_pop_allocator(): void;
        function node_push_allocator(allocator: Allocator): void;
        /**
         * Set the pointer at the specified location to %NULL.
         * @param nullify_location the memory address of the pointer.
         */
        function nullify_pointer(nullify_location: any): void;
        function number_parser_error_quark(): Quark;
        /**
         * Prompts the user with
         * `[E]xit, [H]alt, show [S]tack trace or [P]roceed`.
         * This function is intended to be used for debugging use only.
         * The following example shows how it can be used together with
         * the g_log() functions.
         *
         *
         * ```c
         * #include <glib.h>
         *
         * static void
         * log_handler (const gchar   *log_domain,
         *              GLogLevelFlags log_level,
         *              const gchar   *message,
         *              gpointer       user_data)
         * {
         *   g_log_default_handler (log_domain, log_level, message, user_data);
         *
         *   g_on_error_query (MY_PROGRAM_NAME);
         * }
         *
         * int
         * main (int argc, char *argv[])
         * {
         *   g_log_set_handler (MY_LOG_DOMAIN,
         *                      G_LOG_LEVEL_WARNING |
         *                      G_LOG_LEVEL_ERROR |
         *                      G_LOG_LEVEL_CRITICAL,
         *                      log_handler,
         *                      NULL);
         *   ...
         * ```
         *
         *
         * If "[E]xit" is selected, the application terminates with a call
         * to _exit(0).
         *
         * If "[S]tack" trace is selected, g_on_error_stack_trace() is called.
         * This invokes gdb, which attaches to the current process and shows
         * a stack trace. The prompt is then shown again.
         *
         * If "[P]roceed" is selected, the function returns.
         *
         * This function may cause different actions on non-UNIX platforms.
         *
         * On Windows consider using the `G_DEBUGGER` environment
         * variable (see [Running GLib Applications](glib-running.html)) and
         * calling g_on_error_stack_trace() instead.
         * @param prg_name the program name, needed by gdb for the "[S]tack trace"     option. If @prg_name is %NULL, g_get_prgname() is called to get     the program name (which will work correctly if gdk_init() or     gtk_init() has been called)
         */
        function on_error_query(prg_name: string): void;
        /**
         * Invokes gdb, which attaches to the current process and shows a
         * stack trace. Called by g_on_error_query() when the "[S]tack trace"
         * option is selected. You can get the current process's program name
         * with g_get_prgname(), assuming that you have called gtk_init() or
         * gdk_init().
         *
         * This function may cause different actions on non-UNIX platforms.
         *
         * When running on Windows, this function is *not* called by
         * g_on_error_query(). If called directly, it will raise an
         * exception, which will crash the program. If the `G_DEBUGGER` environment
         * variable is set, a debugger will be invoked to attach and
         * handle that exception (see [Running GLib Applications](glib-running.html)).
         * @param prg_name the program name, needed by gdb for the   "[S]tack trace" option, or `NULL` to use a default string
         */
        function on_error_stack_trace(prg_name?: string | null): void;
        /**
         * Function to be called when starting a critical initialization
         * section. The argument `location` must point to a static
         * 0-initialized variable that will be set to a value other than 0 at
         * the end of the initialization section. In combination with
         * g_once_init_leave() and the unique address `value_location,` it can
         * be ensured that an initialization section will be executed only once
         * during a program's life time, and that concurrent threads are
         * blocked until initialization completed. To be used in constructs
         * like this:
         *
         *
         * ```c
         *   static gsize initialization_value = 0;
         *
         *   if (g_once_init_enter (&initialization_value))
         *     {
         *       gsize setup_value = 42; // initialization code here
         *
         *       g_once_init_leave (&initialization_value, setup_value);
         *     }
         *
         *   // use initialization_value here
         * ```
         *
         *
         * While `location` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param location location of a static initializable variable    containing 0
         * @returns %TRUE if the initialization section should be entered,     %FALSE and blocks otherwise
         */
        function once_init_enter(location: any): [boolean, any];
        function once_init_enter_impl(location: number): boolean;
        /**
         * This functions behaves in the same way as g_once_init_enter(), but can
         * can be used to initialize pointers (or #guintptr) instead of #gsize.
         *
         *
         * ```c
         *   static MyStruct *interesting_struct = NULL;
         *
         *   if (g_once_init_enter_pointer (&interesting_struct))
         *     {
         *       MyStruct *setup_value = allocate_my_struct (); // initialization code here
         *
         *       g_once_init_leave_pointer (&interesting_struct, g_steal_pointer (&setup_value));
         *     }
         *
         *   // use interesting_struct here
         * ```
         *
         * @param location location of a static initializable variable    containing `NULL`
         * @returns %TRUE if the initialization section should be entered,     %FALSE and blocks otherwise
         */
        function once_init_enter_pointer(location: any): boolean;
        /**
         * Counterpart to g_once_init_enter(). Expects a location of a static
         * 0-initialized initialization variable, and an initialization value
         * other than 0. Sets the variable to the initialization value, and
         * releases concurrent threads blocking in g_once_init_enter() on this
         * initialization variable.
         *
         * While `location` has a `volatile` qualifier, this is a historical artifact and
         * the pointer passed to it should not be `volatile`.
         * @param location location of a static initializable variable    containing 0
         * @param result new non-0 value for `*value_location`
         */
        function once_init_leave(location: any, result: number): any;
        /**
         * Counterpart to g_once_init_enter_pointer(). Expects a location of a static
         * `NULL`-initialized initialization variable, and an initialization value
         * other than `NULL`. Sets the variable to the initialization value, and
         * releases concurrent threads blocking in g_once_init_enter_pointer() on this
         * initialization variable.
         *
         * This functions behaves in the same way as g_once_init_leave(), but
         * can be used to initialize pointers (or #guintptr) instead of #gsize.
         * @param location location of a static initializable variable    containing `NULL`
         * @param result new non-`NULL` value for `*location`
         */
        function once_init_leave_pointer(location: any, result?: any | null): void;
        /**
         * A wrapper for the POSIX open() function. The open() function is
         * used to convert a pathname into a file descriptor.
         *
         * On POSIX systems file descriptors are implemented by the operating
         * system. On Windows, it's the C library that implements open() and
         * file descriptors. The actual Win32 API for opening files is quite
         * different, see MSDN documentation for CreateFile(). The Win32 API
         * uses file handles, which are more randomish integers, not small
         * integers like file descriptors.
         *
         * Because file descriptors are specific to the C library on Windows,
         * the file descriptor returned by this function makes sense only to
         * functions in the same C library. Thus if the GLib-using code uses a
         * different C library than GLib does, the file descriptor returned by
         * this function cannot be passed to C library functions like write()
         * or read().
         *
         * See your C library manual for more details about open().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param flags as in open()
         * @param mode as in open()
         * @returns a new file descriptor, or -1 if an error occurred.     The return value can be used exactly like the return value     from open().
         */
        function open(filename: string, flags: number, mode: number): number;
        function option_error_quark(): Quark;
        /**
         * Parses a string containing debugging options
         * into a %guint containing bit flags. This is used
         * within GDK and GTK to parse the debug options passed on the
         * command line or through environment variables.
         *
         * If `string` is equal to "all", all flags are set. Any flags
         * specified along with "all" in `string` are inverted; thus,
         * "all,foo,bar" or "foo,bar,all" sets all flags except those
         * corresponding to "foo" and "bar".
         *
         * If `string` is equal to "help", all the available keys in `keys`
         * are printed out to standard error.
         * @param string a list of debug options separated by colons, spaces, or commas, or %NULL.
         * @param keys pointer to an array of #GDebugKey which associate     strings with bit flags.
         * @returns the combined set of bit flags.
         */
        function parse_debug_string(string: string | null, keys: DebugKey[]): number;
        /**
         * Compares two path buffers for equality and returns `TRUE`
         * if they are equal.
         *
         * The path inside the paths buffers are not going to be normalized,
         * so `X/Y/Z/A/..`, `X/./Y/Z` and `X/Y/Z` are not going to be considered
         * equal.
         *
         * This function can be passed to g_hash_table_new() as the
         * `key_equal_func` parameter.
         * @param v1 a path buffer to compare
         * @param v2 a path buffer to compare
         * @returns `TRUE` if the two path buffers are equal,   and `FALSE` otherwise
         */
        function path_buf_equal(v1: any, v2: any): boolean;
        /**
         * Gets the last component of the filename.
         *
         * If `file_name` ends with a directory separator it gets the component
         * before the last slash. If `file_name` consists only of directory
         * separators (and on Windows, possibly a drive letter), a single
         * separator is returned. If `file_name` is empty, it gets ".".
         * @param file_name the name of the file
         * @returns a newly allocated string   containing the last component of the filename
         */
        function path_get_basename(file_name: string): string;
        /**
         * Gets the directory components of a file name. For example, the directory
         * component of `/usr/bin/test` is `/usr/bin`. The directory component of `/`
         * is `/`.
         *
         * If the file name has no directory components "." is returned.
         * The returned string should be freed when no longer needed.
         * @param file_name the name of the file
         * @returns the directory components of the file
         */
        function path_get_dirname(file_name: string): string;
        /**
         * Returns %TRUE if the given `file_name` is an absolute file name.
         * Note that this is a somewhat vague concept on Windows.
         *
         * On POSIX systems, an absolute file name is well-defined. It always
         * starts from the single root directory. For example "/usr/local".
         *
         * On Windows, the concepts of current drive and drive-specific
         * current directory introduce vagueness. This function interprets as
         * an absolute file name one that either begins with a directory
         * separator such as "\Users\tml" or begins with the root on a drive,
         * for example "C:\Windows". The first case also includes UNC paths
         * such as "\\\\myserver\docs\foo". In all cases, either slashes or
         * backslashes are accepted.
         *
         * Note that a file name relative to the current drive root does not
         * truly specify a file uniquely over time and across processes, as
         * the current drive is a per-process value and can be changed.
         *
         * File names relative the current directory on some specific drive,
         * such as "D:foo/bar", are not interpreted as absolute by this
         * function, but they obviously are not relative to the normal current
         * directory as returned by getcwd() or g_get_current_dir()
         * either. Such paths should be avoided, or need to be handled using
         * Windows-specific code.
         * @param file_name a file name
         * @returns %TRUE if @file_name is absolute
         */
        function path_is_absolute(file_name: string): boolean;
        /**
         * Returns a pointer into `file_name` after the root component,
         * i.e. after the "/" in UNIX or "C:\" under Windows. If `file_name`
         * is not an absolute path it returns %NULL.
         * @param file_name a file name
         * @returns a pointer into @file_name after the     root component
         */
        function path_skip_root(file_name: string): string | null;
        /**
         * Matches a string against a pattern given as a string.
         *
         * If this
         * function is to be called in a loop, it’s more efficient to compile
         * the pattern once with [ctor`GLib`.PatternSpec.new] and call
         * [method`GLib`.PatternSpec.match_string] repeatedly.
         * @param pattern the UTF-8 encoded pattern
         * @param string the UTF-8 encoded string to match
         * @returns %TRUE if @string matches @pspec
         */
        function pattern_match_simple(pattern: string, string: string): boolean;
        /**
         * This is equivalent to g_bit_lock, but working on pointers (or other
         * pointer-sized values).
         *
         * For portability reasons, you may only lock on the bottom 32 bits of
         * the pointer.
         *
         * While `address` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param address a pointer to a #gpointer-sized value
         * @param lock_bit a bit value between 0 and 31
         */
        function pointer_bit_lock(address: any, lock_bit: number): void;
        /**
         * This is equivalent to g_bit_lock, but working on pointers (or other
         * pointer-sized values).
         *
         * For portability reasons, you may only lock on the bottom 32 bits of
         * the pointer.
         * @param address a pointer to a #gpointer-sized value
         * @param lock_bit a bit value between 0 and 31
         */
        function pointer_bit_lock_and_get(address: any, lock_bit: number): never;
        /**
         * This mangles `ptr` as g_pointer_bit_lock() and g_pointer_bit_unlock()
         * do.
         * @param ptr the pointer to mask
         * @param lock_bit the bit to set/clear. If set to `G_MAXUINT`, the   lockbit is taken from @preserve_ptr or @ptr (depending on @preserve_mask).
         * @param set whether to set (lock) the bit or unset (unlock). This   has no effect, if @lock_bit is set to `G_MAXUINT`.
         * @param preserve_mask if non-zero, a bit-mask for @preserve_ptr. The   @preserve_mask bits from @preserve_ptr are set in the result.   Note that the @lock_bit bit will be always set according to @set,   regardless of @preserve_mask and @preserve_ptr (unless @lock_bit is   `G_MAXUINT`).
         * @param preserve_ptr if @preserve_mask is non-zero, the bits   from this pointer are set in the result.
         * @returns the mangled pointer.
         */
        function pointer_bit_lock_mask_ptr(
            ptr: any | null,
            lock_bit: number,
            set: boolean,
            preserve_mask: never,
            preserve_ptr?: any | null,
        ): any | null;
        /**
         * This is equivalent to g_bit_trylock(), but working on pointers (or
         * other pointer-sized values).
         *
         * For portability reasons, you may only lock on the bottom 32 bits of
         * the pointer.
         *
         * While `address` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param address a pointer to a #gpointer-sized value
         * @param lock_bit a bit value between 0 and 31
         * @returns %TRUE if the lock was acquired
         */
        function pointer_bit_trylock(address: any, lock_bit: number): boolean;
        /**
         * This is equivalent to g_bit_unlock, but working on pointers (or other
         * pointer-sized values).
         *
         * For portability reasons, you may only lock on the bottom 32 bits of
         * the pointer.
         *
         * While `address` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param address a pointer to a #gpointer-sized value
         * @param lock_bit a bit value between 0 and 31
         */
        function pointer_bit_unlock(address: any, lock_bit: number): void;
        /**
         * This is equivalent to g_pointer_bit_unlock() and atomically setting
         * the pointer value.
         *
         * Note that the lock bit will be cleared from the pointer. If the unlocked
         * pointer that was set is not identical to `ptr,` an assertion fails. In other
         * words, `ptr` must have `lock_bit` unset. This also means, you usually can
         * only use this on the lowest bits.
         * @param address a pointer to a #gpointer-sized value
         * @param lock_bit a bit value between 0 and 31
         * @param ptr the new pointer value to set
         * @param preserve_mask if non-zero, those bits of the current pointer in @address   are preserved.   Note that the @lock_bit bit will be always set according to @set,   regardless of @preserve_mask and the currently set value in @address.
         */
        function pointer_bit_unlock_and_set(
            address: any,
            lock_bit: number,
            ptr: any | null,
            preserve_mask: never,
        ): void;
        /**
         * Polls `fds,` as with the poll() system call, but portably. (On
         * systems that don't have poll(), it is emulated using select().)
         * This is used internally by #GMainContext, but it can be called
         * directly if you need to block until a file descriptor is ready, but
         * don't want to run the full main loop.
         *
         * Each element of `fds` is a #GPollFD describing a single file
         * descriptor to poll. The `fd` field indicates the file descriptor,
         * and the `events` field indicates the events to poll for. On return,
         * the `revents` fields will be filled with the events that actually
         * occurred.
         *
         * On POSIX systems, the file descriptors in `fds` can be any sort of
         * file descriptor, but the situation is much more complicated on
         * Windows. If you need to use g_poll() in code that has to run on
         * Windows, the easiest solution is to construct all of your
         * #GPollFDs with g_io_channel_win32_make_pollfd().
         * @param fds file descriptors to poll
         * @param nfds the number of file descriptors in @fds
         * @param timeout amount of time to wait, in milliseconds, or -1 to wait forever
         * @returns the number of entries in @fds whose @revents fields were filled in, or 0 if the operation timed out, or -1 on error or if the call was interrupted.
         */
        function poll(fds: PollFD, nfds: number, timeout: number): number;
        /**
         * Prefixes `prefix` to an existing error message. If `err` or `*err` is
         * %NULL (i.e.: no error variable) then do nothing.
         * @param err a return location for a #GError, or %NULL
         * @param prefix string to prefix @err with
         */
        function prefix_error_literal(err: (Error | null) | null, prefix: string): (Error | null) | null;
        /**
         * If `dest` is %NULL, free `src;` otherwise, moves `src` into `*dest`.
         * The error variable `dest` points to must be %NULL.
         *
         * `src` must be non-%NULL.
         *
         * Note that `src` is no longer valid after this call. If you want
         * to keep using the same GError*, you need to set it to %NULL
         * after calling this function on it.
         * @param src error to move into the return location
         */
        function propagate_error(src: Error): Error | null;
        /**
         * This is just like the standard C [`qsort()`](man:qsort(3)) function, but
         * the comparison routine accepts a user data argument
         * (like [`qsort_r()`](man:qsort_r(3))).
         *
         * Unlike `qsort()`, this is guaranteed to be a stable sort (since GLib 2.32).
         * @param pbase start of array to sort
         * @param total_elems elements in the array
         * @param size size of each element
         * @param compare_func function to compare elements
         */
        function qsort_with_data(pbase: any, total_elems: number, size: number, compare_func: CompareDataFunc): void;
        /**
         * Gets the #GQuark identifying the given (static) string. If the
         * string does not currently have an associated #GQuark, a new #GQuark
         * is created, linked to the given string.
         *
         * Note that this function is identical to g_quark_from_string() except
         * that if a new #GQuark is created the string itself is used rather
         * than a copy. This saves memory, but can only be used if the string
         * will continue to exist until the program terminates. It can be used
         * with statically allocated strings in the main program, but not with
         * statically allocated memory in dynamically loaded modules, if you
         * expect to ever unload the module again (e.g. do not use this
         * function in GTK theme engines).
         *
         * This function must not be used before library constructors have finished
         * running. In particular, this means it cannot be used to initialize global
         * variables in C++.
         * @param string a string
         * @returns the #GQuark identifying the string, or 0 if @string is %NULL
         */
        function quark_from_static_string(string?: string | null): Quark;
        /**
         * Gets the #GQuark identifying the given string. If the string does
         * not currently have an associated #GQuark, a new #GQuark is created,
         * using a copy of the string.
         *
         * This function must not be used before library constructors have finished
         * running. In particular, this means it cannot be used to initialize global
         * variables in C++.
         * @param string a string
         * @returns the #GQuark identifying the string, or 0 if @string is %NULL
         */
        function quark_from_string(string?: string | null): Quark;
        /**
         * Gets the string associated with the given #GQuark.
         * @param quark a #GQuark.
         * @returns the string associated with the #GQuark
         */
        function quark_to_string(quark: Quark): string;
        /**
         * Gets the #GQuark associated with the given string, or 0 if string is
         * %NULL or it has no associated #GQuark.
         *
         * If you want the GQuark to be created if it doesn't already exist,
         * use g_quark_from_string() or g_quark_from_static_string().
         *
         * This function must not be used before library constructors have finished
         * running.
         * @param string a string
         * @returns the #GQuark associated with the string, or 0 if @string is     %NULL or there is no #GQuark associated with it
         */
        function quark_try_string(string?: string | null): Quark;
        /**
         * Returns a random #gdouble equally distributed over the range [0..1).
         * @returns a random number
         */
        function random_double(): number;
        /**
         * Returns a random #gdouble equally distributed over the range
         * [`begin`..`end)`.
         * @param begin lower closed bound of the interval
         * @param end upper open bound of the interval
         * @returns a random number
         */
        function random_double_range(begin: number, end: number): number;
        /**
         * Return a random #guint32 equally distributed over the range
         * [0..2^32-1].
         * @returns a random number
         */
        function random_int(): number;
        /**
         * Returns a random #gint32 equally distributed over the range
         * [`begin`..`end-1`].
         * @param begin lower closed bound of the interval
         * @param end upper open bound of the interval
         * @returns a random number
         */
        function random_int_range(begin: number, end: number): number;
        /**
         * Sets the seed for the global random number generator, which is used
         * by the g_random_* functions, to `seed`.
         * @param seed a value to reinitialize the global random number generator
         */
        function random_set_seed(seed: number): void;
        /**
         * Acquires a reference on the data pointed by `mem_block`.
         * @param mem_block a pointer to reference counted data
         * @returns a pointer to the data,   with its reference count increased
         */
        function rc_box_acquire(mem_block: any): any;
        /**
         * Allocates `block_size` bytes of memory, and adds reference
         * counting semantics to it.
         *
         * The data will be freed when its reference count drops to
         * zero.
         *
         * The allocated data is guaranteed to be suitably aligned for any
         * built-in type.
         * @param block_size the size of the allocation, must be greater than 0
         * @returns a pointer to the allocated memory
         */
        function rc_box_alloc(block_size: number): any;
        /**
         * Allocates `block_size` bytes of memory, and adds reference
         * counting semantics to it.
         *
         * The contents of the returned data is set to zero.
         *
         * The data will be freed when its reference count drops to
         * zero.
         *
         * The allocated data is guaranteed to be suitably aligned for any
         * built-in type.
         * @param block_size the size of the allocation, must be greater than 0
         * @returns a pointer to the allocated memory
         */
        function rc_box_alloc0(block_size: number): any;
        /**
         * Allocates a new block of data with reference counting
         * semantics, and copies `block_size` bytes of `mem_block`
         * into it.
         * @param block_size the number of bytes to copy, must be greater than 0
         * @param mem_block the memory to copy
         * @returns a pointer to the allocated   memory
         */
        function rc_box_dup(block_size: number, mem_block: any): any;
        /**
         * Retrieves the size of the reference counted data pointed by `mem_block`.
         * @param mem_block a pointer to reference counted data
         * @returns the size of the data, in bytes
         */
        function rc_box_get_size(mem_block: any): number;
        /**
         * Releases a reference on the data pointed by `mem_block`.
         *
         * If the reference was the last one, it will free the
         * resources allocated for `mem_block`.
         * @param mem_block a pointer to reference counted data
         */
        function rc_box_release(mem_block: any): void;
        /**
         * Releases a reference on the data pointed by `mem_block`.
         *
         * If the reference was the last one, it will call `clear_func`
         * to clear the contents of `mem_block,` and then will free the
         * resources allocated for `mem_block`.
         * @param mem_block a pointer to reference counted data
         */
        function rc_box_release_full(mem_block: any): void;
        /**
         * Reallocates the memory pointed to by `mem,` so that it now has space for
         * `n_bytes` bytes of memory. It returns the new address of the memory, which may
         * have been moved. `mem` may be %NULL, in which case it's considered to
         * have zero-length. `n_bytes` may be 0, in which case %NULL will be returned
         * and `mem` will be freed unless it is %NULL.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         * @param mem the memory to reallocate
         * @param n_bytes new size of the memory in bytes
         * @returns the new address of the allocated memory
         */
        function realloc(mem: any | null, n_bytes: number): any | null;
        /**
         * This function is similar to g_realloc(), allocating (`n_blocks` * `n_block_bytes)` bytes,
         * but care is taken to detect possible overflow during multiplication.
         *
         * If the allocation fails (because the system is out of memory),
         * the program is terminated.
         * @param mem the memory to reallocate
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @returns the new address of the allocated memory
         */
        function realloc_n(mem: any | null, n_blocks: number, n_block_bytes: number): any | null;
        /**
         * Compares the current value of `rc` with `val`.
         * @param rc the address of a reference count variable
         * @param val the value to compare
         * @returns %TRUE if the reference count is the same   as the given value
         */
        function ref_count_compare(rc: number, val: number): boolean;
        /**
         * Decreases the reference count.
         *
         * If %TRUE is returned, the reference count reached 0. After this point, `rc`
         * is an undefined state and must be reinitialized with
         * g_ref_count_init() to be used again.
         * @param rc the address of a reference count variable
         * @returns %TRUE if the reference count reached 0, and %FALSE otherwise
         */
        function ref_count_dec(rc: number): boolean;
        /**
         * Increases the reference count.
         * @param rc the address of a reference count variable
         */
        function ref_count_inc(rc: number): void;
        /**
         * Initializes a reference count variable to 1.
         * @param rc the address of a reference count variable
         */
        function ref_count_init(rc: number): void;
        /**
         * Acquires a reference on a string.
         * @param str a reference counted string
         * @returns the given string, with its reference count increased
         */
        function ref_string_acquire(str: string): string;
        /**
         * Compares two ref-counted strings for byte-by-byte equality.
         *
         * It can be passed to [func`GLib`.HashTable.new] as the key equality function,
         * and behaves exactly the same as [func`GLib`.str_equal] (or `strcmp()`), but
         * can return slightly faster as it can check the string lengths before checking
         * all the bytes.
         * @param str1 a reference counted string
         * @param str2 a reference counted string
         * @returns `TRUE` if the strings are equal, otherwise `FALSE`
         */
        function ref_string_equal(str1: string, str2: string): boolean;
        /**
         * Retrieves the length of `str`.
         * @param str a reference counted string
         * @returns the length of the given string, in bytes
         */
        function ref_string_length(str: string): number;
        /**
         * Creates a new reference counted string and copies the contents of `str`
         * into it.
         * @param str a NUL-terminated string
         * @returns the newly created reference counted string
         */
        function ref_string_new(str: string): string;
        /**
         * Creates a new reference counted string and copies the content of `str`
         * into it.
         *
         * If you call this function multiple times with the same `str,` or with
         * the same contents of `str,` it will return a new reference, instead of
         * creating a new string.
         * @param str a NUL-terminated string
         * @returns the newly created reference   counted string, or a new reference to an existing string
         */
        function ref_string_new_intern(str: string): string;
        /**
         * Creates a new reference counted string and copies the contents of `str`
         * into it, up to `len` bytes.
         *
         * Since this function does not stop at nul bytes, it is the caller's
         * responsibility to ensure that `str` has at least `len` addressable bytes.
         * @param str a string
         * @param len length of @str to use, or -1 if @str is nul-terminated
         * @returns the newly created reference counted string
         */
        function ref_string_new_len(str: string, len: number): string;
        /**
         * Releases a reference on a string; if it was the last reference, the
         * resources allocated by the string are freed as well.
         * @param str a reference counted string
         */
        function ref_string_release(str: string): void;
        /**
         * Checks whether `replacement` is a valid replacement string
         * (see g_regex_replace()), i.e. that all escape sequences in
         * it are valid.
         *
         * If `has_references` is not %NULL then `replacement` is checked
         * for pattern references. For instance, replacement text 'foo\n'
         * does not contain references and may be evaluated without information
         * about actual match, but '\0\1' (whole match followed by first
         * subpattern) requires valid #GMatchInfo object.
         * @param replacement the replacement string
         * @returns whether @replacement is a valid replacement string
         */
        function regex_check_replacement(replacement: string): [boolean, boolean];
        function regex_error_quark(): Quark;
        /**
         * Escapes the nul characters in `string` to "\x00".  It can be used
         * to compile a regex with embedded nul characters.
         *
         * For completeness, `length` can be -1 for a nul-terminated string.
         * In this case the output string will be of course equal to `string`.
         * @param string the string to escape
         * @param length the length of @string
         * @returns a newly-allocated escaped string
         */
        function regex_escape_nul(string: string, length: number): string;
        /**
         * Escapes the special characters used for regular expressions
         * in `string,` for instance "a.b*c" becomes "a\.b\*c". This
         * function is useful to dynamically generate regular expressions.
         *
         * `string` can contain nul characters that are replaced with "\0",
         * in this case remember to specify the correct length of `string`
         * in `length`.
         * @param string the string to escape
         * @param length the length of @string, in bytes, or -1 if @string is nul-terminated
         * @returns a newly-allocated escaped string
         */
        function regex_escape_string(string: string, length: number): string;
        /**
         * Scans for a match in `string` for `pattern`.
         *
         * This function is equivalent to g_regex_match() but it does not
         * require to compile the pattern with g_regex_new(), avoiding some
         * lines of code when you need just to do a match without extracting
         * substrings, capture counts, and so on.
         *
         * If this function is to be called on the same `pattern` more than
         * once, it's more efficient to compile the pattern once with
         * g_regex_new() and then use g_regex_match().
         * @param pattern the regular expression
         * @param string the string to scan for matches
         * @param compile_options compile options for the regular expression, or 0
         * @param match_options match options, or 0
         * @returns %TRUE if the string matched, %FALSE otherwise
         */
        function regex_match_simple(
            pattern: string,
            string: string,
            compile_options: RegexCompileFlags | null,
            match_options: RegexMatchFlags | null,
        ): boolean;
        /**
         * Breaks the string on the pattern, and returns an array of
         * the tokens. If the pattern contains capturing parentheses,
         * then the text for each of the substrings will also be returned.
         * If the pattern does not match anywhere in the string, then the
         * whole string is returned as the first token.
         *
         * This function is equivalent to g_regex_split() but it does
         * not require to compile the pattern with g_regex_new(), avoiding
         * some lines of code when you need just to do a split without
         * extracting substrings, capture counts, and so on.
         *
         * If this function is to be called on the same `pattern` more than
         * once, it's more efficient to compile the pattern once with
         * g_regex_new() and then use g_regex_split().
         *
         * As a special case, the result of splitting the empty string ""
         * is an empty vector, not a vector containing a single string.
         * The reason for this special case is that being able to represent
         * an empty vector is typically more useful than consistent handling
         * of empty elements. If you do need to represent empty elements,
         * you'll need to check for the empty string before calling this
         * function.
         *
         * A pattern that can match empty strings splits `string` into
         * separate characters wherever it matches the empty string between
         * characters. For example splitting "ab c" using as a separator
         * "\s*", you will get "a", "b" and "c".
         * @param pattern the regular expression
         * @param string the string to scan for matches
         * @param compile_options compile options for the regular expression, or 0
         * @param match_options match options, or 0
         * @returns a %NULL-terminated array of strings. Free it using g_strfreev()
         */
        function regex_split_simple(
            pattern: string,
            string: string,
            compile_options: RegexCompileFlags | null,
            match_options: RegexMatchFlags | null,
        ): string[];
        /**
         * Resets the cache used for g_get_user_special_dir(), so
         * that the latest on-disk version is used. Call this only
         * if you just changed the data on disk yourself.
         *
         * Due to thread safety issues this may cause leaking of strings
         * that were previously returned from g_get_user_special_dir()
         * that can't be freed. We ensure to only leak the data for
         * the directories that actually changed value though.
         */
        function reload_user_special_dirs_cache(): void;
        /**
         * A wrapper for the POSIX remove() function. The remove() function
         * deletes a name from the filesystem.
         *
         * See your C library manual for more details about how remove() works
         * on your system. On Unix, remove() removes also directories, as it
         * calls unlink() for files and rmdir() for directories. On Windows,
         * although remove() in the C library only works for files, this
         * function tries first remove() and then if that fails rmdir(), and
         * thus works for both files and directories. Note however, that on
         * Windows, it is in general not possible to remove a file that is
         * open to some process, or mapped into memory.
         *
         * If this function fails on Windows you can't infer too much from the
         * errno value. rmdir() is tried regardless of what caused remove() to
         * fail. Any errno value set by remove() will be overwritten by that
         * set by rmdir().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @returns 0 if the file was successfully removed, -1 if an error    occurred
         */
        function remove(filename: string): number;
        /**
         * A wrapper for the POSIX rename() function. The rename() function
         * renames a file, moving it between directories if required.
         *
         * See your C library manual for more details about how rename() works
         * on your system. It is not possible in general on Windows to rename
         * a file that is open to some process.
         * @param oldfilename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param newfilename a pathname in the GLib file name encoding
         * @returns 0 if the renaming succeeded, -1 if an error occurred
         */
        function rename(oldfilename: string, newfilename: string): number;
        /**
         * A wrapper for the POSIX rmdir() function. The rmdir() function
         * deletes a directory from the filesystem.
         *
         * See your C library manual for more details about how rmdir() works
         * on your system.
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @returns 0 if the directory was successfully removed, -1 if an error    occurred
         */
        function rmdir(filename: string): number;
        /**
         * Calls `func` for each item in the range (`begin,` `end)` passing
         * `user_data` to the function. `func` must not modify the sequence
         * itself.
         * @param begin a #GSequenceIter
         * @param end a #GSequenceIter
         * @param func a #GFunc
         */
        function sequence_foreach_range(begin: SequenceIter, end: SequenceIter, func: Func): void;
        /**
         * Returns the data that `iter` points to.
         * @param iter a #GSequenceIter
         * @returns the data that @iter points to
         */
        function sequence_get(iter: SequenceIter): any | null;
        /**
         * Inserts a new item just before the item pointed to by `iter`.
         * @param iter a #GSequenceIter
         * @param data the data for the new item
         * @returns an iterator pointing to the new item
         */
        function sequence_insert_before(iter: SequenceIter, data?: any | null): SequenceIter;
        /**
         * Moves the item pointed to by `src` to the position indicated by `dest`.
         * After calling this function `dest` will point to the position immediately
         * after `src`. It is allowed for `src` and `dest` to point into different
         * sequences.
         * @param src a #GSequenceIter pointing to the item to move
         * @param dest a #GSequenceIter pointing to the position to which     the item is moved
         */
        function sequence_move(src: SequenceIter, dest: SequenceIter): void;
        /**
         * Inserts the (`begin,` `end)` range at the destination pointed to by `dest`.
         * The `begin` and `end` iters must point into the same sequence. It is
         * allowed for `dest` to point to a different sequence than the one pointed
         * into by `begin` and `end`.
         *
         * If `dest` is %NULL, the range indicated by `begin` and `end` is
         * removed from the sequence. If `dest` points to a place within
         * the (`begin,` `end)` range, the range does not move.
         * @param dest a #GSequenceIter
         * @param begin a #GSequenceIter
         * @param end a #GSequenceIter
         */
        function sequence_move_range(dest: SequenceIter, begin: SequenceIter, end: SequenceIter): void;
        /**
         * Finds an iterator somewhere in the range (`begin,` `end)`. This
         * iterator will be close to the middle of the range, but is not
         * guaranteed to be exactly in the middle.
         *
         * The `begin` and `end` iterators must both point to the same sequence
         * and `begin` must come before or be equal to `end` in the sequence.
         * @param begin a #GSequenceIter
         * @param end a #GSequenceIter
         * @returns a #GSequenceIter pointing somewhere in the    (@begin, @end) range
         */
        function sequence_range_get_midpoint(begin: SequenceIter, end: SequenceIter): SequenceIter;
        /**
         * Removes the item pointed to by `iter`. It is an error to pass the
         * end iterator to this function.
         *
         * If the sequence has a data destroy function associated with it, this
         * function is called on the data for the removed item.
         * @param iter a #GSequenceIter
         */
        function sequence_remove(iter: SequenceIter): void;
        /**
         * Removes all items in the (`begin,` `end)` range.
         *
         * If the sequence has a data destroy function associated with it, this
         * function is called on the data for the removed items.
         * @param begin a #GSequenceIter
         * @param end a #GSequenceIter
         */
        function sequence_remove_range(begin: SequenceIter, end: SequenceIter): void;
        /**
         * Changes the data for the item pointed to by `iter` to be `data`. If
         * the sequence has a data destroy function associated with it, that
         * function is called on the existing data that `iter` pointed to.
         * @param iter a #GSequenceIter
         * @param data new data for the item
         */
        function sequence_set(iter: SequenceIter, data?: any | null): void;
        /**
         * Moves the data pointed to by `iter` to a new position as indicated by
         * `cmp_func`. This
         * function should be called for items in a sequence already sorted according
         * to `cmp_func` whenever some aspect of an item changes so that `cmp_func`
         * may return different values for that item.
         *
         * `cmp_func` is called with two items of the `seq,` and `cmp_data`.
         * It should return 0 if the items are equal, a negative value if
         * the first item comes before the second, and a positive value if
         * the second item comes before the first.
         * @param iter A #GSequenceIter
         * @param cmp_func the function used to compare items in the sequence
         */
        function sequence_sort_changed(iter: SequenceIter, cmp_func: CompareDataFunc): void;
        /**
         * Like g_sequence_sort_changed(), but uses
         * a #GSequenceIterCompareFunc instead of a #GCompareDataFunc as
         * the compare function.
         *
         * `iter_cmp` is called with two iterators pointing into the #GSequence that
         * `iter` points into. It should
         * return 0 if the iterators are equal, a negative value if the first
         * iterator comes before the second, and a positive value if the second
         * iterator comes before the first.
         * @param iter a #GSequenceIter
         * @param iter_cmp the function used to compare iterators in the sequence
         */
        function sequence_sort_changed_iter(iter: SequenceIter, iter_cmp: SequenceIterCompareFunc): void;
        /**
         * Swaps the items pointed to by `a` and `b`. It is allowed for `a` and `b`
         * to point into difference sequences.
         * @param a a #GSequenceIter
         * @param b a #GSequenceIter
         */
        function sequence_swap(a: SequenceIter, b: SequenceIter): void;
        /**
         * Sets a human-readable name for the application. This name should be
         * localized if possible, and is intended for display to the user.
         * Contrast with g_set_prgname(), which sets a non-localized name.
         * g_set_prgname() will be called automatically by gtk_init(),
         * but g_set_application_name() will not.
         *
         * Note that for thread safety reasons, this function can only
         * be called once.
         *
         * The application name will be used in contexts such as error messages,
         * or when displaying an application's name in the task list.
         * @param application_name localized name of the application
         */
        function set_application_name(application_name: string): void;
        /**
         * Does nothing if `err` is %NULL; if `err` is non-%NULL, then `*err`
         * must be %NULL. A new #GError is created and assigned to `*err`.
         * Unlike g_set_error(), `message` is not a printf()-style format string.
         * Use this function if `message` contains text you don't have control over,
         * that could include printf() escape sequences.
         * @param domain error domain
         * @param code error code
         * @param message error message
         */
        function set_error_literal(domain: Quark, code: number, message: string): Error | null;
        /**
         * Sets the name of the program. This name should not be localized,
         * in contrast to g_set_application_name().
         *
         * If you are using #GApplication the program name is set in
         * g_application_run(). In case of GDK or GTK it is set in
         * gdk_init(), which is called by gtk_init() and the
         * #GtkApplication::startup handler. The program name is found by
         * taking the last component of `argv[`0].
         *
         * Since GLib 2.72, this function can be called multiple times
         * and is fully thread safe. Prior to GLib 2.72, this function
         * could only be called once per process.
         * @param prgname the name of the program.
         */
        function set_prgname(prgname: string): void;
        /**
         * Sets an environment variable. On UNIX, both the variable's name and
         * value can be arbitrary byte strings, except that the variable's name
         * cannot contain '='. On Windows, they should be in UTF-8.
         *
         * Note that on some systems, when variables are overwritten, the memory
         * used for the previous variables and its value isn't reclaimed.
         *
         * You should be mindful of the fact that environment variable handling
         * in UNIX is not thread-safe, and your program may crash if one thread
         * calls g_setenv() while another thread is calling getenv(). (And note
         * that many functions, such as gettext(), call getenv() internally.)
         * This function is only safe to use at the very start of your program,
         * before creating any other threads (or creating objects that create
         * worker threads of their own).
         *
         * If you need to set up the environment for a child process, you can
         * use g_get_environ() to get an environment array, modify that with
         * g_environ_setenv() and g_environ_unsetenv(), and then pass that
         * array directly to execvpe(), g_spawn_async(), or the like.
         * @param variable the environment variable to set, must not     contain '='.
         * @param value the value for to set the variable to.
         * @param overwrite whether to change the variable if it already exists.
         * @returns %FALSE if the environment variable couldn't be set.
         */
        function setenv(variable: string, value: string, overwrite: boolean): boolean;
        function shell_error_quark(): Quark;
        /**
         * Parses a command line into an argument vector, in much the same way
         * the shell would, but without many of the expansions the shell would
         * perform (variable expansion, globs, operators, filename expansion,
         * etc. are not supported).
         *
         * The results are defined to be the same as those you would get from
         * a UNIX98 `/bin/sh`, as long as the input contains none of the
         * unsupported shell expansions. If the input does contain such expansions,
         * they are passed through literally.
         *
         * Possible errors are those from the %G_SHELL_ERROR domain.
         *
         * In particular, if `command_line` is an empty string (or a string containing
         * only whitespace), %G_SHELL_ERROR_EMPTY_STRING will be returned. It’s
         * guaranteed that `argvp` will be a non-empty array if this function returns
         * successfully.
         *
         * Free the returned vector with g_strfreev().
         * @param command_line command line to parse
         * @returns %TRUE on success, %FALSE if error set
         */
        function shell_parse_argv(command_line: string): [boolean, string[] | null];
        /**
         * Quotes a string so that the shell (/bin/sh) will interpret the
         * quoted string to mean `unquoted_string`.
         *
         * If you pass a filename to the shell, for example, you should first
         * quote it with this function.
         *
         * The return value must be freed with g_free().
         *
         * The quoting style used is undefined (single or double quotes may be
         * used).
         * @param unquoted_string a literal string
         * @returns quoted string
         */
        function shell_quote(unquoted_string: string): string;
        /**
         * Unquotes a string as the shell (/bin/sh) would.
         *
         * This function only handles quotes; if a string contains file globs,
         * arithmetic operators, variables, backticks, redirections, or other
         * special-to-the-shell features, the result will be different from the
         * result a real shell would produce (the variables, backticks, etc.
         * will be passed through literally instead of being expanded).
         *
         * This function is guaranteed to succeed if applied to the result of
         * g_shell_quote(). If it fails, it returns %NULL and sets the
         * error.
         *
         * The `quoted_string` need not actually contain quoted or escaped text;
         * g_shell_unquote() simply goes through the string and unquotes/unescapes
         * anything that the shell would. Both single and double quotes are
         * handled, as are escapes including escaped newlines.
         *
         * The return value must be freed with g_free().
         *
         * Possible errors are in the %G_SHELL_ERROR domain.
         *
         * Shell quoting rules are a bit strange. Single quotes preserve the
         * literal string exactly. escape sequences are not allowed; not even
         * `\'` - if you want a `'` in the quoted text, you have to do something
         * like `'foo'\''bar'`. Double quotes allow `$`, ```, `"`, `\`, and
         * newline to be escaped with backslash. Otherwise double quotes
         * preserve things literally.
         * @param quoted_string shell-quoted string
         * @returns an unquoted string
         */
        function shell_unquote(quoted_string: string): string;
        /**
         * Allocates a block of memory from the libc allocator.
         *
         * The block address handed out can be expected to be aligned
         * to at least `1 * sizeof (void*)`.
         *
         * Since GLib 2.76 this always uses the system malloc() implementation
         * internally.
         * @param block_size the number of bytes to allocate
         * @returns a pointer to the allocated memory block, which will   be %NULL if and only if @mem_size is 0
         */
        function slice_alloc(block_size: number): any | null;
        /**
         * Allocates a block of memory via g_slice_alloc() and initializes
         * the returned memory to 0.
         *
         * Since GLib 2.76 this always uses the system malloc() implementation
         * internally.
         * @param block_size the number of bytes to allocate
         * @returns a pointer to the allocated block, which will be %NULL    if and only if @mem_size is 0
         */
        function slice_alloc0(block_size: number): any | null;
        /**
         * Allocates a block of memory from the slice allocator
         * and copies `block_size` bytes into it from `mem_block`.
         *
         * `mem_block` must be non-%NULL if `block_size` is non-zero.
         *
         * Since GLib 2.76 this always uses the system malloc() implementation
         * internally.
         * @param block_size the number of bytes to allocate
         * @param mem_block the memory to copy
         * @returns a pointer to the allocated memory block,    which will be %NULL if and only if @mem_size is 0
         */
        function slice_copy(block_size: number, mem_block?: any | null): any | null;
        /**
         * Frees a block of memory.
         *
         * The memory must have been allocated via g_slice_alloc() or
         * g_slice_alloc0() and the `block_size` has to match the size
         * specified upon allocation. Note that the exact release behaviour
         * can be changed with the [`G_DEBUG=gc-friendly`](running.html#environment-variables) environment
         * variable.
         *
         * If `mem_block` is %NULL, this function does nothing.
         *
         * Since GLib 2.76 this always uses the system free_sized() implementation
         * internally.
         * @param block_size the size of the block
         * @param mem_block a pointer to the block to free
         */
        function slice_free1(block_size: number, mem_block?: any | null): void;
        /**
         * Frees a linked list of memory blocks of structure type `type`.
         *
         * The memory blocks must be equal-sized, allocated via
         * g_slice_alloc() or g_slice_alloc0() and linked together by a
         * `next` pointer (similar to #GSList). The offset of the `next`
         * field in each block is passed as third argument.
         * Note that the exact release behaviour can be changed with the
         * [`G_DEBUG=gc-friendly`](running.html#environment-variables) environment variable.
         *
         * If `mem_chain` is %NULL, this function does nothing.
         *
         * Since GLib 2.76 this always uses the system free_sized() implementation
         * internally.
         * @param block_size the size of the blocks
         * @param mem_chain a pointer to the first block of the chain
         * @param next_offset the offset of the @next field in the blocks
         */
        function slice_free_chain_with_offset(block_size: number, mem_chain: any | null, next_offset: number): void;
        function slice_get_config(ckey: SliceConfig | null): number;
        function slice_get_config_state(ckey: SliceConfig | null, address: number, n_values: number): number;
        function slice_set_config(ckey: SliceConfig | null, value: number): void;
        function slist_pop_allocator(): void;
        function slist_push_allocator(allocator: Allocator): void;
        /**
         * Removes the source with the given ID from the default main context. You must
         * use [method`GLib`.Source.destroy] for sources added to a non-default main context.
         *
         * The ID of a #GSource is given by [method`GLib`.Source.get_id], or will be
         * returned by the functions [method`GLib`.Source.attach], [func`GLib`.idle_add],
         * [func`GLib`.idle_add_full], [func`GLib`.timeout_add],
         * [func`GLib`.timeout_add_full], [func`GLib`.child_watch_add],
         * [func`GLib`.child_watch_add_full], [func`GLib`.io_add_watch], and
         * [func`GLib`.io_add_watch_full].
         *
         * It is a programmer error to attempt to remove a non-existent source.
         *
         * More specifically: source IDs can be reissued after a source has been
         * destroyed and therefore it is never valid to use this function with a
         * source ID which may have already been removed.  An example is when
         * scheduling an idle to run in another thread with [func`GLib`.idle_add]: the
         * idle may already have run and been removed by the time this function
         * is called on its (now invalid) source ID.  This source ID may have
         * been reissued, leading to the operation being performed against the
         * wrong source.
         * @param tag the ID of the source to remove.
         * @returns %TRUE if the source was found and removed.
         */
        function source_remove(tag: number): boolean;
        /**
         * Removes a source from the default main loop context given the
         * source functions and user data. If multiple sources exist with the
         * same source functions and user data, only one will be destroyed.
         * @param funcs The @source_funcs passed to [ctor@GLib.Source.new]
         * @param user_data the user data for the callback
         * @returns %TRUE if a source was found and removed.
         */
        function source_remove_by_funcs_user_data(funcs: SourceFuncs, user_data?: any | null): boolean;
        /**
         * Removes a source from the default main loop context given the user
         * data for the callback. If multiple sources exist with the same user
         * data, only one will be destroyed.
         * @param user_data the user_data for the callback.
         * @returns %TRUE if a source was found and removed.
         */
        function source_remove_by_user_data(user_data?: any | null): boolean;
        /**
         * Sets the name of a source using its ID.
         *
         * This is a convenience utility to set source names from the return
         * value of [func`GLib`.idle_add], [func`GLib`.timeout_add], etc.
         *
         * It is a programmer error to attempt to set the name of a non-existent
         * source.
         *
         * More specifically: source IDs can be reissued after a source has been
         * destroyed and therefore it is never valid to use this function with a
         * source ID which may have already been removed.  An example is when
         * scheduling an idle to run in another thread with [func`GLib`.idle_add]: the
         * idle may already have run and been removed by the time this function
         * is called on its (now invalid) source ID.  This source ID may have
         * been reissued, leading to the operation being performed against the
         * wrong source.
         * @param tag a #GSource ID
         * @param name debug name for the source
         */
        function source_set_name_by_id(tag: number, name: string): void;
        /**
         * Gets the smallest prime number from a built-in array of primes which
         * is larger than `num`. This is used within GLib to calculate the optimum
         * size of a #GHashTable.
         *
         * The built-in array of primes ranges from 11 to 13845163 such that
         * each prime is approximately 1.5-2 times the previous prime.
         * @param num a #guint
         * @returns the smallest prime number from a built-in array of primes     which is larger than @num
         */
        function spaced_primes_closest(num: number): number;
        /**
         * Executes a child program asynchronously.
         *
         * See g_spawn_async_with_pipes() for a full description; this function
         * simply calls the g_spawn_async_with_pipes() without any pipes.
         *
         * You should call g_spawn_close_pid() on the returned child process
         * reference when you don't need it any more.
         *
         * If you are writing a GTK application, and the program you are spawning is a
         * graphical application too, then to ensure that the spawned program opens its
         * windows on the right screen, you may want to use #GdkAppLaunchContext,
         * #GAppLaunchContext, or set the %DISPLAY environment variable.
         *
         * Note that the returned `child_pid` on Windows is a handle to the child
         * process and not its identifier. Process handles and process identifiers
         * are different concepts on Windows.
         * @param working_directory child's current working     directory, or %NULL to inherit parent's
         * @param argv child's argument vector
         * @param envp child's environment, or %NULL to inherit parent's
         * @param flags flags from #GSpawnFlags
         * @param child_setup function to run     in the child just before `exec()`
         * @returns %TRUE on success, %FALSE if error is set
         */
        function spawn_async(
            working_directory: string | null,
            argv: string[],
            envp: string[] | null,
            flags: SpawnFlags | null,
            child_setup?: SpawnChildSetupFunc | null,
        ): [boolean, Pid | null];
        /**
         * Executes a child program asynchronously.
         *
         * Identical to g_spawn_async_with_pipes_and_fds() but with `n_fds` set to zero,
         * so no FD assignments are used.
         * @param working_directory child's current working directory, or %NULL to inherit parent's, in the GLib file name encoding
         * @param argv child's argument vector, in the GLib file name encoding;   it must be non-empty and %NULL-terminated
         * @param envp child's environment, or %NULL to inherit parent's, in the GLib file name encoding
         * @param flags flags from #GSpawnFlags
         * @param child_setup function to run   in the child just before `exec()`
         * @param stdin_fd file descriptor to use for child's stdin, or `-1`
         * @param stdout_fd file descriptor to use for child's stdout, or `-1`
         * @param stderr_fd file descriptor to use for child's stderr, or `-1`
         * @returns %TRUE on success, %FALSE if an error was set
         */
        function spawn_async_with_fds(
            working_directory: string | null,
            argv: string[],
            envp: string[] | null,
            flags: SpawnFlags | null,
            child_setup: SpawnChildSetupFunc | null,
            stdin_fd: number,
            stdout_fd: number,
            stderr_fd: number,
        ): [boolean, Pid | null];
        /**
         * Identical to g_spawn_async_with_pipes_and_fds() but with `n_fds` set to zero,
         * so no FD assignments are used.
         * @param working_directory child's current working     directory, or %NULL to inherit parent's, in the GLib file name encoding
         * @param argv child's argument     vector, in the GLib file name encoding; it must be non-empty and %NULL-terminated
         * @param envp child's environment, or %NULL to inherit parent's, in the GLib file     name encoding
         * @param flags flags from #GSpawnFlags
         * @param child_setup function to run     in the child just before `exec()`
         * @returns %TRUE on success, %FALSE if an error was set
         */
        function spawn_async_with_pipes(
            working_directory: string | null,
            argv: string[],
            envp: string[] | null,
            flags: SpawnFlags | null,
            child_setup: SpawnChildSetupFunc | null,
        ): [boolean, Pid | null, number, number, number];
        /**
         * Executes a child program asynchronously (your program will not
         * block waiting for the child to exit).
         *
         * The child program is specified by the only argument that must be
         * provided, `argv`. `argv` should be a %NULL-terminated array of strings,
         * to be passed as the argument vector for the child. The first string
         * in `argv` is of course the name of the program to execute. By default,
         * the name of the program must be a full path. If `flags` contains the
         * %G_SPAWN_SEARCH_PATH flag, the `PATH` environment variable is used to
         * search for the executable. If `flags` contains the
         * %G_SPAWN_SEARCH_PATH_FROM_ENVP flag, the `PATH` variable from `envp`
         * is used to search for the executable. If both the
         * %G_SPAWN_SEARCH_PATH and %G_SPAWN_SEARCH_PATH_FROM_ENVP flags are
         * set, the `PATH` variable from `envp` takes precedence over the
         * environment variable.
         *
         * If the program name is not a full path and %G_SPAWN_SEARCH_PATH flag
         * is not used, then the program will be run from the current directory
         * (or `working_directory,` if specified); this might be unexpected or even
         * dangerous in some cases when the current directory is world-writable.
         *
         * On Windows, note that all the string or string vector arguments to
         * this function and the other `g_spawn*()` functions are in UTF-8, the
         * GLib file name encoding. Unicode characters that are not part of
         * the system codepage passed in these arguments will be correctly
         * available in the spawned program only if it uses wide character API
         * to retrieve its command line. For C programs built with Microsoft's
         * tools it is enough to make the program have a `wmain()` instead of
         * `main()`. `wmain()` has a wide character argument vector as parameter.
         *
         * At least currently, mingw doesn't support `wmain()`, so if you use
         * mingw to develop the spawned program, it should call
         * g_win32_get_command_line() to get arguments in UTF-8.
         *
         * On Windows the low-level child process creation API `CreateProcess()`
         * doesn't use argument vectors, but a command line. The C runtime
         * library's `spawn*()` family of functions (which g_spawn_async_with_pipes()
         * eventually calls) paste the argument vector elements together into
         * a command line, and the C runtime startup code does a corresponding
         * reconstruction of an argument vector from the command line, to be
         * passed to `main()`. Complications arise when you have argument vector
         * elements that contain spaces or double quotes. The `spawn*()` functions
         * don't do any quoting or escaping, but on the other hand the startup
         * code does do unquoting and unescaping in order to enable receiving
         * arguments with embedded spaces or double quotes. To work around this
         * asymmetry, g_spawn_async_with_pipes() will do quoting and escaping on
         * argument vector elements that need it before calling the C runtime
         * `spawn()` function.
         *
         * The returned `child_pid` on Windows is a handle to the child
         * process, not its identifier. Process handles and process
         * identifiers are different concepts on Windows.
         *
         * `envp` is a %NULL-terminated array of strings, where each string
         * has the form `KEY=VALUE`. This will become the child's environment.
         * If `envp` is %NULL, the child inherits its parent's environment.
         *
         * `flags` should be the bitwise OR of any flags you want to affect the
         * function's behaviour. The %G_SPAWN_DO_NOT_REAP_CHILD means that the
         * child will not automatically be reaped; you must use a child watch
         * (g_child_watch_add()) to be notified about the death of the child process,
         * otherwise it will stay around as a zombie process until this process exits.
         * Eventually you must call g_spawn_close_pid() on the `child_pid,` in order to
         * free resources which may be associated with the child process. (On Unix,
         * using a child watch is equivalent to calling waitpid() or handling
         * the `SIGCHLD` signal manually. On Windows, calling g_spawn_close_pid()
         * is equivalent to calling `CloseHandle()` on the process handle returned
         * in `child_pid)`. See g_child_watch_add().
         *
         * Open UNIX file descriptors marked as `FD_CLOEXEC` will be automatically
         * closed in the child process. %G_SPAWN_LEAVE_DESCRIPTORS_OPEN means that
         * other open file descriptors will be inherited by the child; otherwise all
         * descriptors except stdin/stdout/stderr will be closed before calling `exec()`
         * in the child. %G_SPAWN_SEARCH_PATH means that `argv[`0] need not be an
         * absolute path, it will be looked for in the `PATH` environment
         * variable. %G_SPAWN_SEARCH_PATH_FROM_ENVP means need not be an
         * absolute path, it will be looked for in the `PATH` variable from
         * `envp`. If both %G_SPAWN_SEARCH_PATH and %G_SPAWN_SEARCH_PATH_FROM_ENVP
         * are used, the value from `envp` takes precedence over the environment.
         *
         * %G_SPAWN_CHILD_INHERITS_STDIN means that the child will inherit the parent's
         * standard input (by default, the child's standard input is attached to
         * `/dev/null`). %G_SPAWN_STDIN_FROM_DEV_NULL explicitly imposes the default
         * behavior. Both flags cannot be enabled at the same time and, in both cases,
         * the `stdin_pipe_out` argument is ignored.
         *
         * %G_SPAWN_STDOUT_TO_DEV_NULL means that the child's standard output
         * will be discarded (by default, it goes to the same location as the parent's
         * standard output). %G_SPAWN_CHILD_INHERITS_STDOUT explicitly imposes the
         * default behavior. Both flags cannot be enabled at the same time and, in
         * both cases, the `stdout_pipe_out` argument is ignored.
         *
         * %G_SPAWN_STDERR_TO_DEV_NULL means that the child's standard error
         * will be discarded (by default, it goes to the same location as the parent's
         * standard error). %G_SPAWN_CHILD_INHERITS_STDERR explicitly imposes the
         * default behavior. Both flags cannot be enabled at the same time and, in
         * both cases, the `stderr_pipe_out` argument is ignored.
         *
         * It is valid to pass the same FD in multiple parameters (e.g. you can pass
         * a single FD for both `stdout_fd` and `stderr_fd,` and include it in
         * `source_fds` too).
         *
         * `source_fds` and `target_fds` allow zero or more FDs from this process to be
         * remapped to different FDs in the spawned process. If `n_fds` is greater than
         * zero, `source_fds` and `target_fds` must both be non-%NULL and the same length.
         * Each FD in `source_fds` is remapped to the FD number at the same index in
         * `target_fds`. The source and target FD may be equal to simply propagate an FD
         * to the spawned process. FD remappings are processed after standard FDs, so
         * any target FDs which equal `stdin_fd,` `stdout_fd` or `stderr_fd` will overwrite
         * them in the spawned process.
         *
         * `source_fds` is supported on Windows since 2.72.
         *
         * %G_SPAWN_FILE_AND_ARGV_ZERO means that the first element of `argv` is
         * the file to execute, while the remaining elements are the actual
         * argument vector to pass to the file. Normally g_spawn_async_with_pipes()
         * uses `argv[`0] as the file to execute, and passes all of `argv` to the child.
         *
         * `child_setup` and `user_data` are a function and user data. On POSIX
         * platforms, the function is called in the child after GLib has
         * performed all the setup it plans to perform (including creating
         * pipes, closing file descriptors, etc.) but before calling `exec()`.
         * That is, `child_setup` is called just before calling `exec()` in the
         * child. Obviously actions taken in this function will only affect
         * the child, not the parent.
         *
         * On Windows, there is no separate `fork()` and `exec()` functionality.
         * Child processes are created and run with a single API call,
         * `CreateProcess()`. There is no sensible thing `child_setup`
         * could be used for on Windows so it is ignored and not called.
         *
         * If non-%NULL, `child_pid` will on Unix be filled with the child's
         * process ID. You can use the process ID to send signals to the child,
         * or to use g_child_watch_add() (or `waitpid()`) if you specified the
         * %G_SPAWN_DO_NOT_REAP_CHILD flag. On Windows, `child_pid` will be
         * filled with a handle to the child process only if you specified the
         * %G_SPAWN_DO_NOT_REAP_CHILD flag. You can then access the child
         * process using the Win32 API, for example wait for its termination
         * with the `WaitFor*()` functions, or examine its exit code with
         * `GetExitCodeProcess()`. You should close the handle with `CloseHandle()`
         * or g_spawn_close_pid() when you no longer need it.
         *
         * If non-%NULL, the `stdin_pipe_out,` `stdout_pipe_out,` `stderr_pipe_out`
         * locations will be filled with file descriptors for writing to the child's
         * standard input or reading from its standard output or standard error.
         * The caller of g_spawn_async_with_pipes() must close these file descriptors
         * when they are no longer in use. If these parameters are %NULL, the
         * corresponding pipe won't be created.
         *
         * If `stdin_pipe_out` is %NULL, the child's standard input is attached to
         * `/dev/null` unless %G_SPAWN_CHILD_INHERITS_STDIN is set.
         *
         * If `stderr_pipe_out` is NULL, the child's standard error goes to the same
         * location as the parent's standard error unless %G_SPAWN_STDERR_TO_DEV_NULL
         * is set.
         *
         * If `stdout_pipe_out` is NULL, the child's standard output goes to the same
         * location as the parent's standard output unless %G_SPAWN_STDOUT_TO_DEV_NULL
         * is set.
         *
         * `error` can be %NULL to ignore errors, or non-%NULL to report errors.
         * If an error is set, the function returns %FALSE. Errors are reported
         * even if they occur in the child (for example if the executable in
         * ``argv[`0]` is not found). Typically the `message` field of returned
         * errors should be displayed to users. Possible errors are those from
         * the %G_SPAWN_ERROR domain.
         *
         * If an error occurs, `child_pid,` `stdin_pipe_out,` `stdout_pipe_out,`
         * and `stderr_pipe_out` will not be filled with valid values.
         *
         * If `child_pid` is not %NULL and an error does not occur then the returned
         * process reference must be closed using g_spawn_close_pid().
         *
         * On modern UNIX platforms, GLib can use an efficient process launching
         * codepath driven internally by `posix_spawn()`. This has the advantage of
         * avoiding the fork-time performance costs of cloning the parent process
         * address space, and avoiding associated memory overcommit checks that are
         * not relevant in the context of immediately executing a distinct process.
         * This optimized codepath will be used provided that the following conditions
         * are met:
         *
         * 1. %G_SPAWN_DO_NOT_REAP_CHILD is set
         * 2. %G_SPAWN_LEAVE_DESCRIPTORS_OPEN is set
         * 3. %G_SPAWN_SEARCH_PATH_FROM_ENVP is not set
         * 4. `working_directory` is %NULL
         * 5. `child_setup` is %NULL
         * 6. The program is of a recognised binary format, or has a shebang.
         *    Otherwise, GLib will have to execute the program through the
         *    shell, which is not done using the optimized codepath.
         *
         * If you are writing a GTK application, and the program you are spawning is a
         * graphical application too, then to ensure that the spawned program opens its
         * windows on the right screen, you may want to use #GdkAppLaunchContext,
         * #GAppLaunchContext, or set the `DISPLAY` environment variable.
         * @param working_directory child's current working     directory, or %NULL to inherit parent's, in the GLib file name encoding
         * @param argv child's argument     vector, in the GLib file name encoding; it must be non-empty and %NULL-terminated
         * @param envp child's environment, or %NULL to inherit parent's, in the GLib file     name encoding
         * @param flags flags from #GSpawnFlags
         * @param child_setup function to run     in the child just before `exec()`
         * @param stdin_fd file descriptor to use for child's stdin, or `-1`
         * @param stdout_fd file descriptor to use for child's stdout, or `-1`
         * @param stderr_fd file descriptor to use for child's stderr, or `-1`
         * @param source_fds array of FDs from the parent    process to make available in the child process
         * @param target_fds array of FDs to remap    @source_fds to in the child process
         * @returns %TRUE on success, %FALSE if an error was set
         */
        function spawn_async_with_pipes_and_fds(
            working_directory: string | null,
            argv: string[],
            envp: string[] | null,
            flags: SpawnFlags | null,
            child_setup: SpawnChildSetupFunc | null,
            stdin_fd: number,
            stdout_fd: number,
            stderr_fd: number,
            source_fds: number[] | null,
            target_fds: number[] | null,
        ): [boolean, Pid | null, number, number, number];
        /**
         * An old name for g_spawn_check_wait_status(), deprecated because its
         * name is misleading.
         *
         * Despite the name of the function, `wait_status` must be the wait status
         * as returned by g_spawn_sync(), g_subprocess_get_status(), `waitpid()`,
         * etc. On Unix platforms, it is incorrect for it to be the exit status
         * as passed to `exit()` or returned by g_subprocess_get_exit_status() or
         * `WEXITSTATUS()`.
         * @param wait_status A status as returned from g_spawn_sync()
         * @returns %TRUE if child exited successfully, %FALSE otherwise (and     @error will be set)
         */
        function spawn_check_exit_status(wait_status: number): boolean;
        /**
         * Set `error` if `wait_status` indicates the child exited abnormally
         * (e.g. with a nonzero exit code, or via a fatal signal).
         *
         * The g_spawn_sync() and g_child_watch_add() family of APIs return the
         * status of subprocesses encoded in a platform-specific way.
         * On Unix, this is guaranteed to be in the same format waitpid() returns,
         * and on Windows it is guaranteed to be the result of GetExitCodeProcess().
         *
         * Prior to the introduction of this function in GLib 2.34, interpreting
         * `wait_status` required use of platform-specific APIs, which is problematic
         * for software using GLib as a cross-platform layer.
         *
         * Additionally, many programs simply want to determine whether or not
         * the child exited successfully, and either propagate a #GError or
         * print a message to standard error. In that common case, this function
         * can be used. Note that the error message in `error` will contain
         * human-readable information about the wait status.
         *
         * The `domain` and `code` of `error` have special semantics in the case
         * where the process has an "exit code", as opposed to being killed by
         * a signal. On Unix, this happens if WIFEXITED() would be true of
         * `wait_status`. On Windows, it is always the case.
         *
         * The special semantics are that the actual exit code will be the
         * code set in `error,` and the domain will be %G_SPAWN_EXIT_ERROR.
         * This allows you to differentiate between different exit codes.
         *
         * If the process was terminated by some means other than an exit
         * status (for example if it was killed by a signal), the domain will be
         * %G_SPAWN_ERROR and the code will be %G_SPAWN_ERROR_FAILED.
         *
         * This function just offers convenience; you can of course also check
         * the available platform via a macro such as %G_OS_UNIX, and use
         * WIFEXITED() and WEXITSTATUS() on `wait_status` directly. Do not attempt
         * to scan or parse the error message string; it may be translated and/or
         * change in future versions of GLib.
         *
         * Prior to version 2.70, g_spawn_check_exit_status() provides the same
         * functionality, although under a misleading name.
         * @param wait_status A platform-specific wait status as returned from g_spawn_sync()
         * @returns %TRUE if child exited successfully, %FALSE otherwise (and   @error will be set)
         */
        function spawn_check_wait_status(wait_status: number): boolean;
        /**
         * On some platforms, notably Windows, the #GPid type represents a resource
         * which must be closed to prevent resource leaking. g_spawn_close_pid()
         * is provided for this purpose. It should be used on all platforms, even
         * though it doesn't do anything under UNIX.
         * @param pid The process reference to close
         */
        function spawn_close_pid(pid: Pid): void;
        /**
         * A simple version of g_spawn_async() that parses a command line with
         * g_shell_parse_argv() and passes it to g_spawn_async().
         *
         * Runs a command line in the background. Unlike g_spawn_async(), the
         * %G_SPAWN_SEARCH_PATH flag is enabled, other flags are not. Note
         * that %G_SPAWN_SEARCH_PATH can have security implications, so
         * consider using g_spawn_async() directly if appropriate. Possible
         * errors are those from g_shell_parse_argv() and g_spawn_async().
         *
         * The same concerns on Windows apply as for g_spawn_command_line_sync().
         * @param command_line a command line
         * @returns %TRUE on success, %FALSE if error is set
         */
        function spawn_command_line_async(command_line: string): boolean;
        /**
         * A simple version of g_spawn_sync() with little-used parameters
         * removed, taking a command line instead of an argument vector.
         *
         * See g_spawn_sync() for full details.
         *
         * The `command_line` argument will be parsed by g_shell_parse_argv().
         *
         * Unlike g_spawn_sync(), the %G_SPAWN_SEARCH_PATH flag is enabled.
         * Note that %G_SPAWN_SEARCH_PATH can have security implications, so
         * consider using g_spawn_sync() directly if appropriate.
         *
         * Possible errors are those from g_spawn_sync() and those
         * from g_shell_parse_argv().
         *
         * If `wait_status` is non-%NULL, the platform-specific status of
         * the child is stored there; see the documentation of
         * g_spawn_check_wait_status() for how to use and interpret this.
         * On Unix platforms, note that it is usually not equal
         * to the integer passed to `exit()` or returned from `main()`.
         *
         * On Windows, please note the implications of g_shell_parse_argv()
         * parsing `command_line`. Parsing is done according to Unix shell rules, not
         * Windows command interpreter rules.
         * Space is a separator, and backslashes are
         * special. Thus you cannot simply pass a `command_line` containing
         * canonical Windows paths, like "c:\\program files\\app\\app.exe", as
         * the backslashes will be eaten, and the space will act as a
         * separator. You need to enclose such paths with single quotes, like
         * "'c:\\program files\\app\\app.exe' 'e:\\folder\\argument.txt'".
         * @param command_line a command line
         * @returns %TRUE on success, %FALSE if an error was set
         */
        function spawn_command_line_sync(command_line: string): [boolean, Uint8Array | null, Uint8Array | null, number];
        function spawn_error_quark(): Quark;
        function spawn_exit_error_quark(): Quark;
        /**
         * Executes a child synchronously (waits for the child to exit before returning).
         *
         * All output from the child is stored in `standard_output` and `standard_error,`
         * if those parameters are non-%NULL. Note that you must set the
         * %G_SPAWN_STDOUT_TO_DEV_NULL and %G_SPAWN_STDERR_TO_DEV_NULL flags when
         * passing %NULL for `standard_output` and `standard_error`.
         *
         * If `wait_status` is non-%NULL, the platform-specific status of
         * the child is stored there; see the documentation of
         * g_spawn_check_wait_status() for how to use and interpret this.
         * On Unix platforms, note that it is usually not equal
         * to the integer passed to `exit()` or returned from `main()`.
         *
         * Note that it is invalid to pass %G_SPAWN_DO_NOT_REAP_CHILD in
         * `flags,` and on POSIX platforms, the same restrictions as for
         * g_child_watch_source_new() apply.
         *
         * If an error occurs, no data is returned in `standard_output,`
         * `standard_error,` or `wait_status`.
         *
         * This function calls g_spawn_async_with_pipes() internally; see that
         * function for full details on the other parameters and details on
         * how these functions work on Windows.
         * @param working_directory child's current working     directory, or %NULL to inherit parent's
         * @param argv child's argument vector, which must be non-empty and %NULL-terminated
         * @param envp child's environment, or %NULL to inherit parent's
         * @param flags flags from #GSpawnFlags
         * @param child_setup function to run     in the child just before `exec()`
         * @returns %TRUE on success, %FALSE if an error was set
         */
        function spawn_sync(
            working_directory: string | null,
            argv: string[],
            envp: string[] | null,
            flags: SpawnFlags | null,
            child_setup: SpawnChildSetupFunc | null,
        ): [boolean, Uint8Array | null, Uint8Array | null, number];
        /**
         * A wrapper for the POSIX stat() function. The stat() function
         * returns information about a file. On Windows the stat() function in
         * the C library checks only the FAT-style READONLY attribute and does
         * not look at the ACL at all. Thus on Windows the protection bits in
         * the `st_mode` field are a fabrication of little use.
         *
         * On Windows the Microsoft C libraries have several variants of the
         * stat struct and stat() function with names like _stat(), _stat32(),
         * _stat32i64() and _stat64i32(). The one used here is for 32-bit code
         * the one with 32-bit size and time fields, specifically called _stat32().
         *
         * In Microsoft's compiler, by default struct stat means one with
         * 64-bit time fields while in MinGW struct stat is the legacy one
         * with 32-bit fields. To hopefully clear up this messs, the gstdio.h
         * header defines a type #GStatBuf which is the appropriate struct type
         * depending on the platform and/or compiler being used. On POSIX it
         * is just struct stat, but note that even on POSIX platforms, stat()
         * might be a macro.
         *
         * See your C library manual for more details about stat().
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param buf a pointer to a stat struct, which will be filled with the file     information
         * @returns 0 if the information was successfully retrieved,     -1 if an error occurred
         */
        function stat(filename: string, buf: StatBuf): number;
        /**
         * Copies a nul-terminated string into the destination buffer, including
         * the trailing nul byte, and returns a pointer to the trailing nul byte
         * in `dest`.  The return value is useful for concatenating multiple
         * strings without having to repeatedly scan for the end.
         * @param dest destination buffer
         * @param src source string
         * @returns a pointer to the trailing nul byte in `dest`
         */
        function stpcpy(dest: string, src: string): string;
        /**
         * Compares two strings for byte-by-byte equality and returns %TRUE
         * if they are equal. It can be passed to g_hash_table_new() as the
         * `key_equal_func` parameter, when using non-%NULL strings as keys in a
         * #GHashTable.
         *
         * This function is typically used for hash table comparisons, but can be used
         * for general purpose comparisons of non-%NULL strings. For a %NULL-safe string
         * comparison function, see g_strcmp0().
         * @param v1 a key
         * @param v2 a key to compare with @v1
         * @returns %TRUE if the two keys match
         */
        function str_equal(v1: any, v2: any): boolean;
        /**
         * Looks whether the string `str` begins with `prefix`.
         * @param str a string to look in
         * @param prefix the prefix to look for
         * @returns true if @str begins with @prefix, false otherwise
         */
        function str_has_prefix(str: string, prefix: string): boolean;
        /**
         * Looks whether a string ends with `suffix`.
         * @param str a string to look in
         * @param suffix the suffix to look for
         * @returns true if @str ends with @suffix, false otherwise
         */
        function str_has_suffix(str: string, suffix: string): boolean;
        /**
         * Converts a string to a hash value.
         *
         * This function implements the widely used "djb" hash apparently
         * posted by Daniel Bernstein to comp.lang.c some time ago.  The 32
         * bit unsigned hash value starts at 5381 and for each byte 'c' in
         * the string, is updated: `hash = hash * 33 + c`. This function
         * uses the signed value of each byte.
         *
         * It can be passed to g_hash_table_new() as the `hash_func` parameter,
         * when using non-%NULL strings as keys in a #GHashTable.
         *
         * Note that this function may not be a perfect fit for all use cases.
         * For example, it produces some hash collisions with strings as short
         * as 2.
         * @param v a string key
         * @returns a hash value corresponding to the key
         */
        function str_hash(v: any): number;
        /**
         * Determines if a string is pure ASCII. A string is pure ASCII if it
         * contains no bytes with the high bit set.
         * @param str a string
         * @returns true if @str is ASCII
         */
        function str_is_ascii(str: string): boolean;
        /**
         * Checks if a search conducted for `search_term` should match
         * `potential_hit`.
         *
         * This function calls [func`GLib`.str_tokenize_and_fold] on both
         * `search_term` and `potential_hit`. ASCII alternates are never taken
         * for `search_term` but will be taken for `potential_hit` according to
         * the value of `accept_alternates`.
         *
         * A hit occurs when each folded token in `search_term` is a prefix of a
         * folded token from `potential_hit`.
         *
         * Depending on how you're performing the search, it will typically be
         * faster to call `g_str_tokenize_and_fold()` on each string in
         * your corpus and build an index on the returned folded tokens, then
         * call `g_str_tokenize_and_fold()` on the search term and
         * perform lookups into that index.
         *
         * As some examples, searching for ‘fred’ would match the potential hit
         * ‘Smith, Fred’ and also ‘Frédéric’.  Searching for ‘Fréd’ would match
         * ‘Frédéric’ but not ‘Frederic’ (due to the one-directional nature of
         * accent matching).  Searching ‘fo’ would match ‘Foo’ and ‘Bar Foo
         * Baz’, but not ‘SFO’ (because no word has ‘fo’ as a prefix).
         * @param search_term the search term from the user
         * @param potential_hit the text that may be a hit
         * @param accept_alternates if true, ASCII alternates are accepted
         * @returns true if @potential_hit is a hit
         */
        function str_match_string(search_term: string, potential_hit: string, accept_alternates: boolean): boolean;
        /**
         * Transliterate `str` to plain ASCII.
         *
         * For best results, `str` should be in composed normalised form.
         *
         * This function performs a reasonably good set of character
         * replacements.  The particular set of replacements that is done may
         * change by version or even by runtime environment.
         *
         * If the source language of `str` is known, it can used to improve the
         * accuracy of the translation by passing it as `from_locale`.  It should
         * be a valid POSIX locale string (of the form
         * `language[_territory][.codeset][`modifier]``).
         *
         * If `from_locale` is %NULL then the current locale is used.
         *
         * If you want to do translation for no specific locale, and you want it
         * to be done independently of the currently locale, specify `"C"` for
         * `from_locale`.
         * @param str a string, in UTF-8
         * @param from_locale the source locale, if known
         * @returns a string in plain ASCII
         */
        function str_to_ascii(str: string, from_locale?: string | null): string;
        /**
         * Tokenizes `string` and performs folding on each token.
         *
         * A token is a non-empty sequence of alphanumeric characters in the
         * source string, separated by non-alphanumeric characters.  An
         * "alphanumeric" character for this purpose is one that matches
         * [func`GLib`.unichar_isalnum] or [func`GLib`.unichar_ismark].
         *
         * Each token is then (Unicode) normalised and case-folded.  If
         * `ascii_alternates` is non-`NULL` and some of the returned tokens
         * contain non-ASCII characters, ASCII alternatives will be generated.
         *
         * The number of ASCII alternatives that are generated and the method
         * for doing so is unspecified, but `translit_locale` (if specified) may
         * improve the transliteration if the language of the source string is
         * known.
         * @param string a string to tokenize
         * @param translit_locale the language code (like 'de' or   'en_GB') from which @string originates
         * @returns the folded tokens
         */
        function str_tokenize_and_fold(string: string, translit_locale?: string | null): [string[], string[] | null];
        /**
         * For each character in `string,` if the character is not in `valid_chars,`
         * replaces the character with `substitutor`.
         *
         * Modifies `string` in place, and return `string` itself, not a copy. The
         * return value is to allow nesting such as:
         * ```C
         * g_ascii_strup (g_strcanon (str, "abc", '?'))
         * ```
         *
         * In order to modify a copy, you may use [func`GLib`.strdup]:
         * ```C
         * reformatted = g_strcanon (g_strdup (const_str), "abc", '?');
         * …
         * g_free (reformatted);
         * ```
         * @param string a nul-terminated array of bytes
         * @param valid_chars bytes permitted in @string
         * @param substitutor replacement character for disallowed bytes
         * @returns the modified @string
         */
        function strcanon(string: string, valid_chars: string, substitutor: number): string;
        /**
         * A case-insensitive string comparison, corresponding to the standard
         * `strcasecmp()` function on platforms which support it.
         * @param s1 string to compare with @s2
         * @param s2 string to compare with @s1
         * @returns 0 if the strings match, a negative value if @s1 < @s2,   or a positive value if @s1 > @s2
         */
        function strcasecmp(s1: string, s2: string): number;
        /**
         * Removes trailing whitespace from a string.
         *
         * This function doesn't allocate or reallocate any memory;
         * it modifies `string` in place. Therefore, it cannot be used
         * on statically allocated strings.
         *
         * The pointer to `string` is returned to allow the nesting of functions.
         *
         * Also see [func`GLib`.strchug] and [func`GLib`.strstrip].
         * @param string a string to remove the trailing whitespace from
         * @returns the modified @string
         */
        function strchomp(string: string): string;
        /**
         * Removes leading whitespace from a string, by moving the rest
         * of the characters forward.
         *
         * This function doesn't allocate or reallocate any memory;
         * it modifies `string` in place. Therefore, it cannot be used on
         * statically allocated strings.
         *
         * The pointer to `string` is returned to allow the nesting of functions.
         *
         * Also see [func`GLib`.strchomp] and [func`GLib`.strstrip].
         * @param string a string to remove the leading whitespace from
         * @returns the modified @string
         */
        function strchug(string: string): string;
        /**
         * Compares `str1` and `str2` like `strcmp()`.
         *
         * Handles `NULL` gracefully by sorting it before non-`NULL` strings.
         * Comparing two `NULL` pointers returns 0.
         * @param str1 a string
         * @param str2 another string
         * @returns an integer less than, equal to, or greater than zero,   if @str1 is <, == or > than @str2
         */
        function strcmp0(str1?: string | null, str2?: string | null): number;
        /**
         * Makes a copy of a string replacing C string-style escape
         * sequences with their one byte equivalent:
         *
         * - `\b` → [U+0008 Backspace](https://en.wikipedia.org/wiki/Backspace)
         * - `\f` → [U+000C Form Feed](https://en.wikipedia.org/wiki/Form_feed)
         * - `\n` → [U+000A Line Feed](https://en.wikipedia.org/wiki/Newline)
         * - `\r` → [U+000D Carriage Return](https://en.wikipedia.org/wiki/Carriage_return)
         * - `\t` → [U+0009 Horizontal Tabulation](https://en.wikipedia.org/wiki/Tab_character)
         * - `\v` → [U+000B Vertical Tabulation](https://en.wikipedia.org/wiki/Vertical_Tab)
         * - `\` followed by one to three octal digits → the numeric value (mod 255)
         * - `\` followed by any other character → the character as is.
         *   For example, `\\` will turn into a backslash (`\`) and `\"` into a double quote (`"`).
         *
         * [func`GLib`.strescape] does the reverse conversion.
         * @param source a string to compress
         * @returns a newly-allocated copy of @source with all escaped   character compressed
         */
        function strcompress(source: string): string;
        /**
         * Converts any delimiter characters in `string` to `new_delimiter`.
         *
         * Any characters in `string` which are found in `delimiters` are
         * changed to the `new_delimiter` character. Modifies `string` in place,
         * and returns `string` itself, not a copy.
         *
         * The return value is to allow nesting such as:
         * ```C
         * g_ascii_strup (g_strdelimit (str, "abc", '?'))
         * ```
         *
         * In order to modify a copy, you may use [func`GLib`.strdup]:
         * ```C
         * reformatted = g_strdelimit (g_strdup (const_str), "abc", '?');
         * …
         * g_free (reformatted);
         * ```
         * @param string the string to convert
         * @param delimiters a string containing the current delimiters, or   `NULL` to use the standard delimiters defined in [const@GLib.STR_DELIMITERS]
         * @param new_delimiter the new delimiter character
         * @returns the modified @string
         */
        function strdelimit(string: string, delimiters: string | null, new_delimiter: number): string;
        /**
         * Converts a string to lower case.
         * @param string the string to convert
         * @returns the string
         */
        function strdown(string: string): string;
        /**
         * Duplicates a string. If `str` is `NULL` it returns `NULL`.
         * @param str the string to duplicate
         * @returns a newly-allocated copy of @str
         */
        function strdup(str?: string | null): string;
        /**
         * Copies an array of strings. The copy is a deep copy; each string is also
         * copied.
         *
         * If called on a `NULL` value, `g_strdupv()` simply returns `NULL`.
         * @param str_array an array of strings to copy
         * @returns a   newly-allocated array of strings. Use [func@GLib.strfreev] to free it.
         */
        function strdupv(str_array?: string[] | null): string[] | null;
        /**
         * Returns a string corresponding to the given error code, e.g. "no
         * such process".
         *
         * Unlike `strerror()`, this always returns a string in
         * UTF-8 encoding, and the pointer is guaranteed to remain valid for
         * the lifetime of the process. If the error code is unknown, it returns a
         * string like “Unknown error <code\>”.
         *
         * Note that the string may be translated according to the current locale.
         *
         * The value of `errno` will not be changed by this function. However, it may
         * be changed by intermediate function calls, so you should save its value
         * as soon as the call returns:
         * ```C
         * int saved_errno;
         *
         * ret = read (blah);
         * saved_errno = errno;
         *
         * g_strerror (saved_errno);
         * ```
         * @param errnum the system error number. See the standard C `errno` documentation
         * @returns the string describing the error code
         */
        function strerror(errnum: number): string;
        /**
         * It replaces the following special characters in the string `source`
         * with their corresponding C escape sequence:
         *
         * | Symbol                                                                      | Escape |
         * |-----------------------------------------------------------------------------|--------|
         * | [U+0008 Backspace](https://en.wikipedia.org/wiki/Backspace)                 | `\b`   |
         * | [U+000C Form Feed](https://en.wikipedia.org/wiki/Form_feed)                 | `\f`   |
         * | [U+000A Line Feed](https://en.wikipedia.org/wiki/Newline)                   | `\n`   |
         * | [U+000D Carriage Return](https://en.wikipedia.org/wiki/Carriage_return)     | `\r`   |
         * | [U+0009 Horizontal Tabulation](https://en.wikipedia.org/wiki/Tab_character) | `\t`   |
         * | [U+000B Vertical Tabulation](https://en.wikipedia.org/wiki/Vertical_Tab)    | `\v`   |
         *
         * It also inserts a backslash (`\`) before any backslash or a double quote (`"`).
         * Additionally all characters in the range 0x01-0x1F (everything
         * below SPACE) and in the range 0x7F-0xFF (all non-ASCII chars) are
         * replaced with a backslash followed by their octal representation.
         * Characters supplied in `exceptions` are not escaped.
         *
         * [func`GLib`.strcompress] does the reverse conversion.
         * @param source a string to escape
         * @param exceptions a string of characters not to escape in @source
         * @returns a newly-allocated copy of @source with special characters escaped
         */
        function strescape(source: string, exceptions?: string | null): string;
        /**
         * Frees an array of strings, as well as each string it contains.
         *
         * If `str_array` is `NULL`, this function simply returns.
         * @param str_array an   array of strings to free
         */
        function strfreev(str_array?: string[] | null): void;
        /**
         * An auxiliary function for gettext() support (see Q_()).
         * @param msgid a string
         * @param msgval another string
         * @returns @msgval, unless @msgval is identical to @msgid     and contains a '|' character, in which case a pointer to     the substring of msgid after the first '|' character is returned.
         */
        function strip_context(msgid: string, msgval: string): string;
        /**
         * Joins an array of strings together to form one long string, with the
         * optional `separator` inserted between each of them.
         *
         * If `str_array` has no items, the return value will be an
         * empty string. If `str_array` contains a single item, `separator` will not
         * appear in the resulting string.
         * @param separator a string to insert between each of the strings
         * @param str_array an array of strings to join
         * @returns a newly-allocated string containing all of the strings joined   together, with @separator between them
         */
        function strjoinv(separator: string | null, str_array: string[]): string;
        /**
         * Portability wrapper that calls `strlcat()` on systems which have it,
         * and emulates it otherwise. Appends nul-terminated `src` string to `dest,`
         * guaranteeing nul-termination for `dest`. The total size of `dest` won't
         * exceed `dest_size`.
         *
         * At most `dest_size` - 1 characters will be copied. Unlike `strncat()`,
         * `dest_size` is the full size of dest, not the space left over. This
         * function does not allocate memory. It always nul-terminates (unless
         * `dest_size` == 0 or there were no nul characters in the `dest_size`
         * characters of dest to start with).
         *
         * Caveat: this is supposedly a more secure alternative to `strcat()` or
         * `strncat()`, but for real security [func`GLib`.strconcat] is harder to mess up.
         * @param dest destination buffer, already containing one nul-terminated string
         * @param src source buffer
         * @param dest_size length of @dest buffer in bytes (not length of existing string   inside @dest)
         * @returns size of attempted result, which is `MIN (dest_size, strlen   (original dest)) + strlen (src)`, so if @retval >= @dest_size,   truncation occurred
         */
        function strlcat(dest: string, src: string, dest_size: number): number;
        /**
         * Portability wrapper that calls `strlcpy()` on systems which have it,
         * and emulates `strlcpy()` otherwise. Copies `src` to `dest;` `dest` is
         * guaranteed to be nul-terminated; `src` must be nul-terminated;
         * `dest_size` is the buffer size, not the number of bytes to copy.
         *
         * At most `dest_size` - 1 characters will be copied. Always nul-terminates
         * (unless `dest_size` is 0). This function does not allocate memory. Unlike
         * `strncpy()`, this function doesn't pad `dest` (so it's often faster). It
         * returns the size of the attempted result, `strlen (src)`, so if
         * `retval` >= `dest_size,` truncation occurred.
         *
         * Caveat: `strlcpy()` is supposedly more secure than `strcpy()` or `strncpy()`,
         * but if you really want to avoid screwups, [func`GLib`.strdup] is an even better
         * idea.
         * @param dest destination buffer
         * @param src source buffer
         * @param dest_size length of @dest in bytes
         * @returns length of @src
         */
        function strlcpy(dest: string, src: string, dest_size: number): number;
        /**
         * A case-insensitive string comparison, corresponding to the standard
         * `strncasecmp()` function on platforms which support it. It is similar
         * to [func`GLib`.strcasecmp] except it only compares the first `n` characters of
         * the strings.
         * @param s1 string to compare with @s2
         * @param s2 string to compare with @s1
         * @param n the maximum number of characters to compare
         * @returns 0 if the strings match, a negative value if @s1 < @s2,   or a positive value if @s1 > @s2
         */
        function strncasecmp(s1: string, s2: string, n: number): number;
        /**
         * Duplicates the first `n` bytes of a string, returning a newly-allocated
         * buffer `n` + 1 bytes long which will always be nul-terminated. If `str`
         * is less than `n` bytes long the buffer is padded with nuls. If `str` is
         * `NULL` it returns `NULL`.
         *
         * To copy a number of characters from a UTF-8 encoded string,
         * use [func`GLib`.utf8_strncpy] instead.
         * @param str the string to duplicate
         * @param n the maximum number of bytes to copy from @str
         * @returns a newly-allocated buffer containing the first    @n bytes of @str
         */
        function strndup(str: string | null, n: number): string | null;
        /**
         * Creates a new string `length` bytes long filled with `fill_char`.
         * @param length the length of the new string
         * @param fill_char the byte to fill the string with
         * @returns a newly-allocated string filled with @fill_char
         */
        function strnfill(length: number, fill_char: number): string;
        /**
         * Reverses all of the bytes in a string. For example,
         * `g_strreverse ("abcdef")` will result in "fedcba".
         *
         * Note that `g_strreverse()` doesn't work on UTF-8 strings
         * containing multibyte characters. For that purpose, use
         * [func`GLib`.utf8_strreverse].
         * @param string the string to reverse
         * @returns the @string, reversed in place
         */
        function strreverse(string: string): string;
        /**
         * Searches the string `haystack` for the last occurrence
         * of the string `needle`.
         *
         * The fact that this function returns `gchar *` rather than `const gchar *` is
         * a historical artifact.
         * @param haystack a string to search in
         * @param needle the string to search for
         * @returns a pointer to the found occurrence, or    `NULL` if not found
         */
        function strrstr(haystack: string, needle: string): string | null;
        /**
         * Searches the string `haystack` for the last occurrence
         * of the string `needle,` limiting the length of the search
         * to `haystack_len`.
         *
         * The fact that this function returns `gchar *` rather than `const gchar *` is
         * a historical artifact.
         * @param haystack a string to search in
         * @param haystack_len the maximum length of @haystack in bytes. A length of `-1`   can be used to mean "search the entire string", like [func@GLib.strrstr]
         * @param needle the string to search for
         * @returns a pointer to the found occurrence, or    `NULL` if not found
         */
        function strrstr_len(haystack: string, haystack_len: number, needle: string): string | null;
        /**
         * Returns a string describing the given signal, e.g. "Segmentation fault".
         * If the signal is unknown, it returns “unknown signal (<signum\>)”.
         *
         * You should use this function in preference to `strsignal()`, because it
         * returns a string in UTF-8 encoding, and since not all platforms support
         * the `strsignal()` function.
         * @param signum the signal number. See the `signal` documentation
         * @returns the string describing the signal
         */
        function strsignal(signum: number): string;
        /**
         * Splits a string into a maximum of `max_tokens` pieces, using the given
         * `delimiter`. If `max_tokens` is reached, the remainder of `string` is
         * appended to the last token.
         *
         * As an example, the result of `g_strsplit (":a:bc::d:", ":", -1)` is an array
         * containing the six strings "", "a", "bc", "", "d" and "".
         *
         * As a special case, the result of splitting the empty string "" is an empty
         * array, not an array containing a single string. The reason for this
         * special case is that being able to represent an empty array is typically
         * more useful than consistent handling of empty elements. If you do need
         * to represent empty elements, you'll need to check for the empty string
         * before calling `g_strsplit()`.
         * @param string a string to split
         * @param delimiter a string which specifies the places at which to split   the string. The delimiter is not included in any of the resulting   strings, unless @max_tokens is reached.
         * @param max_tokens the maximum number of pieces to split @string into   If this is less than 1, the string is split completely
         * @returns a newly-allocated array of strings, freed with   [func@GLib.strfreev]
         */
        function strsplit(string: string, delimiter: string, max_tokens: number): string[];
        /**
         * Splits `string` into a number of tokens not containing any of the characters
         * in `delimiters`. A token is the (possibly empty) longest string that does not
         * contain any of the characters in `delimiters`. If `max_tokens` is reached, the
         * remainder is appended to the last token.
         *
         * For example, the result of g_strsplit_set ("abc:def/ghi", ":/", -1) is an
         * array containing the three strings "abc", "def", and "ghi".
         *
         * The result of g_strsplit_set (":def/ghi:", ":/", -1) is an array containing
         * the four strings "", "def", "ghi", and "".
         *
         * As a special case, the result of splitting the empty string "" is an empty
         * array, not an array containing a single string. The reason for this
         * special case is that being able to represent an empty array is typically
         * more useful than consistent handling of empty elements. If you do need
         * to represent empty elements, you'll need to check for the empty string
         * before calling `g_strsplit_set()`.
         *
         * Note that this function works on bytes not characters, so it can't be used
         * to delimit UTF-8 strings for anything but ASCII characters.
         * @param string a string to split
         * @param delimiters a string containing characters that are used to split the   string. Can be empty, which will result in no string splitting
         * @param max_tokens the maximum number of tokens to split @string into.   If this is less than 1, the string is split completely
         * @returns a newly-allocated array of strings. Use   [func@GLib.strfreev] to free it.
         */
        function strsplit_set(string: string, delimiters: string, max_tokens: number): string[];
        /**
         * Searches the string `haystack` for the first occurrence
         * of the string `needle,` limiting the length of the search
         * to `haystack_len` or a nul terminator byte (whichever is reached first).
         *
         * A length of `-1` can be used to mean “search the entire string”, like
         * `strstr()`.
         *
         * The fact that this function returns `gchar *` rather than `const gchar *` is
         * a historical artifact.
         * @param haystack a string to search in
         * @param haystack_len the maximum length of @haystack in bytes, or `-1` to   search it entirely
         * @param needle the string to search for
         * @returns a pointer to the found occurrence, or    `NULL` if not found
         */
        function strstr_len(haystack: string, haystack_len: number, needle: string): string | null;
        /**
         * Converts a string to a floating point value.
         *
         * It calls the standard `strtod()` function to handle the conversion, but
         * if the string is not completely converted it attempts the conversion
         * again with [func`GLib`.ascii_strtod], and returns the best match.
         *
         * This function should seldom be used. The normal situation when reading
         * numbers not for human consumption is to use [func`GLib`.ascii_strtod]. Only when
         * you know that you must expect both locale formatted and C formatted numbers
         * should you use this. Make sure that you don't pass strings such as comma
         * separated lists of values, since the commas may be interpreted as a decimal
         * point in some locales, causing unexpected results.
         * @param nptr the string to convert to a numeric value
         * @returns the converted value
         */
        function strtod(nptr: string): [number, string];
        /**
         * Converts a string to upper case.
         * @param string the string to convert
         * @returns the string
         */
        function strup(string: string): string;
        /**
         * Checks if an array of strings contains the string `str` according to
         * [func`GLib`.str_equal]. `strv` must not be `NULL`.
         * @param strv an array of strings to search in
         * @param str the string to search for
         * @returns true if @str is an element of @strv
         */
        function strv_contains(strv: string[], str: string): boolean;
        /**
         * Checks if two arrays of strings contain exactly the same elements in
         * exactly the same order.
         *
         * Elements are compared using [func`GLib`.str_equal]. To match independently
         * of order, sort the arrays first (using [func`GLib`.qsort_with_data]
         * or similar).
         *
         * Two empty arrays are considered equal. Neither `strv1` nor `strv2` may be
         * `NULL`.
         * @param strv1 an array of strings to compare to @strv2
         * @param strv2 an array of strings to compare to @strv1
         * @returns true if @strv1 and @strv2 are equal
         */
        function strv_equal(strv1: string[], strv2: string[]): boolean;
        function strv_get_type(): GObject.GType;
        /**
         * Returns the length of an array of strings. `str_array` must not be `NULL`.
         * @param str_array an array of strings
         * @returns length of @str_array
         */
        function strv_length(str_array: string[]): number;
        /**
         * Creates a new test case.
         *
         * This function is similar to [func`GLib`.test_create_case].
         * However the test is assumed to use no fixture, and test suites are
         * automatically created on the fly and added to the root fixture,
         * based on the /-separated portions of `testpath`. The `test_data`
         * argument will be passed as first argument to `test_func`.
         *
         * If `testpath` includes the component "subprocess" anywhere in it,
         * the test will be skipped by default, and only run if explicitly
         * required via the `-p` command-line option or [func`GLib`.test_trap_subprocess].
         *
         * No component of `testpath` may start with a dot (`.`) if the
         * [const`GLib`.TEST_OPTION_ISOLATE_DIRS] option is being used;
         * and it is recommended to do so even if it isn’t.
         * @param testpath a /-separated name for the test
         * @param test_data data for the @test_func
         * @param test_func the test function to invoke for this test
         */
        function test_add_data_func(testpath: string, test_data: any | null, test_func: TestDataFunc): void;
        /**
         * Creates a new test case.
         *
         * In constract to [func`GLib`.test_add_data_func], this function
         * is freeing `test_data` after the test run is complete.
         * @param testpath a /-separated name for the test
         * @param test_data data for @test_func
         * @param test_func the test function to invoke for this test
         */
        function test_add_data_func_full(testpath: string, test_data: any | null, test_func: TestDataFunc): void;
        /**
         * Creates a new test case.
         *
         * This function is similar to [func`GLib`.test_create_case].
         * However the test is assumed to use no fixture, and test suites are
         * automatically created on the fly and added to the root fixture,
         * based on the /-separated portions of `testpath`.
         *
         * If `testpath` includes the component "subprocess" anywhere in it,
         * the test will be skipped by default, and only run if explicitly
         * required via the `-p` command-line option or [func`GLib`.test_trap_subprocess].
         *
         * No component of `testpath` may start with a dot (`.`) if the
         * [const`GLib`.TEST_OPTION_ISOLATE_DIRS] option is being used; and
         * it is recommended to do so even if it isn’t.
         * @param testpath a /-separated name for the test
         * @param test_func the test function to invoke for this test
         */
        function test_add_func(testpath: string, test_func: TestFunc): void;
        function test_assert_expected_messages_internal(domain: string, file: string, line: number, func: string): void;
        /**
         * Adds a message to test reports that associates a bug URI with a test case.
         *
         * Bug URIs are constructed from a base URI set with [func`GLib`.test_bug_base]
         * and `bug_uri_snippet`. If [func`GLib`.test_bug_base] has not been called, it is
         * assumed to be the empty string, so a full URI can be provided to
         * [func`GLib`.test_bug] instead.
         *
         * See also [func`GLib`.test_summary].
         *
         * Since GLib 2.70, the base URI is not prepended to `bug_uri_snippet`
         * if it is already a valid URI.
         * @param bug_uri_snippet Bug specific bug tracker URI or URI portion.
         */
        function test_bug(bug_uri_snippet: string): void;
        /**
         * Specifies the base URI for bug reports.
         *
         * The base URI is used to construct bug report messages for
         * [func`GLib`.test_message] when [func`GLib`.test_bug] is called.
         * Calling this function outside of a test case sets the
         * default base URI for all test cases. Calling it from within
         * a test case changes the base URI for the scope of the test
         * case only.
         * Bug URIs are constructed by appending a bug specific URI
         * portion to `uri_pattern,` or by replacing the special string
         * `%s` within `uri_pattern` if that is present.
         *
         * If [func`GLib`.test_bug_base] is not called, bug URIs are formed
         * solely from the value provided by [func`GLib`.test_bug].
         * @param uri_pattern the base pattern for bug URIs
         */
        function test_bug_base(uri_pattern: string): void;
        /**
         * Attempts to disable system crash reporting infrastructure.
         *
         * This function should be called before exercising code paths that are
         * expected or intended to crash, to avoid wasting resources in system-wide
         * crash collection infrastructure such as systemd-coredump or abrt.
         */
        function test_disable_crash_reporting(): void;
        /**
         * Indicates that a message with the given `log_domain` and `log_level,`
         * with text matching `pattern,` is expected to be logged.
         *
         * When this message is logged, it will not be printed, and the test case will
         * not abort.
         *
         * This API may only be used with the old logging API ([func`GLib`.log] without
         * `G_LOG_USE_STRUCTURED` defined). It will not work with the structured logging
         * API. See [Testing for Messages](logging.html#testing-for-messages).
         *
         * Use [func`GLib`.test_assert_expected_messages] to assert that all
         * previously-expected messages have been seen and suppressed.
         *
         * You can call this multiple times in a row, if multiple messages are
         * expected as a result of a single call. (The messages must appear in
         * the same order as the calls to [func`GLib`.test_expect_message].)
         *
         * For example:
         *
         * ```c
         * // g_main_context_push_thread_default() should fail if the
         * // context is already owned by another thread.
         * g_test_expect_message (G_LOG_DOMAIN,
         *                        G_LOG_LEVEL_CRITICAL,
         *                        "assertion*acquired_context*failed");
         * g_main_context_push_thread_default (bad_context);
         * g_test_assert_expected_messages ();
         * ```
         *
         * Note that you cannot use this to test [func`GLib`.error] messages, since
         * [func`GLib`.error] intentionally never returns even if the program doesn’t
         * abort; use [func`GLib`.test_trap_subprocess] in this case.
         *
         * If messages at [flags`GLib`.LogLevelFlags.LEVEL_DEBUG] are emitted, but not explicitly
         * expected via [func`GLib`.test_expect_message] then they will be ignored.
         * @param log_domain the log domain of the message
         * @param log_level the log level of the message
         * @param pattern a glob-style pattern (see [type@GLib.PatternSpec])
         */
        function test_expect_message(log_domain: string | null, log_level: LogLevelFlags | null, pattern: string): void;
        /**
         * Indicates that a test failed.
         *
         * This function can be called multiple times from the same test.
         * You can use this function if your test failed in a recoverable way.
         *
         * Do not use this function if the failure of a test could cause
         * other tests to malfunction.
         *
         * Calling this function will not stop the test from running, you
         * need to return from the test function yourself. So you can
         * produce additional diagnostic messages or even continue running
         * the test.
         *
         * If not called from inside a test, this function does nothing.
         *
         * Note that unlike [func`GLib`.test_skip] and [func`GLib`.test_incomplete],
         * this function does not log a message alongside the test failure.
         * If details of the test failure are available, either log them with
         * [func`GLib`.test_message] before [func`GLib`.test_fail], or use
         * [func`GLib`.test_fail_printf] instead.
         */
        function test_fail(): void;
        /**
         * Returns whether a test has already failed.
         *
         * This will be the case when [func`GLib`.test_fail],
         * [func`GLib`.test_incomplete] or [func`GLib`.test_skip] have
         * been called, but also if an assertion has failed.
         *
         * This can be useful to return early from a test if
         * continuing after a failed assertion might be harmful.
         *
         * The return value of this function is only meaningful
         * if it is called from inside a test function.
         * @returns true if the test has failed
         */
        function test_failed(): boolean;
        /**
         * Gets the pathname of the directory containing test files of the type
         * specified by `file_type`.
         *
         * This is approximately the same as calling `g_test_build_filename(".")`,
         * but you don't need to free the return value.
         * @param file_type the type of file (built vs. distributed)
         * @returns the path of the directory, owned by GLib
         */
        function test_get_dir(file_type: TestFileType | null): string;
        /**
         * Gets the test path for the test currently being run.
         *
         * In essence, it will be the same string passed as the first argument
         * to e.g. [func`GLib`.test_add] when the test was added.
         *
         * This function returns a valid string only within a test function.
         *
         * Note that this is a test path, not a file system path.
         * @returns the test path for the test currently being run
         */
        function test_get_path(): string;
        /**
         * Indicates that a test failed because of some incomplete
         * functionality.
         *
         * This function can be called multiple times from the same test.
         *
         * Calling this function will not stop the test from running, you
         * need to return from the test function yourself. So you can
         * produce additional diagnostic messages or even continue running
         * the test.
         *
         * If not called from inside a test, this function does nothing.
         * @param msg explanation
         */
        function test_incomplete(msg?: string | null): void;
        function test_log_type_name(log_type: TestLogType | null): string;
        /**
         * Enqueues a callback `destroy_func` to be executed during the next test case
         * teardown phase.
         *
         * This is most useful to auto destroy allocated test resources at the end
         * of a test run. Resources are released in reverse queue order, that means
         * enqueueing callback `A` before callback `B` will cause `B()` to be called
         * before `A()` during teardown.
         * @param destroy_data destroy callback data
         */
        function test_queue_destroy(destroy_data?: any | null): void;
        /**
         * Enqueues a pointer to be released with [func`GLib`.free]
         * during the next teardown phase.
         *
         * This is equivalent to calling [func`GLib`.test_queue_destroy]
         * with a destroy callback of [func`GLib`.free].
         * @param gfree_pointer the pointer to be stored
         */
        function test_queue_free(gfree_pointer?: any | null): void;
        /**
         * Gets a reproducible random floating point number.
         *
         * See [func`GLib`.test_rand_int] for details on test case random numbers.
         * @returns a random number from the seeded random number generator
         */
        function test_rand_double(): number;
        /**
         * Gets a reproducible random floating point number out of a specified range.
         *
         * See [func`GLib`.test_rand_int] for details on test case random numbers.
         * @param range_start the minimum value returned by this function
         * @param range_end the minimum value not returned by this function
         * @returns a number with @range_start <= number < @range_end
         */
        function test_rand_double_range(range_start: number, range_end: number): number;
        /**
         * Gets a reproducible random integer number.
         *
         * The random numbers generated by the g_test_rand_*() family of functions
         * change with every new test program start, unless the --seed option is
         * given when starting test programs.
         *
         * For individual test cases however, the random number generator is
         * reseeded, to avoid dependencies between tests and to make --seed
         * effective for all test cases.
         * @returns a random number from the seeded random number generator
         */
        function test_rand_int(): number;
        /**
         * Gets a reproducible random integer number out of a specified range.
         *
         * See [func`GLib`.test_rand_int] for details on test case random numbers.
         * @param begin the minimum value returned by this function
         * @param end the smallest value not to be returned by this function
         * @returns a number with @begin <= number < @end
         */
        function test_rand_int_range(begin: number, end: number): number;
        /**
         * Runs all tests under the toplevel suite.
         *
         * The toplevel suite can be retrieved with [func`GLib`.test_get_root].
         *
         * Similar to [func`GLib`.test_run_suite], the test cases to be run are
         * filtered according to test path arguments (`-p testpath` and `-s testpath`)
         * as parsed by [func`GLib`.test_init]. [func`GLib`.test_run_suite] or
         * [func`GLib`.test_run] may only be called once in a program.
         *
         * In general, the tests and sub-suites within each suite are run in
         * the order in which they are defined. However, note that prior to
         * GLib 2.36, there was a bug in the `g_test_add_*`
         * functions which caused them to create multiple suites with the same
         * name, meaning that if you created tests "/foo/simple",
         * "/bar/simple", and "/foo/using-bar" in that order, they would get
         * run in that order (since [func`GLib`.test_run] would run the first "/foo"
         * suite, then the "/bar" suite, then the second "/foo" suite). As of
         * 2.36, this bug is fixed, and adding the tests in that order would
         * result in a running order of "/foo/simple", "/foo/using-bar",
         * "/bar/simple". If this new ordering is sub-optimal (because it puts
         * more-complicated tests before simpler ones, making it harder to
         * figure out exactly what has failed), you can fix it by changing the
         * test paths to group tests by suite in a way that will result in the
         * desired running order. Eg, "/simple/foo", "/simple/bar",
         * "/complex/foo-using-bar".
         *
         * However, you should never make the actual result of a test depend
         * on the order that tests are run in. If you need to ensure that some
         * particular code runs before or after a given test case, use
         * [func`GLib`.test_add], which lets you specify setup and teardown functions.
         *
         * If all tests are skipped or marked as incomplete (expected failures),
         * this function will return 0 if producing TAP output, or 77 (treated
         * as "skip test" by Automake) otherwise.
         * @returns 0 on success, 1 on failure (assuming it returns at all),   0 or 77 if all tests were skipped or marked as incomplete
         */
        function test_run(): number;
        /**
         * Executes the tests within `suite` and all nested test suites.
         *
         * The test suites to be executed are filtered according to
         * test path arguments (`-p testpath` and `-s testpath`) as parsed by
         * [func`GLib`.test_init]. See the [func`GLib`.test_run] documentation
         * for more information on the order that tests are run in.
         *
         * [func`GLib`.test_run_suite] or [func`GLib`.test_run] may only be
         * called once in a program.
         * @param suite a test suite
         * @returns 0 on success
         */
        function test_run_suite(suite: TestSuite): number;
        /**
         * Changes the behaviour of the various assertion macros.
         *
         * The `g_assert_*()` macros, `g_test_assert_expected_messages()`
         * and the various `g_test_trap_assert_*()` macros are changed
         * to not abort to program.
         *
         * Instead, they will call [func`GLib`.test_fail] and continue.
         * (This also changes the behavior of [func`GLib`.test_fail] so that
         * it will not cause the test program to abort after completing
         * the failed test.)
         *
         * Note that the [func`GLib`.assert_not_reached] and [func`GLib`.assert]
         * macros are not affected by this.
         *
         * This function can only be called after [func`GLib`.test_init].
         */
        function test_set_nonfatal_assertions(): void;
        /**
         * Indicates that a test was skipped.
         *
         * Calling this function will not stop the test from running, you
         * need to return from the test function yourself. So you can
         * produce additional diagnostic messages or even continue running
         * the test.
         *
         * If not called from inside a test, this function does nothing.
         * @param msg explanation
         */
        function test_skip(msg?: string | null): void;
        /**
         * Returns true if the test program is running under [func`GLib`.test_trap_subprocess].
         * @returns true if the test program is running under [func@GLib.test_trap_subprocess]
         */
        function test_subprocess(): boolean;
        /**
         * Sets the summary for a test.
         *
         * This may be included in test report output, and is useful documentation for
         * anyone reading the source code or modifying a test in future. It must be a
         * single line, and it should summarise what the test checks, and how.
         *
         * This should be called at the top of a test function.
         *
         * For example:
         *
         * ```c
         * static void
         * test_array_sort (void)
         * {
         *   g_test_summary ("Test my_array_sort() sorts the array correctly and stably, "
         *                   "including testing zero length and one-element arrays.");
         *
         *   // ...
         * }
         * ```
         *
         * See also [func`GLib`.test_bug].
         * @param summary summary of the test purpose
         */
        function test_summary(summary: string): void;
        /**
         * Gets the number of seconds since the last start of the timer with
         * [func`GLib`.test_timer_start].
         * @returns the time since the last start of the timer in seconds
         */
        function test_timer_elapsed(): number;
        /**
         * Reports the last result of [func`GLib`.test_timer_elapsed].
         * @returns the last result of [func@GLib.test_timer_elapsed]
         */
        function test_timer_last(): number;
        /**
         * Starts a timing test.
         *
         * Call [func`GLib`.test_timer_elapsed] when the task is supposed
         * to be done. Call this function again to restart the timer.
         */
        function test_timer_start(): void;
        function test_trap_assertions(
            domain: string,
            file: string,
            line: number,
            func: string,
            assertion_flags: number,
            pattern: string,
        ): void;
        /**
         * Forks the current test program to execute a test case that might
         * not return or that might abort.
         *
         * If `usec_timeout` is non-0, the forked test case is aborted and
         * considered failing if its run time exceeds it.
         *
         * The forking behavior can be configured with [flags`GLib`.TestTrapFlags]
         * flags.
         *
         * In the following example, the test code forks, the forked child
         * process produces some sample output and exits successfully.
         * The forking parent process then asserts successful child program
         * termination and validates child program outputs.
         *
         * ```c
         *   static void
         *   test_fork_patterns (void)
         *   {
         *     if (g_test_trap_fork (0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR))
         *       {
         *         g_print ("some stdout text: somagic17
         * ");
         *         g_printerr ("some stderr text: semagic43
         * ");
         *         exit (0); // successful test run
         *       }
         *     g_test_trap_assert_passed ();
         *     g_test_trap_assert_stdout ("*somagic17*");
         *     g_test_trap_assert_stderr ("*semagic43*");
         *   }
         * ```
         * @param usec_timeout timeout for the forked test in microseconds
         * @param test_trap_flags flags to modify forking behaviour
         * @returns true for the forked child and false for the executing parent process.
         */
        function test_trap_fork(usec_timeout: number, test_trap_flags: TestTrapFlags | null): boolean;
        /**
         * Checks the result of the last [func`GLib`.test_trap_subprocess] call.
         * @returns true if the last test subprocess terminated successfully
         */
        function test_trap_has_passed(): boolean;
        /**
         * Checks the result of the last [func`GLib`.test_trap_subprocess] call.
         * @returns true if the last test subprocess got killed due to a timeout
         */
        function test_trap_reached_timeout(): boolean;
        /**
         * Respawns the test program to run only `test_path` in a subprocess.
         *
         * This is equivalent to calling [func`GLib`.test_trap_subprocess_with_envp]
         * with `envp` set to `NULL`. See the documentation for that function
         * for full details.
         * @param test_path test to run in a subprocess
         * @param usec_timeout timeout for the subprocess test in microseconds.
         * @param test_flags flags to modify subprocess behaviour
         */
        function test_trap_subprocess(
            test_path: string | null,
            usec_timeout: number,
            test_flags: TestSubprocessFlags | null,
        ): void;
        /**
         * Respawns the test program to run only `test_path` in a subprocess with
         * a given environment.
         *
         * This can be used for a test case that might not return, or that
         * might abort.
         *
         * If `test_path` is `NULL` then the same test is re-run in a subprocess.
         * You can use [func`GLib`.test_subprocess] to determine whether the test
         * is in a subprocess or not.
         *
         * `test_path` can also be the name of the parent test, followed by
         * "`/subprocess/`" and then a name for the specific subtest (or just
         * ending with "`/subprocess`" if the test only has one child test);
         * tests with names of this form will automatically be skipped in the
         * parent process.
         *
         * If `envp` is `NULL`, the parent process’ environment will be inherited.
         *
         * If `usec_timeout` is non-0, the test subprocess is aborted and
         * considered failing if its run time exceeds it.
         *
         * The subprocess behavior can be configured with [flags`GLib`.TestSubprocessFlags]
         * flags.
         *
         * You can use methods such as [func`GLib`.test_trap_assert_passed],
         * [func`GLib`.test_trap_assert_failed], and [func`GLib`.test_trap_assert_stderr] to
         * check the results of the subprocess. (But note that
         * [func`GLib`.test_trap_assert_stdout] and [func`GLib`.test_trap_assert_stderr]
         * cannot be used if `test_flags` specifies that the child should
         * inherit the parent stdout/stderr.)
         *
         * If your `main ()` needs to behave differently in the subprocess, you can
         * call [func`GLib`.test_subprocess] (after calling [func`GLib`.test_init])
         * to see whether you are in a subprocess.
         *
         * Internally, this function tracks the child process using
         * [func`GLib`.child_watch_source_new], so your process must not ignore
         * `SIGCHLD`, and must not attempt to watch or wait for the child process
         * via another mechanism.
         *
         * The following example tests that calling `my_object_new(1000000)` will
         * abort with an error message.
         *
         * ```c
         *   static void
         *   test_create_large_object (void)
         *   {
         *     if (g_test_subprocess ())
         *       {
         *         my_object_new (1000000);
         *         return;
         *       }
         *
         *     // Reruns this same test in a subprocess
         *     g_test_trap_subprocess (NULL, 0, G_TEST_SUBPROCESS_DEFAULT);
         *     g_test_trap_assert_failed ();
         *     g_test_trap_assert_stderr ("*ERROR*too large*");
         *   }
         *
         *   static void
         *   test_different_username (void)
         *   {
         *     if (g_test_subprocess ())
         *       {
         *         // Code under test goes here
         *         g_message ("Username is now simulated as %s", g_getenv ("USER"));
         *         return;
         *       }
         *
         *     // Reruns this same test in a subprocess
         *     g_autoptr(GStrv) envp = g_get_environ ();
         *     envp = g_environ_setenv (g_steal_pointer (&envp), "USER", "charlie", TRUE);
         *     g_test_trap_subprocess_with_envp (NULL, envp, 0, G_TEST_SUBPROCESS_DEFAULT);
         *     g_test_trap_assert_passed ();
         *     g_test_trap_assert_stdout ("Username is now simulated as charlie");
         *   }
         *
         *   int
         *   main (int argc, char **argv)
         *   {
         *     g_test_init (&argc, &argv, NULL);
         *
         *     g_test_add_func ("/myobject/create-large-object",
         *                      test_create_large_object);
         *     g_test_add_func ("/myobject/different-username",
         *                      test_different_username);
         *     return g_test_run ();
         *   }
         * ```
         * @param test_path test to run in a subprocess
         * @param envp environment   to run the test in
         * @param usec_timeout timeout for the subprocess test in microseconds
         * @param test_flags flags to modify subprocess behaviour
         */
        function test_trap_subprocess_with_envp(
            test_path: string | null,
            envp: string[] | null,
            usec_timeout: number,
            test_flags: TestSubprocessFlags | null,
        ): void;
        function thread_error_quark(): Quark;
        /**
         * Terminates the current thread.
         *
         * If another thread is waiting for us using g_thread_join() then the
         * waiting thread will be woken up and get `retval` as the return value
         * of g_thread_join().
         *
         * Calling g_thread_exit() with a parameter `retval` is equivalent to
         * returning `retval` from the function `func,` as given to g_thread_new().
         *
         * You must only call g_thread_exit() from a thread that you created
         * yourself with g_thread_new() or related APIs. You must not call
         * this function from a thread created with another threading library
         * or or from within a #GThreadPool.
         * @param retval the return value of this thread
         */
        function thread_exit(retval?: any | null): void;
        /**
         * This function will return the maximum `interval` that a
         * thread will wait in the thread pool for new tasks before
         * being stopped.
         *
         * If this function returns 0, threads waiting in the thread
         * pool for new work are not stopped.
         * @returns the maximum @interval (milliseconds) to wait     for new tasks in the thread pool before stopping the     thread
         */
        function thread_pool_get_max_idle_time(): number;
        /**
         * Returns the maximal allowed number of unused threads.
         * @returns the maximal number of unused threads
         */
        function thread_pool_get_max_unused_threads(): number;
        /**
         * Returns the number of currently unused threads.
         * @returns the number of currently unused threads
         */
        function thread_pool_get_num_unused_threads(): number;
        /**
         * This function will set the maximum `interval` that a thread
         * waiting in the pool for new tasks can be idle for before
         * being stopped. This function is similar to calling
         * g_thread_pool_stop_unused_threads() on a regular timeout,
         * except this is done on a per thread basis.
         *
         * By setting `interval` to 0, idle threads will not be stopped.
         *
         * The default value is 15000 (15 seconds).
         * @param interval the maximum @interval (in milliseconds)     a thread can be idle
         */
        function thread_pool_set_max_idle_time(interval: number): void;
        /**
         * Sets the maximal number of unused threads to `max_threads`.
         * If `max_threads` is -1, no limit is imposed on the number
         * of unused threads.
         *
         * The default value is 8 since GLib 2.84. Previously the default value was 2.
         * @param max_threads maximal number of unused threads
         */
        function thread_pool_set_max_unused_threads(max_threads: number): void;
        /**
         * Stops all currently unused threads. This does not change the
         * maximal number of unused threads. This function can be used to
         * regularly stop all unused threads e.g. from g_timeout_add().
         */
        function thread_pool_stop_unused_threads(): void;
        /**
         * This function returns the #GThread corresponding to the
         * current thread. Note that this function does not increase
         * the reference count of the returned struct.
         *
         * This function will return a #GThread even for threads that
         * were not created by GLib (i.e. those created by other threading
         * APIs). This may be useful for thread identification purposes
         * (i.e. comparisons) but you must not use GLib functions (such
         * as g_thread_join()) on these threads.
         * @returns the #GThread representing the current thread
         */
        function thread_self(): Thread;
        /**
         * Causes the calling thread to voluntarily relinquish the CPU, so
         * that other threads can run.
         *
         * This function is often used as a method to make busy wait less evil.
         */
        function thread_yield(): void;
        /**
         * Converts a string containing an ISO 8601 encoded date and time
         * to a #GTimeVal and puts it into `time_`.
         *
         * `iso_date` must include year, month, day, hours, minutes, and
         * seconds. It can optionally include fractions of a second and a time
         * zone indicator. (In the absence of any time zone indication, the
         * timestamp is assumed to be in local time.)
         *
         * Any leading or trailing space in `iso_date` is ignored.
         *
         * This function was deprecated, along with #GTimeVal itself, in GLib 2.62.
         * Equivalent functionality is available using code like:
         *
         * ```
         * GDateTime *dt = g_date_time_new_from_iso8601 (iso8601_string, NULL);
         * gint64 time_val = g_date_time_to_unix (dt);
         * g_date_time_unref (dt);
         * ```
         *
         * @param iso_date an ISO 8601 encoded date string
         * @returns %TRUE if the conversion was successful.
         */
        function time_val_from_iso8601(iso_date: string): [boolean, TimeVal];
        /**
         * Sets a function to be called at regular intervals, with the given
         * priority.  The function is called repeatedly until it returns
         * %FALSE, at which point the timeout is automatically destroyed and
         * the function will not be called again.  The `notify` function is
         * called when the timeout is destroyed.  The first call to the
         * function will be at the end of the first `interval`.
         *
         * Note that timeout functions may be delayed, due to the processing of other
         * event sources. Thus they should not be relied on for precise timing.
         * After each call to the timeout function, the time of the next
         * timeout is recalculated based on the current time and the given interval
         * (it does not try to 'catch up' time lost in delays).
         *
         * See [mainloop memory management](main-loop.html#memory-management-of-sources) for details
         * on how to handle the return value and memory management of `data`.
         *
         * This internally creates a main loop source using
         * [func`GLib`.timeout_source_new] and attaches it to the global
         * [struct`GLib`.MainContext] using [method`GLib`.Source.attach], so the callback
         * will be invoked in whichever thread is running that main context. You can do
         * these steps manually if you need greater control or to use a custom main
         * context.
         *
         * The interval given is in terms of monotonic time, not wall clock time.
         * See [func`GLib`.get_monotonic_time].
         * @param priority the priority of the timeout source. Typically this will be in   the range between [const@GLib.PRIORITY_DEFAULT] and   [const@GLib.PRIORITY_HIGH].
         * @param interval the time between calls to the function, in milliseconds   (1/1000ths of a second)
         * @param _function function to call
         * @param notify function to call when the timeout is removed, or %NULL
         * @returns the ID (greater than 0) of the event source.
         */
        function timeout_add(
            priority: number,
            interval: number,
            _function: SourceFunc,
            notify?: DestroyNotify | null,
        ): number;
        /**
         * Sets a function to be called at regular intervals, with `priority`.
         *
         * The function is called repeatedly until it returns [const`GLib`.SOURCE_REMOVE]
         * or %FALSE, at which point the timeout is automatically destroyed and
         * the function will not be called again.
         *
         * Unlike [func`GLib`.timeout_add], this function operates at whole second
         * granularity. The initial starting point of the timer is determined by the
         * implementation and the implementation is expected to group multiple timers
         * together so that they fire all at the same time. To allow this grouping, the
         * `interval` to the first timer is rounded and can deviate up to one second
         * from the specified interval. Subsequent timer iterations will generally run
         * at the specified interval.
         *
         * Note that timeout functions may be delayed, due to the processing of other
         * event sources. Thus they should not be relied on for precise timing.
         * After each call to the timeout function, the time of the next
         * timeout is recalculated based on the current time and the given `interval`
         *
         * See [mainloop memory management](main-loop.html#memory-management-of-sources) for details
         * on how to handle the return value and memory management of `data`.
         *
         * If you want timing more precise than whole seconds, use
         * [func`GLib`.timeout_add] instead.
         *
         * The grouping of timers to fire at the same time results in a more power
         * and CPU efficient behavior so if your timer is in multiples of seconds
         * and you don't require the first timer exactly one second from now, the
         * use of [func`GLib`.timeout_add_seconds] is preferred over
         * [func`GLib`.timeout_add].
         *
         * This internally creates a main loop source using
         * [func`GLib`.timeout_source_new_seconds] and attaches it to the main loop
         * context using [method`GLib`.Source.attach]. You can do these steps manually
         * if you need greater control.
         *
         * It is safe to call this function from any thread.
         *
         * The interval given is in terms of monotonic time, not wall clock
         * time. See [func`GLib`.get_monotonic_time].
         * @param priority the priority of the timeout source. Typically this will be in   the range between [const@GLib.PRIORITY_DEFAULT] and   [const@GLib.PRIORITY_HIGH].
         * @param interval the time between calls to the function, in seconds
         * @param _function function to call
         * @param notify function to call when the timeout is removed, or %NULL
         * @returns the ID (greater than 0) of the event source.
         */
        function timeout_add_seconds(
            priority: number,
            interval: number,
            _function: SourceFunc,
            notify?: DestroyNotify | null,
        ): number;
        /**
         * Creates a new timeout source.
         *
         * The source will not initially be associated with any [struct`GLib`.MainContext]
         * and must be added to one with [method`GLib`.Source.attach] before it will be
         * executed.
         *
         * The interval given is in terms of monotonic time, not wall clock
         * time.  See [func`GLib`.get_monotonic_time].
         * @param interval the timeout interval in milliseconds.
         * @returns the newly-created timeout source
         */
        function timeout_source_new(interval: number): Source;
        /**
         * Creates a new timeout source.
         *
         * The source will not initially be associated with any
         * [struct`GLib`.MainContext] and must be added to one with
         * [method`GLib`.Source.attach] before it will be executed.
         *
         * The scheduling granularity/accuracy of this timeout source will be
         * in seconds.
         *
         * The interval given is in terms of monotonic time, not wall clock time.
         * See [func`GLib`.get_monotonic_time].
         * @param interval the timeout interval in seconds
         * @returns the newly-created timeout source
         */
        function timeout_source_new_seconds(interval: number): Source;
        /**
         * Returns the height of a #GTrashStack.
         *
         * Note that execution of this function is of O(N) complexity
         * where N denotes the number of items on the stack.
         * @param stack_p a #GTrashStack
         * @returns the height of the stack
         */
        function trash_stack_height(stack_p: TrashStack): number;
        /**
         * Returns the element at the top of a #GTrashStack
         * which may be %NULL.
         * @param stack_p a #GTrashStack
         * @returns the element at the top of the stack
         */
        function trash_stack_peek(stack_p: TrashStack): any | null;
        /**
         * Pops a piece of memory off a #GTrashStack.
         * @param stack_p a #GTrashStack
         * @returns the element at the top of the stack
         */
        function trash_stack_pop(stack_p: TrashStack): any | null;
        /**
         * Pushes a piece of memory onto a #GTrashStack.
         * @param stack_p a #GTrashStack
         * @param data_p the piece of memory to push on the stack
         */
        function trash_stack_push(stack_p: TrashStack, data_p: any): void;
        /**
         * Attempts to allocate `n_bytes,` and returns %NULL on failure.
         * Contrast with g_malloc(), which aborts the program on failure.
         * @param n_bytes number of bytes to allocate.
         * @returns the allocated memory, or %NULL.
         */
        function try_malloc(n_bytes: number): any | null;
        /**
         * Attempts to allocate `n_bytes,` initialized to 0's, and returns %NULL on
         * failure. Contrast with g_malloc0(), which aborts the program on failure.
         * @param n_bytes number of bytes to allocate
         * @returns the allocated memory, or %NULL
         */
        function try_malloc0(n_bytes: number): any | null;
        /**
         * This function is similar to g_try_malloc0(), allocating (`n_blocks` * `n_block_bytes)` bytes,
         * but care is taken to detect possible overflow during multiplication.
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @returns the allocated memory, or %NULL
         */
        function try_malloc0_n(n_blocks: number, n_block_bytes: number): any | null;
        /**
         * This function is similar to g_try_malloc(), allocating (`n_blocks` * `n_block_bytes)` bytes,
         * but care is taken to detect possible overflow during multiplication.
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @returns the allocated memory, or %NULL.
         */
        function try_malloc_n(n_blocks: number, n_block_bytes: number): any | null;
        /**
         * Attempts to realloc `mem` to a new size, `n_bytes,` and returns %NULL
         * on failure. Contrast with g_realloc(), which aborts the program
         * on failure.
         *
         * If `mem` is %NULL, behaves the same as g_try_malloc().
         * @param mem previously-allocated memory, or %NULL.
         * @param n_bytes number of bytes to allocate.
         * @returns the allocated memory, or %NULL.
         */
        function try_realloc(mem: any | null, n_bytes: number): any | null;
        /**
         * This function is similar to g_try_realloc(), allocating (`n_blocks` * `n_block_bytes)` bytes,
         * but care is taken to detect possible overflow during multiplication.
         * @param mem previously-allocated memory, or %NULL.
         * @param n_blocks the number of blocks to allocate
         * @param n_block_bytes the size of each block in bytes
         * @returns the allocated memory, or %NULL.
         */
        function try_realloc_n(mem: any | null, n_blocks: number, n_block_bytes: number): any | null;
        /**
         * Convert a string from UCS-4 to UTF-16.
         *
         * A nul character (U+0000) will be added to the result after the converted text.
         * @param str a UCS-4 encoded string
         * @returns a pointer to a newly allocated UTF-16 string.   This value must be freed with [func@GLib.free].
         */
        function ucs4_to_utf16(str: number[]): [number, number, number];
        /**
         * Convert a string from a 32-bit fixed width representation as UCS-4.
         * to UTF-8.
         *
         * The result will be terminated with a nul byte.
         * @param str a UCS-4 encoded string
         * @returns a pointer to a newly allocated UTF-8 string.   This value must be freed with [func@GLib.free]. If an error occurs,   @items_read will be set to the position of the first invalid input   character.
         */
        function ucs4_to_utf8(str: number[]): [string, number, number];
        /**
         * Determines the break type of `c`. `c` should be a Unicode character
         * (to derive a character from UTF-8 encoded text, use
         * g_utf8_get_char()). The break type is used to find word and line
         * breaks ("text boundaries"), Pango implements the Unicode boundary
         * resolution algorithms and normally you would use a function such
         * as pango_break() instead of caring about break types yourself.
         * @param c a Unicode character
         * @returns the break type of @c
         */
        function unichar_break_type(c: number): UnicodeBreakType;
        /**
         * Determines the canonical combining class of a Unicode character.
         * @param uc a Unicode character
         * @returns the combining class of the character
         */
        function unichar_combining_class(uc: number): number;
        /**
         * Performs a single composition step of the
         * Unicode canonical composition algorithm.
         *
         * This function includes algorithmic Hangul Jamo composition,
         * but it is not exactly the inverse of g_unichar_decompose().
         * No composition can have either of `a` or `b` equal to zero.
         * To be precise, this function composes if and only if
         * there exists a Primary Composite P which is canonically
         * equivalent to the sequence <`a,``b>`.  See the Unicode
         * Standard for the definition of Primary Composite.
         *
         * If `a` and `b` do not compose a new character, `ch` is set to zero.
         *
         * See
         * [UAX#15](http://unicode.org/reports/tr15/)
         * for details.
         * @param a a Unicode character
         * @param b a Unicode character
         * @returns %TRUE if the characters could be composed
         */
        function unichar_compose(a: number, b: number): [boolean, number];
        /**
         * Performs a single decomposition step of the
         * Unicode canonical decomposition algorithm.
         *
         * This function does not include compatibility
         * decompositions. It does, however, include algorithmic
         * Hangul Jamo decomposition, as well as 'singleton'
         * decompositions which replace a character by a single
         * other character. In the case of singletons `*b` will
         * be set to zero.
         *
         * If `ch` is not decomposable, `*a` is set to `ch` and `*b`
         * is set to zero.
         *
         * Note that the way Unicode decomposition pairs are
         * defined, it is guaranteed that `b` would not decompose
         * further, but `a` may itself decompose.  To get the full
         * canonical decomposition for `ch,` one would need to
         * recursively call this function on `a`.  Or use
         * g_unichar_fully_decompose().
         *
         * See
         * [UAX#15](http://unicode.org/reports/tr15/)
         * for details.
         * @param ch a Unicode character
         * @returns %TRUE if the character could be decomposed
         */
        function unichar_decompose(ch: number): [boolean, number, number];
        /**
         * Determines the numeric value of a character as a decimal
         * digit.
         * @param c a Unicode character
         * @returns If @c is a decimal digit (according to g_unichar_isdigit()), its numeric value. Otherwise, -1.
         */
        function unichar_digit_value(c: number): number;
        /**
         * Computes the canonical or compatibility decomposition of a
         * Unicode character.  For compatibility decomposition,
         * pass %TRUE for `compat;` for canonical decomposition
         * pass %FALSE for `compat`.
         *
         * The decomposed sequence is placed in `result`.  Only up to
         * `result_len` characters are written into `result`.  The length
         * of the full decomposition (irrespective of `result_len)` is
         * returned by the function.  For canonical decomposition,
         * currently all decompositions are of length at most 4, but
         * this may change in the future (very unlikely though).
         * At any rate, Unicode does guarantee that a buffer of length
         * 18 is always enough for both compatibility and canonical
         * decompositions, so that is the size recommended. This is provided
         * as %G_UNICHAR_MAX_DECOMPOSITION_LENGTH.
         *
         * See
         * [UAX#15](http://unicode.org/reports/tr15/)
         * for details.
         * @param ch a Unicode character.
         * @param compat whether perform canonical or compatibility decomposition
         * @param result_len length of @result
         * @returns the length of the full decomposition.
         */
        function unichar_fully_decompose(ch: number, compat: boolean, result_len: number): [number, number];
        /**
         * In Unicode, some characters are "mirrored". This means that their
         * images are mirrored horizontally in text that is laid out from right
         * to left. For instance, "(" would become its mirror image, ")", in
         * right-to-left text.
         *
         * If `ch` has the Unicode mirrored property and there is another unicode
         * character that typically has a glyph that is the mirror image of `ch'`s
         * glyph and `mirrored_ch` is set, it puts that character in the address
         * pointed to by `mirrored_ch`.  Otherwise the original character is put.
         * @param ch a Unicode character
         * @returns %TRUE if @ch has a mirrored character, %FALSE otherwise
         */
        function unichar_get_mirror_char(ch: number): [boolean, number];
        /**
         * Looks up the #GUnicodeScript for a particular character (as defined
         * by Unicode Standard Annex \#24). No check is made for `ch` being a
         * valid Unicode character; if you pass in invalid character, the
         * result is undefined.
         *
         * This function is equivalent to pango_script_for_unichar() and the
         * two are interchangeable.
         * @param ch a Unicode character
         * @returns the #GUnicodeScript for the character.
         */
        function unichar_get_script(ch: number): UnicodeScript;
        /**
         * Determines whether a character is alphanumeric.
         * Given some UTF-8 text, obtain a character value
         * with g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is an alphanumeric character
         */
        function unichar_isalnum(c: number): boolean;
        /**
         * Determines whether a character is alphabetic (i.e. a letter).
         * Given some UTF-8 text, obtain a character value with
         * g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is an alphabetic character
         */
        function unichar_isalpha(c: number): boolean;
        /**
         * Determines whether a character is a control character.
         * Given some UTF-8 text, obtain a character value with
         * g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is a control character
         */
        function unichar_iscntrl(c: number): boolean;
        /**
         * Determines if a given character is assigned in the Unicode
         * standard.
         * @param c a Unicode character
         * @returns %TRUE if the character has an assigned value
         */
        function unichar_isdefined(c: number): boolean;
        /**
         * Determines whether a character is numeric (i.e. a digit).  This
         * covers ASCII 0-9 and also digits in other languages/scripts.  Given
         * some UTF-8 text, obtain a character value with g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is a digit
         */
        function unichar_isdigit(c: number): boolean;
        /**
         * Determines whether a character is printable and not a space
         * (returns %FALSE for control characters, format characters, and
         * spaces). g_unichar_isprint() is similar, but returns %TRUE for
         * spaces. Given some UTF-8 text, obtain a character value with
         * g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is printable unless it's a space
         */
        function unichar_isgraph(c: number): boolean;
        /**
         * Determines whether a character is a lowercase letter.
         * Given some UTF-8 text, obtain a character value with
         * g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is a lowercase letter
         */
        function unichar_islower(c: number): boolean;
        /**
         * Determines whether a character is a mark (non-spacing mark,
         * combining mark, or enclosing mark in Unicode speak).
         * Given some UTF-8 text, obtain a character value
         * with g_utf8_get_char().
         *
         * Note: in most cases where isalpha characters are allowed,
         * ismark characters should be allowed to as they are essential
         * for writing most European languages as well as many non-Latin
         * scripts.
         * @param c a Unicode character
         * @returns %TRUE if @c is a mark character
         */
        function unichar_ismark(c: number): boolean;
        /**
         * Determines whether a character is printable.
         * Unlike g_unichar_isgraph(), returns %TRUE for spaces.
         * Given some UTF-8 text, obtain a character value with
         * g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is printable
         */
        function unichar_isprint(c: number): boolean;
        /**
         * Determines whether a character is punctuation or a symbol.
         * Given some UTF-8 text, obtain a character value with
         * g_utf8_get_char().
         * @param c a Unicode character
         * @returns %TRUE if @c is a punctuation or symbol character
         */
        function unichar_ispunct(c: number): boolean;
        /**
         * Determines whether a character is a space, tab, or line separator
         * (newline, carriage return, etc.).  Given some UTF-8 text, obtain a
         * character value with g_utf8_get_char().
         *
         * (Note: don't use this to do word breaking; you have to use
         * Pango or equivalent to get word breaking right, the algorithm
         * is fairly complex.)
         * @param c a Unicode character
         * @returns %TRUE if @c is a space character
         */
        function unichar_isspace(c: number): boolean;
        /**
         * Determines if a character is titlecase. Some characters in
         * Unicode which are composites, such as the DZ digraph
         * have three case variants instead of just two. The titlecase
         * form is used at the beginning of a word where only the
         * first letter is capitalized. The titlecase form of the DZ
         * digraph is U+01F2 LATIN CAPITAL LETTTER D WITH SMALL LETTER Z.
         * @param c a Unicode character
         * @returns %TRUE if the character is titlecase
         */
        function unichar_istitle(c: number): boolean;
        /**
         * Determines if a character is uppercase.
         * @param c a Unicode character
         * @returns %TRUE if @c is an uppercase character
         */
        function unichar_isupper(c: number): boolean;
        /**
         * Determines if a character is typically rendered in a double-width
         * cell.
         * @param c a Unicode character
         * @returns %TRUE if the character is wide
         */
        function unichar_iswide(c: number): boolean;
        /**
         * Determines if a character is typically rendered in a double-width
         * cell under legacy East Asian locales.  If a character is wide according to
         * g_unichar_iswide(), then it is also reported wide with this function, but
         * the converse is not necessarily true. See the
         * [Unicode Standard Annex #11](http://www.unicode.org/reports/tr11/)
         * for details.
         *
         * If a character passes the g_unichar_iswide() test then it will also pass
         * this test, but not the other way around.  Note that some characters may
         * pass both this test and g_unichar_iszerowidth().
         * @param c a Unicode character
         * @returns %TRUE if the character is wide in legacy East Asian locales
         */
        function unichar_iswide_cjk(c: number): boolean;
        /**
         * Determines if a character is a hexadecimal digit.
         * @param c a Unicode character.
         * @returns %TRUE if the character is a hexadecimal digit
         */
        function unichar_isxdigit(c: number): boolean;
        /**
         * Determines if a given character typically takes zero width when rendered.
         * The return value is %TRUE for all non-spacing and enclosing marks
         * (e.g., combining accents), format characters, zero-width
         * space, but not U+00AD SOFT HYPHEN.
         *
         * A typical use of this function is with one of g_unichar_iswide() or
         * g_unichar_iswide_cjk() to determine the number of cells a string occupies
         * when displayed on a grid display (terminals).  However, note that not all
         * terminals support zero-width rendering of zero-width marks.
         * @param c a Unicode character
         * @returns %TRUE if the character has zero width
         */
        function unichar_iszerowidth(c: number): boolean;
        /**
         * Converts a single character to UTF-8.
         * @param c a Unicode character code
         * @returns number of bytes written
         */
        function unichar_to_utf8(c: number): [number, string];
        /**
         * Converts a character to lower case.
         * @param c a Unicode character.
         * @returns the result of converting @c to lower case.               If @c is not an upperlower or titlecase character,               or has no lowercase equivalent @c is returned unchanged.
         */
        function unichar_tolower(c: number): number;
        /**
         * Converts a character to the titlecase.
         * @param c a Unicode character
         * @returns the result of converting @c to titlecase.               If @c is not an uppercase or lowercase character,               @c is returned unchanged.
         */
        function unichar_totitle(c: number): number;
        /**
         * Converts a character to uppercase.
         * @param c a Unicode character
         * @returns the result of converting @c to uppercase.               If @c is not a lowercase or titlecase character,               or has no upper case equivalent @c is returned unchanged.
         */
        function unichar_toupper(c: number): number;
        /**
         * Classifies a Unicode character by type.
         * @param c a Unicode character
         * @returns the type of the character.
         */
        function unichar_type(c: number): UnicodeType;
        /**
         * Checks whether `ch` is a valid Unicode character.
         *
         * Some possible integer values of `ch` will not be valid. U+0000 is considered a
         * valid character, though it’s normally a string terminator.
         * @param ch a Unicode character
         * @returns `TRUE` if @ch is a valid Unicode character
         */
        function unichar_validate(ch: number): boolean;
        /**
         * Determines the numeric value of a character as a hexadecimal
         * digit.
         * @param c a Unicode character
         * @returns If @c is a hex digit (according to g_unichar_isxdigit()), its numeric value. Otherwise, -1.
         */
        function unichar_xdigit_value(c: number): number;
        /**
         * Computes the canonical decomposition of a Unicode character.
         * @param ch a Unicode character.
         * @param result_len location to store the length of the return value.
         * @returns a newly allocated string of Unicode characters.   @result_len is set to the resulting length of the string.
         */
        function unicode_canonical_decomposition(ch: number, result_len: number): number;
        /**
         * Computes the canonical ordering of a string in-place.
         * This rearranges decomposed characters in the string
         * according to their combining classes.  See the Unicode
         * manual for more information.
         * @param string a UCS-4 encoded string.
         */
        function unicode_canonical_ordering(string: number[]): void;
        /**
         * Looks up the Unicode script for `iso1`5924.  ISO 15924 assigns four-letter
         * codes to scripts.  For example, the code for Arabic is 'Arab'.
         * This function accepts four letter codes encoded as a `guint3`2 in a
         * big-endian fashion.  That is, the code expected for Arabic is
         * 0x41726162 (0x41 is ASCII code for 'A', 0x72 is ASCII code for 'r', etc).
         *
         * See
         * [Codes for the representation of names of scripts](http://unicode.org/iso15924/codelists.html)
         * for details.
         * @param iso15924 a Unicode script
         * @returns the Unicode script for @iso15924, or   of %G_UNICODE_SCRIPT_INVALID_CODE if @iso15924 is zero and   %G_UNICODE_SCRIPT_UNKNOWN if @iso15924 is unknown.
         */
        function unicode_script_from_iso15924(iso15924: number): UnicodeScript;
        /**
         * Looks up the ISO 15924 code for `script`.  ISO 15924 assigns four-letter
         * codes to scripts.  For example, the code for Arabic is 'Arab'.  The
         * four letter codes are encoded as a `guint3`2 by this function in a
         * big-endian fashion.  That is, the code returned for Arabic is
         * 0x41726162 (0x41 is ASCII code for 'A', 0x72 is ASCII code for 'r', etc).
         *
         * See
         * [Codes for the representation of names of scripts](http://unicode.org/iso15924/codelists.html)
         * for details.
         * @param script a Unicode script
         * @returns the ISO 15924 code for @script, encoded as an integer,   of zero if @script is %G_UNICODE_SCRIPT_INVALID_CODE or   ISO 15924 code 'Zzzz' (script code for UNKNOWN) if @script is not understood.
         */
        function unicode_script_to_iso15924(script: UnicodeScript | null): number;
        function unix_error_quark(): Quark;
        /**
         * Sets a function to be called when the IO condition, as specified by
         * `condition` becomes true for `fd`.
         *
         * This is the same as g_unix_fd_add(), except that it allows you to
         * specify a non-default priority and a provide a #GDestroyNotify for
         * `user_data`.
         * @param priority the priority of the source
         * @param fd a file descriptor
         * @param condition IO conditions to watch for on @fd
         * @param _function a #GUnixFDSourceFunc
         * @returns the ID (greater than 0) of the event source
         */
        function unix_fd_add_full(
            priority: number,
            fd: number,
            condition: IOCondition | null,
            _function: UnixFDSourceFunc,
        ): number;
        /**
         * Creates a #GSource to watch for a particular I/O condition on a file
         * descriptor.
         *
         * The source will never close the `fd` — you must do it yourself.
         *
         * Any callback attached to the returned #GSource must have type
         * #GUnixFDSourceFunc.
         * @param fd a file descriptor
         * @param condition I/O conditions to watch for on @fd
         * @returns the newly created #GSource
         */
        function unix_fd_source_new(fd: number, condition: IOCondition | null): Source;
        /**
         * Get the `passwd` file entry for the given `user_name` using `getpwnam_r()`.
         * This can fail if the given `user_name` doesn’t exist.
         *
         * The returned `struct passwd` has been allocated using g_malloc() and should
         * be freed using g_free(). The strings referenced by the returned struct are
         * included in the same allocation, so are valid until the `struct passwd` is
         * freed.
         *
         * This function is safe to call from multiple threads concurrently.
         *
         * You will need to include `pwd.h` to get the definition of `struct passwd`.
         * @param user_name the username to get the passwd file entry for
         * @returns passwd entry, or %NULL on error; free the returned    value with g_free()
         */
        function unix_get_passwd_entry(user_name: string): any | null;
        /**
         * Similar to the UNIX pipe() call, but on modern systems like Linux
         * uses the pipe2() system call, which atomically creates a pipe with
         * the configured flags.
         *
         * As of GLib 2.78, the supported flags are `O_CLOEXEC`/`FD_CLOEXEC` (see below)
         * and `O_NONBLOCK`. Prior to GLib 2.78, only `FD_CLOEXEC` was supported — if
         * you wanted to configure `O_NONBLOCK` then that had to be done separately with
         * `fcntl()`.
         *
         * Since GLib 2.80, the constants %G_UNIX_PIPE_END_READ and
         * %G_UNIX_PIPE_END_WRITE can be used as mnemonic indexes in `fds`.
         *
         * It is a programmer error to call this function with unsupported flags, and a
         * critical warning will be raised.
         *
         * As of GLib 2.78, it is preferred to pass `O_CLOEXEC` in, rather than
         * `FD_CLOEXEC`, as that matches the underlying `pipe()` API more closely. Prior
         * to 2.78, only `FD_CLOEXEC` was supported. Support for `FD_CLOEXEC` may be
         * deprecated and removed in future.
         * @param fds Array of two integers
         * @param flags Bitfield of file descriptor flags, as for fcntl()
         * @returns %TRUE on success, %FALSE if not (and errno will be set).
         */
        function unix_open_pipe(fds: number[], flags: number): boolean;
        /**
         * Control the non-blocking state of the given file descriptor,
         * according to `nonblock`. On most systems this uses %O_NONBLOCK, but
         * on some older ones may use %O_NDELAY.
         * @param fd A file descriptor
         * @param nonblock If %TRUE, set the descriptor to be non-blocking
         * @returns %TRUE if successful
         */
        function unix_set_fd_nonblocking(fd: number, nonblock: boolean): boolean;
        /**
         * A convenience function for g_unix_signal_source_new(), which
         * attaches to the default #GMainContext.  You can remove the watch
         * using g_source_remove().
         * @param priority the priority of the signal source. Typically this will be in            the range between %G_PRIORITY_DEFAULT and %G_PRIORITY_HIGH.
         * @param signum Signal number
         * @param handler Callback
         * @returns An ID (greater than 0) for the event source
         */
        function unix_signal_add(priority: number, signum: number, handler: SourceFunc): number;
        /**
         * Create a #GSource that will be dispatched upon delivery of the UNIX
         * signal `signum`.  In GLib versions before 2.36, only `SIGHUP`, `SIGINT`,
         * `SIGTERM` can be monitored.  In GLib 2.36, `SIGUSR1` and `SIGUSR2`
         * were added. In GLib 2.54, `SIGWINCH` was added.
         *
         * Note that unlike the UNIX default, all sources which have created a
         * watch will be dispatched, regardless of which underlying thread
         * invoked g_unix_signal_source_new().
         *
         * For example, an effective use of this function is to handle `SIGTERM`
         * cleanly; flushing any outstanding files, and then calling
         * g_main_loop_quit().  It is not safe to do any of this from a regular
         * UNIX signal handler; such a handler may be invoked while malloc() or
         * another library function is running, causing reentrancy issues if the
         * handler attempts to use those functions.  None of the GLib/GObject
         * API is safe against this kind of reentrancy.
         *
         * The interaction of this source when combined with native UNIX
         * functions like sigprocmask() is not defined.
         *
         * The source will not initially be associated with any #GMainContext
         * and must be added to one with g_source_attach() before it will be
         * executed.
         * @param signum A signal number
         * @returns A newly created #GSource
         */
        function unix_signal_source_new(signum: number): Source;
        /**
         * A wrapper for the POSIX unlink() function. The unlink() function
         * deletes a name from the filesystem. If this was the last link to the
         * file and no processes have it opened, the diskspace occupied by the
         * file is freed.
         *
         * See your C library manual for more details about unlink(). Note
         * that on Windows, it is in general not possible to delete files that
         * are open to some process, or mapped into memory.
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @returns 0 if the name was successfully deleted, -1 if an error    occurred
         */
        function unlink(filename: string): number;
        /**
         * Removes an environment variable from the environment.
         *
         * Note that on some systems, when variables are overwritten, the
         * memory used for the previous variables and its value isn't reclaimed.
         *
         * You should be mindful of the fact that environment variable handling
         * in UNIX is not thread-safe, and your program may crash if one thread
         * calls g_unsetenv() while another thread is calling getenv(). (And note
         * that many functions, such as gettext(), call getenv() internally.) This
         * function is only safe to use at the very start of your program, before
         * creating any other threads (or creating objects that create worker
         * threads of their own).
         *
         * If you need to set up the environment for a child process, you can
         * use g_get_environ() to get an environment array, modify that with
         * g_environ_setenv() and g_environ_unsetenv(), and then pass that
         * array directly to execvpe(), g_spawn_async(), or the like.
         * @param variable the environment variable to remove, must     not contain '='
         */
        function unsetenv(variable: string): void;
        /**
         * Creates a new #GUri from the given components according to `flags`.
         *
         * See also g_uri_build_with_user(), which allows specifying the
         * components of the "userinfo" separately.
         * @param flags flags describing how to build the #GUri
         * @param scheme the URI scheme
         * @param userinfo the userinfo component, or %NULL
         * @param host the host component, or %NULL
         * @param port the port, or `-1`
         * @param path the path component
         * @param query the query component, or %NULL
         * @param fragment the fragment, or %NULL
         * @returns a new #GUri
         */
        function uri_build(
            flags: UriFlags | null,
            scheme: string,
            userinfo: string | null,
            host: string | null,
            port: number,
            path: string,
            query?: string | null,
            fragment?: string | null,
        ): Uri;
        /**
         * Creates a new #GUri from the given components according to `flags`
         * (%G_URI_FLAGS_HAS_PASSWORD is added unconditionally). The `flags` must be
         * coherent with the passed values, in particular use `%`-encoded values with
         * %G_URI_FLAGS_ENCODED.
         *
         * In contrast to g_uri_build(), this allows specifying the components
         * of the ‘userinfo’ field separately. Note that `user` must be non-%NULL
         * if either `password` or `auth_params` is non-%NULL.
         * @param flags flags describing how to build the #GUri
         * @param scheme the URI scheme
         * @param user the user component of the userinfo, or %NULL
         * @param password the password component of the userinfo, or %NULL
         * @param auth_params the auth params of the userinfo, or %NULL
         * @param host the host component, or %NULL
         * @param port the port, or `-1`
         * @param path the path component
         * @param query the query component, or %NULL
         * @param fragment the fragment, or %NULL
         * @returns a new #GUri
         */
        function uri_build_with_user(
            flags: UriFlags | null,
            scheme: string,
            user: string | null,
            password: string | null,
            auth_params: string | null,
            host: string | null,
            port: number,
            path: string,
            query?: string | null,
            fragment?: string | null,
        ): Uri;
        function uri_error_quark(): Quark;
        /**
         * Escapes arbitrary data for use in a URI.
         *
         * Normally all characters that are not ‘unreserved’ (i.e. ASCII
         * alphanumerical characters plus dash, dot, underscore and tilde) are
         * escaped. But if you specify characters in `reserved_chars_allowed`
         * they are not escaped. This is useful for the ‘reserved’ characters
         * in the URI specification, since those are allowed unescaped in some
         * portions of a URI.
         *
         * Though technically incorrect, this will also allow escaping nul
         * bytes as `%``00`.
         * @param unescaped the unescaped input data.
         * @param reserved_chars_allowed a string of reserved   characters that are allowed to be used, or %NULL.
         * @returns an escaped version of @unescaped.     The returned string should be freed when no longer needed.
         */
        function uri_escape_bytes(unescaped: Uint8Array | string, reserved_chars_allowed?: string | null): string;
        /**
         * Escapes a string for use in a URI.
         *
         * Normally all characters that are not "unreserved" (i.e. ASCII
         * alphanumerical characters plus dash, dot, underscore and tilde) are
         * escaped. But if you specify characters in `reserved_chars_allowed`
         * they are not escaped. This is useful for the "reserved" characters
         * in the URI specification, since those are allowed unescaped in some
         * portions of a URI.
         * @param unescaped the unescaped input string.
         * @param reserved_chars_allowed a string of reserved   characters that are allowed to be used, or %NULL.
         * @param allow_utf8 %TRUE if the result can include UTF-8 characters.
         * @returns an escaped version of @unescaped. The returned string should be freed when no longer needed.
         */
        function uri_escape_string(
            unescaped: string,
            reserved_chars_allowed: string | null,
            allow_utf8: boolean,
        ): string;
        /**
         * Parses `uri_string` according to `flags,` to determine whether it is a valid
         * [absolute URI](#relative-and-absolute-uris), i.e. it does not need to be resolved
         * relative to another URI using g_uri_parse_relative().
         *
         * If it’s not a valid URI, an error is returned explaining how it’s invalid.
         *
         * See g_uri_split(), and the definition of #GUriFlags, for more
         * information on the effect of `flags`.
         * @param uri_string a string containing an absolute URI
         * @param flags flags for parsing @uri_string
         * @returns %TRUE if @uri_string is a valid absolute URI, %FALSE on error.
         */
        function uri_is_valid(uri_string: string, flags: UriFlags | null): boolean;
        /**
         * Joins the given components together according to `flags` to create
         * an absolute URI string. `path` may not be %NULL (though it may be the empty
         * string).
         *
         * When `host` is present, `path` must either be empty or begin with a slash (`/`)
         * character. When `host` is not present, `path` cannot begin with two slash
         * characters (`//`). See
         * [RFC 3986, section 3](https://tools.ietf.org/html/rfc3986#section-3).
         *
         * See also g_uri_join_with_user(), which allows specifying the
         * components of the ‘userinfo’ separately.
         *
         * %G_URI_FLAGS_HAS_PASSWORD and %G_URI_FLAGS_HAS_AUTH_PARAMS are ignored if set
         * in `flags`.
         * @param flags flags describing how to build the URI string
         * @param scheme the URI scheme, or %NULL
         * @param userinfo the userinfo component, or %NULL
         * @param host the host component, or %NULL
         * @param port the port, or `-1`
         * @param path the path component
         * @param query the query component, or %NULL
         * @param fragment the fragment, or %NULL
         * @returns an absolute URI string
         */
        function uri_join(
            flags: UriFlags | null,
            scheme: string | null,
            userinfo: string | null,
            host: string | null,
            port: number,
            path: string,
            query?: string | null,
            fragment?: string | null,
        ): string;
        /**
         * Joins the given components together according to `flags` to create
         * an absolute URI string. `path` may not be %NULL (though it may be the empty
         * string).
         *
         * In contrast to g_uri_join(), this allows specifying the components
         * of the ‘userinfo’ separately. It otherwise behaves the same.
         *
         * %G_URI_FLAGS_HAS_PASSWORD and %G_URI_FLAGS_HAS_AUTH_PARAMS are ignored if set
         * in `flags`.
         * @param flags flags describing how to build the URI string
         * @param scheme the URI scheme, or %NULL
         * @param user the user component of the userinfo, or %NULL
         * @param password the password component of the userinfo, or   %NULL
         * @param auth_params the auth params of the userinfo, or   %NULL
         * @param host the host component, or %NULL
         * @param port the port, or `-1`
         * @param path the path component
         * @param query the query component, or %NULL
         * @param fragment the fragment, or %NULL
         * @returns an absolute URI string
         */
        function uri_join_with_user(
            flags: UriFlags | null,
            scheme: string | null,
            user: string | null,
            password: string | null,
            auth_params: string | null,
            host: string | null,
            port: number,
            path: string,
            query?: string | null,
            fragment?: string | null,
        ): string;
        /**
         * Splits an URI list conforming to the text/uri-list
         * mime type defined in RFC 2483 into individual URIs,
         * discarding any comments. The URIs are not validated.
         * @param uri_list an URI list
         * @returns a newly allocated %NULL-terminated list   of strings holding the individual URIs. The array should be freed   with g_strfreev().
         */
        function uri_list_extract_uris(uri_list: string): string[];
        /**
         * Parses `uri_string` according to `flags`. If the result is not a
         * valid [absolute URI](#relative-and-absolute-uris), it will be discarded, and an
         * error returned.
         * @param uri_string a string representing an absolute URI
         * @param flags flags describing how to parse @uri_string
         * @returns a new #GUri, or NULL on error.
         */
        function uri_parse(uri_string: string, flags: UriFlags | null): Uri;
        /**
         * Many URI schemes include one or more attribute/value pairs as part of the URI
         * value. This method can be used to parse them into a hash table. When an
         * attribute has multiple occurrences, the last value is the final returned
         * value. If you need to handle repeated attributes differently, use
         * #GUriParamsIter.
         *
         * The `params` string is assumed to still be `%`-encoded, but the returned
         * values will be fully decoded. (Thus it is possible that the returned values
         * may contain `=` or `separators,` if the value was encoded in the input.)
         * Invalid `%`-encoding is treated as with the %G_URI_FLAGS_PARSE_RELAXED
         * rules for g_uri_parse(). (However, if `params` is the path or query string
         * from a #GUri that was parsed without %G_URI_FLAGS_PARSE_RELAXED and
         * %G_URI_FLAGS_ENCODED, then you already know that it does not contain any
         * invalid encoding.)
         *
         * %G_URI_PARAMS_WWW_FORM is handled as documented for g_uri_params_iter_init().
         *
         * If %G_URI_PARAMS_CASE_INSENSITIVE is passed to `flags,` attributes will be
         * compared case-insensitively, so a params string `attr=123&Attr=456` will only
         * return a single attribute–value pair, `Attr=456`. Case will be preserved in
         * the returned attributes.
         *
         * If `params` cannot be parsed (for example, it contains two `separators`
         * characters in a row), then `error` is set and %NULL is returned.
         * @param params a `%`-encoded string containing `attribute=value`   parameters
         * @param length the length of @params, or `-1` if it is nul-terminated
         * @param separators the separator byte character set between parameters. (usually   `&`, but sometimes `;` or both `&;`). Note that this function works on   bytes not characters, so it can't be used to delimit UTF-8 strings for   anything but ASCII characters. You may pass an empty set, in which case   no splitting will occur.
         * @param flags flags to modify the way the parameters are handled.
         * @returns A hash table of attribute/value pairs, with both names and values     fully-decoded; or %NULL on error.
         */
        function uri_parse_params(
            params: string,
            length: number,
            separators: string,
            flags: UriParamsFlags | null,
        ): HashTable<string, string>;
        /**
         * Gets the scheme portion of a URI string.
         * [RFC 3986](https://tools.ietf.org/html/rfc3986#section-3) decodes the scheme
         * as:
         *
         * ```
         * URI = scheme ":" hier-part [ "?" query ] [ "#" fragment ]
         * ```
         *
         * Common schemes include `file`, `https`, `svn+ssh`, etc.
         * @param uri a valid URI.
         * @returns The ‘scheme’ component of the URI, or     %NULL on error. The returned string should be freed when no longer needed.
         */
        function uri_parse_scheme(uri: string): string | null;
        /**
         * Gets the scheme portion of a URI string.
         * [RFC 3986](https://tools.ietf.org/html/rfc3986#section-3) decodes the scheme
         * as:
         *
         * ```
         * URI = scheme ":" hier-part [ "?" query ] [ "#" fragment ]
         * ```
         *
         * Common schemes include `file`, `https`, `svn+ssh`, etc.
         *
         * Unlike g_uri_parse_scheme(), the returned scheme is normalized to
         * all-lowercase and does not need to be freed.
         * @param uri a valid URI.
         * @returns The ‘scheme’ component of the URI, or     %NULL on error. The returned string is normalized to all-lowercase, and     interned via g_intern_string(), so it does not need to be freed.
         */
        function uri_peek_scheme(uri: string): string | null;
        /**
         * Parses `uri_ref` according to `flags` and, if it is a
         * [relative URI](#relative-and-absolute-uris), resolves it relative to
         * `base_uri_string`. If the result is not a valid absolute URI, it will be
         * discarded, and an error returned.
         *
         * (If `base_uri_string` is %NULL, this just returns `uri_ref,` or
         * %NULL if `uri_ref` is invalid or not absolute.)
         * @param base_uri_string a string representing a base URI
         * @param uri_ref a string representing a relative or absolute URI
         * @param flags flags describing how to parse @uri_ref
         * @returns the resolved URI string, or NULL on error.
         */
        function uri_resolve_relative(base_uri_string: string | null, uri_ref: string, flags: UriFlags | null): string;
        /**
         * Parses `uri_ref` (which can be an
         * [absolute or relative URI](#relative-and-absolute-uris)) according to `flags,` and
         * returns the pieces. Any component that doesn't appear in `uri_ref` will be
         * returned as %NULL (but note that all URIs always have a path component,
         * though it may be the empty string).
         *
         * If `flags` contains %G_URI_FLAGS_ENCODED, then `%`-encoded characters in
         * `uri_ref` will remain encoded in the output strings. (If not,
         * then all such characters will be decoded.) Note that decoding will
         * only work if the URI components are ASCII or UTF-8, so you will
         * need to use %G_URI_FLAGS_ENCODED if they are not.
         *
         * Note that the %G_URI_FLAGS_HAS_PASSWORD and
         * %G_URI_FLAGS_HAS_AUTH_PARAMS `flags` are ignored by g_uri_split(),
         * since it always returns only the full userinfo; use
         * g_uri_split_with_user() if you want it split up.
         * @param uri_ref a string containing a relative or absolute URI
         * @param flags flags for parsing @uri_ref
         * @returns %TRUE if @uri_ref parsed successfully, %FALSE   on error.
         */
        function uri_split(
            uri_ref: string,
            flags: UriFlags | null,
        ): [boolean, string, string, string, number, string, string, string];
        /**
         * Parses `uri_string` (which must be an [absolute URI](#relative-and-absolute-uris))
         * according to `flags,` and returns the pieces relevant to connecting to a host.
         * See the documentation for g_uri_split() for more details; this is
         * mostly a wrapper around that function with simpler arguments.
         * However, it will return an error if `uri_string` is a relative URI,
         * or does not contain a hostname component.
         * @param uri_string a string containing an absolute URI
         * @param flags flags for parsing @uri_string
         * @returns %TRUE if @uri_string parsed successfully,   %FALSE on error.
         */
        function uri_split_network(uri_string: string, flags: UriFlags | null): [boolean, string, string, number];
        /**
         * Parses `uri_ref` (which can be an
         * [absolute or relative URI](#relative-and-absolute-uris)) according to `flags,` and
         * returns the pieces. Any component that doesn't appear in `uri_ref` will be
         * returned as %NULL (but note that all URIs always have a path component,
         * though it may be the empty string).
         *
         * See g_uri_split(), and the definition of #GUriFlags, for more
         * information on the effect of `flags`. Note that `password` will only
         * be parsed out if `flags` contains %G_URI_FLAGS_HAS_PASSWORD, and
         * `auth_params` will only be parsed out if `flags` contains
         * %G_URI_FLAGS_HAS_AUTH_PARAMS.
         * @param uri_ref a string containing a relative or absolute URI
         * @param flags flags for parsing @uri_ref
         * @returns %TRUE if @uri_ref parsed successfully, %FALSE   on error.
         */
        function uri_split_with_user(
            uri_ref: string,
            flags: UriFlags | null,
        ): [boolean, string, string, string, string, string, number, string, string, string];
        /**
         * Unescapes a segment of an escaped string as binary data.
         *
         * Note that in contrast to g_uri_unescape_string(), this does allow
         * nul bytes to appear in the output.
         *
         * If any of the characters in `illegal_characters` appears as an escaped
         * character in `escaped_string,` then that is an error and %NULL will be
         * returned. This is useful if you want to avoid for instance having a slash
         * being expanded in an escaped path element, which might confuse pathname
         * handling.
         * @param escaped_string A URI-escaped string
         * @param length the length (in bytes) of @escaped_string to escape, or `-1` if it   is nul-terminated.
         * @param illegal_characters a string of illegal characters   not to be allowed, or %NULL.
         * @returns an unescaped version of @escaped_string     or %NULL on error (if decoding failed, using %G_URI_ERROR_FAILED error     code). The returned #GBytes should be unreffed when no longer needed.
         */
        function uri_unescape_bytes(escaped_string: string, length: number, illegal_characters?: string | null): Bytes;
        /**
         * Unescapes a segment of an escaped string.
         *
         * If any of the characters in `illegal_characters` or the NUL
         * character appears as an escaped character in `escaped_string,` then
         * that is an error and %NULL will be returned. This is useful if you
         * want to avoid for instance having a slash being expanded in an
         * escaped path element, which might confuse pathname handling.
         *
         * Note: `NUL` byte is not accepted in the output, in contrast to
         * g_uri_unescape_bytes().
         * @param escaped_string A string, may be %NULL
         * @param escaped_string_end Pointer to end of @escaped_string,   may be %NULL
         * @param illegal_characters An optional string of illegal   characters not to be allowed, may be %NULL
         * @returns an unescaped version of @escaped_string, or %NULL on error. The returned string should be freed when no longer needed.  As a special case if %NULL is given for @escaped_string, this function will return %NULL.
         */
        function uri_unescape_segment(
            escaped_string?: string | null,
            escaped_string_end?: string | null,
            illegal_characters?: string | null,
        ): string | null;
        /**
         * Unescapes a whole escaped string.
         *
         * If any of the characters in `illegal_characters` or the NUL
         * character appears as an escaped character in `escaped_string,` then
         * that is an error and %NULL will be returned. This is useful if you
         * want to avoid for instance having a slash being expanded in an
         * escaped path element, which might confuse pathname handling.
         * @param escaped_string an escaped string to be unescaped.
         * @param illegal_characters a string of illegal characters   not to be allowed, or %NULL.
         * @returns an unescaped version of @escaped_string. The returned string should be freed when no longer needed.
         */
        function uri_unescape_string(escaped_string: string, illegal_characters?: string | null): string | null;
        /**
         * Pauses the current thread for the given number of microseconds.
         *
         * There are 1 million microseconds per second (represented by the
         * %G_USEC_PER_SEC macro). g_usleep() may have limited precision,
         * depending on hardware and operating system; don't rely on the exact
         * length of the sleep.
         * @param microseconds number of microseconds to pause
         */
        function usleep(microseconds: number): void;
        /**
         * Convert a string from UTF-16 to UCS-4.
         *
         * The result will be nul-terminated.
         * @param str a UTF-16 encoded string
         * @returns a pointer to a newly allocated UCS-4 string.   This value must be freed with [func@GLib.free].
         */
        function utf16_to_ucs4(str: number[]): [number, number, number];
        /**
         * Convert a string from UTF-16 to UTF-8.
         *
         * The result will be terminated with a nul byte.
         *
         * Note that the input is expected to be already in native endianness,
         * an initial byte-order-mark character is not handled specially.
         * [func`GLib`.convert] can be used to convert a byte buffer of UTF-16 data of
         * ambiguous endianness.
         *
         * Further note that this function does not validate the result
         * string; it may (for example) include embedded nul characters. The only
         * validation done by this function is to ensure that the input can
         * be correctly interpreted as UTF-16, i.e. it doesn’t contain
         * unpaired surrogates or partial character sequences.
         * @param str a UTF-16 encoded string
         * @returns a pointer to a newly allocated UTF-8 string.   This value must be freed with [func@GLib.free].
         */
        function utf16_to_utf8(str: number[]): [string, number, number];
        /**
         * Converts a string into a form that is independent of case. The
         * result will not correspond to any particular case, but can be
         * compared for equality or ordered with the results of calling
         * g_utf8_casefold() on other strings.
         *
         * Note that calling g_utf8_casefold() followed by g_utf8_collate() is
         * only an approximation to the correct linguistic case insensitive
         * ordering, though it is a fairly good one. Getting this exactly
         * right would require a more sophisticated collation function that
         * takes case sensitivity into account. GLib does not currently
         * provide such a function.
         * @param str a UTF-8 encoded string
         * @param len length of @str, in bytes, or -1 if @str is nul-terminated.
         * @returns a newly allocated string, that is a   case independent form of @str.
         */
        function utf8_casefold(str: string, len: number): string;
        /**
         * Compares two strings for ordering using the linguistically
         * correct rules for the [current locale](running.html#locale).
         * When sorting a large number of strings, it will be significantly
         * faster to obtain collation keys with g_utf8_collate_key() and
         * compare the keys with strcmp() when sorting instead of sorting
         * the original strings.
         *
         * If the two strings are not comparable due to being in different collation
         * sequences, the result is undefined. This can happen if the strings are in
         * different language scripts, for example.
         * @param str1 a UTF-8 encoded string
         * @param str2 a UTF-8 encoded string
         * @returns < 0 if @str1 compares before @str2,   0 if they compare equal, > 0 if @str1 compares after @str2.
         */
        function utf8_collate(str1: string, str2: string): number;
        /**
         * Converts a string into a collation key that can be compared
         * with other collation keys produced by the same function using
         * strcmp().
         *
         * The results of comparing the collation keys of two strings
         * with strcmp() will always be the same as comparing the two
         * original keys with g_utf8_collate().
         *
         * Note that this function depends on the [current locale](running.html#locale).
         *
         * Note that the returned string is not guaranteed to be in any
         * encoding, especially UTF-8. The returned value is meant to be
         * used only for comparisons.
         * @param str a UTF-8 encoded string.
         * @param len length of @str, in bytes, or -1 if @str is nul-terminated.
         * @returns a newly allocated string.   The contents of the string are only meant to be used when sorting.   This string should be freed with g_free() when you are done with it.
         */
        function utf8_collate_key(str: string, len: number): string;
        /**
         * Converts a string into a collation key that can be compared
         * with other collation keys produced by the same function using strcmp().
         *
         * In order to sort filenames correctly, this function treats the dot '.'
         * as a special case. Most dictionary orderings seem to consider it
         * insignificant, thus producing the ordering "event.c" "eventgenerator.c"
         * "event.h" instead of "event.c" "event.h" "eventgenerator.c". Also, we
         * would like to treat numbers intelligently so that "file1" "file10" "file5"
         * is sorted as "file1" "file5" "file10".
         *
         * Note that this function depends on the [current locale](running.html#locale).
         *
         * Note that the returned string is not guaranteed to be in any
         * encoding, especially UTF-8. The returned value is meant to be
         * used only for comparisons.
         * @param str a UTF-8 encoded string.
         * @param len length of @str, in bytes, or -1 if @str is nul-terminated.
         * @returns a newly allocated string.   The contents of the string are only meant to be used when sorting.   This string should be freed with g_free() when you are done with it.
         */
        function utf8_collate_key_for_filename(str: string, len: number): string;
        /**
         * Finds the start of the next UTF-8 character in the string after `p`.
         *
         * `p` does not have to be at the beginning of a UTF-8 character. No check
         * is made to see if the character found is actually valid other than
         * it starts with an appropriate byte.
         *
         * If `end` is `NULL`, the return value will never be `NULL`: if the end of the
         * string is reached, a pointer to the terminating nul byte is returned. If
         * `end` is non-`NULL`, the return value will be `NULL` if the end of the string
         * is reached.
         * @param p a pointer to a position within a UTF-8 encoded string
         * @param end a pointer to the byte following the end of the string,     or `NULL` to indicate that the string is nul-terminated
         * @returns a pointer to the found character or `NULL` if @end is    set and is reached
         */
        function utf8_find_next_char(p: string, end?: string | null): string | null;
        /**
         * Given a position `p` with a UTF-8 encoded string `str,` find the start
         * of the previous UTF-8 character starting before `p`. Returns `NULL` if no
         * UTF-8 characters are present in `str` before `p`.
         *
         * `p` does not have to be at the beginning of a UTF-8 character. No check
         * is made to see if the character found is actually valid other than
         * it starts with an appropriate byte.
         * @param str pointer to the beginning of a UTF-8 encoded string
         * @param p pointer to some position within @str
         * @returns a pointer to the found character
         */
        function utf8_find_prev_char(str: string, p: string): string | null;
        /**
         * Converts a sequence of bytes encoded as UTF-8 to a Unicode character.
         *
         * If `p` does not point to a valid UTF-8 encoded character, results
         * are undefined. If you are not sure that the bytes are complete
         * valid Unicode characters, you should use [func`GLib`.utf8_get_char_validated]
         * instead.
         * @param p a pointer to Unicode character encoded as UTF-8
         * @returns the resulting character
         */
        function utf8_get_char(p: string): number;
        /**
         * Convert a sequence of bytes encoded as UTF-8 to a Unicode character.
         *
         * This function checks for incomplete characters, for invalid characters
         * such as characters that are out of the range of Unicode, and for
         * overlong encodings of valid characters.
         *
         * Note that [func`GLib`.utf8_get_char_validated] returns `(gunichar)-2` if
         * `max_len` is positive and any of the bytes in the first UTF-8 character
         * sequence are nul.
         * @param p a pointer to Unicode character encoded as UTF-8
         * @param max_len the maximum number of bytes to read, or `-1` if @p is nul-terminated
         * @returns the resulting character. If @p points to a partial   sequence at the end of a string that could begin a valid   character (or if @max_len is zero), returns `(gunichar)-2`;   otherwise, if @p does not point to a valid UTF-8 encoded   Unicode character, returns `(gunichar)-1`.
         */
        function utf8_get_char_validated(p: string, max_len: number): number;
        /**
         * If the provided string is valid UTF-8, return a copy of it. If not,
         * return a copy in which bytes that could not be interpreted as valid Unicode
         * are replaced with the Unicode replacement character (U+FFFD).
         *
         * For example, this is an appropriate function to use if you have received
         * a string that was incorrectly declared to be UTF-8, and you need a valid
         * UTF-8 version of it that can be logged or displayed to the user, with the
         * assumption that it is close enough to ASCII or UTF-8 to be mostly
         * readable as-is.
         * @param str string to coerce into UTF-8
         * @param len the maximum length of @str to use, in bytes. If @len is negative,   then the string is nul-terminated.
         * @returns a valid UTF-8 string whose content resembles @str
         */
        function utf8_make_valid(str: string, len: number): string;
        /**
         * Converts a string into canonical form, standardizing
         * such issues as whether a character with an accent
         * is represented as a base character and combining
         * accent or as a single precomposed character. The
         * string has to be valid UTF-8, otherwise %NULL is
         * returned. You should generally call g_utf8_normalize()
         * before comparing two Unicode strings.
         *
         * The normalization mode %G_NORMALIZE_DEFAULT only
         * standardizes differences that do not affect the
         * text content, such as the above-mentioned accent
         * representation. %G_NORMALIZE_ALL also standardizes
         * the "compatibility" characters in Unicode, such
         * as SUPERSCRIPT THREE to the standard forms
         * (in this case DIGIT THREE). Formatting information
         * may be lost but for most text operations such
         * characters should be considered the same.
         *
         * %G_NORMALIZE_DEFAULT_COMPOSE and %G_NORMALIZE_ALL_COMPOSE
         * are like %G_NORMALIZE_DEFAULT and %G_NORMALIZE_ALL,
         * but returned a result with composed forms rather
         * than a maximally decomposed form. This is often
         * useful if you intend to convert the string to
         * a legacy encoding or pass it to a system with
         * less capable Unicode handling.
         * @param str a UTF-8 encoded string.
         * @param len length of @str, in bytes, or -1 if @str is nul-terminated.
         * @param mode the type of normalization to perform.
         * @returns a newly allocated string, that   is the normalized form of @str, or %NULL if @str   is not valid UTF-8.
         */
        function utf8_normalize(str: string, len: number, mode: NormalizeMode | null): string | null;
        /**
         * Converts from an integer character offset to a pointer to a position
         * within the string.
         *
         * Since 2.10, this function allows to pass a negative `offset` to
         * step backwards. It is usually worth stepping backwards from the end
         * instead of forwards if `offset` is in the last fourth of the string,
         * since moving forward is about 3 times faster than moving backward.
         *
         * Note that this function doesn’t abort when reaching the end of `str`.
         * Therefore you should be sure that `offset` is within string boundaries
         * before calling that function. Call [func`GLib`.utf8_strlen] when unsure.
         * This limitation exists as this function is called frequently during
         * text rendering and therefore has to be as fast as possible.
         * @param str a UTF-8 encoded string
         * @param offset a character offset within @str
         * @returns the resulting pointer
         */
        function utf8_offset_to_pointer(str: string, offset: number): string;
        /**
         * Converts from a pointer to position within a string to an integer
         * character offset.
         *
         * Since 2.10, this function allows `pos` to be before `str,` and returns
         * a negative offset in this case.
         * @param str a UTF-8 encoded string
         * @param pos a pointer to a position within @str
         * @returns the resulting character offset
         */
        function utf8_pointer_to_offset(str: string, pos: string): number;
        /**
         * Finds the previous UTF-8 character in the string before `p`.
         *
         * `p` does not have to be at the beginning of a UTF-8 character. No check
         * is made to see if the character found is actually valid other than
         * it starts with an appropriate byte. If `p` might be the first
         * character of the string, you must use [func`GLib`.utf8_find_prev_char]
         * instead.
         * @param p a pointer to a position within a UTF-8 encoded string
         * @returns a pointer to the found character
         */
        function utf8_prev_char(p: string): string;
        /**
         * Finds the leftmost occurrence of the given Unicode character
         * in a UTF-8 encoded string, while limiting the search to `len` bytes.
         *
         * If `len` is `-1`, allow unbounded search.
         * @param p a nul-terminated UTF-8 encoded string
         * @param len the maximum length of @p
         * @param c a Unicode character
         * @returns `NULL` if the string does not contain   the character, otherwise, a pointer to the start of the leftmost occurrence   of the character in the string.
         */
        function utf8_strchr(p: string, len: number, c: number): string | null;
        /**
         * Converts all Unicode characters in the string that have a case
         * to lowercase. The exact manner that this is done depends
         * on the current locale, and may result in the number of
         * characters in the string changing.
         * @param str a UTF-8 encoded string
         * @param len length of @str, in bytes, or -1 if @str is nul-terminated.
         * @returns a newly allocated string, with all characters    converted to lowercase.
         */
        function utf8_strdown(str: string, len: number): string;
        /**
         * Computes the length of the string in characters, not including
         * the terminating nul character. If the `max’`th byte falls in the
         * middle of a character, the last (partial) character is not counted.
         * @param p pointer to the start of a UTF-8 encoded string
         * @param max the maximum number of bytes to examine. If @max   is less than 0, then the string is assumed to be   nul-terminated. If @max is 0, @p will not be examined and   may be `NULL`. If @max is greater than 0, up to @max   bytes are examined
         * @returns the length of the string in characters
         */
        function utf8_strlen(p: string, max: number): number;
        /**
         * Like the standard C [`strncpy()`](man:strncpy) function, but copies a given
         * number of characters instead of a given number of bytes.
         *
         * The `src` string must be valid UTF-8 encoded text. (Use
         * [func`GLib`.utf8_validate] on all text before trying to use UTF-8 utility
         * functions with it.)
         *
         * Note you must ensure `dest` is at least 4 * `n` + 1 to fit the
         * largest possible UTF-8 characters
         * @param dest buffer to fill with characters from @src
         * @param src UTF-8 encoded string
         * @param n character count
         * @returns @dest
         */
        function utf8_strncpy(dest: string, src: string, n: number): string;
        /**
         * Find the rightmost occurrence of the given Unicode character
         * in a UTF-8 encoded string, while limiting the search to `len` bytes.
         *
         * If `len` is `-1`, allow unbounded search.
         * @param p a nul-terminated UTF-8 encoded string
         * @param len the maximum length of @p
         * @param c a Unicode character
         * @returns `NULL` if the string does not contain   the character, otherwise, a pointer to the start of the rightmost   occurrence of the character in the string.
         */
        function utf8_strrchr(p: string, len: number, c: number): string | null;
        /**
         * Reverses a UTF-8 string.
         *
         * `str` must be valid UTF-8 encoded text. (Use [func`GLib`.utf8_validate] on all
         * text before trying to use UTF-8 utility functions with it.)
         *
         * This function is intended for programmatic uses of reversed strings.
         * It pays no attention to decomposed characters, combining marks, byte
         * order marks, directional indicators (LRM, LRO, etc) and similar
         * characters which might need special handling when reversing a string
         * for display purposes.
         *
         * Note that unlike [func`GLib`.strreverse], this function returns
         * newly-allocated memory, which should be freed with [func`GLib`.free] when
         * no longer needed.
         * @param str a UTF-8 encoded string
         * @param len the maximum length of @str to use, in bytes. If @len is negative,   then the string is nul-terminated.
         * @returns a newly-allocated string which is the reverse of @str
         */
        function utf8_strreverse(str: string, len: number): string;
        /**
         * Converts all Unicode characters in the string that have a case
         * to uppercase. The exact manner that this is done depends
         * on the current locale, and may result in the number of
         * characters in the string increasing. (For instance, the
         * German ess-zet will be changed to SS.)
         * @param str a UTF-8 encoded string
         * @param len length of @str, in bytes, or -1 if @str is nul-terminated.
         * @returns a newly allocated string, with all characters    converted to uppercase.
         */
        function utf8_strup(str: string, len: number): string;
        /**
         * Copies a substring out of a UTF-8 encoded string.
         * The substring will contain `end_pos` - `start_pos` characters.
         *
         * Since GLib 2.72, `-1` can be passed to `end_pos` to indicate the
         * end of the string.
         * @param str a UTF-8 encoded string
         * @param start_pos a character offset within @str
         * @param end_pos another character offset within @str,   or `-1` to indicate the end of the string
         * @returns a newly allocated copy of the requested   substring. Free with [func@GLib.free] when no longer needed.
         */
        function utf8_substring(str: string, start_pos: number, end_pos: number): string;
        /**
         * Convert a string from UTF-8 to a 32-bit fixed width representation as UCS-4.
         *
         * A trailing nul character (U+0000) will be added to the string after the
         * converted text.
         * @param str a UTF-8 encoded string
         * @param len the maximum length of @str to use, in bytes. If @len is negative,   then the string is nul-terminated.
         * @returns a pointer to a newly allocated UCS-4 string.   This value must be freed with [func@GLib.free].
         */
        function utf8_to_ucs4(str: string, len: number): [number, number, number];
        /**
         * Convert a string from UTF-8 to a 32-bit fixed width
         * representation as UCS-4, assuming valid UTF-8 input.
         *
         * This function is roughly twice as fast as [func`GLib`.utf8_to_ucs4]
         * but does no error checking on the input. A trailing nul character (U+0000)
         * will be added to the string after the converted text.
         * @param str a UTF-8 encoded string
         * @param len the maximum length of @str to use, in bytes. If @len is negative,   then the string is nul-terminated.
         * @returns a pointer to a newly allocated UCS-4 string.   This value must be freed with [func@GLib.free].
         */
        function utf8_to_ucs4_fast(str: string, len: number): [number, number];
        /**
         * Convert a string from UTF-8 to UTF-16.
         *
         * A nul character (U+0000) will be added to the result after the converted text.
         * @param str a UTF-8 encoded string
         * @param len the maximum length (number of bytes) of @str to use.   If @len is negative, then the string is nul-terminated.
         * @returns a pointer to a newly allocated UTF-16 string.   This value must be freed with [func@GLib.free].
         */
        function utf8_to_utf16(str: string, len: number): [number, number, number];
        /**
         * Cuts off the middle of the string, preserving half of `truncate_length`
         * characters at the beginning and half at the end.
         *
         * If `string` is already short enough, this returns a copy of `string`.
         * If `truncate_length` is `0`, an empty string is returned.
         * @param string a nul-terminated UTF-8 encoded string
         * @param truncate_length the new size of @string, in characters, including the ellipsis character
         * @returns a newly-allocated copy of @string ellipsized in the middle
         */
        function utf8_truncate_middle(string: string, truncate_length: number): string;
        /**
         * Validates UTF-8 encoded text.
         *
         * `str` is the text to validate; if `str` is nul-terminated, then `max_len` can be
         * `-1`, otherwise `max_len` should be the number of bytes to validate.
         *
         * If `end` is non-`NULL`, then the end of the valid range will be stored there.
         * This is the first byte of the first invalid character if some bytes were
         * invalid, or the end of the text being validated otherwise — either the
         * trailing nul byte, or the first byte beyond `max_len` (if it’s positive).
         *
         * Note that `g_utf8_validate()` returns `FALSE` if `max_len` is  positive and
         * any of the `max_len` bytes are nul.
         *
         * Returns `TRUE` if all of `str` was valid. Many GLib and GTK
         * routines require valid UTF-8 as input; so data read from a file
         * or the network should be checked with `g_utf8_validate()` before
         * doing anything else with it.
         * @param str a pointer to character data
         * @returns `TRUE` if the text was valid UTF-8
         */
        function utf8_validate(str: Uint8Array | string): [boolean, string];
        /**
         * Validates UTF-8 encoded text.
         *
         * As with [func`GLib`.utf8_validate], but `max_len` must be set, and hence this
         * function will always return `FALSE` if any of the bytes of `str` are nul.
         * @param str a pointer to character data
         * @returns `TRUE` if the text was valid UTF-8
         */
        function utf8_validate_len(str: Uint8Array | string): [boolean, string];
        /**
         * A wrapper for the POSIX utime() function. The utime() function
         * sets the access and modification timestamps of a file.
         *
         * See your C library manual for more details about how utime() works
         * on your system.
         * @param filename a pathname in the GLib file name encoding     (UTF-8 on Windows)
         * @param utb a pointer to a struct utimbuf.
         * @returns 0 if the operation was successful, -1 if an error occurred
         */
        function utime(filename: string, utb?: any | null): number;
        /**
         * Parses the string `str` and verify if it is a UUID.
         *
         * The function accepts the following syntax:
         *
         * - simple forms (e.g. `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`)
         *
         * Note that hyphens are required within the UUID string itself,
         * as per the aforementioned RFC.
         * @param str a string representing a UUID
         * @returns %TRUE if @str is a valid UUID, %FALSE otherwise.
         */
        function uuid_string_is_valid(str: string): boolean;
        /**
         * Generates a random UUID (RFC 4122 version 4) as a string. It has the same
         * randomness guarantees as #GRand, so must not be used for cryptographic
         * purposes such as key generation, nonces, salts or one-time pads.
         * @returns A string that should be freed with g_free().
         */
        function uuid_string_random(): string;
        function variant_get_gtype(): GObject.GType;
        /**
         * Determines if a given string is a valid D-Bus object path.  You
         * should ensure that a string is a valid D-Bus object path before
         * passing it to g_variant_new_object_path().
         *
         * A valid object path starts with `/` followed by zero or more
         * sequences of characters separated by `/` characters.  Each sequence
         * must contain only the characters `[A-Z][a-z][0-9]_`.  No sequence
         * (including the one following the final `/` character) may be empty.
         * @param string a normal C nul-terminated string
         * @returns %TRUE if @string is a D-Bus object path
         */
        function variant_is_object_path(string: string): boolean;
        /**
         * Determines if a given string is a valid D-Bus type signature.  You
         * should ensure that a string is a valid D-Bus type signature before
         * passing it to g_variant_new_signature().
         *
         * D-Bus type signatures consist of zero or more definite #GVariantType
         * strings in sequence.
         * @param string a normal C nul-terminated string
         * @returns %TRUE if @string is a D-Bus type signature
         */
        function variant_is_signature(string: string): boolean;
        /**
         * Parses a #GVariant from a text representation.
         *
         * A single #GVariant is parsed from the content of `text`.
         *
         * The format is described [here](gvariant-text-format.html).
         *
         * The memory at `limit` will never be accessed and the parser behaves as
         * if the character at `limit` is the nul terminator.  This has the
         * effect of bounding `text`.
         *
         * If `endptr` is non-%NULL then `text` is permitted to contain data
         * following the value that this function parses and `endptr` will be
         * updated to point to the first character past the end of the text
         * parsed by this function.  If `endptr` is %NULL and there is extra data
         * then an error is returned.
         *
         * If `type` is non-%NULL then the value will be parsed to have that
         * type.  This may result in additional parse errors (in the case that
         * the parsed value doesn't fit the type) but may also result in fewer
         * errors (in the case that the type would have been ambiguous, such as
         * with empty arrays).
         *
         * In the event that the parsing is successful, the resulting #GVariant
         * is returned. It is never floating, and must be freed with
         * [method`GLib`.Variant.unref].
         *
         * In case of any error, %NULL will be returned.  If `error` is non-%NULL
         * then it will be set to reflect the error that occurred.
         *
         * Officially, the language understood by the parser is “any string
         * produced by [method`GLib`.Variant.print]”. This explicitly includes
         * `g_variant_print()`’s annotated types like `int64 -1000`.
         *
         * There may be implementation specific restrictions on deeply nested values,
         * which would result in a %G_VARIANT_PARSE_ERROR_RECURSION error. #GVariant is
         * guaranteed to handle nesting up to at least 64 levels.
         * @param type a #GVariantType, or %NULL
         * @param text a string containing a GVariant in text form
         * @param limit a pointer to the end of @text, or %NULL
         * @param endptr a location to store the end pointer, or %NULL
         * @returns a non-floating reference to a #GVariant, or %NULL
         */
        function variant_parse(
            type: VariantType | null,
            text: string,
            limit?: string | null,
            endptr?: string | null,
        ): Variant;
        /**
         * Pretty-prints a message showing the context of a #GVariant parse
         * error within the string for which parsing was attempted.
         *
         * The resulting string is suitable for output to the console or other
         * monospace media where newlines are treated in the usual way.
         *
         * The message will typically look something like one of the following:
         *
         *
         * ```
         * unterminated string constant:
         *   (1, 2, 3, 'abc
         *             ^^^^
         * ```
         *
         *
         * or
         *
         *
         * ```
         * unable to find a common type:
         *   [1, 2, 3, 'str']
         *    ^        ^^^^^
         * ```
         *
         *
         * The format of the message may change in a future version.
         *
         * `error` must have come from a failed attempt to g_variant_parse() and
         * `source_str` must be exactly the same string that caused the error.
         * If `source_str` was not nul-terminated when you passed it to
         * g_variant_parse() then you must add nul termination before using this
         * function.
         * @param error a #GError from the #GVariantParseError domain
         * @param source_str the string that was given to the parser
         * @returns the printed message
         */
        function variant_parse_error_print_context(error: Error, source_str: string): string;
        function variant_parse_error_quark(): Quark;
        /**
         * Same as g_variant_error_quark().
         */
        function variant_parser_get_error_quark(): Quark;
        function variant_type_checked_(type_string: string): VariantType;
        function variant_type_string_get_depth_(type_string: string): number;
        /**
         * Checks if `type_string` is a valid
         * [GVariant type string](./struct.VariantType.html#gvariant-type-strings).
         *
         * This call is equivalent to calling [func`GLib`.VariantType.string_scan] and
         * confirming that the following character is a nul terminator.
         * @param type_string a pointer to any string
         * @returns true if @type_string is exactly one valid type string Since 2.24
         */
        function variant_type_string_is_valid(type_string: string): boolean;
        /**
         * Scan for a single complete and valid GVariant type string in `string`.
         *
         * The memory pointed to by `limit` (or bytes beyond it) is never
         * accessed.
         *
         * If a valid type string is found, `endptr` is updated to point to the
         * first character past the end of the string that was found and %TRUE
         * is returned.
         *
         * If there is no valid type string starting at `string,` or if the type
         * string does not end before `limit` then %FALSE is returned.
         *
         * For the simple case of checking if a string is a valid type string,
         * see [func`GLib`.VariantType.string_is_valid].
         * @param string a pointer to any string
         * @param limit the end of @string
         * @returns true if a valid type string was found
         */
        function variant_type_string_scan(string: string, limit: string | null): [boolean, string];
        interface CacheDestroyFunc {
            (value?: any | null): void;
        }
        interface CacheDupFunc {
            (value?: any | null): any | null;
        }
        interface CacheNewFunc {
            (key?: any | null): any | null;
        }
        interface ChildWatchFunc {
            (pid: Pid, wait_status: number): void;
        }
        interface ClearHandleFunc {
            (handle_id: number): void;
        }
        interface CompareDataFunc {
            (a?: any | null, b?: any | null): number;
        }
        interface CompareFunc {
            (a?: any | null, b?: any | null): number;
        }
        interface CompletionFunc {
            (item?: any | null): string;
        }
        interface CompletionStrncmpFunc {
            (s1: string, s2: string, n: number): number;
        }
        interface CopyFunc {
            (src: any, data?: any | null): any;
        }
        interface DataForeachFunc {
            (key_id: Quark, data?: any | null): void;
        }
        interface DestroyNotify {
            (data?: any | null): void;
        }
        interface DuplicateFunc {
            (data?: any | null): any | null;
        }
        interface EqualFunc {
            (a?: any | null, b?: any | null): boolean;
        }
        interface EqualFuncFull {
            (a?: any | null, b?: any | null): boolean;
        }
        interface ErrorClearFunc {
            (error: Error): void;
        }
        interface ErrorCopyFunc {
            (src_error: Error, dest_error: Error): void;
        }
        interface ErrorInitFunc {
            (error: Error): void;
        }
        interface FreeFunc {
            (data?: any | null): void;
        }
        interface Func {
            (data?: any | null): void;
        }
        interface HFunc {
            (key?: any | null, value?: any | null): void;
        }
        interface HRFunc {
            (key?: any | null, value?: any | null): boolean;
        }
        interface HashFunc {
            (key?: any | null): number;
        }
        interface HookCheckFunc {
            (data?: any | null): boolean;
        }
        interface HookCheckMarshaller {
            (hook: Hook, marshal_data?: any | null): boolean;
        }
        interface HookCompareFunc {
            (new_hook: Hook, sibling: Hook): number;
        }
        interface HookFinalizeFunc {
            (hook_list: HookList, hook: Hook): void;
        }
        interface HookFindFunc {
            (hook: Hook, data?: any | null): boolean;
        }
        interface HookFunc {
            (data?: any | null): void;
        }
        interface HookMarshaller {
            (hook: Hook, marshal_data?: any | null): void;
        }
        interface IOFunc {
            (source: IOChannel, condition: IOCondition, data?: any | null): boolean;
        }
        interface LogFunc {
            (log_domain: string | null, log_level: LogLevelFlags, message: string): void;
        }
        interface LogWriterFunc {
            (log_level: LogLevelFlags, fields: LogField[]): LogWriterOutput;
        }
        interface NodeForeachFunc {
            (node: Node, data?: any | null): void;
        }
        interface NodeTraverseFunc {
            (node: Node, data?: any | null): boolean;
        }
        interface OptionArgFunc {
            (option_name: string, value: string, data?: any | null): boolean;
        }
        interface OptionErrorFunc {
            (context: OptionContext, group: OptionGroup, data?: any | null): void;
        }
        interface OptionParseFunc {
            (context: OptionContext, group: OptionGroup, data?: any | null): boolean;
        }
        interface PollFunc {
            (ufds: PollFD, nfsd: number, timeout_: number): number;
        }
        interface PrintFunc {
            (string: string): void;
        }
        interface RegexEvalCallback {
            (match_info: MatchInfo, result: String): boolean;
        }
        interface ScannerMsgFunc {
            (scanner: Scanner, message: string, error: boolean): void;
        }
        interface SequenceIterCompareFunc {
            (a: SequenceIter, b: SequenceIter, data?: any | null): number;
        }
        interface SourceDisposeFunc {
            (source: Source): void;
        }
        interface SourceDummyMarshal {
            (): void;
        }
        interface SourceFunc {
            (): boolean;
        }
        interface SourceFuncsCheckFunc {
            (source: Source): boolean;
        }
        interface SourceFuncsFinalizeFunc {
            (source: Source): void;
        }
        interface SourceFuncsPrepareFunc {
            (source: Source): boolean;
        }
        interface SourceOnceFunc {
            (): void;
        }
        interface SpawnChildSetupFunc {
            (data?: any | null): void;
        }
        interface TestDataFunc {
            (): void;
        }
        interface TestFixtureFunc {
            (fixture: any): void;
        }
        interface TestFunc {
            (): void;
        }
        interface TestLogFatalFunc {
            (log_domain: string, log_level: LogLevelFlags, message: string): boolean;
        }
        interface ThreadFunc {
            (data?: any | null): any | null;
        }
        interface TranslateFunc {
            (str: string, data?: any | null): string;
        }
        interface TraverseFunc {
            (key?: any | null, value?: any | null, data?: any | null): boolean;
        }
        interface TraverseNodeFunc {
            (node: TreeNode, data?: any | null): boolean;
        }
        interface UnixFDSourceFunc {
            (fd: number, condition: IOCondition): boolean;
        }
        interface VoidFunc {
            (): void;
        }

        export namespace AsciiType {
            export const $gtype: GObject.GType<AsciiType>;
        }

        enum AsciiType {
            ALNUM,
            ALPHA,
            CNTRL,
            DIGIT,
            GRAPH,
            LOWER,
            PRINT,
            PUNCT,
            SPACE,
            UPPER,
            XDIGIT,
        }
        /**
         * Flags to pass to g_file_set_contents_full() to affect its safety and
         * performance.
         */

        /**
         * Flags to pass to g_file_set_contents_full() to affect its safety and
         * performance.
         */
        export namespace FileSetContentsFlags {
            export const $gtype: GObject.GType<FileSetContentsFlags>;
        }

        enum FileSetContentsFlags {
            /**
             * No guarantees about file consistency or durability.
             *   The most dangerous setting, which is slightly faster than other settings.
             */
            NONE,
            /**
             * Guarantee file consistency: after a crash,
             *   either the old version of the file or the new version of the file will be
             *   available, but not a mixture. On Unix systems this equates to an `fsync()`
             *   on the file and use of an atomic `rename()` of the new version of the file
             *   over the old.
             */
            CONSISTENT,
            /**
             * Guarantee file durability: after a crash, the
             *   new version of the file will be available. On Unix systems this equates to
             *   an `fsync()` on the file (if %G_FILE_SET_CONTENTS_CONSISTENT is unset), or
             *   the effects of %G_FILE_SET_CONTENTS_CONSISTENT plus an `fsync()` on the
             *   directory containing the file after calling `rename()`.
             */
            DURABLE,
            /**
             * Only apply consistency and durability
             *   guarantees if the file already exists. This may speed up file operations
             *   if the file doesn’t currently exist, but may result in a corrupted version
             *   of the new file if the system crashes while writing it.
             */
            ONLY_EXISTING,
        }
        /**
         * A test to perform on a file using g_file_test().
         */

        /**
         * A test to perform on a file using g_file_test().
         */
        export namespace FileTest {
            export const $gtype: GObject.GType<FileTest>;
        }

        enum FileTest {
            /**
             * %TRUE if the file is a regular file
             *     (not a directory). Note that this test will also return %TRUE
             *     if the tested file is a symlink to a regular file.
             */
            IS_REGULAR,
            /**
             * %TRUE if the file is a symlink.
             */
            IS_SYMLINK,
            /**
             * %TRUE if the file is a directory.
             */
            IS_DIR,
            /**
             * %TRUE if the file is executable.
             */
            IS_EXECUTABLE,
            /**
             * %TRUE if the file exists. It may or may not
             *     be a regular file.
             */
            EXISTS,
        }
        /**
         * Flags to modify the format of the string returned by g_format_size_full().
         */

        /**
         * Flags to modify the format of the string returned by g_format_size_full().
         */
        export namespace FormatSizeFlags {
            export const $gtype: GObject.GType<FormatSizeFlags>;
        }

        enum FormatSizeFlags {
            /**
             * behave the same as g_format_size()
             */
            DEFAULT,
            /**
             * include the exact number of bytes as part
             *     of the returned string.  For example, "45.6 kB (45,612 bytes)".
             */
            LONG_FORMAT,
            /**
             * use IEC (base 1024) units with "KiB"-style
             *     suffixes. IEC units should only be used for reporting things with
             *     a strong "power of 2" basis, like RAM sizes or RAID stripe sizes.
             *     Network and storage sizes should be reported in the normal SI units.
             */
            IEC_UNITS,
            /**
             * set the size as a quantity in bits, rather than
             *     bytes, and return units in bits. For example, ‘Mbit’ rather than ‘MB’.
             */
            BITS,
            /**
             * return only value, without unit; this should
             *     not be used together with `G_FORMAT_SIZE_LONG_FORMAT`
             *     nor `G_FORMAT_SIZE_ONLY_UNIT`. Since: 2.74
             */
            ONLY_VALUE,
            /**
             * return only unit, without value; this should
             *     not be used together with `G_FORMAT_SIZE_LONG_FORMAT`
             *     nor `G_FORMAT_SIZE_ONLY_VALUE`. Since: 2.74
             */
            ONLY_UNIT,
        }
        /**
         * Flags used internally in the #GHook implementation.
         */

        /**
         * Flags used internally in the #GHook implementation.
         */
        export namespace HookFlagMask {
            export const $gtype: GObject.GType<HookFlagMask>;
        }

        enum HookFlagMask {
            /**
             * set if the hook has not been destroyed
             */
            ACTIVE,
            /**
             * set if the hook is currently being run
             */
            IN_CALL,
            /**
             * A mask covering all bits reserved for
             *   hook flags; see %G_HOOK_FLAG_USER_SHIFT
             */
            MASK,
        }
        /**
         * A bitwise combination representing a condition to watch for on an
         * event source.
         */

        /**
         * A bitwise combination representing a condition to watch for on an
         * event source.
         */
        export namespace IOCondition {
            export const $gtype: GObject.GType<IOCondition>;
        }

        enum IOCondition {
            /**
             * There is data to read.
             */
            IN,
            /**
             * Data can be written (without blocking).
             */
            OUT,
            /**
             * There is urgent data to read.
             */
            PRI,
            /**
             * Error condition.
             */
            ERR,
            /**
             * Hung up (the connection has been broken, usually for
             *            pipes and sockets).
             */
            HUP,
            /**
             * Invalid request. The file descriptor is not open.
             */
            NVAL,
        }
        /**
         * Specifies properties of a #GIOChannel. Some of the flags can only be
         * read with g_io_channel_get_flags(), but not changed with
         * g_io_channel_set_flags().
         */

        /**
         * Specifies properties of a #GIOChannel. Some of the flags can only be
         * read with g_io_channel_get_flags(), but not changed with
         * g_io_channel_set_flags().
         */
        export namespace IOFlags {
            export const $gtype: GObject.GType<IOFlags>;
        }

        enum IOFlags {
            /**
             * no special flags set. Since: 2.74
             */
            NONE,
            /**
             * turns on append mode, corresponds to %O_APPEND
             *     (see the documentation of the UNIX open() syscall)
             */
            APPEND,
            /**
             * turns on nonblocking mode, corresponds to
             *     %O_NONBLOCK/%O_NDELAY (see the documentation of the UNIX open()
             *     syscall)
             */
            NONBLOCK,
            /**
             * indicates that the io channel is readable.
             *     This flag cannot be changed.
             */
            IS_READABLE,
            /**
             * indicates that the io channel is writable.
             *     This flag cannot be changed.
             */
            IS_WRITABLE,
            /**
             * a misspelled version of `G_IO_FLAG_IS_WRITABLE`
             *     that existed before the spelling was fixed in GLib 2.30. It is kept
             *     here for compatibility reasons. Deprecated since 2.30
             */
            IS_WRITEABLE,
            /**
             * indicates that the io channel is seekable,
             *     i.e. that g_io_channel_seek_position() can be used on it.
             *     This flag cannot be changed.
             */
            IS_SEEKABLE,
            /**
             * the mask that specifies all the valid flags.
             */
            MASK,
            /**
             * the mask of the flags that are returned from
             *     g_io_channel_get_flags()
             */
            GET_MASK,
            /**
             * the mask of the flags that the user can modify
             *     with g_io_channel_set_flags()
             */
            SET_MASK,
        }
        /**
         * Flags which influence the parsing.
         */

        /**
         * Flags which influence the parsing.
         */
        export namespace KeyFileFlags {
            export const $gtype: GObject.GType<KeyFileFlags>;
        }

        enum KeyFileFlags {
            /**
             * No flags, default behaviour
             */
            NONE,
            /**
             * Use this flag if you plan to write the
             *   (possibly modified) contents of the key file back to a file;
             *   otherwise all comments will be lost when the key file is
             *   written back.
             */
            KEEP_COMMENTS,
            /**
             * Use this flag if you plan to write the
             *   (possibly modified) contents of the key file back to a file;
             *   otherwise only the translations for the current language will be
             *   written back.
             */
            KEEP_TRANSLATIONS,
        }
        /**
         * Flags specifying the level of log messages.
         *
         * It is possible to change how GLib treats messages of the various
         * levels using [func`GLib`.log_set_handler] and [func`GLib`.log_set_fatal_mask].
         */

        /**
         * Flags specifying the level of log messages.
         *
         * It is possible to change how GLib treats messages of the various
         * levels using [func`GLib`.log_set_handler] and [func`GLib`.log_set_fatal_mask].
         */
        export namespace LogLevelFlags {
            export const $gtype: GObject.GType<LogLevelFlags>;
        }

        enum LogLevelFlags {
            /**
             * internal flag
             */
            FLAG_RECURSION,
            /**
             * internal flag
             */
            FLAG_FATAL,
            /**
             * log level for errors, see [func`GLib`.error].
             *   This level is also used for messages produced by [func`GLib`.assert].
             */
            LEVEL_ERROR,
            /**
             * log level for critical warning messages, see
             *   [func`GLib`.critical]. This level is also used for messages produced by
             *   [func`GLib`.return_if_fail] and [func`GLib`.return_val_if_fail].
             */
            LEVEL_CRITICAL,
            /**
             * log level for warnings, see [func`GLib`.warning]
             */
            LEVEL_WARNING,
            /**
             * log level for messages, see [func`GLib`.message]
             */
            LEVEL_MESSAGE,
            /**
             * log level for informational messages, see [func`GLib`.info]
             */
            LEVEL_INFO,
            /**
             * log level for debug messages, see [func`GLib`.debug]
             */
            LEVEL_DEBUG,
            /**
             * a mask including all log levels
             */
            LEVEL_MASK,
        }
        /**
         * Flags to pass to [ctor`GLib`.MainContext.new_with_flags] which affect the
         * behaviour of a [struct`GLib`.MainContext].
         */

        /**
         * Flags to pass to [ctor`GLib`.MainContext.new_with_flags] which affect the
         * behaviour of a [struct`GLib`.MainContext].
         */
        export namespace MainContextFlags {
            export const $gtype: GObject.GType<MainContextFlags>;
        }

        enum MainContextFlags {
            /**
             * Default behaviour.
             */
            NONE,
            /**
             * Assume that polling for events will
             * free the thread to process other jobs. That's useful if you're using
             * `g_main_context_{prepare,query,check,dispatch}` to integrate GMainContext in
             * other event loops.
             */
            OWNERLESS_POLLING,
        }
        /**
         * A mixed enumerated type and flags field. You must specify one type
         * (string, strdup, boolean, tristate).  Additionally, you may  optionally
         * bitwise OR the type with the flag %G_MARKUP_COLLECT_OPTIONAL.
         *
         * It is likely that this enum will be extended in the future to
         * support other types.
         */

        /**
         * A mixed enumerated type and flags field. You must specify one type
         * (string, strdup, boolean, tristate).  Additionally, you may  optionally
         * bitwise OR the type with the flag %G_MARKUP_COLLECT_OPTIONAL.
         *
         * It is likely that this enum will be extended in the future to
         * support other types.
         */
        export namespace MarkupCollectType {
            export const $gtype: GObject.GType<MarkupCollectType>;
        }

        enum MarkupCollectType {
            /**
             * used to terminate the list of attributes
             *     to collect
             */
            INVALID,
            /**
             * collect the string pointer directly from
             *     the attribute_values[] array. Expects a parameter of type (const
             *     char **). If %G_MARKUP_COLLECT_OPTIONAL is specified and the
             *     attribute isn't present then the pointer will be set to %NULL
             */
            STRING,
            /**
             * as with %G_MARKUP_COLLECT_STRING, but
             *     expects a parameter of type (char **) and g_strdup()s the
             *     returned pointer. The pointer must be freed with g_free()
             */
            STRDUP,
            /**
             * expects a parameter of type (`gboolean *`)
             *     and parses the attribute value as a boolean. Sets %FALSE if the
             *     attribute isn't present. Valid boolean values consist of
             *     (case-insensitive) "false", "f", "no", "n", "0" and "true", "t",
             *     "yes", "y", "1"
             */
            BOOLEAN,
            /**
             * as with %G_MARKUP_COLLECT_BOOLEAN, but
             *     in the case of a missing attribute a value is set that compares
             *     equal to neither %FALSE nor %TRUE %G_MARKUP_COLLECT_OPTIONAL is
             *     implied
             */
            TRISTATE,
            /**
             * can be bitwise ORed with the other fields.
             *     If present, allows the attribute not to appear. A default value
             *     is set depending on what value type is used
             */
            OPTIONAL,
        }
        /**
         * Flags that affect the behaviour of the parser.
         */

        /**
         * Flags that affect the behaviour of the parser.
         */
        export namespace MarkupParseFlags {
            export const $gtype: GObject.GType<MarkupParseFlags>;
        }

        enum MarkupParseFlags {
            /**
             * No special behaviour. Since: 2.74
             */
            DEFAULT_FLAGS,
            /**
             * flag you should not use
             */
            DO_NOT_USE_THIS_UNSUPPORTED_FLAG,
            /**
             * When this flag is set, CDATA marked
             *     sections are not passed literally to the `passthrough` function of
             *     the parser. Instead, the content of the section (without the
             *     `<![CDATA[` and `]]>`) is
             *     passed to the `text` function. This flag was added in GLib 2.12
             */
            TREAT_CDATA_AS_TEXT,
            /**
             * Normally errors caught by GMarkup
             *     itself have line/column information prefixed to them to let the
             *     caller know the location of the error. When this flag is set the
             *     location information is also prefixed to errors generated by the
             *     #GMarkupParser implementation functions
             */
            PREFIX_ERROR_POSITION,
            /**
             * Ignore (don't report) qualified
             *     attributes and tags, along with their contents.  A qualified
             *     attribute or tag is one that contains ':' in its name (ie: is in
             *     another namespace).  Since: 2.40.
             */
            IGNORE_QUALIFIED,
        }
        /**
         * Flags which modify individual options.
         */

        /**
         * Flags which modify individual options.
         */
        export namespace OptionFlags {
            export const $gtype: GObject.GType<OptionFlags>;
        }

        enum OptionFlags {
            /**
             * No flags.
             */
            NONE,
            /**
             * The option doesn't appear in `--help` output.
             */
            HIDDEN,
            /**
             * The option appears in the main section of the
             *   `--help` output, even if it is defined in a group.
             */
            IN_MAIN,
            /**
             * For options of the %G_OPTION_ARG_NONE kind, this
             *   flag indicates that the sense of the option is reversed. i.e. %FALSE will
             *   be stored into the argument rather than %TRUE.
             */
            REVERSE,
            /**
             * For options of the %G_OPTION_ARG_CALLBACK kind,
             *   this flag indicates that the callback does not take any argument
             *   (like a %G_OPTION_ARG_NONE option). Since 2.8
             */
            NO_ARG,
            /**
             * For options of the %G_OPTION_ARG_CALLBACK
             *   kind, this flag indicates that the argument should be passed to the
             *   callback in the GLib filename encoding rather than UTF-8. Since 2.8
             */
            FILENAME,
            /**
             * For options of the %G_OPTION_ARG_CALLBACK
             *   kind, this flag indicates that the argument supply is optional.
             *   If no argument is given then data of %GOptionParseFunc will be
             *   set to NULL. Since 2.8
             */
            OPTIONAL_ARG,
            /**
             * This flag turns off the automatic conflict
             *   resolution which prefixes long option names with `groupname-` if
             *   there is a conflict. This option should only be used in situations
             *   where aliasing is necessary to model some legacy commandline interface.
             *   It is not safe to use this option, unless all option groups are under
             *   your direct control. Since 2.8.
             */
            NOALIAS,
            /**
             * This flag marks the option as deprecated in the `--help`.
             *
             * You should update the description of the option to describe what
             * the user should do in response to the deprecation, for instance:
             * remove the option, or replace it with another one.
             */
            DEPRECATED,
        }
        /**
         * Flags specifying compile-time options.
         */

        /**
         * Flags specifying compile-time options.
         */
        export namespace RegexCompileFlags {
            export const $gtype: GObject.GType<RegexCompileFlags>;
        }

        enum RegexCompileFlags {
            /**
             * No special options set. Since: 2.74
             */
            DEFAULT,
            /**
             * Letters in the pattern match both upper- and
             *     lowercase letters. This option can be changed within a pattern
             *     by a "(?i)" option setting.
             */
            CASELESS,
            /**
             * By default, GRegex treats the strings as consisting
             *     of a single line of characters (even if it actually contains
             *     newlines). The "start of line" metacharacter ("^") matches only
             *     at the start of the string, while the "end of line" metacharacter
             *     ("$") matches only at the end of the string, or before a terminating
             *     newline (unless %G_REGEX_DOLLAR_ENDONLY is set). When
             *     %G_REGEX_MULTILINE is set, the "start of line" and "end of line"
             *     constructs match immediately following or immediately before any
             *     newline in the string, respectively, as well as at the very start
             *     and end. This can be changed within a pattern by a "(?m)" option
             *     setting.
             */
            MULTILINE,
            /**
             * A dot metacharacter (".") in the pattern matches all
             *     characters, including newlines. Without it, newlines are excluded.
             *     This option can be changed within a pattern by a ("?s") option setting.
             */
            DOTALL,
            /**
             * Whitespace data characters in the pattern are
             *     totally ignored except when escaped or inside a character class.
             *     Whitespace does not include the VT character (code 11). In addition,
             *     characters between an unescaped "#" outside a character class and
             *     the next newline character, inclusive, are also ignored. This can
             *     be changed within a pattern by a "(?x)" option setting.
             */
            EXTENDED,
            /**
             * The pattern is forced to be "anchored", that is,
             *     it is constrained to match only at the first matching point in the
             *     string that is being searched. This effect can also be achieved by
             *     appropriate constructs in the pattern itself such as the "^"
             *     metacharacter.
             */
            ANCHORED,
            /**
             * A dollar metacharacter ("$") in the pattern
             *     matches only at the end of the string. Without this option, a
             *     dollar also matches immediately before the final character if
             *     it is a newline (but not before any other newlines). This option
             *     is ignored if %G_REGEX_MULTILINE is set.
             */
            DOLLAR_ENDONLY,
            /**
             * Inverts the "greediness" of the quantifiers so that
             *     they are not greedy by default, but become greedy if followed by "?".
             *     It can also be set by a "(?U)" option setting within the pattern.
             */
            UNGREEDY,
            /**
             * Usually strings must be valid UTF-8 strings, using this
             *     flag they are considered as a raw sequence of bytes.
             */
            RAW,
            /**
             * Disables the use of numbered capturing
             *     parentheses in the pattern. Any opening parenthesis that is not
             *     followed by "?" behaves as if it were followed by "?:" but named
             *     parentheses can still be used for capturing (and they acquire numbers
             *     in the usual way).
             */
            NO_AUTO_CAPTURE,
            /**
             * Since 2.74 and the port to pcre2, requests JIT
             *     compilation, which, if the just-in-time compiler is available, further
             *     processes a compiled pattern into machine code that executes much
             *     faster. However, it comes at the cost of extra processing before the
             *     match is performed, so it is most beneficial to use this when the same
             *     compiled pattern is used for matching many times. Before 2.74 this
             *     option used the built-in non-JIT optimizations in pcre1.
             */
            OPTIMIZE,
            /**
             * Limits an unanchored pattern to match before (or at) the
             *     first newline. Since: 2.34
             */
            FIRSTLINE,
            /**
             * Names used to identify capturing subpatterns need not
             *     be unique. This can be helpful for certain types of pattern when it
             *     is known that only one instance of the named subpattern can ever be
             *     matched.
             */
            DUPNAMES,
            /**
             * Usually any newline character or character sequence is
             *     recognized. If this option is set, the only recognized newline character
             *     is '\r'.
             */
            NEWLINE_CR,
            /**
             * Usually any newline character or character sequence is
             *     recognized. If this option is set, the only recognized newline character
             *     is '\n'.
             */
            NEWLINE_LF,
            /**
             * Usually any newline character or character sequence is
             *     recognized. If this option is set, the only recognized newline character
             *     sequence is '\r\n'.
             */
            NEWLINE_CRLF,
            /**
             * Usually any newline character or character sequence
             *     is recognized. If this option is set, the only recognized newline character
             *     sequences are '\r', '\n', and '\r\n'. Since: 2.34
             */
            NEWLINE_ANYCRLF,
            /**
             * Usually any newline character or character sequence
             *     is recognised. If this option is set, then "\R" only recognizes the newline
             *    characters '\r', '\n' and '\r\n'. Since: 2.34
             */
            BSR_ANYCRLF,
            /**
             * Changes behaviour so that it is compatible with
             *     JavaScript rather than PCRE. Since GLib 2.74 this is no longer supported,
             *     as libpcre2 does not support it. Since: 2.34 Deprecated: 2.74
             */
            JAVASCRIPT_COMPAT,
        }
        /**
         * Flags specifying match-time options.
         */

        /**
         * Flags specifying match-time options.
         */
        export namespace RegexMatchFlags {
            export const $gtype: GObject.GType<RegexMatchFlags>;
        }

        enum RegexMatchFlags {
            /**
             * No special options set. Since: 2.74
             */
            DEFAULT,
            /**
             * The pattern is forced to be "anchored", that is,
             *     it is constrained to match only at the first matching point in the
             *     string that is being searched. This effect can also be achieved by
             *     appropriate constructs in the pattern itself such as the "^"
             *     metacharacter.
             */
            ANCHORED,
            /**
             * Specifies that first character of the string is
             *     not the beginning of a line, so the circumflex metacharacter should
             *     not match before it. Setting this without %G_REGEX_MULTILINE (at
             *     compile time) causes circumflex never to match. This option affects
             *     only the behaviour of the circumflex metacharacter, it does not
             *     affect "\A".
             */
            NOTBOL,
            /**
             * Specifies that the end of the subject string is
             *     not the end of a line, so the dollar metacharacter should not match
             *     it nor (except in multiline mode) a newline immediately before it.
             *     Setting this without %G_REGEX_MULTILINE (at compile time) causes
             *     dollar never to match. This option affects only the behaviour of
             *     the dollar metacharacter, it does not affect "\Z" or "\z".
             */
            NOTEOL,
            /**
             * An empty string is not considered to be a valid
             *     match if this option is set. If there are alternatives in the pattern,
             *     they are tried. If all the alternatives match the empty string, the
             *     entire match fails. For example, if the pattern "a?b?" is applied to
             *     a string not beginning with "a" or "b", it matches the empty string
             *     at the start of the string. With this flag set, this match is not
             *     valid, so GRegex searches further into the string for occurrences
             *     of "a" or "b".
             */
            NOTEMPTY,
            /**
             * Turns on the partial matching feature, for more
             *     documentation on partial matching see g_match_info_is_partial_match().
             */
            PARTIAL,
            /**
             * Overrides the newline definition set when
             *     creating a new #GRegex, setting the '\r' character as line terminator.
             */
            NEWLINE_CR,
            /**
             * Overrides the newline definition set when
             *     creating a new #GRegex, setting the '\n' character as line terminator.
             */
            NEWLINE_LF,
            /**
             * Overrides the newline definition set when
             *     creating a new #GRegex, setting the '\r\n' characters sequence as line terminator.
             */
            NEWLINE_CRLF,
            /**
             * Overrides the newline definition set when
             *     creating a new #GRegex, any Unicode newline sequence
             *     is recognised as a newline. These are '\r', '\n' and '\rn', and the
             *     single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),
             *     U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and
             *     U+2029 PARAGRAPH SEPARATOR.
             */
            NEWLINE_ANY,
            /**
             * Overrides the newline definition set when
             *     creating a new #GRegex; any '\r', '\n', or '\r\n' character sequence
             *     is recognized as a newline. Since: 2.34
             */
            NEWLINE_ANYCRLF,
            /**
             * Overrides the newline definition for "\R" set when
             *     creating a new #GRegex; only '\r', '\n', or '\r\n' character sequences
             *     are recognized as a newline by "\R". Since: 2.34
             */
            BSR_ANYCRLF,
            /**
             * Overrides the newline definition for "\R" set when
             *     creating a new #GRegex; any Unicode newline character or character sequence
             *     are recognized as a newline by "\R". These are '\r', '\n' and '\rn', and the
             *     single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),
             *     U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and
             *     U+2029 PARAGRAPH SEPARATOR. Since: 2.34
             */
            BSR_ANY,
            /**
             * An alias for %G_REGEX_MATCH_PARTIAL. Since: 2.34
             */
            PARTIAL_SOFT,
            /**
             * Turns on the partial matching feature. In contrast to
             *     to %G_REGEX_MATCH_PARTIAL_SOFT, this stops matching as soon as a partial match
             *     is found, without continuing to search for a possible complete match. See
             *     g_match_info_is_partial_match() for more information. Since: 2.34
             */
            PARTIAL_HARD,
            /**
             * Like %G_REGEX_MATCH_NOTEMPTY, but only applied to
             *     the start of the matched string. For anchored
             *     patterns this can only happen for pattern containing "\K". Since: 2.34
             */
            NOTEMPTY_ATSTART,
        }
        /**
         * Flags passed to g_spawn_sync(), g_spawn_async() and g_spawn_async_with_pipes().
         */

        /**
         * Flags passed to g_spawn_sync(), g_spawn_async() and g_spawn_async_with_pipes().
         */
        export namespace SpawnFlags {
            export const $gtype: GObject.GType<SpawnFlags>;
        }

        enum SpawnFlags {
            /**
             * no flags, default behaviour
             */
            DEFAULT,
            /**
             * the parent's open file descriptors will
             *     be inherited by the child; otherwise all descriptors except stdin,
             *     stdout and stderr will be closed before calling exec() in the child.
             */
            LEAVE_DESCRIPTORS_OPEN,
            /**
             * the child will not be automatically reaped;
             *     you must use g_child_watch_add() yourself (or call waitpid() or handle
             *     `SIGCHLD` yourself), or the child will become a zombie.
             */
            DO_NOT_REAP_CHILD,
            /**
             * `argv[0]` need not be an absolute path, it will be
             *     looked for in the user's `PATH`.
             */
            SEARCH_PATH,
            /**
             * the child's standard output will be discarded,
             *     instead of going to the same location as the parent's standard output.
             */
            STDOUT_TO_DEV_NULL,
            /**
             * the child's standard error will be discarded.
             */
            STDERR_TO_DEV_NULL,
            /**
             * the child will inherit the parent's standard
             *     input (by default, the child's standard input is attached to `/dev/null`).
             */
            CHILD_INHERITS_STDIN,
            /**
             * the first element of `argv` is the file to
             *     execute, while the remaining elements are the actual argument vector
             *     to pass to the file. Normally g_spawn_async_with_pipes() uses `argv[0]`
             *     as the file to execute, and passes all of `argv` to the child.
             */
            FILE_AND_ARGV_ZERO,
            /**
             * if `argv[0]` is not an absolute path,
             *     it will be looked for in the `PATH` from the passed child environment.
             *     Since: 2.34
             */
            SEARCH_PATH_FROM_ENVP,
            /**
             * create all pipes with the `O_CLOEXEC` flag set.
             *     Since: 2.40
             */
            CLOEXEC_PIPES,
            /**
             * The child will inherit the parent's standard output.
             */
            CHILD_INHERITS_STDOUT,
            /**
             * The child will inherit the parent's standard error.
             */
            CHILD_INHERITS_STDERR,
            /**
             * The child's standard input is attached to `/dev/null`.
             */
            STDIN_FROM_DEV_NULL,
        }
        /**
         * Flags to pass to [func`GLib`.test_trap_subprocess] to control input and output.
         *
         * Note that in contrast with [func`GLib`.test_trap_fork], the default
         * behavior of [func`GLib`.test_trap_subprocess] is to not show stdout
         * and stderr.
         */

        /**
         * Flags to pass to [func`GLib`.test_trap_subprocess] to control input and output.
         *
         * Note that in contrast with [func`GLib`.test_trap_fork], the default
         * behavior of [func`GLib`.test_trap_subprocess] is to not show stdout
         * and stderr.
         */
        export namespace TestSubprocessFlags {
            export const $gtype: GObject.GType<TestSubprocessFlags>;
        }

        enum TestSubprocessFlags {
            /**
             * Default behaviour. Since: 2.74
             */
            DEFAULT,
            /**
             * If this flag is given, the child
             *   process will inherit the parent's stdin. Otherwise, the child's
             *   stdin is redirected to `/dev/null`.
             */
            INHERIT_STDIN,
            /**
             * If this flag is given, the child
             *   process will inherit the parent's stdout. Otherwise, the child's
             *   stdout will not be visible, but it will be captured to allow
             *   later tests with [func`GLib`.test_trap_assert_stdout].
             */
            INHERIT_STDOUT,
            /**
             * If this flag is given, the child
             *   process will inherit the parent's stderr. Otherwise, the child's
             *   stderr will not be visible, but it will be captured to allow
             *   later tests with [func`GLib`.test_trap_assert_stderr].
             */
            INHERIT_STDERR,
        }
        /**
         * Flags to pass to [func`GLib`.test_trap_fork] to control input and output.
         *
         * Test traps are guards around forked tests. These flags determine what traps to set.
         */

        /**
         * Flags to pass to [func`GLib`.test_trap_fork] to control input and output.
         *
         * Test traps are guards around forked tests. These flags determine what traps to set.
         */
        export namespace TestTrapFlags {
            export const $gtype: GObject.GType<TestTrapFlags>;
        }

        enum TestTrapFlags {
            /**
             * Default behaviour. Since: 2.74
             */
            DEFAULT,
            /**
             * Redirect stdout of the test child to
             *     `/dev/null` so it cannot be observed on the console during test
             *     runs. The actual output is still captured though to allow later
             *     tests with g_test_trap_assert_stdout().
             */
            SILENCE_STDOUT,
            /**
             * Redirect stderr of the test child to
             *     `/dev/null` so it cannot be observed on the console during test
             *     runs. The actual output is still captured though to allow later
             *     tests with g_test_trap_assert_stderr().
             */
            SILENCE_STDERR,
            /**
             * If this flag is given, stdin of the
             *     child process is shared with stdin of its parent process.
             *     It is redirected to `/dev/null` otherwise.
             */
            INHERIT_STDIN,
        }
        /**
         * Specifies which nodes are visited during several of the tree
         * functions, including g_node_traverse() and g_node_find().
         */

        /**
         * Specifies which nodes are visited during several of the tree
         * functions, including g_node_traverse() and g_node_find().
         */
        export namespace TraverseFlags {
            export const $gtype: GObject.GType<TraverseFlags>;
        }

        enum TraverseFlags {
            /**
             * only leaf nodes should be visited. This name has
             *                     been introduced in 2.6, for older version use
             *                     %G_TRAVERSE_LEAFS.
             */
            LEAVES,
            /**
             * only non-leaf nodes should be visited. This
             *                         name has been introduced in 2.6, for older
             *                         version use %G_TRAVERSE_NON_LEAFS.
             */
            NON_LEAVES,
            /**
             * all nodes should be visited.
             */
            ALL,
            /**
             * a mask of all traverse flags.
             */
            MASK,
            /**
             * identical to %G_TRAVERSE_LEAVES.
             */
            LEAFS,
            /**
             * identical to %G_TRAVERSE_NON_LEAVES.
             */
            NON_LEAFS,
        }
        /**
         * Flags that describe a URI.
         *
         * When parsing a URI, if you need to choose different flags based on
         * the type of URI, you can use g_uri_peek_scheme() on the URI string
         * to check the scheme first, and use that to decide what flags to
         * parse it with.
         */

        /**
         * Flags that describe a URI.
         *
         * When parsing a URI, if you need to choose different flags based on
         * the type of URI, you can use g_uri_peek_scheme() on the URI string
         * to check the scheme first, and use that to decide what flags to
         * parse it with.
         */
        export namespace UriFlags {
            export const $gtype: GObject.GType<UriFlags>;
        }

        enum UriFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Parse the URI more relaxedly than the
             *     [RFC 3986](https://tools.ietf.org/html/rfc3986) grammar specifies,
             *     fixing up or ignoring common mistakes in URIs coming from external
             *     sources. This is also needed for some obscure URI schemes where `;`
             *     separates the host from the path. Don’t use this flag unless you need to.
             */
            PARSE_RELAXED,
            /**
             * The userinfo field may contain a password,
             *     which will be separated from the username by `:`.
             */
            HAS_PASSWORD,
            /**
             * The userinfo may contain additional
             *     authentication-related parameters, which will be separated from
             *     the username and/or password by `;`.
             */
            HAS_AUTH_PARAMS,
            /**
             * When parsing a URI, this indicates that `%`-encoded
             *     characters in the userinfo, path, query, and fragment fields
             *     should not be decoded. (And likewise the host field if
             *     %G_URI_FLAGS_NON_DNS is also set.) When building a URI, it indicates
             *     that you have already `%`-encoded the components, and so #GUri
             *     should not do any encoding itself.
             */
            ENCODED,
            /**
             * The host component should not be assumed to be a
             *     DNS hostname or IP address (for example, for `smb` URIs with NetBIOS
             *     hostnames).
             */
            NON_DNS,
            /**
             * Same as %G_URI_FLAGS_ENCODED, for the query
             *     field only.
             */
            ENCODED_QUERY,
            /**
             * Same as %G_URI_FLAGS_ENCODED, for the path only.
             */
            ENCODED_PATH,
            /**
             * Same as %G_URI_FLAGS_ENCODED, for the
             *     fragment only.
             */
            ENCODED_FRAGMENT,
            /**
             * A scheme-based normalization will be applied.
             *     For example, when parsing an HTTP URI changing omitted path to `/` and
             *     omitted port to `80`; and when building a URI, changing empty path to `/`
             *     and default port `80`). This only supports a subset of known schemes. (Since: 2.68)
             */
            SCHEME_NORMALIZE,
        }
        /**
         * Flags describing what parts of the URI to hide in
         * g_uri_to_string_partial(). Note that %G_URI_HIDE_PASSWORD and
         * %G_URI_HIDE_AUTH_PARAMS will only work if the #GUri was parsed with
         * the corresponding flags.
         */

        /**
         * Flags describing what parts of the URI to hide in
         * g_uri_to_string_partial(). Note that %G_URI_HIDE_PASSWORD and
         * %G_URI_HIDE_AUTH_PARAMS will only work if the #GUri was parsed with
         * the corresponding flags.
         */
        export namespace UriHideFlags {
            export const $gtype: GObject.GType<UriHideFlags>;
        }

        enum UriHideFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Hide the userinfo.
             */
            USERINFO,
            /**
             * Hide the password.
             */
            PASSWORD,
            /**
             * Hide the auth_params.
             */
            AUTH_PARAMS,
            /**
             * Hide the query.
             */
            QUERY,
            /**
             * Hide the fragment.
             */
            FRAGMENT,
        }
        /**
         * Flags modifying the way parameters are handled by g_uri_parse_params() and
         * #GUriParamsIter.
         */

        /**
         * Flags modifying the way parameters are handled by g_uri_parse_params() and
         * #GUriParamsIter.
         */
        export namespace UriParamsFlags {
            export const $gtype: GObject.GType<UriParamsFlags>;
        }

        enum UriParamsFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Parameter names are case insensitive.
             */
            CASE_INSENSITIVE,
            /**
             * Replace `+` with space character. Only useful for
             *     URLs on the web, using the `https` or `http` schemas.
             */
            WWW_FORM,
            /**
             * See %G_URI_FLAGS_PARSE_RELAXED.
             */
            PARSE_RELAXED,
        }
        abstract class Allocator {
            static $gtype: GObject.GType<Allocator>;

            // Constructors

            _init(...args: any[]): void;

            // Methods

            free(): void;
        }

        /**
         * Contains the public fields of a GArray.
         */
        class Array {
            static $gtype: GObject.GType<Array>;

            // Fields

            data: string;
            len: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    data: string;
                    len: number;
                }>,
            );
            _init(...args: any[]): void;
        }

        /**
         * An opaque data structure which represents an asynchronous queue.
         *
         * It should only be accessed through the `g_async_queue_*` functions.
         */
        abstract class AsyncQueue {
            static $gtype: GObject.GType<AsyncQueue>;

            // Constructors

            _init(...args: any[]): void;

            // Static methods

            /**
             * Creates a new asynchronous queue.
             */
            static ['new'](): AsyncQueue;
            /**
             * Creates a new asynchronous queue and sets up a destroy notify
             * function that is used to free any remaining queue items when
             * the queue is destroyed after the final unref.
             * @param item_free_func function to free queue elements
             */
            static new_full(item_free_func?: DestroyNotify | null): AsyncQueue;

            // Methods

            /**
             * Returns the length of the queue.
             *
             * Actually this function returns the number of data items in
             * the queue minus the number of waiting threads, so a negative
             * value means waiting threads, and a positive value means available
             * entries in the `queue`. A return value of 0 could mean n entries
             * in the queue and n threads waiting. This can happen due to locking
             * of the queue or due to scheduling.
             * @returns the length of the @queue
             */
            length(): number;
            /**
             * Returns the length of the queue.
             *
             * Actually this function returns the number of data items in
             * the queue minus the number of waiting threads, so a negative
             * value means waiting threads, and a positive value means available
             * entries in the `queue`. A return value of 0 could mean n entries
             * in the queue and n threads waiting. This can happen due to locking
             * of the queue or due to scheduling.
             *
             * This function must be called while holding the `queue'`s lock.
             * @returns the length of the @queue.
             */
            length_unlocked(): number;
            /**
             * Acquires the `queue'`s lock. If another thread is already
             * holding the lock, this call will block until the lock
             * becomes available.
             *
             * Call g_async_queue_unlock() to drop the lock again.
             *
             * While holding the lock, you can only call the
             * g_async_queue_*_unlocked() functions on `queue`. Otherwise,
             * deadlock may occur.
             */
            lock(): void;
            /**
             * Pops data from the `queue`. If `queue` is empty, this function
             * blocks until data becomes available.
             * @returns data from the queue
             */
            pop(): any | null;
            /**
             * Pops data from the `queue`. If `queue` is empty, this function
             * blocks until data becomes available.
             *
             * This function must be called while holding the `queue'`s lock.
             * @returns data from the queue.
             */
            pop_unlocked(): any | null;
            /**
             * Pushes the `data` into the `queue`.
             *
             * The `data` parameter must not be %NULL.
             * @param data data to push onto the @queue
             */
            push(data: any): void;
            /**
             * Pushes the `item` into the `queue`. `item` must not be %NULL.
             * In contrast to g_async_queue_push(), this function
             * pushes the new item ahead of the items already in the queue,
             * so that it will be the next one to be popped off the queue.
             * @param item data to push into the @queue
             */
            push_front(item: any): void;
            /**
             * Pushes the `item` into the `queue`. `item` must not be %NULL.
             * In contrast to g_async_queue_push_unlocked(), this function
             * pushes the new item ahead of the items already in the queue,
             * so that it will be the next one to be popped off the queue.
             *
             * This function must be called while holding the `queue'`s lock.
             * @param item data to push into the @queue
             */
            push_front_unlocked(item: any): void;
            /**
             * Inserts `data` into `queue` using `func` to determine the new
             * position.
             *
             * This function requires that the `queue` is sorted before pushing on
             * new elements, see g_async_queue_sort().
             *
             * This function will lock `queue` before it sorts the queue and unlock
             * it when it is finished.
             *
             * For an example of `func` see g_async_queue_sort().
             * @param data the @data to push into the @queue
             * @param func the #GCompareDataFunc is used to sort @queue
             */
            push_sorted(data: any, func: CompareDataFunc): void;
            /**
             * Inserts `data` into `queue` using `func` to determine the new
             * position.
             *
             * The sort function `func` is passed two elements of the `queue`.
             * It should return 0 if they are equal, a negative value if the
             * first element should be higher in the `queue` or a positive value
             * if the first element should be lower in the `queue` than the second
             * element.
             *
             * This function requires that the `queue` is sorted before pushing on
             * new elements, see g_async_queue_sort().
             *
             * This function must be called while holding the `queue'`s lock.
             *
             * For an example of `func` see g_async_queue_sort().
             * @param data the data to push into the @queue
             * @param func the #GCompareDataFunc is used to sort @queue
             */
            push_sorted_unlocked(data: any | null, func: CompareDataFunc): void;
            /**
             * Pushes the `data` into the `queue`.
             *
             * The `data` parameter must not be %NULL.
             *
             * This function must be called while holding the `queue'`s lock.
             * @param data data to push onto the @queue
             */
            push_unlocked(data: any): void;
            /**
             * Increases the reference count of the asynchronous `queue` by 1.
             * You do not need to hold the lock to call this function.
             * @returns the @queue that was passed in (since 2.6)
             */
            ref(): AsyncQueue;
            /**
             * Increases the reference count of the asynchronous `queue` by 1.
             */
            ref_unlocked(): void;
            /**
             * Remove an item from the queue.
             * @param item the data to remove from the @queue
             * @returns %TRUE if the item was removed
             */
            remove(item: any): boolean;
            /**
             * Remove an item from the queue.
             *
             * This function must be called while holding the `queue'`s lock.
             * @param item the data to remove from the @queue
             * @returns %TRUE if the item was removed
             */
            remove_unlocked(item?: any | null): boolean;
            /**
             * Sorts `queue` using `func`.
             *
             * The sort function `func` is passed two elements of the `queue`.
             * It should return 0 if they are equal, a negative value if the
             * first element should be higher in the `queue` or a positive value
             * if the first element should be lower in the `queue` than the second
             * element.
             *
             * This function will lock `queue` before it sorts the queue and unlock
             * it when it is finished.
             *
             * If you were sorting a list of priority numbers to make sure the
             * lowest priority would be at the top of the queue, you could use:
             *
             * ```c
             *  gint32 id1;
             *  gint32 id2;
             *
             *  id1 = GPOINTER_TO_INT (element1);
             *  id2 = GPOINTER_TO_INT (element2);
             *
             *  return (id1 > id2 ? +1 : id1 == id2 ? 0 : -1);
             * ```
             *
             * @param func the #GCompareDataFunc is used to sort @queue
             */
            sort(func: CompareDataFunc): void;
            /**
             * Sorts `queue` using `func`.
             *
             * The sort function `func` is passed two elements of the `queue`.
             * It should return 0 if they are equal, a negative value if the
             * first element should be higher in the `queue` or a positive value
             * if the first element should be lower in the `queue` than the second
             * element.
             *
             * This function must be called while holding the `queue'`s lock.
             * @param func the #GCompareDataFunc is used to sort @queue
             */
            sort_unlocked(func: CompareDataFunc): void;
            /**
             * Pops data from the `queue`. If the queue is empty, blocks until
             * `end_time` or until data becomes available.
             *
             * If no data is received before `end_time,` %NULL is returned.
             *
             * To easily calculate `end_time,` a combination of g_get_real_time()
             * and g_time_val_add() can be used.
             * @param end_time a #GTimeVal, determining the final time
             * @returns data from the queue or %NULL, when no data is   received before @end_time.
             */
            timed_pop(end_time: TimeVal): any | null;
            /**
             * Pops data from the `queue`. If the queue is empty, blocks until
             * `end_time` or until data becomes available.
             *
             * If no data is received before `end_time,` %NULL is returned.
             *
             * To easily calculate `end_time,` a combination of g_get_real_time()
             * and g_time_val_add() can be used.
             *
             * This function must be called while holding the `queue'`s lock.
             * @param end_time a #GTimeVal, determining the final time
             * @returns data from the queue or %NULL, when no data is   received before @end_time.
             */
            timed_pop_unlocked(end_time: TimeVal): any | null;
            /**
             * Pops data from the `queue`. If the queue is empty, blocks for
             * `timeout` microseconds, or until data becomes available.
             *
             * If no data is received before the timeout, %NULL is returned.
             * @param timeout the number of microseconds to wait
             * @returns data from the queue or %NULL, when no data is   received before the timeout.
             */
            timeout_pop(timeout: number): any | null;
            /**
             * Pops data from the `queue`. If the queue is empty, blocks for
             * `timeout` microseconds, or until data becomes available.
             *
             * If no data is received before the timeout, %NULL is returned.
             *
             * This function must be called while holding the `queue'`s lock.
             * @param timeout the number of microseconds to wait
             * @returns data from the queue or %NULL, when no data is   received before the timeout.
             */
            timeout_pop_unlocked(timeout: number): any | null;
            /**
             * Tries to pop data from the `queue`. If no data is available,
             * %NULL is returned.
             * @returns data from the queue or %NULL, when no data is   available immediately.
             */
            try_pop(): any | null;
            /**
             * Tries to pop data from the `queue`. If no data is available,
             * %NULL is returned.
             *
             * This function must be called while holding the `queue'`s lock.
             * @returns data from the queue or %NULL, when no data is   available immediately.
             */
            try_pop_unlocked(): any | null;
            /**
             * Releases the queue's lock.
             *
             * Calling this function when you have not acquired
             * the with g_async_queue_lock() leads to undefined
             * behaviour.
             */
            unlock(): void;
            /**
             * Decreases the reference count of the asynchronous `queue` by 1.
             *
             * If the reference count went to 0, the `queue` will be destroyed
             * and the memory allocated will be freed. So you are not allowed
             * to use the `queue` afterwards, as it might have disappeared.
             * You do not need to hold the lock to call this function.
             */
            unref(): void;
            /**
             * Decreases the reference count of the asynchronous `queue` by 1
             * and releases the lock. This function must be called while holding
             * the `queue'`s lock. If the reference count went to 0, the `queue`
             * will be destroyed and the memory allocated will be freed.
             */
            unref_and_unlock(): void;
        }

        /**
         * `GBookmarkFile` lets you parse, edit or create files containing bookmarks.
         *
         * Bookmarks refer to a URI, along with some meta-data about the resource
         * pointed by the URI like its MIME type, the application that is registering
         * the bookmark and the icon that should be used to represent the bookmark.
         * The data is stored using the
         * [Desktop Bookmark Specification](https://www.freedesktop.org/wiki/Specifications/desktop-bookmark-spec/).
         *
         * The syntax of the bookmark files is described in detail inside the
         * Desktop Bookmark Specification, here is a quick summary: bookmark
         * files use a sub-class of the XML Bookmark Exchange Language
         * specification, consisting of valid UTF-8 encoded XML, under the
         * `<xbel>` root element; each bookmark is stored inside a
         * `<bookmark>` element, using its URI: no relative paths can
         * be used inside a bookmark file. The bookmark may have a user defined
         * title and description, to be used instead of the URI. Under the
         * `<metadata>` element, with its owner attribute set to
         * `http://freedesktop.org`, is stored the meta-data about a resource
         * pointed by its URI. The meta-data consists of the resource's MIME
         * type; the applications that have registered a bookmark; the groups
         * to which a bookmark belongs to; a visibility flag, used to set the
         * bookmark as "private" to the applications and groups that has it
         * registered; the URI and MIME type of an icon, to be used when
         * displaying the bookmark inside a GUI.
         *
         * Here is an example of a bookmark file:
         * [bookmarks.xbel](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/glib/tests/bookmarks.xbel)
         *
         * A bookmark file might contain more than one bookmark; each bookmark
         * is accessed through its URI.
         *
         * The important caveat of bookmark files is that when you add a new
         * bookmark you must also add the application that is registering it, using
         * [method`GLib`.BookmarkFile.add_application] or [method`GLib`.BookmarkFile.set_application_info].
         * If a bookmark has no applications then it won't be dumped when creating
         * the on disk representation, using [method`GLib`.BookmarkFile.to_data] or
         * [method`GLib`.BookmarkFile.to_file].
         */
        class BookmarkFile {
            static $gtype: GObject.GType<BookmarkFile>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            static ['new'](): BookmarkFile;

            // Static methods

            static error_quark(): Quark;

            // Methods

            /**
             * Adds the application with `name` and `exec` to the list of
             * applications that have registered a bookmark for `uri` into
             * `bookmark`.
             *
             * Every bookmark inside a #GBookmarkFile must have at least an
             * application registered.  Each application must provide a name, a
             * command line useful for launching the bookmark, the number of times
             * the bookmark has been registered by the application and the last
             * time the application registered this bookmark.
             *
             * If `name` is %NULL, the name of the application will be the
             * same returned by g_get_application_name(); if `exec` is %NULL, the
             * command line will be a composition of the program name as
             * returned by g_get_prgname() and the "\%u" modifier, which will be
             * expanded to the bookmark's URI.
             *
             * This function will automatically take care of updating the
             * registrations count and timestamping in case an application
             * with the same `name` had already registered a bookmark for
             * `uri` inside `bookmark`.
             *
             * If no bookmark for `uri` is found, one is created.
             * @param uri a valid URI
             * @param name the name of the application registering the bookmark   or %NULL
             * @param exec command line to be used to launch the bookmark or %NULL
             */
            add_application(uri: string, name?: string | null, exec?: string | null): void;
            /**
             * Adds `group` to the list of groups to which the bookmark for `uri`
             * belongs to.
             *
             * If no bookmark for `uri` is found then it is created.
             * @param uri a valid URI
             * @param group the group name to be added
             */
            add_group(uri: string, group: string): void;
            /**
             * Deeply copies a `bookmark` #GBookmarkFile object to a new one.
             * @returns the copy of @bookmark. Use   g_bookmark_free() when finished using it.
             */
            copy(): BookmarkFile;
            /**
             * Frees a #GBookmarkFile.
             */
            free(): void;
            /**
             * Gets the time the bookmark for `uri` was added to `bookmark`
             *
             * In the event the URI cannot be found, -1 is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a timestamp
             */
            get_added(uri: string): never;
            /**
             * Gets the time the bookmark for `uri` was added to `bookmark`
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a #GDateTime
             */
            get_added_date_time(uri: string): DateTime;
            /**
             * Gets the registration information of `app_name` for the bookmark for
             * `uri`.  See g_bookmark_file_set_application_info() for more information about
             * the returned data.
             *
             * The string returned in `app_exec` must be freed.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.  In the
             * event that no application with name `app_name` has registered a bookmark
             * for `uri,`  %FALSE is returned and error is set to
             * %G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED. In the event that unquoting
             * the command line fails, an error of the %G_SHELL_ERROR domain is
             * set and %FALSE is returned.
             * @param uri a valid URI
             * @param name an application's name
             * @returns %TRUE on success.
             */
            get_app_info(uri: string, name: string): [boolean, string, number, never | null];
            /**
             * Gets the registration information of `app_name` for the bookmark for
             * `uri`.  See g_bookmark_file_set_application_info() for more information about
             * the returned data.
             *
             * The string returned in `app_exec` must be freed.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.  In the
             * event that no application with name `app_name` has registered a bookmark
             * for `uri,`  %FALSE is returned and error is set to
             * %G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED. In the event that unquoting
             * the command line fails, an error of the %G_SHELL_ERROR domain is
             * set and %FALSE is returned.
             * @param uri a valid URI
             * @param name an application's name
             * @returns %TRUE on success.
             */
            get_application_info(uri: string, name: string): [boolean, string, number, DateTime | null];
            /**
             * Retrieves the names of the applications that have registered the
             * bookmark for `uri`.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a newly allocated %NULL-terminated array of strings.   Use g_strfreev() to free it.
             */
            get_applications(uri: string): string[];
            /**
             * Retrieves the description of the bookmark for `uri`.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a newly allocated string or %NULL if the specified   URI cannot be found.
             */
            get_description(uri: string): string;
            /**
             * Retrieves the list of group names of the bookmark for `uri`.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             *
             * The returned array is %NULL terminated, so `length` may optionally
             * be %NULL.
             * @param uri a valid URI
             * @returns a newly allocated %NULL-terminated array of group names.   Use g_strfreev() to free it.
             */
            get_groups(uri: string): string[];
            /**
             * Gets the icon of the bookmark for `uri`.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns %TRUE if the icon for the bookmark for the URI was found.   You should free the returned strings.
             */
            get_icon(uri: string): [boolean, string, string];
            /**
             * Gets whether the private flag of the bookmark for `uri` is set.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.  In the
             * event that the private flag cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_INVALID_VALUE.
             * @param uri a valid URI
             * @returns %TRUE if the private flag is set, %FALSE otherwise.
             */
            get_is_private(uri: string): boolean;
            /**
             * Retrieves the MIME type of the resource pointed by `uri`.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.  In the
             * event that the MIME type cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_INVALID_VALUE.
             * @param uri a valid URI
             * @returns a newly allocated string or %NULL if the specified   URI cannot be found.
             */
            get_mime_type(uri: string): string;
            /**
             * Gets the time when the bookmark for `uri` was last modified.
             *
             * In the event the URI cannot be found, -1 is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a timestamp
             */
            get_modified(uri: string): never;
            /**
             * Gets the time when the bookmark for `uri` was last modified.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a #GDateTime
             */
            get_modified_date_time(uri: string): DateTime;
            /**
             * Gets the number of bookmarks inside `bookmark`.
             * @returns the number of bookmarks
             */
            get_size(): number;
            /**
             * Returns the title of the bookmark for `uri`.
             *
             * If `uri` is %NULL, the title of `bookmark` is returned.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI or %NULL
             * @returns a newly allocated string or %NULL if the specified   URI cannot be found.
             */
            get_title(uri?: string | null): string;
            /**
             * Returns all URIs of the bookmarks in the bookmark file `bookmark`.
             * The array of returned URIs will be %NULL-terminated, so `length` may
             * optionally be %NULL.
             * @returns a newly allocated %NULL-terminated array of strings.   Use g_strfreev() to free it.
             */
            get_uris(): string[];
            /**
             * Gets the time the bookmark for `uri` was last visited.
             *
             * In the event the URI cannot be found, -1 is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a timestamp.
             */
            get_visited(uri: string): never;
            /**
             * Gets the time the bookmark for `uri` was last visited.
             *
             * In the event the URI cannot be found, %NULL is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @returns a #GDateTime
             */
            get_visited_date_time(uri: string): DateTime;
            /**
             * Checks whether the bookmark for `uri` inside `bookmark` has been
             * registered by application `name`.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @param name the name of the application
             * @returns %TRUE if the application @name was found
             */
            has_application(uri: string, name: string): boolean;
            /**
             * Checks whether `group` appears in the list of groups to which
             * the bookmark for `uri` belongs to.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param uri a valid URI
             * @param group the group name to be searched
             * @returns %TRUE if @group was found.
             */
            has_group(uri: string, group: string): boolean;
            /**
             * Looks whether the desktop bookmark has an item with its URI set to `uri`.
             * @param uri a valid URI
             * @returns %TRUE if @uri is inside @bookmark, %FALSE otherwise
             */
            has_item(uri: string): boolean;
            /**
             * Loads a bookmark file from memory into an empty #GBookmarkFile
             * structure.  If the object cannot be created then `error` is set to a
             * #GBookmarkFileError.
             * @param data desktop bookmarks    loaded in memory
             * @returns %TRUE if a desktop bookmark could be loaded.
             */
            load_from_data(data: Uint8Array | string): boolean;
            /**
             * This function looks for a desktop bookmark file named `file` in the
             * paths returned from g_get_user_data_dir() and g_get_system_data_dirs(),
             * loads the file into `bookmark` and returns the file's full path in
             * `full_path`.  If the file could not be loaded then `error` is
             * set to either a #GFileError or #GBookmarkFileError.
             * @param file a relative path to a filename to open and parse
             * @returns %TRUE if a key file could be loaded, %FALSE otherwise
             */
            load_from_data_dirs(file: string): [boolean, string];
            /**
             * Loads a desktop bookmark file into an empty #GBookmarkFile structure.
             * If the file could not be loaded then `error` is set to either a #GFileError
             * or #GBookmarkFileError.
             * @param filename the path of a filename to load, in the     GLib file name encoding
             * @returns %TRUE if a desktop bookmark file could be loaded
             */
            load_from_file(filename: string): boolean;
            /**
             * Changes the URI of a bookmark item from `old_uri` to `new_uri`.  Any
             * existing bookmark for `new_uri` will be overwritten.  If `new_uri` is
             * %NULL, then the bookmark is removed.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * @param old_uri a valid URI
             * @param new_uri a valid URI, or %NULL
             * @returns %TRUE if the URI was successfully changed
             */
            move_item(old_uri: string, new_uri?: string | null): boolean;
            /**
             * Removes application registered with `name` from the list of applications
             * that have registered a bookmark for `uri` inside `bookmark`.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * In the event that no application with name `app_name` has registered
             * a bookmark for `uri,`  %FALSE is returned and error is set to
             * %G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED.
             * @param uri a valid URI
             * @param name the name of the application
             * @returns %TRUE if the application was successfully removed.
             */
            remove_application(uri: string, name: string): boolean;
            /**
             * Removes `group` from the list of groups to which the bookmark
             * for `uri` belongs to.
             *
             * In the event the URI cannot be found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND.
             * In the event no group was defined, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_INVALID_VALUE.
             * @param uri a valid URI
             * @param group the group name to be removed
             * @returns %TRUE if @group was successfully removed.
             */
            remove_group(uri: string, group: string): boolean;
            /**
             * Removes the bookmark for `uri` from the bookmark file `bookmark`.
             * @param uri a valid URI
             * @returns %TRUE if the bookmark was removed successfully.
             */
            remove_item(uri: string): boolean;
            /**
             * Sets the time the bookmark for `uri` was added into `bookmark`.
             *
             * If no bookmark for `uri` is found then it is created.
             * @param uri a valid URI
             * @param added a timestamp or -1 to use the current time
             */
            set_added(uri: string, added: never): void;
            /**
             * Sets the time the bookmark for `uri` was added into `bookmark`.
             *
             * If no bookmark for `uri` is found then it is created.
             * @param uri a valid URI
             * @param added a #GDateTime
             */
            set_added_date_time(uri: string, added: DateTime): void;
            /**
             * Sets the meta-data of application `name` inside the list of
             * applications that have registered a bookmark for `uri` inside
             * `bookmark`.
             *
             * You should rarely use this function; use g_bookmark_file_add_application()
             * and g_bookmark_file_remove_application() instead.
             *
             * `name` can be any UTF-8 encoded string used to identify an
             * application.
             * `exec` can have one of these two modifiers: "\%f", which will
             * be expanded as the local file name retrieved from the bookmark's
             * URI; "\%u", which will be expanded as the bookmark's URI.
             * The expansion is done automatically when retrieving the stored
             * command line using the g_bookmark_file_get_application_info() function.
             * `count` is the number of times the application has registered the
             * bookmark; if is < 0, the current registration count will be increased
             * by one, if is 0, the application with `name` will be removed from
             * the list of registered applications.
             * `stamp` is the Unix time of the last registration; if it is -1, the
             * current time will be used.
             *
             * If you try to remove an application by setting its registration count to
             * zero, and no bookmark for `uri` is found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND; similarly,
             * in the event that no application `name` has registered a bookmark
             * for `uri,`  %FALSE is returned and error is set to
             * %G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED.  Otherwise, if no bookmark
             * for `uri` is found, one is created.
             * @param uri a valid URI
             * @param name an application's name
             * @param exec an application's command line
             * @param count the number of registrations done for this application
             * @param stamp the time of the last registration for this application
             * @returns %TRUE if the application's meta-data was successfully   changed.
             */
            set_app_info(uri: string, name: string, exec: string, count: number, stamp: never): boolean;
            /**
             * Sets the meta-data of application `name` inside the list of
             * applications that have registered a bookmark for `uri` inside
             * `bookmark`.
             *
             * You should rarely use this function; use g_bookmark_file_add_application()
             * and g_bookmark_file_remove_application() instead.
             *
             * `name` can be any UTF-8 encoded string used to identify an
             * application.
             * `exec` can have one of these two modifiers: "\%f", which will
             * be expanded as the local file name retrieved from the bookmark's
             * URI; "\%u", which will be expanded as the bookmark's URI.
             * The expansion is done automatically when retrieving the stored
             * command line using the g_bookmark_file_get_application_info() function.
             * `count` is the number of times the application has registered the
             * bookmark; if is < 0, the current registration count will be increased
             * by one, if is 0, the application with `name` will be removed from
             * the list of registered applications.
             * `stamp` is the Unix time of the last registration.
             *
             * If you try to remove an application by setting its registration count to
             * zero, and no bookmark for `uri` is found, %FALSE is returned and
             * `error` is set to %G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND; similarly,
             * in the event that no application `name` has registered a bookmark
             * for `uri,`  %FALSE is returned and error is set to
             * %G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED.  Otherwise, if no bookmark
             * for `uri` is found, one is created.
             * @param uri a valid URI
             * @param name an application's name
             * @param exec an application's command line
             * @param count the number of registrations done for this application
             * @param stamp the time of the last registration for this application,    which may be %NULL if @count is 0
             * @returns %TRUE if the application's meta-data was successfully   changed.
             */
            set_application_info(
                uri: string,
                name: string,
                exec: string,
                count: number,
                stamp?: DateTime | null,
            ): boolean;
            /**
             * Sets `description` as the description of the bookmark for `uri`.
             *
             * If `uri` is %NULL, the description of `bookmark` is set.
             *
             * If a bookmark for `uri` cannot be found then it is created.
             * @param uri a valid URI or %NULL
             * @param description a string
             */
            set_description(uri: string | null, description: string): void;
            /**
             * Sets a list of group names for the item with URI `uri`.  Each previously
             * set group name list is removed.
             *
             * If `uri` cannot be found then an item for it is created.
             * @param uri an item's URI
             * @param groups an array of    group names, or %NULL to remove all groups
             */
            set_groups(uri: string, groups?: string[] | null): void;
            /**
             * Sets the icon for the bookmark for `uri`. If `href` is %NULL, unsets
             * the currently set icon. `href` can either be a full URL for the icon
             * file or the icon name following the Icon Naming specification.
             *
             * If no bookmark for `uri` is found one is created.
             * @param uri a valid URI
             * @param href the URI of the icon for the bookmark, or %NULL
             * @param mime_type the MIME type of the icon for the bookmark
             */
            set_icon(uri: string, href: string | null, mime_type: string): void;
            /**
             * Sets the private flag of the bookmark for `uri`.
             *
             * If a bookmark for `uri` cannot be found then it is created.
             * @param uri a valid URI
             * @param is_private %TRUE if the bookmark should be marked as private
             */
            set_is_private(uri: string, is_private: boolean): void;
            /**
             * Sets `mime_type` as the MIME type of the bookmark for `uri`.
             *
             * If a bookmark for `uri` cannot be found then it is created.
             * @param uri a valid URI
             * @param mime_type a MIME type
             */
            set_mime_type(uri: string, mime_type: string): void;
            /**
             * Sets the last time the bookmark for `uri` was last modified.
             *
             * If no bookmark for `uri` is found then it is created.
             *
             * The "modified" time should only be set when the bookmark's meta-data
             * was actually changed.  Every function of #GBookmarkFile that
             * modifies a bookmark also changes the modification time, except for
             * g_bookmark_file_set_visited_date_time().
             * @param uri a valid URI
             * @param modified a timestamp or -1 to use the current time
             */
            set_modified(uri: string, modified: never): void;
            /**
             * Sets the last time the bookmark for `uri` was last modified.
             *
             * If no bookmark for `uri` is found then it is created.
             *
             * The "modified" time should only be set when the bookmark's meta-data
             * was actually changed.  Every function of #GBookmarkFile that
             * modifies a bookmark also changes the modification time, except for
             * g_bookmark_file_set_visited_date_time().
             * @param uri a valid URI
             * @param modified a #GDateTime
             */
            set_modified_date_time(uri: string, modified: DateTime): void;
            /**
             * Sets `title` as the title of the bookmark for `uri` inside the
             * bookmark file `bookmark`.
             *
             * If `uri` is %NULL, the title of `bookmark` is set.
             *
             * If a bookmark for `uri` cannot be found then it is created.
             * @param uri a valid URI or %NULL
             * @param title a UTF-8 encoded string
             */
            set_title(uri: string | null, title: string): void;
            /**
             * Sets the time the bookmark for `uri` was last visited.
             *
             * If no bookmark for `uri` is found then it is created.
             *
             * The "visited" time should only be set if the bookmark was launched,
             * either using the command line retrieved by g_bookmark_file_get_application_info()
             * or by the default application for the bookmark's MIME type, retrieved
             * using g_bookmark_file_get_mime_type().  Changing the "visited" time
             * does not affect the "modified" time.
             * @param uri a valid URI
             * @param visited a timestamp or -1 to use the current time
             */
            set_visited(uri: string, visited: never): void;
            /**
             * Sets the time the bookmark for `uri` was last visited.
             *
             * If no bookmark for `uri` is found then it is created.
             *
             * The "visited" time should only be set if the bookmark was launched,
             * either using the command line retrieved by g_bookmark_file_get_application_info()
             * or by the default application for the bookmark's MIME type, retrieved
             * using g_bookmark_file_get_mime_type().  Changing the "visited" time
             * does not affect the "modified" time.
             * @param uri a valid URI
             * @param visited a #GDateTime
             */
            set_visited_date_time(uri: string, visited: DateTime): void;
            /**
             * This function outputs `bookmark` as a string.
             * @returns a newly allocated string holding the contents of the #GBookmarkFile
             */
            to_data(): Uint8Array;
            /**
             * This function outputs `bookmark` into a file.  The write process is
             * guaranteed to be atomic by using g_file_set_contents() internally.
             * @param filename path of the output file
             * @returns %TRUE if the file was successfully written.
             */
            to_file(filename: string): boolean;
        }

        /**
         * Contains the public fields of a GByteArray.
         */
        class ByteArray {
            static $gtype: GObject.GType<ByteArray>;

            // Fields

            data: number;
            len: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    data: number;
                    len: number;
                }>,
            );
            _init(...args: any[]): void;

            // Static methods

            /**
             * Adds the given bytes to the end of the #GByteArray.
             * The array will grow in size automatically if necessary.
             * @param array a #GByteArray
             * @param data the byte data to be added
             * @param len the number of bytes to add
             */
            static append(array: Uint8Array | string, data: number, len: number): Uint8Array;
            /**
             * Frees the memory allocated by the #GByteArray. If `free_segment` is
             * %TRUE it frees the actual byte data. If the reference count of
             * `array` is greater than one, the #GByteArray wrapper is preserved but
             * the size of `array` will be set to zero.
             * @param array a #GByteArray
             * @param free_segment if %TRUE the actual byte data is freed as well
             */
            static free(array: Uint8Array | string, free_segment: boolean): number;
            /**
             * Transfers the data from the #GByteArray into a new immutable #GBytes.
             *
             * The #GByteArray is freed unless the reference count of `array` is greater
             * than one, the #GByteArray wrapper is preserved but the size of `array`
             * will be set to zero.
             *
             * This is identical to using g_bytes_new_take() and g_byte_array_free()
             * together.
             * @param array a #GByteArray
             */
            static free_to_bytes(array: Uint8Array | string): Bytes;
            /**
             * Creates a new #GByteArray with a reference count of 1.
             */
            static ['new'](): Uint8Array;
            /**
             * Creates a byte array containing the `data`.
             * After this call, `data` belongs to the #GByteArray and may no longer be
             * modified by the caller. The memory of `data` has to be dynamically
             * allocated and will eventually be freed with g_free().
             *
             * Do not use it if `len` is greater than %G_MAXUINT. #GByteArray
             * stores the length of its data in #guint, which may be shorter than
             * #gsize.
             * @param data byte data for the array
             */
            static new_take(data: Uint8Array | string): Uint8Array;
            /**
             * Adds the given data to the start of the #GByteArray.
             * The array will grow in size automatically if necessary.
             * @param array a #GByteArray
             * @param data the byte data to be added
             * @param len the number of bytes to add
             */
            static prepend(array: Uint8Array | string, data: number, len: number): Uint8Array;
            /**
             * Atomically increments the reference count of `array` by one.
             * This function is thread-safe and may be called from any thread.
             * @param array A #GByteArray
             */
            static ref(array: Uint8Array | string): Uint8Array;
            /**
             * Removes the byte at the given index from a #GByteArray.
             * The following bytes are moved down one place.
             * @param array a #GByteArray
             * @param index_ the index of the byte to remove
             */
            static remove_index(array: Uint8Array | string, index_: number): Uint8Array;
            /**
             * Removes the byte at the given index from a #GByteArray. The last
             * element in the array is used to fill in the space, so this function
             * does not preserve the order of the #GByteArray. But it is faster
             * than g_byte_array_remove_index().
             * @param array a #GByteArray
             * @param index_ the index of the byte to remove
             */
            static remove_index_fast(array: Uint8Array | string, index_: number): Uint8Array;
            /**
             * Removes the given number of bytes starting at the given index from a
             * #GByteArray.  The following elements are moved to close the gap.
             * @param array a @GByteArray
             * @param index_ the index of the first byte to remove
             * @param length the number of bytes to remove
             */
            static remove_range(array: Uint8Array | string, index_: number, length: number): Uint8Array;
            /**
             * Sets the size of the #GByteArray, expanding it if necessary.
             * @param array a #GByteArray
             * @param length the new size of the #GByteArray
             */
            static set_size(array: Uint8Array | string, length: number): Uint8Array;
            /**
             * Creates a new #GByteArray with `reserved_size` bytes preallocated.
             * This avoids frequent reallocation, if you are going to add many
             * bytes to the array. Note however that the size of the array is still
             * 0.
             * @param reserved_size number of bytes preallocated
             */
            static sized_new(reserved_size: number): Uint8Array;
            /**
             * Sorts a byte array, using `compare_func` which should be a
             * qsort()-style comparison function (returns less than zero for first
             * arg is less than second arg, zero for equal, greater than zero if
             * first arg is greater than second arg).
             *
             * If two array elements compare equal, their order in the sorted array
             * is undefined. If you want equal elements to keep their order (i.e.
             * you want a stable sort) you can write a comparison function that,
             * if two elements would otherwise compare equal, compares them by
             * their addresses.
             * @param array a #GByteArray
             * @param compare_func comparison function
             */
            static sort(array: Uint8Array | string, compare_func: CompareFunc): void;
            /**
             * Like g_byte_array_sort(), but the comparison function takes an extra
             * user data argument.
             * @param array a #GByteArray
             * @param compare_func comparison function
             */
            static sort_with_data(array: Uint8Array | string, compare_func: CompareDataFunc): void;
            /**
             * Frees the data in the array and resets the size to zero, while
             * the underlying array is preserved for use elsewhere and returned
             * to the caller.
             * @param array a #GByteArray.
             */
            static steal(array: Uint8Array | string): [number, number];
            /**
             * Atomically decrements the reference count of `array` by one. If the
             * reference count drops to 0, all memory allocated by the array is
             * released. This function is thread-safe and may be called from any
             * thread.
             * @param array A #GByteArray
             */
            static unref(array: Uint8Array | string): void;
        }

        /**
         * A simple reference counted data type representing an immutable sequence of
         * zero or more bytes from an unspecified origin.
         *
         * The purpose of a `GBytes` is to keep the memory region that it holds
         * alive for as long as anyone holds a reference to the bytes.  When
         * the last reference count is dropped, the memory is released. Multiple
         * unrelated callers can use byte data in the `GBytes` without coordinating
         * their activities, resting assured that the byte data will not change or
         * move while they hold a reference.
         *
         * A `GBytes` can come from many different origins that may have
         * different procedures for freeing the memory region.  Examples are
         * memory from [func`GLib`.malloc], from memory slices, from a
         * [struct`GLib`.MappedFile] or memory from other allocators.
         *
         * `GBytes` work well as keys in [struct`GLib`.HashTable]. Use
         * [method`GLib`.Bytes.equal] and [method`GLib`.Bytes.hash] as parameters to
         * [func`GLib`.HashTable.new] or [func`GLib`.HashTable.new_full].
         * `GBytes` can also be used as keys in a [struct`GLib`.Tree] by passing the
         * [method`GLib`.Bytes.compare] function to [ctor`GLib`.Tree.new].
         *
         * The data pointed to by this bytes must not be modified. For a mutable
         * array of bytes see [struct`GLib`.ByteArray]. Use
         * [method`GLib`.Bytes.unref_to_array] to create a mutable array for a `GBytes`
         * sequence. To create an immutable `GBytes` from a mutable
         * [struct`GLib`.ByteArray], use the [func`GLib`.ByteArray.free_to_bytes]
         * function.
         */
        class Bytes {
            static $gtype: GObject.GType<Bytes>;

            // Constructors

            constructor(data?: Uint8Array | null);
            _init(...args: any[]): void;

            static ['new'](data?: Uint8Array | null): Bytes;

            static new_take(data?: Uint8Array | null): Bytes;

            // Methods

            /**
             * Compares the two [struct`GLib`.Bytes] values.
             *
             * This function can be used to sort `GBytes` instances in lexicographical
             * order.
             *
             * If `bytes1` and `bytes2` have different length but the shorter one is a
             * prefix of the longer one then the shorter one is considered to be less than
             * the longer one. Otherwise the first byte where both differ is used for
             * comparison. If `bytes1` has a smaller value at that position it is
             * considered less, otherwise greater than `bytes2`.
             * @param bytes2 a pointer to a [struct@GLib.Bytes] to compare with @bytes1
             * @returns a negative value if @bytes1 is less than @bytes2, a positive value   if @bytes1 is greater than @bytes2, and zero if @bytes1 is equal to @bytes2
             */
            compare(bytes2: Bytes | Uint8Array): number;
            /**
             * Compares the two [struct`GLib`.Bytes] values being pointed to and returns
             * `TRUE` if they are equal.
             *
             * This function can be passed to [func`GLib`.HashTable.new] as the
             * `key_equal_func` parameter, when using non-`NULL` `GBytes` pointers as keys in
             * a [struct`GLib`.HashTable].
             * @param bytes2 a pointer to a [struct@GLib.Bytes] to compare with @bytes1
             * @returns `TRUE` if the two keys match.
             */
            equal(bytes2: Bytes | Uint8Array): boolean;
            /**
             * Get the byte data in the [struct`GLib`.Bytes].
             *
             * This data should not be modified.
             *
             * This function will always return the same pointer for a given `GBytes`.
             *
             * `NULL` may be returned if `size` is 0. This is not guaranteed, as the `GBytes`
             * may represent an empty string with `data` non-`NULL` and `size` as 0. `NULL`
             * will not be returned if `size` is non-zero.
             * @returns a pointer to the byte data
             */
            get_data(): Uint8Array | null;
            /**
             * Gets a pointer to a region in `bytes`.
             *
             * The region starts at `offset` many bytes from the start of the data
             * and contains `n_elements` many elements of `element_size` size.
             *
             * `n_elements` may be zero, but `element_size` must always be non-zero.
             * Ideally, `element_size` is a static constant (eg: `sizeof` a struct).
             *
             * This function does careful bounds checking (including checking for
             * arithmetic overflows) and returns a non-`NULL` pointer if the
             * specified region lies entirely within the `bytes`. If the region is
             * in some way out of range, or if an overflow has occurred, then `NULL`
             * is returned.
             *
             * Note: it is possible to have a valid zero-size region. In this case,
             * the returned pointer will be equal to the base pointer of the data of
             * `bytes,` plus `offset`.  This will be non-`NULL` except for the case
             * where `bytes` itself was a zero-sized region.  Since it is unlikely
             * that you will be using this function to check for a zero-sized region
             * in a zero-sized `bytes,` `NULL` effectively always means ‘error’.
             * @param element_size a non-zero element size
             * @param offset an offset to the start of the region within the @bytes
             * @param n_elements the number of elements in the region
             * @returns the requested region, or `NULL` in case of an error
             */
            get_region(element_size: number, offset: number, n_elements: number): any | null;
            /**
             * Get the size of the byte data in the [struct`GLib`.Bytes].
             *
             * This function will always return the same value for a given `GBytes`.
             * @returns the size
             */
            get_size(): number;
            /**
             * Creates an integer hash code for the byte data in the [struct`GLib`.Bytes].
             *
             * This function can be passed to [func`GLib`.HashTable.new] as the
             * `key_hash_func` parameter, when using non-`NULL` `GBytes` pointers as keys in
             * a [struct`GLib`.HashTable].
             * @returns a hash value corresponding to the key.
             */
            hash(): number;
            /**
             * Creates a [struct`GLib`.Bytes] which is a subsection of another `GBytes`.
             *
             * The `offset` + `length` may not be longer than the size of `bytes`.
             *
             * A reference to `bytes` will be held by the newly created `GBytes` until
             * the byte data is no longer needed.
             *
             * Since 2.56, if `offset` is 0 and `length` matches the size of `bytes,` then
             * `bytes` will be returned with the reference count incremented by 1. If `bytes`
             * is a slice of another `GBytes`, then the resulting `GBytes` will reference
             * the same `GBytes` instead of `bytes`. This allows consumers to simplify the
             * usage of `GBytes` when asynchronously writing to streams.
             * @param offset offset which subsection starts at
             * @param length length of subsection
             * @returns a new [struct@GLib.Bytes]
             */
            new_from_bytes(offset: number, length: number): Bytes;
            /**
             * Increase the reference count on `bytes`.
             * @returns the [struct@GLib.Bytes]
             */
            ref(): Bytes;
            /**
             * Releases a reference on `bytes`.
             *
             * This may result in the bytes being freed. If `bytes` is `NULL`, it will
             * return immediately.
             */
            unref(): void;
            /**
             * Unreferences the bytes, and returns a new mutable [struct`GLib`.ByteArray]
             * containing the same byte data.
             *
             * As an optimization, the byte data is transferred to the array without copying
             * if this was the last reference to `bytes` and `bytes` was created with
             * [ctor`GLib`.Bytes.new], [ctor`GLib`.Bytes.new_take] or
             * [func`GLib`.ByteArray.free_to_bytes] and the buffer was larger than the size
             * [struct`GLib`.Bytes] may internalize within its allocation. In all other cases
             * the data is copied.
             *
             * Do not use it if `bytes` contains more than %G_MAXUINT
             * bytes. [struct`GLib`.ByteArray] stores the length of its data in `guint`,
             * which may be shorter than `gsize`, that `bytes` is using.
             * @returns a new mutable [struct@GLib.ByteArray] containing   the same byte data
             */
            unref_to_array(): Uint8Array;
            /**
             * Unreferences the bytes, and returns a pointer the same byte data
             * contents.
             *
             * As an optimization, the byte data is returned without copying if this was
             * the last reference to `bytes` and `bytes` was created with
             * [ctor`GLib`.Bytes.new], [ctor`GLib`.Bytes.new_take] or
             * [func`GLib`.ByteArray.free_to_bytes] and the buffer was larger than the size
             * [struct`GLib`.Bytes] may internalize within its allocation. In all other cases
             * the data is copied.
             * @returns a pointer to the same byte data, which should be freed with [func@GLib.free]
             */
            unref_to_data(): Uint8Array;
            toArray(): Uint8Array;
        }

        /**
         * A `GCache` allows sharing of complex data structures, in order to
         * save system resources.
         *
         * `GCache` uses keys and values. A `GCache` key describes the properties
         * of a particular resource. A `GCache` value is the actual resource.
         *
         * `GCache` has been marked as deprecated, since this API is rarely
         * used and not very actively maintained.
         */
        abstract class Cache {
            static $gtype: GObject.GType<Cache>;

            // Constructors

            _init(...args: any[]): void;

            // Methods

            /**
             * Frees the memory allocated for the #GCache.
             *
             * Note that it does not destroy the keys and values which were
             * contained in the #GCache.
             */
            destroy(): void;
            /**
             * Gets the value corresponding to the given key, creating it if
             * necessary. It first checks if the value already exists in the
             * #GCache, by using the `key_equal_func` function passed to
             * g_cache_new(). If it does already exist it is returned, and its
             * reference count is increased by one. If the value does not currently
             * exist, if is created by calling the `value_new_func`. The key is
             * duplicated by calling `key_dup_func` and the duplicated key and value
             * are inserted into the #GCache.
             * @param key a key describing a #GCache object
             * @returns a pointer to a #GCache value
             */
            insert(key?: any | null): any | null;
            /**
             * Calls the given function for each of the keys in the #GCache.
             *
             * NOTE `func` is passed three parameters, the value and key of a cache
             * entry and the `user_data`. The order of value and key is different
             * from the order in which g_hash_table_foreach() passes key-value
             * pairs to its callback function !
             * @param func the function to call with each #GCache key
             */
            key_foreach(func: HFunc): void;
            /**
             * Decreases the reference count of the given value. If it drops to 0
             * then the value and its corresponding key are destroyed, using the
             * `value_destroy_func` and `key_destroy_func` passed to g_cache_new().
             * @param value the value to remove
             */
            remove(value?: any | null): void;
            /**
             * Calls the given function for each of the values in the #GCache.
             * @param func the function to call with each #GCache value
             */
            value_foreach(func: HFunc): void;
        }

        /**
         * GLib provides a generic API for computing checksums (or ‘digests’)
         * for a sequence of arbitrary bytes, using various hashing algorithms
         * like MD5, SHA-1 and SHA-256. Checksums are commonly used in various
         * environments and specifications.
         *
         * To create a new `GChecksum`, use [ctor`GLib`.Checksum.new]. To free
         * a `GChecksum`, use [method`GLib`.Checksum.free].
         *
         * GLib supports incremental checksums using the `GChecksum` data
         * structure, by calling [method`GLib`.Checksum.update] as long as there’s data
         * available and then using [method`GLib`.Checksum.get_string] or
         * [method`GLib`.Checksum.get_digest] to compute the checksum and return it
         * either as a string in hexadecimal form, or as a raw sequence of bytes. To
         * compute the checksum for binary blobs and nul-terminated strings in
         * one go, use the convenience functions [func`GLib`.compute_checksum_for_data]
         * and [func`GLib`.compute_checksum_for_string], respectively.
         */
        class Checksum {
            static $gtype: GObject.GType<Checksum>;

            // Constructors

            constructor(checksum_type: ChecksumType);
            _init(...args: any[]): void;

            static ['new'](checksum_type: ChecksumType): Checksum;

            // Static methods

            /**
             * Gets the length in bytes of digests of type `checksum_type`
             * @param checksum_type a #GChecksumType
             */
            static type_get_length(checksum_type: ChecksumType): number;

            // Methods

            /**
             * Copies a #GChecksum. If `checksum` has been closed, by calling
             * g_checksum_get_string() or g_checksum_get_digest(), the copied
             * checksum will be closed as well.
             * @returns the copy of the passed #GChecksum. Use   g_checksum_free() when finished using it.
             */
            copy(): Checksum;
            /**
             * Frees the memory allocated for `checksum`.
             */
            free(): void;
            /**
             * Gets the digest as a hexadecimal string.
             *
             * Once this function has been called the #GChecksum can no longer be
             * updated with g_checksum_update().
             *
             * The hexadecimal characters will be lower case.
             * @returns the hexadecimal representation of the checksum. The   returned string is owned by the checksum and should not be modified   or freed.
             */
            get_string(): string;
            /**
             * Resets the state of the `checksum` back to its initial state.
             */
            reset(): void;
            /**
             * Feeds `data` into an existing #GChecksum. The checksum must still be
             * open, that is g_checksum_get_string() or g_checksum_get_digest() must
             * not have been called on `checksum`.
             * @param data buffer used to compute the checksum
             */
            update(data: Uint8Array | string): void;
        }

        /**
         * `GCompletion` provides support for automatic completion of a string
         * using any group of target strings. It is typically used for file
         * name completion as is common in many UNIX shells.
         *
         * A `GCompletion` is created using [func`GLib`.Completion.new]. Target items are
         * added and removed with [method`GLib`.Completion.add_items],
         * [method`GLib`.Completion.remove_items] and
         * [method`GLib`.Completion.clear_items]. A completion attempt is requested with
         * [method`GLib`.Completion.complete] or [method`GLib`.Completion.complete_utf8].
         * When no longer needed, the `GCompletion` is freed with
         * [method`GLib`.Completion.free].
         *
         * Items in the completion can be simple strings (e.g. filenames), or
         * pointers to arbitrary data structures. If data structures are used
         * you must provide a [type`GLib`.CompletionFunc] in [func`GLib`.Completion.new],
         * which retrieves the item’s string from the data structure. You can change
         * the way in which strings are compared by setting a different
         * [type`GLib`.CompletionStrncmpFunc] in [method`GLib`.Completion.set_compare].
         *
         * `GCompletion` has been marked as deprecated, since this API is rarely
         * used and not very actively maintained.
         */
        class Completion {
            static $gtype: GObject.GType<Completion>;

            // Fields

            items: any[];
            func: CompletionFunc;
            prefix: string;
            cache: any[];
            strncmp_func: CompletionStrncmpFunc;

            // Constructors

            _init(...args: any[]): void;

            // Methods

            /**
             * Removes all items from the #GCompletion. The items are not freed, so if the
             * memory was dynamically allocated, it should be freed after calling this
             * function.
             */
            clear_items(): void;
            /**
             * Attempts to complete the string `prefix` using the #GCompletion target items.
             * In contrast to g_completion_complete(), this function returns the largest common
             * prefix that is a valid UTF-8 string, omitting a possible common partial
             * character.
             *
             * You should use this function instead of g_completion_complete() if your
             * items are UTF-8 strings.
             * @param prefix the prefix string, typically used by the user, which is compared    with each of the items
             * @param new_prefix if non-%NULL, returns the longest prefix which is common to all    items that matched @prefix, or %NULL if no items matched @prefix.    This string should be freed when no longer needed.
             * @returns the list of items whose strings begin with @prefix. This should not be changed.
             */
            complete_utf8(prefix: string, new_prefix: string): string[];
            /**
             * Frees all memory used by the #GCompletion. The items are not freed, so if
             * the memory was dynamically allocated, it should be freed after calling this
             * function.
             */
            free(): void;
        }

        /**
         * The #GCond struct is an opaque data structure that represents a
         * condition. Threads can block on a #GCond if they find a certain
         * condition to be false. If other threads change the state of this
         * condition they signal the #GCond, and that causes the waiting
         * threads to be woken up.
         *
         * Consider the following example of a shared variable.  One or more
         * threads can wait for data to be published to the variable and when
         * another thread publishes the data, it can signal one of the waiting
         * threads to wake up to collect the data.
         *
         * Here is an example for using GCond to block a thread until a condition
         * is satisfied:
         *
         * ```c
         *   gpointer current_data = NULL;
         *   GMutex data_mutex;
         *   GCond data_cond;
         *
         *   void
         *   push_data (gpointer data)
         *   {
         *     g_mutex_lock (&data_mutex);
         *     current_data = data;
         *     g_cond_signal (&data_cond);
         *     g_mutex_unlock (&data_mutex);
         *   }
         *
         *   gpointer
         *   pop_data (void)
         *   {
         *     gpointer data;
         *
         *     g_mutex_lock (&data_mutex);
         *     while (!current_data)
         *       g_cond_wait (&data_cond, &data_mutex);
         *     data = current_data;
         *     current_data = NULL;
         *     g_mutex_unlock (&data_mutex);
         *
         *     return data;
         *   }
         * ```
         *
         * Whenever a thread calls pop_data() now, it will wait until
         * current_data is non-%NULL, i.e. until some other thread
         * has called push_data().
         *
         * The example shows that use of a condition variable must always be
         * paired with a mutex.  Without the use of a mutex, there would be a
         * race between the check of `current_data` by the while loop in
         * pop_data() and waiting. Specifically, another thread could set
         * `current_data` after the check, and signal the cond (with nobody
         * waiting on it) before the first thread goes to sleep. #GCond is
         * specifically useful for its ability to release the mutex and go
         * to sleep atomically.
         *
         * It is also important to use the g_cond_wait() and g_cond_wait_until()
         * functions only inside a loop which checks for the condition to be
         * true.  See g_cond_wait() for an explanation of why the condition may
         * not be true even after it returns.
         *
         * If a #GCond is allocated in static storage then it can be used
         * without initialisation.  Otherwise, you should call g_cond_init()
         * on it and g_cond_clear() when done.
         *
         * A #GCond should only be accessed via the g_cond_ functions.
         */
        class Cond {
            static $gtype: GObject.GType<Cond>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            // Methods

            /**
             * If threads are waiting for `cond,` all of them are unblocked.
             * If no threads are waiting for `cond,` this function has no effect.
             * It is good practice to lock the same mutex as the waiting threads
             * while calling this function, though not required.
             */
            broadcast(): void;
            /**
             * Frees the resources allocated to a #GCond with g_cond_init().
             *
             * This function should not be used with a #GCond that has been
             * statically allocated.
             *
             * Calling g_cond_clear() for a #GCond on which threads are
             * blocking leads to undefined behaviour.
             */
            clear(): void;
            /**
             * Initialises a #GCond so that it can be used.
             *
             * This function is useful to initialise a #GCond that has been
             * allocated as part of a larger structure.  It is not necessary to
             * initialise a #GCond that has been statically allocated.
             *
             * To undo the effect of g_cond_init() when a #GCond is no longer
             * needed, use g_cond_clear().
             *
             * Calling g_cond_init() on an already-initialised #GCond leads
             * to undefined behaviour.
             */
            init(): void;
            /**
             * If threads are waiting for `cond,` at least one of them is unblocked.
             * If no threads are waiting for `cond,` this function has no effect.
             * It is good practice to hold the same lock as the waiting thread
             * while calling this function, though not required.
             */
            signal(): void;
            /**
             * Atomically releases `mutex` and waits until `cond` is signalled.
             * When this function returns, `mutex` is locked again and owned by the
             * calling thread.
             *
             * When using condition variables, it is possible that a spurious wakeup
             * may occur (ie: g_cond_wait() returns even though g_cond_signal() was
             * not called).  It's also possible that a stolen wakeup may occur.
             * This is when g_cond_signal() is called, but another thread acquires
             * `mutex` before this thread and modifies the state of the program in
             * such a way that when g_cond_wait() is able to return, the expected
             * condition is no longer met.
             *
             * For this reason, g_cond_wait() must always be used in a loop.  See
             * the documentation for #GCond for a complete example.
             * @param mutex a #GMutex that is currently locked
             */
            wait(mutex: Mutex): void;
            /**
             * Waits until either `cond` is signalled or `end_time` has passed.
             *
             * As with g_cond_wait() it is possible that a spurious or stolen wakeup
             * could occur.  For that reason, waiting on a condition variable should
             * always be in a loop, based on an explicitly-checked predicate.
             *
             * %TRUE is returned if the condition variable was signalled (or in the
             * case of a spurious wakeup).  %FALSE is returned if `end_time` has
             * passed.
             *
             * The following code shows how to correctly perform a timed wait on a
             * condition variable (extending the example presented in the
             * documentation for #GCond):
             *
             *
             * ```c
             * gpointer
             * pop_data_timed (void)
             * {
             *   gint64 end_time;
             *   gpointer data;
             *
             *   g_mutex_lock (&data_mutex);
             *
             *   end_time = g_get_monotonic_time () + 5 * G_TIME_SPAN_SECOND;
             *   while (!current_data)
             *     if (!g_cond_wait_until (&data_cond, &data_mutex, end_time))
             *       {
             *         // timeout has passed.
             *         g_mutex_unlock (&data_mutex);
             *         return NULL;
             *       }
             *
             *   // there is data for us
             *   data = current_data;
             *   current_data = NULL;
             *
             *   g_mutex_unlock (&data_mutex);
             *
             *   return data;
             * }
             * ```
             *
             *
             * Notice that the end time is calculated once, before entering the
             * loop and reused.  This is the motivation behind the use of absolute
             * time on this API -- if a relative time of 5 seconds were passed
             * directly to the call and a spurious wakeup occurred, the program would
             * have to start over waiting again (which would lead to a total wait
             * time of more than 5 seconds).
             * @param mutex a #GMutex that is currently locked
             * @param end_time the monotonic time to wait until
             * @returns %TRUE on a signal, %FALSE on a timeout
             */
            wait_until(mutex: Mutex, end_time: number): boolean;
        }

        /**
         * An opaque data structure that represents a keyed data list.
         *
         * See also: [Keyed data lists](datalist-and-dataset.html).
         */
        abstract class Data {
            static $gtype: GObject.GType<Data>;

            // Constructors

            _init(...args: any[]): void;
        }

        /**
         * `GDate` is a struct for calendrical calculations.
         *
         * The `GDate` data structure represents a day between January 1, Year 1,
         * and sometime a few thousand years in the future (right now it will go
         * to the year 65535 or so, but [method`GLib`.Date.set_parse] only parses up to the
         * year 8000 or so - just count on "a few thousand"). `GDate` is meant to
         * represent everyday dates, not astronomical dates or historical dates
         * or ISO timestamps or the like. It extrapolates the current Gregorian
         * calendar forward and backward in time; there is no attempt to change
         * the calendar to match time periods or locations. `GDate` does not store
         * time information; it represents a day.
         *
         * The `GDate` implementation has several nice features; it is only a
         * 64-bit struct, so storing large numbers of dates is very efficient. It
         * can keep both a Julian and day-month-year representation of the date,
         * since some calculations are much easier with one representation or the
         * other. A Julian representation is simply a count of days since some
         * fixed day in the past; for #GDate the fixed day is January 1, 1 AD.
         * ("Julian" dates in the #GDate API aren't really Julian dates in the
         * technical sense; technically, Julian dates count from the start of the
         * Julian period, Jan 1, 4713 BC).
         *
         * `GDate` is simple to use. First you need a "blank" date; you can get a
         * dynamically allocated date from [ctor`GLib`.Date.new], or you can declare an
         * automatic variable or array and initialize it by calling [method`GLib`.Date.clear].
         * A cleared date is safe; it's safe to call [method`GLib`.Date.set_dmy] and the other
         * mutator functions to initialize the value of a cleared date. However, a cleared date
         * is initially invalid, meaning that it doesn't represent a day that exists.
         * It is undefined to call any of the date calculation routines on an invalid date.
         * If you obtain a date from a user or other unpredictable source, you should check
         * its validity with the [method`GLib`.Date.valid] predicate. [method`GLib`.Date.valid]
         * is also used to check for errors with [method`GLib`.Date.set_parse] and other functions
         * that can fail. Dates can be invalidated by calling [method`GLib`.Date.clear] again.
         *
         * It is very important to use the API to access the `GDate` struct. Often only the
         * day-month-year or only the Julian representation is valid. Sometimes neither is valid.
         * Use the API.
         *
         * GLib also features `GDateTime` which represents a precise time.
         */
        class Date {
            static $gtype: GObject.GType<Date>;

            // Fields

            julian_days: number;
            julian: number;
            dmy: number;
            day: number;
            month: number;
            year: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    julian_days: number;
                    julian: number;
                    dmy: number;
                    day: number;
                    month: number;
                    year: number;
                }>,
            );
            _init(...args: any[]): void;

            static ['new'](): Date;

            static new_dmy(day: DateDay, month: DateMonth, year: DateYear): Date;

            static new_julian(julian_day: number): Date;

            // Static methods

            /**
             * Returns the number of days in a month, taking leap
             * years into account.
             * @param month month
             * @param year year
             */
            static get_days_in_month(month: DateMonth, year: DateYear): number;
            /**
             * Returns the number of weeks in the year, where weeks
             * are taken to start on Monday. Will be 52 or 53. The
             * date must be valid. (Years always have 52 7-day periods,
             * plus 1 or 2 extra days depending on whether it's a leap
             * year. This function is basically telling you how many
             * Mondays are in the year, i.e. there are 53 Mondays if
             * one of the extra days happens to be a Monday.)
             * @param year a year
             */
            static get_monday_weeks_in_year(year: DateYear): number;
            /**
             * Returns the number of weeks in the year, where weeks
             * are taken to start on Sunday. Will be 52 or 53. The
             * date must be valid. (Years always have 52 7-day periods,
             * plus 1 or 2 extra days depending on whether it's a leap
             * year. This function is basically telling you how many
             * Sundays are in the year, i.e. there are 53 Sundays if
             * one of the extra days happens to be a Sunday.)
             * @param year year to count weeks in
             */
            static get_sunday_weeks_in_year(year: DateYear): number;
            /**
             * Returns %TRUE if the year is a leap year.
             *
             * For the purposes of this function, leap year is every year
             * divisible by 4 unless that year is divisible by 100. If it
             * is divisible by 100 it would be a leap year only if that year
             * is also divisible by 400.
             * @param year year to check
             */
            static is_leap_year(year: DateYear): boolean;
            /**
             * Generates a printed representation of the date, in a
             * [locale](running.html#locale)-specific way.
             * Works just like the platform's C library strftime() function,
             * but only accepts date-related formats; time-related formats
             * give undefined results. Date must be valid. Unlike strftime()
             * (which uses the locale encoding), works on a UTF-8 format
             * string and stores a UTF-8 result.
             *
             * This function does not provide any conversion specifiers in
             * addition to those implemented by the platform's C library.
             * For example, don't expect that using g_date_strftime() would
             * make the \%F provided by the C99 strftime() work on Windows
             * where the C library only complies to C89.
             * @param s destination buffer
             * @param slen buffer size
             * @param format format string
             * @param date valid #GDate
             */
            static strftime(s: string, slen: number, format: string, date: Date): number;
            /**
             * Returns %TRUE if the day of the month is valid (a day is valid if it's
             * between 1 and 31 inclusive).
             * @param day day to check
             */
            static valid_day(day: DateDay): boolean;
            /**
             * Returns %TRUE if the day-month-year triplet forms a valid, existing day
             * in the range of days #GDate understands (Year 1 or later, no more than
             * a few thousand years in the future).
             * @param day day
             * @param month month
             * @param year year
             */
            static valid_dmy(day: DateDay, month: DateMonth, year: DateYear): boolean;
            /**
             * Returns %TRUE if the Julian day is valid. Anything greater than zero
             * is basically a valid Julian, though there is a 32-bit limit.
             * @param julian_date Julian day to check
             */
            static valid_julian(julian_date: number): boolean;
            /**
             * Returns %TRUE if the month value is valid. The 12 #GDateMonth
             * enumeration values are the only valid months.
             * @param month month
             */
            static valid_month(month: DateMonth): boolean;
            /**
             * Returns %TRUE if the weekday is valid. The seven #GDateWeekday enumeration
             * values are the only valid weekdays.
             * @param weekday weekday
             */
            static valid_weekday(weekday: DateWeekday): boolean;
            /**
             * Returns %TRUE if the year is valid. Any year greater than 0 is valid,
             * though there is a 16-bit limit to what #GDate will understand.
             * @param year year
             */
            static valid_year(year: DateYear): boolean;

            // Methods

            /**
             * Increments a date some number of days.
             * To move forward by weeks, add weeks*7 days.
             * The date must be valid.
             * @param n_days number of days to move the date forward
             */
            add_days(n_days: number): void;
            /**
             * Increments a date by some number of months.
             * If the day of the month is greater than 28,
             * this routine may change the day of the month
             * (because the destination month may not have
             * the current day in it). The date must be valid.
             * @param n_months number of months to move forward
             */
            add_months(n_months: number): void;
            /**
             * Increments a date by some number of years.
             * If the date is February 29, and the destination
             * year is not a leap year, the date will be changed
             * to February 28. The date must be valid.
             * @param n_years number of years to move forward
             */
            add_years(n_years: number): void;
            /**
             * If `date` is prior to `min_date,` sets `date` equal to `min_date`.
             * If `date` falls after `max_date,` sets `date` equal to `max_date`.
             * Otherwise, `date` is unchanged.
             * Either of `min_date` and `max_date` may be %NULL.
             * All non-%NULL dates must be valid.
             * @param min_date minimum accepted value for @date
             * @param max_date maximum accepted value for @date
             */
            clamp(min_date: Date, max_date: Date): void;
            /**
             * Initializes one or more #GDate structs to a safe but invalid
             * state. The cleared dates will not represent an existing date, but will
             * not contain garbage. Useful to init a date declared on the stack.
             * Validity can be tested with g_date_valid().
             * @param n_dates number of dates to clear
             */
            clear(n_dates: number): void;
            /**
             * qsort()-style comparison function for dates.
             * Both dates must be valid.
             * @param rhs second date to compare
             * @returns 0 for equal, less than zero if @lhs is less than @rhs,     greater than zero if @lhs is greater than @rhs
             */
            compare(rhs: Date): number;
            /**
             * Copies a GDate to a newly-allocated GDate. If the input was invalid
             * (as determined by g_date_valid()), the invalid state will be copied
             * as is into the new object.
             * @returns a newly-allocated #GDate initialized from @date
             */
            copy(): Date;
            /**
             * Computes the number of days between two dates.
             * If `date2` is prior to `date1`, the returned value is negative.
             * Both dates must be valid.
             * @param date2 the second date
             * @returns the number of days between @date1 and @date2
             */
            days_between(date2: Date): number;
            /**
             * Frees a #GDate returned from g_date_new().
             */
            free(): void;
            /**
             * Returns the day of the month. The date must be valid.
             * @returns day of the month
             */
            get_day(): DateDay;
            /**
             * Returns the day of the year, where Jan 1 is the first day of the
             * year. The date must be valid.
             * @returns day of the year
             */
            get_day_of_year(): number;
            /**
             * Returns the week of the year, where weeks are interpreted according
             * to ISO 8601.
             * @returns ISO 8601 week number of the year.
             */
            get_iso8601_week_of_year(): number;
            /**
             * Returns the Julian day or "serial number" of the #GDate. The
             * Julian day is simply the number of days since January 1, Year 1; i.e.,
             * January 1, Year 1 is Julian day 1; January 2, Year 1 is Julian day 2,
             * etc. The date must be valid.
             * @returns Julian day
             */
            get_julian(): number;
            /**
             * Returns the week of the year, where weeks are understood to start on
             * Monday. If the date is before the first Monday of the year, return 0.
             * The date must be valid.
             * @returns week of the year
             */
            get_monday_week_of_year(): number;
            /**
             * Returns the month of the year. The date must be valid.
             * @returns month of the year as a #GDateMonth
             */
            get_month(): DateMonth;
            /**
             * Returns the week of the year during which this date falls, if
             * weeks are understood to begin on Sunday. The date must be valid.
             * Can return 0 if the day is before the first Sunday of the year.
             * @returns week number
             */
            get_sunday_week_of_year(): number;
            /**
             * Returns the day of the week for a #GDate. The date must be valid.
             * @returns day of the week as a #GDateWeekday.
             */
            get_weekday(): DateWeekday;
            /**
             * Returns the year of a #GDate. The date must be valid.
             * @returns year in which the date falls
             */
            get_year(): DateYear;
            /**
             * Returns %TRUE if the date is on the first of a month.
             * The date must be valid.
             * @returns %TRUE if the date is the first of the month
             */
            is_first_of_month(): boolean;
            /**
             * Returns %TRUE if the date is the last day of the month.
             * The date must be valid.
             * @returns %TRUE if the date is the last day of the month
             */
            is_last_of_month(): boolean;
            /**
             * Checks if `date1` is less than or equal to `date2`,
             * and swap the values if this is not the case.
             * @param date2 the second date
             */
            order(date2: Date): void;
            /**
             * Sets the day of the month for a #GDate. If the resulting
             * day-month-year triplet is invalid, the date will be invalid.
             * @param day day to set
             */
            set_day(day: DateDay): void;
            /**
             * Sets the value of a #GDate from a day, month, and year.
             * The day-month-year triplet must be valid; if you aren't
             * sure it is, call g_date_valid_dmy() to check before you
             * set it.
             * @param day day
             * @param month month
             * @param y year
             */
            set_dmy(day: DateDay, month: DateMonth | null, y: DateYear): void;
            /**
             * Sets the value of a #GDate from a Julian day number.
             * @param julian_date Julian day number (days since January 1, Year 1)
             */
            set_julian(julian_date: number): void;
            /**
             * Sets the month of the year for a #GDate.  If the resulting
             * day-month-year triplet is invalid, the date will be invalid.
             * @param month month to set
             */
            set_month(month: DateMonth | null): void;
            /**
             * Parses a user-inputted string `str,` and try to figure out what date it
             * represents, taking the [current locale](running.html#locale)
             * into account. If the string is successfully parsed, the date will be
             * valid after the call. Otherwise, it will be invalid. You should check
             * using g_date_valid() to see whether the parsing succeeded.
             *
             * This function is not appropriate for file formats and the like; it
             * isn't very precise, and its exact behavior varies with the locale.
             * It's intended to be a heuristic routine that guesses what the user
             * means by a given string (and it does work pretty well in that
             * capacity).
             * @param str string to parse
             */
            set_parse(str: string): void;
            /**
             * Sets the value of a date from a #GTime value.
             * The time to date conversion is done using the user's current timezone.
             * @param time_ #GTime value to set.
             */
            set_time(time_: Time): void;
            /**
             * Sets the value of a date to the date corresponding to a time
             * specified as a time_t. The time to date conversion is done using
             * the user's current timezone.
             *
             * To set the value of a date to the current day, you could write:
             *
             * ```c
             *  time_t now = time (NULL);
             *  if (now == (time_t) -1)
             *    // handle the error
             *  g_date_set_time_t (date, now);
             * ```
             *
             * @param timet time_t value to set
             */
            set_time_t(timet: never): void;
            /**
             * Sets the value of a date from a #GTimeVal value.  Note that the
             * `tv_usec` member is ignored, because #GDate can't make use of the
             * additional precision.
             *
             * The time to date conversion is done using the user's current timezone.
             * @param timeval #GTimeVal value to set
             */
            set_time_val(timeval: TimeVal): void;
            /**
             * Sets the year for a #GDate. If the resulting day-month-year
             * triplet is invalid, the date will be invalid.
             * @param year year to set
             */
            set_year(year: DateYear): void;
            /**
             * Moves a date some number of days into the past.
             * To move by weeks, just move by weeks*7 days.
             * The date must be valid.
             * @param n_days number of days to move
             */
            subtract_days(n_days: number): void;
            /**
             * Moves a date some number of months into the past.
             * If the current day of the month doesn't exist in
             * the destination month, the day of the month
             * may change. The date must be valid.
             * @param n_months number of months to move
             */
            subtract_months(n_months: number): void;
            /**
             * Moves a date some number of years into the past.
             * If the current day doesn't exist in the destination
             * year (i.e. it's February 29 and you move to a non-leap-year)
             * then the day is changed to February 29. The date
             * must be valid.
             * @param n_years number of years to move
             */
            subtract_years(n_years: number): void;
            /**
             * Fills in the date-related bits of a struct tm using the `date` value.
             * Initializes the non-date parts with something safe but meaningless.
             * @param tm struct tm to fill
             */
            to_struct_tm(tm: any): void;
            /**
             * Returns %TRUE if the #GDate represents an existing day. The date must not
             * contain garbage; it should have been initialized with g_date_clear()
             * if it wasn't allocated by one of the g_date_new() variants.
             * @returns Whether the date is valid
             */
            valid(): boolean;
        }

        /**
         * `GDateTime` is a structure that combines a Gregorian date and time
         * into a single structure.
         *
         * `GDateTime` provides many conversion and methods to manipulate dates and times.
         * Time precision is provided down to microseconds and the time can range
         * (proleptically) from 0001-01-01 00:00:00 to 9999-12-31 23:59:59.999999.
         * `GDateTime` follows POSIX time in the sense that it is oblivious to leap
         * seconds.
         *
         * `GDateTime` is an immutable object; once it has been created it cannot
         * be modified further. All modifiers will create a new `GDateTime`.
         * Nearly all such functions can fail due to the date or time going out
         * of range, in which case %NULL will be returned.
         *
         * `GDateTime` is reference counted: the reference count is increased by calling
         * [method`GLib`.DateTime.ref] and decreased by calling [method`GLib`.DateTime.unref].
         * When the reference count drops to 0, the resources allocated by the `GDateTime`
         * structure are released.
         *
         * Many parts of the API may produce non-obvious results. As an
         * example, adding two months to January 31st will yield March 31st
         * whereas adding one month and then one month again will yield either
         * March 28th or March 29th.  Also note that adding 24 hours is not
         * always the same as adding one day (since days containing daylight
         * savings time transitions are either 23 or 25 hours in length).
         */
        class DateTime {
            static $gtype: GObject.GType<DateTime>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            static ['new'](
                tz: TimeZone,
                year: number,
                month: number,
                day: number,
                hour: number,
                minute: number,
                seconds: number,
            ): DateTime;

            static new_from_iso8601(text: string, default_tz?: TimeZone | null): DateTime;

            static new_from_timeval_local(tv: TimeVal): DateTime;

            static new_from_timeval_utc(tv: TimeVal): DateTime;

            static new_from_unix_local(t: number): DateTime;

            static new_from_unix_local_usec(usecs: number): DateTime;

            static new_from_unix_utc(t: number): DateTime;

            static new_from_unix_utc_usec(usecs: number): DateTime;

            static new_local(
                year: number,
                month: number,
                day: number,
                hour: number,
                minute: number,
                seconds: number,
            ): DateTime;

            static new_now(tz: TimeZone): DateTime;

            static new_now_local(): DateTime;

            static new_now_utc(): DateTime;

            static new_utc(
                year: number,
                month: number,
                day: number,
                hour: number,
                minute: number,
                seconds: number,
            ): DateTime;

            // Methods

            /**
             * Creates a copy of `datetime` and adds the specified timespan to the copy.
             * @param timespan a #GTimeSpan
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add(timespan: TimeSpan): DateTime | null;
            /**
             * Creates a copy of `datetime` and adds the specified number of days to the
             * copy. Add negative values to subtract days.
             * @param days the number of days
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_days(days: number): DateTime | null;
            /**
             * Creates a new #GDateTime adding the specified values to the current date and
             * time in `datetime`. Add negative values to subtract.
             * @param years the number of years to add
             * @param months the number of months to add
             * @param days the number of days to add
             * @param hours the number of hours to add
             * @param minutes the number of minutes to add
             * @param seconds the number of seconds to add
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_full(
                years: number,
                months: number,
                days: number,
                hours: number,
                minutes: number,
                seconds: number,
            ): DateTime | null;
            /**
             * Creates a copy of `datetime` and adds the specified number of hours.
             * Add negative values to subtract hours.
             * @param hours the number of hours to add
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_hours(hours: number): DateTime | null;
            /**
             * Creates a copy of `datetime` adding the specified number of minutes.
             * Add negative values to subtract minutes.
             * @param minutes the number of minutes to add
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_minutes(minutes: number): DateTime | null;
            /**
             * Creates a copy of `datetime` and adds the specified number of months to the
             * copy. Add negative values to subtract months.
             *
             * The day of the month of the resulting #GDateTime is clamped to the number
             * of days in the updated calendar month. For example, if adding 1 month to
             * 31st January 2018, the result would be 28th February 2018. In 2020 (a leap
             * year), the result would be 29th February.
             * @param months the number of months
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_months(months: number): DateTime | null;
            /**
             * Creates a copy of `datetime` and adds the specified number of seconds.
             * Add negative values to subtract seconds.
             * @param seconds the number of seconds to add
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_seconds(seconds: number): DateTime | null;
            /**
             * Creates a copy of `datetime` and adds the specified number of weeks to the
             * copy. Add negative values to subtract weeks.
             * @param weeks the number of weeks
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_weeks(weeks: number): DateTime | null;
            /**
             * Creates a copy of `datetime` and adds the specified number of years to the
             * copy. Add negative values to subtract years.
             *
             * As with g_date_time_add_months(), if the resulting date would be 29th
             * February on a non-leap year, the day will be clamped to 28th February.
             * @param years the number of years
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            add_years(years: number): DateTime | null;
            /**
             * A comparison function for #GDateTimes that is suitable
             * as a #GCompareFunc. Both #GDateTimes must be non-%NULL.
             * @param dt2 second #GDateTime to compare
             * @returns -1, 0 or 1 if @dt1 is less than, equal to or greater   than @dt2.
             */
            compare(dt2: DateTime): number;
            /**
             * Calculates the difference in time between `end` and `begin`.  The
             * #GTimeSpan that is returned is effectively `end` - `begin` (ie:
             * positive if the first parameter is larger).
             * @param begin a #GDateTime
             * @returns the difference between the two #GDateTime, as a time   span expressed in microseconds.
             */
            difference(begin: DateTime): TimeSpan;
            /**
             * Checks to see if `dt1` and `dt2` are equal.
             *
             * Equal here means that they represent the same moment after converting
             * them to the same time zone.
             * @param dt2 a #GDateTime
             * @returns %TRUE if @dt1 and @dt2 are equal
             */
            equal(dt2: DateTime): boolean;
            /**
             * Creates a newly allocated string representing the requested `format`.
             *
             * The format strings understood by this function are a subset of the
             * `strftime()` format language as specified by C99.  The `%D`, `%U` and `%W`
             * conversions are not supported, nor is the `E` modifier.  The GNU
             * extensions `%k`, `%l`, `%s` and `%P` are supported, however, as are the
             * `0`, `_` and `-` modifiers. The Python extension `%f` is also supported.
             *
             * In contrast to `strftime()`, this function always produces a UTF-8
             * string, regardless of the current locale.  Note that the rendering of
             * many formats is locale-dependent and may not match the `strftime()`
             * output exactly.
             *
             * The following format specifiers are supported:
             *
             * - `%a`: the abbreviated weekday name according to the current locale
             * - `%A`: the full weekday name according to the current locale
             * - `%b`: the abbreviated month name according to the current locale
             * - `%B`: the full month name according to the current locale
             * - `%c`: the preferred date and time representation for the current locale
             * - `%C`: the century number (year/100) as a 2-digit integer (00-99)
             * - `%d`: the day of the month as a decimal number (range 01 to 31)
             * - `%e`: the day of the month as a decimal number (range 1 to 31);
             *   single digits are preceded by a figure space (U+2007)
             * - `%F`: equivalent to `%Y-%m-%d` (the ISO 8601 date format)
             * - `%g`: the last two digits of the ISO 8601 week-based year as a
             *   decimal number (00-99). This works well with `%V` and `%u`.
             * - `%G`: the ISO 8601 week-based year as a decimal number. This works
             *   well with `%V` and `%u`.
             * - `%h`: equivalent to `%b`
             * - `%H`: the hour as a decimal number using a 24-hour clock (range 00 to 23)
             * - `%I`: the hour as a decimal number using a 12-hour clock (range 01 to 12)
             * - `%j`: the day of the year as a decimal number (range 001 to 366)
             * - `%k`: the hour (24-hour clock) as a decimal number (range 0 to 23);
             *   single digits are preceded by a figure space (U+2007)
             * - `%l`: the hour (12-hour clock) as a decimal number (range 1 to 12);
             *   single digits are preceded by a figure space (U+2007)
             * - `%m`: the month as a decimal number (range 01 to 12)
             * - `%M`: the minute as a decimal number (range 00 to 59)
             * - `%f`: the microsecond as a decimal number (range 000000 to 999999)
             * - `%p`: either ‘AM’ or ‘PM’ according to the given time value, or the
             *   corresponding  strings for the current locale.  Noon is treated as
             *   ‘PM’ and midnight as ‘AM’. Use of this format specifier is discouraged, as
             *   many locales have no concept of AM/PM formatting. Use `%c` or `%X` instead.
             * - `%P`: like `%p` but lowercase: ‘am’ or ‘pm’ or a corresponding string for
             *   the current locale. Use of this format specifier is discouraged, as
             *   many locales have no concept of AM/PM formatting. Use `%c` or `%X` instead.
             * - `%r`: the time in a.m. or p.m. notation. Use of this format specifier is
             *   discouraged, as many locales have no concept of AM/PM formatting. Use `%c`
             *   or `%X` instead.
             * - `%R`: the time in 24-hour notation (`%H:%M`)
             * - `%s`: the number of seconds since the Epoch, that is, since 1970-01-01
             *   00:00:00 UTC
             * - `%S`: the second as a decimal number (range 00 to 60)
             * - `%t`: a tab character
             * - `%T`: the time in 24-hour notation with seconds (`%H:%M:%S`)
             * - `%u`: the ISO 8601 standard day of the week as a decimal, range 1 to 7,
             *    Monday being 1. This works well with `%G` and `%V`.
             * - `%V`: the ISO 8601 standard week number of the current year as a decimal
             *   number, range 01 to 53, where week 1 is the first week that has at
             *   least 4 days in the new year. See g_date_time_get_week_of_year().
             *   This works well with `%G` and `%u`.
             * - `%w`: the day of the week as a decimal, range 0 to 6, Sunday being 0.
             *   This is not the ISO 8601 standard format — use `%u` instead.
             * - `%x`: the preferred date representation for the current locale without
             *   the time
             * - `%X`: the preferred time representation for the current locale without
             *   the date
             * - `%y`: the year as a decimal number without the century
             * - `%Y`: the year as a decimal number including the century
             * - `%z`: the time zone as an offset from UTC (`+hhmm`)
             * - `%:z`: the time zone as an offset from UTC (`+hh:mm`).
             *   This is a gnulib `strftime()` extension. Since: 2.38
             * - `%::z`: the time zone as an offset from UTC (`+hh:mm:ss`). This is a
             *   gnulib `strftime()` extension. Since: 2.38
             * - `%:::z`: the time zone as an offset from UTC, with `:` to necessary
             *   precision (e.g., `-04`, `+05:30`). This is a gnulib `strftime()` extension. Since: 2.38
             * - `%Z`: the time zone or name or abbreviation
             * - `%%`: a literal `%` character
             *
             * Some conversion specifications can be modified by preceding the
             * conversion specifier by one or more modifier characters.
             *
             * The following modifiers are supported for many of the numeric
             * conversions:
             *
             * - `O`: Use alternative numeric symbols, if the current locale supports those.
             * - `_`: Pad a numeric result with spaces. This overrides the default padding
             *   for the specifier.
             * - `-`: Do not pad a numeric result. This overrides the default padding
             *   for the specifier.
             * - `0`: Pad a numeric result with zeros. This overrides the default padding
             *   for the specifier.
             *
             * The following modifiers are supported for many of the alphabetic conversions:
             *
             * - `^`: Use upper case if possible. This is a gnulib `strftime()` extension.
             *   Since: 2.80
             * - `#`: Use opposite case if possible. This is a gnulib `strftime()`
             *   extension. Since: 2.80
             *
             * Additionally, when `O` is used with `B`, `b`, or `h`, it produces the alternative
             * form of a month name. The alternative form should be used when the month
             * name is used without a day number (e.g., standalone). It is required in
             * some languages (Baltic, Slavic, Greek, and more) due to their grammatical
             * rules. For other languages there is no difference. `%OB` is a GNU and BSD
             * `strftime()` extension expected to be added to the future POSIX specification,
             * `%Ob` and `%Oh` are GNU `strftime()` extensions. Since: 2.56
             *
             * Since GLib 2.80, when `E` is used with `%c`, `%C`, `%x`, `%X`, `%y` or `%Y`,
             * the date is formatted using an alternate era representation specific to the
             * locale. This is typically used for the Thai solar calendar or Japanese era
             * names, for example.
             *
             * - `%Ec`: the preferred date and time representation for the current locale,
             *   using the alternate era representation
             * - `%EC`: the name of the era
             * - `%Ex`: the preferred date representation for the current locale without
             *   the time, using the alternate era representation
             * - `%EX`: the preferred time representation for the current locale without
             *   the date, using the alternate era representation
             * - `%Ey`: the year since the beginning of the era denoted by the `%EC`
             *   specifier
             * - `%EY`: the full alternative year representation
             * @param format a valid UTF-8 string, containing the format for the          #GDateTime
             * @returns a newly allocated string formatted to    the requested format or %NULL in the case that there was an error (such    as a format specifier not being supported in the current locale). The    string should be freed with g_free().
             */
            format(format: string): string | null;
            /**
             * Format `datetime` in [ISO 8601 format](https://en.wikipedia.org/wiki/ISO_8601),
             * including the date, time and time zone, and return that as a UTF-8 encoded
             * string.
             *
             * Since GLib 2.66, this will output to sub-second precision if needed.
             * @returns a newly allocated string formatted in   ISO 8601 format or %NULL in the case that there was an error. The string   should be freed with g_free().
             */
            format_iso8601(): string | null;
            /**
             * Retrieves the day of the month represented by `datetime` in the gregorian
             * calendar.
             * @returns the day of the month
             */
            get_day_of_month(): number;
            /**
             * Retrieves the ISO 8601 day of the week on which `datetime` falls (1 is
             * Monday, 2 is Tuesday... 7 is Sunday).
             * @returns the day of the week
             */
            get_day_of_week(): number;
            /**
             * Retrieves the day of the year represented by `datetime` in the Gregorian
             * calendar.
             * @returns the day of the year
             */
            get_day_of_year(): number;
            /**
             * Retrieves the hour of the day represented by `datetime`
             * @returns the hour of the day
             */
            get_hour(): number;
            /**
             * Retrieves the microsecond of the date represented by `datetime`
             * @returns the microsecond of the second
             */
            get_microsecond(): number;
            /**
             * Retrieves the minute of the hour represented by `datetime`
             * @returns the minute of the hour
             */
            get_minute(): number;
            /**
             * Retrieves the month of the year represented by `datetime` in the Gregorian
             * calendar.
             * @returns the month represented by @datetime
             */
            get_month(): number;
            /**
             * Retrieves the second of the minute represented by `datetime`
             * @returns the second represented by @datetime
             */
            get_second(): number;
            /**
             * Retrieves the number of seconds since the start of the last minute,
             * including the fractional part.
             * @returns the number of seconds
             */
            get_seconds(): number;
            /**
             * Get the time zone for this `datetime`.
             * @returns the time zone
             */
            get_timezone(): TimeZone;
            /**
             * Determines the time zone abbreviation to be used at the time and in
             * the time zone of `datetime`.
             *
             * For example, in Toronto this is currently "EST" during the winter
             * months and "EDT" during the summer months when daylight savings
             * time is in effect.
             * @returns the time zone abbreviation. The returned          string is owned by the #GDateTime and it should not be          modified or freed
             */
            get_timezone_abbreviation(): string;
            /**
             * Determines the offset to UTC in effect at the time and in the time
             * zone of `datetime`.
             *
             * The offset is the number of microseconds that you add to UTC time to
             * arrive at local time for the time zone (ie: negative numbers for time
             * zones west of GMT, positive numbers for east).
             *
             * If `datetime` represents UTC time, then the offset is always zero.
             * @returns the number of microseconds that should be added to UTC to          get the local time
             */
            get_utc_offset(): TimeSpan;
            /**
             * Returns the ISO 8601 week-numbering year in which the week containing
             * `datetime` falls.
             *
             * This function, taken together with g_date_time_get_week_of_year() and
             * g_date_time_get_day_of_week() can be used to determine the full ISO
             * week date on which `datetime` falls.
             *
             * This is usually equal to the normal Gregorian year (as returned by
             * g_date_time_get_year()), except as detailed below:
             *
             * For Thursday, the week-numbering year is always equal to the usual
             * calendar year.  For other days, the number is such that every day
             * within a complete week (Monday to Sunday) is contained within the
             * same week-numbering year.
             *
             * For Monday, Tuesday and Wednesday occurring near the end of the year,
             * this may mean that the week-numbering year is one greater than the
             * calendar year (so that these days have the same week-numbering year
             * as the Thursday occurring early in the next year).
             *
             * For Friday, Saturday and Sunday occurring near the start of the year,
             * this may mean that the week-numbering year is one less than the
             * calendar year (so that these days have the same week-numbering year
             * as the Thursday occurring late in the previous year).
             *
             * An equivalent description is that the week-numbering year is equal to
             * the calendar year containing the majority of the days in the current
             * week (Monday to Sunday).
             *
             * Note that January 1 0001 in the proleptic Gregorian calendar is a
             * Monday, so this function never returns 0.
             * @returns the ISO 8601 week-numbering year for @datetime
             */
            get_week_numbering_year(): number;
            /**
             * Returns the ISO 8601 week number for the week containing `datetime`.
             * The ISO 8601 week number is the same for every day of the week (from
             * Moday through Sunday).  That can produce some unusual results
             * (described below).
             *
             * The first week of the year is week 1.  This is the week that contains
             * the first Thursday of the year.  Equivalently, this is the first week
             * that has more than 4 of its days falling within the calendar year.
             *
             * The value 0 is never returned by this function.  Days contained
             * within a year but occurring before the first ISO 8601 week of that
             * year are considered as being contained in the last week of the
             * previous year.  Similarly, the final days of a calendar year may be
             * considered as being part of the first ISO 8601 week of the next year
             * if 4 or more days of that week are contained within the new year.
             * @returns the ISO 8601 week number for @datetime.
             */
            get_week_of_year(): number;
            /**
             * Retrieves the year represented by `datetime` in the Gregorian calendar.
             * @returns the year represented by @datetime
             */
            get_year(): number;
            /**
             * Retrieves the Gregorian day, month, and year of a given #GDateTime.
             */
            get_ymd(): [number, number, number];
            /**
             * Hashes `datetime` into a #guint, suitable for use within #GHashTable.
             * @returns a #guint containing the hash
             */
            hash(): number;
            /**
             * Determines if daylight savings time is in effect at the time and in
             * the time zone of `datetime`.
             * @returns %TRUE if daylight savings time is in effect
             */
            is_daylight_savings(): boolean;
            /**
             * Atomically increments the reference count of `datetime` by one.
             * @returns the #GDateTime with the reference count increased
             */
            ref(): DateTime;
            /**
             * Creates a new #GDateTime corresponding to the same instant in time as
             * `datetime,` but in the local time zone.
             *
             * This call is equivalent to calling g_date_time_to_timezone() with the
             * time zone returned by g_time_zone_new_local().
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            to_local(): DateTime | null;
            /**
             * Stores the instant in time that `datetime` represents into `tv`.
             *
             * The time contained in a #GTimeVal is always stored in the form of
             * seconds elapsed since 1970-01-01 00:00:00 UTC, regardless of the time
             * zone associated with `datetime`.
             *
             * On systems where 'long' is 32bit (ie: all 32bit systems and all
             * Windows systems), a #GTimeVal is incapable of storing the entire
             * range of values that #GDateTime is capable of expressing.  On those
             * systems, this function returns %FALSE to indicate that the time is
             * out of range.
             *
             * On systems where 'long' is 64bit, this function never fails.
             * @param tv a #GTimeVal to modify
             * @returns %TRUE if successful, else %FALSE
             */
            to_timeval(tv: TimeVal): boolean;
            /**
             * Create a new #GDateTime corresponding to the same instant in time as
             * `datetime,` but in the time zone `tz`.
             *
             * This call can fail in the case that the time goes out of bounds.  For
             * example, converting 0001-01-01 00:00:00 UTC to a time zone west of
             * Greenwich will fail (due to the year 0 being out of range).
             * @param tz the new #GTimeZone
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            to_timezone(tz: TimeZone): DateTime | null;
            /**
             * Gives the Unix time corresponding to `datetime,` rounding down to the
             * nearest second.
             *
             * Unix time is the number of seconds that have elapsed since 1970-01-01
             * 00:00:00 UTC, regardless of the time zone associated with `datetime`.
             * @returns the Unix time corresponding to @datetime
             */
            to_unix(): number;
            /**
             * Gives the Unix time corresponding to `datetime,` in microseconds.
             *
             * Unix time is the number of microseconds that have elapsed since 1970-01-01
             * 00:00:00 UTC, regardless of the time zone associated with `datetime`.
             * @returns the Unix time corresponding to @datetime
             */
            to_unix_usec(): number;
            /**
             * Creates a new #GDateTime corresponding to the same instant in time as
             * `datetime,` but in UTC.
             *
             * This call is equivalent to calling g_date_time_to_timezone() with the
             * time zone returned by g_time_zone_new_utc().
             * @returns the newly created #GDateTime which   should be freed with g_date_time_unref(), or %NULL
             */
            to_utc(): DateTime | null;
            /**
             * Atomically decrements the reference count of `datetime` by one.
             *
             * When the reference count reaches zero, the resources allocated by
             * `datetime` are freed
             */
            unref(): void;
        }

        /**
         * Associates a string with a bit flag.
         * Used in g_parse_debug_string().
         */
        class DebugKey {
            static $gtype: GObject.GType<DebugKey>;

            // Fields

            key: string;
            value: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    key: string;
                    value: number;
                }>,
            );
            _init(...args: any[]): void;
        }

        /**
         * An opaque structure representing an opened directory.
         */
        class Dir {
            static $gtype: GObject.GType<Dir>;

            // Constructors

            constructor(path: string, flags: number);
            _init(...args: any[]): void;

            static open(path: string, flags: number): Dir;

            // Static methods

            /**
             * Creates a subdirectory in the preferred directory for temporary
             * files (as returned by g_get_tmp_dir()).
             *
             * `tmpl` should be a string in the GLib file name encoding containing
             * a sequence of six 'X' characters, as the parameter to g_mkstemp().
             * However, unlike these functions, the template should only be a
             * basename, no directory components are allowed. If template is
             * %NULL, a default template is used.
             *
             * Note that in contrast to g_mkdtemp() (and mkdtemp()) `tmpl` is not
             * modified, and might thus be a read-only literal string.
             * @param tmpl Template for directory name,   as in g_mkdtemp(), basename only, or %NULL for a default template
             */
            static make_tmp(tmpl?: string | null): string;

            // Methods

            /**
             * Closes the directory immediately and decrements the reference count.
             *
             * Once the reference count reaches zero, the `GDir` structure itself will be
             * freed. Prior to GLib 2.80, `GDir` was not reference counted.
             *
             * It is an error to call any of the `GDir` methods other than
             * [method`GLib`.Dir.ref] and [method`GLib`.Dir.unref] on a `GDir` after calling
             * [method`GLib`.Dir.close] on it.
             */
            close(): void;
            /**
             * Retrieves the name of another entry in the directory, or %NULL.
             * The order of entries returned from this function is not defined,
             * and may vary by file system or other operating-system dependent
             * factors.
             *
             * %NULL may also be returned in case of errors. On Unix, you can
             * check `errno` to find out if %NULL was returned because of an error.
             *
             * On Unix, the '.' and '..' entries are omitted, and the returned
             * name is in the on-disk encoding.
             *
             * On Windows, as is true of all GLib functions which operate on
             * filenames, the returned name is in UTF-8.
             * @returns The entry's name or %NULL if there are no   more entries. The return value is owned by GLib and   must not be modified or freed.
             */
            read_name(): string;
            /**
             * Increment the reference count of `dir`.
             * @returns the same pointer as `dir`
             */
            ref(): Dir;
            /**
             * Resets the given directory. The next call to g_dir_read_name()
             * will return the first entry again.
             */
            rewind(): void;
            /**
             * Decrements the reference count of `dir`.
             *
             * Once the reference count reaches zero, the directory will be closed and all
             * resources associated with it will be freed. If [method`GLib`.Dir.close] is
             * called when the reference count is greater than zero, the directory is closed
             * but the `GDir` structure will not be freed until its reference count reaches
             * zero.
             *
             * It is an error to call any of the `GDir` methods other than
             * [method`GLib`.Dir.ref] and [method`GLib`.Dir.unref] on a `GDir` after calling
             * [method`GLib`.Dir.close] on it.
             */
            unref(): void;
        }

        /**
         * The `GError` structure contains information about
         * an error that has occurred.
         */
        class Error {
            static $gtype: GObject.GType<Error>;

            // Fields

            domain: Quark;
            code: number;
            message: string;
            stack: string;

            // Constructors

            constructor(
                properties?: Partial<{
                    domain: Quark;
                    code: number;
                    message: string;
                }>,
            );
            _init(...args: any[]): void;

            static new_literal(domain: { new (...args: any[]): Error } | Quark, code: number, message: string): Error;

            // Static methods

            /**
             * This function registers an extended #GError domain.
             * `error_type_name` will be duplicated. Otherwise does the same as
             * g_error_domain_register_static().
             * @param error_type_name string to create a #GQuark from
             * @param error_type_private_size size of the private error data in bytes
             * @param error_type_init function initializing fields of the private error data
             * @param error_type_copy function copying fields of the private error data
             * @param error_type_clear function freeing fields of the private error data
             */
            static domain_register(
                error_type_name: string,
                error_type_private_size: number,
                error_type_init: ErrorInitFunc,
                error_type_copy: ErrorCopyFunc,
                error_type_clear: ErrorClearFunc,
            ): Quark;
            /**
             * This function registers an extended #GError domain.
             *
             * `error_type_name` should not be freed. `error_type_private_size` must
             * be greater than 0.
             *
             * `error_type_init` receives an initialized #GError and should then initialize
             * the private data.
             *
             * `error_type_copy` is a function that receives both original and a copy
             * #GError and should copy the fields of the private error data. The standard
             * #GError fields are already handled.
             *
             * `error_type_clear` receives the pointer to the error, and it should free the
             * fields of the private error data. It should not free the struct itself though.
             *
             * Normally, it is better to use G_DEFINE_EXTENDED_ERROR(), as it
             * already takes care of passing valid information to this function.
             * @param error_type_name static string to create a #GQuark from
             * @param error_type_private_size size of the private error data in bytes
             * @param error_type_init function initializing fields of the private error data
             * @param error_type_copy function copying fields of the private error data
             * @param error_type_clear function freeing fields of the private error data
             */
            static domain_register_static(
                error_type_name: string,
                error_type_private_size: number,
                error_type_init: ErrorInitFunc,
                error_type_copy: ErrorCopyFunc,
                error_type_clear: ErrorClearFunc,
            ): Quark;

            // Methods

            /**
             * Makes a copy of `error`.
             * @returns a new #GError
             */
            copy(): Error;
            /**
             * Frees a #GError and associated resources.
             */
            free(): void;
            /**
             * Returns %TRUE if `error` matches `domain` and `code,` %FALSE
             * otherwise. In particular, when `error` is %NULL, %FALSE will
             * be returned.
             *
             * If `domain` contains a `FAILED` (or otherwise generic) error code,
             * you should generally not check for it explicitly, but should
             * instead treat any not-explicitly-recognized error code as being
             * equivalent to the `FAILED` code. This way, if the domain is
             * extended in the future to provide a more specific error code for
             * a certain case, your code will still work.
             * @param domain an error domain
             * @param code an error code
             * @returns whether @error has @domain and @code
             */
            matches(domain: { new (...args: any[]): Error } | Quark, code: number): boolean;
        }

        /**
         * The #GHashTable struct is an opaque data structure to represent a
         * [Hash Table](data-structures.html#hash-tables). It should only be accessed via the
         * following functions.
         */
        abstract class HashTable<A = string, B = any> {
            static $gtype: GObject.GType<HashTable>;

            [key: string]: B;

            // Static methods

            /**
             * This is a convenience function for using a #GHashTable as a set.  It
             * is equivalent to calling g_hash_table_replace() with `key` as both the
             * key and the value.
             *
             * In particular, this means that if `key` already exists in the hash table, then
             * the old copy of `key` in the hash table is freed and `key` replaces it in the
             * table.
             *
             * When a hash table only ever contains keys that have themselves as the
             * corresponding value it is able to be stored more efficiently.  See
             * the discussion in the section description.
             *
             * Starting from GLib 2.40, this function returns a boolean value to
             * indicate whether the newly added value was already in the hash table
             * or not.
             * @param hash_table a #GHashTable
             * @param key a key to insert
             */
            static add(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
            /**
             * Checks if `key` is in `hash_table`.
             * @param hash_table a #GHashTable
             * @param key a key to check
             */
            static contains(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
            /**
             * Destroys all keys and values in the #GHashTable and decrements its
             * reference count by 1. If keys and/or values are dynamically allocated,
             * you should either free them first or create the #GHashTable with destroy
             * notifiers using g_hash_table_new_full(). In the latter case the destroy
             * functions you supplied will be called on all keys and values during the
             * destruction phase.
             * @param hash_table a #GHashTable
             */
            static destroy(hash_table: { [key: string]: any } | HashTable<any, any>): void;
            /**
             * Calls the given function for key/value pairs in the #GHashTable
             * until `predicate` returns %TRUE. The function is passed the key
             * and value of each pair, and the given `user_data` parameter. The
             * hash table may not be modified while iterating over it (you can't
             * add/remove items).
             *
             * Note, that hash tables are really only optimized for forward
             * lookups, i.e. g_hash_table_lookup(). So code that frequently issues
             * g_hash_table_find() or g_hash_table_foreach() (e.g. in the order of
             * once per every entry in a hash table) should probably be reworked
             * to use additional or different data structures for reverse lookups
             * (keep in mind that an O(n) find/foreach operation issued for all n
             * values in a hash table ends up needing O(n*n) operations).
             * @param hash_table a #GHashTable
             * @param predicate function to test the key/value pairs for a certain property
             */
            static find(hash_table: { [key: string]: any } | HashTable<any, any>, predicate: HRFunc): any | null;
            /**
             * Calls the given function for each of the key/value pairs in the
             * #GHashTable.  The function is passed the key and value of each
             * pair, and the given `user_data` parameter.  The hash table may not
             * be modified while iterating over it (you can't add/remove
             * items). To remove all items matching a predicate, use
             * g_hash_table_foreach_remove().
             *
             * The order in which g_hash_table_foreach() iterates over the keys/values in
             * the hash table is not defined.
             *
             * See g_hash_table_find() for performance caveats for linear
             * order searches in contrast to g_hash_table_lookup().
             * @param hash_table a #GHashTable
             * @param func the function to call for each key/value pair
             */
            static foreach(hash_table: { [key: string]: any } | HashTable<any, any>, func: HFunc): void;
            /**
             * Calls the given function for each key/value pair in the
             * #GHashTable. If the function returns %TRUE, then the key/value
             * pair is removed from the #GHashTable. If you supplied key or
             * value destroy functions when creating the #GHashTable, they are
             * used to free the memory allocated for the removed keys and values.
             *
             * See #GHashTableIter for an alternative way to loop over the
             * key/value pairs in the hash table.
             * @param hash_table a #GHashTable
             * @param func the function to call for each key/value pair
             */
            static foreach_remove(hash_table: { [key: string]: any } | HashTable<any, any>, func: HRFunc): number;
            /**
             * Calls the given function for each key/value pair in the
             * #GHashTable. If the function returns %TRUE, then the key/value
             * pair is removed from the #GHashTable, but no key or value
             * destroy functions are called.
             *
             * See #GHashTableIter for an alternative way to loop over the
             * key/value pairs in the hash table.
             * @param hash_table a #GHashTable
             * @param func the function to call for each key/value pair
             */
            static foreach_steal(hash_table: { [key: string]: any } | HashTable<any, any>, func: HRFunc): number;
            /**
             * Inserts a new key and value into a #GHashTable.
             *
             * If the key already exists in the #GHashTable its current
             * value is replaced with the new value. If you supplied a
             * `value_destroy_func` when creating the #GHashTable, the old
             * value is freed using that function. If you supplied a
             * `key_destroy_func` when creating the #GHashTable, the passed
             * key is freed using that function.
             *
             * Starting from GLib 2.40, this function returns a boolean value to
             * indicate whether the newly added value was already in the hash table
             * or not.
             * @param hash_table a #GHashTable
             * @param key a key to insert
             * @param value the value to associate with the key
             */
            static insert(
                hash_table: { [key: string]: any } | HashTable<any, any>,
                key?: any | null,
                value?: any | null,
            ): boolean;
            /**
             * Looks up a key in a #GHashTable. Note that this function cannot
             * distinguish between a key that is not present and one which is present
             * and has the value %NULL. If you need this distinction, use
             * g_hash_table_lookup_extended().
             * @param hash_table a #GHashTable
             * @param key the key to look up
             */
            static lookup(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): any | null;
            /**
             * Looks up a key in the #GHashTable, returning the original key and the
             * associated value and a #gboolean which is %TRUE if the key was found. This
             * is useful if you need to free the memory allocated for the original key,
             * for example before calling g_hash_table_remove().
             *
             * You can actually pass %NULL for `lookup_key` to test
             * whether the %NULL key exists, provided the hash and equal functions
             * of `hash_table` are %NULL-safe.
             * @param hash_table a #GHashTable
             * @param lookup_key the key to look up
             */
            static lookup_extended(
                hash_table: { [key: string]: any } | HashTable<any, any>,
                lookup_key: any | null,
            ): [boolean, any, any];
            /**
             * Creates a new #GHashTable like g_hash_table_new_full() with a reference
             * count of 1.
             *
             * It inherits the hash function, the key equal function, the key destroy function,
             * as well as the value destroy function, from `other_hash_table`.
             *
             * The returned hash table will be empty; it will not contain the keys
             * or values from `other_hash_table`.
             * @param other_hash_table Another #GHashTable
             */
            static new_similar(other_hash_table: { [key: string]: any } | HashTable<any, any>): HashTable<any, any>;
            /**
             * Atomically increments the reference count of `hash_table` by one.
             * This function is MT-safe and may be called from any thread.
             * @param hash_table a valid #GHashTable
             */
            static ref(hash_table: { [key: string]: any } | HashTable<any, any>): HashTable<any, any>;
            /**
             * Removes a key and its associated value from a #GHashTable.
             *
             * If the #GHashTable was created using g_hash_table_new_full(), the
             * key and value are freed using the supplied destroy functions, otherwise
             * you have to make sure that any dynamically allocated values are freed
             * yourself.
             * @param hash_table a #GHashTable
             * @param key the key to remove
             */
            static remove(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
            /**
             * Removes all keys and their associated values from a #GHashTable.
             *
             * If the #GHashTable was created using g_hash_table_new_full(),
             * the keys and values are freed using the supplied destroy functions,
             * otherwise you have to make sure that any dynamically allocated
             * values are freed yourself.
             * @param hash_table a #GHashTable
             */
            static remove_all(hash_table: { [key: string]: any } | HashTable<any, any>): void;
            /**
             * Inserts a new key and value into a #GHashTable similar to
             * g_hash_table_insert(). The difference is that if the key
             * already exists in the #GHashTable, it gets replaced by the
             * new key. If you supplied a `value_destroy_func` when creating
             * the #GHashTable, the old value is freed using that function.
             * If you supplied a `key_destroy_func` when creating the
             * #GHashTable, the old key is freed using that function.
             *
             * Starting from GLib 2.40, this function returns a boolean value to
             * indicate whether the newly added value was already in the hash table
             * or not.
             * @param hash_table a #GHashTable
             * @param key a key to insert
             * @param value the value to associate with the key
             */
            static replace(
                hash_table: { [key: string]: any } | HashTable<any, any>,
                key?: any | null,
                value?: any | null,
            ): boolean;
            /**
             * Returns the number of elements contained in the #GHashTable.
             * @param hash_table a #GHashTable
             */
            static size(hash_table: { [key: string]: any } | HashTable<any, any>): number;
            /**
             * Removes a key and its associated value from a #GHashTable without
             * calling the key and value destroy functions.
             * @param hash_table a #GHashTable
             * @param key the key to remove
             */
            static steal(hash_table: { [key: string]: any } | HashTable<any, any>, key?: any | null): boolean;
            /**
             * Removes all keys and their associated values from a #GHashTable
             * without calling the key and value destroy functions.
             * @param hash_table a #GHashTable
             */
            static steal_all(hash_table: { [key: string]: any } | HashTable<any, any>): void;
            /**
             * Looks up a key in the #GHashTable, stealing the original key and the
             * associated value and returning %TRUE if the key was found. If the key was
             * not found, %FALSE is returned.
             *
             * If found, the stolen key and value are removed from the hash table without
             * calling the key and value destroy functions, and ownership is transferred to
             * the caller of this method, as with g_hash_table_steal(). That is the case
             * regardless whether `stolen_key` or `stolen_value` output parameters are
             * requested.
             *
             * You can pass %NULL for `lookup_key,` provided the hash and equal functions
             * of `hash_table` are %NULL-safe.
             *
             * The dictionary implementation optimizes for having all values identical to
             * their keys, for example by using g_hash_table_add(). Before 2.82, when
             * stealing both the key and the value from such a dictionary, the value was
             * %NULL. Since 2.82, the returned value and key will be the same.
             * @param hash_table a #GHashTable
             * @param lookup_key the key to look up
             */
            static steal_extended(
                hash_table: { [key: string]: any } | HashTable<any, any>,
                lookup_key: any | null,
            ): [boolean, any, any];
            /**
             * Atomically decrements the reference count of `hash_table` by one.
             * If the reference count drops to 0, all keys and values will be
             * destroyed, and all memory allocated by the hash table is released.
             * This function is MT-safe and may be called from any thread.
             * @param hash_table a valid #GHashTable
             */
            static unref(hash_table: { [key: string]: any } | HashTable<any, any>): void;
        }

        /**
         * A GHashTableIter structure represents an iterator that can be used
         * to iterate over the elements of a #GHashTable. GHashTableIter
         * structures are typically allocated on the stack and then initialized
         * with g_hash_table_iter_init().
         *
         * The iteration order of a #GHashTableIter over the keys/values in a hash
         * table is not defined.
         */
        class HashTableIter {
            static $gtype: GObject.GType<HashTableIter>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            // Methods

            /**
             * Returns the #GHashTable associated with `iter`.
             * @returns the #GHashTable associated with @iter.
             */
            get_hash_table(): HashTable<any, any>;
            /**
             * Initializes a key/value pair iterator and associates it with
             * `hash_table`. Modifying the hash table after calling this function
             * invalidates the returned iterator.
             *
             * The iteration order of a #GHashTableIter over the keys/values in a hash
             * table is not defined.
             *
             *
             * ```c
             * GHashTableIter iter;
             * gpointer key, value;
             *
             * g_hash_table_iter_init (&iter, hash_table);
             * while (g_hash_table_iter_next (&iter, &key, &value))
             *   {
             *     // do something with key and value
             *   }
             * ```
             *
             * @param hash_table a #GHashTable
             */
            init(hash_table: { [key: string]: any } | HashTable<any, any>): void;
            /**
             * Advances `iter` and retrieves the key and/or value that are now
             * pointed to as a result of this advancement. If %FALSE is returned,
             * `key` and `value` are not set, and the iterator becomes invalid.
             * @returns %FALSE if the end of the #GHashTable has been reached.
             */
            next(): [boolean, any, any];
            /**
             * Removes the key/value pair currently pointed to by the iterator
             * from its associated #GHashTable. Can only be called after
             * g_hash_table_iter_next() returned %TRUE, and cannot be called
             * more than once for the same key/value pair.
             *
             * If the #GHashTable was created using g_hash_table_new_full(),
             * the key and value are freed using the supplied destroy functions,
             * otherwise you have to make sure that any dynamically allocated
             * values are freed yourself.
             *
             * It is safe to continue iterating the #GHashTable afterward:
             *
             * ```c
             * while (g_hash_table_iter_next (&iter, &key, &value))
             *   {
             *     if (condition)
             *       g_hash_table_iter_remove (&iter);
             *   }
             * ```
             *
             */
            remove(): void;
            /**
             * Replaces the value currently pointed to by the iterator
             * from its associated #GHashTable. Can only be called after
             * g_hash_table_iter_next() returned %TRUE.
             *
             * If you supplied a `value_destroy_func` when creating the
             * #GHashTable, the old value is freed using that function.
             * @param value the value to replace with
             */
            replace(value?: any | null): void;
            /**
             * Removes the key/value pair currently pointed to by the
             * iterator from its associated #GHashTable, without calling
             * the key and value destroy functions. Can only be called
             * after g_hash_table_iter_next() returned %TRUE, and cannot
             * be called more than once for the same key/value pair.
             */
            steal(): void;
        }

        /**
         * HMACs should be used when producing a cookie or hash based on data
         * and a key. Simple mechanisms for using SHA1 and other algorithms to
         * digest a key and data together are vulnerable to various security
         * issues.
         * [HMAC](http://en.wikipedia.org/wiki/HMAC)
         * uses algorithms like SHA1 in a secure way to produce a digest of a
         * key and data.
         *
         * Both the key and data are arbitrary byte arrays of bytes or characters.
         *
         * Support for HMAC Digests has been added in GLib 2.30, and support for SHA-512
         * in GLib 2.42. Support for SHA-384 was added in GLib 2.52.
         *
         * To create a new `GHmac`, use [ctor`GLib`.Hmac.new]. To free a `GHmac`, use
         * [method`GLib`.Hmac.unref].
         */
        class Hmac {
            static $gtype: GObject.GType<Hmac>;

            // Constructors

            constructor(digest_type: ChecksumType, key: Uint8Array | string);
            _init(...args: any[]): void;

            static ['new'](digest_type: ChecksumType, key: Uint8Array | string): Hmac;

            // Methods

            /**
             * Copies a #GHmac. If `hmac` has been closed, by calling
             * g_hmac_get_string() or g_hmac_get_digest(), the copied
             * HMAC will be closed as well.
             * @returns the copy of the passed #GHmac. Use g_hmac_unref()   when finished using it.
             */
            copy(): Hmac;
            /**
             * Gets the digest from `checksum` as a raw binary array and places it
             * into `buffer`. The size of the digest depends on the type of checksum.
             *
             * Once this function has been called, the #GHmac is closed and can
             * no longer be updated with g_checksum_update().
             * @param buffer output buffer
             */
            get_digest(buffer: Uint8Array | string): void;
            /**
             * Gets the HMAC as a hexadecimal string.
             *
             * Once this function has been called the #GHmac can no longer be
             * updated with g_hmac_update().
             *
             * The hexadecimal characters will be lower case.
             * @returns the hexadecimal representation of the HMAC. The   returned string is owned by the HMAC and should not be modified   or freed.
             */
            get_string(): string;
            /**
             * Atomically increments the reference count of `hmac` by one.
             *
             * This function is MT-safe and may be called from any thread.
             * @returns the passed in #GHmac.
             */
            ref(): Hmac;
            /**
             * Atomically decrements the reference count of `hmac` by one.
             *
             * If the reference count drops to 0, all keys and values will be
             * destroyed, and all memory allocated by the hash table is released.
             * This function is MT-safe and may be called from any thread.
             * Frees the memory allocated for `hmac`.
             */
            unref(): void;
            /**
             * Feeds `data` into an existing #GHmac.
             *
             * The HMAC must still be open, that is g_hmac_get_string() or
             * g_hmac_get_digest() must not have been called on `hmac`.
             * @param data buffer used to compute the checksum
             */
            update(data: Uint8Array | string): void;
        }

        /**
         * The #GHook struct represents a single hook function in a #GHookList.
         */
        class Hook {
            static $gtype: GObject.GType<Hook>;

            // Fields

            data: any;
            ref_count: number;
            hook_id: number;
            flags: number;
            func: any;
            destroy: DestroyNotify;

            // Constructors

            _init(...args: any[]): void;

            // Static methods

            /**
             * Removes one #GHook from a #GHookList, marking it
             * inactive and calling g_hook_unref() on it.
             * @param hook_list a #GHookList
             * @param hook the #GHook to remove
             */
            static destroy_link(hook_list: HookList, hook: Hook): void;
            /**
             * Calls the #GHookList `finalize_hook` function if it exists,
             * and frees the memory allocated for the #GHook.
             * @param hook_list a #GHookList
             * @param hook the #GHook to free
             */
            static free(hook_list: HookList, hook: Hook): void;
            /**
             * Inserts a #GHook into a #GHookList, before a given #GHook.
             * @param hook_list a #GHookList
             * @param sibling the #GHook to insert the new #GHook before
             * @param hook the #GHook to insert
             */
            static insert_before(hook_list: HookList, sibling: Hook | null, hook: Hook): void;
            /**
             * Inserts a #GHook into a #GHookList, sorted by the given function.
             * @param hook_list a #GHookList
             * @param hook the #GHook to insert
             * @param func the comparison function used to sort the #GHook elements
             */
            static insert_sorted(hook_list: HookList, hook: Hook, func: HookCompareFunc): void;
            /**
             * Prepends a #GHook on the start of a #GHookList.
             * @param hook_list a #GHookList
             * @param hook the #GHook to add to the start of @hook_list
             */
            static prepend(hook_list: HookList, hook: Hook): void;
            /**
             * Decrements the reference count of a #GHook.
             * If the reference count falls to 0, the #GHook is removed
             * from the #GHookList and g_hook_free() is called to free it.
             * @param hook_list a #GHookList
             * @param hook the #GHook to unref
             */
            static unref(hook_list: HookList, hook: Hook): void;

            // Methods

            /**
             * Compares the ids of two #GHook elements, returning a negative value
             * if the second id is greater than the first.
             * @param sibling a #GHook to compare with @new_hook
             * @returns a value <= 0 if the id of @sibling is >= the id of @new_hook
             */
            compare_ids(sibling: Hook): number;
        }

        /**
         * The #GHookList struct represents a list of hook functions.
         */
        class HookList {
            static $gtype: GObject.GType<HookList>;

            // Fields

            seq_id: number;
            hook_size: number;
            is_setup: number;
            dummy3: any;
            finalize_hook: HookFinalizeFunc;
            dummy: any[];

            // Constructors

            _init(...args: any[]): void;

            // Methods

            /**
             * Removes all the #GHook elements from a #GHookList.
             */
            clear(): void;
            /**
             * Initializes a #GHookList.
             * This must be called before the #GHookList is used.
             * @param hook_size the size of each element in the #GHookList,     typically `sizeof (GHook)`.
             */
            init(hook_size: number): void;
            /**
             * Calls all of the #GHook functions in a #GHookList.
             * @param may_recurse %TRUE if functions which are already running     (e.g. in another thread) can be called. If set to %FALSE,     these are skipped
             */
            invoke(may_recurse: boolean): void;
            /**
             * Calls all of the #GHook functions in a #GHookList.
             * Any function which returns %FALSE is removed from the #GHookList.
             * @param may_recurse %TRUE if functions which are already running     (e.g. in another thread) can be called. If set to %FALSE,     these are skipped
             */
            invoke_check(may_recurse: boolean): void;
            /**
             * Calls a function on each valid #GHook.
             * @param may_recurse %TRUE if hooks which are currently running     (e.g. in another thread) are considered valid. If set to %FALSE,     these are skipped
             * @param marshaller the function to call for each #GHook
             */
            marshal(may_recurse: boolean, marshaller: HookMarshaller): void;
            /**
             * Calls a function on each valid #GHook and destroys it if the
             * function returns %FALSE.
             * @param may_recurse %TRUE if hooks which are currently running     (e.g. in another thread) are considered valid. If set to %FALSE,     these are skipped
             * @param marshaller the function to call for each #GHook
             */
            marshal_check(may_recurse: boolean, marshaller: HookCheckMarshaller): void;
        }

        /**
         * The `GIOChannel` data type aims to provide a portable method for
         * using file descriptors, pipes, and sockets, and integrating them
         * into the main event loop (see [struct`GLib`.MainContext]). Currently,
         * full support is available on UNIX platforms; support for Windows
         * is only partially complete.
         *
         * To create a new `GIOChannel` on UNIX systems use
         * [ctor`GLib`.IOChannel.unix_new]. This works for plain file descriptors,
         * pipes and sockets. Alternatively, a channel can be created for a
         * file in a system independent manner using [ctor`GLib`.IOChannel.new_file].
         *
         * Once a `GIOChannel` has been created, it can be used in a generic
         * manner with the functions [method`GLib`.IOChannel.read_chars],
         * [method`GLib`.IOChannel.write_chars], [method`GLib`.IOChannel.seek_position],
         * and [method`GLib`.IOChannel.shutdown].
         *
         * To add a `GIOChannel` to the main event loop, use [func`GLib`.io_add_watch] or
         * [func`GLib`.io_add_watch_full]. Here you specify which events you are
         * interested in on the `GIOChannel`, and provide a function to be called
         * whenever these events occur.
         *
         * `GIOChannel` instances are created with an initial reference count of 1.
         * [method`GLib`.IOChannel.ref] and [method`GLib`.IOChannel.unref] can be used to
         * increment or decrement the reference count respectively. When the
         * reference count falls to 0, the `GIOChannel` is freed. (Though it
         * isn’t closed automatically, unless it was created using
         * [ctor`GLib`.IOChannel.new_file].) Using [func`GLib`.io_add_watch] or
         * [func`GLib`.io_add_watch_full] increments a channel’s reference count.
         *
         * The new functions [method`GLib`.IOChannel.read_chars],
         * [method`GLib`.IOChannel.read_line], [method`GLib`.IOChannel.read_line_string],
         * [method`GLib`.IOChannel.read_to_end], [method`GLib`.IOChannel.write_chars],
         * [method`GLib`.IOChannel.seek_position], and [method`GLib`.IOChannel.flush]
         * should not be mixed with the deprecated functions
         * [method`GLib`.IOChannel.read], [method`GLib`.IOChannel.write], and
         * [method`GLib`.IOChannel.seek] on the same channel.
         */
        class IOChannel {
            static $gtype: GObject.GType<IOChannel>;

            // Constructors

            constructor(filename: string, mode: string);
            _init(...args: any[]): void;

            static new_file(filename: string, mode: string): IOChannel;

            static unix_new(fd: number): IOChannel;

            // Static methods

            /**
             * Converts an `errno` error number to a #GIOChannelError.
             * @param en an `errno` error number, e.g. `EINVAL`
             */
            static error_from_errno(en: number): IOChannelError;
            static error_quark(): Quark;

            // Methods

            /**
             * Close an IO channel. Any pending data to be written will be
             * flushed, ignoring errors. The channel will not be freed until the
             * last reference is dropped using g_io_channel_unref().
             */
            close(): void;
            /**
             * Flushes the write buffer for the GIOChannel.
             * @returns the status of the operation: One of   %G_IO_STATUS_NORMAL, %G_IO_STATUS_AGAIN, or   %G_IO_STATUS_ERROR.
             */
            flush(): IOStatus;
            /**
             * This function returns a #GIOCondition depending on whether there
             * is data to be read/space to write data in the internal buffers in
             * the #GIOChannel. Only the flags %G_IO_IN and %G_IO_OUT may be set.
             * @returns A #GIOCondition
             */
            get_buffer_condition(): IOCondition;
            /**
             * Gets the buffer size.
             * @returns the size of the buffer.
             */
            get_buffer_size(): number;
            /**
             * Returns whether `channel` is buffered.
             * @returns %TRUE if the @channel is buffered.
             */
            get_buffered(): boolean;
            /**
             * Returns whether the file/socket/whatever associated with `channel`
             * will be closed when `channel` receives its final unref and is
             * destroyed. The default value of this is %TRUE for channels created
             * by g_io_channel_new_file (), and %FALSE for all other channels.
             * @returns %TRUE if the channel will be closed, %FALSE otherwise.
             */
            get_close_on_unref(): boolean;
            /**
             * Gets the encoding for the input/output of the channel.
             * The internal encoding is always UTF-8. The encoding %NULL
             * makes the channel safe for binary data.
             * @returns A string containing the encoding, this string is   owned by GLib and must not be freed.
             */
            get_encoding(): string;
            /**
             * Gets the current flags for a #GIOChannel, including read-only
             * flags such as %G_IO_FLAG_IS_READABLE.
             *
             * The values of the flags %G_IO_FLAG_IS_READABLE and %G_IO_FLAG_IS_WRITABLE
             * are cached for internal use by the channel when it is created.
             * If they should change at some later point (e.g. partial shutdown
             * of a socket with the UNIX shutdown() function), the user
             * should immediately call g_io_channel_get_flags() to update
             * the internal values of these flags.
             * @returns the flags which are set on the channel
             */
            get_flags(): IOFlags;
            /**
             * This returns the string that #GIOChannel uses to determine
             * where in the file a line break occurs. A value of %NULL
             * indicates autodetection. Since 2.84, the return value is always
             * nul-terminated.
             * @returns The line termination string. This value   is owned by GLib and must not be freed.
             */
            get_line_term(): [string, number];
            /**
             * Initializes a #GIOChannel struct.
             *
             * This is called by each of the above functions when creating a
             * #GIOChannel, and so is not often needed by the application
             * programmer (unless you are creating a new type of #GIOChannel).
             */
            init(): void;
            /**
             * Reads data from a #GIOChannel.
             * @param buf a buffer to read the data into (which should be at least       count bytes long)
             * @param count the number of bytes to read from the #GIOChannel
             * @param bytes_read returns the number of bytes actually read
             * @returns %G_IO_ERROR_NONE if the operation was successful.
             */
            read(buf: string, count: number, bytes_read: number): IOError;
            /**
             * Replacement for g_io_channel_read() with the new API.
             * @returns the status of the operation.
             */
            read_chars(): [IOStatus, Uint8Array, number];
            /**
             * Reads a line, including the terminating character(s),
             * from a #GIOChannel into a newly-allocated string.
             * `str_return` will contain allocated memory if the return
             * is %G_IO_STATUS_NORMAL.
             * @returns the status of the operation.
             */
            read_line(): [IOStatus, string, number, number];
            /**
             * Reads a line from a #GIOChannel, using a #GString as a buffer.
             * @param buffer a #GString into which the line will be written.          If @buffer already contains data, the old data will          be overwritten.
             * @param terminator_pos location to store position of line terminator, or %NULL
             * @returns the status of the operation.
             */
            read_line_string(buffer: String, terminator_pos?: number | null): IOStatus;
            /**
             * Reads all the remaining data from the file.
             * @returns %G_IO_STATUS_NORMAL on success.     This function never returns %G_IO_STATUS_EOF.
             */
            read_to_end(): [IOStatus, Uint8Array];
            /**
             * Reads a Unicode character from `channel`.
             * This function cannot be called on a channel with %NULL encoding.
             * @returns a #GIOStatus
             */
            read_unichar(): [IOStatus, number];
            /**
             * Increments the reference count of a #GIOChannel.
             * @returns the @channel that was passed in (since 2.6)
             */
            ref(): IOChannel;
            /**
             * Sets the current position in the #GIOChannel, similar to the standard
             * library function fseek().
             * @param offset an offset, in bytes, which is added to the position specified          by @type
             * @param type the position in the file, which can be %G_SEEK_CUR (the current        position), %G_SEEK_SET (the start of the file), or %G_SEEK_END        (the end of the file)
             * @returns %G_IO_ERROR_NONE if the operation was successful.
             */
            seek(offset: number, type: SeekType | null): IOError;
            /**
             * Replacement for g_io_channel_seek() with the new API.
             * @param offset The offset in bytes from the position specified by @type
             * @param type a #GSeekType. The type %G_SEEK_CUR is only allowed in those                      cases where a call to g_io_channel_set_encoding ()                      is allowed. See the documentation for                      g_io_channel_set_encoding () for details.
             * @returns the status of the operation.
             */
            seek_position(offset: number, type: SeekType | null): IOStatus;
            /**
             * Sets the buffer size.
             * @param size the size of the buffer, or 0 to let GLib pick a good size
             */
            set_buffer_size(size: number): void;
            /**
             * The buffering state can only be set if the channel's encoding
             * is %NULL. For any other encoding, the channel must be buffered.
             *
             * A buffered channel can only be set unbuffered if the channel's
             * internal buffers have been flushed. Newly created channels or
             * channels which have returned %G_IO_STATUS_EOF
             * not require such a flush. For write-only channels, a call to
             * g_io_channel_flush () is sufficient. For all other channels,
             * the buffers may be flushed by a call to g_io_channel_seek_position ().
             * This includes the possibility of seeking with seek type %G_SEEK_CUR
             * and an offset of zero. Note that this means that socket-based
             * channels cannot be set unbuffered once they have had data
             * read from them.
             *
             * On unbuffered channels, it is safe to mix read and write
             * calls from the new and old APIs, if this is necessary for
             * maintaining old code.
             *
             * The default state of the channel is buffered.
             * @param buffered whether to set the channel buffered or unbuffered
             */
            set_buffered(buffered: boolean): void;
            /**
             * Whether to close the channel on the final unref of the #GIOChannel
             * data structure. The default value of this is %TRUE for channels
             * created by g_io_channel_new_file (), and %FALSE for all other channels.
             *
             * Setting this flag to %TRUE for a channel you have already closed
             * can cause problems when the final reference to the #GIOChannel is dropped.
             * @param do_close Whether to close the channel on the final unref of            the GIOChannel data structure.
             */
            set_close_on_unref(do_close: boolean): void;
            /**
             * Sets the encoding for the input/output of the channel.
             * The internal encoding is always UTF-8. The default encoding
             * for the external file is UTF-8.
             *
             * The encoding %NULL is safe to use with binary data.
             *
             * The encoding can only be set if one of the following conditions
             * is true:
             *
             * - The channel was just created, and has not been written to or read from yet.
             *
             * - The channel is write-only.
             *
             * - The channel is a file, and the file pointer was just repositioned
             *   by a call to g_io_channel_seek_position(). (This flushes all the
             *   internal buffers.)
             *
             * - The current encoding is %NULL or UTF-8.
             *
             * - One of the (new API) read functions has just returned %G_IO_STATUS_EOF
             *   (or, in the case of g_io_channel_read_to_end(), %G_IO_STATUS_NORMAL).
             *
             * -  One of the functions g_io_channel_read_chars() or
             *    g_io_channel_read_unichar() has returned %G_IO_STATUS_AGAIN or
             *    %G_IO_STATUS_ERROR. This may be useful in the case of
             *    %G_CONVERT_ERROR_ILLEGAL_SEQUENCE.
             *    Returning one of these statuses from g_io_channel_read_line(),
             *    g_io_channel_read_line_string(), or g_io_channel_read_to_end()
             *    does not guarantee that the encoding can be changed.
             *
             * Channels which do not meet one of the above conditions cannot call
             * g_io_channel_seek_position() with an offset of %G_SEEK_CUR, and, if
             * they are "seekable", cannot call g_io_channel_write_chars() after
             * calling one of the API "read" functions.
             * @param encoding the encoding type
             * @returns %G_IO_STATUS_NORMAL if the encoding was successfully set
             */
            set_encoding(encoding?: string | null): IOStatus;
            /**
             * Sets the (writeable) flags in `channel` to (`flags` & %G_IO_FLAG_SET_MASK).
             * @param flags the flags to set on the IO channel
             * @returns the status of the operation.
             */
            set_flags(flags: IOFlags | null): IOStatus;
            /**
             * This sets the string that #GIOChannel uses to determine
             * where in the file a line break occurs.
             * @param line_term The line termination string. Use %NULL for             autodetect.  Autodetection breaks on "\n", "\r\n", "\r", "\0",             and the Unicode paragraph separator. Autodetection should not be             used for anything other than file-based channels.
             * @param length The length of the termination string. If -1 is passed, the          string is assumed to be nul-terminated. This option allows          termination strings with embedded nuls.
             */
            set_line_term(line_term: string | null, length: number): void;
            /**
             * Close an IO channel. Any pending data to be written will be
             * flushed if `flush` is %TRUE. The channel will not be freed until the
             * last reference is dropped using g_io_channel_unref().
             * @param flush if %TRUE, flush pending
             * @returns the status of the operation.
             */
            shutdown(flush: boolean): IOStatus;
            /**
             * Returns the file descriptor of the #GIOChannel.
             *
             * On Windows this function returns the file descriptor or socket of
             * the #GIOChannel.
             * @returns the file descriptor of the #GIOChannel.
             */
            unix_get_fd(): number;
            /**
             * Decrements the reference count of a #GIOChannel.
             */
            unref(): void;
            /**
             * Writes data to a #GIOChannel.
             * @param buf the buffer containing the data to write
             * @param count the number of bytes to write
             * @param bytes_written the number of bytes actually written
             * @returns %G_IO_ERROR_NONE if the operation was successful.
             */
            write(buf: string, count: number, bytes_written: number): IOError;
            /**
             * Replacement for g_io_channel_write() with the new API.
             *
             * On seekable channels with encodings other than %NULL or UTF-8, generic
             * mixing of reading and writing is not allowed. A call to g_io_channel_write_chars ()
             * may only be made on a channel from which data has been read in the
             * cases described in the documentation for g_io_channel_set_encoding ().
             * @param buf a buffer to write data from
             * @param count the size of the buffer. If -1, the buffer         is taken to be a nul-terminated string.
             * @returns the status of the operation.
             */
            write_chars(buf: Uint8Array | string, count: number): [IOStatus, number];
            /**
             * Writes a Unicode character to `channel`.
             * This function cannot be called on a channel with %NULL encoding.
             * @param thechar a character
             * @returns a #GIOStatus
             */
            write_unichar(thechar: number): IOStatus;
        }

        /**
         * A table of functions used to handle different types of #GIOChannel
         * in a generic way.
         */
        class IOFuncs {
            static $gtype: GObject.GType<IOFuncs>;

            // Constructors

            _init(...args: any[]): void;
        }

        /**
         * `GKeyFile` parses .ini-like config files.
         *
         * `GKeyFile` lets you parse, edit or create files containing groups of
         * key-value pairs, which we call ‘key files’ for lack of a better name.
         * Several freedesktop.org specifications use key files. For example, the
         * [Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/)
         * and the [Icon Theme Specification](https://specifications.freedesktop.org/icon-theme-spec/latest/).
         *
         * The syntax of key files is described in detail in the
         * [Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/),
         * here is a quick summary: Key files consists of groups of key-value pairs, interspersed
         * with comments.
         *
         * ```txt
         * # this is just an example
         * # there can be comments before the first group
         *
         * [First Group]
         *
         * Name=Key File Example\tthis value shows\nescaping
         *
         * # localized strings are stored in multiple key-value pairs
         * Welcome=Hello
         * Welcome[de]=Hallo
         * Welcome[fr_FR]=Bonjour
         * Welcome[it]=Ciao
         *
         * [Another Group]
         *
         * Numbers=2;20;-200;0
         *
         * Booleans=true;false;true;true
         * ```
         *
         * Lines beginning with a `#` and blank lines are considered comments.
         *
         * Groups are started by a header line containing the group name enclosed
         * in `[` and `]`, and ended implicitly by the start of the next group or
         * the end of the file. Each key-value pair must be contained in a group.
         *
         * Key-value pairs generally have the form `key=value`, with the exception
         * of localized strings, which have the form `key[locale]=value`, with a
         * locale identifier of the form `lang_COUNTRY`MODIFIER`` where `COUNTRY`
         * and `MODIFIER` are optional. As a special case, the locale `C` is associated
         * with the untranslated pair `key=value` (since GLib 2.84). Space before and
         * after the `=` character is ignored. Newline, tab, carriage return and
         * backslash characters in value are escaped as `\n`, `\t`, `\r`, and `\\\\`,
         * respectively. To preserve leading spaces in values, these can also be escaped
         * as `\s`.
         *
         * Key files can store strings (possibly with localized variants), integers,
         * booleans and lists of these. Lists are separated by a separator character,
         * typically `;` or `,`. To use the list separator character in a value in
         * a list, it has to be escaped by prefixing it with a backslash.
         *
         * This syntax is obviously inspired by the .ini files commonly met
         * on Windows, but there are some important differences:
         *
         * - .ini files use the `;` character to begin comments,
         *   key files use the `#` character.
         *
         * - Key files do not allow for ungrouped keys meaning only
         *   comments can precede the first group.
         *
         * - Key files are always encoded in UTF-8.
         *
         * - Key and Group names are case-sensitive. For example, a group called
         *   `[GROUP]` is a different from `[group]`.
         *
         * - .ini files don’t have a strongly typed boolean entry type,
         *    they only have `GetProfileInt()`. In key files, only
         *    `true` and `false` (in lower case) are allowed.
         *
         * Note that in contrast to the
         * [Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/),
         * groups in key files may contain the same key multiple times; the last entry wins.
         * Key files may also contain multiple groups with the same name; they are merged
         * together. Another difference is that keys and group names in key files are not
         * restricted to ASCII characters.
         *
         * Here is an example of loading a key file and reading a value:
         *
         * ```c
         * g_autoptr(GError) error = NULL;
         * g_autoptr(GKeyFile) key_file = g_key_file_new ();
         *
         * if (!g_key_file_load_from_file (key_file, "key-file.ini", flags, &error))
         *   {
         *     if (!g_error_matches (error, G_FILE_ERROR, G_FILE_ERROR_NOENT))
         *       g_warning ("Error loading key file: %s", error->message);
         *     return;
         *   }
         *
         * g_autofree gchar *val = g_key_file_get_string (key_file, "Group Name", "SomeKey", &error);
         * if (val == NULL &&
         *     !g_error_matches (error, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND))
         *   {
         *     g_warning ("Error finding key in key file: %s", error->message);
         *     return;
         *   }
         * else if (val == NULL)
         *   {
         *     // Fall back to a default value.
         *     val = g_strdup ("default-value");
         *   }
         * ```
         *
         * Here is an example of creating and saving a key file:
         *
         * ```c
         * g_autoptr(GKeyFile) key_file = g_key_file_new ();
         * const gchar *val = …;
         * g_autoptr(GError) error = NULL;
         *
         * g_key_file_set_string (key_file, "Group Name", "SomeKey", val);
         *
         * // Save as a file.
         * if (!g_key_file_save_to_file (key_file, "key-file.ini", &error))
         *   {
         *     g_warning ("Error saving key file: %s", error->message);
         *     return;
         *   }
         *
         * // Or store to a GBytes for use elsewhere.
         * gsize data_len;
         * g_autofree guint8 *data = (guint8 *) g_key_file_to_data (key_file, &data_len, &error);
         * if (data == NULL)
         *   {
         *     g_warning ("Error saving key file: %s", error->message);
         *     return;
         *   }
         * g_autoptr(GBytes) bytes = g_bytes_new_take (g_steal_pointer (&data), data_len);
         * ```
         */
        class KeyFile {
            static $gtype: GObject.GType<KeyFile>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            static ['new'](): KeyFile;

            // Static methods

            static error_quark(): Quark;

            // Methods

            /**
             * Returns the value associated with `key` under `group_name` as a
             * boolean.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. Likewise, if the value associated with `key` cannot be interpreted
             * as a boolean then [error`GLib`.KeyFileError.INVALID_VALUE] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns the value associated with the key as a boolean,    or false if the key was not found or could not be parsed.
             */
            get_boolean(group_name: string, key: string): boolean;
            /**
             * Returns the values associated with `key` under `group_name` as
             * booleans.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. Likewise, if the values associated with `key` cannot be interpreted
             * as booleans then [error`GLib`.KeyFileError.INVALID_VALUE] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns the values associated with the key as a list of booleans, or `NULL` if the    key was not found or could not be parsed. The returned list of booleans    should be freed with [func@GLib.free] when no longer needed.
             */
            get_boolean_list(group_name: string, key: string): boolean[];
            /**
             * Retrieves a comment above `key` from `group_name`.
             *
             * If `key` is `NULL` then `comment` will be read from above
             * `group_name`. If both `key` and `group_name` are `NULL`, then
             * `comment` will be read from above the first group in the file.
             *
             * Note that the returned string does not include the `#` comment markers,
             * but does include any whitespace after them (on each line). It includes
             * the line breaks between lines, but does not include the final line break.
             * @param group_name a group name, or `NULL` to get a top-level comment
             * @param key a key, or `NULL` to get a group comment
             * @returns a comment that should be freed with [func@GLib.free]
             */
            get_comment(group_name?: string | null, key?: string | null): string;
            /**
             * Returns the value associated with `key` under `group_name` as a double.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. Likewise, if the value associated with `key` cannot be interpreted
             * as a double then [error`GLib`.KeyFileError.INVALID_VALUE] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns the value associated with the key as a double, or     `0.0` if the key was not found or could not be parsed.
             */
            get_double(group_name: string, key: string): number;
            /**
             * Returns the values associated with `key` under `group_name` as
             * doubles.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. Likewise, if the values associated with `key` cannot be interpreted
             * as doubles then [error`GLib`.KeyFileError.INVALID_VALUE] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns the values associated with the key as a list of doubles, or `NULL` if the     key was not found or could not be parsed. The returned list of doubles     should be freed with [func@GLib.free] when no longer needed.
             */
            get_double_list(group_name: string, key: string): number[];
            /**
             * Returns all groups in the key file loaded with `key_file`.
             *
             * The array of returned groups will be `NULL`-terminated, so
             * `length` may optionally be `NULL`.
             * @returns a newly-allocated    `NULL`-terminated array of strings. Use [func@GLib.strfreev] to free it.
             */
            get_groups(): [string[], number];
            /**
             * Returns the value associated with `key` under `group_name` as a signed
             * 64-bit integer.
             *
             * This is similar to [method`GLib`.KeyFile.get_integer] but can return
             * 64-bit results without truncation.
             * @param group_name a group name
             * @param key a key
             * @returns the value associated with the key as a signed 64-bit integer, or    `0` if the key was not found or could not be parsed.
             */
            get_int64(group_name: string, key: string): number;
            /**
             * Returns the value associated with `key` under `group_name` as an
             * integer.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. Likewise, if the value associated with `key` cannot be interpreted
             * as an integer, or is out of range for a `gint`, then
             * [error`GLib`.KeyFileError.INVALID_VALUE] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns the value associated with the key as an integer, or     `0` if the key was not found or could not be parsed.
             */
            get_integer(group_name: string, key: string): number;
            /**
             * Returns the values associated with `key` under `group_name` as
             * integers.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. Likewise, if the values associated with `key` cannot be interpreted
             * as integers, or are out of range for `gint`, then
             * [error`GLib`.KeyFileError.INVALID_VALUE] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns the values associated with the key as a list of integers, or `NULL` if     the key was not found or could not be parsed. The returned list of     integers should be freed with [func@GLib.free] when no longer needed.
             */
            get_integer_list(group_name: string, key: string): number[];
            /**
             * Returns all keys for the group name `group_name`.
             *
             * The array of returned keys will be `NULL`-terminated, so `length` may
             * optionally be `NULL`. If the `group_name` cannot be found,
             * [error`GLib`.KeyFileError.GROUP_NOT_FOUND] is returned.
             * @param group_name a group name
             * @returns a newly-allocated    `NULL`-terminated array of strings. Use [func@GLib.strfreev] to free it.
             */
            get_keys(group_name: string): [string[], number];
            /**
             * Returns the actual locale which the result of
             * [method`GLib`.KeyFile.get_locale_string] or
             * [method`GLib`.KeyFile.get_locale_string_list] came from.
             *
             * If calling [method`GLib`.KeyFile.get_locale_string] or
             * [method`GLib`.KeyFile.get_locale_string_list] with exactly the same `key_file,`
             * `group_name,` `key` and `locale,` the result of those functions will
             * have originally been tagged with the locale that is the result of
             * this function.
             * @param group_name a group name
             * @param key a key
             * @param locale a locale identifier or `NULL` to use the current locale
             * @returns the locale from the file, or `NULL` if the key was not   found or the entry in the file was was untranslated
             */
            get_locale_for_key(group_name: string, key: string, locale?: string | null): string | null;
            /**
             * Returns the value associated with `key` under `group_name`
             * translated in the given `locale` if available.
             *
             * If `locale` is `C` then the untranslated value is returned (since GLib 2.84).
             *
             * If `locale` is `NULL` then the current locale is assumed.
             *
             * If `locale` is to be non-`NULL`, or if the current locale will change over
             * the lifetime of the [struct`GLib`.KeyFile], it must be loaded with
             * [flags`GLib`.KeyFileFlags.KEEP_TRANSLATIONS] in order to load strings for all
             * locales.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. If the value associated
             * with `key` cannot be interpreted or no suitable translation can
             * be found then the untranslated value is returned.
             * @param group_name a group name
             * @param key a key
             * @param locale a locale identifier or `NULL` to use the current locale
             * @returns a newly allocated string or `NULL` if the specified   key cannot be found.
             */
            get_locale_string(group_name: string, key: string, locale?: string | null): string;
            /**
             * Returns the values associated with `key` under `group_name`
             * translated in the given `locale` if available.
             *
             * If `locale` is `C` then the untranslated value is returned (since GLib 2.84).
             *
             * If `locale` is `NULL` then the current locale is assumed.
             *
             * If `locale` is to be non-`NULL`, or if the current locale will change over
             * the lifetime of the [struct`GLib`.KeyFile], it must be loaded with
             * [flags`GLib`.KeyFileFlags.KEEP_TRANSLATIONS] in order to load strings for all
             * locales.
             *
             * If `key` cannot be found then [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. If the values associated
             * with `key` cannot be interpreted or no suitable translations
             * can be found then the untranslated values are returned. The
             * returned array is `NULL`-terminated, so `length` may optionally
             * be `NULL`.
             * @param group_name a group name
             * @param key a key
             * @param locale a locale identifier or `NULL` to use the current locale
             * @returns a newly allocated `NULL`-terminated string array or `NULL` if the key    isn’t found. The string array should be freed with [func@GLib.strfreev].
             */
            get_locale_string_list(group_name: string, key: string, locale?: string | null): string[];
            /**
             * Returns the name of the start group of the file.
             * @returns The start group of the key file.
             */
            get_start_group(): string | null;
            /**
             * Returns the string value associated with `key` under `group_name`.
             *
             * Unlike [method`GLib`.KeyFile.get_value], this function handles escape
             * sequences like `\s`.
             *
             * If the key cannot be found, [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. If the `group_name` cannot be found,
             * [error`GLib`.KeyFileError.GROUP_NOT_FOUND] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns a newly allocated string or `NULL` if the specified   key cannot be found.
             */
            get_string(group_name: string, key: string): string;
            /**
             * Returns the values associated with `key` under `group_name`.
             *
             * If the key cannot be found, [error`GLib`.KeyFileError.KEY_NOT_FOUND] is
             * returned. If the `group_name` cannot be found,
             * [error`GLib`.KeyFileError.GROUP_NOT_FOUND] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns a `NULL`-terminated string array or `NULL` if the specified  key cannot be found. The array should be freed with [func@GLib.strfreev].
             */
            get_string_list(group_name: string, key: string): string[];
            /**
             * Returns the value associated with `key` under `group_name` as an unsigned
             * 64-bit integer.
             *
             * This is similar to [method`GLib`.KeyFile.get_integer] but can return
             * large positive results without truncation.
             * @param group_name a group name
             * @param key a key
             * @returns the value associated with the key as an unsigned 64-bit integer,    or `0` if the key was not found or could not be parsed.
             */
            get_uint64(group_name: string, key: string): number;
            /**
             * Returns the raw value associated with `key` under `group_name`.
             *
             * Use [method`GLib`.KeyFile.get_string] to retrieve an unescaped UTF-8 string.
             *
             * If the key cannot be found, [error`GLib`.KeyFileError.KEY_NOT_FOUND]
             * is returned.  If the `group_name` cannot be found,
             * [error`GLib`.KeyFileError.GROUP_NOT_FOUND] is returned.
             * @param group_name a group name
             * @param key a key
             * @returns a newly allocated string or `NULL` if the specified  key cannot be found.
             */
            get_value(group_name: string, key: string): string;
            /**
             * Looks whether the key file has the group `group_name`.
             * @param group_name a group name
             * @returns true if @group_name is a part of @key_file, false otherwise.
             */
            has_group(group_name: string): boolean;
            /**
             * Loads a key file from the data in `bytes` into an empty [struct`GLib`.KeyFile]
             * structure.
             *
             * If the object cannot be created then a [error`GLib`.KeyFileError] is returned.
             * @param bytes a [struct@GLib.Bytes]
             * @param flags flags from [flags@GLib.KeyFileFlags]
             * @returns true if a key file could be loaded, false otherwise
             */
            load_from_bytes(bytes: Bytes | Uint8Array, flags: KeyFileFlags | null): boolean;
            /**
             * Loads a key file from memory into an empty [struct`GLib`.KeyFile] structure.
             *
             * If the object cannot be created then a [error`GLib`.KeyFileError is returned.
             * @param data key file loaded in memory
             * @param length the length of @data in bytes (or `(gsize)-1` if data is nul-terminated)
             * @param flags flags from [flags@GLib.KeyFileFlags]
             * @returns true if a key file could be loaded, false otherwise
             */
            load_from_data(data: string, length: number, flags: KeyFileFlags | null): boolean;
            /**
             * Looks for a key file named `file` in the paths returned from
             * [func`GLib`.get_user_data_dir] and [func`GLib`.get_system_data_dirs],
             * loads the file into `key_file` and returns the file’s full path in
             * `full_path`.
             *
             * If the file could not be loaded then either a [error`GLib`.FileError] or
             * [error`GLib`.KeyFileError] is returned.
             * @param file a relative path to a filename to open and parse
             * @param flags flags from [flags@GLib.KeyFileFlags]
             * @returns true if a key file could be loaded, false otherwise
             */
            load_from_data_dirs(file: string, flags: KeyFileFlags | null): [boolean, string];
            /**
             * Looks for a key file named `file` in the paths specified in `search_dirs,`
             * loads the file into `key_file` and returns the file’s full path in `full_path`.
             *
             * If the file could not be found in any of the `search_dirs,`
             * [error`GLib`.KeyFileError.NOT_FOUND] is returned. If
             * the file is found but the OS returns an error when opening or reading the
             * file, a [error`GLib`.FileError] is returned. If there is a problem parsing the
             * file, a [error`GLib`.KeyFileError] is returned.
             * @param file a relative path to a filename to open and parse
             * @param search_dirs `NULL`-terminated    array of directories to search
             * @param flags flags from [flags@GLib.KeyFileFlags]
             * @returns true if a key file could be loaded, false otherwise
             */
            load_from_dirs(file: string, search_dirs: string[], flags: KeyFileFlags | null): [boolean, string];
            /**
             * Loads a key file into an empty [struct`GLib`.KeyFile] structure.
             *
             * If the OS returns an error when opening or reading the file, a
             * [error`GLib`.FileError] is returned. If there is a problem parsing the file,
             * a [error`GLib`.KeyFileError] is returned.
             *
             * This function will never return a [error`GLib`.KeyFileError.NOT_FOUND]
             * error. If the `file` is not found, [error`GLib`.FileError.NOENT] is returned.
             * @param file the path of a filename to load, in the GLib filename encoding
             * @param flags flags from [flags@GLib.KeyFileFlags]
             * @returns true if a key file could be loaded, false otherwise
             */
            load_from_file(file: string, flags: KeyFileFlags | null): boolean;
            /**
             * Removes a comment above `key` from `group_name`.
             *
             * If `key` is `NULL` then `comment` will be removed above `group_name`.
             * If both `key` and `group_name` are `NULL`, then `comment` will
             * be removed above the first group in the file.
             * @param group_name a group name, or `NULL` to get a top-level comment
             * @param key a key, or `NULL` to get a group comment
             * @returns true if the comment was removed, false otherwise
             */
            remove_comment(group_name?: string | null, key?: string | null): boolean;
            /**
             * Removes the specified group, `group_name,`
             * from the key file.
             * @param group_name a group name
             * @returns true if the group was removed, false otherwise
             */
            remove_group(group_name: string): boolean;
            /**
             * Removes `key` in `group_name` from the key file.
             * @param group_name a group name
             * @param key a key name to remove
             * @returns true if the key was removed, false otherwise
             */
            remove_key(group_name: string, key: string): boolean;
            /**
             * Writes the contents of `key_file` to `filename` using
             * [func`GLib`.file_set_contents].
             *
             * If you need stricter guarantees about durability of
             * the written file than are provided by [func`GLib`.file_set_contents], use
             * [func`GLib`.file_set_contents_full] with the return value of
             * [method`GLib`.KeyFile.to_data].
             *
             * This function can fail for any of the reasons that
             * [func`GLib`.file_set_contents] may fail.
             * @param filename the name of the file to write to
             * @returns true if successful, false otherwise
             */
            save_to_file(filename: string): boolean;
            /**
             * Associates a new boolean value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param value true or false
             */
            set_boolean(group_name: string, key: string, value: boolean): void;
            /**
             * Associates a list of boolean values with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param list an array of boolean values
             */
            set_boolean_list(group_name: string, key: string, list: boolean[]): void;
            /**
             * Places a comment above `key` from `group_name`.
             *
             * If `key` is `NULL` then `comment` will be written above `group_name`.
             * If both `key` and `group_name` are `NULL`, then `comment` will be
             * written above the first group in the file.
             *
             * Note that this function prepends a `#` comment marker to
             * each line of `comment`.
             * @param group_name a group name, or `NULL` to write a top-level comment
             * @param key a key, or `NULL` to write a group comment
             * @param comment a comment
             * @returns true if the comment was written, false otherwise
             */
            set_comment(group_name: string | null, key: string | null, comment: string): boolean;
            /**
             * Associates a new double value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param value a double value
             */
            set_double(group_name: string, key: string, value: number): void;
            /**
             * Associates a list of double values with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param list an array of double values
             */
            set_double_list(group_name: string, key: string, list: number[]): void;
            /**
             * Associates a new integer value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param value an integer value
             */
            set_int64(group_name: string, key: string, value: number): void;
            /**
             * Associates a new integer value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param value an integer value
             */
            set_integer(group_name: string, key: string, value: number): void;
            /**
             * Associates a list of integer values with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param list an array of integer values
             */
            set_integer_list(group_name: string, key: string, list: number[]): void;
            /**
             * Sets the character which is used to separate values in lists.
             *
             * Typically `;` or `,` are used as separators. The default list separator
             * is `;`.
             * @param separator the separator
             */
            set_list_separator(separator: number): void;
            /**
             * Associates a string value for `key` and `locale` under `group_name`.
             *
             * If the translation for `key` cannot be found then it is created.
             *
             * If `locale` is `C` then the untranslated value is set (since GLib 2.84).
             * @param group_name a group name
             * @param key a key
             * @param locale a locale identifier
             * @param string a string
             */
            set_locale_string(group_name: string, key: string, locale: string, string: string): void;
            /**
             * Associates a list of string values for `key` and `locale` under
             * `group_name`.
             *
             * If `locale` is `C` then the untranslated value is set (since GLib 2.84).
             *
             * If the translation for `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param locale a locale identifier
             * @param list a `NULL`-terminated array of    locale string values
             */
            set_locale_string_list(group_name: string, key: string, locale: string, list: string[]): void;
            /**
             * Associates a new string value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * If `group_name` cannot be found then it is created.
             * Unlike [method`GLib`.KeyFile.set_value], this function handles characters
             * that need escaping, such as newlines.
             * @param group_name a group name
             * @param key a key
             * @param string a string
             */
            set_string(group_name: string, key: string, string: string): void;
            /**
             * Associates a list of string values for `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * If `group_name` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param list an array    of string values
             */
            set_string_list(group_name: string, key: string, list: string[]): void;
            /**
             * Associates a new integer value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created.
             * @param group_name a group name
             * @param key a key
             * @param value an integer value
             */
            set_uint64(group_name: string, key: string, value: number): void;
            /**
             * Associates a new value with `key` under `group_name`.
             *
             * If `key` cannot be found then it is created. If `group_name` cannot
             * be found then it is created. To set an UTF-8 string which may contain
             * characters that need escaping (such as newlines or spaces), use
             * [method`GLib`.KeyFile.set_string].
             * @param group_name a group name
             * @param key a key
             * @param value a string
             */
            set_value(group_name: string, key: string, value: string): void;
            /**
             * Outputs `key_file` as a string.
             *
             * Note that this function never reports an error.
             * @returns a newly allocated string holding the contents of the key file
             */
            to_data(): [string, number];
            /**
             * Decreases the reference count of `key_file` by 1.
             *
             * If the reference count reaches zero, frees the key file and all its allocated
             * memory.
             */
            unref(): void;
        }

        /**
         * The #GList struct is used for each element in a doubly-linked list.
         */
        class List {
            static $gtype: GObject.GType<List>;

            // Fields

            data: any;
            next: any[];
            prev: any[];

            // Constructors

            constructor(
                properties?: Partial<{
                    data: any;
                }>,
            );
            _init(...args: any[]): void;

            // Static methods

            static pop_allocator(): void;
            static push_allocator(allocator: Allocator): void;
        }

        /**
         * Structure representing a single field in a structured log entry. See
         * g_log_structured() for details.
         *
         * Log fields may contain arbitrary values, including binary with embedded nul
         * bytes. If the field contains a string, the string must be UTF-8 encoded and
         * have a trailing nul byte. Otherwise, `length` must be set to a non-negative
         * value.
         */
        class LogField {
            static $gtype: GObject.GType<LogField>;

            // Fields

            key: string;
            value: any;
            length: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    key: string;
                    value: any;
                    length: number;
                }>,
            );
            _init(...args: any[]): void;
        }

        /**
         * The `GMainContext` struct is an opaque data
         * type representing a set of sources to be handled in a main loop.
         */
        class MainContext {
            static $gtype: GObject.GType<MainContext>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            static ['new'](): MainContext;

            static new_with_flags(flags: MainContextFlags): MainContext;

            // Static methods

            /**
             * Returns the global-default main context. This is the main context
             * used for main loop functions when a main loop is not explicitly
             * specified, and corresponds to the "main" main loop. See also
             * [func`GLib`.MainContext.get_thread_default].
             */
            static ['default'](): MainContext;
            /**
             * Gets the thread-default #GMainContext for this thread. Asynchronous
             * operations that want to be able to be run in contexts other than
             * the default one should call this method or
             * [func`GLib`.MainContext.ref_thread_default] to get a
             * [struct`GLib`.MainContext] to add their [struct`GLib`.Source]s to. (Note that
             * even in single-threaded programs applications may sometimes want to
             * temporarily push a non-default context, so it is not safe to assume that
             * this will always return %NULL if you are running in the default thread.)
             *
             * If you need to hold a reference on the context, use
             * [func`GLib`.MainContext.ref_thread_default] instead.
             */
            static get_thread_default(): MainContext | null;
            /**
             * Gets the thread-default [struct`GLib`.MainContext] for this thread, as with
             * [func`GLib`.MainContext.get_thread_default], but also adds a reference to
             * it with [method`GLib`.MainContext.ref]. In addition, unlike
             * [func`GLib`.MainContext.get_thread_default], if the thread-default context
             * is the global-default context, this will return that
             * [struct`GLib`.MainContext] (with a ref added to it) rather than returning
             * %NULL.
             */
            static ref_thread_default(): MainContext;

            // Methods

            /**
             * Tries to become the owner of the specified context.
             * If some other thread is the owner of the context,
             * returns %FALSE immediately. Ownership is properly
             * recursive: the owner can require ownership again
             * and will release ownership when [method`GLib`.MainContext.release]
             * is called as many times as [method`GLib`.MainContext.acquire].
             *
             * You must be the owner of a context before you
             * can call [method`GLib`.MainContext.prepare], [method`GLib`.MainContext.query],
             * [method`GLib`.MainContext.check], [method`GLib`.MainContext.dispatch],
             * [method`GLib`.MainContext.release].
             *
             * Since 2.76 `context` can be %NULL to use the global-default
             * main context.
             * @returns %TRUE if the operation succeeded, and   this thread is now the owner of @context.
             */
            acquire(): boolean;
            /**
             * Adds a file descriptor to the set of file descriptors polled for
             * this context. This will very seldom be used directly. Instead
             * a typical event source will use `g_source_add_unix_fd` instead.
             * @param fd a #GPollFD structure holding information about a file      descriptor to watch.
             * @param priority the priority for this file descriptor which should be      the same as the priority used for [method@GLib.Source.attach] to ensure      that the file descriptor is polled whenever the results may be needed.
             */
            add_poll(fd: PollFD, priority: number): void;
            /**
             * Passes the results of polling back to the main loop. You should be
             * careful to pass `fds` and its length `n_fds` as received from
             * [method`GLib`.MainContext.query], as this functions relies on assumptions
             * on how `fds` is filled.
             *
             * You must have successfully acquired the context with
             * [method`GLib`.MainContext.acquire] before you may call this function.
             *
             * Since 2.76 `context` can be %NULL to use the global-default
             * main context.
             * @param max_priority the maximum numerical priority of sources to check
             * @param fds array of #GPollFD's that was passed to       the last call to [method@GLib.MainContext.query]
             * @returns %TRUE if some sources are ready to be dispatched.
             */
            check(max_priority: number, fds: PollFD[]): boolean;
            /**
             * Dispatches all pending sources.
             *
             * You must have successfully acquired the context with
             * [method`GLib`.MainContext.acquire] before you may call this function.
             *
             * Since 2.76 `context` can be %NULL to use the global-default
             * main context.
             */
            dispatch(): void;
            /**
             * Finds a source with the given source functions and user data.  If
             * multiple sources exist with the same source function and user data,
             * the first one found will be returned.
             * @param funcs the @source_funcs passed to [ctor@GLib.Source.new].
             * @param user_data the user data from the callback.
             * @returns the source, if one was found, otherwise %NULL
             */
            find_source_by_funcs_user_data(funcs: SourceFuncs, user_data?: any | null): Source;
            /**
             * Finds a #GSource given a pair of context and ID.
             *
             * It is a programmer error to attempt to look up a non-existent source.
             *
             * More specifically: source IDs can be reissued after a source has been
             * destroyed and therefore it is never valid to use this function with a
             * source ID which may have already been removed.  An example is when
             * scheduling an idle to run in another thread with [func`GLib`.idle_add]: the
             * idle may already have run and been removed by the time this function
             * is called on its (now invalid) source ID.  This source ID may have
             * been reissued, leading to the operation being performed against the
             * wrong source.
             * @param source_id the source ID, as returned by [method@GLib.Source.get_id].
             * @returns the #GSource
             */
            find_source_by_id(source_id: number): Source;
            /**
             * Finds a source with the given user data for the callback.  If
             * multiple sources exist with the same user data, the first
             * one found will be returned.
             * @param user_data the user_data for the callback.
             * @returns the source, if one was found, otherwise %NULL
             */
            find_source_by_user_data(user_data?: any | null): Source;
            /**
             * Invokes a function in such a way that `context` is owned during the
             * invocation of `function`.
             *
             * This function is the same as [method`GLib`.MainContext.invoke] except that it
             * lets you specify the priority in case `function` ends up being
             * scheduled as an idle and also lets you give a #GDestroyNotify for `data`.
             *
             * `notify` should not assume that it is called from any particular
             * thread or with any particular context acquired.
             * @param priority the priority at which to run @function
             * @param _function function to call
             * @param notify a function to call when @data is no longer in use, or %NULL.
             */
            invoke_full(priority: number, _function: SourceFunc, notify?: DestroyNotify | null): void;
            /**
             * Determines whether this thread holds the (recursive)
             * ownership of this [struct`GLib`.MainContext]. This is useful to
             * know before waiting on another thread that may be
             * blocking to get ownership of `context`.
             * @returns %TRUE if current thread is owner of @context.
             */
            is_owner(): boolean;
            /**
             * Runs a single iteration for the given main loop. This involves
             * checking to see if any event sources are ready to be processed,
             * then if no events sources are ready and `may_block` is %TRUE, waiting
             * for a source to become ready, then dispatching the highest priority
             * events sources that are ready. Otherwise, if `may_block` is %FALSE
             * sources are not waited to become ready, only those highest priority
             * events sources will be dispatched (if any), that are ready at this
             * given moment without further waiting.
             *
             * Note that even when `may_block` is %TRUE, it is still possible for
             * [method`GLib`.MainContext.iteration] to return %FALSE, since the wait may
             * be interrupted for other reasons than an event source becoming ready.
             * @param may_block whether the call may block.
             * @returns %TRUE if events were dispatched.
             */
            iteration(may_block: boolean): boolean;
            /**
             * Checks if any sources have pending events for the given context.
             * @returns %TRUE if events are pending.
             */
            pending(): boolean;
            /**
             * Pops `context` off the thread-default context stack (verifying that
             * it was on the top of the stack).
             */
            pop_thread_default(): void;
            /**
             * Prepares to poll sources within a main loop. The resulting information
             * for polling is determined by calling [method`GLib`.MainContext.query].
             *
             * You must have successfully acquired the context with
             * [method`GLib`.MainContext.acquire] before you may call this function.
             * @returns %TRUE if some source is ready to be dispatched               prior to polling.
             */
            prepare(): [boolean, number];
            /**
             * Acquires `context` and sets it as the thread-default context for the
             * current thread. This will cause certain asynchronous operations
             * (such as most [Gio](../gio/index.html)-based I/O) which are
             * started in this thread to run under `context` and deliver their
             * results to its main loop, rather than running under the global
             * default main context in the main thread. Note that calling this function
             * changes the context returned by [func`GLib`.MainContext.get_thread_default],
             * not the one returned by [func`GLib`.MainContext.default], so it does not
             * affect the context used by functions like [func`GLib`.idle_add].
             *
             * Normally you would call this function shortly after creating a new
             * thread, passing it a [struct`GLib`.MainContext] which will be run by a
             * [struct`GLib`.MainLoop] in that thread, to set a new default context for all
             * async operations in that thread. In this case you may not need to
             * ever call [method`GLib`.MainContext.pop_thread_default], assuming you want
             * the new [struct`GLib`.MainContext] to be the default for the whole lifecycle
             * of the thread.
             *
             * If you don't have control over how the new thread was created (e.g.
             * in the new thread isn't newly created, or if the thread life
             * cycle is managed by a #GThreadPool), it is always suggested to wrap
             * the logic that needs to use the new [struct`GLib`.MainContext] inside a
             * [method`GLib`.MainContext.push_thread_default] /
             * [method`GLib`.MainContext.pop_thread_default] pair, otherwise threads that
             * are re-used will end up never explicitly releasing the
             * [struct`GLib`.MainContext] reference they hold.
             *
             * In some cases you may want to schedule a single operation in a
             * non-default context, or temporarily use a non-default context in
             * the main thread. In that case, you can wrap the call to the
             * asynchronous operation inside a
             * [method`GLib`.MainContext.push_thread_default] /
             * [method`GLib`.MainContext.pop_thread_default] pair, but it is up to you to
             * ensure that no other asynchronous operations accidentally get
             * started while the non-default context is active.
             *
             * Beware that libraries that predate this function may not correctly
             * handle being used from a thread with a thread-default context. Eg,
             * see g_file_supports_thread_contexts().
             */
            push_thread_default(): void;
            /**
             * Push `main_context` as the new thread-default main context for the current
             * thread, using [method`GLib`.MainContext.push_thread_default], and return a
             * new [alias`GLib`.MainContextPusher]. Pop with g_main_context_pusher_free().
             * Using [method`GLib`.MainContext.pop_thread_default] on `main_context` while a
             * [alias`GLib`.MainContextPusher] exists for it can lead to undefined behaviour.
             *
             * Using two [alias`GLib`.MainContextPusher]s in the same scope is not allowed,
             * as it leads to an undefined pop order.
             *
             * This is intended to be used with g_autoptr().  Note that g_autoptr()
             * is only available when using GCC or clang, so the following example
             * will only work with those compilers:
             *
             * ```
             * typedef struct
             * {
             *   ...
             *   GMainContext *context;
             *   ...
             * } MyObject;
             *
             * static void
             * my_object_do_stuff (MyObject *self)
             * {
             *   g_autoptr(GMainContextPusher) pusher = g_main_context_pusher_new (self->context);
             *
             *   // Code with main context as the thread default here
             *
             *   if (cond)
             *     // No need to pop
             *     return;
             *
             *   // Optionally early pop
             *   g_clear_pointer (&pusher, g_main_context_pusher_free);
             *
             *   // Code with main context no longer the thread default here
             * }
             * ```
             *
             * @returns a #GMainContextPusher
             */
            pusher_new(): MainContextPusher;
            /**
             * Determines information necessary to poll this main loop. You should
             * be careful to pass the resulting `fds` array and its length `n_fds`
             * as is when calling [method`GLib`.MainContext.check], as this function relies
             * on assumptions made when the array is filled.
             *
             * You must have successfully acquired the context with
             * [method`GLib`.MainContext.acquire] before you may call this function.
             * @param max_priority maximum priority source to check
             * @returns the number of records actually stored in @fds,   or, if more than @n_fds records need to be stored, the number   of records that need to be stored.
             */
            query(max_priority: number): [number, number, PollFD[]];
            /**
             * Increases the reference count on a [struct`GLib`.MainContext] object by one.
             * @returns the @context that was passed in (since 2.6)
             */
            ref(): MainContext;
            /**
             * Releases ownership of a context previously acquired by this thread
             * with [method`GLib`.MainContext.acquire]. If the context was acquired multiple
             * times, the ownership will be released only when [method`GLib`.MainContext.release]
             * is called as many times as it was acquired.
             *
             * You must have successfully acquired the context with
             * [method`GLib`.MainContext.acquire] before you may call this function.
             */
            release(): void;
            /**
             * Removes file descriptor from the set of file descriptors to be
             * polled for a particular context.
             * @param fd a #GPollFD descriptor previously added with   [method@GLib.MainContext.add_poll]
             */
            remove_poll(fd: PollFD): void;
            /**
             * Decreases the reference count on a [struct`GLib`.MainContext] object by one.
             * If
             * the result is zero, free the context and free all associated memory.
             */
            unref(): void;
            /**
             * Tries to become the owner of the specified context,
             * as with [method`GLib`.MainContext.acquire]. But if another thread
             * is the owner, atomically drop `mutex` and wait on `cond` until
             * that owner releases ownership or until `cond` is signaled, then
             * try again (once) to become the owner.
             * @param cond a condition variable
             * @param mutex a mutex, currently held
             * @returns %TRUE if the operation succeeded, and   this thread is now the owner of @context.
             */
            wait(cond: Cond, mutex: Mutex): boolean;
            /**
             * If `context` is currently blocking in [method`GLib`.MainContext.iteration]
             * waiting for a source to become ready, cause it to stop blocking
             * and return.  Otherwise, cause the next invocation of
             * [method`GLib`.MainContext.iteration] to return without blocking.
             *
             * This API is useful for low-level control over [struct`GLib`.MainContext]; for
             * example, integrating it with main loop implementations such as
             * [struct`GLib`.MainLoop].
             *
             * Another related use for this function is when implementing a main
             * loop with a termination condition, computed from multiple threads:
             *
             *
             * ```c
             *   #define NUM_TASKS 10
             *   static gint tasks_remaining = NUM_TASKS;  // (atomic)
             *   ...
             *
             *   while (g_atomic_int_get (&tasks_remaining) != 0)
             *     g_main_context_iteration (NULL, TRUE);
             * ```
             *
             *
             * Then in a thread:
             *
             * ```c
             *   perform_work();
             *
             *   if (g_atomic_int_dec_and_test (&tasks_remaining))
             *     g_main_context_wakeup (NULL);
             * ```
             *
             */
            wakeup(): void;
        }

        /**
         * The `GMainLoop` struct is an opaque data type
         * representing the main event loop of a GLib or GTK application.
         */
        class MainLoop {
            static $gtype: GObject.GType<MainLoop>;

            // Constructors

            constructor(context: MainContext | null, is_running: boolean);
            _init(...args: any[]): void;

            static ['new'](context: MainContext | null, is_running: boolean): MainLoop;

            // Methods

            /**
             * Returns the [struct`GLib`.MainContext] of `loop`.
             * @returns the [struct@GLib.MainContext] of @loop
             */
            get_context(): MainContext;
            /**
             * Checks to see if the main loop is currently being run via
             * [method`GLib`.MainLoop.run].
             * @returns %TRUE if the mainloop is currently being run.
             */
            is_running(): boolean;
            /**
             * Stops a [struct`GLib`.MainLoop] from running. Any calls to
             * [method`GLib`.MainLoop.run] for the loop will return.
             *
             * Note that sources that have already been dispatched when
             * [method`GLib`.MainLoop.quit] is called will still be executed.
             */
            quit(): void;
            /**
             * Increases the reference count on a [struct`GLib`.MainLoop] object by one.
             * @returns @loop
             */
            ref(): MainLoop;
            /**
             * Runs a main loop until [method`GLib`.MainLoop.quit] is called on the loop.
             * If this is called for the thread of the loop's #GMainContext,
             * it will process events from the loop, otherwise it will
             * simply wait.
             */
            run(): void;
            /**
             * Decreases the reference count on a [struct`GLib`.MainLoop] object by one. If
             * the result is zero, free the loop and free all associated memory.
             */
            unref(): void;
            /**
             * Similar to `GLib.MainLoop.run` but return a Promise which resolves when the main loop ends, instead of blocking while the main loop runs.
             * This helps avoid the situation where Promises never resolved if you didn't run the main loop inside a callback.
             */
            runAsync(): Promise<void>;
        }

        /**
         * The #GMappedFile represents a file mapping created with
         * g_mapped_file_new(). It has only private members and should
         * not be accessed directly.
         */
        class MappedFile {
            static $gtype: GObject.GType<MappedFile>;

            // Constructors

            constructor(filename: string, writable: boolean);
            _init(...args: any[]): void;

            static ['new'](filename: string, writable: boolean): MappedFile;

            static new_from_fd(fd: number, writable: boolean): MappedFile;

            // Methods

            /**
             * This call existed before #GMappedFile had refcounting and is currently
             * exactly the same as g_mapped_file_unref().
             */
            free(): void;
            /**
             * Creates a new #GBytes which references the data mapped from `file`.
             * The mapped contents of the file must not be modified after creating this
             * bytes object, because a #GBytes should be immutable.
             * @returns A newly allocated #GBytes referencing data     from @file
             */
            get_bytes(): Bytes;
            /**
             * Returns the contents of a #GMappedFile.
             *
             * Note that the contents may not be zero-terminated,
             * even if the #GMappedFile is backed by a text file.
             *
             * If the file is empty then %NULL is returned.
             * @returns the contents of @file, or %NULL.
             */
            get_contents(): string | null;
            /**
             * Returns the length of the contents of a #GMappedFile.
             * @returns the length of the contents of @file.
             */
            get_length(): number;
            /**
             * Increments the reference count of `file` by one.  It is safe to call
             * this function from any thread.
             * @returns the passed in #GMappedFile.
             */
            ref(): MappedFile;
            /**
             * Decrements the reference count of `file` by one.  If the reference count
             * drops to 0, unmaps the buffer of `file` and frees it.
             *
             * It is safe to call this function from any thread.
             *
             * Since 2.22
             */
            unref(): void;
        }

        /**
         * A parse context is used to parse a stream of bytes that
         * you expect to contain marked-up text.
         *
         * See g_markup_parse_context_new(), #GMarkupParser, and so
         * on for more details.
         */
        class MarkupParseContext {
            static $gtype: GObject.GType<MarkupParseContext>;

            // Constructors

            constructor(parser: MarkupParser, flags: MarkupParseFlags, user_data?: any | null);
            _init(...args: any[]): void;

            static ['new'](parser: MarkupParser, flags: MarkupParseFlags, user_data?: any | null): MarkupParseContext;

            // Methods

            /**
             * Signals to the #GMarkupParseContext that all data has been
             * fed into the parse context with g_markup_parse_context_parse().
             *
             * This function reports an error if the document isn't complete,
             * for example if elements are still open.
             * @returns %TRUE on success, %FALSE if an error was set
             */
            end_parse(): boolean;
            /**
             * Frees a #GMarkupParseContext.
             *
             * This function can't be called from inside one of the
             * #GMarkupParser functions or while a subparser is pushed.
             */
            free(): void;
            /**
             * Retrieves the name of the currently open element.
             *
             * If called from the start_element or end_element handlers this will
             * give the element_name as passed to those functions. For the parent
             * elements, see g_markup_parse_context_get_element_stack().
             * @returns the name of the currently open element, or %NULL
             */
            get_element(): string;
            /**
             * Retrieves the element stack from the internal state of the parser.
             *
             * The returned #GSList is a list of strings where the first item is
             * the currently open tag (as would be returned by
             * g_markup_parse_context_get_element()) and the next item is its
             * immediate parent.
             *
             * This function is intended to be used in the start_element and
             * end_element handlers where g_markup_parse_context_get_element()
             * would merely return the name of the element that is being
             * processed.
             * @returns the element stack, which must not be modified
             */
            get_element_stack(): string[];
            /**
             * Retrieves the current line number and the number of the character on
             * that line. Intended for use in error messages; there are no strict
             * semantics for what constitutes the "current" line number other than
             * "the best number we could come up with for error messages."
             */
            get_position(): [number, number];
            /**
             * Returns the user_data associated with `context`.
             *
             * This will either be the user_data that was provided to
             * g_markup_parse_context_new() or to the most recent call
             * of g_markup_parse_context_push().
             * @returns the provided user_data. The returned data belongs to     the markup context and will be freed when     g_markup_parse_context_free() is called.
             */
            get_user_data(): any | null;
            /**
             * Feed some data to the #GMarkupParseContext.
             *
             * The data need not be valid UTF-8; an error will be signaled if
             * it's invalid. The data need not be an entire document; you can
             * feed a document into the parser incrementally, via multiple calls
             * to this function. Typically, as you receive data from a network
             * connection or file, you feed each received chunk of data into this
             * function, aborting the process if an error occurs. Once an error
             * is reported, no further data may be fed to the #GMarkupParseContext;
             * all errors are fatal.
             * @param text chunk of text to parse
             * @param text_len length of @text in bytes
             * @returns %FALSE if an error occurred, %TRUE on success
             */
            parse(text: string, text_len: number): boolean;
            /**
             * Completes the process of a temporary sub-parser redirection.
             *
             * This function exists to collect the user_data allocated by a
             * matching call to g_markup_parse_context_push(). It must be called
             * in the end_element handler corresponding to the start_element
             * handler during which g_markup_parse_context_push() was called.
             * You must not call this function from the error callback -- the
             * `user_data` is provided directly to the callback in that case.
             *
             * This function is not intended to be directly called by users
             * interested in invoking subparsers. Instead, it is intended to
             * be used by the subparsers themselves to implement a higher-level
             * interface.
             * @returns the user data passed to g_markup_parse_context_push()
             */
            pop(): any | null;
            /**
             * Temporarily redirects markup data to a sub-parser.
             *
             * This function may only be called from the start_element handler of
             * a #GMarkupParser. It must be matched with a corresponding call to
             * g_markup_parse_context_pop() in the matching end_element handler
             * (except in the case that the parser aborts due to an error).
             *
             * All tags, text and other data between the matching tags is
             * redirected to the subparser given by `parser`. `user_data` is used
             * as the user_data for that parser. `user_data` is also passed to the
             * error callback in the event that an error occurs. This includes
             * errors that occur in subparsers of the subparser.
             *
             * The end tag matching the start tag for which this call was made is
             * handled by the previous parser (which is given its own user_data)
             * which is why g_markup_parse_context_pop() is provided to allow "one
             * last access" to the `user_data` provided to this function. In the
             * case of error, the `user_data` provided here is passed directly to
             * the error callback of the subparser and g_markup_parse_context_pop()
             * should not be called. In either case, if `user_data` was allocated
             * then it ought to be freed from both of these locations.
             *
             * This function is not intended to be directly called by users
             * interested in invoking subparsers. Instead, it is intended to be
             * used by the subparsers themselves to implement a higher-level
             * interface.
             *
             * As an example, see the following implementation of a simple
             * parser that counts the number of tags encountered.
             *
             *
             * ```c
             * typedef struct
             * {
             *   gint tag_count;
             * } CounterData;
             *
             * static void
             * counter_start_element (GMarkupParseContext  *context,
             *                        const gchar          *element_name,
             *                        const gchar         **attribute_names,
             *                        const gchar         **attribute_values,
             *                        gpointer              user_data,
             *                        GError              **error)
             * {
             *   CounterData *data = user_data;
             *
             *   data->tag_count++;
             * }
             *
             * static void
             * counter_error (GMarkupParseContext *context,
             *                GError              *error,
             *                gpointer             user_data)
             * {
             *   CounterData *data = user_data;
             *
             *   g_slice_free (CounterData, data);
             * }
             *
             * static GMarkupParser counter_subparser =
             * {
             *   counter_start_element,
             *   NULL,
             *   NULL,
             *   NULL,
             *   counter_error
             * };
             * ```
             *
             *
             * In order to allow this parser to be easily used as a subparser, the
             * following interface is provided:
             *
             *
             * ```c
             * void
             * start_counting (GMarkupParseContext *context)
             * {
             *   CounterData *data = g_slice_new (CounterData);
             *
             *   data->tag_count = 0;
             *   g_markup_parse_context_push (context, &counter_subparser, data);
             * }
             *
             * gint
             * end_counting (GMarkupParseContext *context)
             * {
             *   CounterData *data = g_markup_parse_context_pop (context);
             *   int result;
             *
             *   result = data->tag_count;
             *   g_slice_free (CounterData, data);
             *
             *   return result;
             * }
             * ```
             *
             *
             * The subparser would then be used as follows:
             *
             *
             * ```c
             * static void start_element (context, element_name, ...)
             * {
             *   if (strcmp (element_name, "count-these") == 0)
             *     start_counting (context);
             *
             *   // else, handle other tags...
             * }
             *
             * static void end_element (context, element_name, ...)
             * {
             *   if (strcmp (element_name, "count-these") == 0)
             *     g_print ("Counted %d tags\n", end_counting (context));
             *
             *   // else, handle other tags...
             * }
             * ```
             *
             * @param parser a #GMarkupParser
             * @param user_data user data to pass to #GMarkupParser functions
             */
            push(parser: MarkupParser, user_data?: any | null): void;
            /**
             * Increases the reference count of `context`.
             * @returns the same @context
             */
            ref(): MarkupParseContext;
            /**
             * Decreases the reference count of `context`.  When its reference count
             * drops to 0, it is freed.
             */
            unref(): void;
        }

        /**
         * Any of the fields in #GMarkupParser can be %NULL, in which case they
         * will be ignored. Except for the `error` function, any of these callbacks
         * can set an error; in particular the %G_MARKUP_ERROR_UNKNOWN_ELEMENT,
         * %G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, and %G_MARKUP_ERROR_INVALID_CONTENT
         * errors are intended to be set from these callbacks. If you set an error
         * from a callback, g_markup_parse_context_parse() will report that error
         * back to its caller.
         */
        class MarkupParser {
            static $gtype: GObject.GType<MarkupParser>;

            // Constructors

            _init(...args: any[]): void;
        }

        /**
         * A GMatchInfo is an opaque struct used to return information about
         * matches.
         */
        abstract class MatchInfo {
            static $gtype: GObject.GType<MatchInfo>;

            // Constructors

            _init(...args: any[]): void;

            // Methods

            /**
             * Returns a new string containing the text in `string_to_expand` with
             * references and escape sequences expanded. References refer to the last
             * match done with `string` against `regex` and have the same syntax used by
             * g_regex_replace().
             *
             * The `string_to_expand` must be UTF-8 encoded even if %G_REGEX_RAW was
             * passed to g_regex_new().
             *
             * The backreferences are extracted from the string passed to the match
             * function, so you cannot call this function after freeing the string.
             *
             * `match_info` may be %NULL in which case `string_to_expand` must not
             * contain references. For instance "foo\n" does not refer to an actual
             * pattern and '\n' merely will be replaced with \n character,
             * while to expand "\0" (whole match) one needs the result of a match.
             * Use g_regex_check_replacement() to find out whether `string_to_expand`
             * contains references.
             * @param string_to_expand the string to expand
             * @returns the expanded string, or %NULL if an error occurred
             */
            expand_references(string_to_expand: string): string | null;
            /**
             * Retrieves the text matching the `match_num'`th capturing
             * parentheses. 0 is the full text of the match, 1 is the first paren
             * set, 2 the second, and so on.
             *
             * If `match_num` is a valid sub pattern but it didn't match anything
             * (e.g. sub pattern 1, matching "b" against "(a)?b") then an empty
             * string is returned.
             *
             * If the match was obtained using the DFA algorithm, that is using
             * g_regex_match_all() or g_regex_match_all_full(), the retrieved
             * string is not that of a set of parentheses but that of a matched
             * substring. Substrings are matched in reverse order of length, so
             * 0 is the longest match.
             *
             * The string is fetched from the string passed to the match function,
             * so you cannot call this function after freeing the string.
             * @param match_num number of the sub expression
             * @returns The matched substring, or %NULL if an error     occurred. You have to free the string yourself
             */
            fetch(match_num: number): string | null;
            /**
             * Bundles up pointers to each of the matching substrings from a match
             * and stores them in an array of gchar pointers. The first element in
             * the returned array is the match number 0, i.e. the entire matched
             * text.
             *
             * If a sub pattern didn't match anything (e.g. sub pattern 1, matching
             * "b" against "(a)?b") then an empty string is inserted.
             *
             * If the last match was obtained using the DFA algorithm, that is using
             * g_regex_match_all() or g_regex_match_all_full(), the retrieved
             * strings are not that matched by sets of parentheses but that of the
             * matched substring. Substrings are matched in reverse order of length,
             * so the first one is the longest match.
             *
             * The strings are fetched from the string passed to the match function,
             * so you cannot call this function after freeing the string.
             * @returns a %NULL-terminated array of gchar *     pointers.  It must be freed using g_strfreev(). If the previous     match failed %NULL is returned
             */
            fetch_all(): string[];
            /**
             * Retrieves the text matching the capturing parentheses named `name`.
             *
             * If `name` is a valid sub pattern name but it didn't match anything
             * (e.g. sub pattern `"X"`, matching `"b"` against `"(?P<X>a)?b"`)
             * then an empty string is returned.
             *
             * The string is fetched from the string passed to the match function,
             * so you cannot call this function after freeing the string.
             * @param name name of the subexpression
             * @returns The matched substring, or %NULL if an error     occurred. You have to free the string yourself
             */
            fetch_named(name: string): string | null;
            /**
             * Retrieves the position in bytes of the capturing parentheses named `name`.
             *
             * If `name` is a valid sub pattern name but it didn't match anything
             * (e.g. sub pattern `"X"`, matching `"b"` against `"(?P<X>a)?b"`)
             * then `start_pos` and `end_pos` are set to -1 and %TRUE is returned.
             * @param name name of the subexpression
             * @returns %TRUE if the position was fetched, %FALSE otherwise.     If the position cannot be fetched, @start_pos and @end_pos     are left unchanged.
             */
            fetch_named_pos(name: string): [boolean, number, number];
            /**
             * Retrieves the position in bytes of the `match_num'`th capturing
             * parentheses. 0 is the full text of the match, 1 is the first
             * paren set, 2 the second, and so on.
             *
             * If `match_num` is a valid sub pattern but it didn't match anything
             * (e.g. sub pattern 1, matching "b" against "(a)?b") then `start_pos`
             * and `end_pos` are set to -1 and %TRUE is returned.
             *
             * If the match was obtained using the DFA algorithm, that is using
             * g_regex_match_all() or g_regex_match_all_full(), the retrieved
             * position is not that of a set of parentheses but that of a matched
             * substring. Substrings are matched in reverse order of length, so
             * 0 is the longest match.
             * @param match_num number of the sub expression
             * @returns %TRUE if the position was fetched, %FALSE otherwise. If   the position cannot be fetched, @start_pos and @end_pos are left   unchanged
             */
            fetch_pos(match_num: number): [boolean, number, number];
            /**
             * If `match_info` is not %NULL, calls g_match_info_unref(); otherwise does
             * nothing.
             */
            free(): void;
            /**
             * Retrieves the number of matched substrings (including substring 0,
             * that is the whole matched text), so 1 is returned if the pattern
             * has no substrings in it and 0 is returned if the match failed.
             *
             * If the last match was obtained using the DFA algorithm, that is
             * using g_regex_match_all() or g_regex_match_all_full(), the retrieved
             * count is not that of the number of capturing parentheses but that of
             * the number of matched substrings.
             * @returns Number of matched substrings, or -1 if an error occurred
             */
            get_match_count(): number;
            /**
             * Returns #GRegex object used in `match_info`. It belongs to Glib
             * and must not be freed. Use g_regex_ref() if you need to keep it
             * after you free `match_info` object.
             * @returns #GRegex object used in @match_info
             */
            get_regex(): Regex;
            /**
             * Returns the string searched with `match_info`. This is the
             * string passed to g_regex_match() or g_regex_replace() so
             * you may not free it before calling this function.
             * @returns the string searched with @match_info
             */
            get_string(): string;
            /**
             * Usually if the string passed to g_regex_match*() matches as far as
             * it goes, but is too short to match the entire pattern, %FALSE is
             * returned. There are circumstances where it might be helpful to
             * distinguish this case from other cases in which there is no match.
             *
             * Consider, for example, an application where a human is required to
             * type in data for a field with specific formatting requirements. An
             * example might be a date in the form ddmmmyy, defined by the pattern
             * "^\d?\d(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\d\d$".
             * If the application sees the user’s keystrokes one by one, and can
             * check that what has been typed so far is potentially valid, it is
             * able to raise an error as soon as a mistake is made.
             *
             * GRegex supports the concept of partial matching by means of the
             * %G_REGEX_MATCH_PARTIAL_SOFT and %G_REGEX_MATCH_PARTIAL_HARD flags.
             * When they are used, the return code for
             * g_regex_match() or g_regex_match_full() is, as usual, %TRUE
             * for a complete match, %FALSE otherwise. But, when these functions
             * return %FALSE, you can check if the match was partial calling
             * g_match_info_is_partial_match().
             *
             * The difference between %G_REGEX_MATCH_PARTIAL_SOFT and
             * %G_REGEX_MATCH_PARTIAL_HARD is that when a partial match is encountered
             * with %G_REGEX_MATCH_PARTIAL_SOFT, matching continues to search for a
             * possible complete match, while with %G_REGEX_MATCH_PARTIAL_HARD matching
             * stops at the partial match.
             * When both %G_REGEX_MATCH_PARTIAL_SOFT and %G_REGEX_MATCH_PARTIAL_HARD
             * are set, the latter takes precedence.
             *
             * There were formerly some restrictions on the pattern for partial matching.
             * The restrictions no longer apply.
             *
             * See pcrepartial(3) for more information on partial matching.
             * @returns %TRUE if the match was partial, %FALSE otherwise
             */
            is_partial_match(): boolean;
            /**
             * Returns whether the previous match operation succeeded.
             * @returns %TRUE if the previous match operation succeeded,   %FALSE otherwise
             */
            matches(): boolean;
            /**
             * Scans for the next match using the same parameters of the previous
             * call to g_regex_match_full() or g_regex_match() that returned
             * `match_info`.
             *
             * The match is done on the string passed to the match function, so you
             * cannot free it before calling this function.
             * @returns %TRUE is the string matched, %FALSE otherwise
             */
            next(): boolean;
            /**
             * Increases reference count of `match_info` by 1.
             * @returns @match_info
             */
            ref(): MatchInfo;
            /**
             * Decreases reference count of `match_info` by 1. When reference count drops
             * to zero, it frees all the memory associated with the match_info structure.
             */
            unref(): void;
        }

        abstract class MemChunk {
            static $gtype: GObject.GType<MemChunk>;

            // Constructors

            _init(...args: any[]): void;

            // Static methods

            static info(): void;

            // Methods

            alloc(): any | null;
            alloc0(): any | null;
            clean(): void;
            destroy(): void;
            free(mem?: any | null): void;
            print(): void;
            reset(): void;
        }

        /**
         * A set of functions used to perform memory allocation. The same #GMemVTable must
         * be used for all allocations in the same program; a call to g_mem_set_vtable(),
         * if it exists, should be prior to any use of GLib.
         *
         * This functions related to this has been deprecated in 2.46, and no longer work.
         */
        class MemVTable {
            static $gtype: GObject.GType<MemVTable>;

            // Constructors

            _init(...args: any[]): void;
        }

        /**
         * The #GNode struct represents one node in a [n-ary tree](data-structures.html#n-ary-trees).
         */
        class Node {
            static $gtype: GObject.GType<Node>;

            // Fields

            data: any;

            // Constructors

            _init(...args: any[]): void;

            // Static methods

            static pop_allocator(): void;
            static push_allocator(allocator: Allocator): void;

            // Methods

            /**
             * Gets the position of the first child of a #GNode
             * which contains the given data.
             * @param data the data to find
             * @returns the index of the child of @node which contains     @data, or -1 if the data is not found
             */
            child_index(data?: any | null): number;
            /**
             * Gets the position of a #GNode with respect to its siblings.
             * `child` must be a child of `node`. The first child is numbered 0,
             * the second 1, and so on.
             * @param child a child of @node
             * @returns the position of @child with respect to its siblings
             */
            child_position(child: Node): number;
            /**
             * Calls a function for each of the children of a #GNode. Note that it
             * doesn't descend beneath the child nodes. `func` must not do anything
             * that would modify the structure of the tree.
             * @param flags which types of children are to be visited, one of     %G_TRAVERSE_ALL, %G_TRAVERSE_LEAVES and %G_TRAVERSE_NON_LEAVES
             * @param func the function to call for each visited node
             */
            children_foreach(flags: TraverseFlags | null, func: NodeForeachFunc): void;
            /**
             * Gets the depth of a #GNode.
             *
             * If `node` is %NULL the depth is 0. The root node has a depth of 1.
             * For the children of the root node the depth is 2. And so on.
             * @returns the depth of the #GNode
             */
            depth(): number;
            /**
             * Removes `root` and its children from the tree, freeing any memory
             * allocated.
             */
            destroy(): void;
            /**
             * Returns %TRUE if `node` is an ancestor of `descendant`.
             * This is true if node is the parent of `descendant,`
             * or if node is the grandparent of `descendant` etc.
             * @param descendant a #GNode
             * @returns %TRUE if @node is an ancestor of @descendant
             */
            is_ancestor(descendant: Node): boolean;
            /**
             * Gets the maximum height of all branches beneath a #GNode.
             * This is the maximum distance from the #GNode to all leaf nodes.
             *
             * If `root` is %NULL, 0 is returned. If `root` has no children,
             * 1 is returned. If `root` has children, 2 is returned. And so on.
             * @returns the maximum height of the tree beneath @root
             */
            max_height(): number;
            /**
             * Gets the number of children of a #GNode.
             * @returns the number of children of @node
             */
            n_children(): number;
            /**
             * Gets the number of nodes in a tree.
             * @param flags which types of children are to be counted, one of     %G_TRAVERSE_ALL, %G_TRAVERSE_LEAVES and %G_TRAVERSE_NON_LEAVES
             * @returns the number of nodes in the tree
             */
            n_nodes(flags: TraverseFlags | null): number;
            /**
             * Reverses the order of the children of a #GNode.
             * (It doesn't change the order of the grandchildren.)
             */
            reverse_children(): void;
            /**
             * Traverses a tree starting at the given root #GNode.
             * It calls the given function for each node visited.
             * The traversal can be halted at any point by returning %TRUE from `func`.
             * `func` must not do anything that would modify the structure of the tree.
             * @param order the order in which nodes are visited - %G_IN_ORDER,     %G_PRE_ORDER, %G_POST_ORDER, or %G_LEVEL_ORDER.
             * @param flags which types of children are to be visited, one of     %G_TRAVERSE_ALL, %G_TRAVERSE_LEAVES and %G_TRAVERSE_NON_LEAVES
             * @param max_depth the maximum depth of the traversal. Nodes below this     depth will not be visited. If max_depth is -1 all nodes in     the tree are visited. If depth is 1, only the root is visited.     If depth is 2, the root and its children are visited. And so on.
             * @param func the function to call for each visited #GNode
             */
            traverse(
                order: TraverseType | null,
                flags: TraverseFlags | null,
                max_depth: number,
                func: NodeTraverseFunc,
            ): void;
            /**
             * Unlinks a #GNode from a tree, resulting in two separate trees.
             */
            unlink(): void;
        }

        /**
         * A #GOnce struct controls a one-time initialization function. Any
         * one-time initialization function must have its own unique #GOnce
         * struct.
         */
        class Once {
            static $gtype: GObject.GType<Once>;

            // Fields

            status: OnceStatus;
            retval: any;

            // Constructors

            _init(...args: any[]): void;

            // Static methods

            /**
             * Function to be called when starting a critical initialization
             * section. The argument `location` must point to a static
             * 0-initialized variable that will be set to a value other than 0 at
             * the end of the initialization section. In combination with
             * g_once_init_leave() and the unique address `value_location,` it can
             * be ensured that an initialization section will be executed only once
             * during a program's life time, and that concurrent threads are
             * blocked until initialization completed. To be used in constructs
             * like this:
             *
             *
             * ```c
             *   static gsize initialization_value = 0;
             *
             *   if (g_once_init_enter (&initialization_value))
             *     {
             *       gsize setup_value = 42; // initialization code here
             *
             *       g_once_init_leave (&initialization_value, setup_value);
             *     }
             *
             *   // use initialization_value here
             * ```
             *
             *
             * While `location` has a `volatile` qualifier, this is a historical artifact and
             * the pointer passed to it should not be `volatile`.
             * @param location location of a static initializable variable    containing 0
             */
            static init_enter(location: any): [boolean, any];
            static init_enter_impl(location: number): boolean;
            /**
             * This functions behaves in the same way as g_once_init_enter(), but can
             * can be used to initialize pointers (or #guintptr) instead of #gsize.
             *
             *
             * ```c
             *   static MyStruct *interesting_struct = NULL;
             *
             *   if (g_once_init_enter_pointer (&interesting_struct))
             *     {
             *       MyStruct *setup_value = allocate_my_struct (); // initialization code here
             *
             *       g_once_init_leave_pointer (&interesting_struct, g_steal_pointer (&setup_value));
             *     }
             *
             *   // use interesting_struct here
             * ```
             *
             * @param location location of a static initializable variable    containing `NULL`
             */
            static init_enter_pointer(location: any): boolean;
            /**
             * Counterpart to g_once_init_enter(). Expects a location of a static
             * 0-initialized initialization variable, and an initialization value
             * other than 0. Sets the variable to the initialization value, and
             * releases concurrent threads blocking in g_once_init_enter() on this
             * initialization variable.
             *
             * While `location` has a `volatile` qualifier, this is a historical artifact and
             * the pointer passed to it should not be `volatile`.
             * @param location location of a static initializable variable    containing 0
             * @param result new non-0 value for `*value_location`
             */
            static init_leave(location: any, result: number): any;
            /**
             * Counterpart to g_once_init_enter_pointer(). Expects a location of a static
             * `NULL`-initialized initialization variable, and an initialization value
             * other than `NULL`. Sets the variable to the initialization value, and
             * releases concurrent threads blocking in g_once_init_enter_pointer() on this
             * initialization variable.
             *
             * This functions behaves in the same way as g_once_init_leave(), but
             * can be used to initialize pointers (or #guintptr) instead of #gsize.
             * @param location location of a static initializable variable    containing `NULL`
             * @param result new non-`NULL` value for `*location`
             */
            static init_leave_pointer(location: any, result?: any | null): void;
        }

        /**
         * A `GOptionContext` struct defines which options
         * are accepted by the commandline option parser. The struct has only private
         * fields and should not be directly accessed.
         */
        abstract class OptionContext {
            static $gtype: GObject.GType<OptionContext>;

            // Constructors

            _init(...args: any[]): void;

            // Methods

            /**
             * Adds a #GOptionGroup to the `context,` so that parsing with `context`
             * will recognize the options in the group. Note that this will take
             * ownership of the `group` and thus the `group` should not be freed.
             * @param group the group to add
             */
            add_group(group: OptionGroup): void;
            /**
             * A convenience function which creates a main group if it doesn't
             * exist, adds the `entries` to it and sets the translation domain.
             * @param entries a %NULL-terminated array of #GOptionEntrys
             * @param translation_domain a translation domain to use for translating    the `--help` output for the options in @entries    with gettext(), or %NULL
             */
            add_main_entries(entries: OptionEntry[], translation_domain?: string | null): void;
            /**
             * Frees context and all the groups which have been
             * added to it.
             *
             * Please note that parsed arguments need to be freed separately (see
             * #GOptionEntry).
             */
            free(): void;
            /**
             * Returns the description. See g_option_context_set_description().
             * @returns the description
             */
            get_description(): string;
            /**
             * Returns a formatted, translated help text for the given context.
             * To obtain the text produced by `--help`, call
             * `g_option_context_get_help (context, TRUE, NULL)`.
             * To obtain the text produced by `--help-all`, call
             * `g_option_context_get_help (context, FALSE, NULL)`.
             * To obtain the help text for an option group, call
             * `g_option_context_get_help (context, FALSE, group)`.
             * @param main_help if %TRUE, only include the main group
             * @param group the #GOptionGroup to create help for, or %NULL
             * @returns A newly allocated string containing the help text
             */
            get_help(main_help: boolean, group?: OptionGroup | null): string;
            /**
             * Returns whether automatic `--help` generation
             * is turned on for `context`. See g_option_context_set_help_enabled().
             * @returns %TRUE if automatic help generation is turned on.
             */
            get_help_enabled(): boolean;
            /**
             * Returns whether unknown options are ignored or not. See
             * g_option_context_set_ignore_unknown_options().
             * @returns %TRUE if unknown options are ignored.
             */
            get_ignore_unknown_options(): boolean;
            /**
             * Returns a pointer to the main group of `context`.
             * @returns the main group of @context, or %NULL if  @context doesn't have a main group. Note that group belongs to  @context and should not be modified or freed.
             */
            get_main_group(): OptionGroup;
            /**
             * Returns whether strict POSIX code is enabled.
             *
             * See g_option_context_set_strict_posix() for more information.
             * @returns %TRUE if strict POSIX is enabled, %FALSE otherwise.
             */
            get_strict_posix(): boolean;
            /**
             * Returns the summary. See g_option_context_set_summary().
             * @returns the summary
             */
            get_summary(): string;
            /**
             * Parses the command line arguments, recognizing options
             * which have been added to `context`. A side-effect of
             * calling this function is that g_set_prgname() will be
             * called.
             *
             * If the parsing is successful, any parsed arguments are
             * removed from the array and `argc` and `argv` are updated
             * accordingly. A '--' option is stripped from `argv`
             * unless there are unparsed options before and after it,
             * or some of the options after it start with '-'. In case
             * of an error, `argc` and `argv` are left unmodified.
             *
             * If automatic `--help` support is enabled
             * (see g_option_context_set_help_enabled()), and the
             * `argv` array contains one of the recognized help options,
             * this function will produce help output to stdout and
             * call `exit (0)`.
             *
             * Note that function depends on the
             * [current locale](running.html#locale) for automatic
             * character set conversion of string and filename arguments.
             * @param argv a pointer to the array of command line arguments
             * @returns %TRUE if the parsing was successful,               %FALSE if an error occurred
             */
            parse(argv?: string[]): [boolean, string[]];
            /**
             * Parses the command line arguments.
             *
             * This function is similar to g_option_context_parse() except that it
             * respects the normal memory rules when dealing with a strv instead of
             * assuming that the passed-in array is the argv of the main function.
             *
             * In particular, strings that are removed from the arguments list will
             * be freed using g_free().
             *
             * On Windows, the strings are expected to be in UTF-8.  This is in
             * contrast to g_option_context_parse() which expects them to be in the
             * system codepage, which is how they are passed as `argv` to main().
             * See g_win32_get_command_line() for a solution.
             *
             * This function is useful if you are trying to use #GOptionContext with
             * #GApplication.
             * @param _arguments a pointer    to the command line arguments (which must be in UTF-8 on Windows).    Starting with GLib 2.62, @arguments can be %NULL, which matches    g_option_context_parse().
             * @returns %TRUE if the parsing was successful,          %FALSE if an error occurred
             */
            parse_strv(_arguments?: string[]): [boolean, string[]];
            /**
             * Adds a string to be displayed in `--help` output after the list
             * of options. This text often includes a bug reporting address.
             *
             * Note that the summary is translated (see
             * g_option_context_set_translate_func()).
             * @param description a string to be shown in `--help` output   after the list of options, or %NULL
             */
            set_description(description?: string | null): void;
            /**
             * Enables or disables automatic generation of `--help` output.
             * By default, g_option_context_parse() recognizes `--help`, `-h`,
             * `-?`, `--help-all` and `--help-groupname` and creates suitable
             * output to stdout.
             * @param help_enabled %TRUE to enable `--help`, %FALSE to disable it
             */
            set_help_enabled(help_enabled: boolean): void;
            /**
             * Sets whether to ignore unknown options or not. If an argument is
             * ignored, it is left in the `argv` array after parsing. By default,
             * g_option_context_parse() treats unknown options as error.
             *
             * This setting does not affect non-option arguments (i.e. arguments
             * which don't start with a dash). But note that GOption cannot reliably
             * determine whether a non-option belongs to a preceding unknown option.
             * @param ignore_unknown %TRUE to ignore unknown options, %FALSE to produce    an error when unknown options are met
             */
            set_ignore_unknown_options(ignore_unknown: boolean): void;
            /**
             * Sets a #GOptionGroup as main group of the `context`.
             * This has the same effect as calling g_option_context_add_group(),
             * the only difference is that the options in the main group are
             * treated differently when generating `--help` output.
             * @param group the group to set as main group
             */
            set_main_group(group: OptionGroup): void;
            /**
             * Sets strict POSIX mode.
             *
             * By default, this mode is disabled.
             *
             * In strict POSIX mode, the first non-argument parameter encountered
             * (eg: filename) terminates argument processing.  Remaining arguments
             * are treated as non-options and are not attempted to be parsed.
             *
             * If strict POSIX mode is disabled then parsing is done in the GNU way
             * where option arguments can be freely mixed with non-options.
             *
             * As an example, consider "ls foo -l".  With GNU style parsing, this
             * will list "foo" in long mode.  In strict POSIX style, this will list
             * the files named "foo" and "-l".
             *
             * It may be useful to force strict POSIX mode when creating "verb
             * style" command line tools.  For example, the "gsettings" command line
             * tool supports the global option "--schemadir" as well as many
             * subcommands ("get", "set", etc.) which each have their own set of
             * arguments.  Using strict POSIX mode will allow parsing the global
             * options up to the verb name while leaving the remaining options to be
             * parsed by the relevant subcommand (which can be determined by
             * examining the verb name, which should be present in argv[1] after
             * parsing).
             * @param strict_posix the new value
             */
            set_strict_posix(strict_posix: boolean): void;
            /**
             * Adds a string to be displayed in `--help` output before the list
             * of options. This is typically a summary of the program functionality.
             *
             * Note that the summary is translated (see
             * g_option_context_set_translate_func() and
             * g_option_context_set_translation_domain()).
             * @param summary a string to be shown in `--help` output  before the list of options, or %NULL
             */
            set_summary(summary?: string | null): void;
            /**
             * Sets the function which is used to translate the contexts
             * user-visible strings, for `--help` output. If `func` is %NULL,
             * strings are not translated.
             *
             * Note that option groups have their own translation functions,
             * this function only affects the `parameter_string` (see g_option_context_new()),
             * the summary (see g_option_context_set_summary()) and the description
             * (see g_option_context_set_description()).
             *
             * If you are using gettext(), you only need to set the translation
             * domain, see g_option_context_set_translation_domain().
             * @param func the #GTranslateFunc, or %NULL
             * @param destroy_notify a function which gets called to free @data, or %NULL
             */
            set_translate_func(func?: TranslateFunc | null, destroy_notify?: DestroyNotify | null): void;
            /**
             * A convenience function to use gettext() for translating
             * user-visible strings.
             * @param domain the domain to use
             */
            set_translation_domain(domain: string): void;
        }

        /**
         * - %G_OPTION_ARG_NONE: %gboolean
         *     - %G_OPTION_ARG_STRING: %gchar*
         *     - %G_OPTION_ARG_INT: %gint
         *     - %G_OPTION_ARG_FILENAME: %gchar*
         *     - %G_OPTION_ARG_STRING_ARRAY: %gchar**
         *     - %G_OPTION_ARG_FILENAME_ARRAY: %gchar**
         *     - %G_OPTION_ARG_DOUBLE: %gdouble
         *
         *     If `arg` type is %G_OPTION_ARG_STRING or %G_OPTION_ARG_FILENAME,
         *     the location will contain a newly allocated string if the option
         *     was given. That string needs to be freed by the callee using g_free().
         *     Likewise if `arg` type is %G_OPTION_ARG_STRING_ARRAY or
         *     %G_OPTION_ARG_FILENAME_ARRAY, the data should be freed using g_strfreev().
         * A GOptionEntry struct defines a single option. To have an effect, they
         * must be added to a #GOptionGroup with g_option_context_add_main_entries()
         * or g_option_group_add_entries().
         */
        class OptionEntry {
            static $gtype: GObject.GType<OptionEntry>;

            // Fields

            long_name: string;
            short_name: number;
            flags: number;
            arg: OptionArg;
            arg_data: any;
            description: string;
            arg_description: string;

            // Constructors

            _init(...args: any[]): void;
        }

        /**
         * A `GOptionGroup` struct defines the options in a single
         * group. The struct has only private fields and should not be directly accessed.
         *
         * All options in a group share the same translation function. Libraries which
         * need to parse commandline options are expected to provide a function for
         * getting a `GOptionGroup` holding their options, which
         * the application can then add to its #GOptionContext.
         */
        class OptionGroup {
            static $gtype: GObject.GType<OptionGroup>;

            // Constructors

            constructor(
                name: string,
                description: string,
                help_description: string,
                user_data?: any | null,
                destroy?: DestroyNotify | null,
            );
            _init(...args: any[]): void;

            static ['new'](
                name: string,
                description: string,
                help_description: string,
                user_data?: any | null,
                destroy?: DestroyNotify | null,
            ): OptionGroup;

            // Methods

            /**
             * Adds the options specified in `entries` to `group`.
             * @param entries a %NULL-terminated array of #GOptionEntrys
             */
            add_entries(entries: OptionEntry[]): void;
            /**
             * Frees a #GOptionGroup. Note that you must not free groups
             * which have been added to a #GOptionContext.
             */
            free(): void;
            /**
             * Increments the reference count of `group` by one.
             * @returns a #GOptionGroup
             */
            ref(): OptionGroup;
            /**
             * Sets the function which is used to translate user-visible strings,
             * for `--help` output. Different groups can use different
             * #GTranslateFuncs. If `func` is %NULL, strings are not translated.
             *
             * If you are using gettext(), you only need to set the translation
             * domain, see g_option_group_set_translation_domain().
             * @param func the #GTranslateFunc, or %NULL
             * @param destroy_notify a function which gets called to free @data, or %NULL
             */
            set_translate_func(func?: TranslateFunc | null, destroy_notify?: DestroyNotify | null): void;
            /**
             * A convenience function to use gettext() for translating
             * user-visible strings.
             * @param domain the domain to use
             */
            set_translation_domain(domain: string): void;
            /**
             * Decrements the reference count of `group` by one.
             * If the reference count drops to 0, the `group` will be freed.
             * and all memory allocated by the `group` is released.
             */
            unref(): void;
        }

        /**
         * `GPathBuf` is a helper type that allows you to easily build paths from
         * individual elements, using the platform specific conventions for path
         * separators.
         *
         * ```c
         * g_auto (GPathBuf) path;
         *
         * g_path_buf_init (&path);
         *
         * g_path_buf_push (&path, "usr");
         * g_path_buf_push (&path, "bin");
         * g_path_buf_push (&path, "echo");
         *
         * g_autofree char *echo = g_path_buf_to_path (&path);
         * g_assert_cmpstr (echo, ==, "/usr/bin/echo");
         * ```
         *
         * You can also load a full path and then operate on its components:
         *
         * ```c
         * g_auto (GPathBuf) path;
         *
         * g_path_buf_init_from_path (&path, "/usr/bin/echo");
         *
         * g_path_buf_pop (&path);
         * g_path_buf_push (&path, "sh");
         *
         * g_autofree char *sh = g_path_buf_to_path (&path);
         * g_assert_cmpstr (sh, ==, "/usr/bin/sh");
         * ```
         */
        class PathBuf {
            static $gtype: GObject.GType<PathBuf>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            // Static methods

            /**
             * Compares two path buffers for equality and returns `TRUE`
             * if they are equal.
             *
             * The path inside the paths buffers are not going to be normalized,
             * so `X/Y/Z/A/..`, `X/./Y/Z` and `X/Y/Z` are not going to be considered
             * equal.
             *
             * This function can be passed to g_hash_table_new() as the
             * `key_equal_func` parameter.
             * @param v1 a path buffer to compare
             * @param v2 a path buffer to compare
             */
            static equal(v1: any, v2: any): boolean;

            // Methods

            /**
             * Clears the contents of the path buffer.
             *
             * This function should be use to free the resources in a stack-allocated
             * `GPathBuf` initialized using g_path_buf_init() or
             * g_path_buf_init_from_path().
             */
            clear(): void;
            /**
             * Clears the contents of the path buffer and returns the built path.
             *
             * This function returns `NULL` if the `GPathBuf` is empty.
             *
             * See also: g_path_buf_to_path()
             * @returns the built path
             */
            clear_to_path(): string | null;
            /**
             * Frees a `GPathBuf` allocated by g_path_buf_new().
             */
            free(): void;
            /**
             * Frees a `GPathBuf` allocated by g_path_buf_new(), and
             * returns the path inside the buffer.
             *
             * This function returns `NULL` if the `GPathBuf` is empty.
             *
             * See also: g_path_buf_to_path()
             * @returns the path
             */
            free_to_path(): string | null;
            /**
             * Initializes a `GPathBuf` instance.
             * @returns the initialized path builder
             */
            init(): PathBuf;
            /**
             * Initializes a `GPathBuf` instance with the given path.
             * @param path a file system path
             * @returns the initialized path builder
             */
            init_from_path(path?: string | null): PathBuf;
            /**
             * Removes the last element of the path buffer.
             *
             * If there is only one element in the path buffer (for example, `/` on
             * Unix-like operating systems or the drive on Windows systems), it will
             * not be removed and %FALSE will be returned instead.
             *
             *
             * ```c
             * GPathBuf buf, cmp;
             *
             * g_path_buf_init_from_path (&buf, "/bin/sh");
             *
             * g_path_buf_pop (&buf);
             * g_path_buf_init_from_path (&cmp, "/bin");
             * g_assert_true (g_path_buf_equal (&buf, &cmp));
             * g_path_buf_clear (&cmp);
             *
             * g_path_buf_pop (&buf);
             * g_path_buf_init_from_path (&cmp, "/");
             * g_assert_true (g_path_buf_equal (&buf, &cmp));
             * g_path_buf_clear (&cmp);
             *
             * g_path_buf_clear (&buf);
             * ```
             *
             * @returns `TRUE` if the buffer was modified and `FALSE` otherwise
             */
            pop(): boolean;
            /**
             * Extends the given path buffer with `path`.
             *
             * If `path` is absolute, it replaces the current path.
             *
             * If `path` contains a directory separator, the buffer is extended by
             * as many elements the path provides.
             *
             * On Windows, both forward slashes and backslashes are treated as
             * directory separators. On other platforms, %G_DIR_SEPARATOR_S is the
             * only directory separator.
             *
             *
             * ```c
             * GPathBuf buf, cmp;
             *
             * g_path_buf_init_from_path (&buf, "/tmp");
             * g_path_buf_push (&buf, ".X11-unix/X0");
             * g_path_buf_init_from_path (&cmp, "/tmp/.X11-unix/X0");
             * g_assert_true (g_path_buf_equal (&buf, &cmp));
             * g_path_buf_clear (&cmp);
             *
             * g_path_buf_push (&buf, "/etc/locale.conf");
             * g_path_buf_init_from_path (&cmp, "/etc/locale.conf");
             * g_assert_true (g_path_buf_equal (&buf, &cmp));
             * g_path_buf_clear (&cmp);
             *
             * g_path_buf_clear (&buf);
             * ```
             *
             * @param path a path
             * @returns the same pointer to @buf, for convenience
             */
            push(path: string): PathBuf;
            /**
             * Adds an extension to the file name in the path buffer.
             *
             * If `extension` is `NULL`, the extension will be unset.
             *
             * If the path buffer does not have a file name set, this function returns
             * `FALSE` and leaves the path buffer unmodified.
             * @param extension the file extension
             * @returns `TRUE` if the extension was replaced, and `FALSE` otherwise
             */
            set_extension(extension?: string | null): boolean;
            /**
             * Sets the file name of the path.
             *
             * If the path buffer is empty, the filename is left unset and this
             * function returns `FALSE`.
             *
             * If the path buffer only contains the root element (on Unix-like operating
             * systems) or the drive (on Windows), this is the equivalent of pushing
             * the new `file_name`.
             *
             * If the path buffer contains a path, this is the equivalent of
             * popping the path buffer and pushing `file_name,` creating a
             * sibling of the original path.
             *
             *
             * ```c
             * GPathBuf buf, cmp;
             *
             * g_path_buf_init_from_path (&buf, "/");
             *
             * g_path_buf_set_filename (&buf, "bar");
             * g_path_buf_init_from_path (&cmp, "/bar");
             * g_assert_true (g_path_buf_equal (&buf, &cmp));
             * g_path_buf_clear (&cmp);
             *
             * g_path_buf_set_filename (&buf, "baz.txt");
             * g_path_buf_init_from_path (&cmp, "/baz.txt");
             * g_assert_true (g_path_buf_equal (&buf, &cmp);
             * g_path_buf_clear (&cmp);
             *
             * g_path_buf_clear (&buf);
             * ```
             *
             * @param file_name the file name in the path
             * @returns `TRUE` if the file name was replaced, and `FALSE` otherwise
             */
            set_filename(file_name: string): boolean;
            /**
             * Retrieves the built path from the path buffer.
             *
             * On Windows, the result contains backslashes as directory separators,
             * even if forward slashes were used in input.
             *
             * If the path buffer is empty, this function returns `NULL`.
             * @returns the path
             */
            to_path(): string | null;
        }

        /**
         * A `GPatternSpec` struct is the ‘compiled’ form of a glob-style pattern.
         *
         * The [func`GLib`.pattern_match_simple] and [method`GLib`.PatternSpec.match] functions
         * match a string against a pattern containing `*` and `?` wildcards with similar
         * semantics as the standard `glob()` function: `*` matches an arbitrary,
         * possibly empty, string, `?` matches an arbitrary character.
         *
         * Note that in contrast to [`glob()`](man:glob(3)), the `/` character can be
         * matched by the wildcards, there are no `[…]` character ranges and `*` and `?`
         * can not be escaped to include them literally in a pattern.
         *
         * When multiple strings must be matched against the same pattern, it is better
         * to compile the pattern to a [struct`GLib`.PatternSpec] using
         * [ctor`GLib`.PatternSpec.new] and use [method`GLib`.PatternSpec.match_string]
         * instead of [func`GLib`.pattern_match_simple]. This avoids the overhead of repeated
         * pattern compilation.
         */
        class PatternSpec {
            static $gtype: GObject.GType<PatternSpec>;

            // Constructors

            constructor(pattern: string);
            _init(...args: any[]): void;

            static ['new'](pattern: string): PatternSpec;

            // Methods

            /**
             * Copies `pspec` in a new [type`GLib`.PatternSpec].
             * @returns a copy of @pspec.
             */
            copy(): PatternSpec;
            /**
             * Compares two compiled pattern specs and returns whether they will
             * match the same set of strings.
             * @param pspec2 another #GPatternSpec
             * @returns Whether the compiled patterns are equal
             */
            equal(pspec2: PatternSpec): boolean;
            /**
             * Frees the memory allocated for the [type`GLib`.PatternSpec].
             */
            free(): void;
            /**
             * Matches a string against a compiled pattern.
             *
             * Passing the correct
             * length of the string given is mandatory. The reversed string can be
             * omitted by passing `NULL`, this is more efficient if the reversed
             * version of the string to be matched is not at hand, as
             * [method`GLib`.PatternSpec.match] will only construct it if the compiled pattern
             * requires reverse matches.
             *
             * Note that, if the user code will (possibly) match a string against a
             * multitude of patterns containing wildcards, chances are high that
             * some patterns will require a reversed string. In this case, it’s
             * more efficient to provide the reversed string to avoid multiple
             * constructions thereof in the various calls to [method`GLib`.PatternSpec.match].
             *
             * Note also that the reverse of a UTF-8 encoded string can in general
             * not be obtained by [func`GLib`.strreverse]. This works only if the string
             * does not contain any multibyte characters. GLib offers the
             * [func`GLib`.utf8_strreverse] function to reverse UTF-8 encoded strings.
             * @param string_length the length of @string (in bytes, i.e. `strlen()`,    not [func@GLib.utf8_strlen])
             * @param string the UTF-8 encoded string to match
             * @param string_reversed the reverse of @string
             * @returns %TRUE if @string matches @pspec
             */
            match(string_length: number, string: string, string_reversed?: string | null): boolean;
            /**
             * Matches a string against a compiled pattern.
             *
             * If the string is to be
             * matched against more than one pattern, consider using
             * [method`GLib`.PatternSpec.match] instead while supplying the reversed string.
             * @param string the UTF-8 encoded string to match
             * @returns %TRUE if @string matches @pspec
             */
            match_string(string: string): boolean;
        }

        /**
         * Represents a file descriptor, which events to poll for, and which events
         * occurred.
         */
        class PollFD {
            static $gtype: GObject.GType<PollFD>;

            // Fields

            fd: number;
            events: number;
            revents: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    fd: number;
                    events: number;
                    revents: number;
                }>,
            );
            _init(...args: any[]): void;
        }

        /**
         * The #GPrivate struct is an opaque data structure to represent a
         * thread-local data key. It is approximately equivalent to the
         * pthread_setspecific()/pthread_getspecific() APIs on POSIX and to
         * TlsSetValue()/TlsGetValue() on Windows.
         *
         * If you don't already know why you might want this functionality,
         * then you probably don't need it.
         *
         * #GPrivate is a very limited resource (as far as 128 per program,
         * shared between all libraries). It is also not possible to destroy a
         * #GPrivate after it has been used. As such, it is only ever acceptable
         * to use #GPrivate in static scope, and even then sparingly so.
         *
         * See G_PRIVATE_INIT() for a couple of examples.
         *
         * The #GPrivate structure should be considered opaque.  It should only
         * be accessed via the g_private_ functions.
         */
        class Private {
            static $gtype: GObject.GType<Private>;

            // Constructors

            _init(...args: any[]): void;

            // Methods

            /**
             * Returns the current value of the thread local variable `key`.
             *
             * If the value has not yet been set in this thread, %NULL is returned.
             * Values are never copied between threads (when a new thread is
             * created, for example).
             * @returns the thread-local value
             */
            get(): any | null;
            /**
             * Sets the thread local variable `key` to have the value `value` in the
             * current thread.
             *
             * This function differs from g_private_set() in the following way: if
             * the previous value was non-%NULL then the #GDestroyNotify handler for
             * `key` is run on it.
             * @param value the new value
             */
            replace(value?: any | null): void;
            /**
             * Sets the thread local variable `key` to have the value `value` in the
             * current thread.
             *
             * This function differs from g_private_replace() in the following way:
             * the #GDestroyNotify for `key` is not called on the old value.
             * @param value the new value
             */
            set(value?: any | null): void;
        }

        /**
         * Contains the public fields of a pointer array.
         */
        class PtrArray {
            static $gtype: GObject.GType<PtrArray>;

            // Fields

            pdata: any;
            len: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    pdata: any;
                    len: number;
                }>,
            );
            _init(...args: any[]): void;
        }

        /**
         * Contains the public fields of a
         * [Queue](data-structures.html#double-ended-queues).
         */
        class Queue {
            static $gtype: GObject.GType<Queue>;

            // Fields

            head: any[];
            tail: any[];
            length: number;

            // Constructors

            constructor(
                properties?: Partial<{
                    length: number;
                }>,
            );
            _init(...args: any[]): void;

            // Methods

            /**
             * Removes all the elements in `queue`. If queue elements contain
             * dynamically-allocated memory, they should be freed first.
             */
            clear(): void;
            /**
             * Convenience method, which frees all the memory used by a #GQueue,
             * and calls the provided `free_func` on each item in the #GQueue.
             * @param free_func the function to be called to free memory allocated
             */
            clear_full(free_func?: DestroyNotify | null): void;
            /**
             * Calls `func` for each element in the queue passing `user_data` to the
             * function.
             *
             * It is safe for `func` to remove the element from `queue,` but it must
             * not modify any part of the queue after that element.
             * @param func the function to call for each element's data
             */
            foreach(func: Func): void;
            /**
             * Frees the memory allocated for the #GQueue. Only call this function
             * if `queue` was created with g_queue_new(). If queue elements contain
             * dynamically-allocated memory, they should be freed first.
             *
             * If queue elements contain dynamically-allocated memory, you should
             * either use g_queue_free_full() or free them manually first.
             */
            free(): void;
            /**
             * Convenience method, which frees all the memory used by a #GQueue,
             * and calls the specified destroy function on every element's data.
             *
             * `free_func` should not modify the queue (eg, by removing the freed
             * element from it).
             */
            free_full(): void;
            /**
             * Returns the number of items in `queue`.
             * @returns the number of items in @queue
             */
            get_length(): number;
            /**
             * Returns the position of the first element in `queue` which contains `data`.
             * @param data the data to find
             * @returns the position of the first element in @queue which     contains @data, or -1 if no element in @queue contains @data
             */
            index(data?: any | null): number;
            /**
             * A statically-allocated #GQueue must be initialized with this function
             * before it can be used. Alternatively you can initialize it with
             * %G_QUEUE_INIT. It is not necessary to initialize queues created with
             * g_queue_new().
             */
            init(): void;
            /**
             * Inserts `data` into `queue` using `func` to determine the new position.
             * @param data the data to insert
             * @param func the #GCompareDataFunc used to compare elements in the queue. It is     called with two elements of the @queue and @user_data. It should     return 0 if the elements are equal, a negative value if the first     element comes before the second, and a positive value if the second     element comes before the first.
             */
            insert_sorted(data: any | null, func: CompareDataFunc): void;
            /**
             * Returns %TRUE if the queue is empty.
             * @returns %TRUE if the queue is empty
             */
            is_empty(): boolean;
            /**
             * Returns the first element of the queue.
             * @returns the data of the first element in the queue, or %NULL     if the queue is empty
             */
            peek_head(): any | null;
            /**
             * Returns the `n'`th element of `queue`.
             * @param n the position of the element
             * @returns the data for the @n'th element of @queue,     or %NULL if @n is off the end of @queue
             */
            peek_nth(n: number): any | null;
            /**
             * Returns the last element of the queue.
             * @returns the data of the last element in the queue, or %NULL     if the queue is empty
             */
            peek_tail(): any | null;
            /**
             * Removes the first element of the queue and returns its data.
             * @returns the data of the first element in the queue, or %NULL     if the queue is empty
             */
            pop_head(): any | null;
            /**
             * Removes the `n'`th element of `queue` and returns its data.
             * @param n the position of the element
             * @returns the element's data, or %NULL if @n is off the end of @queue
             */
            pop_nth(n: number): any | null;
            /**
             * Removes the last element of the queue and returns its data.
             * @returns the data of the last element in the queue, or %NULL     if the queue is empty
             */
            pop_tail(): any | null;
            /**
             * Adds a new element at the head of the queue.
             * @param data the data for the new element.
             */
            push_head(data?: any | null): void;
            /**
             * Inserts a new element into `queue` at the given position.
             * @param data the data for the new element
             * @param n the position to insert the new element. If @n is negative or     larger than the number of elements in the @queue, the element is     added to the end of the queue.
             */
            push_nth(data: any | null, n: number): void;
            /**
             * Adds a new element at the tail of the queue.
             * @param data the data for the new element
             */
            push_tail(data?: any | null): void;
            /**
             * Removes the first element in `queue` that contains `data`.
             * @param data the data to remove
             * @returns %TRUE if @data was found and removed from @queue
             */
            remove(data?: any | null): boolean;
            /**
             * Remove all elements whose data equals `data` from `queue`.
             * @param data the data to remove
             * @returns the number of elements removed from @queue
             */
            remove_all(data?: any | null): number;
            /**
             * Reverses the order of the items in `queue`.
             */
            reverse(): void;
            /**
             * Sorts `queue` using `compare_func`.
             * @param compare_func the #GCompareDataFunc used to sort @queue. This function     is passed two elements of the queue and should return 0 if they are     equal, a negative value if the first comes before the second, and     a positive value if the second comes before the first.
             */
            sort(compare_func: CompareDataFunc): void;
        }

        /**
         * The GRWLock struct is an opaque data structure to represent a
         * reader-writer lock. It is similar to a #GMutex in that it allows
         * multiple threads to coordinate access to a shared resource.
         *
         * The difference to a mutex is that a reader-writer lock discriminates
         * between read-only ('reader') and full ('writer') access. While only
         * one thread at a time is allowed write access (by holding the 'writer'
         * lock via g_rw_lock_writer_lock()), multiple threads can gain
         * simultaneous read-only access (by holding the 'reader' lock via
         * g_rw_lock_reader_lock()).
         *
         * It is unspecified whether readers or writers have priority in acquiring the
         * lock when a reader already holds the lock and a writer is queued to acquire
         * it.
         *
         * Here is an example for an array with access functions:
         *
         * ```c
         *   GRWLock lock;
         *   GPtrArray *array;
         *
         *   gpointer
         *   my_array_get (guint index)
         *   {
         *     gpointer retval = NULL;
         *
         *     if (!array)
         *       return NULL;
         *
         *     g_rw_lock_reader_lock (&lock);
         *     if (index < array->len)
         *       retval = g_ptr_array_index (array, index);
         *     g_rw_lock_reader_unlock (&lock);
         *
         *     return retval;
         *   }
         *
         *   void
         *   my_array_set (guint index, gpointer data)
         *   {
         *     g_rw_lock_writer_lock (&lock);
         *
         *     if (!array)
         *       array = g_ptr_array_new ();
         *
         *     if (index >= array->len)
         *       g_ptr_array_set_size (array, index+1);
         *     g_ptr_array_index (array, index) = data;
         *
         *     g_rw_lock_writer_unlock (&lock);
         *   }
         *  ```
         *
         * This example shows an array which can be accessed by many readers
         * (the my_array_get() function) simultaneously, whereas the writers
         * (the my_array_set() function) will only be allowed one at a time
         * and only if no readers currently access the array. This is because
         * of the potentially dangerous resizing of the array. Using these
         * functions is fully multi-thread safe now.
         *
         * If a #GRWLock is allocated in static storage then it can be used
         * without initialisation.  Otherwise, you should call
         * g_rw_lock_init() on it and g_rw_lock_clear() when done.
         *
         * A GRWLock should only be accessed with the g_rw_lock_ functions.
         */
        class RWLock {
            static $gtype: GObject.GType<RWLock>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            // Methods

            /**
             * Frees the resources allocated to a lock with g_rw_lock_init().
             *
             * This function should not be used with a #GRWLock that has been
             * statically allocated.
             *
             * Calling g_rw_lock_clear() when any thread holds the lock
             * leads to undefined behaviour.
             */
            clear(): void;
            /**
             * Initializes a #GRWLock so that it can be used.
             *
             * This function is useful to initialize a lock that has been
             * allocated on the stack, or as part of a larger structure.  It is not
             * necessary to initialise a reader-writer lock that has been statically
             * allocated.
             *
             *
             * ```c
             *   typedef struct {
             *     GRWLock l;
             *     ...
             *   } Blob;
             *
             * Blob *b;
             *
             * b = g_new (Blob, 1);
             * g_rw_lock_init (&b->l);
             * ```
             *
             *
             * To undo the effect of g_rw_lock_init() when a lock is no longer
             * needed, use g_rw_lock_clear().
             *
             * Calling g_rw_lock_init() on an already initialized #GRWLock leads
             * to undefined behaviour.
             */
            init(): void;
            /**
             * Obtain a read lock on `rw_lock`. If another thread currently holds
             * the write lock on `rw_lock,` the current thread will block until the
             * write lock was (held and) released. If another thread does not hold
             * the write lock, but is waiting for it, it is implementation defined
             * whether the reader or writer will block. Read locks can be taken
             * recursively.
             *
             * Calling g_rw_lock_reader_lock() while the current thread already
             * owns a write lock leads to undefined behaviour. Read locks however
             * can be taken recursively, in which case you need to make sure to
             * call g_rw_lock_reader_unlock() the same amount of times.
             *
             * It is implementation-defined how many read locks are allowed to be
             * held on the same lock simultaneously. If the limit is hit,
             * or if a deadlock is detected, a critical warning will be emitted.
             */
            reader_lock(): void;
            /**
             * Tries to obtain a read lock on `rw_lock` and returns %TRUE if
             * the read lock was successfully obtained. Otherwise it
             * returns %FALSE.
             * @returns %TRUE if @rw_lock could be locked
             */
            reader_trylock(): boolean;
            /**
             * Release a read lock on `rw_lock`.
             *
             * Calling g_rw_lock_reader_unlock() on a lock that is not held
             * by the current thread leads to undefined behaviour.
             */
            reader_unlock(): void;
            /**
             * Obtain a write lock on `rw_lock`. If another thread currently holds
             * a read or write lock on `rw_lock,` the current thread will block
             * until all other threads have dropped their locks on `rw_lock`.
             *
             * Calling g_rw_lock_writer_lock() while the current thread already
             * owns a read or write lock on `rw_lock` leads to undefined behaviour.
             */
            writer_lock(): void;
            /**
             * Tries to obtain a write lock on `rw_lock`. If another thread
             * currently holds a read or write lock on `rw_lock,` it immediately
             * returns %FALSE.
             * Otherwise it locks `rw_lock` and returns %TRUE.
             * @returns %TRUE if @rw_lock could be locked
             */
            writer_trylock(): boolean;
            /**
             * Release a write lock on `rw_lock`.
             *
             * Calling g_rw_lock_writer_unlock() on a lock that is not held
             * by the current thread leads to undefined behaviour.
             */
            writer_unlock(): void;
        }

        /**
         * The GRand struct is an opaque data structure. It should only be
         * accessed through the g_rand_* functions.
         */
        class Rand {
            static $gtype: GObject.GType<Rand>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            static ['new'](): Rand;

            static new_with_seed(seed: number): Rand;

            static new_with_seed_array(seed: number, seed_length: number): Rand;

            // Methods

            /**
             * Copies a #GRand into a new one with the same exact state as before.
             * This way you can take a snapshot of the random number generator for
             * replaying later.
             * @returns the new #GRand
             */
            copy(): Rand;
            /**
             * Returns the next random #gdouble from `rand_` equally distributed over
             * the range [0..1).
             * @returns a random number
             */
            double(): number;
            /**
             * Returns the next random #gdouble from `rand_` equally distributed over
             * the range [`begin`..`end)`.
             * @param begin lower closed bound of the interval
             * @param end upper open bound of the interval
             * @returns a random number
             */
            double_range(begin: number, end: number): number;
            /**
             * Frees the memory allocated for the #GRand.
             */
            free(): void;
            /**
             * Returns the next random #guint32 from `rand_` equally distributed over
             * the range [0..2^32-1].
             * @returns a random number
             */
            int(): number;
            /**
             * Returns the next random #gint32 from `rand_` equally distributed over
             * the range [`begin`..`end-1`].
             * @param begin lower closed bound of the interval
             * @param end upper open bound of the interval
             * @returns a random number
             */
            int_range(begin: number, end: number): number;
            /**
             * Sets the seed for the random number generator #GRand to `seed`.
             * @param seed a value to reinitialize the random number generator
             */
            set_seed(seed: number): void;
            /**
             * Initializes the random number generator by an array of longs.
             * Array can be of arbitrary size, though only the first 624 values
             * are taken.  This function is useful if you have many low entropy
             * seeds, or if you require more then 32 bits of actual entropy for
             * your application.
             * @param seed array to initialize with
             * @param seed_length length of array
             */
            set_seed_array(seed: number, seed_length: number): void;
        }

        /**
         * The GRecMutex struct is an opaque data structure to represent a
         * recursive mutex. It is similar to a #GMutex with the difference
         * that it is possible to lock a GRecMutex multiple times in the same
         * thread without deadlock. When doing so, care has to be taken to
         * unlock the recursive mutex as often as it has been locked.
         *
         * If a #GRecMutex is allocated in static storage then it can be used
         * without initialisation.  Otherwise, you should call
         * g_rec_mutex_init() on it and g_rec_mutex_clear() when done.
         *
         * A GRecMutex should only be accessed with the
         * g_rec_mutex_ functions.
         */
        class RecMutex {
            static $gtype: GObject.GType<RecMutex>;

            // Constructors

            constructor(properties?: Partial<{}>);
            _init(...args: any[]): void;

            // Methods

            /**
             * Frees the resources allocated to a recursive mutex with
             * g_rec_mutex_init().
             *
             * This function should not be used with a #GRecMutex that has been
             * statically allocated.
             *
             * Calling g_rec_mutex_clear() on a locked recursive mutex leads
             * to undefined behaviour.
             */
            clear(): void;
            /**
             * Initializes a #GRecMutex so that it can be used.
             *
             * This function is useful to initialize a recursive mutex
             * that has been allocated on the stack, or as part of a larger
             * structure.
             *
             * It is not necessary to initialise a recursive mutex that has been
             * statically allocated.
             *
             *
             * ```c
             *   typedef struct {
             *     GRecMutex m;
             *     ...
             *   } Blob;
             *
             * Blob *b;
             *
             * b = g_new (Blob, 1);
             * g_rec_mutex_init (&b->m);
             * ```
             *
             *
             * Calling g_rec_mutex_init() on an already initialized #GRecMutex
             * leads to undefined behaviour.
             *
             * To undo the effect of g_rec_mutex_init() when a recursive mutex
             * is no longer needed, use g_rec_mutex_clear().
             */
            init(): void;
            /**
             * Locks `rec_mutex`. If `rec_mutex` is already locked by another
             * thread, the current thread will block until `rec_mutex` is
             * unlocked by the other thread. If `rec_mutex` is already locked
             * by the current thread, the 'lock count' of `rec_mutex` is increased.
             * The mutex will only become available again when it is unlocked
             * as many times as it has been locked.
             */
            lock(): void;
            /**
             * Tries to lock `rec_mutex`. If `rec_mutex` is already locked
             * by another thread, it immediately returns %FALSE. Otherwise
             * it locks `rec_mutex` and returns %TRUE.
             * @returns %TRUE if @rec_mutex could be locked
             */
            trylock(): boolean;
            /**
             * Unlocks `rec_mutex`. If another thread is blocked in a
             * g_rec_mutex_lock() call for `rec_mutex,` it will become unblocked
             * and can lock `rec_mutex` itself.
             *
             * Calling g_rec_mutex_unlock() on a recursive mutex that is not
             * locked by the current thread leads to undefined behaviour.
             */
            unlock(): void;
        }

        /**
         * A `GRegex` is the "compiled" form of a regular expression pattern.
         *
         * `GRegex` implements regular expression pattern matching using syntax and
         * semantics similar to Perl regular expression. See the
         * [PCRE documentation](man:pcrepattern(3)) for the syntax definition.
         *
         * Some functions accept a `start_position` argument, setting it differs
         * from just passing over a shortened string and setting %G_REGEX_MATCH_NOTBOL
         * in the case of a pattern that begins with any kind of lookbehind assertion.
         * For example, consider the pattern "\Biss\B" which finds occurrences of "iss"
         * in the middle of words. ("\B" matches only if the current position in the
         * subject is not a word boundary.) When applied to the string "Mississipi"
         * from the fourth byte, namely "issipi", it does not match, because "\B" is
         * always false at the start of the subject, which is deemed to be a word
         * boundary. However, if the entire string is passed , but with
         * `start_position` set to 4, it finds the second occurrence of "iss" because
         * it is able to look behind the starting point to discover that it is
         * preceded by a letter.
         *
         * Note that, unless you set the %G_REGEX_RAW flag, all the strings passed
         * to these functions must be encoded in UTF-8. The lengths and the positions
         * inside the strings are in bytes and not in characters, so, for instance,
         * "\xc3\xa0" (i.e. "à") is two bytes long but it is treated as a
         * single character. If you set %G_REGEX_RAW the strings can be non-valid
         * UTF-8 strings and a byte is treated as a character, so "\xc3\xa0" is two
         * bytes and two characters long.
         *
         * When matching a pattern, "\n" matches only against a "\n" character in
         * the string, and "\r" matches only a "\r" character. To match any newline
         * sequence use "\R". This particular group matches either the two-character
         * sequence CR + LF ("\r\n"), or one of the single characters LF (linefeed,
         * U+000A, "\n"), VT vertical tab, U+000B, "\v"), FF (formfeed, U+000C, "\f"),
         * CR (carriage return, U+000D, "\r"), NEL (next line, U+0085), LS (line
         * separator, U+2028), or PS (paragraph separator, U+2029).
         *
         * The behaviour of the dot, circumflex, and dollar metacharacters are
         * affected by newline characters, the default is to recognize any newline
         * character (the same characters recognized by "\R"). This can be changed
         * with `G_REGEX_NEWLINE_CR`, `G_REGEX_NEWLINE_LF` and `G_REGEX_NEWLINE_CRLF`
         * compile options, and with `G_REGEX_MATCH_NEWLINE_ANY`,
         * `G_REGEX_MATCH_NEWLINE_CR`, `G_REGEX_MATCH_NEWLINE_LF` and
         * `G_REGEX_MATCH_NEWLINE_CRLF` match options. These settings are also
         * relevant when compiling a pattern if `G_REGEX_EXTENDED` is set, and an
         * unescaped "#" outside a character class is encountered. This indicates
         * a comment that lasts until after the next newline.
         *
         * Creating and manipulating the same `GRegex` structure from different
         * threads is not a problem as `GRegex` does not modify its internal
         * state between creation and destruction, on the other hand `GMatchInfo`
         * is not threadsafe.
         *
         * The regular expressions low-level functionalities are obtained through
         * the excellent [PCRE](http://www.pcre.org/) library written by Philip Hazel.
         */
        class Regex {
            static $gtype: GObject.GType<Regex>;

            // Constructors

            constructor(pattern: string, compile_options: RegexCompileFlags, match_options: RegexMatchFlags);
            _init(...args: any[]): void;

            static ['new'](pattern: string, compile_options: RegexCompileFlags, match_options: RegexMatchFlags): Regex;

            // Static methods

            /**
             * Checks whether `replacement` is a valid replacement string
             * (see g_regex_replace()), i.e. that all escape sequences in
             * it are valid.
             *
             * If `has_references` is not %NULL then `replacement` is checked
             * for pattern references. For instance, replacement text 'foo\n'
             * does not contain references and may be evaluated without information
             * about actual match, but '\0\1' (whole match followed by first
             * subpattern) requires valid #GMatchInfo object.
             * @param replacement the replacement string
             */
            static check_replacement(replacement: string): [boolean, boolean];
            static error_quark(): Quark;
            /**
             * Escapes the nul characters in `string` to "\x00".  It can be used
             * to compile a regex with embedded nul characters.
             *
             * For completeness, `length` can be -1 for a nul-terminated string.
             * In this case the output string will be of course equal to `string`.
             * @param string the string to escape
             * @param length the length of @string
             */
            static escape_nul(string: string, length: number): string;
            /**
             * Escapes the special characters used for regular expressions
             * in `string,` for instance "a.b*c" becomes "a\.b\*c". This
             * function is useful to dynamically generate regular expressions.
             *
             * `string` can contain nul characters that are replaced with "\0",
             * in this case remember to specify the correct length of `string`
             * in `length`.
             * @param string the string to escape
             * @param length the length of @string, in bytes, or -1 if @string is nul-terminated
             */
            static escape_string(string: string, length: number): string;
            /**
             * Scans for a match in `string` for `pattern`.
             *
             * This function is equivalent to g_regex_match() but it does not
             * require to compile the pattern with g_regex_new(), avoiding some
             * lines of code when you need just to do a match without extracting
             * substrings, capture counts, and so on.
             *
             * If this function is to be called on the same `pattern` more than
             * once, it's more efficient to compile the pattern once with
             * g_regex_new() and then use g_regex_match().
             * @param pattern the regular expression
             * @param string the string to scan for matches
             * @param compile_options compile options for the regular expression, or 0
             * @param match_options match options, or 0
             */
            static match_simple(
                pattern: string,
                string: string,
                compile_options: RegexCompileFlags,
                match_options: RegexMatchFlags,
            ): boolean;
            /**
             * Breaks the string on the pattern, and returns an array of
             * the tokens. If the pattern contains capturing parentheses,
             * then the text for each of the substrings will also be returned.
             * If the pattern does not match anywhere in the string, then the
             * whole string is returned as the first token.
             *
             * This function is equivalent to g_regex_split() but it does
             * not require to compile the pattern with g_regex_new(), avoiding
             * some lines of code when you need just to do a split without
             * extracting substrings, capture counts, and so on.
             *
             * If this function is to be called on the same `pattern` more than
             * once, it's more efficient to compile the pattern once with
             * g_regex_new() and then use g_regex_split().
             *
             * As a special case, the result of splitting the empty string ""
             * is an empty vector, not a vector containing a single string.
             * The reason for this special case is that being able to represent
             * an empty vector is typically more useful than consistent handling
             * of empty elements. If you do need to represent empty elements,
             * you'll need to check for the empty string before calling this
             * function.
             *
             * A pattern that can match empty strings splits `string` into
             * separate characters wherever it matches the empty string between
             * characters. For example splitting "ab c" using as a separator
             * "\s*", you will get "a", "b" and "c".
             * @param pattern the regular expression
             * @param string the string to scan for matches
             * @param compile_options compile options for the regular expression, or 0
             * @param match_options match options, or 0
             */
            static split_simple(
                pattern: string,
                string: string,
                compile_options: RegexCompileFlags,
                match_options: RegexMatchFlags,
            ): string[];

            // Methods

            /**
             * Returns the number of capturing subpatterns in the pattern.
             * @returns the number of capturing subpatterns
             */
            get_capture_count(): number;
            /**
             * Returns the compile options that `regex` was created with.
             *
             * Depending on the version of PCRE that is used, this may or may not
             * include flags set by option expressions such as `(?i)` found at the
             * top-level within the compiled pattern.
             * @returns flags from #GRegexCompileFlags
             */
            get_compile_flags(): RegexCompileFlags;
            /**
             * Checks whether the pattern contains explicit CR or LF references.
             * @returns %TRUE if the pattern contains explicit CR or LF references
             */
            get_has_cr_or_lf(): boolean;
            /**
             * Returns the match options that `regex` was created with.
             * @returns flags from #GRegexMatchFlags
             */
            get_match_flags(): RegexMatchFlags;
            /**
             * Returns the number of the highest back reference
             * in the pattern, or 0 if the pattern does not contain
             * back references.
             * @returns the number of the highest back reference
             */
            get_max_backref(): number;
            /**
             * Gets the number of characters in the longest lookbehind assertion in the
             * pattern. This information is useful when doing multi-segment matching using
             * the partial matching facilities.
             * @returns the number of characters in the longest lookbehind assertion.
             */
            get_max_lookbehind(): number;
            /**
             * Gets the pattern string associated with `regex,` i.e. a copy of
             * the string passed to g_regex_new().
             * @returns the pattern of @regex
             */
            get_pattern(): string;
            /**
             * Retrieves the number of the subexpression named `name`.
             * @param name name of the subexpression
             * @returns The number of the subexpression or -1 if @name   does not exists
             */
            get_string_number(name: string): number;
            /**
             * Scans for a match in `string` for the pattern in `regex`.
             * The `match_options` are combined with the match options specified
             * when the `regex` structure was created, letting you have more
             * flexibility in reusing #GRegex structures.
             *
             * Unless %G_REGEX_RAW is specified in the options, `string` must be valid UTF-8.
             *
             * A #GMatchInfo structure, used to get information on the match,
             * is stored in `match_info` if not %NULL. Note that if `match_info`
             * is not %NULL then it is created even if the function returns %FALSE,
             * i.e. you must free it regardless if regular expression actually matched.
             *
             * To retrieve all the non-overlapping matches of the pattern in
             * string you can use g_match_info_next().
             *
             *
             * ```c
             * static void
             * print_uppercase_words (const gchar *string)
             * {
             *   // Print all uppercase-only words.
             *   GRegex *regex;
             *   GMatchInfo *match_info;
             *
             *   regex = g_regex_new ("[A-Z]+", G_REGEX_DEFAULT, G_REGEX_MATCH_DEFAULT, NULL);
             *   g_regex_match (regex, string, 0, &match_info);
             *   while (g_match_info_matches (match_info))
             *     {
             *       gchar *word = g_match_info_fetch (match_info, 0);
             *       g_print ("Found: %s\n", word);
             *       g_free (word);
             *       g_match_info_next (match_info, NULL);
             *     }
             *   g_match_info_free (match_info);
             *   g_regex_unref (regex);
             * }
             * ```
             *
             *
             * `string` is not copied and is used in #GMatchInfo internally. If
             * you use any #GMatchInfo method (except g_match_info_free()) after
             * freeing or modifying `string` then the behaviour is undefined.
             * @param string the string to scan for matches
             * @param match_options match options
             * @returns %TRUE is the string matched, %FALSE otherwise
             */
            match(string: string, match_options: RegexMatchFlags | null): [boolean, MatchInfo | null];
            /**
             * Using the standard algorithm for regular expression matching only
             * the longest match in the string is retrieved. This function uses
             * a different algorithm so it can retrieve all the possible matches.
             * For more documentation see g_regex_match_all_full().
             *
             * A #GMatchInfo structure, used to get information on the match, is
             * stored in `match_info` if not %NULL. Note that if `match_info` is
             * not %NULL then it is created even if the function returns %FALSE,
             * i.e. you must free it regardless if regular expression actually
             * matched.
             *
             * `string` is not copied and is used in #GMatchInfo internally. If
             * you use any #GMatchInfo method (except g_match_info_free()) after
             * freeing or modifying `string` then the behaviour is undefined.
             * @param string the string to scan for matches
             * @param match_options match options
             * @returns %TRUE is the string matched, %FALSE otherwise
             */
            match_all(string: string, match_options: RegexMatchFlags | null): [boolean, MatchInfo | null];
            /**
             * Using the standard algorithm for regular expression matching only
             * the longest match in the `string` is retrieved, it is not possible
             * to obtain all the available matches. For instance matching
             * `"<a> <b> <c>"` against the pattern `"<.*>"`
             * you get `"<a> <b> <c>"`.
             *
             * This function uses a different algorithm (called DFA, i.e. deterministic
             * finite automaton), so it can retrieve all the possible matches, all
             * starting at the same point in the string. For instance matching
             * `"<a> <b> <c>"` against the pattern `"<.*>"`
             * you would obtain three matches: `"<a> <b> <c>"`,
             * `"<a> <b>"` and `"<a>"`.
             *
             * The number of matched strings is retrieved using
             * g_match_info_get_match_count(). To obtain the matched strings and
             * their position you can use, respectively, g_match_info_fetch() and
             * g_match_info_fetch_pos(). Note that the strings are returned in
             * reverse order of length; that is, the longest matching string is
             * given first.
             *
             * Note that the DFA algorithm is slower than the standard one and it
             * is not able to capture substrings, so backreferences do not work.
             *
             * Setting `start_position` differs from just passing over a shortened
             * string and setting %G_REGEX_MATCH_NOTBOL in the case of a pattern
             * that begins with any kind of lookbehind assertion, such as "\b".
             *
             * Unless %G_REGEX_RAW is specified in the options, `string` must be valid UTF-8.
             *
             * A #GMatchInfo structure, used to get information on the match, is
             * stored in `match_info` if not %NULL. Note that if `match_info` is
             * not %NULL then it is created even if the function returns %FALSE,
             * i.e. you must free it regardless if regular expression actually
             * matched.
             *
             * `string` is not copied and is used in #GMatchInfo internally. If
             * you use any #GMatchInfo method (except g_match_info_free()) after
             * freeing or modifying `string` then the behaviour is undefined.
             * @param string the string to scan for matches
             * @param start_position starting index of the string to match, in bytes
             * @param match_options match options
             * @returns %TRUE is the string matched, %FALSE otherwise
             */
            match_all_full(
                string: string[],
                start_position: number,
                match_options: RegexMatchFlags | null,
            ): [boolean, MatchInfo | null];
            /**
             * Scans for a match in `string` for the pattern in `regex`.
             * The `match_options` are combined with the match options specified
             * when the `regex` structure was created, letting you have more
             * flexibility in reusing #GRegex structures.
             *
             * Setting 