/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.whatsNew.reaction;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.whatsNew.reaction.ReactionChecker;
import com.intellij.platform.whatsNew.reaction.ReactionCollector;
import com.intellij.platform.whatsNew.reaction.ReactionType;
import com.intellij.platform.whatsNew.reaction.ReationAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/whatsNew/reaction/FUSReactionChecker;", "Lcom/intellij/platform/whatsNew/reaction/ReactionChecker;", "stateKey", "", "<init>", "(Ljava/lang/String;)V", "onLike", "", "project", "Lcom/intellij/openapi/project/Project;", "place", "onDislike", "putValue", "value", "", "putValue$intellij_platform_whatsNew", "getLikenessState", "Lcom/intellij/platform/whatsNew/reaction/ReactionChecker$State;", "clearLikenessState", "checkState", "", "state", "intellij.platform.whatsNew"})
public final class FUSReactionChecker
implements ReactionChecker {
    @NotNull
    private final String stateKey;

    public FUSReactionChecker(@NotNull String stateKey) {
        Intrinsics.checkNotNullParameter((Object)stateKey, (String)"stateKey");
        this.stateKey = stateKey;
    }

    @Override
    public void onLike(@Nullable Project project, @Nullable String place) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int value = this.getLikenessState() == ReactionChecker.State.Liked ? 0 : 1;
        this.putValue$intellij_platform_whatsNew(value);
        ReactionCollector.INSTANCE.reactedPerformed(project, place, ReactionType.Like, value == 0 ? ReationAction.Unset : ReationAction.Set);
    }

    @Override
    public void onDislike(@Nullable Project project, @Nullable String place) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int value = this.getLikenessState() == ReactionChecker.State.Disliked ? 0 : -1;
        this.putValue$intellij_platform_whatsNew(value);
        ReactionCollector.INSTANCE.reactedPerformed(project, place, ReactionType.Dislike, value == 0 ? ReationAction.Unset : ReationAction.Set);
    }

    public final void putValue$intellij_platform_whatsNew(int value) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        propertiesComponent.setValue(this.stateKey, value, 0);
    }

    private final ReactionChecker.State getLikenessState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        return ReactionChecker.State.Companion.stateByIndex(propertiesComponent.getInt(this.stateKey, 0));
    }

    @Override
    public void clearLikenessState() {
        this.putValue$intellij_platform_whatsNew(0);
    }

    @Override
    public boolean checkState(@NotNull ReactionChecker.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return this.getLikenessState() == state;
    }
}

