/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger.remote;

import com.intellij.jupyter.py.debugger.JupyterEditorSourcePosition;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePositionConverter;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePyStackFrame;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/debugger/remote/JupyterRemoteExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "threadInfo", "Lcom/jetbrains/python/debugger/PyThreadInfo;", "<init>", "(Lcom/jetbrains/python/debugger/PyFrameAccessor;Lcom/jetbrains/python/debugger/PyThreadInfo;)V", "getTopFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteExecutionStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteExecutionStack.kt\ncom/intellij/jupyter/py/debugger/remote/JupyterRemoteExecutionStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1863#2,2:36\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteExecutionStack.kt\ncom/intellij/jupyter/py/debugger/remote/JupyterRemoteExecutionStack\n*L\n26#1:36,2\n*E\n"})
public final class JupyterRemoteExecutionStack
extends XExecutionStack {
    @NotNull
    private final PyFrameAccessor frameAccessor;
    @NotNull
    private final PyThreadInfo threadInfo;

    public JupyterRemoteExecutionStack(@NotNull PyFrameAccessor frameAccessor, @NotNull PyThreadInfo threadInfo) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
        super(threadInfo.getName());
        this.frameAccessor = frameAccessor;
        this.threadInfo = threadInfo;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        JupyterEditorSourcePosition jupyterEditorSourcePosition;
        List list = this.threadInfo.getFrames();
        if (list == null || (list = (PyStackFrameInfo)CollectionsKt.firstOrNull((List)list)) == null) {
            return null;
        }
        List topFrameInfo = list;
        Project project = this.frameAccessor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        JupyterRemotePositionConverter positionConverter = new JupyterRemotePositionConverter();
        PySourcePosition pySourcePosition = topFrameInfo.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"getPosition(...)");
        XSourcePosition xSourcePosition = positionConverter.convertFromPython(pySourcePosition, topFrameInfo.getName());
        if (xSourcePosition != null) {
            XSourcePosition it = xSourcePosition;
            boolean bl = false;
            jupyterEditorSourcePosition = new JupyterEditorSourcePosition(it);
        } else {
            jupyterEditorSourcePosition = null;
        }
        JupyterEditorSourcePosition sourcePosition = jupyterEditorSourcePosition;
        return (XStackFrame)new JupyterRemotePyStackFrame(project2, this.frameAccessor, (PyStackFrameInfo)topFrameInfo, sourcePosition);
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Project project = this.frameAccessor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List stackFrames = new ArrayList();
        List list = this.threadInfo.getFrames();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JupyterEditorSourcePosition jupyterEditorSourcePosition;
                PyStackFrameInfo frameInfo = (PyStackFrameInfo)element$iv;
                boolean bl = false;
                JupyterRemotePositionConverter positionConverter = new JupyterRemotePositionConverter();
                PySourcePosition pySourcePosition = frameInfo.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"getPosition(...)");
                if (positionConverter.convertFromPython(pySourcePosition, frameInfo.getName()) != null) {
                    XSourcePosition it;
                    boolean bl2 = false;
                    jupyterEditorSourcePosition = new JupyterEditorSourcePosition(it);
                } else {
                    jupyterEditorSourcePosition = null;
                }
                JupyterEditorSourcePosition sourcePosition = jupyterEditorSourcePosition;
                Intrinsics.checkNotNull((Object)frameInfo);
                stackFrames.add(new JupyterRemotePyStackFrame(project2, this.frameAccessor, frameInfo, sourcePosition));
            }
        }
        container.addStackFrames(stackFrames, true);
    }
}

