/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.plugins.emojipicker.EmojiSkinTone;
import org.jetbrains.plugins.emojipicker.service.EmojiService;
import org.jetbrains.plugins.emojipicker.ui.EmojiPicker;
import org.jetbrains.plugins.emojipicker.ui.EmojiPickerStyle;
import org.jetbrains.plugins.emojipicker.ui.EmojiSearchField;

public class EmojiSkinTonesPanel
extends JPanel {
    @NlsSafe
    private static final String ITEM_EMOJI = "\ud83d\udd90";
    private final EmojiPickerStyle myStyle;
    private final Map<EmojiSkinTone, Item> myItemMap = new EnumMap<EmojiSkinTone, Item>(EmojiSkinTone.class);
    private final int myItemSize = JBUIScale.scale((int)34);
    private EmojiSkinTone myCurrentSkinTone = EmojiService.getInstance().getCurrentSkinTone();
    private int myFocusedItem = -1;

    EmojiSkinTonesPanel(EmojiPicker emojiPicker, EmojiPickerStyle style) {
        this.myStyle = style;
        this.setVisible(false);
        this.setLayout(new GridBagLayout());
        for (EmojiSkinTone tone : EmojiSkinTone.values()) {
            Item item = new Item(emojiPicker, tone);
            this.myItemMap.put(tone, item);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.myStyle.myBorderColor);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, 0.0, (double)this.getWidth(), (double)this.getHeight(), (Object)6.0);
        g.setColor(this.myStyle.myBackgroundColor);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 1.0, 1.0, (double)(this.getWidth() - 2), (double)(this.getHeight() - 2), (Object)6.0);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myFocusedItem != -1) {
            g.setColor(this.myStyle.myFocusBorderColor);
            RectanglePainter2D.DRAW.paint((Graphics2D)g, 3.0, (double)(this.myFocusedItem * this.myItemSize + 3), (double)(this.myItemSize - 4), (double)(this.myItemSize - 4), (Object)6.0);
        }
    }

    EmojiSkinTone getCurrentSkinTone() {
        return this.myCurrentSkinTone;
    }

    Item getCurrentItem() {
        return this.myItemMap.get((Object)this.myCurrentSkinTone);
    }

    void focusItem(int increment) {
        this.myFocusedItem = (this.myFocusedItem + increment + this.getComponentCount()) % this.getComponentCount();
        this.repaint();
    }

    void setCurrentItemFromFocus() {
        if (this.myFocusedItem < 0) {
            return;
        }
        Component c = this.getComponent(this.myFocusedItem);
        for (Item item : this.myItemMap.values()) {
            if (item.myButton != c) continue;
            this.myCurrentSkinTone = item.myTone;
            return;
        }
    }

    void open(EmojiSearchField searchField) {
        this.myFocusedItem = -1;
        Point center = searchField.getSkinToneIconCenter();
        this.setBounds(searchField.getX() + center.x - this.myItemSize / 2 - 1, searchField.getY() + center.y - this.myItemSize / 2 - 1, this.myItemSize + 2, this.myItemSize * this.myItemMap.size() + 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        this.removeAll();
        this.add((Component)this.myItemMap.get((Object)((Object)this.myCurrentSkinTone)).myButton, gbc);
        for (Map.Entry<EmojiSkinTone, Item> item : this.myItemMap.entrySet()) {
            if (item.getKey() == this.myCurrentSkinTone) continue;
            this.add((Component)item.getValue().myButton, gbc);
        }
        this.doLayout();
        this.setVisible(true);
    }

    class Item {
        private final EmojiSkinTone myTone;
        private final Icon myIcon;
        private final Icon myHoverIcon;
        private final InplaceButton myButton;

        private Item(EmojiPicker emojiPicker, EmojiSkinTone tone) {
            this.myTone = tone;
            this.myIcon = new Icon(false);
            this.myHoverIcon = new Icon(true);
            this.myButton = new InplaceButton(new IconButton("", (javax.swing.Icon)this.myIcon, (javax.swing.Icon)this.myHoverIcon), e -> {
                EmojiSkinTonesPanel.this.myCurrentSkinTone = tone;
                emojiPicker.selectSkinToneFromPanel();
            });
        }

        javax.swing.Icon getIcon(boolean hover) {
            return hover ? this.myHoverIcon : this.myIcon;
        }

        private class Icon
        implements javax.swing.Icon {
            private final boolean myHover;

            private Icon(boolean hover) {
                this.myHover = hover;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                if (this.myHover) {
                    g.setColor(EmojiSkinTonesPanel.this.myStyle.myHoverBackgroundColor);
                    RectanglePainter2D.FILL.paint((Graphics2D)g, (double)x, (double)y, (double)this.getIconWidth(), (double)this.getIconHeight(), (Object)6.0);
                }
                @NlsSafe String emoji = EmojiSkinTonesPanel.ITEM_EMOJI + Item.this.myTone.getStringValue();
                FontMetrics metrics = g.getFontMetrics(EmojiSkinTonesPanel.this.myStyle.myEmojiFont);
                int verticalOffset = metrics.getHeight() / 2 - metrics.getDescent();
                int width = metrics.stringWidth(emoji);
                new TextLayout(emoji, EmojiSkinTonesPanel.this.myStyle.myEmojiFont, ((Graphics2D)g).getFontRenderContext()).draw((Graphics2D)g, (float)x + (float)(this.getIconWidth() - width) / 2.0f, (float)y + (float)this.getIconHeight() / 2.0f + (float)verticalOffset);
            }

            @Override
            public int getIconWidth() {
                return EmojiSkinTonesPanel.this.myItemSize;
            }

            @Override
            public int getIconHeight() {
                return EmojiSkinTonesPanel.this.myItemSize;
            }
        }
    }
}

