/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlSingleSessionModeInspection;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlSingleSessionModeInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "ApplySingleSessionModeFix", "intellij.database.sql.impl"})
public final class SqlSingleSessionModeInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, this, onTheFly){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ SqlSingleSessionModeInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dialect = $dialect;
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o) {
                LocalDataSource dataSource;
                JdbcConsole console;
                if (o == null || !o.isTemporary()) {
                    return;
                }
                if (!this.$dialect.getDbms().isOracle() && !this.$dialect.getDbms().isSqlite()) {
                    return;
                }
                PsiFile file = o.getContainingFile();
                JdbcConsole jdbcConsole = console = JdbcConsoleProvider.getValidConsole((Project)o.getProject(), (VirtualFile)file.getVirtualFile());
                Object object = dataSource = jdbcConsole != null ? jdbcConsole.getDataSource() : null;
                if (dataSource == null || dataSource.isSingleConnection()) {
                    return;
                }
                PsiElement psiElement = this.getTemporaryPsiElement(o);
                if (psiElement == null) {
                    return;
                }
                PsiElement temporaryPsiElement = psiElement;
                ApplySingleSessionModeFix enableSingleSessionModeFix = this.this$0.new ApplySingleSessionModeFix();
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{enableSingleSessionModeFix};
                this.addDescriptor(this.myManager.createProblemDescriptor(temporaryPsiElement, SqlBundle.message((String)"inspection.message.creating.temporary.table.without.single.session", (Object[])new Object[0]), true, ProblemHighlightType.WEAK_WARNING, this.$onTheFly, localQuickFixArray));
            }

            private final PsiElement getTemporaryPsiElement(SqlCreateTableStatement o) {
                return (PsiElement)SqlImplUtil.sqlChildren((PsiElement)((PsiElement)o)).find(arg_0 -> createAnnotationVisitor.1.getTemporaryPsiElement$lambda$1(createAnnotationVisitor.1::getTemporaryPsiElement$lambda$0, arg_0));
            }

            private static final boolean getTemporaryPsiElement$lambda$0(PsiElement it) {
                return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlCommonKeywords.SQL_TEMPORARY) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlCommonKeywords.SQL_TEMP);
            }

            private static final boolean getTemporaryPsiElement$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlSingleSessionModeInspection$ApplySingleSessionModeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "(Lcom/intellij/sql/inspections/SqlSingleSessionModeInspection;)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "", "intellij.database.sql.impl"})
    private final class ApplySingleSessionModeFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"warning.single.session.apply", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            VirtualFile virtualFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            JdbcConsole jdbcConsole = JdbcConsoleProvider.getConsole((Project)descriptor.getPsiElement().getContainingFile().getProject(), (VirtualFile)virtualFile2);
            if (jdbcConsole == null) {
                return;
            }
            JdbcConsole console = jdbcConsole;
            LocalDataSource localDataSource = console.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager((Project)project);
            Collection collection = manager.getActiveConfigurations(dataSource);
            if (collection == null || collection.isEmpty()) {
                dataSource.setSingleConnection(true);
            } else {
                Object[] objectArray = new Object[]{dataSource.getName()};
                int answer = Messages.showYesNoCancelDialog((String)DatabaseBundle.message((String)"DataSourceConfigurable.apply.reconnect", (Object[])objectArray), (String)DatabaseBundle.message((String)"DataSourceConfigurable.apply.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                switch (answer) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        dataSource.setSingleConnection(true);
                        break;
                    }
                    case 0: {
                        dataSource.setSingleConnection(true);
                        SessionsUtil.deactivateDataSourceAsync((Project)project, (LocalDataSource)dataSource, null);
                    }
                }
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

