/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.xml;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorsMappingAllowedMethodsConverter
extends DelimitedListConverter<RequestMethod> {
    private static final String ANY_METHOD = "*";
    private static final EnumSet<RequestMethod> DEFAULT_REQUEST_METHODS = EnumSet.of(RequestMethod.GET, RequestMethod.HEAD, RequestMethod.POST);

    public CorsMappingAllowedMethodsConverter() {
        super(",");
    }

    @Nullable
    protected RequestMethod convertString(@Nullable String string, @NotNull ConvertContext context) {
        String value;
        if (context == null) {
            CorsMappingAllowedMethodsConverter.$$$reportNull$$$0(0);
        }
        if (ANY_METHOD.equals(value = StringUtil.trim((String)string))) {
            return RequestMethod.GET;
        }
        for (RequestMethod method : RequestMethod.values()) {
            if (!method.name().equals(value)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    protected String toString(@Nullable RequestMethod method) {
        return method != null ? method.name() : null;
    }

    protected Object[] getReferenceVariants(@NotNull ConvertContext context, GenericDomValue<? extends List<RequestMethod>> genericDomValue) {
        if (context == null) {
            CorsMappingAllowedMethodsConverter.$$$reportNull$$$0(1);
        }
        return CorsMappingAllowedMethodsConverter.getVariants();
    }

    @NotNull
    public static Object[] getVariants() {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(RequestMethod.values().length);
        for (RequestMethod method : RequestMethod.values()) {
            boolean isEnabledByDefault = DEFAULT_REQUEST_METHODS.contains((Object)method);
            variants.add(LookupElementBuilder.create((String)method.name()).withBoldness(isEnabledByDefault));
        }
        variants.add(LookupElementBuilder.create((String)ANY_METHOD).withTailText(" (all)", true));
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            CorsMappingAllowedMethodsConverter.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Nullable
    protected PsiElement resolveReference(@Nullable RequestMethod method, @NotNull ConvertContext context) {
        if (context == null) {
            CorsMappingAllowedMethodsConverter.$$$reportNull$$$0(3);
        }
        return method != null ? context.getXmlElement() : null;
    }

    protected String getUnresolvedMessage(String value) {
        return SpringMvcBundle.message("cors.mapping.method.unresolved.message", value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/model/xml/CorsMappingAllowedMethodsConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/model/xml/CorsMappingAllowedMethodsConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceVariants";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

