/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DatabaseAuthPanel {
    private final Project myProject;
    private DatabaseConnectionConfig myConfig;
    private final DatabaseConnectionConfig myAccumulator;
    private final DatabaseCredentials myCredentials;
    private JBLabel myAuthLabel;
    private ComboBox<DatabaseAuthProvider> myAuthComboBox;
    private JComponent myAuthPanel;
    private DatabaseAuthProvider.AuthWidget myWidget;
    private JComponent myAddedWidget;
    private Runnable myFieldsListener;
    private UrlEditorModelBase.StateChangeListener myAuthTypeListener;
    private static final Object2BooleanMap<Class<?>> ourLdsOnlyCache = new Object2BooleanOpenHashMap();

    public DatabaseAuthPanel(@NotNull Project project, DatabaseConnectionConfig config, DatabaseCredentials credentials) {
        if (project == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myAccumulator = new LocalDataSource();
        this.myCredentials = credentials;
        this.createAuthBox(config);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myAuthPanel;
        if (jComponent == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Object object = this.myWidget == null ? this.myAuthComboBox : this.myWidget.getPreferredFocusedComponent();
        if (object == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(2);
        }
        return object;
    }

    public void addListeners(Runnable fieldsListener, UrlEditorModelBase.StateChangeListener authTypeListener) {
        this.myFieldsListener = fieldsListener;
        if (this.myWidget != null) {
            this.myWidget.onChanged(this.myFieldsListener);
        }
        this.myAuthTypeListener = authTypeListener;
    }

    private void createAuthBox(DatabaseConnectionConfig config) {
        this.myAuthLabel = new JBLabel(DatabaseBundle.message((String)"authentication.type", (Object[])new Object[0]));
        this.myAuthComboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(new ArrayList<DatabaseAuthProvider>(DatabaseAuthPanel.getApplicable(config)), null));
        this.myAuthComboBox.setRenderer((ListCellRenderer)new SimpleListCellRenderer<DatabaseAuthProvider>(){

            public void customize(@NotNull JList<? extends DatabaseAuthProvider> list, DatabaseAuthProvider value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setText(value == null ? "" : value.getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel$1", "customize"));
            }
        });
        this.myAuthLabel.setLabelFor(this.myAuthComboBox);
        this.myAuthPanel = new JPanel((LayoutManager)new GridLayoutManager(2, 6, (Insets)JBUI.emptyInsets(), -1, -1));
        this.validateAuthPanel();
        this.myAuthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DatabaseAuthProvider item = (DatabaseAuthProvider)DatabaseAuthPanel.this.myAuthComboBox.getSelectedItem();
                if (item != null && e.getStateChange() == 1) {
                    DatabaseAuthPanel.this.applyAuthProvider(item, DatabaseAuthPanel.this.myConfig);
                    if (DatabaseAuthPanel.this.myAuthTypeListener != null) {
                        DatabaseAuthPanel.this.myAuthTypeListener.stateChanged(null);
                    }
                }
            }
        });
    }

    @Nullable
    private DatabaseAuthProvider.AuthWidget initWidget(@NotNull DatabaseAuthProvider provider, @NotNull DatabaseConnectionConfig config) {
        DatabaseAuthProvider.AuthWidget widget;
        if (provider == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(3);
        }
        if (config == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(4);
        }
        if ((widget = provider.createWidget(this.myProject, this.myCredentials, config)) != null) {
            return widget;
        }
        AuthWidgetBuilder builder = DatabaseCoreUiService.getInstance().createAuthWidgetBuilder();
        if (builder == null) {
            return null;
        }
        provider.configureWidget(builder, this.myProject, this.myCredentials, config);
        return builder.build(this.myProject, this.myCredentials, config);
    }

    private void applyAuthProvider(@NotNull DatabaseAuthProvider provider, DatabaseConnectionConfig config) {
        if (provider == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(5);
        }
        if (this.myWidget != null) {
            this.myWidget.save(this.myAccumulator, true);
        }
        this.myWidget = this.initWidget(provider, config);
        if (this.myWidget != null) {
            this.myWidget.reset((DatabaseConnectionPoint)this.myAccumulator, false);
        }
        if (this.myFieldsListener != null && this.myWidget != null) {
            this.myWidget.onChanged(this.myFieldsListener);
        }
        this.validateAuthPanel();
    }

    private void validateAuthPanel() {
        JComponent requiredWidget;
        boolean authIsVisible;
        boolean shouldBeVisible = this.myAuthComboBox.getItemCount() > 1;
        boolean bl = authIsVisible = this.myAuthLabel.getParent() == this.myAuthPanel;
        if (shouldBeVisible && !authIsVisible) {
            this.myAuthPanel.add((Component)this.myAuthLabel, DatabaseUIUtils.createLabelConstraints(0, 0, this.myAuthLabel.getPreferredSize().width));
            this.myAuthPanel.add((Component)this.myAuthComboBox, DatabaseUIUtils.createAlignedConstraints(0, 1, 5, 10));
        } else if (!shouldBeVisible && authIsVisible) {
            this.myAuthPanel.remove((Component)this.myAuthLabel);
            this.myAuthPanel.remove((Component)this.myAuthComboBox);
        }
        JComponent jComponent = requiredWidget = this.myWidget == null ? null : this.myWidget.getComponent();
        if (this.myAddedWidget != null && this.myAddedWidget != requiredWidget) {
            this.myAuthPanel.remove(this.myAddedWidget);
            this.myAddedWidget = null;
        }
        if (requiredWidget != null) {
            this.myAuthPanel.add((Component)requiredWidget, DatabaseUIUtils.createSimpleConstraints(1, 0, 6));
            this.myAddedWidget = requiredWidget;
        }
        this.myAuthPanel.revalidate();
        this.myAuthPanel.repaint();
    }

    public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
        DatabaseAuthProvider item;
        if (config == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(6);
        }
        config.setAuthProviderId(((item = (DatabaseAuthProvider)this.myAuthComboBox.getSelectedItem()) == null ? DatabaseAuthProvider.getDefault((DatabaseConnectionPoint)config.getDataSource()) : item).getId());
        if (this.myWidget != null) {
            this.myWidget.save(config, copyCredentials);
        }
    }

    public void reset(@NotNull DatabaseConnectionConfig config, boolean resetCredentials) {
        if (config == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(7);
        }
        DatabaseAuthProvider provider = this.getAuthProvider((DatabaseConnectionPoint)config);
        this.validateAuthTypes(config, provider);
        if (this.myWidget != null) {
            this.myWidget.reset((DatabaseConnectionPoint)config, resetCredentials);
        }
    }

    @NotNull
    protected DatabaseAuthProvider getAuthProvider(@NotNull DatabaseConnectionPoint point) {
        DatabaseAuthProvider item;
        if (point == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(8);
        }
        DatabaseAuthProvider databaseAuthProvider = (item = DatabaseAuthProvider.get((String)point.getAuthProviderId())) == null ? DatabaseAuthProvider.getDefault((DatabaseConnectionPoint)point.getDataSource()) : item;
        if (databaseAuthProvider == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(9);
        }
        return databaseAuthProvider;
    }

    public void validateAuthTypes(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseAuthProvider provider) {
        if (config == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(10);
        }
        this.myConfig = config;
        ArrayList<DatabaseAuthProvider> applicable = new ArrayList<DatabaseAuthProvider>(DatabaseAuthPanel.getApplicable(config));
        DatabaseAuthProvider sel = (DatabaseAuthProvider)this.myAuthComboBox.getSelectedItem();
        this.myAuthComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(applicable, (Object)sel));
        if (provider != null) {
            sel = provider;
        }
        if (!applicable.contains(sel)) {
            sel = DatabaseAuthProvider.getDefault((DatabaseConnectionPoint)config.getDataSource());
        }
        if (!applicable.contains(sel)) {
            sel = (DatabaseAuthProvider)ContainerUtil.getFirstItem(applicable);
        }
        this.myAuthComboBox.setSelectedItem((Object)sel);
    }

    @NotNull
    public static @Unmodifiable List<DatabaseAuthProvider> getApplicable(@NotNull DatabaseConnectionConfig config) {
        if (config == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(11);
        }
        List applicable = DatabaseAuthProvider.getApplicable((DatabaseConnectionPoint)config.getDataSource());
        List list = config instanceof LocalDataSource ? applicable : ContainerUtil.filter((Collection)applicable, p -> !DatabaseAuthPanel.isOnlyLdsIsSupported(p.getClass()));
        if (list == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.myWidget;
    }

    @NotNull
    public ComboBox<DatabaseAuthProvider> getAuthComboBox() {
        ComboBox<DatabaseAuthProvider> comboBox = this.myAuthComboBox;
        if (comboBox == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(13);
        }
        return comboBox;
    }

    public boolean isNeeded() {
        return this.myAuthComboBox.getItemCount() > 1 || this.myWidget != null;
    }

    private static boolean isOnlyLdsIsSupported(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(14);
        }
        return (Boolean)ourLdsOnlyCache.computeIfAbsent(providerClass, clazz -> {
            Method oldMethod = ReflectionUtil.getMethod((Class)clazz, (String)"createWidget", (Class[])new Class[]{Project.class, DatabaseCredentials.class, LocalDataSource.class});
            return oldMethod != null && !oldMethod.isDefault();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initWidget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyAuthProvider";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAuthProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateAuthTypes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getApplicable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOnlyLdsIsSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

