/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesColumnDescriptorsProvider;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapperKt;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.kubernetes.view.ui.DateTimeUtilitiesKt;
import com.intellij.kubernetes.view.ui.KubernetesTableCellRenderer;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.ColumnInfo;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.common.KubernetesType;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.time.OffsetDateTime;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 B*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0002BCB\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0011H\u0004J\u0018\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0011H\u0004J/\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u00112\u0019\u0010\u0018\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0019\u00a2\u0006\u0002\b\u001aH\u0004J;\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u00112%\u0010\u001c\u001a!\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d0\u0019\u00a2\u0006\u0002\b\u001aH\u0004J9\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00112\u001f\u0010 \u001a\u001b\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00160\u0019\u00a2\u0006\u0002\b\u001aH\u0004J/\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u00112\u0019\u0010\"\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0019\u00a2\u0006\u0002\b\u001aH\u0004J/\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u00112\u0019\u0010$\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0019\u00a2\u0006\u0002\b\u001aH\u0004Jd\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u00112\u000b\u0010&\u001a\u00070\u0012\u00a2\u0006\u0002\b'2&\u0010(\u001a\"\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b)\u0012\b\b&\u0012\u0004\b\b(*\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b'0\u00192\u0019\u0010+\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0019\u00a2\u0006\u0002\b\u001aH\u0004JL\u0010,\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0011\"\u0004\b\u0002\u0010-2\u000b\u0010&\u001a\u00070\u0012\u00a2\u0006\u0002\b'2\u001f\u0010.\u001a\u001b\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u0002H-\u0018\u00010\u00160\u0019\u00a2\u0006\u0002\b\u001aH\u0004J\u001a\u00106\u001a\u00070\u0012\u00a2\u0006\u0002\b'2\u0006\u00107\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\u001e\u0010<\u001a\u0002092\u0006\u0010:\u001a\u00020;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016J+\u0010@\u001a\u0002092\u0006\u00107\u001a\u00028\u00002\u0006\u0010:\u001a\u00020;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016\u00a2\u0006\u0002\u0010AR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010/\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b0*\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0016\u00103\u001a\u00070\u0012\u00a2\u0006\u0002\b08F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006D"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "Lcom/intellij/kubernetes/view/mappers/KubernetesColumnDescriptorsProvider;", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesEntity;)V", "getEntity", "()Lcom/intellij/kubernetes/api/KubernetesEntity;", "resourceClass", "Lkotlin/reflect/KClass;", "getResourceClass", "()Lkotlin/reflect/KClass;", "addNameField", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "", "addAgeField", "Ljava/time/OffsetDateTime;", "addLabelsField", "", "addStatusField", "getStatus", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addCapacityField", "getCapacity", "", "Lio/kubernetes/client/custom/Quantity;", "addAccessModesField", "getAccessModes", "addStorageClassField", "getStorageClass", "addReasonField", "getReason", "addTimestampField", "name", "Lorg/jetbrains/annotations/Nls;", "getTooltipText", "Lkotlin/ParameterName;", "isoTimestamp", "getTimestamp", "addMultilineField", "Aspect", "getValueFromResource", "rootDirectoryName", "Lorg/jetbrains/annotations/NonNls;", "getRootDirectoryName", "(Lio/kubernetes/client/common/KubernetesObject;)Ljava/lang/String;", "directoryName", "getDirectoryName", "()Ljava/lang/String;", "getResourceDisplayableName", "resource", "isAccepted", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "mayBeInList", "getApiModel", "Lkotlin/Function0;", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "isAcceptedFor", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;Lkotlin/jvm/functions/Function0;)Z", "Companion", "ColumnDescriptor", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper\n+ 2 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion\n*L\n1#1,208:1\n172#2,5:209\n172#2,5:214\n172#2,5:219\n172#2,5:224\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper\n*L\n71#1:209,5\n74#1:214,5\n83#1:219,5\n86#1:224,5\n*E\n"})
public abstract class KubernetesResourceMapper<T extends KubernetesObject, L extends KubernetesListObject>
implements KubernetesColumnDescriptorsProvider<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesEntity<T, L> entity;
    @NotNull
    private static final Map<KubernetesEntity<?, ?>, Function0<KubernetesResourceMapper<?, ?>>> mappersByEntity = new LinkedHashMap();

    public KubernetesResourceMapper(@NotNull KubernetesEntity<T, L> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        this.entity = entity;
    }

    @NotNull
    public final KubernetesEntity<T, L> getEntity() {
        return this.entity;
    }

    @NotNull
    public final KClass<T> getResourceClass() {
        return this.entity.getType();
    }

    @NotNull
    protected final ColumnDescriptor<T, String> addNameField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.nameField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new ColumnDescriptor(string, Reflection.getOrCreateKotlinClass(String.class), SortOrder.ASCENDING, FileNameComparator.getInstance(), null, null, null, KubernetesResourceMapper::addNameField$lambda$0, 112, null);
    }

    @NotNull
    protected final ColumnDescriptor<T, OffsetDateTime> addAgeField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.ageField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addTimestampField(string, (Function1<String, String>)((Function1)KubernetesResourceMapper::addAgeField$lambda$0), KubernetesResourceMapper::addAgeField$lambda$1);
    }

    @NotNull
    protected final ColumnDescriptor<T, Iterable<?>> addLabelsField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.labelsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addMultilineField(string, KubernetesResourceMapper::addLabelsField$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addStatusField(@NotNull Function1<? super T, String> getStatus) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getStatus, (String)"getStatus");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.statusField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = arg_0 -> KubernetesResourceMapper.addStatusField$lambda$0(getStatus, arg_0);
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addCapacityField(@NotNull Function1<? super T, ? extends Map<String, ? extends Quantity>> getCapacity) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getCapacity, (String)"getCapacity");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.capacityField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = arg_0 -> KubernetesResourceMapper.addCapacityField$lambda$0(getCapacity, arg_0);
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    @NotNull
    protected final ColumnDescriptor<T, Iterable<?>> addAccessModesField(@NotNull Function1<? super T, ? extends Iterable<String>> getAccessModes) {
        Intrinsics.checkNotNullParameter(getAccessModes, (String)"getAccessModes");
        String string = KubernetesBundle.message("KubernetesResourceMapper.accessModesField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addMultilineField(string, arg_0 -> KubernetesResourceMapper.addAccessModesField$lambda$0(getAccessModes, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addStorageClassField(@NotNull Function1<? super T, String> getStorageClass) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getStorageClass, (String)"getStorageClass");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.storageClassField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = arg_0 -> KubernetesResourceMapper.addStorageClassField$lambda$0(getStorageClass, arg_0);
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addReasonField(@NotNull Function1<? super T, String> getReason) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getReason, (String)"getReason");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.reasonField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = arg_0 -> KubernetesResourceMapper.addReasonField$lambda$0(getReason, arg_0);
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    @NotNull
    protected final ColumnDescriptor<T, OffsetDateTime> addTimestampField(@NotNull String name, @NotNull Function1<? super String, String> getTooltipText, @NotNull Function1<? super T, OffsetDateTime> getTimestamp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(getTooltipText, (String)"getTooltipText");
        Intrinsics.checkNotNullParameter(getTimestamp, (String)"getTimestamp");
        return new ColumnDescriptor(name, Reflection.getOrCreateKotlinClass(OffsetDateTime.class), null, null, new KubernetesTableCellRenderer(getTooltipText){
            final /* synthetic */ Function1<String, String> $getTooltipText;
            {
                this.$getTooltipText = $getTooltipText;
            }

            protected void setValue(JBTextArea $this$setValue, Object value2, int row) {
                Intrinsics.checkNotNullParameter((Object)$this$setValue, (String)"<this>");
                OffsetDateTime offsetDateTime = value2 instanceof OffsetDateTime ? (OffsetDateTime)value2 : null;
                if (offsetDateTime == null) {
                    return;
                }
                OffsetDateTime timestamp = offsetDateTime;
                $this$setValue.setText(DateTimeUtilitiesKt.formatAge$default(timestamp, null, 1, null));
                $this$setValue.setToolTipText((String)this.$getTooltipText.invoke((Object)DateTimeUtilitiesKt.formatISO(timestamp)));
            }
        }, null, null, getTimestamp, 108, null);
    }

    @NotNull
    protected final <Aspect> ColumnDescriptor<T, Iterable<?>> addMultilineField(@NotNull String name, @NotNull Function1<? super T, ? extends Iterable<? extends Aspect>> getValueFromResource) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(getValueFromResource, (String)"getValueFromResource");
        KubernetesTableCellRenderer singleLineRenderer2 = new KubernetesTableCellRenderer(){

            protected void setValue(JBTextArea $this$setValue, Object value2, int row) {
                Iterable iterable;
                Intrinsics.checkNotNullParameter((Object)$this$setValue, (String)"<this>");
                Iterable iterable2 = iterable = value2 instanceof Iterable ? (Iterable)value2 : null;
                $this$setValue.setText(iterable2 != null ? CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)"", null, null, (int)1, null, null, (int)54, null) : null);
                Iterable iterable3 = iterable;
                $this$setValue.setToolTipText(iterable3 != null ? CollectionsKt.joinToString$default((Iterable)iterable3, (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null) : null);
            }
        };
        KubernetesTableCellRenderer multiLineRenderer2 = new KubernetesTableCellRenderer(){

            protected void setValue(JBTextArea $this$setValue, Object value2, int row) {
                Intrinsics.checkNotNullParameter((Object)$this$setValue, (String)"<this>");
                Iterable iterable = value2 instanceof Iterable ? (Iterable)value2 : null;
                $this$setValue.setText(iterable != null ? CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null);
                $this$setValue.setToolTipText(null);
            }
        };
        return new ColumnDescriptor(name, Reflection.getOrCreateKotlinClass(Iterable.class), null, null, singleLineRenderer2, multiLineRenderer2, null, getValueFromResource, 76, null);
    }

    @Nullable
    public String getRootDirectoryName(@NotNull T $this$rootDirectoryName) {
        Intrinsics.checkNotNullParameter($this$rootDirectoryName, (String)"<this>");
        return null;
    }

    @NotNull
    public final String getDirectoryName() {
        return this.entity.getResource();
    }

    @NotNull
    public String getResourceDisplayableName(@NotNull T resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Object[] objectArray = new Object[]{this.entity.getDisplayableKind(), resource.getMetadata().getName()};
        String string = KubernetesBundle.message("KubernetesResourceMapper.resourceDisplayableName.template", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return Intrinsics.areEqual((Object)navigationData.getKind(), (Object)this.entity.getKind());
    }

    public boolean mayBeInList(@NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<? extends KubernetesApiModelInterface> getApiModel) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        return true;
    }

    public boolean isAcceptedFor(@NotNull T resource, @NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<? extends KubernetesApiModelInterface> getApiModel) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        return Intrinsics.areEqual((Object)((KubernetesType)resource).getKind(), (Object)navigationData.getKind()) && Intrinsics.areEqual((Object)resource.getMetadata().getName(), (Object)navigationData.getName());
    }

    private static final String addNameField$lambda$0(KubernetesObject $this$ColumnDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$ColumnDescriptor, (String)"$this$ColumnDescriptor");
        V1ObjectMeta v1ObjectMeta = $this$ColumnDescriptor.getMetadata();
        return v1ObjectMeta != null ? v1ObjectMeta.getName() : null;
    }

    private static final String addAgeField$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it};
        String string = KubernetesBundle.message("KubernetesResourceMapper.ageField.tooltip.template", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final OffsetDateTime addAgeField$lambda$1(KubernetesObject $this$addTimestampField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTimestampField, (String)"$this$addTimestampField");
        V1ObjectMeta v1ObjectMeta = $this$addTimestampField.getMetadata();
        return v1ObjectMeta != null ? v1ObjectMeta.getCreationTimestamp() : null;
    }

    private static final Iterable addLabelsField$lambda$0(KubernetesObject $this$addMultilineField) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getMetadata();
        return object != null && (object = object.getLabels()) != null ? KubernetesResourceMapperKt.getIterable((Map<String, String>)object) : null;
    }

    private static final String addStatusField$lambda$0(Function1 $getStatus, KubernetesObject $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        return (String)$getStatus.invoke((Object)$this$simple);
    }

    private static final String addCapacityField$lambda$0(Function1 $getCapacity, KubernetesObject $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        Map map2 = (Map)$getCapacity.invoke((Object)$this$simple);
        return map2 != null && (map2 = (Quantity)map2.get("storage")) != null ? map2.toSuffixedString() : null;
    }

    private static final Iterable addAccessModesField$lambda$0(Function1 $getAccessModes, KubernetesObject $this$addMultilineField) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Iterable iterable = (Iterable)$getAccessModes.invoke((Object)$this$addMultilineField);
        return iterable != null ? CollectionsKt.sorted((Iterable)iterable) : null;
    }

    private static final String addStorageClassField$lambda$0(Function1 $getStorageClass, KubernetesObject $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        return (String)$getStorageClass.invoke((Object)$this$simple);
    }

    private static final String addReasonField$lambda$0(Function1 $getReason, KubernetesObject $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        return (String)$getReason.invoke((Object)$this$simple);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (*\u0004\b\u0002\u0010\u0001*\b\b\u0003\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001(B\u0087\u0001\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u001c\b\u0002\u0010\f\u001a\u0016\u0012\u0004\u0012\u00028\u0003\u0018\u00010\rj\n\u0012\u0004\u0012\u00028\u0003\u0018\u0001`\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0019\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010#\u001a\u0004\u0018\u00018\u00032\u0006\u0010$\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010%J\f\u0010&\u001a\u0006\u0012\u0002\b\u00030'H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR%\u0010\f\u001a\u0016\u0012\u0004\u0012\u00028\u0003\u0018\u00010\rj\n\u0012\u0004\u0012\u00028\u0003\u0018\u0001`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R!\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "Item", "Aspect", "", "Lcom/intellij/util/ui/ColumnInfo;", "name", "", "Lorg/jetbrains/annotations/Nls;", "columnClass", "Lkotlin/reflect/KClass;", "sortOrder", "Ljavax/swing/SortOrder;", "viewComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "singleLineRenderer", "Ljavax/swing/table/TableCellRenderer;", "multiLineRenderer", "singleLineColumnMaxWidth", "", "getValue", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Lkotlin/reflect/KClass;Ljavax/swing/SortOrder;Ljava/util/Comparator;Ljavax/swing/table/TableCellRenderer;Ljavax/swing/table/TableCellRenderer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getSortOrder", "()Ljavax/swing/SortOrder;", "getViewComparator", "()Ljava/util/Comparator;", "getSingleLineRenderer", "()Ljavax/swing/table/TableCellRenderer;", "getMultiLineRenderer", "getSingleLineColumnMaxWidth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "valueOf", "item", "(Ljava/lang/Object;)Ljava/lang/Object;", "getColumnClass", "Ljava/lang/Class;", "Companion", "intellij.clouds.kubernetes"})
    public static final class ColumnDescriptor<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final KClass<Aspect> columnClass;
        @Nullable
        private final SortOrder sortOrder;
        @Nullable
        private final Comparator<Aspect> viewComparator;
        @NotNull
        private final TableCellRenderer singleLineRenderer;
        @NotNull
        private final TableCellRenderer multiLineRenderer;
        @Nullable
        private final Integer singleLineColumnMaxWidth;
        @NotNull
        private final Function1<Item, Aspect> getValue;

        public ColumnDescriptor(@NotNull String name, @NotNull KClass<Aspect> columnClass, @Nullable SortOrder sortOrder, @Nullable Comparator<Aspect> viewComparator, @NotNull TableCellRenderer singleLineRenderer2, @NotNull TableCellRenderer multiLineRenderer2, @Nullable Integer singleLineColumnMaxWidth, @NotNull Function1<? super Item, ? extends Aspect> getValue2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columnClass, (String)"columnClass");
            Intrinsics.checkNotNullParameter((Object)singleLineRenderer2, (String)"singleLineRenderer");
            Intrinsics.checkNotNullParameter((Object)multiLineRenderer2, (String)"multiLineRenderer");
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            super(name);
            this.columnClass = columnClass;
            this.sortOrder = sortOrder;
            this.viewComparator = viewComparator;
            this.singleLineRenderer = singleLineRenderer2;
            this.multiLineRenderer = multiLineRenderer2;
            this.singleLineColumnMaxWidth = singleLineColumnMaxWidth;
            this.getValue = getValue2;
        }

        public /* synthetic */ ColumnDescriptor(String string, KClass kClass, SortOrder sortOrder, Comparator comparator2, TableCellRenderer tableCellRenderer, TableCellRenderer tableCellRenderer2, Integer n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                sortOrder = null;
            }
            if ((n2 & 8) != 0) {
                comparator2 = null;
            }
            if ((n2 & 0x10) != 0) {
                tableCellRenderer = new KubernetesTableCellRenderer();
            }
            if ((n2 & 0x20) != 0) {
                tableCellRenderer2 = tableCellRenderer;
            }
            if ((n2 & 0x40) != 0) {
                n = null;
            }
            this(string, kClass, sortOrder, comparator2, tableCellRenderer, tableCellRenderer2, n, function1);
        }

        @Nullable
        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Nullable
        public final Comparator<Aspect> getViewComparator() {
            return this.viewComparator;
        }

        @NotNull
        public final TableCellRenderer getSingleLineRenderer() {
            return this.singleLineRenderer;
        }

        @NotNull
        public final TableCellRenderer getMultiLineRenderer() {
            return this.multiLineRenderer;
        }

        @Nullable
        public final Integer getSingleLineColumnMaxWidth() {
            return this.singleLineColumnMaxWidth;
        }

        @Nullable
        public Aspect valueOf(Item item) {
            return (Aspect)this.getValue.invoke(item);
        }

        @NotNull
        public Class<?> getColumnClass() {
            return JvmClassMappingKt.getJavaClass(this.columnClass);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0004\u0010\u0006*\u00020\b\"\n\b\u0005\u0010\u0007\u0018\u0001*\u00020\u00012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u001b\b\b\u0010\f\u001a\u0015\u0012\u0004\u0012\u0002H\u0006\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\r\u00a2\u0006\u0002\b\u000eH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion;", "", "<init>", "()V", "simple", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "Item", "Aspect", "Lio/kubernetes/client/common/KubernetesObject;", "name", "", "Lorg/jetbrains/annotations/Nls;", "getValue", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "intellij.clouds.kubernetes"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <Item extends KubernetesObject, Aspect> ColumnDescriptor<Item, Aspect> simple(String name, Function1<? super Item, ? extends Aspect> getValue2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
                boolean $i$f$simple = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"Aspect");
                return new ColumnDescriptor(name, Reflection.getOrCreateKotlinClass(Object.class), null, null, null, null, null, getValue2, 124, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u001a\u0010\n\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\f0\u000bJH\u0010\r\u001a\u00020\u000e\"\b\b\u0002\u0010\u000f*\u00020\u0010\"\b\b\u0003\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00110\u00062\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00110\b0\u0007R0\u0010\u0004\u001a$\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$Companion;", "", "<init>", "()V", "mappersByEntity", "", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "Lkotlin/Function0;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "find", "predicate", "Lkotlin/Function1;", "", "registerMapper", "", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "entity", "lazyMapper", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesResourceMapper<?, ?> find(@NotNull Function1<? super KubernetesEntity<?, ?>, Boolean> predicate) {
            Function0 function0;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                Iterable iterable = mappersByEntity.entrySet();
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    if (!((Boolean)predicate.invoke(it.getKey())).booleanValue()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry != null && (function0 = (Function0)entry.getValue()) != null ? (KubernetesResourceMapper)function0.invoke() : null;
        }

        public final <T extends KubernetesObject, L extends KubernetesListObject> void registerMapper(@NotNull KubernetesEntity<T, L> entity, @NotNull Function0<? extends KubernetesResourceMapper<T, L>> lazyMapper) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter(lazyMapper, (String)"lazyMapper");
            mappersByEntity.put(entity, lazyMapper);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

