/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSpringModelImpl
extends XmlSpringModel {
    @NotNull
    private final Set<XmlFile> myConfigFiles;

    public XmlSpringModelImpl(@NotNull Set<XmlFile> configFiles, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (configFiles == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(1);
        }
        super(module, fileSet);
        this.myConfigFiles = configFiles;
    }

    @NotNull
    public Set<CommonSpringModel> getRelatedModels(boolean checkActiveProfiles) {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        models.addAll(this.getLocalSpringModels());
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    public Set<LocalXmlModel> getLocalSpringModels() {
        SpringFileSet fileSet = this.getFileSet();
        Set activeProfiles = fileSet == null ? this.getActiveProfiles() : fileSet.getActiveProfiles();
        return new LinkedHashSet<LocalXmlModel>(ContainerUtil.mapNotNull(this.getXmlConfigFiles(), xmlFile -> SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(xmlFile, this.getModule(), activeProfiles)));
    }

    @NotNull
    public Set<XmlFile> getXmlConfigFiles() {
        Set<XmlFile> set = this.myConfigFiles;
        if (set == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    private boolean hasImportedConfigs(final @NotNull XmlFile file) {
        if (file == null) {
            XmlSpringModelImpl.$$$reportNull$$$0(4);
        }
        CommonProcessors.FindProcessor<CommonSpringModel> findProcessor2 = new CommonProcessors.FindProcessor<CommonSpringModel>(this){

            protected boolean accept(CommonSpringModel model) {
                return model instanceof LocalXmlModel && ((XmlFile)((LocalXmlModel)model).getConfig()).equals((Object)file);
            }
        };
        for (LocalXmlModel model : this.getLocalSpringModels()) {
            if (SpringModelVisitors.visitRecursionAwareRelatedModels((CommonSpringModel)model, (CommonSpringModelVisitorContext)CommonSpringModelVisitorContext.context((Processor)findProcessor2, (m, p) -> p.process((Object)m)))) continue;
            return true;
        }
        return false;
    }

    public Set<DomFileElement<Beans>> getLocalModelsRoots() {
        Set<LocalXmlModel> localModels = this.getLocalSpringModels();
        LinkedHashSet<DomFileElement<Beans>> set = new LinkedHashSet<DomFileElement<Beans>>(localModels.size());
        for (LocalXmlModel localXmlModel : localModels) {
            DomFileElement root = localXmlModel.getRoot();
            ContainerUtil.addIfNotNull(set, (Object)root);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/XmlSpringModelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/XmlSpringModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModels";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasImportedConfigs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

