/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings.state;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerSecretState;", "", "<init>", "()V", "saveConfiguredSettings", "", "config", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "saveManagedSettings", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "getUpdateManagedSettings", "getUpdateConfiguredSettings", "removeConfiguredSecret", "configId", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "getPasswordCredentials", "Lcom/intellij/credentialStore/CredentialAttributes;", "getTokenCredentials", "intellij.jupyter.core"})
public final class JupyterServerSecretState {
    @NotNull
    public static final JupyterServerSecretState INSTANCE = new JupyterServerSecretState();

    private JupyterServerSecretState() {
    }

    public final void saveConfiguredSettings(@NotNull JupyterConfiguredServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Credentials password = new Credentials(null, config.getPassword().toString());
        PasswordSafe.Companion.getInstance().set(this.getPasswordCredentials(config), password);
        Credentials token = new Credentials(null, config.getToken());
        PasswordSafe.Companion.getInstance().set(this.getTokenCredentials(config), token);
    }

    public final void saveManagedSettings(@NotNull JupyterManagedServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Credentials password = new Credentials(null, config.getPassword().toString());
        PasswordSafe.Companion.getInstance().set(this.getPasswordCredentials(config), password);
    }

    @NotNull
    public final JupyterManagedServerConfig getUpdateManagedSettings(@NotNull JupyterManagedServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Credentials passwordCredentials = PasswordSafe.Companion.getInstance().get(this.getPasswordCredentials(config));
        Object object = passwordCredentials;
        if (object == null || (object = object.getPassword()) == null || (object = object.toString(false)) == null) {
            object = "";
        }
        Object password = object;
        return JupyterManagedServerConfig.copy$default(config, null, null, null, null, null, (String)password, 31, null);
    }

    @NotNull
    public final JupyterConfiguredServerConfig getUpdateConfiguredSettings(@NotNull JupyterConfiguredServerConfig config) {
        Credentials passwordCredentials;
        Object object;
        Object token;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Credentials tokenCredentials = PasswordSafe.Companion.getInstance().get(this.getTokenCredentials(config));
        Object object2 = tokenCredentials;
        if (object2 == null || (object2 = object2.getPassword()) == null || (object2 = object2.toString(true)) == null) {
            object2 = token = "";
        }
        if ((object = (passwordCredentials = PasswordSafe.Companion.getInstance().get(this.getPasswordCredentials(config)))) == null || (object = object.getPassword()) == null || (object = object.toString(true)) == null) {
            object = "";
        }
        Object password = object;
        return JupyterConfiguredServerConfig.copy$default(config, null, null, null, null, (String)token, (String)password, null, false, false, 463, null);
    }

    public final void removeConfiguredSecret(@NotNull JupyterServerConfig configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        PasswordSafe.Companion.getInstance().set(this.getPasswordCredentials(configId), null);
        PasswordSafe.Companion.getInstance().set(this.getTokenCredentials(configId), null);
    }

    private final CredentialAttributes getPasswordCredentials(JupyterServerConfig $this$getPasswordCredentials) {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"Jupyter", (String)($this$getPasswordCredentials.getId() + " password"));
        return new CredentialAttributes(serviceName);
    }

    private final CredentialAttributes getTokenCredentials(JupyterServerConfig $this$getTokenCredentials) {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"Jupyter", (String)($this$getTokenCredentials.getId() + " token"));
        return new CredentialAttributes(serviceName);
    }
}

