/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui;

import com.intellij.openapi.project.Project;
import com.intellij.re.msg.ReBundle;
import com.intellij.re.ui.AttrMappingType;
import com.intellij.re.ui.AttributeCellEditor;
import com.intellij.re.ui.AttributeCellRenderer;
import com.intellij.re.ui.DbColumnTreeNode;
import com.intellij.re.ui.bulk.RelationPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/re/ui/AttributeInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "relationPanel", "Lcom/intellij/re/ui/bulk/RelationPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/re/ui/bulk/RelationPanel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "valueOf", "item", "isCellEditable", "", "getEditor", "Ljavax/swing/table/TableCellEditor;", "isSingleSelectionOption", "Lcom/intellij/re/ui/DbColumnTreeNode;", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "setValue", "", "value", "intellij.javaee.reverseEngineering"})
public final class AttributeInfo
extends ColumnInfo<DefaultMutableTreeNode, Object> {
    @NotNull
    private final Project project;
    @Nullable
    private final RelationPanel relationPanel;

    public AttributeInfo(@NotNull Project project, @Nullable RelationPanel relationPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(ReBundle.message("column.name.attribute", new Object[0]));
        this.project = project;
        this.relationPanel = relationPanel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public Object valueOf(@Nullable DefaultMutableTreeNode item) {
        if (item instanceof DbColumnTreeNode) {
            Object object = ((DbColumnTreeNode)((Object)item)).getSuitableParentAttribute();
            if (object == null && (object = ((DbColumnTreeNode)((Object)item)).getAttributeName()) == null) {
                object = ((DbColumnTreeNode)((Object)item)).getAttribute();
            }
            return object;
        }
        return null;
    }

    public boolean isCellEditable(@Nullable DefaultMutableTreeNode item) {
        DbColumnTreeNode dbColumnTreeNode = item instanceof DbColumnTreeNode ? (DbColumnTreeNode)((Object)item) : null;
        return (dbColumnTreeNode != null ? dbColumnTreeNode.isEnabled() : false) && (!this.isSingleSelectionOption((DbColumnTreeNode)((Object)item)) || ((DbColumnTreeNode)((Object)item)).getSuitableParentAttribute() == null) && ((DbColumnTreeNode)((Object)item)).getAttrMappingType() != AttrMappingType.IdClass;
    }

    @Nullable
    public TableCellEditor getEditor(@Nullable DefaultMutableTreeNode item) {
        TableCellEditor tableCellEditor;
        if (item instanceof DbColumnTreeNode) {
            if (((DbColumnTreeNode)((Object)item)).getSuitableParentAttribute() == null && this.isSingleSelectionOption((DbColumnTreeNode)((Object)item))) {
                DefaultCellEditor defaultCellEditor;
                DefaultCellEditor $this$getEditor_u24lambda_u240 = defaultCellEditor = new DefaultCellEditor((JTextField)new JBTextField());
                boolean bl = false;
                $this$getEditor_u24lambda_u240.setClickCountToStart(1);
                tableCellEditor = defaultCellEditor;
            } else {
                tableCellEditor = new AttributeCellEditor((DbColumnTreeNode)((Object)item), this.project, this.relationPanel);
            }
        } else {
            tableCellEditor = null;
        }
        return tableCellEditor;
    }

    private final boolean isSingleSelectionOption(DbColumnTreeNode item) {
        if (item == null) {
            return false;
        }
        int newAttr = !item.getAttribute().isId() || item.getSuitableParentAttribute() == null ? 1 : 0;
        int optionsSize = newAttr + item.getPossibleParentAttributes().size();
        if (item.getSuitableParentAttribute() != null) {
            ++optionsSize;
        }
        return optionsSize == 1;
    }

    @Nullable
    public TableCellRenderer getRenderer(@Nullable DefaultMutableTreeNode item) {
        return item instanceof DbColumnTreeNode ? (TableCellRenderer)((Object)new AttributeCellRenderer()) : null;
    }

    public void setValue(@NotNull DefaultMutableTreeNode item, @Nullable Object value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!(value instanceof String)) break block1;
            DbColumnTreeNode dbColumnTreeNode = item instanceof DbColumnTreeNode ? (DbColumnTreeNode)((Object)item) : null;
            if (dbColumnTreeNode != null) {
                dbColumnTreeNode.setAttributeName((String)value);
            }
        }
    }
}

