/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.RememberCheckBoxState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class LoginForm {
    private JPanel myContentPane;
    private JTextField myHostField;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JTextField myPrivateKeyField;
    private JLabel myPrivateKeyLabel;
    private JLabel myPasswordLabel;
    private JBCheckBox myRememberPasswordCheckbox;
    private JBLabel myPasswordHelpLabel;

    public LoginForm(@NotNull Deployable deployable) {
        if (deployable == null) {
            LoginForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        Credentials credentials = deployable.getCredentials();
        this.myHostField.setText(deployable.getHost() + ":" + deployable.getLiteralPort());
        this.myUsernameField.setText(credentials == null ? "" : credentials.getUserName());
        this.myPasswordField.setText(credentials == null ? null : StringUtil.nullize((String)credentials.getPasswordAsString()));
        this.myRememberPasswordCheckbox.setSelected(PasswordSafe.getInstance().isRememberPasswordByDefault() && !deployable.isPassMemoryOnly());
        if (deployable.getAuthType() == AuthType.KEY_PAIR) {
            this.myPrivateKeyLabel.setVisible(true);
            this.myPrivateKeyField.setVisible(true);
            this.myPrivateKeyField.setText(new File(deployable.getPrivateKeyFile()).getName());
            this.myPasswordLabel.setText(WDBundle.message("login.label.passphrase", new Object[0]));
        } else {
            this.myPrivateKeyLabel.setVisible(false);
            this.myPrivateKeyField.setVisible(false);
            this.myPasswordLabel.setText(WDBundle.message("login.label.password", new Object[0]));
        }
        this.myPasswordHelpLabel.setIcon(AllIcons.General.ContextHelp);
        HelpTooltip helpTooltip = new HelpTooltip().setDescription(WDBundle.message("tooltip.choose.between.saving.password.permanently.or.until.ide.restart", new Object[0]));
        helpTooltip.installOn((JComponent)this.myPasswordHelpLabel);
        if (PasswordSafe.getInstance().isMemoryOnly()) {
            this.myRememberPasswordCheckbox.setVisible(false);
            this.myPasswordHelpLabel.setVisible(false);
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return StringUtil.isEmpty((String)this.myUsernameField.getText()) ? this.myUsernameField : this.myPasswordField;
    }

    public String getUsername() {
        return this.myUsernameField.getText().trim();
    }

    public String getPassword() {
        String password = new String(this.myPasswordField.getPassword());
        return this.isRememberPassword() ? password : StringUtil.nullize((String)password, (boolean)true);
    }

    public boolean isRememberPassword() {
        return this.myRememberPasswordCheckbox.isSelected();
    }

    public void updateRememberPasswordState() {
        RememberCheckBoxState.update((JCheckBox)this.myRememberPasswordCheckbox);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/LoginForm", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JLabel jLabel;
        JPasswordField jPasswordField;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(false);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WDBundle", LoginForm.class).getString("host.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/WDBundle", LoginForm.class).getString("user.name.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", LoginForm.class).getString("password.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostField = jTextField3 = new JTextField();
        ((Component)jTextField3).setEnabled(false);
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUsernameField = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(true);
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPrivateKeyLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WDBundle", LoginForm.class).getString("private.key.label"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myRememberPasswordCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", LoginForm.class).getString("checkbox.save"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPasswordHelpLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jPasswordField);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

