/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.mvstore;

import com.intellij.code.provenance.core.events.storage.dto.ProvenanceEntryDTO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\r*\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u0012H\u0002J\u001b\u0010\u0013\u001a\u00020\r*\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0014*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/code/provenance/core/events/storage/mvstore/ProvenanceEntrySerializer;", "", "<init>", "()V", "VERSION", "", "serialize", "", "dto", "Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "deserialize", "bytes", "writeNullableString", "", "Ljava/io/DataOutputStream;", "value", "", "readNullableString", "Ljava/io/DataInputStream;", "writeNullableLong", "", "(Ljava/io/DataOutputStream;Ljava/lang/Long;)V", "readNullableLong", "(Ljava/io/DataInputStream;)Ljava/lang/Long;", "intellij.code.provenance.core"})
public final class ProvenanceEntrySerializer {
    @NotNull
    public static final ProvenanceEntrySerializer INSTANCE = new ProvenanceEntrySerializer();
    private static final byte VERSION = 1;

    private ProvenanceEntrySerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@NotNull ProvenanceEntryDTO dto) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(byteStream);
            Throwable throwable2 = null;
            try {
                DataOutputStream out = (DataOutputStream)closeable2;
                boolean bl2 = false;
                out.writeByte(1);
                out.writeLong(dto.getTimestamp());
                out.writeUTF(dto.getType());
                out.writeLong(dto.getFileId());
                out.writeUTF(dto.getPayloadBase64());
                out.writeUTF(dto.getExtra());
                INSTANCE.writeNullableString(out, dto.getKind());
                INSTANCE.writeNullableLong(out, dto.getOldContentHash());
                INSTANCE.writeNullableLong(out, dto.getNewContentHash());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = byteStream.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProvenanceEntryDTO deserialize(@NotNull byte[] bytes) {
        ProvenanceEntryDTO provenanceEntryDTO;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Closeable closeable = new ByteArrayInputStream(bytes);
        Throwable throwable = null;
        try {
            ProvenanceEntryDTO provenanceEntryDTO2;
            ByteArrayInputStream byteStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataInputStream(byteStream);
            Throwable throwable2 = null;
            try {
                DataInputStream input = (DataInputStream)closeable2;
                boolean bl2 = false;
                byte version = input.readByte();
                if (version != 1) {
                    throw new IllegalStateException("Unsupported serialization version: " + version);
                }
                long l = input.readLong();
                String string = input.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                long l2 = input.readLong();
                String string2 = input.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readUTF(...)");
                String string3 = input.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readUTF(...)");
                provenanceEntryDTO2 = new ProvenanceEntryDTO(l, string, l2, string2, string3, INSTANCE.readNullableString(input), INSTANCE.readNullableLong(input), INSTANCE.readNullableLong(input));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            provenanceEntryDTO = provenanceEntryDTO2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return provenanceEntryDTO;
    }

    private final void writeNullableString(DataOutputStream $this$writeNullableString, String value) {
        if (value == null) {
            $this$writeNullableString.writeBoolean(false);
        } else {
            $this$writeNullableString.writeBoolean(true);
            $this$writeNullableString.writeUTF(value);
        }
    }

    private final String readNullableString(DataInputStream $this$readNullableString) {
        return $this$readNullableString.readBoolean() ? $this$readNullableString.readUTF() : null;
    }

    private final void writeNullableLong(DataOutputStream $this$writeNullableLong, Long value) {
        if (value == null) {
            $this$writeNullableLong.writeBoolean(false);
        } else {
            $this$writeNullableLong.writeBoolean(true);
            $this$writeNullableLong.writeLong(value);
        }
    }

    private final Long readNullableLong(DataInputStream $this$readNullableLong) {
        return $this$readNullableLong.readBoolean() ? Long.valueOf($this$readNullableLong.readLong()) : null;
    }
}

