/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;

public final class UnusedImportsUtil {
    @ApiStatus.Internal
    public static final Collection<? extends Class<? extends JSQualifiedNamedElement>> REFERENCED_ELEMENTS_CLASSES = Arrays.asList(JSClass.class, JSNamespaceDeclaration.class, JSFunction.class, JSVariable.class);
    private static final Collection<? extends Class<? extends JSQualifiedNamedElement>> QUALIFIED_REFERENCE_NEEDS_IMPORT = Arrays.asList(JSClass.class, JSNamespaceDeclaration.class);

    @ApiStatus.Internal
    public static boolean isInstance(PsiElement element, Collection<? extends Class<?>> classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSomeNodeThatShouldNotHaveImportsWhenQualified(JSReferenceExpression expression, PsiElement element) {
        if (expression.getContainingFile() instanceof JSExpressionCodeFragment) {
            return true;
        }
        Couple<Boolean> pair = UnusedImportsUtil.getReplaceStatus(expression, element);
        return (Boolean)pair.first == false;
    }

    @ApiStatus.Internal
    public static Couple<Boolean> getReplaceStatus(JSReferenceExpression node) {
        return UnusedImportsUtil.getReplaceStatus(node, null);
    }

    private static Couple<Boolean> getReplaceStatus(JSReferenceExpression node, PsiElement resolve) {
        PsiElement element;
        JSFunction funcExpr;
        PsiElement parent = node.getParent();
        if (parent instanceof JSImportStatement) {
            return Couple.of((Object)false, (Object)false);
        }
        if (resolve == null) {
            resolve = JSDialectSpecificHandlersFactory.forElement((PsiElement)node).getClassResolver().findClassByQName(node.getText(), (PsiElement)node);
        }
        if (parent instanceof JSExpressionStatement && !(resolve instanceof JSNamespaceDeclaration)) {
            return Couple.of((Object)false, (Object)false);
        }
        if (parent instanceof JSParameter && (funcExpr = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) instanceof JSFunctionExpression && ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)funcExpr)) {
            return Couple.of((Object)false, (Object)false);
        }
        if (parent instanceof JSReferenceListMember) {
            String className;
            PsiElement listRef = parent.getParent();
            if (JSElementTypes.EXTENDS_LISTS.contains(listRef.getNode().getElementType()) && listRef.getParent() instanceof JSClass && StringUtil.isNotEmpty((String)(className = ((JSClass)listRef.getParent()).getName())) && className.equals(node.getReferencedName())) {
                return Couple.of((Object)true, (Object)false);
            }
            if (listRef.getNode().getElementType() == JSElementTypes.IMPLEMENTS_LIST && node.getContainingFile().getContext() instanceof XmlAttributeValue) {
                return Couple.of((Object)false, (Object)false);
            }
        }
        if ((element = resolve) == null || !UnusedImportsUtil.isInstance(element, REFERENCED_ELEMENTS_CLASSES)) {
            return Couple.of((Object)false, (Object)false);
        }
        JSClass clazz = JSResolveUtil.getClassOfContext((PsiElement)node);
        boolean canBeReplaced = clazz == null || !StringUtil.getShortName((String)node.getText()).equals(clazz.getName()) || clazz == resolve;
        return Couple.of((Object)UnusedImportsUtil.isInstance(element, QUALIFIED_REFERENCE_NEEDS_IMPORT), (Object)canBeReplaced);
    }
}

