/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.remote.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.jpa.remote.GroovyHelper;
import com.intellij.jpa.remote.RemoteEntityManager;
import com.intellij.jpa.remote.RemoteEntityTransaction;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.remote.impl.RemoteEntityTransactionImpl;
import com.intellij.jpa.remote.impl.RemoteQueryImpl;
import java.net.URL;
import java.rmi.RemoteException;
import javax.persistence.EntityManager;

public class RemoteEntityManagerImpl
extends JdbcRemoteObject
implements RemoteEntityManager {
    private final String myUnitName;
    private final EntityManager myDelegate;

    public RemoteEntityManagerImpl(String unitName, EntityManager delegate) {
        this.myUnitName = unitName;
        this.myDelegate = delegate;
    }

    public static RemoteEntityManagerImpl wrap(String unitName, EntityManager delegate) {
        return new RemoteEntityManagerImpl(unitName, delegate);
    }

    @Override
    public boolean isOpen() throws RemoteException {
        try {
            return this.myDelegate.isOpen();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public RemoteQuery createQuery(String s) throws RemoteException {
        try {
            return (RemoteQuery)this.export(RemoteQueryImpl.wrap(this.myDelegate.createQuery(s), this.myDelegate));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public RemoteQuery createNamedQuery(String s) throws RemoteException {
        try {
            return (RemoteQuery)this.export(RemoteQueryImpl.wrap(this.myDelegate.createNamedQuery(s), this.myDelegate));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public RemoteEntityTransaction getTransaction() throws RemoteException {
        try {
            return (RemoteEntityTransaction)this.export(RemoteEntityTransactionImpl.wrap(this.myDelegate.getTransaction()));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public void close() throws RemoteException {
        try {
            this.unexportChildren();
            this.myDelegate.close();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public String generateSql(String s) throws RemoteException {
        return String.valueOf(this.invokeHelper("sql", this.myDelegate, s));
    }

    @Override
    public String generateSchemaScript() throws RemoteException {
        return String.valueOf(this.invokeHelper("ddl", this.myDelegate, this.myUnitName));
    }

    private Object invokeHelper(String method, Object ... args) throws RemoteException {
        try {
            String managerClassName = this.myDelegate.getClass().getName();
            String name = RemoteEntityManagerImpl.getHelperScriptName(managerClassName);
            URL resource = this.getClass().getResource(name);
            if (resource == null) {
                throw new UnsupportedOperationException(managerClassName + " is not supported");
            }
            return GroovyHelper.invokeGroovyMethod(resource, method, args);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    private static String getHelperScriptName(String name) {
        int idx = name.indexOf(46);
        idx = idx < 0 ? idx : name.indexOf(46, idx + 1);
        idx = idx < 0 ? idx : name.indexOf(46, idx + 1);
        String scriptName = idx < 0 ? name : name.substring(0, idx);
        return scriptName + ".script";
    }
}

