/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.el.ELElementVisitor;
import com.intellij.javaee.el.impl.ElBundle;
import com.intellij.javaee.el.psi.ELLiteralExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class ELValidationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ELValidationInspection.$$$reportNull$$$0(0);
        }
        return new ELElementVisitor(){

            @Override
            public void visitELVariable(@NotNull ELVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                ELValidationInspection.this.visitVariable(variable, isOnTheFly, holder);
            }

            @Override
            public void visitELLiteralExpression(@NotNull ELLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                ELValidationInspection.this.visitLiteral(expression, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/el/inspections/ELValidationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void visitLiteral(ELLiteralExpression expression, ProblemsHolder holder) {
        PsiReference[] references = expression.getReferences();
        if (references.length == 0) {
            return;
        }
        PsiReference psiReference = references[0];
        if (!psiReference.isSoft() && psiReference instanceof PsiPolyVariantReference && !ELResolveUtil.isSoftContext(ELResolveUtil.getContext((PsiElement)expression), expression.getContainingFile()) && ((PsiPolyVariantReference)psiReference).multiResolve(false).length == 0 && !ELResolveUtil.isFromInjectedEL(expression)) {
            String message = ElBundle.message("el.cannot.resolve.property", psiReference.getCanonicalText());
            holder.registerProblem((PsiElement)expression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])null);
        }
    }

    public void visitVariable(ELVariable variable, boolean isOnTheFly, ProblemsHolder holder) {
        for (PsiReference reference : variable.getReferences()) {
            this.checkVariableReference(variable, reference, isOnTheFly, holder);
        }
    }

    protected void checkVariableReference(ELVariable variable, PsiReference reference1, boolean isOnTheFly, ProblemsHolder holder) {
        ELReference reference;
        block5: {
            block4: {
                if (!(reference1 instanceof ELReference)) break block4;
                reference = (ELReference)reference1;
                if (!reference1.isSoft()) break block5;
            }
            return;
        }
        ResolveResult[] results = reference.multiResolve(false);
        if (results.length == 0) {
            holder.registerProblem((PsiElement)variable, MessageFormat.format(reference.getUnresolvedMessagePattern(), reference.getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, reference.getQuickFixes());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/el/inspections/ELValidationInspection", "buildVisitor"));
    }
}

