/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSModuleNameInfoImpl
implements JSModuleNameInfo,
JSModuleDescriptor {
    @Nullable
    private final VirtualFile myModule;
    @NotNull
    private final VirtualFile myResolvedFile;
    @NotNull
    private final String myModuleName;
    private final SmartPsiElementPointer<PsiElement> myModulePsi;

    JSModuleNameInfoImpl(@Nullable String unquotedModuleName, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement place) {
        if (resolvedFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(0);
        }
        if (place == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(1);
        }
        this.myModuleName = unquotedModuleName;
        this.myModule = moduleFileOrDirectory;
        this.myResolvedFile = resolvedFile;
        PsiFile psiFile = place.getManager().findFile(moduleFileOrDirectory == null || moduleFileOrDirectory.isDirectory() ? resolvedFile : moduleFileOrDirectory);
        this.myModulePsi = psiFile != null ? SmartPointerManager.createPointer((PsiElement)psiFile) : null;
    }

    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.myModuleName);
    }

    @NotNull
    @NlsSafe
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public VirtualFile getModuleFileOrDirectory() {
        VirtualFile virtualFile = this.myModule == null ? this.getResolvedFile() : this.myModule;
        if (virtualFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public PsiElement getModule() {
        return this.myModulePsi != null ? this.myModulePsi.getElement() : null;
    }

    @NotNull
    public VirtualFile getResolvedFile() {
        VirtualFile virtualFile = this.myResolvedFile;
        if (virtualFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public String toString() {
        return "\"" + this.getModuleName() + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSModuleNameInfoImpl info = (JSModuleNameInfoImpl)o;
        return Objects.equals(this.myModule, info.myModule) && this.myResolvedFile.equals(info.myResolvedFile) && this.myModuleName.equals(info.myModuleName);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myResolvedFile, this.myModuleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleNameInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleNameInfoImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileOrDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

