/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 33096895198223L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-122812590 - -26392, 122812590 - 16925, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-122812590 - -26393, 122812590 - 4621, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 113062233126753L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.l();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1513989570 + (char)-30908, -1513989570 + -((char)-24172), (int)l2) + string + WindowsNamedPipeAgentIpc.b(1513989570 + (char)-30907, -1513989570 + -((char)-19030), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1513989570 + (char)-30914, -1513989570 + -32596, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 62856463160689L;
                Object object = this.lock;
                n2 = SshAgentIpcService.l();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-383248680 - -30777, -383248680 - -27911, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-383248680 - -30778, -383248680 - -((char)-24920), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-383248680 - -30779, 383248680 - (char)-29521, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-383248680 - -30788, 383248680 - (char)-15434, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-383248680 - -30789, -383248680 - -((char)-27351), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-383248680 - -30790, -383248680 - -27366, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-383248680 - -30788, 383248680 - (char)-15434, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-383248680 - -30791, -383248680 - -27851, (int)l2));
            if (ActionTimestamp.P() == null) {
                SshAgentIpcService.P(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 42877445643363L;
                    n3 = SshAgentIpcService.l();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 71303067684289L;
                int n3 = SshAgentIpcService.P();
                this.assertConnectionThread();
                n2 = n3;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7764), -1979419140 - -((char)-7685), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7763), -1979419140 - -((char)-28456), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7762), 1979419140 - (char)-22285, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7764), -1979419140 - -((char)-7685), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7761), 1979419140 - (char)-936, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7764), -1979419140 - -((char)-7685), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7752), 1979419140 - (char)-25734, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7751), 1979419140 - (char)-5735, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7762), 1979419140 - (char)-22285, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7764), -1979419140 - -((char)-7685), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7760), 1979419140 - (char)-29630, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1979419140 - -((char)-7750), -1979419140 - -((char)-20848), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 110015678829342L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-91486860 + -((char)-6587), 91486860 + (char)-4071, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 107214579159863L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(689428200 + 18463, 689428200 + (char)-28836, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "C\u00c1\u008d\u001d@D\u00d1aT\u0093d\u00eb&\u00d6B\u00d2z:\u008b\u0014\u00e9\u00b3\u00d8U\u00f1\u008f\u009a\u009d\u00bf\n\u00dc\f\u00f3\u00d39\u00f9\u00f8\u0099\u00dc\u0006";
                        var4_3 = "C\u00c1\u008d\u001d@D\u00d1aT\u0093d\u00eb&\u00d6B\u00d2z:\u008b\u0014\u00e9\u00b3\u00d8U\u00f1\u008f\u009a\u009d\u00bf\n\u00dc\f\u00f3\u00d39\u00f9\u00f8\u0099\u00dc\u0006".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 116;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 115;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 68;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 49;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 116;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 43;
                                        break;
                                    }
                                    default: {
                                        v11 = 123;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFCC31) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 109;
                            case 1 -> 91;
                            case 2 -> 244;
                            case 3 -> 55;
                            case 4 -> 45;
                            case 5 -> 158;
                            case 6 -> 11;
                            case 7 -> 119;
                            case 8 -> 108;
                            case 9 -> 233;
                            case 10 -> 110;
                            case 11 -> 219;
                            case 12 -> 251;
                            case 13 -> 153;
                            case 14 -> 235;
                            case 15 -> 62;
                            case 16 -> 146;
                            case 17 -> 77;
                            case 18 -> 131;
                            case 19 -> 10;
                            case 20 -> 13;
                            case 21 -> 83;
                            case 22 -> 241;
                            case 23 -> 174;
                            case 24 -> 32;
                            case 25 -> 107;
                            case 26 -> 243;
                            case 27 -> 24;
                            case 28 -> 171;
                            case 29 -> 140;
                            case 30 -> 128;
                            case 31 -> 253;
                            case 32 -> 133;
                            case 33 -> 115;
                            case 34 -> 48;
                            case 35 -> 94;
                            case 36 -> 197;
                            case 37 -> 93;
                            case 38 -> 225;
                            case 39 -> 61;
                            case 40 -> 117;
                            case 41 -> 63;
                            case 42 -> 242;
                            case 43 -> 154;
                            case 44 -> 22;
                            case 45 -> 89;
                            case 46 -> 35;
                            case 47 -> 156;
                            case 48 -> 84;
                            case 49 -> 249;
                            case 50 -> 202;
                            case 51 -> 114;
                            case 52 -> 245;
                            case 53 -> 130;
                            case 54 -> 168;
                            case 55 -> 29;
                            case 56 -> 111;
                            case 57 -> 182;
                            case 58 -> 220;
                            case 59 -> 64;
                            case 60 -> 237;
                            case 61 -> 222;
                            case 62 -> 37;
                            case 63 -> 147;
                            case 64 -> 198;
                            case 65 -> 175;
                            case 66 -> 210;
                            case 67 -> 28;
                            case 68 -> 1;
                            case 69 -> 208;
                            case 70 -> 58;
                            case 71 -> 247;
                            case 72 -> 95;
                            case 73 -> 105;
                            case 74 -> 224;
                            case 75 -> 150;
                            case 76 -> 74;
                            case 77 -> 125;
                            case 78 -> 49;
                            case 79 -> 203;
                            case 80 -> 144;
                            case 81 -> 121;
                            case 82 -> 252;
                            case 83 -> 218;
                            case 84 -> 3;
                            case 85 -> 39;
                            case 86 -> 90;
                            case 87 -> 126;
                            case 88 -> 67;
                            case 89 -> 155;
                            case 90 -> 193;
                            case 91 -> 106;
                            case 92 -> 44;
                            case 93 -> 23;
                            case 94 -> 166;
                            case 95 -> 165;
                            case 96 -> 167;
                            case 97 -> 98;
                            case 98 -> 221;
                            case 99 -> 36;
                            case 100 -> 47;
                            case 101 -> 213;
                            case 102 -> 46;
                            case 103 -> 73;
                            case 104 -> 248;
                            case 105 -> 99;
                            case 106 -> 79;
                            case 107 -> 143;
                            case 108 -> 157;
                            case 109 -> 14;
                            case 110 -> 206;
                            case 111 -> 139;
                            case 112 -> 80;
                            case 113 -> 159;
                            case 114 -> 0;
                            case 115 -> 250;
                            case 116 -> 132;
                            case 117 -> 127;
                            case 118 -> 194;
                            case 119 -> 191;
                            case 120 -> 12;
                            case 121 -> 18;
                            case 122 -> 59;
                            case 123 -> 231;
                            case 124 -> 60;
                            case 125 -> 27;
                            case 126 -> 142;
                            case 127 -> 100;
                            case 128 -> 212;
                            case 129 -> 169;
                            case 130 -> 189;
                            case 131 -> 120;
                            case 132 -> 85;
                            case 133 -> 7;
                            case 134 -> 239;
                            case 135 -> 15;
                            case 136 -> 113;
                            case 137 -> 65;
                            case 138 -> 209;
                            case 139 -> 54;
                            case 140 -> 207;
                            case 141 -> 141;
                            case 142 -> 181;
                            case 143 -> 104;
                            case 144 -> 180;
                            case 145 -> 161;
                            case 146 -> 53;
                            case 147 -> 81;
                            case 148 -> 118;
                            case 149 -> 223;
                            case 150 -> 145;
                            case 151 -> 112;
                            case 152 -> 190;
                            case 153 -> 40;
                            case 154 -> 6;
                            case 155 -> 134;
                            case 156 -> 86;
                            case 157 -> 102;
                            case 158 -> 195;
                            case 159 -> 151;
                            case 160 -> 82;
                            case 161 -> 124;
                            case 162 -> 254;
                            case 163 -> 162;
                            case 164 -> 183;
                            case 165 -> 136;
                            case 166 -> 192;
                            case 167 -> 129;
                            case 168 -> 188;
                            case 169 -> 21;
                            case 170 -> 66;
                            case 171 -> 26;
                            case 172 -> 234;
                            case 173 -> 205;
                            case 174 -> 216;
                            case 175 -> 33;
                            case 176 -> 123;
                            case 177 -> 2;
                            case 178 -> 103;
                            case 179 -> 200;
                            case 180 -> 9;
                            case 181 -> 34;
                            case 182 -> 135;
                            case 183 -> 204;
                            case 184 -> 164;
                            case 185 -> 25;
                            case 186 -> 255;
                            case 187 -> 56;
                            case 188 -> 177;
                            case 189 -> 51;
                            case 190 -> 226;
                            case 191 -> 152;
                            case 192 -> 70;
                            case 193 -> 185;
                            case 194 -> 178;
                            case 195 -> 148;
                            case 196 -> 240;
                            case 197 -> 227;
                            case 198 -> 57;
                            case 199 -> 20;
                            case 200 -> 96;
                            case 201 -> 179;
                            case 202 -> 41;
                            case 203 -> 16;
                            case 204 -> 122;
                            case 205 -> 211;
                            case 206 -> 72;
                            case 207 -> 78;
                            case 208 -> 138;
                            case 209 -> 50;
                            case 210 -> 19;
                            case 211 -> 116;
                            case 212 -> 101;
                            case 213 -> 68;
                            case 214 -> 184;
                            case 215 -> 137;
                            case 216 -> 246;
                            case 217 -> 75;
                            case 218 -> 173;
                            case 219 -> 214;
                            case 220 -> 38;
                            case 221 -> 170;
                            case 222 -> 199;
                            case 223 -> 52;
                            case 224 -> 217;
                            case 225 -> 228;
                            case 226 -> 160;
                            case 227 -> 69;
                            case 228 -> 97;
                            case 229 -> 232;
                            case 230 -> 43;
                            case 231 -> 92;
                            case 232 -> 172;
                            case 233 -> 149;
                            case 234 -> 88;
                            case 235 -> 229;
                            case 236 -> 176;
                            case 237 -> 215;
                            case 238 -> 17;
                            case 239 -> 187;
                            case 240 -> 42;
                            case 241 -> 30;
                            case 242 -> 238;
                            case 243 -> 201;
                            case 244 -> 5;
                            case 245 -> 186;
                            case 246 -> 230;
                            case 247 -> 4;
                            case 248 -> 196;
                            case 249 -> 163;
                            case 250 -> 8;
                            case 251 -> 236;
                            case 252 -> 71;
                            case 253 -> 87;
                            case 254 -> 76;
                            default -> 31;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 == 0) {
                ActionTimestamp.P(new String[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 76106448506505L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.P();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-371976660 + -332, -371976660 + -365, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-371976660 + -328, 371976660 - 11082, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-371976660 + -301, 371976660 - 22441, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-371976660 + -332, -371976660 + -365, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-371976660 + -328, 371976660 - 11082, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-371976660 + -308, 371976660 - 24038, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 86177327864569L;
                        int n3 = SshAgentIpcService.l();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1190902020 + -((char)-31117), 1190902020 + (char)-31385, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1190902020 + -((char)-31118), 1190902020 + (char)-23502, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 133200897243219L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                n2 = SshAgentIpcService.P();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1076477910 + 8804, 1076477910 + 8847, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1076477910 + 8808, -1076477910 - -2086, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1076477910 + 8779, -1076477910 + -13082, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1076477910 + 8808, -1076477910 - -2086, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1076477910 + 8802, -1076477910 - -5209, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1076477910 + 8804, 1076477910 + 8847, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1076477910 + 8808, -1076477910 - -2086, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1076477910 + 8792, -1076477910 + -10263, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1076477910 + 8804, 1076477910 + 8847, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1076477910 + 8808, -1076477910 - -2086, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1076477910 + 8793, -1076477910 + -4975, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1076477910 + 8804, 1076477910 + 8847, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1076477910 + 8808, -1076477910 - -2086, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1076477910 + 8790, -1076477910 + -16317, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 76865160384700L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.P();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1869320340 - -7017, -1869320340 - -6942, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1869320340 - -7013, 1869320340 - 28629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1869320340 - -6998, -1869320340 - -28989, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1869320340 - -7001, -1869320340 - -((char)-31349), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1869320340 - -7017, -1869320340 - -6942, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1869320340 - -7013, 1869320340 - 28629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1869320340 - -7000, 1869320340 - 8965, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1869320340 - -7017, -1869320340 - -6942, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1869320340 - -7013, 1869320340 - 28629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1869320340 - -7003, 1869320340 - 11036, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1869320340 - -7017, -1869320340 - -6942, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1869320340 - -7013, 1869320340 - 28629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1869320340 - -7002, -1869320340 - -((char)-30379), (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1869320340 - -7017, -1869320340 - -6942, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1869320340 - -7013, 1869320340 - 28629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1869320340 - -7053, -1869320340 - -29803, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1869320340 - -7052, 1869320340 - 18818, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "#7\u00c5m\u00c1\u000f\u00faK\u0014J\u0000\u00d0l\u009d\u00a7\u00deD8\u00d2\u00a2 \u0095a\u00a7\u00f0\u00aed\u00be\u0006\u0006\u00c7\u00fbY\u00f48}\u0018\u0095\u0001K|l`\u00e2|w\u00a8D\u001f/y\u00a2q\u00a7=\u00b1\u00b0g\u00f3\u0015%\t3\u00fc\u0001rN>\u00be\u00ff\u00c0\u0005\u00a2r\u00f5\u00c5\u00b7\bGoI\u0017\u0002f\u0084\u0084\u0014\u001a\u008b\u00a2\u0086\u00be\u00f2\u008fy|\u00a8\u0081\u00db\u00bb\u00bd\u00d9\u0086sy\u00fc\u00e7\u0005\u0013\u00de\u00c3Pq\u001e)\u001b\u0091\u008c\u00a6\u00ba\u0019]\u00ad\u0098T\u009eai\u00c9\u0017+`\u00f2\u00ef\u00a37\u0081p\u00c2\u00d1\u00cd\u0085xh\u0010\u0081\u00a5`\u009e\u00cf\u00ca\u00c2\u00aa\u00ab\u00d4\u0019\u00ea\u00ce\u00b2\u0093\u00f3\t\u00e0'\u00ad\u0018\u0088T@-\u00f1\u0010\u0015\u009a\u00f2y\u009d6\u00885\u00e2'0\u0094\u00eb}7\n?\u00e9\u00cc\u0081v\u00a9\u00ec}\u00fbP\u009d\u00ae\u00c5\u0081\u00f4\u00e8\u009d\u00caT\u00b3\u00ac\u0005\r.Q'\u001d|\u00a8y\u009b\u0007\u008f\u0015\u00a4\u0006{5+\u007f\u0011je\b\u008e\u00cfXb\u00d6\u0002\u00ce`X\u00cc#.\u00d8\u0090\u00e4\u00edJdk\u00a7\bN\u00c9h\u00c3&\u00fc\u0000\u00d7\f\u00a8n\u00a4,\u00a2c~#\u0015\u00ad\u009c\u00c1F\u00c2\u00d1\u00e9\u00db\u000b\u009dK\u00fc\u00b3ZB\u00fb\u008a;\u0096B\u00f9\u00c8\u00d5\u0090\u00db\u00d8\u00f6\u00d9\n'*\u00e4\f;\u0093\u00a7\u00bb\u0017\u0011,\r\u008c\u00d3!lvC\u0017x\u00ee\u00c0}\u00b1CpC!\u00d6\u0085}z$&\u00ee.\u0096\u00b2\u00b7\u0019\u00fd\u0010i\"\u00e0\u001f\u00df\u00e3O\u0093}Yb!\u00c2\u0017\u00b9o\u00dcJu\u00c2\u00c72\u0012ot\u00a7\u00ac\u00c9\u00066B\u00b5\u0094\u009f\u0082\u000b\u0013L\u00d3hL\u00eb\u00a32\u00ae\u0083\u00e1\u0015\u00ee\u008bl\u0093\u00bc\u00fcQ\u00ad\u00ce\u0090%T\u00f1\u0081\u00cd\u00ed+CR8J)\u00e5\u00f0\b\u00f1\u0095\u0015\u007f\u00a8a&\u00cdIV\u0084\u00ba\u001ea!\u001d\u00aaegH\u00c9\u00f5\u007f\u00eb\u00e4\u008eAC\u00d6_\u009c\u00eb\u00d0L\u000ep\u00d8\u00bb\u0007M\u00d8\u0017\u00eeR\u00ab\u001c\u00075\u00ac|\f\u00d8\u0018[(\u000e\u00949\\\u0003\u00ca[t\u0095jy\u00f6\u00e3\u00f2NS\u00f8%\u0080i\u00b7!}\u00ca\u00c3\u00a3\u009b\u0004\u00b7=\u00bf@;%\u00f9J\u00b4 \u00fc\u00ee\u000f\u00b2\u00a9\u00e0\u00d2\u00d0w\u0084\u0000\u001bi\t\u00c7M\u0080\u0005\"#L\u00d0f\u008e\u00e7\u001c\u00f6\r\u00ed@0\u00e4\u00a7\u0088\u00b4\u00cc]\"gh\u00deI\u00aeF\u00c7P-\u00ddJ\u008b\u00b0h\u00a3\u000e\u0099X\u0085\u00ec|\u00b0\u0011\u00f8\u00a9v_$\u008b\u00f6\u001b}]\u001eI\u00f4\u00b1\u0095\u0084n~*$u\u00c0\u009cN\u00e6\u00a8\u00daEL\u00ae\u00be\u0006\u00f3\u00bf\u00b3\nJ<<b\u00a40L\u009e\u00fe_\u0018|\u00cd>V\u00f1\u00ee\u00141@\u0001-T,\u009dK\u00c4k\u00f8\u00bc6\u00f8\u008bs\u00f1)oEYG\u00bf\u00c3:r\u00c9}\u00d8\"\u00f0\u00e0\u00f1\u00e9v\u00aa \u001e\u00f8\u00e1\u00b2\u0015\u00dfv3)\u00c6\u00a4\u00f1\u00fb,\u00e7P+\u00e5UE\u00b3\u001d\t\u00fd\u00ad\u000eW\u00f6r\u00d9\u00b2\u007f";
                var4_3 = "#7\u00c5m\u00c1\u000f\u00faK\u0014J\u0000\u00d0l\u009d\u00a7\u00deD8\u00d2\u00a2 \u0095a\u00a7\u00f0\u00aed\u00be\u0006\u0006\u00c7\u00fbY\u00f48}\u0018\u0095\u0001K|l`\u00e2|w\u00a8D\u001f/y\u00a2q\u00a7=\u00b1\u00b0g\u00f3\u0015%\t3\u00fc\u0001rN>\u00be\u00ff\u00c0\u0005\u00a2r\u00f5\u00c5\u00b7\bGoI\u0017\u0002f\u0084\u0084\u0014\u001a\u008b\u00a2\u0086\u00be\u00f2\u008fy|\u00a8\u0081\u00db\u00bb\u00bd\u00d9\u0086sy\u00fc\u00e7\u0005\u0013\u00de\u00c3Pq\u001e)\u001b\u0091\u008c\u00a6\u00ba\u0019]\u00ad\u0098T\u009eai\u00c9\u0017+`\u00f2\u00ef\u00a37\u0081p\u00c2\u00d1\u00cd\u0085xh\u0010\u0081\u00a5`\u009e\u00cf\u00ca\u00c2\u00aa\u00ab\u00d4\u0019\u00ea\u00ce\u00b2\u0093\u00f3\t\u00e0'\u00ad\u0018\u0088T@-\u00f1\u0010\u0015\u009a\u00f2y\u009d6\u00885\u00e2'0\u0094\u00eb}7\n?\u00e9\u00cc\u0081v\u00a9\u00ec}\u00fbP\u009d\u00ae\u00c5\u0081\u00f4\u00e8\u009d\u00caT\u00b3\u00ac\u0005\r.Q'\u001d|\u00a8y\u009b\u0007\u008f\u0015\u00a4\u0006{5+\u007f\u0011je\b\u008e\u00cfXb\u00d6\u0002\u00ce`X\u00cc#.\u00d8\u0090\u00e4\u00edJdk\u00a7\bN\u00c9h\u00c3&\u00fc\u0000\u00d7\f\u00a8n\u00a4,\u00a2c~#\u0015\u00ad\u009c\u00c1F\u00c2\u00d1\u00e9\u00db\u000b\u009dK\u00fc\u00b3ZB\u00fb\u008a;\u0096B\u00f9\u00c8\u00d5\u0090\u00db\u00d8\u00f6\u00d9\n'*\u00e4\f;\u0093\u00a7\u00bb\u0017\u0011,\r\u008c\u00d3!lvC\u0017x\u00ee\u00c0}\u00b1CpC!\u00d6\u0085}z$&\u00ee.\u0096\u00b2\u00b7\u0019\u00fd\u0010i\"\u00e0\u001f\u00df\u00e3O\u0093}Yb!\u00c2\u0017\u00b9o\u00dcJu\u00c2\u00c72\u0012ot\u00a7\u00ac\u00c9\u00066B\u00b5\u0094\u009f\u0082\u000b\u0013L\u00d3hL\u00eb\u00a32\u00ae\u0083\u00e1\u0015\u00ee\u008bl\u0093\u00bc\u00fcQ\u00ad\u00ce\u0090%T\u00f1\u0081\u00cd\u00ed+CR8J)\u00e5\u00f0\b\u00f1\u0095\u0015\u007f\u00a8a&\u00cdIV\u0084\u00ba\u001ea!\u001d\u00aaegH\u00c9\u00f5\u007f\u00eb\u00e4\u008eAC\u00d6_\u009c\u00eb\u00d0L\u000ep\u00d8\u00bb\u0007M\u00d8\u0017\u00eeR\u00ab\u001c\u00075\u00ac|\f\u00d8\u0018[(\u000e\u00949\\\u0003\u00ca[t\u0095jy\u00f6\u00e3\u00f2NS\u00f8%\u0080i\u00b7!}\u00ca\u00c3\u00a3\u009b\u0004\u00b7=\u00bf@;%\u00f9J\u00b4 \u00fc\u00ee\u000f\u00b2\u00a9\u00e0\u00d2\u00d0w\u0084\u0000\u001bi\t\u00c7M\u0080\u0005\"#L\u00d0f\u008e\u00e7\u001c\u00f6\r\u00ed@0\u00e4\u00a7\u0088\u00b4\u00cc]\"gh\u00deI\u00aeF\u00c7P-\u00ddJ\u008b\u00b0h\u00a3\u000e\u0099X\u0085\u00ec|\u00b0\u0011\u00f8\u00a9v_$\u008b\u00f6\u001b}]\u001eI\u00f4\u00b1\u0095\u0084n~*$u\u00c0\u009cN\u00e6\u00a8\u00daEL\u00ae\u00be\u0006\u00f3\u00bf\u00b3\nJ<<b\u00a40L\u009e\u00fe_\u0018|\u00cd>V\u00f1\u00ee\u00141@\u0001-T,\u009dK\u00c4k\u00f8\u00bc6\u00f8\u008bs\u00f1)oEYG\u00bf\u00c3:r\u00c9}\u00d8\"\u00f0\u00e0\u00f1\u00e9v\u00aa \u001e\u00f8\u00e1\u00b2\u0015\u00dfv3)\u00c6\u00a4\u00f1\u00fb,\u00e7P+\u00e5UE\u00b3\u001d\t\u00fd\u00ad\u000eW\u00f6r\u00d9\u00b2\u007f".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 45;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00d7\u00b4\u00034\u00b9\u00e0\u00b7[5\u0015\nb\u00e7\u00a5^\f\u00ceW*h\u00a1]'\u0011\u008b\u00a7e\u001b\u00d1\u0014\u00e5\u00fah~\u00c7\u00a8\u00d8\u00e8\u00b5\n^vG\u00e6\u00b0M\u0001\u009e\u0006\u0014";
                    var4_3 = "\u00d7\u00b4\u00034\u00b9\u00e0\u00b7[5\u0015\nb\u00e7\u00a5^\f\u00ceW*h\u00a1]'\u0011\u008b\u00a7e\u001b\u00d1\u0014\u00e5\u00fah~\u00c7\u00a8\u00d8\u00e8\u00b5\n^vG\u00e6\u00b0M\u0001\u009e\u0006\u0014".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 76;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 74;
                            break;
                        }
                        case 1: {
                            v15 = 43;
                            break;
                        }
                        case 2: {
                            v15 = 110;
                            break;
                        }
                        case 3: {
                            v15 = 71;
                            break;
                        }
                        case 4: {
                            v15 = 18;
                            break;
                        }
                        case 5: {
                            v15 = 106;
                            break;
                        }
                        default: {
                            v15 = 38;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x1A65) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 195;
                case 1 -> 41;
                case 2 -> 205;
                case 3 -> 238;
                case 4 -> 77;
                case 5 -> 50;
                case 6 -> 253;
                case 7 -> 25;
                case 8 -> 146;
                case 9 -> 204;
                case 10 -> 230;
                case 11 -> 187;
                case 12 -> 228;
                case 13 -> 104;
                case 14 -> 5;
                case 15 -> 153;
                case 16 -> 29;
                case 17 -> 103;
                case 18 -> 191;
                case 19 -> 133;
                case 20 -> 170;
                case 21 -> 196;
                case 22 -> 2;
                case 23 -> 39;
                case 24 -> 95;
                case 25 -> 111;
                case 26 -> 245;
                case 27 -> 18;
                case 28 -> 90;
                case 29 -> 158;
                case 30 -> 137;
                case 31 -> 92;
                case 32 -> 215;
                case 33 -> 165;
                case 34 -> 10;
                case 35 -> 28;
                case 36 -> 108;
                case 37 -> 247;
                case 38 -> 30;
                case 39 -> 214;
                case 40 -> 49;
                case 41 -> 189;
                case 42 -> 56;
                case 43 -> 58;
                case 44 -> 118;
                case 45 -> 74;
                case 46 -> 70;
                case 47 -> 46;
                case 48 -> 51;
                case 49 -> 91;
                case 50 -> 185;
                case 51 -> 124;
                case 52 -> 8;
                case 53 -> 68;
                case 54 -> 61;
                case 55 -> 222;
                case 56 -> 166;
                case 57 -> 197;
                case 58 -> 52;
                case 59 -> 26;
                case 60 -> 110;
                case 61 -> 6;
                case 62 -> 143;
                case 63 -> 184;
                case 64 -> 177;
                case 65 -> 254;
                case 66 -> 102;
                case 67 -> 226;
                case 68 -> 106;
                case 69 -> 105;
                case 70 -> 87;
                case 71 -> 134;
                case 72 -> 147;
                case 73 -> 130;
                case 74 -> 100;
                case 75 -> 84;
                case 76 -> 248;
                case 77 -> 233;
                case 78 -> 252;
                case 79 -> 203;
                case 80 -> 114;
                case 81 -> 80;
                case 82 -> 174;
                case 83 -> 99;
                case 84 -> 19;
                case 85 -> 88;
                case 86 -> 72;
                case 87 -> 115;
                case 88 -> 96;
                case 89 -> 135;
                case 90 -> 38;
                case 91 -> 216;
                case 92 -> 181;
                case 93 -> 117;
                case 94 -> 89;
                case 95 -> 131;
                case 96 -> 142;
                case 97 -> 235;
                case 98 -> 83;
                case 99 -> 76;
                case 100 -> 93;
                case 101 -> 183;
                case 102 -> 201;
                case 103 -> 154;
                case 104 -> 85;
                case 105 -> 250;
                case 106 -> 94;
                case 107 -> 121;
                case 108 -> 188;
                case 109 -> 69;
                case 110 -> 152;
                case 111 -> 217;
                case 112 -> 240;
                case 113 -> 65;
                case 114 -> 33;
                case 115 -> 242;
                case 116 -> 255;
                case 117 -> 42;
                case 118 -> 63;
                case 119 -> 17;
                case 120 -> 178;
                case 121 -> 3;
                case 122 -> 219;
                case 123 -> 0;
                case 124 -> 75;
                case 125 -> 202;
                case 126 -> 190;
                case 127 -> 27;
                case 128 -> 220;
                case 129 -> 98;
                case 130 -> 175;
                case 131 -> 168;
                case 132 -> 43;
                case 133 -> 231;
                case 134 -> 144;
                case 135 -> 21;
                case 136 -> 234;
                case 137 -> 239;
                case 138 -> 243;
                case 139 -> 192;
                case 140 -> 101;
                case 141 -> 148;
                case 142 -> 97;
                case 143 -> 159;
                case 144 -> 34;
                case 145 -> 180;
                case 146 -> 112;
                case 147 -> 67;
                case 148 -> 54;
                case 149 -> 145;
                case 150 -> 162;
                case 151 -> 129;
                case 152 -> 64;
                case 153 -> 82;
                case 154 -> 221;
                case 155 -> 173;
                case 156 -> 22;
                case 157 -> 225;
                case 158 -> 23;
                case 159 -> 36;
                case 160 -> 251;
                case 161 -> 176;
                case 162 -> 241;
                case 163 -> 206;
                case 164 -> 48;
                case 165 -> 172;
                case 166 -> 164;
                case 167 -> 62;
                case 168 -> 44;
                case 169 -> 207;
                case 170 -> 109;
                case 171 -> 194;
                case 172 -> 60;
                case 173 -> 150;
                case 174 -> 163;
                case 175 -> 32;
                case 176 -> 14;
                case 177 -> 157;
                case 178 -> 200;
                case 179 -> 232;
                case 180 -> 179;
                case 181 -> 212;
                case 182 -> 223;
                case 183 -> 208;
                case 184 -> 40;
                case 185 -> 224;
                case 186 -> 169;
                case 187 -> 236;
                case 188 -> 155;
                case 189 -> 186;
                case 190 -> 37;
                case 191 -> 167;
                case 192 -> 199;
                case 193 -> 123;
                case 194 -> 151;
                case 195 -> 160;
                case 196 -> 198;
                case 197 -> 249;
                case 198 -> 12;
                case 199 -> 139;
                case 200 -> 246;
                case 201 -> 218;
                case 202 -> 57;
                case 203 -> 15;
                case 204 -> 210;
                case 205 -> 125;
                case 206 -> 229;
                case 207 -> 120;
                case 208 -> 73;
                case 209 -> 128;
                case 210 -> 86;
                case 211 -> 107;
                case 212 -> 16;
                case 213 -> 81;
                case 214 -> 209;
                case 215 -> 171;
                case 216 -> 193;
                case 217 -> 55;
                case 218 -> 7;
                case 219 -> 66;
                case 220 -> 79;
                case 221 -> 140;
                case 222 -> 132;
                case 223 -> 116;
                case 224 -> 53;
                case 225 -> 71;
                case 226 -> 141;
                case 227 -> 4;
                case 228 -> 113;
                case 229 -> 138;
                case 230 -> 78;
                case 231 -> 161;
                case 232 -> 13;
                case 233 -> 1;
                case 234 -> 47;
                case 235 -> 24;
                case 236 -> 127;
                case 237 -> 149;
                case 238 -> 211;
                case 239 -> 136;
                case 240 -> 126;
                case 241 -> 9;
                case 242 -> 35;
                case 243 -> 20;
                case 244 -> 59;
                case 245 -> 119;
                case 246 -> 213;
                case 247 -> 237;
                case 248 -> 156;
                case 249 -> 11;
                case 250 -> 227;
                case 251 -> 31;
                case 252 -> 244;
                case 253 -> 45;
                case 254 -> 122;
                default -> 182;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 35041915838045L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(722326770 - 1149, -722326770 - -16175, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 38508950480995L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.l();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-273674160 + -27142, -273674160 + -16491, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-273674160 + -27143, -273674160 + -23770, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-273674160 + -27144, -273674160 + -7404, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00da\u00a4\u0016\u00be\u00d1-\u001a\u00f5\u0010\u00ca\u00ba\u00e5\u00dc\u0015\u00da{R^'\u0006\u00feu\u00d2\u001e=";
                    var4_3 = "\u00da\u00a4\u0016\u00be\u00d1-\u001a\u00f5\u0010\u00ca\u00ba\u00e5\u00dc\u0015\u00da{R^'\u0006\u00feu\u00d2\u001e=".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 117;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0091Q\u0004{\u00985\u0007b\u00c1q\u00f2-\u00e4|\u00a1\"\u0010\u00e5; \u00a9\u0092k\u00a6\u0001@\u00d6\u0094A\u00a1q\u00bd\u008a\u000f\u00b6\u00e6\u00b8\u00bd\u000f}\u00d8\u0080\u0092\u00e9\u00153\u00b4\u0097\u00c5\u0081\u00b4\u0088\u00ee}\u00be\u00cc]\u00aa\u00f4";
                        var4_3 = "\u0091Q\u0004{\u00985\u0007b\u00c1q\u00f2-\u00e4|\u00a1\"\u0010\u00e5; \u00a9\u0092k\u00a6\u0001@\u00d6\u0094A\u00a1q\u00bd\u008a\u000f\u00b6\u00e6\u00b8\u00bd\u000f}\u00d8\u0080\u0092\u00e9\u00153\u00b4\u0097\u00c5\u0081\u00b4\u0088\u00ee}\u00be\u00cc]\u00aa\u00f4".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 36;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 102;
                                break;
                            }
                            case 1: {
                                v15 = 117;
                                break;
                            }
                            case 2: {
                                v15 = 84;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 108;
                                break;
                            }
                            case 5: {
                                v15 = 70;
                                break;
                            }
                            default: {
                                v15 = 88;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCE28) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 182;
                    case 1 -> 222;
                    case 2 -> 140;
                    case 3 -> 87;
                    case 4 -> 146;
                    case 5 -> 54;
                    case 6 -> 103;
                    case 7 -> 253;
                    case 8 -> 68;
                    case 9 -> 10;
                    case 10 -> 0;
                    case 11 -> 190;
                    case 12 -> 216;
                    case 13 -> 109;
                    case 14 -> 245;
                    case 15 -> 128;
                    case 16 -> 177;
                    case 17 -> 75;
                    case 18 -> 15;
                    case 19 -> 74;
                    case 20 -> 13;
                    case 21 -> 26;
                    case 22 -> 171;
                    case 23 -> 77;
                    case 24 -> 148;
                    case 25 -> 137;
                    case 26 -> 143;
                    case 27 -> 116;
                    case 28 -> 62;
                    case 29 -> 113;
                    case 30 -> 188;
                    case 31 -> 22;
                    case 32 -> 108;
                    case 33 -> 183;
                    case 34 -> 102;
                    case 35 -> 122;
                    case 36 -> 172;
                    case 37 -> 152;
                    case 38 -> 121;
                    case 39 -> 78;
                    case 40 -> 2;
                    case 41 -> 92;
                    case 42 -> 215;
                    case 43 -> 230;
                    case 44 -> 39;
                    case 45 -> 153;
                    case 46 -> 101;
                    case 47 -> 229;
                    case 48 -> 244;
                    case 49 -> 126;
                    case 50 -> 159;
                    case 51 -> 8;
                    case 52 -> 89;
                    case 53 -> 18;
                    case 54 -> 61;
                    case 55 -> 95;
                    case 56 -> 196;
                    case 57 -> 139;
                    case 58 -> 56;
                    case 59 -> 53;
                    case 60 -> 33;
                    case 61 -> 133;
                    case 62 -> 117;
                    case 63 -> 49;
                    case 64 -> 192;
                    case 65 -> 191;
                    case 66 -> 246;
                    case 67 -> 106;
                    case 68 -> 120;
                    case 69 -> 136;
                    case 70 -> 236;
                    case 71 -> 218;
                    case 72 -> 21;
                    case 73 -> 238;
                    case 74 -> 6;
                    case 75 -> 144;
                    case 76 -> 81;
                    case 77 -> 107;
                    case 78 -> 185;
                    case 79 -> 187;
                    case 80 -> 233;
                    case 81 -> 110;
                    case 82 -> 118;
                    case 83 -> 72;
                    case 84 -> 34;
                    case 85 -> 84;
                    case 86 -> 205;
                    case 87 -> 220;
                    case 88 -> 186;
                    case 89 -> 206;
                    case 90 -> 28;
                    case 91 -> 178;
                    case 92 -> 135;
                    case 93 -> 124;
                    case 94 -> 228;
                    case 95 -> 208;
                    case 96 -> 38;
                    case 97 -> 203;
                    case 98 -> 141;
                    case 99 -> 29;
                    case 100 -> 36;
                    case 101 -> 175;
                    case 102 -> 51;
                    case 103 -> 169;
                    case 104 -> 97;
                    case 105 -> 179;
                    case 106 -> 44;
                    case 107 -> 199;
                    case 108 -> 96;
                    case 109 -> 47;
                    case 110 -> 42;
                    case 111 -> 202;
                    case 112 -> 138;
                    case 113 -> 123;
                    case 114 -> 88;
                    case 115 -> 150;
                    case 116 -> 82;
                    case 117 -> 132;
                    case 118 -> 100;
                    case 119 -> 162;
                    case 120 -> 127;
                    case 121 -> 65;
                    case 122 -> 156;
                    case 123 -> 155;
                    case 124 -> 154;
                    case 125 -> 168;
                    case 126 -> 71;
                    case 127 -> 119;
                    case 128 -> 60;
                    case 129 -> 210;
                    case 130 -> 17;
                    case 131 -> 223;
                    case 132 -> 130;
                    case 133 -> 149;
                    case 134 -> 4;
                    case 135 -> 239;
                    case 136 -> 193;
                    case 137 -> 158;
                    case 138 -> 176;
                    case 139 -> 58;
                    case 140 -> 252;
                    case 141 -> 145;
                    case 142 -> 251;
                    case 143 -> 57;
                    case 144 -> 27;
                    case 145 -> 157;
                    case 146 -> 195;
                    case 147 -> 16;
                    case 148 -> 79;
                    case 149 -> 23;
                    case 150 -> 173;
                    case 151 -> 255;
                    case 152 -> 20;
                    case 153 -> 86;
                    case 154 -> 80;
                    case 155 -> 85;
                    case 156 -> 98;
                    case 157 -> 225;
                    case 158 -> 111;
                    case 159 -> 184;
                    case 160 -> 94;
                    case 161 -> 24;
                    case 162 -> 243;
                    case 163 -> 226;
                    case 164 -> 147;
                    case 165 -> 250;
                    case 166 -> 32;
                    case 167 -> 83;
                    case 168 -> 3;
                    case 169 -> 249;
                    case 170 -> 104;
                    case 171 -> 198;
                    case 172 -> 217;
                    case 173 -> 235;
                    case 174 -> 19;
                    case 175 -> 93;
                    case 176 -> 212;
                    case 177 -> 30;
                    case 178 -> 112;
                    case 179 -> 76;
                    case 180 -> 204;
                    case 181 -> 214;
                    case 182 -> 12;
                    case 183 -> 45;
                    case 184 -> 174;
                    case 185 -> 160;
                    case 186 -> 90;
                    case 187 -> 11;
                    case 188 -> 201;
                    case 189 -> 91;
                    case 190 -> 213;
                    case 191 -> 131;
                    case 192 -> 25;
                    case 193 -> 9;
                    case 194 -> 115;
                    case 195 -> 197;
                    case 196 -> 232;
                    case 197 -> 66;
                    case 198 -> 221;
                    case 199 -> 181;
                    case 200 -> 59;
                    case 201 -> 167;
                    case 202 -> 7;
                    case 203 -> 63;
                    case 204 -> 67;
                    case 205 -> 189;
                    case 206 -> 73;
                    case 207 -> 31;
                    case 208 -> 227;
                    case 209 -> 247;
                    case 210 -> 37;
                    case 211 -> 114;
                    case 212 -> 194;
                    case 213 -> 165;
                    case 214 -> 180;
                    case 215 -> 166;
                    case 216 -> 224;
                    case 217 -> 200;
                    case 218 -> 55;
                    case 219 -> 242;
                    case 220 -> 211;
                    case 221 -> 254;
                    case 222 -> 48;
                    case 223 -> 142;
                    case 224 -> 234;
                    case 225 -> 35;
                    case 226 -> 46;
                    case 227 -> 161;
                    case 228 -> 70;
                    case 229 -> 69;
                    case 230 -> 99;
                    case 231 -> 170;
                    case 232 -> 14;
                    case 233 -> 237;
                    case 234 -> 5;
                    case 235 -> 129;
                    case 236 -> 1;
                    case 237 -> 43;
                    case 238 -> 209;
                    case 239 -> 219;
                    case 240 -> 64;
                    case 241 -> 105;
                    case 242 -> 40;
                    case 243 -> 248;
                    case 244 -> 134;
                    case 245 -> 125;
                    case 246 -> 151;
                    case 247 -> 207;
                    case 248 -> 241;
                    case 249 -> 240;
                    case 250 -> 41;
                    case 251 -> 50;
                    case 252 -> 52;
                    case 253 -> 231;
                    case 254 -> 163;
                    default -> 164;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 53028960059994L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "<(\u0016.Ax-e\t;\"\u0005$\f:0yd";
                    var5_4 = "<(\u0016.Ax-e\t;\"\u0005$\f:0yd".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 118;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 33;
                                    break;
                                }
                                case 1: {
                                    v11 = 59;
                                    break;
                                }
                                case 2: {
                                    v11 = 18;
                                    break;
                                }
                                case 3: {
                                    v11 = 54;
                                    break;
                                }
                                case 4: {
                                    v11 = 82;
                                    break;
                                }
                                case 5: {
                                    v11 = 98;
                                    break;
                                }
                                default: {
                                    v11 = 104;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 19270444089567L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "'^\u001b2\u0001E\u0019\u0004!@\u0017(\n-_\u001c(\rG\u0001\u0007^\u0015\t-_\u001c(\rG\u0001\u000bT\r*Y\u0001%\u0007J\u001b\u000bS\u0006/\u0006C";
                    var5_4 = "'^\u001b2\u0001E\u0019\u0004!@\u0017(\n-_\u001c(\rG\u0001\u0007^\u0015\t-_\u001c(\rG\u0001\u000bT\r*Y\u0001%\u0007J\u001b\u000bS\u0006/\u0006C".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 123;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0014e$\f8s+\u0006\u0014e$\f4y";
                        var5_4 = "\u0014e$\f8s+\u0006\u0014e$\f4y".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 66;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 21;
                                break;
                            }
                            case 1: {
                                v15 = 75;
                                break;
                            }
                            case 2: {
                                v15 = 9;
                                break;
                            }
                            case 3: {
                                v15 = 61;
                                break;
                            }
                            case 4: {
                                v15 = 19;
                                break;
                            }
                            case 5: {
                                v15 = 95;
                                break;
                            }
                            default: {
                                v15 = 14;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 24734858739087L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-142079880 + -30, -142079880 - -20060, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 38860302437026L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00ea\u00ddD&c\u0003\u00f8\u00c1\u00b2\u0005\u00f5\u00cd\u0081\u00e08\r\u00eb\u00c9t*s\u009a\f\u00e1\u008f\u00a7\u00ac\u00c8\u00cd\u0010\u00ee\u001a\u0013\u00bb\u00a0=](l\u001a32\u00d8\u00db-\u00ea\u0005\u001a\u00f0|G\u00873-\u0004\u008b\u00aef\u00db\u00b5\u00e0\f\u00fe\u00b4\u0087\u00ee<\u00c7\t\u009f\u00c6\u00f8<\u00a5\u00e0\u00c4\u00ae\u0002\u00d3}\u007f\u000b\u00d19\u000e\u00ee\u00dd\u00ef\u0002\u0003\u00f2\u009fJ\b\t\u00be\u00ed\u00a3\u007fr\u00d9O\u0095\u001e";
                    var4_3 = "\u00ea\u00ddD&c\u0003\u00f8\u00c1\u00b2\u0005\u00f5\u00cd\u0081\u00e08\r\u00eb\u00c9t*s\u009a\f\u00e1\u008f\u00a7\u00ac\u00c8\u00cd\u0010\u00ee\u001a\u0013\u00bb\u00a0=](l\u001a32\u00d8\u00db-\u00ea\u0005\u001a\u00f0|G\u00873-\u0004\u008b\u00aef\u00db\u00b5\u00e0\f\u00fe\u00b4\u0087\u00ee<\u00c7\t\u009f\u00c6\u00f8<\u00a5\u00e0\u00c4\u00ae\u0002\u00d3}\u007f\u000b\u00d19\u000e\u00ee\u00dd\u00ef\u0002\u0003\u00f2\u009fJ\b\t\u00be\u00ed\u00a3\u007fr\u00d9O\u0095\u001e".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 90;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "?\u0001\u00f8\t\f\u00ba\u0019\t5\u00ef\u00c9]V\u00e7-\u00bcL\u00cceqO\u0017\u00ba\u0014g\u001d\u00b1`/m'\u00d9\u00dd\u0088\\4H\u0085\u00db;\u00ba\u000fk(\u007f\u008aI7\u00a3\u00eeWO\u009e\u00f4n\u008anM\u00a1\bT\u00b1G*7g\u00ad\"\u00ca\u00a8x\u00df\u00e2\u0007\u0092\u009f\u00be\u00ce\u000f\u00f9\\\u00e0\u00cf\u00d6\u009e\u00d1\u00ea\u0018\u00b4_N\u00c3\u009d";
                        var4_3 = "?\u0001\u00f8\t\f\u00ba\u0019\t5\u00ef\u00c9]V\u00e7-\u00bcL\u00cceqO\u0017\u00ba\u0014g\u001d\u00b1`/m'\u00d9\u00dd\u0088\\4H\u0085\u00db;\u00ba\u000fk(\u007f\u008aI7\u00a3\u00eeWO\u009e\u00f4n\u008anM\u00a1\bT\u00b1G*7g\u00ad\"\u00ca\u00a8x\u00df\u00e2\u0007\u0092\u009f\u00be\u00ce\u000f\u00f9\\\u00e0\u00cf\u00d6\u009e\u00d1\u00ea\u0018\u00b4_N\u00c3\u009d".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 109;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 75;
                                break;
                            }
                            case 1: {
                                v15 = 10;
                                break;
                            }
                            case 2: {
                                v15 = 73;
                                break;
                            }
                            case 3: {
                                v15 = 40;
                                break;
                            }
                            case 4: {
                                v15 = 110;
                                break;
                            }
                            case 5: {
                                v15 = 77;
                                break;
                            }
                            default: {
                                v15 = 66;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF5D5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 2;
                    case 1 -> 1;
                    case 2 -> 95;
                    case 3 -> 212;
                    case 4 -> 177;
                    case 5 -> 240;
                    case 6 -> 74;
                    case 7 -> 206;
                    case 8 -> 42;
                    case 9 -> 98;
                    case 10 -> 230;
                    case 11 -> 105;
                    case 12 -> 144;
                    case 13 -> 68;
                    case 14 -> 207;
                    case 15 -> 151;
                    case 16 -> 163;
                    case 17 -> 134;
                    case 18 -> 117;
                    case 19 -> 189;
                    case 20 -> 141;
                    case 21 -> 146;
                    case 22 -> 238;
                    case 23 -> 183;
                    case 24 -> 113;
                    case 25 -> 246;
                    case 26 -> 115;
                    case 27 -> 92;
                    case 28 -> 220;
                    case 29 -> 173;
                    case 30 -> 112;
                    case 31 -> 76;
                    case 32 -> 129;
                    case 33 -> 219;
                    case 34 -> 14;
                    case 35 -> 138;
                    case 36 -> 21;
                    case 37 -> 210;
                    case 38 -> 28;
                    case 39 -> 96;
                    case 40 -> 91;
                    case 41 -> 61;
                    case 42 -> 53;
                    case 43 -> 37;
                    case 44 -> 148;
                    case 45 -> 158;
                    case 46 -> 133;
                    case 47 -> 24;
                    case 48 -> 52;
                    case 49 -> 63;
                    case 50 -> 191;
                    case 51 -> 17;
                    case 52 -> 235;
                    case 53 -> 4;
                    case 54 -> 192;
                    case 55 -> 213;
                    case 56 -> 22;
                    case 57 -> 250;
                    case 58 -> 200;
                    case 59 -> 233;
                    case 60 -> 41;
                    case 61 -> 69;
                    case 62 -> 65;
                    case 63 -> 131;
                    case 64 -> 101;
                    case 65 -> 211;
                    case 66 -> 55;
                    case 67 -> 108;
                    case 68 -> 50;
                    case 69 -> 94;
                    case 70 -> 170;
                    case 71 -> 196;
                    case 72 -> 121;
                    case 73 -> 135;
                    case 74 -> 78;
                    case 75 -> 125;
                    case 76 -> 122;
                    case 77 -> 184;
                    case 78 -> 64;
                    case 79 -> 195;
                    case 80 -> 48;
                    case 81 -> 180;
                    case 82 -> 123;
                    case 83 -> 23;
                    case 84 -> 167;
                    case 85 -> 137;
                    case 86 -> 30;
                    case 87 -> 39;
                    case 88 -> 38;
                    case 89 -> 87;
                    case 90 -> 176;
                    case 91 -> 236;
                    case 92 -> 81;
                    case 93 -> 54;
                    case 94 -> 164;
                    case 95 -> 153;
                    case 96 -> 7;
                    case 97 -> 71;
                    case 98 -> 247;
                    case 99 -> 143;
                    case 100 -> 252;
                    case 101 -> 32;
                    case 102 -> 5;
                    case 103 -> 198;
                    case 104 -> 197;
                    case 105 -> 12;
                    case 106 -> 35;
                    case 107 -> 215;
                    case 108 -> 104;
                    case 109 -> 3;
                    case 110 -> 119;
                    case 111 -> 13;
                    case 112 -> 51;
                    case 113 -> 254;
                    case 114 -> 171;
                    case 115 -> 142;
                    case 116 -> 157;
                    case 117 -> 116;
                    case 118 -> 156;
                    case 119 -> 31;
                    case 120 -> 161;
                    case 121 -> 15;
                    case 122 -> 10;
                    case 123 -> 140;
                    case 124 -> 103;
                    case 125 -> 145;
                    case 126 -> 237;
                    case 127 -> 114;
                    case 128 -> 73;
                    case 129 -> 149;
                    case 130 -> 208;
                    case 131 -> 126;
                    case 132 -> 152;
                    case 133 -> 8;
                    case 134 -> 248;
                    case 135 -> 46;
                    case 136 -> 203;
                    case 137 -> 25;
                    case 138 -> 181;
                    case 139 -> 109;
                    case 140 -> 6;
                    case 141 -> 178;
                    case 142 -> 209;
                    case 143 -> 124;
                    case 144 -> 36;
                    case 145 -> 239;
                    case 146 -> 88;
                    case 147 -> 40;
                    case 148 -> 60;
                    case 149 -> 90;
                    case 150 -> 241;
                    case 151 -> 107;
                    case 152 -> 72;
                    case 153 -> 44;
                    case 154 -> 160;
                    case 155 -> 9;
                    case 156 -> 136;
                    case 157 -> 229;
                    case 158 -> 45;
                    case 159 -> 89;
                    case 160 -> 147;
                    case 161 -> 244;
                    case 162 -> 227;
                    case 163 -> 224;
                    case 164 -> 20;
                    case 165 -> 128;
                    case 166 -> 66;
                    case 167 -> 70;
                    case 168 -> 0;
                    case 169 -> 155;
                    case 170 -> 232;
                    case 171 -> 11;
                    case 172 -> 154;
                    case 173 -> 84;
                    case 174 -> 93;
                    case 175 -> 67;
                    case 176 -> 34;
                    case 177 -> 150;
                    case 178 -> 166;
                    case 179 -> 194;
                    case 180 -> 80;
                    case 181 -> 132;
                    case 182 -> 221;
                    case 183 -> 62;
                    case 184 -> 255;
                    case 185 -> 29;
                    case 186 -> 86;
                    case 187 -> 56;
                    case 188 -> 27;
                    case 189 -> 18;
                    case 190 -> 201;
                    case 191 -> 19;
                    case 192 -> 165;
                    case 193 -> 190;
                    case 194 -> 79;
                    case 195 -> 214;
                    case 196 -> 120;
                    case 197 -> 179;
                    case 198 -> 16;
                    case 199 -> 99;
                    case 200 -> 85;
                    case 201 -> 217;
                    case 202 -> 245;
                    case 203 -> 185;
                    case 204 -> 249;
                    case 205 -> 130;
                    case 206 -> 225;
                    case 207 -> 159;
                    case 208 -> 111;
                    case 209 -> 26;
                    case 210 -> 106;
                    case 211 -> 100;
                    case 212 -> 251;
                    case 213 -> 97;
                    case 214 -> 202;
                    case 215 -> 172;
                    case 216 -> 231;
                    case 217 -> 43;
                    case 218 -> 228;
                    case 219 -> 33;
                    case 220 -> 49;
                    case 221 -> 186;
                    case 222 -> 175;
                    case 223 -> 223;
                    case 224 -> 222;
                    case 225 -> 82;
                    case 226 -> 243;
                    case 227 -> 110;
                    case 228 -> 83;
                    case 229 -> 127;
                    case 230 -> 102;
                    case 231 -> 234;
                    case 232 -> 205;
                    case 233 -> 47;
                    case 234 -> 57;
                    case 235 -> 188;
                    case 236 -> 77;
                    case 237 -> 218;
                    case 238 -> 168;
                    case 239 -> 187;
                    case 240 -> 162;
                    case 241 -> 204;
                    case 242 -> 242;
                    case 243 -> 118;
                    case 244 -> 182;
                    case 245 -> 58;
                    case 246 -> 226;
                    case 247 -> 169;
                    case 248 -> 59;
                    case 249 -> 216;
                    case 250 -> 174;
                    case 251 -> 193;
                    case 252 -> 199;
                    case 253 -> 75;
                    case 254 -> 253;
                    default -> 139;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 117645631106283L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2113110540 - -((char)-30718), 2113110540 - (char)-7956, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 30274323038066L;
                    int n3 = SshAgentIpcService.l();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-901499460 - -((char)-8014), 901368390 + (char)-9171, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 97659929617821L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\f\u0090\u0082\u00e3\u00f8\u00032\u00c3\u0013";
                var4_3 = "\f\u0090\u0082\u00e3\u00f8\u00032\u00c3\u0013".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 57;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 96;
                                break;
                            }
                            case 1: {
                                v11 = 56;
                                break;
                            }
                            case 2: {
                                v11 = 57;
                                break;
                            }
                            case 3: {
                                v11 = 13;
                                break;
                            }
                            case 4: {
                                v11 = 44;
                                break;
                            }
                            case 5: {
                                v11 = 10;
                                break;
                            }
                            default: {
                                v11 = 127;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x291D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 182;
                    case 1 -> 142;
                    case 2 -> 253;
                    case 3 -> 110;
                    case 4 -> 125;
                    case 5 -> 36;
                    case 6 -> 57;
                    case 7 -> 79;
                    case 8 -> 165;
                    case 9 -> 74;
                    case 10 -> 100;
                    case 11 -> 23;
                    case 12 -> 209;
                    case 13 -> 89;
                    case 14 -> 180;
                    case 15 -> 231;
                    case 16 -> 43;
                    case 17 -> 241;
                    case 18 -> 0;
                    case 19 -> 119;
                    case 20 -> 228;
                    case 21 -> 32;
                    case 22 -> 98;
                    case 23 -> 184;
                    case 24 -> 160;
                    case 25 -> 68;
                    case 26 -> 252;
                    case 27 -> 140;
                    case 28 -> 234;
                    case 29 -> 179;
                    case 30 -> 29;
                    case 31 -> 137;
                    case 32 -> 93;
                    case 33 -> 206;
                    case 34 -> 223;
                    case 35 -> 128;
                    case 36 -> 158;
                    case 37 -> 24;
                    case 38 -> 35;
                    case 39 -> 60;
                    case 40 -> 201;
                    case 41 -> 229;
                    case 42 -> 21;
                    case 43 -> 226;
                    case 44 -> 37;
                    case 45 -> 130;
                    case 46 -> 90;
                    case 47 -> 97;
                    case 48 -> 59;
                    case 49 -> 124;
                    case 50 -> 84;
                    case 51 -> 178;
                    case 52 -> 112;
                    case 53 -> 69;
                    case 54 -> 116;
                    case 55 -> 133;
                    case 56 -> 13;
                    case 57 -> 188;
                    case 58 -> 78;
                    case 59 -> 204;
                    case 60 -> 134;
                    case 61 -> 76;
                    case 62 -> 63;
                    case 63 -> 176;
                    case 64 -> 139;
                    case 65 -> 238;
                    case 66 -> 92;
                    case 67 -> 132;
                    case 68 -> 40;
                    case 69 -> 50;
                    case 70 -> 67;
                    case 71 -> 210;
                    case 72 -> 80;
                    case 73 -> 221;
                    case 74 -> 70;
                    case 75 -> 138;
                    case 76 -> 121;
                    case 77 -> 53;
                    case 78 -> 196;
                    case 79 -> 54;
                    case 80 -> 11;
                    case 81 -> 224;
                    case 82 -> 28;
                    case 83 -> 114;
                    case 84 -> 5;
                    case 85 -> 151;
                    case 86 -> 106;
                    case 87 -> 183;
                    case 88 -> 217;
                    case 89 -> 109;
                    case 90 -> 105;
                    case 91 -> 214;
                    case 92 -> 1;
                    case 93 -> 48;
                    case 94 -> 148;
                    case 95 -> 251;
                    case 96 -> 41;
                    case 97 -> 113;
                    case 98 -> 33;
                    case 99 -> 88;
                    case 100 -> 145;
                    case 101 -> 115;
                    case 102 -> 10;
                    case 103 -> 8;
                    case 104 -> 146;
                    case 105 -> 49;
                    case 106 -> 118;
                    case 107 -> 233;
                    case 108 -> 155;
                    case 109 -> 123;
                    case 110 -> 156;
                    case 111 -> 163;
                    case 112 -> 75;
                    case 113 -> 14;
                    case 114 -> 16;
                    case 115 -> 175;
                    case 116 -> 164;
                    case 117 -> 192;
                    case 118 -> 171;
                    case 119 -> 66;
                    case 120 -> 199;
                    case 121 -> 95;
                    case 122 -> 17;
                    case 123 -> 38;
                    case 124 -> 167;
                    case 125 -> 51;
                    case 126 -> 64;
                    case 127 -> 103;
                    case 128 -> 186;
                    case 129 -> 136;
                    case 130 -> 102;
                    case 131 -> 62;
                    case 132 -> 6;
                    case 133 -> 211;
                    case 134 -> 94;
                    case 135 -> 170;
                    case 136 -> 248;
                    case 137 -> 96;
                    case 138 -> 242;
                    case 139 -> 2;
                    case 140 -> 232;
                    case 141 -> 99;
                    case 142 -> 55;
                    case 143 -> 197;
                    case 144 -> 144;
                    case 145 -> 101;
                    case 146 -> 12;
                    case 147 -> 222;
                    case 148 -> 46;
                    case 149 -> 131;
                    case 150 -> 87;
                    case 151 -> 25;
                    case 152 -> 194;
                    case 153 -> 154;
                    case 154 -> 7;
                    case 155 -> 153;
                    case 156 -> 127;
                    case 157 -> 249;
                    case 158 -> 225;
                    case 159 -> 245;
                    case 160 -> 200;
                    case 161 -> 81;
                    case 162 -> 34;
                    case 163 -> 15;
                    case 164 -> 254;
                    case 165 -> 26;
                    case 166 -> 107;
                    case 167 -> 189;
                    case 168 -> 174;
                    case 169 -> 244;
                    case 170 -> 230;
                    case 171 -> 39;
                    case 172 -> 220;
                    case 173 -> 82;
                    case 174 -> 218;
                    case 175 -> 191;
                    case 176 -> 31;
                    case 177 -> 246;
                    case 178 -> 193;
                    case 179 -> 58;
                    case 180 -> 255;
                    case 181 -> 104;
                    case 182 -> 159;
                    case 183 -> 216;
                    case 184 -> 162;
                    case 185 -> 71;
                    case 186 -> 30;
                    case 187 -> 91;
                    case 188 -> 44;
                    case 189 -> 141;
                    case 190 -> 208;
                    case 191 -> 47;
                    case 192 -> 120;
                    case 193 -> 85;
                    case 194 -> 247;
                    case 195 -> 108;
                    case 196 -> 18;
                    case 197 -> 152;
                    case 198 -> 65;
                    case 199 -> 20;
                    case 200 -> 205;
                    case 201 -> 117;
                    case 202 -> 250;
                    case 203 -> 56;
                    case 204 -> 3;
                    case 205 -> 181;
                    case 206 -> 172;
                    case 207 -> 213;
                    case 208 -> 73;
                    case 209 -> 236;
                    case 210 -> 240;
                    case 211 -> 219;
                    case 212 -> 126;
                    case 213 -> 207;
                    case 214 -> 157;
                    case 215 -> 22;
                    case 216 -> 235;
                    case 217 -> 195;
                    case 218 -> 77;
                    case 219 -> 147;
                    case 220 -> 52;
                    case 221 -> 185;
                    case 222 -> 61;
                    case 223 -> 227;
                    case 224 -> 202;
                    case 225 -> 42;
                    case 226 -> 177;
                    case 227 -> 143;
                    case 228 -> 4;
                    case 229 -> 239;
                    case 230 -> 122;
                    case 231 -> 212;
                    case 232 -> 45;
                    case 233 -> 215;
                    case 234 -> 83;
                    case 235 -> 166;
                    case 236 -> 150;
                    case 237 -> 9;
                    case 238 -> 72;
                    case 239 -> 111;
                    case 240 -> 19;
                    case 241 -> 27;
                    case 242 -> 129;
                    case 243 -> 135;
                    case 244 -> 198;
                    case 245 -> 161;
                    case 246 -> 203;
                    case 247 -> 149;
                    case 248 -> 168;
                    case 249 -> 190;
                    case 250 -> 86;
                    case 251 -> 237;
                    case 252 -> 187;
                    case 253 -> 169;
                    case 254 -> 243;
                    default -> 173;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

