/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.google.common.base.Joiner;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssPropertyDescriptorImplEx;
import com.intellij.psi.css.impl.descriptor.CssPseudoSelectorDescriptorImpl;
import com.intellij.psi.css.impl.util.CssCompatibilityData;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssElementDescriptorBase
implements CssElementDescriptor {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    @NotNull
    private final CssCommonDescriptorData myCommonData;
    private BrowserVersion @Nullable [] myMdnBrowserCompatData;

    protected CssElementDescriptorBase(@NotNull CssCommonDescriptorData commonDescriptorData) {
        if (commonDescriptorData == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(0);
        }
        this.myCommonData = commonDescriptorData;
    }

    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion cssVersion = this.myCommonData.cssVersion;
        if (cssVersion == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(1);
        }
        return cssVersion;
    }

    public CssContextType @NotNull [] getAllowedContextTypes() {
        if (this.myCommonData.allowedInRules == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(2);
        }
        return this.myCommonData.allowedInRules;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.myCommonData.id;
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myCommonData.presentableName;
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    public BrowserVersion @NotNull [] getBrowsers() {
        if (this.myMdnBrowserCompatData != null) {
            if (this.myMdnBrowserCompatData == null) {
                CssElementDescriptorBase.$$$reportNull$$$0(5);
            }
            return this.myMdnBrowserCompatData;
        }
        if (this instanceof CssPropertyDescriptorImplEx) {
            this.myMdnBrowserCompatData = CssCompatibilityData.getBrowserDataForProperty(this.getId());
            if (this.myMdnBrowserCompatData == null) {
                CssElementDescriptorBase.$$$reportNull$$$0(6);
            }
            return this.myMdnBrowserCompatData;
        }
        if (this instanceof CssPseudoSelectorDescriptorImpl) {
            this.myMdnBrowserCompatData = CssCompatibilityData.getBrowserDataForPseudoSelector(this.getId());
            if (this.myMdnBrowserCompatData == null) {
                CssElementDescriptorBase.$$$reportNull$$$0(7);
            }
            return this.myMdnBrowserCompatData;
        }
        if (this.myCommonData.browsers == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(8);
        }
        return this.myCommonData.browsers;
    }

    @Nullable
    public String getSpecificationUrl() {
        return this.myCommonData.specificationUrl;
    }

    @NotNull
    public String getDescription() {
        String string = this.myCommonData.description;
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.element", (Object[])new Object[0]);
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(11);
        }
        if (contextType == CssContextType.ANY || contextType == CssContextType.UNKNOWN) {
            return true;
        }
        for (CssContextType rule : this.myCommonData.allowedInRules) {
            if (rule != contextType && (!contextType.isSubsetOfAny() || rule != CssContextType.ANY && rule != CssContextType.NONAME)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        StringBuilder builder = new StringBuilder();
        DocumentationUtil.formatEntityName((String)this.getElementTypeName(), (String)this.getPresentableName(), (StringBuilder)builder);
        this.fillWithAttributesDescription(builder);
        String description = this.getDescription();
        if (!description.isEmpty()) {
            builder.append("<br/>").append(description);
        }
        return builder.toString();
    }

    protected void fillWithAttributesDescription(@NotNull StringBuilder builder) {
        if (builder == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(12);
        }
        this.fillSpecificationString(builder).append("<br/>");
        builder.append("Allowed in: ").append(COMMA_JOINER.join((Object[])this.myCommonData.allowedInRules)).append("<br/>");
        if (this.getBrowsers().length > 0) {
            builder.append("Supported browsers: ").append(COMMA_JOINER.join((Object[])this.getBrowsers())).append("<br/>");
        }
    }

    private StringBuilder fillSpecificationString(StringBuilder builder) {
        CssElementDescriptor.CssVersion cssVersion = this.getCssVersion();
        if (cssVersion == CssElementDescriptor.CssVersion.UNKNOWN && this.myCommonData.specificationUrl == null) {
            return builder;
        }
        builder.append("Specification: ");
        if (this.myCommonData.specificationUrl != null) {
            String linkName = cssVersion == CssElementDescriptor.CssVersion.UNKNOWN ? "link" : cssVersion.getPresentableName();
            builder.append("<a href=\"").append(this.myCommonData.specificationUrl).append("\">").append(linkName).append("</a>");
        } else {
            builder.append(cssVersion.getPresentableName());
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssElementDescriptorBase)) {
            return false;
        }
        CssElementDescriptorBase base = (CssElementDescriptorBase)o;
        return this.myCommonData.equals(base.myCommonData);
    }

    public int hashCode() {
        return this.myCommonData.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonDescriptorData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedContextTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedInContextType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillWithAttributesDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

