/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.indexedProperty;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.transformations.indexedProperty.ImplKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/indexedProperty/IndexedPropertyAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "<init>", "()V", "checkApplicability", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "intellij.groovy.psi"})
public final class IndexedPropertyAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"groovy.transform.IndexedProperty")) {
            return false;
        }
        PsiAnnotationOwner psiAnnotationOwner = annotation.getOwner();
        GrModifierList grModifierList = psiAnnotationOwner instanceof GrModifierList ? (GrModifierList)psiAnnotationOwner : null;
        if (grModifierList == null) {
            return true;
        }
        GrModifierList modifierList = grModifierList;
        PsiElement psiElement = modifierList.getParent();
        GrVariableDeclaration grVariableDeclaration = psiElement instanceof GrVariableDeclaration ? (GrVariableDeclaration)psiElement : null;
        if (grVariableDeclaration == null) {
            return true;
        }
        GrVariableDeclaration parent = grVariableDeclaration;
        GrVariable[] grVariableArray = parent.getVariables();
        Intrinsics.checkNotNullExpressionValue((Object)grVariableArray, (String)"getVariables(...)");
        Object object = ArraysKt.singleOrNull((Object[])grVariableArray);
        GrField grField = object instanceof GrField ? (GrField)object : null;
        if (grField == null) {
            return true;
        }
        GrField field2 = grField;
        if (!field2.isProperty()) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("indexed.property.is.applicable.to.properties.only", new Object[0])).range((PsiElement)annotation).create();
            return true;
        }
        if (ImplKt.getIndexedComponentType(field2) == null) {
            Object[] objectArray = new Object[]{field2.getType().getPresentableText()};
            String string = GroovyBundle.message("inspection.message.property.not.indexable.type.must.be.array.or.list.but.found.0", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            holder.newAnnotation(HighlightSeverity.ERROR, message).create();
        }
        return true;
    }
}

