/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.BrowserSelectorProxy;
import com.intellij.javascript.debugger.execution.JSLocalFilesMappingPanel;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.CollapsibleRow;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "uri", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "browserSelector", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy;", "useFirstLineBreakpointsCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "localFilesMappingPanel", "Lcom/intellij/javascript/debugger/execution/JSLocalFilesMappingPanel;", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "createMappingsPanel", "Companion", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nJavaScriptDebugSettingsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebugSettingsEditor.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugSettingsEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class JavaScriptDebugSettingsEditor
extends SettingsEditor<JavaScriptDebugConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private TextFieldWithBrowseButton uri;
    private BrowserSelectorProxy browserSelector;
    private JBCheckBox useFirstLineBreakpointsCheckBox;
    private JSLocalFilesMappingPanel localFilesMappingPanel;
    @NotNull
    private static final Condition<WebBrowser> BROWSER_CONDITION = JavaScriptDebugSettingsEditor::BROWSER_CONDITION$lambda$0;

    public JavaScriptDebugSettingsEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    protected void resetEditorFrom(@NotNull JavaScriptDebugConfiguration configuration) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        BrowserSelectorProxy browserSelectorProxy = this.browserSelector;
        if (browserSelectorProxy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browserSelector");
            browserSelectorProxy = null;
        }
        browserSelectorProxy.setSelectedBrowserId(configuration.getEngineId());
        String url = configuration.getUri();
        String text = null;
        if (url == null) {
            text = "";
        } else {
            int index = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
            if (index < 0 || !StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
                text = url;
            } else {
                int offset = index + 3;
                if (SystemInfo.isWindows && url.charAt(offset) == '/') {
                    ++offset;
                }
                String string = url.substring(offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                text = FileUtilRt.toSystemDependentName((String)string);
            }
        }
        if ((textFieldWithBrowseButton = this.uri) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.setText(text);
        JSLocalFilesMappingPanel jSLocalFilesMappingPanel = this.localFilesMappingPanel;
        if (jSLocalFilesMappingPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localFilesMappingPanel");
            jSLocalFilesMappingPanel = null;
        }
        List<RemoteUrlMappingBean> list = configuration.getMappings();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMappings(...)");
        jSLocalFilesMappingPanel.resetEditorFrom(list, true);
        JBCheckBox jBCheckBox = this.useFirstLineBreakpointsCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useFirstLineBreakpointsCheckBox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(configuration.isUseFirstLineBreakpoints());
    }

    protected void applyEditorTo(@NotNull JavaScriptDebugConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        BrowserSelectorProxy browserSelectorProxy = this.browserSelector;
        if (browserSelectorProxy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browserSelector");
            browserSelectorProxy = null;
        }
        configuration.setEngineId(browserSelectorProxy.getSelectedBrowserId());
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.uri;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        String url = StringUtil.isEmpty((String)text) ? null : (URLUtil.containsScheme((String)text) ? text : (!SourceResolver.Companion.isAbsolute(text) ? VirtualFileManager.constructUrl((String)"http", (String)text) : VirtualFileManager.constructUrl((String)"file", (String)PathUtil.toSystemIndependentName((String)OSAgnosticPathUtil.expandUserHome((String)text)))));
        configuration.setUri(url);
        JSLocalFilesMappingPanel jSLocalFilesMappingPanel = this.localFilesMappingPanel;
        if (jSLocalFilesMappingPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localFilesMappingPanel");
            jSLocalFilesMappingPanel = null;
        }
        List<RemoteUrlMappingBean> list = configuration.getMappings();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMappings(...)");
        jSLocalFilesMappingPanel.applyEditorTo(list, (RunConfiguration)configuration);
        JBCheckBox jBCheckBox = this.useFirstLineBreakpointsCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useFirstLineBreakpointsCheckBox");
            jBCheckBox = null;
        }
        configuration.setUseFirstLineBreakpoints(jBCheckBox.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        return (JComponent)BuilderKt.panel(arg_0 -> JavaScriptDebugSettingsEditor.createEditor$lambda$0(this, arg_0));
    }

    private final JSLocalFilesMappingPanel createMappingsPanel() {
        Project project = this.project;
        BorderLayout borderLayout = new BorderLayout();
        return new JSLocalFilesMappingPanel(this, project, borderLayout){
            final /* synthetic */ JavaScriptDebugSettingsEditor this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void initUI() {
                this.add(this.getMappingTreePanel());
                super.initUI();
            }

            protected RemoteUrlMappingBean createMapping(String localPath, String remote) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
                Object remote2 = remote;
                if (!URLUtil.containsScheme((String)remote2)) {
                    remote2 = "http://" + (String)remote2;
                }
                return new RemoteUrlMappingBean(localPath, (String)remote2);
            }

            public String getBaseUrl() {
                TextFieldWithBrowseButton textFieldWithBrowseButton = JavaScriptDebugSettingsEditor.access$getUri$p(this.this$0);
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    textFieldWithBrowseButton = null;
                }
                String string = textFieldWithBrowseButton.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return string;
            }
        };
    }

    private static final Unit createEditor$lambda$0(JavaScriptDebugSettingsEditor this$0, Panel $this$panel) {
        CollapsibleRow collapsibleRow;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = JSDebuggerBundle.message("javascript.debugger.settings.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> JavaScriptDebugSettingsEditor.createEditor$lambda$0$0(this$0, arg_0));
        String string2 = JSDebuggerBundle.message("label.text.browser", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> JavaScriptDebugSettingsEditor.createEditor$lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JavaScriptDebugSettingsEditor.createEditor$lambda$0$2(this$0, arg_0), (int)1, null);
        String string3 = JSDebuggerBundle.message("label.text.remote.urls.of.local.files", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        CollapsibleRow $this$createEditor_u24lambda_u240_u244 = collapsibleRow = Panel.collapsibleGroup$default((Panel)$this$panel, (String)string3, (boolean)false, arg_0 -> JavaScriptDebugSettingsEditor.createEditor$lambda$0$3(this$0, arg_0), (int)2, null);
        boolean bl = false;
        $this$createEditor_u24lambda_u240_u244.setExpanded(true);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$0(JavaScriptDebugSettingsEditor this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$createEditor_u24lambda_u240_u240_u240 = cell = Row.textFieldWithBrowseButton$default((Row)$this$row, (Project)this$0.project, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE);
        boolean bl = false;
        StartBrowserPanel.setupUrlField((TextFieldWithBrowseButton)((TextFieldWithBrowseButton)$this$createEditor_u24lambda_u240_u240_u240.getComponent()), (Project)this$0.project);
        this$0.uri = (TextFieldWithBrowseButton)$this$createEditor_u24lambda_u240_u240_u240.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$1(JavaScriptDebugSettingsEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.browserSelector = BrowserSelectorProxy.Companion.create$default(BrowserSelectorProxy.Companion, this$0.project, null, null, 6, null);
        BrowserSelectorProxy browserSelectorProxy = this$0.browserSelector;
        if (browserSelectorProxy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browserSelector");
            browserSelectorProxy = null;
        }
        $this$row.cell(browserSelectorProxy.getMainComponent()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$2(JavaScriptDebugSettingsEditor this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = JSDebuggerBundle.message("use.first.line.breakpoints.checkbox.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell $this$createEditor_u24lambda_u240_u242_u240 = cell = $this$row.checkBox(string);
        boolean bl = false;
        this$0.useFirstLineBreakpointsCheckBox = (JBCheckBox)$this$createEditor_u24lambda_u240_u242_u240.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$3(JavaScriptDebugSettingsEditor this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        Panel.row$default((Panel)$this$collapsibleGroup, null, arg_0 -> JavaScriptDebugSettingsEditor.createEditor$lambda$0$3$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createEditor$lambda$0$3$0(JavaScriptDebugSettingsEditor this$0, Row $this$row) {
        void $this$createEditor_u24lambda_u240_u243_u240_u240;
        JSLocalFilesMappingPanel jSLocalFilesMappingPanel;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JSLocalFilesMappingPanel jSLocalFilesMappingPanel2 = jSLocalFilesMappingPanel = this$0.createMappingsPanel();
        JavaScriptDebugSettingsEditor javaScriptDebugSettingsEditor = this$0;
        boolean bl = false;
        $this$createEditor_u24lambda_u240_u243_u240_u240.initUI();
        javaScriptDebugSettingsEditor.localFilesMappingPanel = jSLocalFilesMappingPanel;
        JSLocalFilesMappingPanel jSLocalFilesMappingPanel3 = this$0.localFilesMappingPanel;
        if (jSLocalFilesMappingPanel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localFilesMappingPanel");
            jSLocalFilesMappingPanel3 = null;
        }
        $this$row.cell((JComponent)jSLocalFilesMappingPanel3).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final boolean BROWSER_CONDITION$lambda$0(WebBrowser browser) {
        return browser != null && browser.getFamily() == BrowserFamily.CHROME;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getUri$p(JavaScriptDebugSettingsEditor $this) {
        return $this.uri;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugSettingsEditor$Companion;", "", "<init>", "()V", "BROWSER_CONDITION", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/ide/browsers/WebBrowser;", "getBROWSER_CONDITION", "()Lcom/intellij/openapi/util/Condition;", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Condition<WebBrowser> getBROWSER_CONDITION() {
            return BROWSER_CONDITION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

