/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtAnnotationEntryElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinAnnotationEntryStubImpl;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "psi-impl"})
@SourceDebugExtension(value={"SMAP\nKtAnnotationEntryElementType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtAnnotationEntryElementType.kt\norg/jetbrains/kotlin/psi/stubs/elements/KtAnnotationEntryElementType\n+ 2 StubUtils.kt\norg/jetbrains/kotlin/psi/stubs/StubUtils\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n91#2,4:70\n95#2,3:75\n98#2:79\n221#3:74\n222#3:78\n*S KotlinDebug\n*F\n+ 1 KtAnnotationEntryElementType.kt\norg/jetbrains/kotlin/psi/stubs/elements/KtAnnotationEntryElementType\n*L\n42#1:70,4\n42#1:75,3\n42#1:79\n42#1:74\n42#1:78\n*E\n"})
public final class KtAnnotationEntryElementType
extends KtStubElementType<KotlinAnnotationEntryStubImpl, KtAnnotationEntry> {
    @NotNull
    public static final KtAnnotationEntryElementType INSTANCE = new KtAnnotationEntryElementType();

    private KtAnnotationEntryElementType() {
        super("ANNOTATION_ENTRY", KtAnnotationEntry.class, KotlinAnnotationEntryStub.class);
    }

    @NotNull
    public KotlinAnnotationEntryStubImpl createStub(@NotNull KtAnnotationEntry psi, @Nullable StubElement<?> parentStub) {
        Name shortName;
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Name name2 = shortName = psi.getShortName();
        String resultName = name2 != null ? name2.asString() : null;
        KtValueArgumentList valueArgumentList = psi.getValueArgumentList();
        boolean hasValueArguments = valueArgumentList != null && !valueArgumentList.getArguments().isEmpty();
        return new KotlinAnnotationEntryStubImpl(parentStub, StringRef.fromString((String)resultName), hasValueArguments, null);
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(@NotNull KotlinAnnotationEntryStubImpl stub, @NotNull StubOutputStream dataStream) {
        block1: {
            void $this$writeNullableMap$iv;
            void map$iv;
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            dataStream.writeName(stub.getShortName());
            dataStream.writeBoolean(stub.getHasValueArguments());
            StubOutputStream stubOutputStream = dataStream;
            Map<Name, ConstantValue<?>> map = stub.getValueArguments();
            boolean $i$f$writeNullableMap$psi_impl = false;
            void v0 = map$iv;
            int nullableSize$iv = v0 != null ? v0.size() + 1 : 0;
            $this$writeNullableMap$iv.writeVarInt(nullableSize$iv);
            void v1 = map$iv;
            if (v1 == null) break block1;
            void $this$forEach$iv$iv = v1;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                ConstantValue it;
                Map.Entry element$iv$iv;
                Map.Entry entry$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                Name name2 = (Name)entry$iv.getKey();
                void $this$serialize_u24lambda_u240 = $this$writeNullableMap$iv;
                boolean bl2 = false;
                $this$serialize_u24lambda_u240.writeName(((Name)((Object)it)).asString());
                it = (ConstantValue)entry$iv.getValue();
                void $this$serialize_u24lambda_u241 = $this$writeNullableMap$iv;
                boolean bl3 = false;
                KotlinConstantValueKt.serializeConstantValue(it, (StubOutputStream)$this$serialize_u24lambda_u241);
            }
        }
    }

    @NotNull
    public KotlinAnnotationEntryStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef shortNameRef = dataStream.readName();
        boolean hasValueArguments = dataStream.readBoolean();
        Map valueArguments = StubUtils.readNullableMap$psi_impl(dataStream, arg_0 -> KtAnnotationEntryElementType.deserialize$lambda$0(dataStream, arg_0), KtAnnotationEntryElementType::deserialize$lambda$1);
        return new KotlinAnnotationEntryStubImpl(parentStub, shortNameRef, hasValueArguments, valueArguments);
    }

    @Override
    public void indexStub(@NotNull KotlinAnnotationEntryStubImpl stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        StubIndexService.Companion.getInstance().indexAnnotation(stub, sink);
    }

    private static final Name deserialize$lambda$0(StubInputStream $dataStream, StubInputStream $this$readNullableMap) {
        Intrinsics.checkNotNullParameter((Object)$this$readNullableMap, (String)"$this$readNullableMap");
        String string = $dataStream.readNameString();
        Intrinsics.checkNotNull((Object)string);
        return Name.identifier(string);
    }

    private static final ConstantValue deserialize$lambda$1(StubInputStream $this$readNullableMap) {
        Intrinsics.checkNotNullParameter((Object)$this$readNullableMap, (String)"$this$readNullableMap");
        ConstantValue<?> constantValue = KotlinConstantValueKt.deserializeConstantValue($this$readNullableMap);
        Intrinsics.checkNotNull(constantValue);
        return constantValue;
    }
}

