/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.common.actions;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ws.common.FileUtils;
import com.intellij.ws.common.WSUtilsBundle;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class AbstractCreateWebServiceAction
extends CreateElementActionBase {
    public AbstractCreateWebServiceAction() {
    }

    public AbstractCreateWebServiceAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon) {
        if (text == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(1);
        }
        super(text, description, icon);
    }

    protected abstract String getKindName();

    protected String getErrorTitle() {
        return WSUtilsBundle.message("title.cannot.create.filetype", this.getKindName());
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory psiDirectory, @NotNull String s) {
        if (psiDirectory == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(2);
        }
        if (s == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(3);
        }
        String string = WSUtilsBundle.message("progress.creating.filetype.in.directory", this.getKindName(), s, psiDirectory.getName());
        if (string == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected Pair<String, PsiDirectory> getTargetFileDirectoryPair(@NotNull String className, PsiDirectory dir) {
        if (className == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(5);
        }
        if (className.contains(".")) {
            String[] names = className.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                String name = names[i];
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            className = names[names.length - 1];
        }
        Pair pair = Pair.create((Object)className, (Object)dir);
        if (pair == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(6);
        }
        return pair;
    }

    public PsiElement @NotNull [] create(@NotNull String className, @NotNull PsiDirectory dir) throws Exception {
        if (className == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(8);
        }
        Pair<String, PsiDirectory> pair = this.getTargetFileDirectoryPair(className, dir);
        className = (String)pair.first;
        dir = (PsiDirectory)pair.second;
        PsiFile file = dir.createFile(className + ".java");
        String packageQName = JavaDirectoryService.getInstance().getPackage(dir).getQualifiedName();
        String text = this.buildText(packageQName, className, file);
        VirtualFile virtualFile = file.getVirtualFile();
        FileUtils.saveText(virtualFile, text);
        new ReformatCodeProcessor(file, false).run();
        FileEditor[] fileEditors = FileEditorManager.getInstance((Project)dir.getProject()).openFile(virtualFile, true);
        Editor editor = null;
        for (FileEditor fe : fileEditors) {
            if (!(fe instanceof TextEditor)) continue;
            editor = ((TextEditor)fe).getEditor();
            break;
        }
        this.createAdditionalFiles(className, packageQName, dir, editor, virtualFile);
        PsiElement[] psiElementArray = new PsiElement[]{file};
        if (psiElementArray == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    protected void createAdditionalFiles(@NotNull String className, String packageQName, PsiDirectory psiDirectory, Editor editor, VirtualFile vfile) throws Exception {
        if (className == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(10);
        }
    }

    protected abstract String buildText(String var1, String var2, PsiFile var3);

    protected PsiElement @NotNull [] invokeDialog(@NotNull Project project, @NotNull PsiDirectory psiDirectory) {
        if (project == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(11);
        }
        if (psiDirectory == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(12);
        }
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, psiDirectory);
        Messages.showInputDialog((Project)project, (String)WSUtilsBundle.message("prompt.enter.new.0", this.getKindName()), (String)WSUtilsBundle.message("title.new.filetype", this.getKindName()), (Icon)Messages.getQuestionIcon(), (String)this.getDefaultNewName(), (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    @NotNull
    protected String getDefaultNewName() {
        return "";
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(14);
        }
        super.update(e);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
            assert (ideView != null);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory dir : ideView.getDirectories()) {
                if (!fileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                return;
            }
            presentation.setEnabledAndVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/common/actions/AbstractCreateWebServiceAction";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/common/actions/AbstractCreateWebServiceAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFileDirectoryPair";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFileDirectoryPair";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9, 13 -> new IllegalStateException(string);
        };
    }
}

